/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyMap {
    private ListMultiMap<String, ITestNGMethod> m_dependencies = Maps.newListMultiMap();
    private ListMultiMap<String, ITestNGMethod> m_groups = Maps.newListMultiMap();

    public DependencyMap(ITestNGMethod[] methods) {
        for (ITestNGMethod m : methods) {
            this.m_dependencies.put(m.getRealClass().getName() + "." + m.getMethodName(), m);
            for (String g : m.getGroups()) {
                this.m_groups.put(g, m);
            }
        }
    }

    public List<ITestNGMethod> getMethodsThatBelongTo(String group, ITestNGMethod fromMethod) {
        List<String> keys = this.m_groups.getKeys();
        Set<String> uniqueKeys = Sets.newHashSet(keys);
        List<ITestNGMethod> result = Lists.newArrayList();
        for (String k : uniqueKeys) {
            List<ITestNGMethod> temp;
            if (!Pattern.matches(group, k) || (temp = this.m_groups.get(k)) == null) continue;
            result.addAll(this.m_groups.get(k));
        }
        if (result.isEmpty()) {
            throw new TestNGException("DependencyMap::Method \"" + fromMethod + "\" depends on nonexistent group \"" + group + "\"");
        }
        return result;
    }

    public ITestNGMethod getMethodDependingOn(String methodName, ITestNGMethod fromMethod) {
        List<ITestNGMethod> l = this.m_dependencies.get(methodName);
        for (ITestNGMethod m : l) {
            if (fromMethod.getRealClass().isAssignableFrom(m.getRealClass())) {
                if (m.getInstance() != fromMethod.getInstance()) continue;
                return m;
            }
            return m;
        }
        throw new TestNGException("Method \"" + fromMethod + "\" depends on nonexistent method \"" + methodName + "\"");
    }
}

