/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; fill-column: 100 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_SVX_INC_STRINGS_HXX
#define INCLUDED_SVX_INC_STRINGS_HXX

#define RID_GALLERYSTR_THEME_HTMLBUTTONS            "private://gallery/hidden/HtmlExportButtons"
#define RID_GALLERYSTR_THEME_POWERPOINT             "private://gallery/hidden/imgppt"
#define RID_GALLERYSTR_THEME_RULERS                 "Rulers"
#define RID_GALLERYSTR_THEME_USERSOUNDS             "private://gallery/hidden/usersounds"
#define RID_GALLERYSTR_THEME_DUMMY5                 "Dummy 5"
#define RID_GALLERYSTR_THEME_FONTWORK               "private://gallery/hidden/fontwork"
#define RID_GALLERYSTR_THEME_FONTWORK_VERTICAL      "private://gallery/hidden/fontworkvertical"

// Reference-strings for standardcolor-table
#define RID_SVXSTR_COLOR_BLACK_DEF                  "Black"
#define RID_SVXSTR_COLOR_BLUE_DEF                   "Blue"
#define RID_SVXSTR_COLOR_GREEN_DEF                  "Green"
#define RID_SVXSTR_COLOR_RED_DEF                    "Red"
#define RID_SVXSTR_COLOR_GREY_DEF                   "Gray"
#define RID_SVXSTR_COLOR_YELLOW_DEF                 "Yellow"
#define RID_SVXSTR_COLOR_WHITE_DEF                  "White"
#define RID_SVXSTR_COLOR_BLUEGREY_DEF               "Blue gray"
#define RID_SVXSTR_COLOR_ORANGE_DEF                 "Orange"
#define RID_SVXSTR_COLOR_MAGENTA_DEF                "Magenta"
#define RID_SVXSTR_COLOR_BORDEAUX_DEF               "Bordeaux"
#define RID_SVXSTR_COLOR_PALE_YELLOW_DEF            "Pale yellow"
#define RID_SVXSTR_COLOR_PALE_GREEN_DEF             "Pale green"
#define RID_SVXSTR_COLOR_DARKVIOLET_DEF             "Dark violet"
#define RID_SVXSTR_COLOR_SALMON_DEF                 "Salmon"
#define RID_SVXSTR_COLOR_SEABLUE_DEF                "Sea blue"
#define RID_SVXSTR_COLOR_CHART_DEF                  "Chart"
#define RID_SVXSTR_COLOR_PURPLE_DEF                 "Purple"
#define RID_SVXSTR_COLOR_SKYBLUE_DEF                "Sky blue"
#define RID_SVXSTR_COLOR_YELLOWGREEN_DEF            "Yellow green"
#define RID_SVXSTR_COLOR_PINK_DEF                   "Pink"
#define RID_SVXSTR_COLOR_TURQUOISE_DEF              "Turquoise"
#define RID_SVXSTR_COLOR_BLUE_CLASSIC_DEF           "Blue classic"
#define RID_SVXSTR_COLOR_GOLD_DEF                   "Gold"
#define RID_SVXSTR_COLOR_BRICK_DEF                  "Brick"
#define RID_SVXSTR_COLOR_INDIGO_DEF                 "Indigo"
#define RID_SVXSTR_COLOR_TEAL_DEF                   "Teal"
#define RID_SVXSTR_COLOR_LIME_DEF                   "Lime"
// Reference strings: Light variants of the standard color palette
#define RID_SVXSTR_COLOR_LIGHTGRAY_DEF              "Light Gray"
#define RID_SVXSTR_COLOR_LIGHTYELLOW_DEF            "Light Yellow"
#define RID_SVXSTR_COLOR_LIGHTGOLD_DEF              "Light Gold"
#define RID_SVXSTR_COLOR_LIGHTORANGE_DEF            "Light Orange"
#define RID_SVXSTR_COLOR_LIGHTBRICK_DEF             "Light Brick"
#define RID_SVXSTR_COLOR_LIGHTRED_DEF               "Light Red"
#define RID_SVXSTR_COLOR_LIGHTMAGENTA_DEF           "Light Magenta"
#define RID_SVXSTR_COLOR_LIGHTPURPLE_DEF            "Light Purple"
#define RID_SVXSTR_COLOR_LIGHTINDIGO_DEF            "Light Indigo"
#define RID_SVXSTR_COLOR_LIGHTBLUE_DEF              "Light Blue"
#define RID_SVXSTR_COLOR_LIGHTTEAL_DEF              "Light Teal"
#define RID_SVXSTR_COLOR_LIGHTGREEN_DEF             "Light Green"
#define RID_SVXSTR_COLOR_LIGHTLIME_DEF              "Light Lime"
// Reference strings: Dark variants of the standard color palette
#define RID_SVXSTR_COLOR_DARKGRAY_DEF               "Dark Gray"
#define RID_SVXSTR_COLOR_DARKYELLOW_DEF             "Dark Yellow"
#define RID_SVXSTR_COLOR_DARKGOLD_DEF               "Dark Gold"
#define RID_SVXSTR_COLOR_DARKORANGE_DEF             "Dark Orange"
#define RID_SVXSTR_COLOR_DARKBRICK_DEF              "Dark Brick"
#define RID_SVXSTR_COLOR_DARKRED_DEF                "Dark Red"
#define RID_SVXSTR_COLOR_DARKMAGENTA_DEF            "Dark Magenta"
#define RID_SVXSTR_COLOR_DARKPURPLE_DEF             "Dark Purple"
#define RID_SVXSTR_COLOR_DARKINDIGO_DEF             "Dark Indigo"
#define RID_SVXSTR_COLOR_DARKBLUE_DEF               "Dark Blue"
#define RID_SVXSTR_COLOR_DARKTEAL_DEF               "Dark Teal"
#define RID_SVXSTR_COLOR_DARKGREEN_DEF              "Dark Green"
#define RID_SVXSTR_COLOR_DARKLIME_DEF               "Dark Lime"
// Reference strings for the Tonal palette
#define RID_SVXSTR_COLOR_VIOLET_DEF                 "Violet"
#define RID_SVXSTR_COLOR_VIOLET_OUG_DEF             "Violet (Out of Gamut)"
#define RID_SVXSTR_COLOR_BLUE_OUG_DEF               "Blue (Out of Gamut)"
#define RID_SVXSTR_COLOR_AZURE_OUG_DEF              "Azure (Out of Gamut)"
#define RID_SVXSTR_COLOR_SPRINGGREEN_OUG_DEF        "Spring Green (Out of Gamut)"
#define RID_SVXSTR_COLOR_GREEN_OUG_DEF              "Green (Out of Gamut)"
#define RID_SVXSTR_COLOR_CHARTREUSEGREEN_OUG_DEF    "Chartreuse Green (Out of Gamut)"
#define RID_SVXSTR_COLOR_ORANGE_OUG_DEF             "Orange (Out of Gamut)"
#define RID_SVXSTR_COLOR_RED_OUG_DEF                "Red (Out of Gamut)"
#define RID_SVXSTR_COLOR_ROSE_OUG_DEF               "Rose (Out of Gamut)"
#define RID_SVXSTR_COLOR_AZURE_DEF                  "Azure"
#define RID_SVXSTR_COLOR_CYAN_DEF                   "Cyan"
#define RID_SVXSTR_COLOR_SPRINGGREEN_DEF            "Spring Green"
#define RID_SVXSTR_COLOR_CHARTREUSEGREEN_DEF        "Chartreuse Green"
#define RID_SVXSTR_COLOR_ROSE_DEF                   "Rose"
// Reference strings for the Material palette
#define RID_SVXSTR_COLOR_MATERIAL_GRAY_A_DEF        "Gray A"
#define RID_SVXSTR_COLOR_MATERIAL_YELLOW_A_DEF      "Yellow A"
#define RID_SVXSTR_COLOR_MATERIAL_AMBER_A_DEF       "Amber A"
#define RID_SVXSTR_COLOR_MATERIAL_AMBER_DEF         "Amber"
#define RID_SVXSTR_COLOR_MATERIAL_ORANGE_A_DEF      "Orange A"
#define RID_SVXSTR_COLOR_MATERIAL_DEEP_ORANGE_A_DEF "Deep Orange A"
#define RID_SVXSTR_COLOR_MATERIAL_DEEP_ORANGE_DEF   "Deep Orange"
#define RID_SVXSTR_COLOR_MATERIAL_RED_A_DEF         "Red A"
#define RID_SVXSTR_COLOR_MATERIAL_PINK_A_DEF        "Pink A"
#define RID_SVXSTR_COLOR_MATERIAL_PURPLE_A_DEF      "Purple A"
#define RID_SVXSTR_COLOR_MATERIAL_DEEP_PURPLE_A_DEF "Deep Purple A"
#define RID_SVXSTR_COLOR_MATERIAL_DEEP_PURPLE_DEF   "Deep Purple"
#define RID_SVXSTR_COLOR_MATERIAL_INDIGO_A_DEF      "Indigo A"
#define RID_SVXSTR_COLOR_MATERIAL_BLUE_A_DEF        "Blue A"
#define RID_SVXSTR_COLOR_MATERIAL_LIGHT_BLUE_A_DEF  "Light Blue A"
#define RID_SVXSTR_COLOR_MATERIAL_CYAN_A_DEF        "Cyan A"
#define RID_SVXSTR_COLOR_MATERIAL_TEAL_A_DEF        "Teal A"
#define RID_SVXSTR_COLOR_MATERIAL_GREEN_A_DEF       "Green A"
#define RID_SVXSTR_COLOR_MATERIAL_LIGHT_GREEN_A_DEF "Light Green A"
#define RID_SVXSTR_COLOR_MATERIAL_LIME_A_DEF        "Lime A"
#define RID_SVXSTR_COLOR_MATERIAL_BROWN_A_DEF       "Brown A"
#define RID_SVXSTR_COLOR_MATERIAL_BROWN_DEF         "Brown"
#define RID_SVXSTR_COLOR_MATERIAL_BLUE_GRAY_A_DEF   "Blue Gray A"
#define RID_SVXSTR_COLOR_MATERIAL_BLUE_GRAY_DEF     "Blue Gray"
// Reference-strings for standard-gradient-table
#define RID_SVXSTR_GRDT0_DEF                        "Gradient"
#define RID_SVXSTR_GRDT1_DEF                        "Linear blue/white"
#define RID_SVXSTR_GRDT2_DEF                        "Linear magenta/green"
#define RID_SVXSTR_GRDT3_DEF                        "Linear yellow/brown"
#define RID_SVXSTR_GRDT4_DEF                        "Radial green/black"
#define RID_SVXSTR_GRDT5_DEF                        "Radial red/yellow"
#define RID_SVXSTR_GRDT6_DEF                        "Rectangular red/white"
#define RID_SVXSTR_GRDT7_DEF                        "Square yellow/white"
#define RID_SVXSTR_GRDT8_DEF                        "Ellipsoid blue grey/light blue"
#define RID_SVXSTR_GRDT9_DEF                        "Axial light red/white"
#define RID_SVXSTR_GRDT10_DEF                       "Diagonal 1l"
#define RID_SVXSTR_GRDT11_DEF                       "Diagonal 1r"
#define RID_SVXSTR_GRDT12_DEF                       "Diagonal 2l"
#define RID_SVXSTR_GRDT13_DEF                       "Diagonal 2r"
#define RID_SVXSTR_GRDT14_DEF                       "Diagonal 3l"
#define RID_SVXSTR_GRDT15_DEF                       "Diagonal 3r"
#define RID_SVXSTR_GRDT16_DEF                       "Diagonal 4l"
#define RID_SVXSTR_GRDT17_DEF                       "Diagonal 4r"
#define RID_SVXSTR_GRDT18_DEF                       "Diagonal Blue"
#define RID_SVXSTR_GRDT19_DEF                       "Diagonal Green"
#define RID_SVXSTR_GRDT20_DEF                       "Diagonal Orange"
#define RID_SVXSTR_GRDT21_DEF                       "Diagonal Red"
#define RID_SVXSTR_GRDT22_DEF                       "Diagonal Turquoise"
#define RID_SVXSTR_GRDT23_DEF                       "Diagonal Violet"
#define RID_SVXSTR_GRDT24_DEF                       "From a Corner"
#define RID_SVXSTR_GRDT25_DEF                       "From a Corner, Blue"
#define RID_SVXSTR_GRDT26_DEF                       "From a Corner, Green"
#define RID_SVXSTR_GRDT27_DEF                       "From a Corner, Orange"
#define RID_SVXSTR_GRDT28_DEF                       "From a Corner, Red"
#define RID_SVXSTR_GRDT29_DEF                       "From a Corner, Turquoise"
#define RID_SVXSTR_GRDT30_DEF                       "From a Corner, Violet"
#define RID_SVXSTR_GRDT31_DEF                       "From the Middle"
#define RID_SVXSTR_GRDT32_DEF                       "From the Middle, Blue"
#define RID_SVXSTR_GRDT33_DEF                       "From the Middle, Green"
#define RID_SVXSTR_GRDT34_DEF                       "From the Middle, Orange"
#define RID_SVXSTR_GRDT35_DEF                       "From the Middle, Red"
#define RID_SVXSTR_GRDT36_DEF                       "From the Middle, Turquoise"
#define RID_SVXSTR_GRDT37_DEF                       "From the Middle, Violet"
#define RID_SVXSTR_GRDT38_DEF                       "Horizontal"
#define RID_SVXSTR_GRDT39_DEF                       "Horizontal Blue"
#define RID_SVXSTR_GRDT40_DEF                       "Horizontal Green"
#define RID_SVXSTR_GRDT41_DEF                       "Horizontal Orange"
#define RID_SVXSTR_GRDT42_DEF                       "Horizontal Red"
#define RID_SVXSTR_GRDT43_DEF                       "Horizontal Turquoise"
#define RID_SVXSTR_GRDT44_DEF                       "Horizontal Violet"
#define RID_SVXSTR_GRDT45_DEF                       "Radial"
#define RID_SVXSTR_GRDT46_DEF                       "Radial Blue"
#define RID_SVXSTR_GRDT47_DEF                       "Radial Green"
#define RID_SVXSTR_GRDT48_DEF                       "Radial Orange"
#define RID_SVXSTR_GRDT49_DEF                       "Radial Red"
#define RID_SVXSTR_GRDT50_DEF                       "Radial Turquoise"
#define RID_SVXSTR_GRDT51_DEF                       "Radial Violet"
#define RID_SVXSTR_GRDT52_DEF                       "Vertical"
#define RID_SVXSTR_GRDT53_DEF                       "Vertical Blue"
#define RID_SVXSTR_GRDT54_DEF                       "Vertical Green"
#define RID_SVXSTR_GRDT55_DEF                       "Vertical Orange"
#define RID_SVXSTR_GRDT56_DEF                       "Vertical Red"
#define RID_SVXSTR_GRDT57_DEF                       "Vertical Turquoise"
#define RID_SVXSTR_GRDT58_DEF                       "Vertical Violet"
#define RID_SVXSTR_GRDT59_DEF                       "Gray Gradient"
#define RID_SVXSTR_GRDT60_DEF                       "Yellow Gradient"
#define RID_SVXSTR_GRDT61_DEF                       "Orange Gradient"
#define RID_SVXSTR_GRDT62_DEF                       "Red Gradient"
#define RID_SVXSTR_GRDT63_DEF                       "Pink Gradient"
#define RID_SVXSTR_GRDT64_DEF                       "Sky"
#define RID_SVXSTR_GRDT65_DEF                       "Cyan Gradient"
#define RID_SVXSTR_GRDT66_DEF                       "Blue Gradient"
#define RID_SVXSTR_GRDT67_DEF                       "Purple Pipe"
#define RID_SVXSTR_GRDT68_DEF                       "Night"
#define RID_SVXSTR_GRDT69_DEF                       "Green Gradient"
//actual gradients defined for 6.1
#define RID_SVXSTR_GRDT70_DEF                       "Pastel Bouquet"
#define RID_SVXSTR_GRDT71_DEF                       "Pastel Dream"
#define RID_SVXSTR_GRDT72_DEF                       "Blue Touch"
#define RID_SVXSTR_GRDT73_DEF                       "Blank with Gray"
#define RID_SVXSTR_GRDT74_DEF                       "Spotted Gray"
#define RID_SVXSTR_GRDT75_DEF                       "London Mist"
#define RID_SVXSTR_GRDT76_DEF                       "Teal to Blue"
#define RID_SVXSTR_GRDT77_DEF                       "Midnight"
#define RID_SVXSTR_GRDT78_DEF                       "Deep Ocean"
#define RID_SVXSTR_GRDT79_DEF                       "Submarine"
#define RID_SVXSTR_GRDT80_DEF                       "Green Grass"
#define RID_SVXSTR_GRDT81_DEF                       "Neon Light"
#define RID_SVXSTR_GRDT82_DEF                       "Sunshine"
#define RID_SVXSTR_GRDT83_DEF                       "Present"
#define RID_SVXSTR_GRDT84_DEF                       "Mahogany"
// Reference-strings for standard-hatch-table
#define RID_SVXSTR_HATCH0_DEF                       "Black 45 Degrees Wide"
#define RID_SVXSTR_HATCH1_DEF                       "Black 45 Degrees"
#define RID_SVXSTR_HATCH2_DEF                       "Black -45 Degrees"
#define RID_SVXSTR_HATCH3_DEF                       "Black 90 Degrees"
#define RID_SVXSTR_HATCH4_DEF                       "Red Crossed 45 Degrees"
#define RID_SVXSTR_HATCH5_DEF                       "Red Crossed 0 Degrees"
#define RID_SVXSTR_HATCH6_DEF                       "Blue Crossed 45 Degrees"
#define RID_SVXSTR_HATCH7_DEF                       "Blue Crossed 0 Degrees"
#define RID_SVXSTR_HATCH8_DEF                       "Blue Triple 90 Degrees"
#define RID_SVXSTR_HATCH9_DEF                       "Black 0 Degrees"
#define RID_SVXSTR_HATCH10_DEF                      "Hatching"
// Reference-strings for standard-bitmap-table
#define RID_SVXSTR_BMP0_DEF                         "Empty"
#define RID_SVXSTR_BMP1_DEF                         "Painted White"
#define RID_SVXSTR_BMP2_DEF                         "Paper Texture"
#define RID_SVXSTR_BMP3_DEF                         "Paper Crumpled"
#define RID_SVXSTR_BMP4_DEF                         "Paper Graph"
#define RID_SVXSTR_BMP5_DEF                         "Parchment Paper"
#define RID_SVXSTR_BMP6_DEF                         "Fence"
#define RID_SVXSTR_BMP7_DEF                         "Wooden Board"
#define RID_SVXSTR_BMP8_DEF                         "Maple Leaves"
#define RID_SVXSTR_BMP9_DEF                         "Lawn"
#define RID_SVXSTR_BMP10_DEF                        "Colorful Pebbles"
#define RID_SVXSTR_BMP11_DEF                        "Coffee Beans"
#define RID_SVXSTR_BMP12_DEF                        "Little Clouds"
#define RID_SVXSTR_BMP13_DEF                        "Bathroom Tiles"
#define RID_SVXSTR_BMP14_DEF                        "Wall of Rock"
#define RID_SVXSTR_BMP15_DEF                        "Zebra"
#define RID_SVXSTR_BMP16_DEF                        "Color Stripes"
#define RID_SVXSTR_BMP17_DEF                        "Gravel"
#define RID_SVXSTR_BMP18_DEF                        "Parchment Studio"
#define RID_SVXSTR_BMP19_DEF                        "Night Sky"
#define RID_SVXSTR_BMP20_DEF                        "Pool"
#define RID_SVXSTR_BMP21_DEF                        "Bitmap"
// Reference strings for patterns - they are a variation of bitmaps
#define RID_SVXSTR_BMP22_DEF                        "5 Percent"
#define RID_SVXSTR_BMP23_DEF                        "10 Percent"
#define RID_SVXSTR_BMP24_DEF                        "20 Percent"
#define RID_SVXSTR_BMP25_DEF                        "25 Percent"
#define RID_SVXSTR_BMP26_DEF                        "30 Percent"
#define RID_SVXSTR_BMP27_DEF                        "40 Percent"
#define RID_SVXSTR_BMP28_DEF                        "50 Percent"
#define RID_SVXSTR_BMP29_DEF                        "60 Percent"
#define RID_SVXSTR_BMP30_DEF                        "70 Percent"
#define RID_SVXSTR_BMP31_DEF                        "75 Percent"
#define RID_SVXSTR_BMP32_DEF                        "80 Percent"
#define RID_SVXSTR_BMP33_DEF                        "90 Percent"
#define RID_SVXSTR_BMP34_DEF                        "Light Downward Diagonal"
#define RID_SVXSTR_BMP35_DEF                        "Light Upward Diagonal"
#define RID_SVXSTR_BMP36_DEF                        "Dark Downward Diagonal"
#define RID_SVXSTR_BMP37_DEF                        "Dark Upward Diagonal"
#define RID_SVXSTR_BMP38_DEF                        "Wide Downward Diagonal"
#define RID_SVXSTR_BMP39_DEF                        "Wide Upward Diagonal"
#define RID_SVXSTR_BMP40_DEF                        "Light Vertical"
#define RID_SVXSTR_BMP41_DEF                        "Light Horizontal"
#define RID_SVXSTR_BMP42_DEF                        "Narrow Vertical"
#define RID_SVXSTR_BMP43_DEF                        "Narrow Horizontal"
#define RID_SVXSTR_BMP44_DEF                        "Dark Vertical"
#define RID_SVXSTR_BMP45_DEF                        "Dark Horizontal"
#define RID_SVXSTR_BMP46_DEF                        "Dashed Downward Diagonal"
#define RID_SVXSTR_BMP47_DEF                        "Dashed Upward Diagonal"
#define RID_SVXSTR_BMP48_DEF                        "Dashed Horizontal"
#define RID_SVXSTR_BMP49_DEF                        "Dashed Vertical"
#define RID_SVXSTR_BMP50_DEF                        "Small Confetti"
#define RID_SVXSTR_BMP51_DEF                        "Large Confetti"
#define RID_SVXSTR_BMP52_DEF                        "Zig Zag"
#define RID_SVXSTR_BMP53_DEF                        "Wave"
#define RID_SVXSTR_BMP54_DEF                        "Diagonal Brick"
#define RID_SVXSTR_BMP55_DEF                        "Horizontal Brick"
#define RID_SVXSTR_BMP56_DEF                        "Weave"
#define RID_SVXSTR_BMP57_DEF                        "Plaid"
#define RID_SVXSTR_BMP58_DEF                        "Divot"
#define RID_SVXSTR_BMP59_DEF                        "Dotted Grid"
#define RID_SVXSTR_BMP60_DEF                        "Dotted Diamond"
#define RID_SVXSTR_BMP61_DEF                        "Shingle"
#define RID_SVXSTR_BMP62_DEF                        "Trellis"
#define RID_SVXSTR_BMP63_DEF                        "Sphere"
#define RID_SVXSTR_BMP64_DEF                        "Small Grid"
#define RID_SVXSTR_BMP65_DEF                        "Large Grid"
#define RID_SVXSTR_BMP66_DEF                        "Small Checker Board"
#define RID_SVXSTR_BMP67_DEF                        "Large Checker Board"
#define RID_SVXSTR_BMP68_DEF                        "Outlined Diamond"
#define RID_SVXSTR_BMP69_DEF                        "Solid Diamond"
#define RID_SVXSTR_BMP70_DEF                        "Vertical"
#define RID_SVXSTR_BMP71_DEF                        "Horizontal"
#define RID_SVXSTR_BMP72_DEF                        "Downward Diagonal"
#define RID_SVXSTR_BMP73_DEF                        "Upward Diagonal"
#define RID_SVXSTR_BMP74_DEF                        "Cross"
#define RID_SVXSTR_BMP75_DEF                        "Diagonal Cross"
// Reference-strings for standard-dash-table
#define RID_SVXSTR_DASH0_DEF                        "Ultrafine Dashed"
#define RID_SVXSTR_DASH1_DEF                        "Fine Dashed"
#define RID_SVXSTR_DASH2_DEF                        "Ultrafine 2 Dots 3 Dashes"
#define RID_SVXSTR_DASH3_DEF                        "Fine Dotted"
#define RID_SVXSTR_DASH4_DEF                        "Line with Fine Dots"
#define RID_SVXSTR_DASH5_DEF                        "Fine Dashed (var)"
#define RID_SVXSTR_DASH6_DEF                        "3 Dashes 3 Dots (var)"
#define RID_SVXSTR_DASH7_DEF                        "Ultrafine Dotted (var)"
#define RID_SVXSTR_DASH8_DEF                        "Line Style 9"
#define RID_SVXSTR_DASH9_DEF                        "2 Dots 1 Dash"
#define RID_SVXSTR_DASH10_DEF                       "Dashed (var)"
#define RID_SVXSTR_DASH11_DEF                       "Dash"
#define RID_SVXSTR_DASH12_DEF                       "Line Style"
// Reference-strings for standard-line-end-table
#define RID_SVXSTR_LEND0_DEF                        "Arrow concave"
#define RID_SVXSTR_LEND1_DEF                        "Square 45"
#define RID_SVXSTR_LEND2_DEF                        "Small Arrow"
#define RID_SVXSTR_LEND3_DEF                        "Dimension Lines"
#define RID_SVXSTR_LEND4_DEF                        "Double Arrow"
#define RID_SVXSTR_LEND5_DEF                        "Rounded short Arrow"
#define RID_SVXSTR_LEND6_DEF                        "Symmetric Arrow"
#define RID_SVXSTR_LEND7_DEF                        "Line Arrow"
#define RID_SVXSTR_LEND8_DEF                        "Rounded large Arrow"
#define RID_SVXSTR_LEND9_DEF                        "Circle"
#define RID_SVXSTR_LEND10_DEF                       "Square"
#define RID_SVXSTR_LEND11_DEF                       "Arrow"
#define RID_SVXSTR_LEND12_DEF                       "Short line Arrow"
#define RID_SVXSTR_LEND13_DEF                       "Triangle unfilled"
#define RID_SVXSTR_LEND14_DEF                       "Diamond unfilled"
#define RID_SVXSTR_LEND15_DEF                       "Diamond"
#define RID_SVXSTR_LEND16_DEF                       "Circle unfilled"
#define RID_SVXSTR_LEND17_DEF                       "Square 45 unfilled"
#define RID_SVXSTR_LEND18_DEF                       "Square unfilled"
#define RID_SVXSTR_LEND19_DEF                       "Half Circle unfilled"
#define RID_SVXSTR_LEND20_DEF                       "Arrowhead"
// Reference-strings for standard transparence gradients
#define RID_SVXSTR_TRASNGR0_DEF                     "Transparency"
#define RID_SVXSTR_COLOR_LIBRE_GREEN_1_DEF          "Green 1 (%PRODUCTNAME Main Color)"
#define RID_SVXSTR_COLOR_LIBRE_GREEN_ACCENT_DEF     "Green Accent"
#define RID_SVXSTR_COLOR_LIBRE_BLUE_ACCENT_DEF      "Blue Accent"
#define RID_SVXSTR_COLOR_LIBRE_ORANGE_ACCENT_DEF    "Orange Accent"
#define RID_SVXSTR_COLOR_LIBRE_PURPLE_DEF           "Purple"
#define RID_SVXSTR_COLOR_LIBRE_PURPLE_ACCENT_DEF    "Purple Accent"
#define RID_SVXSTR_COLOR_LIBRE_YELLOW_ACCENT_DEF    "Yellow Accent"
#define RID_SVXSTR_COLOR_TANGO_BUTTER_DEF           "Tango: Butter"
#define RID_SVXSTR_COLOR_TANGO_ORANGE_DEF           "Tango: Orange"
#define RID_SVXSTR_COLOR_TANGO_CHOCOLATE_DEF        "Tango: Chocolate"
#define RID_SVXSTR_COLOR_TANGO_CHAMELEON_DEF        "Tango: Chameleon"
#define RID_SVXSTR_COLOR_TANGO_SKY_BLUE_DEF         "Tango: Sky Blue"
#define RID_SVXSTR_COLOR_TANGO_PLUM_DEF             "Tango: Plum"
#define RID_SVXSTR_COLOR_TANGO_SCARLET_RED_DEF      "Tango: Scarlet Red"
#define RID_SVXSTR_COLOR_TANGO_ALUMINIUM_DEF        "Tango: Aluminium"

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab cinoptions=b1,g0,N-s cinkeys+=0=break: */
