/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import com.wombatinvasion.pmwikidraw.PmWikiDrawURLEncoder;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.contrib.ChopPolygonConnector;
import org.jhotdraw.contrib.PolygonHandle;
import org.jhotdraw.contrib.PolygonScaleHandle;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.AbstractLocator;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class PolygonFigure
extends AttributeFigure {
    static final int TOO_CLOSE = 2;
    private static final long serialVersionUID = 6254089689239215026L;
    private int polygonFigureSerializedDataVersion = 1;
    private Polygon fPoly;

    public PolygonFigure() {
        this.setInternalPolygon(new Polygon());
    }

    public PolygonFigure(int n, int n2) {
        this();
        this.getInternalPolygon().addPoint(n, n2);
    }

    public PolygonFigure(Polygon polygon) {
        this.setInternalPolygon(new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints));
    }

    public Rectangle displayBox() {
        return PolygonFigure.bounds(this.getInternalPolygon());
    }

    public boolean isEmpty() {
        return this.pointCount() < 3 || this.size().width < 2 && this.size().height < 2;
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList(this.pointCount());
        for (int i = 0; i < this.pointCount(); ++i) {
            list.add(new PolygonHandle(this, PolygonFigure.locator(i), i));
        }
        list.add(new PolygonScaleHandle(this));
        return new HandleEnumerator(list);
    }

    public String getMap() {
        String string = (String)this.getAttribute(FigureAttributeConstant.URL);
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            string = PmWikiDrawURLEncoder.decode(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Rectangle rectangle = this.displayBox();
        String string2 = "";
        for (int i = 0; i < this.fPoly.npoints; ++i) {
            if (i > 0) {
                string2 = string2 + ",";
            }
            string2 = string2 + this.fPoly.xpoints[i] + "," + this.fPoly.ypoints[i];
        }
        return "<area shape=\"poly\" coords=\"" + string2 + "\" href=\"" + string + "\" alt=\"" + string + "\" />";
    }

    public void basicDisplayBox(Point point, Point point2) {
        Rectangle rectangle = this.displayBox();
        int n = point.x - rectangle.x;
        int n2 = point.y - rectangle.y;
        this.getInternalPolygon().translate(n, n2);
        rectangle = this.displayBox();
        Point point3 = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        this.scaleRotate(point3, this.getInternalPolygon(), point2);
    }

    public Polygon getPolygon() {
        return new Polygon(this.fPoly.xpoints, this.fPoly.ypoints, this.fPoly.npoints);
    }

    protected void setInternalPolygon(Polygon polygon) {
        this.fPoly = polygon;
    }

    public Polygon getInternalPolygon() {
        return this.fPoly;
    }

    public Point center() {
        return PolygonFigure.center(this.getInternalPolygon());
    }

    public Iterator points() {
        List list = CollectionsFactory.current().createList(this.pointCount());
        for (int i = 0; i < this.pointCount(); ++i) {
            list.add(new Point(this.getInternalPolygon().xpoints[i], this.getInternalPolygon().ypoints[i]));
        }
        return list.iterator();
    }

    public int pointCount() {
        return this.getInternalPolygon().npoints;
    }

    public void basicMoveBy(int n, int n2) {
        this.getInternalPolygon().translate(n, n2);
    }

    public void drawBackground(Graphics graphics) {
        graphics.fillPolygon(this.getInternalPolygon());
    }

    public void drawFrame(Graphics graphics) {
        graphics.drawPolygon(this.getInternalPolygon());
    }

    public boolean containsPoint(int n, int n2) {
        return this.getInternalPolygon().contains(n, n2);
    }

    public Connector connectorAt(int n, int n2) {
        return new ChopPolygonConnector(this);
    }

    public void addPoint(int n, int n2) {
        this.getInternalPolygon().addPoint(n, n2);
        this.changed();
    }

    public void setPointAt(Point point, int n) {
        this.willChange();
        this.getInternalPolygon().xpoints[n] = point.x;
        this.getInternalPolygon().ypoints[n] = point.y;
        this.changed();
    }

    public void insertPointAt(Point point, int n) {
        int n2;
        this.willChange();
        int n3 = this.pointCount() + 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = this.getInternalPolygon().xpoints[n2];
            nArray2[n2] = this.getInternalPolygon().ypoints[n2];
        }
        nArray[n] = point.x;
        nArray2[n] = point.y;
        for (n2 = n; n2 < this.pointCount(); ++n2) {
            nArray[n2 + 1] = this.getInternalPolygon().xpoints[n2];
            nArray2[n2 + 1] = this.getInternalPolygon().ypoints[n2];
        }
        this.setInternalPolygon(new Polygon(nArray, nArray2, n3));
        this.changed();
    }

    public void removePointAt(int n) {
        int n2;
        this.willChange();
        int n3 = this.pointCount() - 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = this.getInternalPolygon().xpoints[n2];
            nArray2[n2] = this.getInternalPolygon().ypoints[n2];
        }
        for (n2 = n; n2 < n3; ++n2) {
            nArray[n2] = this.getInternalPolygon().xpoints[n2 + 1];
            nArray2[n2] = this.getInternalPolygon().ypoints[n2 + 1];
        }
        this.setInternalPolygon(new Polygon(nArray, nArray2, n3));
        this.changed();
    }

    public void scaleRotate(Point point, Polygon polygon, Point point2) {
        this.willChange();
        Point point3 = PolygonFigure.center(polygon);
        double d = Geom.length(point3.x, point3.y, point.x, point.y);
        if (d > 0.0) {
            double d2 = Geom.length(point3.x, point3.y, point2.x, point2.y);
            double d3 = d2 / d;
            double d4 = Math.atan2(point.y - point3.y, point.x - point3.x);
            double d5 = Math.atan2(point2.y - point3.y, point2.x - point3.x);
            double d6 = d5 - d4;
            int n = polygon.npoints;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = polygon.xpoints[i];
                int n3 = polygon.ypoints[i];
                double d7 = (double)Geom.length(point3.x, point3.y, n2, n3) * d3;
                double d8 = Math.atan2(n3 - point3.y, n2 - point3.x) + d6;
                nArray[i] = (int)((double)point3.x + d7 * Math.cos(d8) + 0.5);
                nArray2[i] = (int)((double)point3.y + d7 * Math.sin(d8) + 0.5);
            }
            this.setInternalPolygon(new Polygon(nArray, nArray2, n));
        }
        this.changed();
    }

    public void smoothPoints() {
        this.willChange();
        boolean bl = false;
        int n = this.pointCount();
        do {
            bl = false;
            int n2 = 0;
            while (n2 < n && n >= 3) {
                int n3 = (n2 - 1 + n) % n;
                int n4 = (n2 + 1) % n;
                if (Geom.distanceFromLine(this.getInternalPolygon().xpoints[n3], this.getInternalPolygon().ypoints[n3], this.getInternalPolygon().xpoints[n4], this.getInternalPolygon().ypoints[n4], this.getInternalPolygon().xpoints[n2], this.getInternalPolygon().ypoints[n2]) < 2.0) {
                    bl = true;
                    --n;
                    for (int i = n2; i < n; ++i) {
                        this.getInternalPolygon().xpoints[i] = this.getInternalPolygon().xpoints[i + 1];
                        this.getInternalPolygon().ypoints[i] = this.getInternalPolygon().ypoints[i + 1];
                    }
                    continue;
                }
                ++n2;
            }
        } while (bl);
        if (n != this.pointCount()) {
            this.setInternalPolygon(new Polygon(this.getInternalPolygon().xpoints, this.getInternalPolygon().ypoints, n));
        }
        this.changed();
    }

    public int splitSegment(int n, int n2) {
        int n3 = this.findSegment(n, n2);
        if (n3 != -1) {
            this.insertPointAt(new Point(n, n2), n3 + 1);
            return n3 + 1;
        }
        return -1;
    }

    public Point pointAt(int n) {
        return new Point(this.getInternalPolygon().xpoints[n], this.getInternalPolygon().ypoints[n]);
    }

    public Point outermostPoint() {
        Point point = this.center();
        int n = 0;
        long l = 0L;
        for (int i = 0; i < this.pointCount(); ++i) {
            long l2 = Geom.length2(point.x, point.y, this.getInternalPolygon().xpoints[i], this.getInternalPolygon().ypoints[i]);
            if (l2 <= l) continue;
            l = l2;
            n = i;
        }
        return new Point(this.getInternalPolygon().xpoints[n], this.getInternalPolygon().ypoints[n]);
    }

    public int findSegment(int n, int n2) {
        double d = 2.0;
        int n3 = -1;
        for (int i = 0; i < this.pointCount(); ++i) {
            int n4 = (i + 1) % this.pointCount();
            double d2 = Geom.distanceFromLine(this.getInternalPolygon().xpoints[i], this.getInternalPolygon().ypoints[i], this.getInternalPolygon().xpoints[n4], this.getInternalPolygon().ypoints[n4], n, n2);
            if (!(d2 < d)) continue;
            d = d2;
            n3 = i;
        }
        return n3;
    }

    public Point chop(Point point) {
        return PolygonFigure.chop(this.getInternalPolygon(), point);
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.pointCount());
        for (int i = 0; i < this.pointCount(); ++i) {
            storableOutput.writeInt(this.getInternalPolygon().xpoints[i]);
            storableOutput.writeInt(this.getInternalPolygon().ypoints[i]);
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        int n = storableInput.readInt();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = storableInput.readInt();
            nArray2[i] = storableInput.readInt();
        }
        this.setInternalPolygon(new Polygon(nArray, nArray2, n));
    }

    public static Locator locator(final int n) {
        return new AbstractLocator(){

            public Point locate(Figure figure) {
                PolygonFigure polygonFigure = (PolygonFigure)figure;
                if (n < polygonFigure.pointCount()) {
                    return ((PolygonFigure)figure).pointAt(n);
                }
                return new Point(-1, -1);
            }
        };
    }

    public static Rectangle bounds(Polygon polygon) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = polygon.npoints;
        for (int i = 0; i < n5; ++i) {
            int n6 = polygon.xpoints[i];
            int n7 = polygon.ypoints[i];
            if (n6 > n3) {
                n3 = n6;
            }
            if (n6 < n) {
                n = n6;
            }
            if (n7 > n4) {
                n4 = n7;
            }
            if (n7 >= n2) continue;
            n2 = n7;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public static Point center(Polygon polygon) {
        long l = 0L;
        long l2 = 0L;
        int n = polygon.npoints;
        for (int i = 0; i < n; ++i) {
            l += (long)polygon.xpoints[i];
            l2 += (long)polygon.ypoints[i];
        }
        return new Point((int)(l / (long)n), (int)(l2 / (long)n));
    }

    public static Point chop(Polygon polygon, Point point) {
        int n;
        Point point2 = PolygonFigure.center(polygon);
        int n2 = -1;
        int n3 = -1;
        long l = Long.MAX_VALUE;
        for (n = 0; n < polygon.npoints; ++n) {
            long l2;
            int n4 = (n + 1) % polygon.npoints;
            Point point3 = Geom.intersect(polygon.xpoints[n], polygon.ypoints[n], polygon.xpoints[n4], polygon.ypoints[n4], point.x, point.y, point2.x, point2.y);
            if (point3 == null || (l2 = Geom.length2(point3.x, point3.y, point.x, point.y)) >= l) continue;
            l = l2;
            n2 = point3.x;
            n3 = point3.y;
        }
        for (n = 0; n < polygon.npoints; ++n) {
            long l3 = Geom.length2(polygon.xpoints[n], polygon.ypoints[n], point.x, point.y);
            if (l3 >= l) continue;
            l = l3;
            n2 = polygon.xpoints[n];
            n3 = polygon.ypoints[n];
        }
        return new Point(n2, n3);
    }
}

