/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class SafeTreeMap<K, V>
implements Serializable,
NavigableMap<K, V> {
    private static final Comparator NATURAL_ORDER = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    };
    private final NavigableMap<K, V> delegate;
    private static final long serialVersionUID = 0L;

    public SafeTreeMap() {
        this(new TreeMap());
    }

    public SafeTreeMap(Comparator<? super K> comparator) {
        this(new TreeMap(comparator));
    }

    public SafeTreeMap(Map<? extends K, ? extends V> map) {
        this((NavigableMap<? extends K, ? extends V>)new TreeMap<K, V>(map));
    }

    public SafeTreeMap(SortedMap<K, ? extends V> map) {
        this((NavigableMap<K, ? extends V>)new TreeMap<K, V>(map));
    }

    private SafeTreeMap(NavigableMap<K, V> delegate) {
        this.delegate = delegate;
        if (delegate == null) {
            throw new NullPointerException();
        }
        for (Object k : this.keySet()) {
            this.checkValid(k);
        }
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.delegate.ceilingEntry(this.checkValid(key));
    }

    @Override
    public K ceilingKey(K key) {
        return this.delegate.ceilingKey(this.checkValid(key));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Comparator<? super K> comparator() {
        Comparator comparator = this.delegate.comparator();
        if (comparator == null) {
            comparator = NATURAL_ORDER;
        }
        return comparator;
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.delegate.containsKey(this.checkValid(key));
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.delegate.descendingKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return new SafeTreeMap<K, V>(this.delegate.descendingMap());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.delegate.firstEntry();
    }

    @Override
    public K firstKey() {
        return this.delegate.firstKey();
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.delegate.floorEntry(this.checkValid(key));
    }

    @Override
    public K floorKey(K key) {
        return this.delegate.floorKey(this.checkValid(key));
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(this.checkValid(key));
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new SafeTreeMap<K, V>(this.delegate.headMap(this.checkValid(toKey), inclusive));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.delegate.higherEntry(this.checkValid(key));
    }

    @Override
    public K higherKey(K key) {
        return this.delegate.higherKey(this.checkValid(key));
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public NavigableSet<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.delegate.lastEntry();
    }

    @Override
    public K lastKey() {
        return this.delegate.lastKey();
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.delegate.lowerEntry(this.checkValid(key));
    }

    @Override
    public K lowerKey(K key) {
        return this.delegate.lowerKey(this.checkValid(key));
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return this.delegate.navigableKeySet();
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.delegate.pollFirstEntry();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.delegate.pollLastEntry();
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(this.checkValid(key), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K key : map.keySet()) {
            this.checkValid(key);
        }
        this.delegate.putAll(map);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(this.checkValid(key));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new SafeTreeMap<K, V>(this.delegate.subMap(this.checkValid(fromKey), fromInclusive, this.checkValid(toKey), toInclusive));
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new SafeTreeMap<K, V>(this.delegate.tailMap(this.checkValid(fromKey), inclusive));
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    private <T> T checkValid(T t) {
        T k = t;
        this.comparator().compare(k, k);
        return t;
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

