## RabbitMQ 3.6.16

RabbitMQ 3.6.16 is a maintenance release that primarily includes selected backports from
the [3.7.x series](https://www.rabbitmq.com/changelog.html). Users of earlier 3.6.x releases
are recommended to [upgrade](https://www.rabbitmq.com/upgrade.html) to a 3.7.x release, e.g. [3.7.6](https://github.com/rabbitmq/rabbitmq-server/releases).

### Upgrades and Compatibility

See the [Upgrades documentation guide](https://www.rabbitmq.com/upgrade.html) for general
documentation on upgrades.

This release nearly exclusively contains backports of bug fixes, optimisations and small enhancements
(e.g. safer defaults) from the 3.7.x series. Some of them are **potentially breaking** but
should only affect a very small percentage of users. They are:

 * The max 255 priority cap is now enforced at all levels
 * Default `rabbit.channel_max` value is now about 2K, a much safer value than 65K used previously
 * Default idle LDAP connection timeout is now 300 seconds instead of infinity

This release has no other known incompatibilities with versions 3.6.7 through
3.6.15. See the upgrade and compatibility sections in the [3.6.7 release
notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_7)
if upgrading from an earlier release.

### 3.6.x Series Support Timeline

Please read this note on [RabbitMQ 3.6.x series support
timeline](https://groups.google.com/forum/#!msg/rabbitmq-users/kXkI-f3pgEw/UFowJIK4BQAJ).


### Core Server

#### Bug Fixes

* queue leader locator `min-masters` incorrectly calculated the number of masters.

  GitHub issue: [rabbitmq-server#1519](https://github.com/rabbitmq/rabbitmq-server/issues/1519)

* Maximum supported number of queue priorities (255) is now enforced.

  GitHub issue: [rabbitmq-server#1590](https://github.com/rabbitmq/rabbitmq-server/issues/1590)

#### Enhancements

 * On Erlang 20.2.3 or later, more optimal memory allocators will be used. On some workloads that leads
   to [significant reduction in node's RAM consumption](https://groups.google.com/d/msg/rabbitmq-users/LSYaac9frYw/LNZDZUlrBAAJ). The change is workload-specific, however, on the workloads
   tested that do introduce a negative effect (more RAM used) the difference was very small (about 1%).


   It is possible to go back to the previous settings, `+MBas aoffcbf +MHas aoffcbf +MBlmbcs 5120 +MHlmbcs 5120 +MMmcs 10`,
   by specifying them in the `RABBITMQ_SERVER_ADDITIONAL_ERL_ARGS` [environment variable](https://www.rabbitmq.com/configure.html#customise-environment).

   On Erlang/OTP releases older than 20.2.3 there will be no default changes.

   GitHub issue: [rabbitmq/rabbitmq-server#1604](https://github.com/rabbitmq/rabbitmq-server/pull/1604), [rabbitmq/rabbitmq-server#1612](https://github.com/rabbitmq/rabbitmq-server/pull/1612)

 * `queue.delete` operations will now force delete queues that don't have a [promotable
   master](https://www.rabbitmq.com/ha.html#unsynchronised-mirrors).

   GitHub issue: [rabbitmq-server#1501](https://github.com/rabbitmq/rabbitmq-server/issues/1501)

 * `ha-promote-on-failure` is a new mirrored queue setting that's similar to [`ha-promote-on-shutdown`](https://www.rabbitmq.com/ha.html#unsynchronised-mirrors)
   but for unexpected leader replica termination.

   GitHub issue: [rabbitmq-server#1578](https://github.com/rabbitmq/rabbitmq-server/pull/1578)
  * Lock contention in internal database is now much lower when a node with a lot of exclusive queues
   shuts down or is otherwise considered to be unavailable by peers. This means fewer CPU cycles
   spent cleaning up the exclusive queues.

   GitHub issue: [rabbitmq-server#1570](https://github.com/rabbitmq/rabbitmq-server/pull/1570)

 * Default [max number of channels allowed on a connection](https://www.rabbitmq.com/networking.html#tuning-for-large-number-of-connections-channel-max) (a.k.a. `channel_max`) has been lowered from `65535` to `2047`.
   The new default is much safer and will reduce the effect application channel leaks have on node resource consumption. **This is a potentially breaking change**.

   Systems where a lot (at least hundreds) of channels *per connection* are used should explicitly override `channel_max` in the [config file](https://www.rabbitmq.com/configure.html) to a higher suitable value, e.g.:

``` erlang
[
  {rabbit, [
    {channel_max, 4000}
  ]}
].
```

   GitHub issue: [rabbitmq-server#1593](https://github.com/rabbitmq/rabbitmq-server/issues/1593)


### Management Plugin

#### Bug Fixes

 * Eliminated unnecessary encoding conversions that could lead to increased memory consumption.

   GitHub issue: [rabbitmq-management#550](https://github.com/rabbitmq/rabbitmq-management/pull/550)

 * `rabbitmqadmin` could run into an exception with certain formatting settings on Python 2.x.

   GitHub issue: [rabbitmq-management#568](https://github.com/rabbitmq/rabbitmq-management/issues/568)

 * `rabbitmqadmin` incorrectly encoded spaces in connection name values

   GitHub issue: [rabbitmq-management#579](https://github.com/rabbitmq/rabbitmq-management/pull/579)

 * HTTP API stats documentation used incorrect field names.

   GitHub issue: [rabbitmq-management#561](https://github.com/rabbitmq/rabbitmq-management/pull/561)

#### Enhancements

 * Reduced padding usage in tables in the management UI.

   GitHub issue: [rabbitmq-management#541](https://github.com/rabbitmq/rabbitmq-management/pull/541)


### LDAP Plugin

#### Bug Fixes

 * LDAP server-initiated connection closure was not handled gracefully by connection pool.
   Kudos to Adam Gardner for [doing all the hard work](https://groups.google.com/forum/#!topic/rabbitmq-users/4Gva3h-yJzM) investigating this issue.

   GitHub issues: [rabbitmq-auth-backend-ldap#82](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/82), [rabbitmq-auth-backend-ldap#90](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/90)

 * `rabbit.idle_timeout` now defaults to 300 seconds instead of `infinity`.

   GitHub issue: [rabbitmq-auth-backend-ldap#81](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/81)


## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All
configuration and persistent message data are retained. When upgrading
using definitions export/import from versions earlier than 3.6.0, see
http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ
documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains
the source of the broker, not the plugins or the client libraries.
Please download the archive named `rabbitmq-server-3.6.16.tar.xz`.
