## RabbitMQ 3.8.16

RabbitMQ `3.8.16` is a maintenance release.

It reintroduces `rabbitmq_peer_discovery_aws` plugin that was unintentionally removed
from `3.8.15` due to release pipeline changes.

This is the first release to drop support for Erlang 22.3 and introduce support for the [upcoming Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/) release.

### Obtaining Packages

This release is distributed via GitHub, [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This is the [first release to require Erlang 23.2 or later and support upcoming Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision a recent version of Erlang `23.3`.


## Upgrade and Compatibility Notes

### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and
compatibility notes first if upgrading from an earlier release series (e.g. `3.7.x`).

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

### Core Server

#### Erlang Release Series Support

 * This release [introduces Erlang 24 support and drops support for Erlang 22](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/). Erlang 24 offers non-trivial real world throughput improvements for many
   RabbitMQ installations and workloads. It is expected to ship in May 2021.

   In the meantime, see [Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) to
   learn how to provision a recent version of Erlang `23.3`.

   GitHub issue: [#2900](https://github.com/rabbitmq/rabbitmq-server/pull/2900)


### AWS Peer Discovery Plugin

#### Bug Fixes

 * This plugin was unintentionally excluded from the distribution in `3.8.15` and has now been
   added back.

   GitHub issue: [#3023](https://github.com/rabbitmq/rabbitmq-server/issues/3023)


### Management Plugin

#### Enhancements

 * Messaging polling HTTP API endpoint leaked temporary connections it used in case of a polling timeout.
   Note that **this endpoint is not recommended to be used** outside of QA environments.
   Use a [long-lived consumer](https://www.rabbitmq.com/consumers.html) via one of the supported messaging protocols.

   Contributed by @luos.

   GitHub issue: [#3024](https://github.com/rabbitmq/rabbitmq-server/pull/3024)


## Dependency Upgrades

* Cuttlefish has been upgraded from [`2.6.0` to `3.0.0`](https://github.com/kyorai/cuttlefish/compare/v2.6.0..v3.0.0)
* Lager has been upgraded from [`3.8.2` to `3.9.1`](https://github.com/erlang-lager/lager/compare/3.8.2..3.9.1)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.16.tar.xz`
instead of the source tarball produced by GitHub.
