/* rygel-external-container.c generated by valac 0.44.9, the Vala compiler
 * generated from rygel-external-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <rygel-server.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_EXTERNAL_TYPE_CONTAINER (rygel_external_container_get_type ())
#define RYGEL_EXTERNAL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer))
#define RYGEL_EXTERNAL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))
#define RYGEL_EXTERNAL_IS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_IS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))

typedef struct _RygelExternalContainer RygelExternalContainer;
typedef struct _RygelExternalContainerClass RygelExternalContainerClass;
typedef struct _RygelExternalContainerPrivate RygelExternalContainerPrivate;

#define RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY (rygel_external_media_container_proxy_get_type ())
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY, RygelExternalMediaContainerProxy))
#define RYGEL_EXTERNAL_IS_MEDIA_CONTAINER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY))
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY, RygelExternalMediaContainerProxyIface))

typedef struct _RygelExternalMediaContainerProxy RygelExternalMediaContainerProxy;
typedef struct _RygelExternalMediaContainerProxyIface RygelExternalMediaContainerProxyIface;

#define RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY (rygel_external_media_object_proxy_get_type ())
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY, RygelExternalMediaObjectProxy))
#define RYGEL_EXTERNAL_IS_MEDIA_OBJECT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY))
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY, RygelExternalMediaObjectProxyIface))

typedef struct _RygelExternalMediaObjectProxy RygelExternalMediaObjectProxy;
typedef struct _RygelExternalMediaObjectProxyIface RygelExternalMediaObjectProxyIface;

#define RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY_PROXY (rygel_external_media_object_proxy_proxy_get_type ())

#define RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY_PROXY (rygel_external_media_container_proxy_proxy_get_type ())

#define RYGEL_EXTERNAL_TYPE_ITEM_FACTORY (rygel_external_item_factory_get_type ())
#define RYGEL_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactory))
#define RYGEL_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))

typedef struct _RygelExternalItemFactory RygelExternalItemFactory;
typedef struct _RygelExternalItemFactoryClass RygelExternalItemFactoryClass;
enum  {
	RYGEL_EXTERNAL_CONTAINER_0_PROPERTY,
	RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES_PROPERTY,
	RYGEL_EXTERNAL_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_external_container_properties[RYGEL_EXTERNAL_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_external_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_item_factory_unref (var), NULL)))
typedef struct _RygelExternalContainerGetChildrenData RygelExternalContainerGetChildrenData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelExternalContainerSearchData RygelExternalContainerSearchData;

#define RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES (rygel_external_free_desktop_properties_get_type ())
#define RYGEL_EXTERNAL_FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES, RygelExternalFreeDesktopProperties))
#define RYGEL_EXTERNAL_FREE_DESKTOP_IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES))
#define RYGEL_EXTERNAL_FREE_DESKTOP_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES, RygelExternalFreeDesktopPropertiesIface))

typedef struct _RygelExternalFreeDesktopProperties RygelExternalFreeDesktopProperties;
typedef struct _RygelExternalFreeDesktopPropertiesIface RygelExternalFreeDesktopPropertiesIface;

#define RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES_PROXY (rygel_external_free_desktop_properties_proxy_get_type ())
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER (rygel_external_dummy_container_get_type ())
#define RYGEL_EXTERNAL_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainer))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))

typedef struct _RygelExternalDummyContainer RygelExternalDummyContainer;
typedef struct _RygelExternalDummyContainerClass RygelExternalDummyContainerClass;
typedef struct _RygelExternalContainerFindObjectData RygelExternalContainerFindObjectData;
typedef struct _RygelExternalContainerCreateMediaObjectsData RygelExternalContainerCreateMediaObjectsData;
typedef struct _RygelExternalContainerRefreshChildContainersData RygelExternalContainerRefreshChildContainersData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelExternalContainerUpdateContainerData RygelExternalContainerUpdateContainerData;

struct _RygelExternalMediaObjectProxyIface {
	GTypeInterface parent_iface;
	char* (*get_parent) (RygelExternalMediaObjectProxy* self);
	void (*set_parent) (RygelExternalMediaObjectProxy* self, const char* value);
	gchar* (*get_display_name) (RygelExternalMediaObjectProxy* self);
	void (*set_display_name) (RygelExternalMediaObjectProxy* self, const gchar* value);
	gchar* (*get_object_type) (RygelExternalMediaObjectProxy* self);
	void (*set_object_type) (RygelExternalMediaObjectProxy* self, const gchar* value);
};

struct _RygelExternalMediaContainerProxyIface {
	GTypeInterface parent_iface;
	void (*list_children) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, gint filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_children_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, gint* result_length1, GError** error);
	void (*list_containers) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, gint filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_containers_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, gint* result_length1, GError** error);
	void (*list_items) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, gint filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_items_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, gint* result_length1, GError** error);
	void (*search_objects) (RygelExternalMediaContainerProxy* self, const gchar* query, guint offset, guint max_count, gchar** filter, gint filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*search_objects_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, gint* result_length1, GError** error);
	guint (*get_child_count) (RygelExternalMediaContainerProxy* self);
	void (*set_child_count) (RygelExternalMediaContainerProxy* self, guint value);
	guint (*get_item_count) (RygelExternalMediaContainerProxy* self);
	void (*set_item_count) (RygelExternalMediaContainerProxy* self, guint value);
	guint (*get_container_count) (RygelExternalMediaContainerProxy* self);
	void (*set_container_count) (RygelExternalMediaContainerProxy* self, guint value);
	gboolean (*get_searchable) (RygelExternalMediaContainerProxy* self);
	void (*set_searchable) (RygelExternalMediaContainerProxy* self, gboolean value);
	char* (*get_icon) (RygelExternalMediaContainerProxy* self);
	void (*set_icon) (RygelExternalMediaContainerProxy* self, const char* value);
};

struct _RygelExternalContainer {
	RygelMediaContainer parent_instance;
	RygelExternalContainerPrivate * priv;
	RygelExternalMediaContainerProxy* actual_container;
	gchar* service_name;
};

struct _RygelExternalContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelExternalContainerPrivate {
	RygelExternalItemFactory* item_factory;
	GeeArrayList* containers;
	GeeArrayList* _search_classes;
	gboolean searchable;
};

struct _RygelExternalContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelExternalContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	gchar** filter;
	gchar** _tmp0_;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	gint object_prop_collection_length1;
	gint _object_prop_collection_size_;
	gint object_prop_it;
	const gchar* object_prop;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar** container_prop_collection;
	gint container_prop_collection_length1;
	gint _container_prop_collection_size_;
	gint container_prop_it;
	const gchar* container_prop;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar** item_prop_collection;
	gint item_prop_collection_length1;
	gint _item_prop_collection_size_;
	gint item_prop_it;
	const gchar* item_prop;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GHashTable** children_props;
	RygelExternalMediaContainerProxy* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	GHashTable** _tmp13_;
	gint children_props_length1;
	gint _children_props_size_;
	RygelMediaObjects* _result_;
	GHashTable** _tmp14_;
	gint _tmp14__length1;
	RygelMediaObjects* _tmp15_;
	RygelMediaObjects* _tmp16_;
	GError* _inner_error0_;
};

struct _RygelExternalContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelExternalContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	RygelMediaObjects* result;
	gboolean _tmp0_;
	RygelMediaObjects* _tmp1_;
	guint _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _tmp4_;
	gchar** filter;
	gchar** _tmp5_;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	gint object_prop_collection_length1;
	gint _object_prop_collection_size_;
	gint object_prop_it;
	const gchar* object_prop;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar** container_prop_collection;
	gint container_prop_collection_length1;
	gint _container_prop_collection_size_;
	gint container_prop_it;
	const gchar* container_prop;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar** item_prop_collection;
	gint item_prop_collection_length1;
	gint _item_prop_collection_size_;
	gint item_prop_it;
	const gchar* item_prop;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	RygelSearchExpression* ext_expression;
	RygelSearchExpression* _tmp15_;
	GHashTable** _result_;
	RygelExternalMediaContainerProxy* _tmp16_;
	RygelSearchExpression* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_;
	GHashTable** _tmp22_;
	GHashTable** _tmp23_;
	gint _tmp23__length1;
	gint _result__length1;
	gint __result__size_;
	GHashTable** _tmp24_;
	gint _tmp24__length1;
	RygelMediaObjects* objects;
	GHashTable** _tmp25_;
	gint _tmp25__length1;
	RygelMediaObjects* _tmp26_;
	RygelMediaObjects* _tmp27_;
	GError* _inner_error0_;
};

struct _RygelExternalFreeDesktopPropertiesIface {
	GTypeInterface parent_iface;
	void (*get_all) (RygelExternalFreeDesktopProperties* self, const gchar* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*get_all_finish) (RygelExternalFreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
};

struct _RygelExternalContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelExternalContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* media_object;
	RygelExternalMediaObjectProxy* actual_object;
	const gchar* _tmp0_;
	RygelExternalMediaObjectProxy* _tmp1_;
	RygelExternalMediaObjectProxy* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	RygelMediaContainer* _tmp7_;
	RygelMediaObject* _tmp8_;
	GeeArrayList* _container_list;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	gint _container_size;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _container_index;
	RygelExternalContainer* container;
	GeeArrayList* _tmp14_;
	gpointer _tmp15_;
	RygelMediaObject* _tmp16_;
	RygelExternalContainer* _tmp17_;
	RygelMediaObject* _tmp18_;
	RygelMediaObject* _tmp19_;
	RygelMediaObject* _tmp20_;
	RygelExternalFreeDesktopProperties* props_iface;
	const gchar* _tmp21_;
	RygelExternalFreeDesktopProperties* _tmp22_;
	GHashTable* props;
	RygelExternalFreeDesktopProperties* _tmp23_;
	GHashTable* _tmp24_;
	guint child_count;
	GHashTable* _tmp25_;
	gconstpointer _tmp26_;
	guint _tmp27_;
	gboolean searchable;
	GHashTable* _tmp28_;
	gconstpointer _tmp29_;
	gboolean _tmp30_;
	GHashTable* _tmp31_;
	RygelExternalFreeDesktopProperties* _tmp32_;
	GHashTable* _tmp33_;
	GHashTable* _tmp34_;
	gchar* path;
	GHashTable* _tmp35_;
	gconstpointer _tmp36_;
	gchar* _tmp37_;
	gchar* title;
	GHashTable* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	RygelExternalContainer* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	RygelExternalContainer* _tmp47_;
	RygelExternalContainer* _tmp48_;
	RygelExternalDummyContainer* parent_container;
	RygelExternalMediaObjectProxy* _tmp49_;
	char* _tmp50_;
	char* _tmp51_;
	gchar* _tmp52_;
	RygelExternalDummyContainer* _tmp53_;
	RygelExternalDummyContainer* _tmp54_;
	RygelExternalFreeDesktopProperties* _vala1_props_iface;
	const gchar* _tmp55_;
	RygelExternalFreeDesktopProperties* _tmp56_;
	GHashTable* _vala1_props;
	RygelExternalFreeDesktopProperties* _tmp57_;
	GHashTable* _tmp58_;
	RygelMediaFileItem* _tmp59_;
	RygelExternalItemFactory* _tmp60_;
	RygelExternalMediaObjectProxy* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	RygelExternalMediaObjectProxy* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	GHashTable* _tmp69_;
	const gchar* _tmp70_;
	RygelExternalDummyContainer* _tmp71_;
	RygelMediaFileItem* _tmp72_;
	RygelMediaFileItem* _tmp73_;
	RygelMediaFileItem* _tmp74_;
	GError* _inner_error0_;
};

struct _RygelExternalContainerCreateMediaObjectsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelExternalContainer* self;
	GHashTable** all_props;
	gint all_props_length1;
	RygelMediaContainer* parent;
	RygelMediaObjects* result;
	RygelMediaObjects* media_objects;
	RygelMediaObjects* _tmp0_;
	GHashTable** props_collection;
	gint props_collection_length1;
	gint _props_collection_size_;
	gint props_it;
	GHashTable* _tmp1_;
	GHashTable* props;
	gchar* id;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	gchar* _tmp4_;
	gchar* type;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_;
	gchar* _tmp7_;
	RygelMediaContainer* parent_container;
	RygelMediaContainer* _tmp8_;
	gchar* parent_id;
	GHashTable* _tmp9_;
	gconstpointer _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	RygelExternalDummyContainer* _tmp13_;
	RygelMediaObject* media_object;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	RygelMediaContainer* _tmp16_;
	RygelMediaObject* _tmp17_;
	gchar* title;
	GHashTable* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	guint child_count;
	GHashTable* _tmp23_;
	gconstpointer _tmp24_;
	guint _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	RygelMediaContainer* _tmp28_;
	RygelExternalDummyContainer* _tmp29_;
	RygelMediaFileItem* _tmp30_;
	RygelExternalItemFactory* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GHashTable* _tmp35_;
	const gchar* _tmp36_;
	RygelMediaContainer* _tmp37_;
	RygelMediaFileItem* _tmp38_;
	RygelMediaFileItem* _tmp39_;
	RygelMediaObjects* _tmp40_;
	RygelMediaObject* _tmp41_;
	GError* _inner_error0_;
};

struct _RygelExternalContainerRefreshChildContainersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelExternalContainer* self;
	gchar** filter;
	gchar** _tmp0_;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	gint object_prop_collection_length1;
	gint _object_prop_collection_size_;
	gint object_prop_it;
	const gchar* object_prop;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar** container_prop_collection;
	gint container_prop_collection_length1;
	gint _container_prop_collection_size_;
	gint container_prop_it;
	const gchar* container_prop;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GHashTable** children_props;
	RygelExternalMediaContainerProxy* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	GHashTable** _tmp10_;
	gint children_props_length1;
	gint _children_props_size_;
	GeeArrayList* _tmp11_;
	GHashTable** _tmp12_;
	gint _tmp12__length1;
	GHashTable** props_collection;
	gint props_collection_length1;
	gint _props_collection_size_;
	gint props_it;
	GHashTable* _tmp13_;
	GHashTable* props;
	gchar* path;
	GHashTable* _tmp14_;
	gconstpointer _tmp15_;
	gchar* _tmp16_;
	gchar* title;
	GHashTable* _tmp17_;
	gconstpointer _tmp18_;
	gchar* _tmp19_;
	guint child_count;
	GHashTable* _tmp20_;
	gconstpointer _tmp21_;
	guint _tmp22_;
	gboolean searchable;
	GHashTable* _tmp23_;
	gconstpointer _tmp24_;
	gboolean _tmp25_;
	RygelExternalContainer* container;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	RygelExternalContainer* _tmp30_;
	GeeArrayList* _tmp31_;
	RygelExternalContainer* _tmp32_;
	GError* _inner_error0_;
};

struct _RygelExternalContainerUpdateContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelExternalContainer* self;
	gboolean connect_signal;
	RygelExternalFreeDesktopProperties* props_iface;
	const gchar* _tmp0_;
	RygelExternalMediaContainerProxy* _tmp1_;
	const gchar* _tmp2_;
	RygelExternalFreeDesktopProperties* _tmp3_;
	GHashTable* props;
	RygelExternalFreeDesktopProperties* _tmp4_;
	GHashTable* _tmp5_;
	guint child_count;
	GHashTable* _tmp6_;
	gconstpointer _tmp7_;
	guint _tmp8_;
	GHashTable* _tmp9_;
	RygelExternalFreeDesktopProperties* _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* _tmp12_;
	GHashTable* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* property_error;
	RygelExternalMediaContainerProxy* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GError* err;
	RygelExternalMediaContainerProxy* _tmp25_;
	const gchar* _tmp26_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	RygelExternalMediaContainerProxy* _tmp29_;
	GError* _inner_error0_;
};

static gint RygelExternalContainer_private_offset;
static gpointer rygel_external_container_parent_class = NULL;
static RygelSearchableContainerIface * rygel_external_container_rygel_searchable_container_parent_iface = NULL;

GType rygel_external_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelExternalContainer, g_object_unref)
GType rygel_external_media_object_proxy_get_type (void) G_GNUC_CONST;
GType rygel_external_media_object_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_media_object_proxy_register_object (void* object,
                                                         GDBusConnection* connection,
                                                         const gchar* path,
                                                         GError** error);
GType rygel_external_media_container_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_media_container_proxy_register_object (void* object,
                                                            GDBusConnection* connection,
                                                            const gchar* path,
                                                            GError** error);
GType rygel_external_media_container_proxy_get_type (void) G_GNUC_CONST;
gpointer rygel_external_item_factory_ref (gpointer instance);
void rygel_external_item_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_item_factory (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
void rygel_external_value_set_item_factory (GValue* value,
                                            gpointer v_object);
void rygel_external_value_take_item_factory (GValue* value,
                                             gpointer v_object);
gpointer rygel_external_value_get_item_factory (const GValue* value);
GType rygel_external_item_factory_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelExternalItemFactory, rygel_external_item_factory_unref)
RygelExternalContainer* rygel_external_container_new (const gchar* id,
                                                      const gchar* title,
                                                      guint child_count,
                                                      gboolean searchable,
                                                      const gchar* service_name,
                                                      const gchar* path,
                                                      RygelExternalContainer* parent,
                                                      GError** error);
RygelExternalContainer* rygel_external_container_construct (GType object_type,
                                                            const gchar* id,
                                                            const gchar* title,
                                                            guint child_count,
                                                            gboolean searchable,
                                                            const gchar* service_name,
                                                            const gchar* path,
                                                            RygelExternalContainer* parent,
                                                            GError** error);
RygelExternalItemFactory* rygel_external_item_factory_new (void);
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type);
static void rygel_external_container_update_container (RygelExternalContainer* self,
                                                gboolean connect_signal,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void rygel_external_container_update_container_finish (RygelExternalContainer* self,
                                                       GAsyncResult* _res_);
static void rygel_external_container_real_get_children_data_free (gpointer _data);
static void rygel_external_container_real_get_children (RygelMediaContainer* base,
                                                 guint offset,
                                                 guint max_count,
                                                 const gchar* sort_criteria,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* _data_);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
void rygel_external_media_container_proxy_list_children (RygelExternalMediaContainerProxy* self,
                                                         guint offset,
                                                         guint max_count,
                                                         gchar** filter,
                                                         gint filter_length1,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_list_children_finish (RygelExternalMediaContainerProxy* self,
                                                                        GAsyncResult* _res_,
                                                                        gint* result_length1,
                                                                        GError** error);
static void rygel_external_container_get_children_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void rygel_external_container_create_media_objects (RygelExternalContainer* self,
                                                    GHashTable** all_props,
                                                    gint all_props_length1,
                                                    RygelMediaContainer* parent,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static RygelMediaObjects* rygel_external_container_create_media_objects_finish (RygelExternalContainer* self,
                                                                         GAsyncResult* _res_,
                                                                         GError** error);
static void rygel_external_container_real_search_data_free (gpointer _data);
static void rygel_external_container_real_search (RygelSearchableContainer* base,
                                           RygelSearchExpression* expression,
                                           guint offset,
                                           guint max_count,
                                           const gchar* sort_criteria,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean rygel_external_container_real_search_co (RygelExternalContainerSearchData* _data_);
static void rygel_external_container_search_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void _vala_array_add4 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static RygelSearchExpression* rygel_external_container_translate_expression (RygelExternalContainer* self,
                                                                      RygelSearchExpression* upnp_expression);
void rygel_external_media_container_proxy_search_objects (RygelExternalMediaContainerProxy* self,
                                                          const gchar* query,
                                                          guint offset,
                                                          guint max_count,
                                                          gchar** filter,
                                                          gint filter_length1,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_search_objects_finish (RygelExternalMediaContainerProxy* self,
                                                                         GAsyncResult* _res_,
                                                                         gint* result_length1,
                                                                         GError** error);
static void rygel_external_container_real_find_object_data_free (gpointer _data);
static void rygel_external_container_real_find_object (RygelMediaContainer* base,
                                                const gchar* id,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean rygel_external_container_real_find_object_co (RygelExternalContainerFindObjectData* _data_);
static void rygel_external_container_find_object_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
gchar* rygel_external_media_object_proxy_get_object_type (RygelExternalMediaObjectProxy* self);
static RygelMediaContainer* rygel_external_container_find_container_by_id (RygelExternalContainer* self,
                                                                    const gchar* id);
GType rygel_external_free_desktop_properties_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_free_desktop_properties_register_object (void* object,
                                                              GDBusConnection* connection,
                                                              const gchar* path,
                                                              GError** error);
GType rygel_external_free_desktop_properties_get_type (void) G_GNUC_CONST;
void rygel_external_free_desktop_properties_get_all (RygelExternalFreeDesktopProperties* self,
                                                     const gchar* iface,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
GHashTable* rygel_external_free_desktop_properties_get_all_finish (RygelExternalFreeDesktopProperties* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error);
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_IFACE "org.gnome.UPnP.MediaContainer2"
static guint _variant_get1 (GVariant* value);
static gboolean _variant_get2 (GVariant* value);
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_IFACE "org.gnome.UPnP.MediaObject2"
static gchar* _variant_get3 (GVariant* value);
gchar* rygel_external_get_mandatory_string_value (GHashTable* props,
                                                  const gchar* key,
                                                  const gchar* _default_,
                                                  const gchar* service_name);
GType rygel_external_dummy_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelExternalDummyContainer, g_object_unref)
char* rygel_external_media_object_proxy_get_parent (RygelExternalMediaObjectProxy* self);
RygelExternalDummyContainer* rygel_external_dummy_container_new (const gchar* id,
                                                                 const gchar* title,
                                                                 guint child_count,
                                                                 RygelMediaContainer* parent);
RygelExternalDummyContainer* rygel_external_dummy_container_construct (GType object_type,
                                                                       const gchar* id,
                                                                       const gchar* title,
                                                                       guint child_count,
                                                                       RygelMediaContainer* parent);
#define RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_IFACE "org.gnome.UPnP.MediaItem2"
void rygel_external_item_factory_create (RygelExternalItemFactory* self,
                                         const gchar* id,
                                         const gchar* type,
                                         const gchar* title,
                                         GHashTable* props,
                                         const gchar* service_name,
                                         RygelMediaContainer* parent,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
RygelMediaFileItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self,
                                                               GAsyncResult* _res_,
                                                               GError** error);
gchar* rygel_external_media_object_proxy_get_display_name (RygelExternalMediaObjectProxy* self);
static void rygel_external_container_create_media_objects_data_free (gpointer _data);
static gboolean rygel_external_container_create_media_objects_co (RygelExternalContainerCreateMediaObjectsData* _data_);
static gchar* _variant_get4 (GVariant* value);
static gchar* _variant_get5 (GVariant* value);
static gchar* _variant_get6 (GVariant* value);
static guint _variant_get7 (GVariant* value);
static void rygel_external_container_create_media_objects_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void rygel_external_container_refresh_child_containers_data_free (gpointer _data);
static void rygel_external_container_refresh_child_containers (RygelExternalContainer* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void rygel_external_container_refresh_child_containers_finish (RygelExternalContainer* self,
                                                               GAsyncResult* _res_,
                                                               GError** error);
static gboolean rygel_external_container_refresh_child_containers_co (RygelExternalContainerRefreshChildContainersData* _data_);
static void _vala_array_add7 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
void rygel_external_media_container_proxy_list_containers (RygelExternalMediaContainerProxy* self,
                                                           guint offset,
                                                           guint max_count,
                                                           gchar** filter,
                                                           gint filter_length1,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_list_containers_finish (RygelExternalMediaContainerProxy* self,
                                                                          GAsyncResult* _res_,
                                                                          gint* result_length1,
                                                                          GError** error);
static void rygel_external_container_refresh_child_containers_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static gchar* _variant_get8 (GVariant* value);
static gchar* _variant_get9 (GVariant* value);
static guint _variant_get10 (GVariant* value);
static gboolean _variant_get11 (GVariant* value);
static void rygel_external_container_update_container_data_free (gpointer _data);
static gboolean rygel_external_container_update_container_co (RygelExternalContainerUpdateContainerData* _data_);
static void rygel_external_container_update_container_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static guint _variant_get12 (GVariant* value);
static void rygel_external_container_on_updated (RygelExternalContainer* self,
                                          RygelExternalMediaContainerProxy* actual_container);
static void _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated (RygelExternalMediaContainerProxy* _sender,
                                                                                        gpointer self);
gchar* rygel_external_container_translate_property (RygelExternalContainer* self,
                                                    const gchar* property);
static void rygel_external_container_finalize (GObject * obj);
static void _vala_rygel_external_container_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_rygel_external_container_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

extern const gchar* RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES[4];
extern const gchar* RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES[2];
extern const gchar* RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES[19];

static inline gpointer
rygel_external_container_get_instance_private (RygelExternalContainer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelExternalContainer_private_offset);
}

RygelExternalContainer*
rygel_external_container_construct (GType object_type,
                                    const gchar* id,
                                    const gchar* title,
                                    guint child_count,
                                    gboolean searchable,
                                    const gchar* service_name,
                                    const gchar* path,
                                    RygelExternalContainer* parent,
                                    GError** error)
{
	RygelExternalContainer * self = NULL;
	gint tmp = 0;
	gchar* _tmp0_;
	RygelExternalItemFactory* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	RygelExternalMediaContainerProxy* _tmp5_ = NULL;
	const gchar* _tmp6_;
	RygelExternalMediaContainerProxy* _tmp7_;
	RygelExternalMediaContainerProxy* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (service_name != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	tmp = (gint) CLAMP (child_count, (guint) 0, (guint) G_MAXINT);
	if (tmp == G_MAXINT) {
		tmp = -1;
	}
	self = (RygelExternalContainer*) rygel_media_container_construct (object_type, id, (RygelMediaContainer*) parent, title, tmp);
	_tmp0_ = g_strdup (service_name);
	_g_free0 (self->service_name);
	self->service_name = _tmp0_;
	_tmp1_ = rygel_external_item_factory_new ();
	_rygel_external_item_factory_unref0 (self->priv->item_factory);
	self->priv->item_factory = _tmp1_;
	_tmp2_ = gee_array_list_new (RYGEL_EXTERNAL_TYPE_CONTAINER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->containers);
	self->priv->containers = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp4_ = _tmp3_;
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	rygel_media_container_set_sort_criteria ((RygelMediaContainer*) self, "");
	_tmp6_ = self->service_name;
	_tmp7_ = (RygelExternalMediaContainerProxy*) g_initable_new (RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _tmp6_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", path, "g-interface-name", "org.gnome.UPnP.MediaContainer2", "g-interface-info", g_type_get_qdata (RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	_tmp5_ = (RygelExternalMediaContainerProxy*) _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = _tmp5_;
	_tmp5_ = NULL;
	_g_object_unref0 (self->actual_container);
	self->actual_container = _tmp8_;
	rygel_external_container_update_container (self, TRUE, NULL, NULL);
	if (parent != NULL) {
		g_object_add_weak_pointer ((GObject*) parent, &((RygelMediaObject*) self)->parent_ptr);
	}
	_g_object_unref0 (_tmp5_);
	return self;
}

RygelExternalContainer*
rygel_external_container_new (const gchar* id,
                              const gchar* title,
                              guint child_count,
                              gboolean searchable,
                              const gchar* service_name,
                              const gchar* path,
                              RygelExternalContainer* parent,
                              GError** error)
{
	return rygel_external_container_construct (RYGEL_EXTERNAL_TYPE_CONTAINER, id, title, child_count, searchable, service_name, path, parent, error);
}

static void
rygel_external_container_real_get_children_data_free (gpointer _data)
{
	RygelExternalContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelExternalContainerGetChildrenData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_external_container_real_get_children (RygelMediaContainer* base,
                                            guint offset,
                                            guint max_count,
                                            const gchar* sort_criteria,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	RygelExternalContainer * self;
	RygelExternalContainerGetChildrenData* _data_;
	RygelExternalContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	self = (RygelExternalContainer*) base;
	_data_ = g_slice_new0 (RygelExternalContainerGetChildrenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_container_real_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp1_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_external_container_real_get_children_co (_data_);
}

static RygelMediaObjects*
rygel_external_container_get_children_finish (RygelMediaContainer* base,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	RygelMediaObjects* result;
	RygelExternalContainerGetChildrenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
rygel_external_container_get_children_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	RygelExternalContainerGetChildrenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_external_container_real_get_children_co (_data_);
}

static gboolean
rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data_->filter = _data_->_tmp0_;
	_data_->filter_length1 = 0;
	_data_->_filter_size_ = _data_->filter_length1;
	{
		_data_->object_prop_collection_length1 = 0;
		_data_->_object_prop_collection_size_ = 0;
		_data_->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
		_data_->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
		for (_data_->object_prop_it = 0; _data_->object_prop_it < _data_->object_prop_collection_length1; _data_->object_prop_it = _data_->object_prop_it + 1) {
			_data_->object_prop = _data_->object_prop_collection[_data_->object_prop_it];
			{
				_data_->_tmp1_ = _data_->filter;
				_data_->_tmp1__length1 = _data_->filter_length1;
				_data_->_tmp2_ = _data_->object_prop;
				_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
				_vala_array_add1 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp3_);
			}
		}
	}
	{
		_data_->container_prop_collection_length1 = 0;
		_data_->_container_prop_collection_size_ = 0;
		_data_->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
		_data_->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
		for (_data_->container_prop_it = 0; _data_->container_prop_it < _data_->container_prop_collection_length1; _data_->container_prop_it = _data_->container_prop_it + 1) {
			_data_->container_prop = _data_->container_prop_collection[_data_->container_prop_it];
			{
				_data_->_tmp4_ = _data_->filter;
				_data_->_tmp4__length1 = _data_->filter_length1;
				_data_->_tmp5_ = _data_->container_prop;
				_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
				_vala_array_add2 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp6_);
			}
		}
	}
	{
		_data_->item_prop_collection_length1 = 0;
		_data_->_item_prop_collection_size_ = 0;
		_data_->item_prop_collection = RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES;
		_data_->item_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES);
		for (_data_->item_prop_it = 0; _data_->item_prop_it < _data_->item_prop_collection_length1; _data_->item_prop_it = _data_->item_prop_it + 1) {
			_data_->item_prop = _data_->item_prop_collection[_data_->item_prop_it];
			{
				_data_->_tmp7_ = _data_->filter;
				_data_->_tmp7__length1 = _data_->filter_length1;
				_data_->_tmp8_ = _data_->item_prop;
				_data_->_tmp9_ = g_strdup (_data_->_tmp8_);
				_vala_array_add3 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp9_);
			}
		}
	}
	_data_->_tmp10_ = _data_->self->actual_container;
	_data_->_tmp11_ = _data_->filter;
	_data_->_tmp11__length1 = _data_->filter_length1;
	_data_->_tmp12_ = 0;
	_data_->_state_ = 1;
	rygel_external_media_container_proxy_list_children (_data_->_tmp10_, _data_->offset, _data_->max_count, _data_->_tmp11_, (gint) _data_->_tmp11__length1, rygel_external_container_get_children_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp13_ = rygel_external_media_container_proxy_list_children_finish (_data_->_tmp10_, _data_->_res_, &_data_->_tmp12_, &_data_->_inner_error0_);
	_data_->children_props = _data_->_tmp13_;
	_data_->children_props_length1 = _data_->_tmp12_;
	_data_->_children_props_size_ = _data_->children_props_length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->children_props;
	_data_->_tmp14__length1 = _data_->children_props_length1;
	_data_->_state_ = 2;
	rygel_external_container_create_media_objects (_data_->self, _data_->_tmp14_, (gint) _data_->_tmp14__length1, (RygelMediaContainer*) _data_->self, rygel_external_container_get_children_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp15_ = rygel_external_container_create_media_objects_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_result_ = _data_->_tmp15_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = _data_->_result_;
	rygel_media_objects_sort_by_criteria (_data_->_tmp16_, _data_->sort_criteria);
	_data_->result = _data_->_result_;
	_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_external_container_real_search_data_free (gpointer _data)
{
	RygelExternalContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelExternalContainerSearchData, _data_);
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

static void
rygel_external_container_real_search (RygelSearchableContainer* base,
                                      RygelSearchExpression* expression,
                                      guint offset,
                                      guint max_count,
                                      const gchar* sort_criteria,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	RygelExternalContainer * self;
	RygelExternalContainerSearchData* _data_;
	RygelExternalContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	self = (RygelExternalContainer*) base;
	_data_ = g_slice_new0 (RygelExternalContainerSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp2_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	rygel_external_container_real_search_co (_data_);
}

static RygelMediaObjects*
rygel_external_container_search_finish (RygelSearchableContainer* base,
                                        GAsyncResult* _res_,
                                        guint* total_matches,
                                        GError** error)
{
	RygelMediaObjects* result;
	RygelExternalContainerSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_external_container_search_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	RygelExternalContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_external_container_real_search_co (_data_);
}

static void
_vala_array_add4 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
rygel_external_container_real_search_co (RygelExternalContainerSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->expression == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = !_data_->self->priv->searchable;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp2_ = 0U;
		_data_->_state_ = 1;
		rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->expression, _data_->offset, _data_->max_count, _data_->sort_criteria, _data_->cancellable, rygel_external_container_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp2_, &_data_->_inner_error0_);
		_data_->total_matches = _data_->_tmp2_;
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp4_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_data_->result = _data_->_tmp4_;
		_g_object_unref0 (_data_->_tmp1_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = g_new0 (gchar*, 0 + 1);
	_data_->filter = _data_->_tmp5_;
	_data_->filter_length1 = 0;
	_data_->_filter_size_ = _data_->filter_length1;
	{
		_data_->object_prop_collection_length1 = 0;
		_data_->_object_prop_collection_size_ = 0;
		_data_->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
		_data_->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
		for (_data_->object_prop_it = 0; _data_->object_prop_it < _data_->object_prop_collection_length1; _data_->object_prop_it = _data_->object_prop_it + 1) {
			_data_->object_prop = _data_->object_prop_collection[_data_->object_prop_it];
			{
				_data_->_tmp6_ = _data_->filter;
				_data_->_tmp6__length1 = _data_->filter_length1;
				_data_->_tmp7_ = _data_->object_prop;
				_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
				_vala_array_add4 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp8_);
			}
		}
	}
	{
		_data_->container_prop_collection_length1 = 0;
		_data_->_container_prop_collection_size_ = 0;
		_data_->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
		_data_->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
		for (_data_->container_prop_it = 0; _data_->container_prop_it < _data_->container_prop_collection_length1; _data_->container_prop_it = _data_->container_prop_it + 1) {
			_data_->container_prop = _data_->container_prop_collection[_data_->container_prop_it];
			{
				_data_->_tmp9_ = _data_->filter;
				_data_->_tmp9__length1 = _data_->filter_length1;
				_data_->_tmp10_ = _data_->container_prop;
				_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
				_vala_array_add5 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp11_);
			}
		}
	}
	{
		_data_->item_prop_collection_length1 = 0;
		_data_->_item_prop_collection_size_ = 0;
		_data_->item_prop_collection = RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES;
		_data_->item_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES);
		for (_data_->item_prop_it = 0; _data_->item_prop_it < _data_->item_prop_collection_length1; _data_->item_prop_it = _data_->item_prop_it + 1) {
			_data_->item_prop = _data_->item_prop_collection[_data_->item_prop_it];
			{
				_data_->_tmp12_ = _data_->filter;
				_data_->_tmp12__length1 = _data_->filter_length1;
				_data_->_tmp13_ = _data_->item_prop;
				_data_->_tmp14_ = g_strdup (_data_->_tmp13_);
				_vala_array_add6 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp14_);
			}
		}
	}
	_data_->_tmp15_ = rygel_external_container_translate_expression (_data_->self, _data_->expression);
	_data_->ext_expression = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->self->actual_container;
	_data_->_tmp17_ = _data_->ext_expression;
	_data_->_tmp18_ = rygel_search_expression_to_string (_data_->_tmp17_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = _data_->filter;
	_data_->_tmp20__length1 = _data_->filter_length1;
	_data_->_tmp21_ = 0;
	_data_->_state_ = 2;
	rygel_external_media_container_proxy_search_objects (_data_->_tmp16_, _data_->_tmp19_, _data_->offset, _data_->max_count, _data_->_tmp20_, (gint) _data_->_tmp20__length1, rygel_external_container_search_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp22_ = rygel_external_media_container_proxy_search_objects_finish (_data_->_tmp16_, _data_->_res_, &_data_->_tmp21_, &_data_->_inner_error0_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp23__length1 = _data_->_tmp21_;
	_g_free0 (_data_->_tmp19_);
	_data_->_result_ = _data_->_tmp23_;
	_data_->_result__length1 = _data_->_tmp23__length1;
	_data_->__result__size_ = _data_->_result__length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_rygel_search_expression_unref0 (_data_->ext_expression);
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp24_ = _data_->_result_;
	_data_->_tmp24__length1 = _data_->_result__length1;
	_data_->total_matches = (guint) _data_->_tmp24__length1;
	_data_->_tmp25_ = _data_->_result_;
	_data_->_tmp25__length1 = _data_->_result__length1;
	_data_->_state_ = 3;
	rygel_external_container_create_media_objects (_data_->self, _data_->_tmp25_, (gint) _data_->_tmp25__length1, NULL, rygel_external_container_search_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp26_ = rygel_external_container_create_media_objects_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->objects = _data_->_tmp26_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
		_rygel_search_expression_unref0 (_data_->ext_expression);
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = _data_->objects;
	rygel_media_objects_sort_by_criteria (_data_->_tmp27_, _data_->sort_criteria);
	_data_->result = _data_->objects;
	_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_rygel_search_expression_unref0 (_data_->ext_expression);
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_external_container_real_find_object_data_free (gpointer _data)
{
	RygelExternalContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelExternalContainerFindObjectData, _data_);
}

static void
rygel_external_container_real_find_object (RygelMediaContainer* base,
                                           const gchar* id,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	RygelExternalContainer * self;
	RygelExternalContainerFindObjectData* _data_;
	RygelExternalContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	self = (RygelExternalContainer*) base;
	_data_ = g_slice_new0 (RygelExternalContainerFindObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_external_container_real_find_object_co (_data_);
}

static RygelMediaObject*
rygel_external_container_find_object_finish (RygelMediaContainer* base,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	RygelMediaObject* result;
	RygelExternalContainerFindObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_external_container_find_object_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	RygelExternalContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_external_container_real_find_object_co (_data_);
}

static guint
_variant_get1 (GVariant* value)
{
	return g_variant_get_uint32 (value);
}

static gboolean
_variant_get2 (GVariant* value)
{
	return g_variant_get_boolean (value);
}

static gchar*
_variant_get3 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gboolean
rygel_external_container_real_find_object_co (RygelExternalContainerFindObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->media_object = NULL;
	_data_->_tmp0_ = _data_->self->service_name;
	_data_->_state_ = 1;
	g_async_initable_new_async (RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY_PROXY, 0, NULL, rygel_external_container_find_object_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->id, "g-interface-name", "org.gnome.UPnP.MediaObject2", "g-interface-info", g_type_get_qdata (RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = (RygelExternalMediaObjectProxy*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
	_data_->actual_object = (RygelExternalMediaObjectProxy*) _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->media_object);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->actual_object;
	_data_->_tmp3_ = rygel_external_media_object_proxy_get_object_type (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = g_strcmp0 (_data_->_tmp5_, "container") == 0;
	_g_free0 (_data_->_tmp5_);
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = rygel_external_container_find_container_by_id (_data_->self, _data_->id);
		_g_object_unref0 (_data_->media_object);
		_data_->media_object = (RygelMediaObject*) _data_->_tmp7_;
		_data_->_tmp8_ = _data_->media_object;
		if (_data_->_tmp8_ == NULL) {
			{
				_data_->_tmp9_ = _data_->self->priv->containers;
				_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
				_data_->_container_list = _data_->_tmp10_;
				_data_->_tmp11_ = _data_->_container_list;
				_data_->_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp11_);
				_data_->_tmp13_ = _data_->_tmp12_;
				_data_->_container_size = _data_->_tmp13_;
				_data_->_container_index = -1;
				while (TRUE) {
					_data_->_container_index = _data_->_container_index + 1;
					if (!(_data_->_container_index < _data_->_container_size)) {
						break;
					}
					_data_->_tmp14_ = _data_->_container_list;
					_data_->_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp14_, _data_->_container_index);
					_data_->container = (RygelExternalContainer*) _data_->_tmp15_;
					_data_->_tmp17_ = _data_->container;
					_data_->_state_ = 2;
					rygel_media_container_find_object ((RygelMediaContainer*) _data_->_tmp17_, _data_->id, _data_->cancellable, rygel_external_container_find_object_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp18_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) _data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
					_data_->_tmp16_ = _data_->_tmp18_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->container);
						_g_object_unref0 (_data_->_container_list);
						_g_object_unref0 (_data_->actual_object);
						_g_object_unref0 (_data_->media_object);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp19_ = _data_->_tmp16_;
					_data_->_tmp16_ = NULL;
					_g_object_unref0 (_data_->media_object);
					_data_->media_object = _data_->_tmp19_;
					_data_->_tmp20_ = _data_->media_object;
					if (_data_->_tmp20_ != NULL) {
						_g_object_unref0 (_data_->_tmp16_);
						_g_object_unref0 (_data_->container);
						break;
					}
					_g_object_unref0 (_data_->_tmp16_);
					_g_object_unref0 (_data_->container);
				}
				_g_object_unref0 (_data_->_container_list);
			}
			_data_->_tmp21_ = _data_->self->service_name;
			_data_->_state_ = 3;
			g_async_initable_new_async (RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES_PROXY, 0, NULL, rygel_external_container_find_object_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _data_->_tmp21_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->id, "g-interface-name", "org.freedesktop.DBus.Properties", "g-interface-info", g_type_get_qdata (RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
			return FALSE;
			_state_3:
			_data_->_tmp22_ = (RygelExternalFreeDesktopProperties*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->props_iface = (RygelExternalFreeDesktopProperties*) _data_->_tmp22_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->actual_object);
				_g_object_unref0 (_data_->media_object);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp23_ = _data_->props_iface;
			_data_->_state_ = 4;
			rygel_external_free_desktop_properties_get_all (_data_->_tmp23_, RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_IFACE, rygel_external_container_find_object_ready, _data_);
			return FALSE;
			_state_4:
			_data_->_tmp24_ = rygel_external_free_desktop_properties_get_all_finish (_data_->_tmp23_, _data_->_res_, &_data_->_inner_error0_);
			_data_->props = _data_->_tmp24_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->props_iface);
				_g_object_unref0 (_data_->actual_object);
				_g_object_unref0 (_data_->media_object);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp25_ = _data_->props;
			_data_->_tmp26_ = g_hash_table_lookup (_data_->_tmp25_, "ChildCount");
			_data_->_tmp27_ = _variant_get1 ((GVariant*) _data_->_tmp26_);
			_data_->child_count = _data_->_tmp27_;
			_data_->_tmp28_ = _data_->props;
			_data_->_tmp29_ = g_hash_table_lookup (_data_->_tmp28_, "Searchable");
			_data_->_tmp30_ = _variant_get2 ((GVariant*) _data_->_tmp29_);
			_data_->searchable = _data_->_tmp30_;
			_data_->_tmp32_ = _data_->props_iface;
			_data_->_state_ = 5;
			rygel_external_free_desktop_properties_get_all (_data_->_tmp32_, RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_IFACE, rygel_external_container_find_object_ready, _data_);
			return FALSE;
			_state_5:
			_data_->_tmp33_ = rygel_external_free_desktop_properties_get_all_finish (_data_->_tmp32_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp31_ = _data_->_tmp33_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_hash_table_unref0 (_data_->props);
				_g_object_unref0 (_data_->props_iface);
				_g_object_unref0 (_data_->actual_object);
				_g_object_unref0 (_data_->media_object);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp34_ = _data_->_tmp31_;
			_data_->_tmp31_ = NULL;
			_g_hash_table_unref0 (_data_->props);
			_data_->props = _data_->_tmp34_;
			_data_->_tmp35_ = _data_->props;
			_data_->_tmp36_ = g_hash_table_lookup (_data_->_tmp35_, "Path");
			_data_->_tmp37_ = _variant_get3 ((GVariant*) _data_->_tmp36_);
			_data_->path = _data_->_tmp37_;
			_data_->_tmp38_ = _data_->props;
			_data_->_tmp39_ = _data_->path;
			_data_->_tmp40_ = _data_->self->service_name;
			_data_->_tmp41_ = rygel_external_get_mandatory_string_value (_data_->_tmp38_, "DisplayName", _data_->_tmp39_, _data_->_tmp40_);
			_data_->title = _data_->_tmp41_;
			_data_->_tmp43_ = _data_->path;
			_data_->_tmp44_ = _data_->title;
			_data_->_tmp45_ = _data_->self->service_name;
			_data_->_tmp46_ = _data_->path;
			_data_->_tmp47_ = rygel_external_container_new (_data_->_tmp43_, _data_->_tmp44_, _data_->child_count, _data_->searchable, _data_->_tmp45_, _data_->_tmp46_, _data_->self, &_data_->_inner_error0_);
			_data_->_tmp42_ = _data_->_tmp47_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->title);
				_g_free0 (_data_->path);
				_g_hash_table_unref0 (_data_->_tmp31_);
				_g_hash_table_unref0 (_data_->props);
				_g_object_unref0 (_data_->props_iface);
				_g_object_unref0 (_data_->actual_object);
				_g_object_unref0 (_data_->media_object);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp48_ = _data_->_tmp42_;
			_data_->_tmp42_ = NULL;
			_g_object_unref0 (_data_->media_object);
			_data_->media_object = (RygelMediaObject*) _data_->_tmp48_;
			_g_object_unref0 (_data_->_tmp42_);
			_g_free0 (_data_->title);
			_g_free0 (_data_->path);
			_g_hash_table_unref0 (_data_->_tmp31_);
			_g_hash_table_unref0 (_data_->props);
			_g_object_unref0 (_data_->props_iface);
		}
	} else {
		_data_->_tmp49_ = _data_->actual_object;
		_data_->_tmp50_ = rygel_external_media_object_proxy_get_parent (_data_->_tmp49_);
		_data_->_tmp51_ = _data_->_tmp50_;
		_data_->_tmp52_ = (gchar*) _data_->_tmp51_;
		_data_->_tmp53_ = rygel_external_dummy_container_new (_data_->_tmp52_, "LaLaLa", (guint) 0, NULL);
		_data_->_tmp54_ = _data_->_tmp53_;
		_g_free0 (_data_->_tmp52_);
		_data_->parent_container = _data_->_tmp54_;
		_data_->_tmp55_ = _data_->self->service_name;
		_data_->_state_ = 6;
		g_async_initable_new_async (RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES_PROXY, 0, NULL, rygel_external_container_find_object_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _data_->_tmp55_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->id, "g-interface-name", "org.freedesktop.DBus.Properties", "g-interface-info", g_type_get_qdata (RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_6:
		_data_->_tmp56_ = (RygelExternalFreeDesktopProperties*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_vala1_props_iface = (RygelExternalFreeDesktopProperties*) _data_->_tmp56_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->parent_container);
			_g_object_unref0 (_data_->actual_object);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp57_ = _data_->_vala1_props_iface;
		_data_->_state_ = 7;
		rygel_external_free_desktop_properties_get_all (_data_->_tmp57_, RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_IFACE, rygel_external_container_find_object_ready, _data_);
		return FALSE;
		_state_7:
		_data_->_tmp58_ = rygel_external_free_desktop_properties_get_all_finish (_data_->_tmp57_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_vala1_props = _data_->_tmp58_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->_vala1_props_iface);
			_g_object_unref0 (_data_->parent_container);
			_g_object_unref0 (_data_->actual_object);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp60_ = _data_->self->priv->item_factory;
		_data_->_tmp61_ = _data_->actual_object;
		_data_->_tmp62_ = rygel_external_media_object_proxy_get_object_type (_data_->_tmp61_);
		_data_->_tmp63_ = _data_->_tmp62_;
		_data_->_tmp64_ = _data_->_tmp63_;
		_data_->_tmp65_ = _data_->actual_object;
		_data_->_tmp66_ = rygel_external_media_object_proxy_get_display_name (_data_->_tmp65_);
		_data_->_tmp67_ = _data_->_tmp66_;
		_data_->_tmp68_ = _data_->_tmp67_;
		_data_->_tmp69_ = _data_->_vala1_props;
		_data_->_tmp70_ = _data_->self->service_name;
		_data_->_tmp71_ = _data_->parent_container;
		_data_->_state_ = 8;
		rygel_external_item_factory_create (_data_->_tmp60_, _data_->id, _data_->_tmp64_, _data_->_tmp68_, _data_->_tmp69_, _data_->_tmp70_, (RygelMediaContainer*) _data_->_tmp71_, rygel_external_container_find_object_ready, _data_);
		return FALSE;
		_state_8:
		_data_->_tmp72_ = rygel_external_item_factory_create_finish (_data_->_tmp60_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp73_ = _data_->_tmp72_;
		_g_free0 (_data_->_tmp68_);
		_g_free0 (_data_->_tmp64_);
		_data_->_tmp59_ = _data_->_tmp73_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_hash_table_unref0 (_data_->_vala1_props);
			_g_object_unref0 (_data_->_vala1_props_iface);
			_g_object_unref0 (_data_->parent_container);
			_g_object_unref0 (_data_->actual_object);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp74_ = _data_->_tmp59_;
		_data_->_tmp59_ = NULL;
		_g_object_unref0 (_data_->media_object);
		_data_->media_object = (RygelMediaObject*) _data_->_tmp74_;
		_g_object_unref0 (_data_->_tmp59_);
		_g_hash_table_unref0 (_data_->_vala1_props);
		_g_object_unref0 (_data_->_vala1_props_iface);
		_g_object_unref0 (_data_->parent_container);
	}
	_data_->result = _data_->media_object;
	_g_object_unref0 (_data_->actual_object);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_external_container_create_media_objects_data_free (gpointer _data)
{
	RygelExternalContainerCreateMediaObjectsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->parent);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelExternalContainerCreateMediaObjectsData, _data_);
}

static void
rygel_external_container_create_media_objects (RygelExternalContainer* self,
                                               GHashTable** all_props,
                                               gint all_props_length1,
                                               RygelMediaContainer* parent,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	RygelExternalContainerCreateMediaObjectsData* _data_;
	RygelExternalContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	_data_ = g_slice_new0 (RygelExternalContainerCreateMediaObjectsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_container_create_media_objects_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->all_props = all_props;
	_data_->all_props_length1 = all_props_length1;
	_tmp1_ = _g_object_ref0 (parent);
	_g_object_unref0 (_data_->parent);
	_data_->parent = _tmp1_;
	rygel_external_container_create_media_objects_co (_data_);
}

static RygelMediaObjects*
rygel_external_container_create_media_objects_finish (RygelExternalContainer* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	RygelMediaObjects* result;
	RygelExternalContainerCreateMediaObjectsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static gchar*
_variant_get4 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get5 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get6 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static guint
_variant_get7 (GVariant* value)
{
	return g_variant_get_uint32 (value);
}

static void
rygel_external_container_create_media_objects_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	RygelExternalContainerCreateMediaObjectsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_external_container_create_media_objects_co (_data_);
}

static gboolean
rygel_external_container_create_media_objects_co (RygelExternalContainerCreateMediaObjectsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_objects_new ();
	_data_->media_objects = _data_->_tmp0_;
	{
		_data_->props_collection_length1 = 0;
		_data_->_props_collection_size_ = 0;
		_data_->props_collection = _data_->all_props;
		_data_->props_collection_length1 = _data_->all_props_length1;
		for (_data_->props_it = 0; _data_->props_it < _data_->props_collection_length1; _data_->props_it = _data_->props_it + 1) {
			_data_->_tmp1_ = _g_hash_table_ref0 (_data_->props_collection[_data_->props_it]);
			_data_->props = _data_->_tmp1_;
			{
				_data_->_tmp2_ = _data_->props;
				_data_->_tmp3_ = g_hash_table_lookup (_data_->_tmp2_, "Path");
				_data_->_tmp4_ = _variant_get4 ((GVariant*) _data_->_tmp3_);
				_data_->id = _data_->_tmp4_;
				_data_->_tmp5_ = _data_->props;
				_data_->_tmp6_ = g_hash_table_lookup (_data_->_tmp5_, "Type");
				_data_->_tmp7_ = _variant_get5 ((GVariant*) _data_->_tmp6_);
				_data_->type = _data_->_tmp7_;
				if (_data_->parent != NULL) {
					_data_->_tmp8_ = _g_object_ref0 (_data_->parent);
					_g_object_unref0 (_data_->parent_container);
					_data_->parent_container = _data_->_tmp8_;
				} else {
					_data_->_tmp9_ = _data_->props;
					_data_->_tmp10_ = g_hash_table_lookup (_data_->_tmp9_, "Parent");
					_data_->_tmp11_ = _variant_get6 ((GVariant*) _data_->_tmp10_);
					_data_->parent_id = _data_->_tmp11_;
					_data_->_tmp12_ = _data_->parent_id;
					_data_->_tmp13_ = rygel_external_dummy_container_new (_data_->_tmp12_, "LaLaLa", (guint) 0, NULL);
					_g_object_unref0 (_data_->parent_container);
					_data_->parent_container = (RygelMediaContainer*) _data_->_tmp13_;
					_g_free0 (_data_->parent_id);
				}
				_data_->media_object = NULL;
				_data_->_tmp14_ = _data_->type;
				if (g_strcmp0 (_data_->_tmp14_, "container") == 0) {
					_data_->_tmp15_ = _data_->id;
					_data_->_tmp16_ = rygel_external_container_find_container_by_id (_data_->self, _data_->_tmp15_);
					_g_object_unref0 (_data_->media_object);
					_data_->media_object = (RygelMediaObject*) _data_->_tmp16_;
				}
				_data_->_tmp17_ = _data_->media_object;
				if (_data_->_tmp17_ == NULL) {
					_data_->_tmp18_ = _data_->props;
					_data_->_tmp19_ = _data_->id;
					_data_->_tmp20_ = _data_->self->service_name;
					_data_->_tmp21_ = rygel_external_get_mandatory_string_value (_data_->_tmp18_, "DisplayName", _data_->_tmp19_, _data_->_tmp20_);
					_data_->title = _data_->_tmp21_;
					_data_->_tmp22_ = _data_->type;
					if (g_strcmp0 (_data_->_tmp22_, "container") == 0) {
						_data_->_tmp23_ = _data_->props;
						_data_->_tmp24_ = g_hash_table_lookup (_data_->_tmp23_, "ChildCount");
						_data_->_tmp25_ = _variant_get7 ((GVariant*) _data_->_tmp24_);
						_data_->child_count = _data_->_tmp25_;
						_data_->_tmp26_ = _data_->id;
						_data_->_tmp27_ = _data_->title;
						_data_->_tmp28_ = _data_->parent_container;
						_data_->_tmp29_ = rygel_external_dummy_container_new (_data_->_tmp26_, _data_->_tmp27_, _data_->child_count, _data_->_tmp28_);
						_g_object_unref0 (_data_->media_object);
						_data_->media_object = (RygelMediaObject*) _data_->_tmp29_;
					} else {
						_data_->_tmp31_ = _data_->self->priv->item_factory;
						_data_->_tmp32_ = _data_->id;
						_data_->_tmp33_ = _data_->type;
						_data_->_tmp34_ = _data_->title;
						_data_->_tmp35_ = _data_->props;
						_data_->_tmp36_ = _data_->self->service_name;
						_data_->_tmp37_ = _data_->parent_container;
						_data_->_state_ = 1;
						rygel_external_item_factory_create (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_, _data_->_tmp34_, _data_->_tmp35_, _data_->_tmp36_, _data_->_tmp37_, rygel_external_container_create_media_objects_ready, _data_);
						return FALSE;
						_state_1:
						_data_->_tmp38_ = rygel_external_item_factory_create_finish (_data_->_tmp31_, _data_->_res_, &_data_->_inner_error0_);
						_data_->_tmp30_ = _data_->_tmp38_;
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							_g_free0 (_data_->title);
							_g_object_unref0 (_data_->media_object);
							_g_object_unref0 (_data_->parent_container);
							_g_free0 (_data_->type);
							_g_free0 (_data_->id);
							_g_hash_table_unref0 (_data_->props);
							_g_object_unref0 (_data_->media_objects);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
						_data_->_tmp39_ = _data_->_tmp30_;
						_data_->_tmp30_ = NULL;
						_g_object_unref0 (_data_->media_object);
						_data_->media_object = (RygelMediaObject*) _data_->_tmp39_;
						_g_object_unref0 (_data_->_tmp30_);
					}
					_g_free0 (_data_->title);
				}
				_data_->_tmp40_ = _data_->media_objects;
				_data_->_tmp41_ = _data_->media_object;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp40_, _data_->_tmp41_);
				_g_object_unref0 (_data_->media_object);
				_g_object_unref0 (_data_->parent_container);
				_g_free0 (_data_->type);
				_g_free0 (_data_->id);
				_g_hash_table_unref0 (_data_->props);
			}
		}
	}
	_data_->result = _data_->media_objects;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_external_container_refresh_child_containers_data_free (gpointer _data)
{
	RygelExternalContainerRefreshChildContainersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelExternalContainerRefreshChildContainersData, _data_);
}

static void
rygel_external_container_refresh_child_containers (RygelExternalContainer* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	RygelExternalContainerRefreshChildContainersData* _data_;
	RygelExternalContainer* _tmp0_;
	_data_ = g_slice_new0 (RygelExternalContainerRefreshChildContainersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_container_refresh_child_containers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_external_container_refresh_child_containers_co (_data_);
}

static void
rygel_external_container_refresh_child_containers_finish (RygelExternalContainer* self,
                                                          GAsyncResult* _res_,
                                                          GError** error)
{
	RygelExternalContainerRefreshChildContainersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
_vala_array_add7 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
rygel_external_container_refresh_child_containers_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	RygelExternalContainerRefreshChildContainersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_external_container_refresh_child_containers_co (_data_);
}

static gchar*
_variant_get8 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get9 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static guint
_variant_get10 (GVariant* value)
{
	return g_variant_get_uint32 (value);
}

static gboolean
_variant_get11 (GVariant* value)
{
	return g_variant_get_boolean (value);
}

static gboolean
rygel_external_container_refresh_child_containers_co (RygelExternalContainerRefreshChildContainersData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data_->filter = _data_->_tmp0_;
	_data_->filter_length1 = 0;
	_data_->_filter_size_ = _data_->filter_length1;
	{
		_data_->object_prop_collection_length1 = 0;
		_data_->_object_prop_collection_size_ = 0;
		_data_->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
		_data_->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
		for (_data_->object_prop_it = 0; _data_->object_prop_it < _data_->object_prop_collection_length1; _data_->object_prop_it = _data_->object_prop_it + 1) {
			_data_->object_prop = _data_->object_prop_collection[_data_->object_prop_it];
			{
				_data_->_tmp1_ = _data_->filter;
				_data_->_tmp1__length1 = _data_->filter_length1;
				_data_->_tmp2_ = _data_->object_prop;
				_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
				_vala_array_add7 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp3_);
			}
		}
	}
	{
		_data_->container_prop_collection_length1 = 0;
		_data_->_container_prop_collection_size_ = 0;
		_data_->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
		_data_->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
		for (_data_->container_prop_it = 0; _data_->container_prop_it < _data_->container_prop_collection_length1; _data_->container_prop_it = _data_->container_prop_it + 1) {
			_data_->container_prop = _data_->container_prop_collection[_data_->container_prop_it];
			{
				_data_->_tmp4_ = _data_->filter;
				_data_->_tmp4__length1 = _data_->filter_length1;
				_data_->_tmp5_ = _data_->container_prop;
				_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
				_vala_array_add8 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp6_);
			}
		}
	}
	_data_->_tmp7_ = _data_->self->actual_container;
	_data_->_tmp8_ = _data_->filter;
	_data_->_tmp8__length1 = _data_->filter_length1;
	_data_->_tmp9_ = 0;
	_data_->_state_ = 1;
	rygel_external_media_container_proxy_list_containers (_data_->_tmp7_, (guint) 0, (guint) 0, _data_->_tmp8_, (gint) _data_->_tmp8__length1, rygel_external_container_refresh_child_containers_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp10_ = rygel_external_media_container_proxy_list_containers_finish (_data_->_tmp7_, _data_->_res_, &_data_->_tmp9_, &_data_->_inner_error0_);
	_data_->children_props = _data_->_tmp10_;
	_data_->children_props_length1 = _data_->_tmp9_;
	_data_->_children_props_size_ = _data_->children_props_length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->self->priv->containers;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _data_->_tmp11_);
	_data_->_tmp12_ = _data_->children_props;
	_data_->_tmp12__length1 = _data_->children_props_length1;
	{
		_data_->props_collection_length1 = 0;
		_data_->_props_collection_size_ = 0;
		_data_->props_collection = _data_->_tmp12_;
		_data_->props_collection_length1 = _data_->_tmp12__length1;
		for (_data_->props_it = 0; _data_->props_it < _data_->props_collection_length1; _data_->props_it = _data_->props_it + 1) {
			_data_->_tmp13_ = _g_hash_table_ref0 (_data_->props_collection[_data_->props_it]);
			_data_->props = _data_->_tmp13_;
			{
				_data_->_tmp14_ = _data_->props;
				_data_->_tmp15_ = g_hash_table_lookup (_data_->_tmp14_, "Path");
				_data_->_tmp16_ = _variant_get8 ((GVariant*) _data_->_tmp15_);
				_data_->path = _data_->_tmp16_;
				_data_->_tmp17_ = _data_->props;
				_data_->_tmp18_ = g_hash_table_lookup (_data_->_tmp17_, "DisplayName");
				_data_->_tmp19_ = _variant_get9 ((GVariant*) _data_->_tmp18_);
				_data_->title = _data_->_tmp19_;
				_data_->_tmp20_ = _data_->props;
				_data_->_tmp21_ = g_hash_table_lookup (_data_->_tmp20_, "ChildCount");
				_data_->_tmp22_ = _variant_get10 ((GVariant*) _data_->_tmp21_);
				_data_->child_count = _data_->_tmp22_;
				_data_->_tmp23_ = _data_->props;
				_data_->_tmp24_ = g_hash_table_lookup (_data_->_tmp23_, "Searchable");
				_data_->_tmp25_ = _variant_get11 ((GVariant*) _data_->_tmp24_);
				_data_->searchable = _data_->_tmp25_;
				_data_->_tmp26_ = _data_->path;
				_data_->_tmp27_ = _data_->title;
				_data_->_tmp28_ = _data_->self->service_name;
				_data_->_tmp29_ = _data_->path;
				_data_->_tmp30_ = rygel_external_container_new (_data_->_tmp26_, _data_->_tmp27_, _data_->child_count, _data_->searchable, _data_->_tmp28_, _data_->_tmp29_, _data_->self, &_data_->_inner_error0_);
				_data_->container = _data_->_tmp30_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_free0 (_data_->title);
					_g_free0 (_data_->path);
					_g_hash_table_unref0 (_data_->props);
					_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
					_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp31_ = _data_->self->priv->containers;
				_data_->_tmp32_ = _data_->container;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp31_, _data_->_tmp32_);
				_g_object_unref0 (_data_->container);
				_g_free0 (_data_->title);
				_g_free0 (_data_->path);
				_g_hash_table_unref0 (_data_->props);
			}
		}
	}
	_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_external_container_update_container_data_free (gpointer _data)
{
	RygelExternalContainerUpdateContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelExternalContainerUpdateContainerData, _data_);
}

static void
rygel_external_container_update_container (RygelExternalContainer* self,
                                           gboolean connect_signal,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	RygelExternalContainerUpdateContainerData* _data_;
	RygelExternalContainer* _tmp0_;
	_data_ = g_slice_new0 (RygelExternalContainerUpdateContainerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_container_update_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->connect_signal = connect_signal;
	rygel_external_container_update_container_co (_data_);
}

static void
rygel_external_container_update_container_finish (RygelExternalContainer* self,
                                                  GAsyncResult* _res_)
{
	RygelExternalContainerUpdateContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_external_container_update_container_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	RygelExternalContainerUpdateContainerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_external_container_update_container_co (_data_);
}

static guint
_variant_get12 (GVariant* value)
{
	return g_variant_get_uint32 (value);
}

static void
_rygel_external_container_on_updated_rygel_external_media_container_proxy_updated (RygelExternalMediaContainerProxy* _sender,
                                                                                   gpointer self)
{
	rygel_external_container_on_updated ((RygelExternalContainer*) self, _sender);
}

static gboolean
rygel_external_container_update_container_co (RygelExternalContainerUpdateContainerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->service_name;
		_data_->_tmp1_ = _data_->self->actual_container;
		_data_->_tmp2_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _data_->_tmp1_);
		_data_->_state_ = 1;
		g_async_initable_new_async (RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES_PROXY, 0, NULL, rygel_external_container_update_container_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _data_->_tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp2_, "g-interface-name", "org.freedesktop.DBus.Properties", "g-interface-info", g_type_get_qdata (RYGEL_EXTERNAL_FREE_DESKTOP_TYPE_PROPERTIES, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = (RygelExternalFreeDesktopProperties*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->props_iface = (RygelExternalFreeDesktopProperties*) _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->props_iface;
		_data_->_state_ = 2;
		rygel_external_free_desktop_properties_get_all (_data_->_tmp4_, RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_IFACE, rygel_external_container_update_container_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp5_ = rygel_external_free_desktop_properties_get_all_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		_data_->props = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->props_iface);
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->props;
		_data_->_tmp7_ = g_hash_table_lookup (_data_->_tmp6_, "ChildCount");
		_data_->_tmp8_ = _variant_get12 ((GVariant*) _data_->_tmp7_);
		_data_->child_count = _data_->_tmp8_;
		if (_data_->child_count < ((guint) G_MAXINT)) {
			rygel_media_container_set_child_count ((RygelMediaContainer*) _data_->self, (gint) _data_->child_count);
		}
		_data_->_tmp10_ = _data_->props_iface;
		_data_->_state_ = 3;
		rygel_external_free_desktop_properties_get_all (_data_->_tmp10_, RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_IFACE, rygel_external_container_update_container_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp11_ = rygel_external_free_desktop_properties_get_all_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp9_ = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_hash_table_unref0 (_data_->props);
			_g_object_unref0 (_data_->props_iface);
			goto __catch0_g_error;
		}
		_data_->_tmp12_ = _data_->_tmp9_;
		_data_->_tmp9_ = NULL;
		_g_hash_table_unref0 (_data_->props);
		_data_->props = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->props;
		_data_->_tmp14_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = _data_->self->service_name;
		_data_->_tmp17_ = rygel_external_get_mandatory_string_value (_data_->_tmp13_, "DisplayName", _data_->_tmp15_, _data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		rygel_media_object_set_title ((RygelMediaObject*) _data_->self, _data_->_tmp18_);
		_g_free0 (_data_->_tmp18_);
		_g_hash_table_unref0 (_data_->_tmp9_);
		_g_hash_table_unref0 (_data_->props);
		_g_object_unref0 (_data_->props_iface);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->property_error = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp19_ = _data_->self->actual_container;
		_data_->_tmp20_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _data_->_tmp19_);
		_data_->_tmp21_ = _data_->property_error;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_warning ("rygel-external-container.vala:349: Failed to update information about " \
"container '%s': %s", _data_->_tmp20_, _data_->_tmp22_);
		_g_error_free0 (_data_->property_error);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp23_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp24_ = _data_->_tmp23_;
		if (_data_->_tmp24_ < G_MAXINT) {
			_data_->_state_ = 4;
			rygel_external_container_refresh_child_containers (_data_->self, rygel_external_container_update_container_ready, _data_);
			return FALSE;
			_state_4:
			rygel_external_container_refresh_child_containers_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp25_ = _data_->self->actual_container;
		_data_->_tmp26_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _data_->_tmp25_);
		_data_->_tmp27_ = _data_->err;
		_data_->_tmp28_ = _data_->_tmp27_->message;
		g_warning ("rygel-external-container.vala:360: Failed to update information about " \
"container '%s': %s", _data_->_tmp26_, _data_->_tmp28_);
		_g_error_free0 (_data_->err);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	if (_data_->connect_signal) {
		_data_->_tmp29_ = _data_->self->actual_container;
		g_signal_connect_object (_data_->_tmp29_, "updated", (GCallback) _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated, _data_->self, 0);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_external_container_on_updated (RygelExternalContainer* self,
                                     RygelExternalMediaContainerProxy* actual_container)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (actual_container != NULL);
	rygel_external_container_update_container (self, FALSE, NULL, NULL);
}

static RygelMediaContainer*
rygel_external_container_find_container_by_id (RygelExternalContainer* self,
                                               const gchar* id)
{
	RygelMediaContainer* target = NULL;
	RygelMediaContainer* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	target = NULL;
	{
		GeeArrayList* _container_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _container_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _container_index = 0;
		_tmp0_ = self->priv->containers;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_container_list = _tmp1_;
		_tmp2_ = _container_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_container_size = _tmp4_;
		_container_index = -1;
		while (TRUE) {
			RygelExternalContainer* container = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			RygelExternalContainer* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_container_index = _container_index + 1;
			if (!(_container_index < _container_size)) {
				break;
			}
			_tmp5_ = _container_list;
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _container_index);
			container = (RygelExternalContainer*) _tmp6_;
			_tmp7_ = container;
			_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
			_tmp9_ = _tmp8_;
			if (g_strcmp0 (_tmp9_, id) == 0) {
				RygelExternalContainer* _tmp10_;
				RygelMediaContainer* _tmp11_;
				_tmp10_ = container;
				_tmp11_ = _g_object_ref0 ((RygelMediaContainer*) _tmp10_);
				_g_object_unref0 (target);
				target = _tmp11_;
				_g_object_unref0 (container);
				break;
			}
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_list);
	}
	result = target;
	return result;
}

static RygelSearchExpression*
rygel_external_container_translate_expression (RygelExternalContainer* self,
                                               RygelSearchExpression* upnp_expression)
{
	RygelSearchExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (upnp_expression != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (upnp_expression, RYGEL_TYPE_RELATIONAL_EXPRESSION)) {
		RygelRelationalExpression* expression = NULL;
		RygelRelationalExpression* _tmp0_;
		RygelRelationalExpression* ext_expression = NULL;
		RygelRelationalExpression* _tmp1_;
		RygelRelationalExpression* _tmp2_;
		RygelRelationalExpression* _tmp3_;
		gconstpointer _tmp4_;
		RygelRelationalExpression* _tmp5_;
		RygelRelationalExpression* _tmp6_;
		gconstpointer _tmp7_;
		gchar* _tmp8_;
		RygelRelationalExpression* _tmp9_;
		RygelRelationalExpression* _tmp10_;
		gconstpointer _tmp11_;
		gchar* _tmp12_;
		_tmp0_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (upnp_expression, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) upnp_expression) : NULL);
		expression = _tmp0_;
		_tmp1_ = rygel_relational_expression_new ();
		ext_expression = _tmp1_;
		_tmp2_ = ext_expression;
		_tmp3_ = expression;
		_tmp4_ = ((RygelSearchExpression*) _tmp3_)->op;
		((RygelSearchExpression*) _tmp2_)->op = (gpointer) ((gintptr) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp4_)));
		_tmp5_ = ext_expression;
		_tmp6_ = expression;
		_tmp7_ = ((RygelSearchExpression*) _tmp6_)->operand1;
		_tmp8_ = rygel_external_container_translate_property (self, (const gchar*) _tmp7_);
		_g_free0 (((RygelSearchExpression*) _tmp5_)->operand1);
		((RygelSearchExpression*) _tmp5_)->operand1 = _tmp8_;
		_tmp9_ = ext_expression;
		_tmp10_ = expression;
		_tmp11_ = ((RygelSearchExpression*) _tmp10_)->operand2;
		_tmp12_ = g_strdup ((const gchar*) _tmp11_);
		_g_free0 (((RygelSearchExpression*) _tmp9_)->operand2);
		((RygelSearchExpression*) _tmp9_)->operand2 = _tmp12_;
		result = (RygelSearchExpression*) ext_expression;
		_rygel_search_expression_unref0 (expression);
		return result;
	} else {
		RygelLogicalExpression* expression = NULL;
		RygelLogicalExpression* _tmp13_;
		RygelLogicalExpression* ext_expression = NULL;
		RygelLogicalExpression* _tmp14_;
		RygelLogicalExpression* _tmp15_;
		RygelLogicalExpression* _tmp16_;
		gconstpointer _tmp17_;
		RygelLogicalExpression* _tmp18_;
		RygelLogicalExpression* _tmp19_;
		gconstpointer _tmp20_;
		RygelSearchExpression* _tmp21_;
		RygelLogicalExpression* _tmp22_;
		RygelLogicalExpression* _tmp23_;
		gconstpointer _tmp24_;
		RygelSearchExpression* _tmp25_;
		_tmp13_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (upnp_expression, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) upnp_expression) : NULL);
		expression = _tmp13_;
		_tmp14_ = rygel_logical_expression_new ();
		ext_expression = _tmp14_;
		_tmp15_ = ext_expression;
		_tmp16_ = expression;
		_tmp17_ = ((RygelSearchExpression*) _tmp16_)->op;
		((RygelSearchExpression*) _tmp15_)->op = (gpointer) ((gintptr) ((RygelLogicalOperator) ((gintptr) _tmp17_)));
		_tmp18_ = ext_expression;
		_tmp19_ = expression;
		_tmp20_ = ((RygelSearchExpression*) _tmp19_)->operand1;
		_tmp21_ = rygel_external_container_translate_expression (self, (RygelSearchExpression*) _tmp20_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp18_)->operand1);
		((RygelSearchExpression*) _tmp18_)->operand1 = _tmp21_;
		_tmp22_ = ext_expression;
		_tmp23_ = expression;
		_tmp24_ = ((RygelSearchExpression*) _tmp23_)->operand2;
		_tmp25_ = rygel_external_container_translate_expression (self, (RygelSearchExpression*) _tmp24_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp22_)->operand2);
		((RygelSearchExpression*) _tmp22_)->operand2 = _tmp25_;
		result = (RygelSearchExpression*) ext_expression;
		_rygel_search_expression_unref0 (expression);
		return result;
	}
}

gchar*
rygel_external_container_translate_property (RygelExternalContainer* self,
                                             const gchar* property)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (property != NULL, NULL);
	_tmp0_ = property;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("Path");
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("Parent");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("DisplayName");
				result = _tmp5_;
				return result;
			}
		}
	} else if (((_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("dc:creator")))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("upnp:artist"))))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("upnp:author"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("Artist");
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("Album");
				result = _tmp7_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup (property);
				result = _tmp8_;
				return result;
			}
		}
	}
}

static GeeArrayList*
rygel_external_container_real_get_search_classes (RygelSearchableContainer* base)
{
	GeeArrayList* result;
	RygelExternalContainer* self;
	GeeArrayList* _tmp0_;
	self = (RygelExternalContainer*) base;
	_tmp0_ = self->priv->_search_classes;
	result = _tmp0_;
	return result;
}

static void
rygel_external_container_real_set_search_classes (RygelSearchableContainer* base,
                                                  GeeArrayList* value)
{
	RygelExternalContainer* self;
	self = (RygelExternalContainer*) base;
	if (rygel_external_container_real_get_search_classes (base) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_search_classes);
		self->priv->_search_classes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_external_container_properties[RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES_PROPERTY]);
	}
}

static void
rygel_external_container_class_init (RygelExternalContainerClass * klass,
                                     gpointer klass_data)
{
	rygel_external_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelExternalContainer_private_offset);
	((RygelMediaContainerClass *) klass)->get_children = (void (*) (RygelMediaContainer*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_external_container_real_get_children;
	((RygelMediaContainerClass *) klass)->get_children_finish = (RygelMediaObjects* (*) (RygelMediaContainer*, GAsyncResult*, GError**)) rygel_external_container_get_children_finish;
	((RygelMediaContainerClass *) klass)->find_object = (void (*) (RygelMediaContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_external_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = (RygelMediaObject* (*) (RygelMediaContainer*, GAsyncResult*, GError**)) rygel_external_container_find_object_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_external_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_external_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_external_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES_PROPERTY, rygel_external_container_properties[RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES_PROPERTY] = g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_external_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface,
                                                                    gpointer iface_data)
{
	rygel_external_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (RygelSearchableContainer*, RygelSearchExpression*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_external_container_real_search;
	iface->search_finish = (RygelMediaObjects* (*) (RygelSearchableContainer*, GAsyncResult*, guint*, GError**)) rygel_external_container_search_finish;
	iface->get_search_classes = rygel_external_container_real_get_search_classes;
	iface->set_search_classes = rygel_external_container_real_set_search_classes;
}

static void
rygel_external_container_instance_init (RygelExternalContainer * self,
                                        gpointer klass)
{
	self->priv = rygel_external_container_get_instance_private (self);
}

static void
rygel_external_container_finalize (GObject * obj)
{
	RygelExternalContainer * self;
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer);
	_tmp0_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		RygelMediaContainer* _tmp2_;
		RygelMediaContainer* _tmp3_;
		_tmp2_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
		_tmp3_ = _tmp2_;
		g_object_remove_weak_pointer ((GObject*) _tmp3_, &((RygelMediaObject*) self)->parent_ptr);
	}
	_g_object_unref0 (self->actual_container);
	_g_free0 (self->service_name);
	_rygel_external_item_factory_unref0 (self->priv->item_factory);
	_g_object_unref0 (self->priv->containers);
	_g_object_unref0 (self->priv->_search_classes);
	G_OBJECT_CLASS (rygel_external_container_parent_class)->finalize (obj);
}

/**
 * Represents an external container.
 */
GType
rygel_external_container_get_type (void)
{
	static volatile gsize rygel_external_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalContainer), 0, (GInstanceInitFunc) rygel_external_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_external_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_external_container_type_id;
		rygel_external_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelExternalContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_external_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		RygelExternalContainer_private_offset = g_type_add_instance_private (rygel_external_container_type_id, sizeof (RygelExternalContainerPrivate));
		g_once_init_leave (&rygel_external_container_type_id__volatile, rygel_external_container_type_id);
	}
	return rygel_external_container_type_id__volatile;
}

static void
_vala_rygel_external_container_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	RygelExternalContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer);
	switch (property_id) {
		case RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES_PROPERTY:
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_external_container_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	RygelExternalContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer);
	switch (property_id) {
		case RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES_PROPERTY:
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

