/*
* Copyright (C) 2011 The Android Open Source Project
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
#ifndef _GLES_DISPATCH_H
#define _GLES_DISPATCH_H

#include "gl_proc.h"


struct GLDispatch {
    glAlphaFunc_t glAlphaFunc;
    glClearColor_t glClearColor;
    glClearDepthf_t glClearDepthf;
    glClipPlanef_t glClipPlanef;
    glColor4f_t glColor4f;
    glDepthRangef_t glDepthRangef;
    glFogf_t glFogf;
    glFogfv_t glFogfv;
    glFrustumf_t glFrustumf;
    glGetClipPlanef_t glGetClipPlanef;
    glGetFloatv_t glGetFloatv;
    glGetLightfv_t glGetLightfv;
    glGetMaterialfv_t glGetMaterialfv;
    glGetTexEnvfv_t glGetTexEnvfv;
    glGetTexParameterfv_t glGetTexParameterfv;
    glLightModelf_t glLightModelf;
    glLightModelfv_t glLightModelfv;
    glLightf_t glLightf;
    glLightfv_t glLightfv;
    glLineWidth_t glLineWidth;
    glLoadMatrixf_t glLoadMatrixf;
    glMaterialf_t glMaterialf;
    glMaterialfv_t glMaterialfv;
    glMultMatrixf_t glMultMatrixf;
    glMultiTexCoord4f_t glMultiTexCoord4f;
    glNormal3f_t glNormal3f;
    glOrthof_t glOrthof;
    glPointParameterf_t glPointParameterf;
    glPointParameterfv_t glPointParameterfv;
    glPointSize_t glPointSize;
    glPolygonOffset_t glPolygonOffset;
    glRotatef_t glRotatef;
    glScalef_t glScalef;
    glTexEnvf_t glTexEnvf;
    glTexEnvfv_t glTexEnvfv;
    glTexParameterf_t glTexParameterf;
    glTexParameterfv_t glTexParameterfv;
    glTranslatef_t glTranslatef;
    glActiveTexture_t glActiveTexture;
    glAlphaFuncx_t glAlphaFuncx;
    glBindBuffer_t glBindBuffer;
    glBindTexture_t glBindTexture;
    glBlendFunc_t glBlendFunc;
    glBufferData_t glBufferData;
    glBufferSubData_t glBufferSubData;
    glClear_t glClear;
    glClearColorx_t glClearColorx;
    glClearDepthx_t glClearDepthx;
    glClearStencil_t glClearStencil;
    glClientActiveTexture_t glClientActiveTexture;
    glClipPlanex_t glClipPlanex;
    glColor4ub_t glColor4ub;
    glColor4x_t glColor4x;
    glColorMask_t glColorMask;
    glColorPointer_t glColorPointer;
    glCompressedTexImage2D_t glCompressedTexImage2D;
    glCompressedTexSubImage2D_t glCompressedTexSubImage2D;
    glCopyTexImage2D_t glCopyTexImage2D;
    glCopyTexSubImage2D_t glCopyTexSubImage2D;
    glCullFace_t glCullFace;
    glDeleteBuffers_t glDeleteBuffers;
    glDeleteTextures_t glDeleteTextures;
    glDepthFunc_t glDepthFunc;
    glDepthMask_t glDepthMask;
    glDepthRangex_t glDepthRangex;
    glDisable_t glDisable;
    glDisableClientState_t glDisableClientState;
    glDrawArrays_t glDrawArrays;
    glDrawElements_t glDrawElements;
    glEnable_t glEnable;
    glEnableClientState_t glEnableClientState;
    glFinish_t glFinish;
    glFlush_t glFlush;
    glFogx_t glFogx;
    glFogxv_t glFogxv;
    glFrontFace_t glFrontFace;
    glFrustumx_t glFrustumx;
    glGetBooleanv_t glGetBooleanv;
    glGetBufferParameteriv_t glGetBufferParameteriv;
    glGetClipPlanex_t glGetClipPlanex;
    glGenBuffers_t glGenBuffers;
    glGenTextures_t glGenTextures;
    glGetError_t glGetError;
    glGetFixedv_t glGetFixedv;
    glGetIntegerv_t glGetIntegerv;
    glGetLightxv_t glGetLightxv;
    glGetMaterialxv_t glGetMaterialxv;
    glGetPointerv_t glGetPointerv;
    glGetString_t glGetString;
    glGetTexEnviv_t glGetTexEnviv;
    glGetTexEnvxv_t glGetTexEnvxv;
    glGetTexParameteriv_t glGetTexParameteriv;
    glGetTexParameterxv_t glGetTexParameterxv;
    glHint_t glHint;
    glIsBuffer_t glIsBuffer;
    glIsEnabled_t glIsEnabled;
    glIsTexture_t glIsTexture;
    glLightModelx_t glLightModelx;
    glLightModelxv_t glLightModelxv;
    glLightx_t glLightx;
    glLightxv_t glLightxv;
    glLineWidthx_t glLineWidthx;
    glLoadIdentity_t glLoadIdentity;
    glLoadMatrixx_t glLoadMatrixx;
    glLogicOp_t glLogicOp;
    glMaterialx_t glMaterialx;
    glMaterialxv_t glMaterialxv;
    glMatrixMode_t glMatrixMode;
    glMultMatrixx_t glMultMatrixx;
    glMultiTexCoord4x_t glMultiTexCoord4x;
    glNormal3x_t glNormal3x;
    glNormalPointer_t glNormalPointer;
    glOrthox_t glOrthox;
    glPixelStorei_t glPixelStorei;
    glPointParameterx_t glPointParameterx;
    glPointParameterxv_t glPointParameterxv;
    glPointSizex_t glPointSizex;
    glPolygonOffsetx_t glPolygonOffsetx;
    glPopMatrix_t glPopMatrix;
    glPushMatrix_t glPushMatrix;
    glReadPixels_t glReadPixels;
    glRotatex_t glRotatex;
    glSampleCoverage_t glSampleCoverage;
    glSampleCoveragex_t glSampleCoveragex;
    glScalex_t glScalex;
    glScissor_t glScissor;
    glShadeModel_t glShadeModel;
    glStencilFunc_t glStencilFunc;
    glStencilMask_t glStencilMask;
    glStencilOp_t glStencilOp;
    glTexCoordPointer_t glTexCoordPointer;
    glTexEnvi_t glTexEnvi;
    glTexEnvx_t glTexEnvx;
    glTexEnviv_t glTexEnviv;
    glTexEnvxv_t glTexEnvxv;
    glTexImage2D_t glTexImage2D;
    glTexParameteri_t glTexParameteri;
    glTexParameterx_t glTexParameterx;
    glTexParameteriv_t glTexParameteriv;
    glTexParameterxv_t glTexParameterxv;
    glTexSubImage2D_t glTexSubImage2D;
    glTranslatex_t glTranslatex;
    glVertexPointer_t glVertexPointer;
    glViewport_t glViewport;
    glPointSizePointerOES_t glPointSizePointerOES;
    glBlendEquationSeparateOES_t glBlendEquationSeparateOES;
    glBlendFuncSeparateOES_t glBlendFuncSeparateOES;
    glBlendEquationOES_t glBlendEquationOES;
    glDrawTexsOES_t glDrawTexsOES;
    glDrawTexiOES_t glDrawTexiOES;
    glDrawTexxOES_t glDrawTexxOES;
    glDrawTexsvOES_t glDrawTexsvOES;
    glDrawTexivOES_t glDrawTexivOES;
    glDrawTexxvOES_t glDrawTexxvOES;
    glDrawTexfOES_t glDrawTexfOES;
    glDrawTexfvOES_t glDrawTexfvOES;
    glEGLImageTargetTexture2DOES_t glEGLImageTargetTexture2DOES;
    glEGLImageTargetRenderbufferStorageOES_t glEGLImageTargetRenderbufferStorageOES;
    glAlphaFuncxOES_t glAlphaFuncxOES;
    glClearColorxOES_t glClearColorxOES;
    glClearDepthxOES_t glClearDepthxOES;
    glClipPlanexOES_t glClipPlanexOES;
    glColor4xOES_t glColor4xOES;
    glDepthRangexOES_t glDepthRangexOES;
    glFogxOES_t glFogxOES;
    glFogxvOES_t glFogxvOES;
    glFrustumxOES_t glFrustumxOES;
    glGetClipPlanexOES_t glGetClipPlanexOES;
    glGetFixedvOES_t glGetFixedvOES;
    glGetLightxvOES_t glGetLightxvOES;
    glGetMaterialxvOES_t glGetMaterialxvOES;
    glGetTexEnvxvOES_t glGetTexEnvxvOES;
    glGetTexParameterxvOES_t glGetTexParameterxvOES;
    glLightModelxOES_t glLightModelxOES;
    glLightModelxvOES_t glLightModelxvOES;
    glLightxOES_t glLightxOES;
    glLightxvOES_t glLightxvOES;
    glLineWidthxOES_t glLineWidthxOES;
    glLoadMatrixxOES_t glLoadMatrixxOES;
    glMaterialxOES_t glMaterialxOES;
    glMaterialxvOES_t glMaterialxvOES;
    glMultMatrixxOES_t glMultMatrixxOES;
    glMultiTexCoord4xOES_t glMultiTexCoord4xOES;
    glNormal3xOES_t glNormal3xOES;
    glOrthoxOES_t glOrthoxOES;
    glPointParameterxOES_t glPointParameterxOES;
    glPointParameterxvOES_t glPointParameterxvOES;
    glPointSizexOES_t glPointSizexOES;
    glPolygonOffsetxOES_t glPolygonOffsetxOES;
    glRotatexOES_t glRotatexOES;
    glSampleCoveragexOES_t glSampleCoveragexOES;
    glScalexOES_t glScalexOES;
    glTexEnvxOES_t glTexEnvxOES;
    glTexEnvxvOES_t glTexEnvxvOES;
    glTexParameterxOES_t glTexParameterxOES;
    glTexParameterxvOES_t glTexParameterxvOES;
    glTranslatexOES_t glTranslatexOES;
    glIsRenderbufferOES_t glIsRenderbufferOES;
    glBindRenderbufferOES_t glBindRenderbufferOES;
    glDeleteRenderbuffersOES_t glDeleteRenderbuffersOES;
    glGenRenderbuffersOES_t glGenRenderbuffersOES;
    glRenderbufferStorageOES_t glRenderbufferStorageOES;
    glGetRenderbufferParameterivOES_t glGetRenderbufferParameterivOES;
    glIsFramebufferOES_t glIsFramebufferOES;
    glBindFramebufferOES_t glBindFramebufferOES;
    glDeleteFramebuffersOES_t glDeleteFramebuffersOES;
    glGenFramebuffersOES_t glGenFramebuffersOES;
    glCheckFramebufferStatusOES_t glCheckFramebufferStatusOES;
    glFramebufferRenderbufferOES_t glFramebufferRenderbufferOES;
    glFramebufferTexture2DOES_t glFramebufferTexture2DOES;
    glGetFramebufferAttachmentParameterivOES_t glGetFramebufferAttachmentParameterivOES;
    glGenerateMipmapOES_t glGenerateMipmapOES;
    glMapBufferOES_t glMapBufferOES;
    glUnmapBufferOES_t glUnmapBufferOES;
    glGetBufferPointervOES_t glGetBufferPointervOES;
    glCurrentPaletteMatrixOES_t glCurrentPaletteMatrixOES;
    glLoadPaletteFromModelViewMatrixOES_t glLoadPaletteFromModelViewMatrixOES;
    glMatrixIndexPointerOES_t glMatrixIndexPointerOES;
    glWeightPointerOES_t glWeightPointerOES;
    glQueryMatrixxOES_t glQueryMatrixxOES;
    glDepthRangefOES_t glDepthRangefOES;
    glFrustumfOES_t glFrustumfOES;
    glOrthofOES_t glOrthofOES;
    glClipPlanefOES_t glClipPlanefOES;
    glGetClipPlanefOES_t glGetClipPlanefOES;
    glClearDepthfOES_t glClearDepthfOES;
    glTexGenfOES_t glTexGenfOES;
    glTexGenfvOES_t glTexGenfvOES;
    glTexGeniOES_t glTexGeniOES;
    glTexGenivOES_t glTexGenivOES;
    glTexGenxOES_t glTexGenxOES;
    glTexGenxvOES_t glTexGenxvOES;
    glGetTexGenfvOES_t glGetTexGenfvOES;
    glGetTexGenivOES_t glGetTexGenivOES;
    glGetTexGenxvOES_t glGetTexGenxvOES;
    glBindVertexArrayOES_t glBindVertexArrayOES;
    glDeleteVertexArraysOES_t glDeleteVertexArraysOES;
    glGenVertexArraysOES_t glGenVertexArraysOES;
    glIsVertexArrayOES_t glIsVertexArrayOES;
    glDiscardFramebufferEXT_t glDiscardFramebufferEXT;
    glMultiDrawArraysEXT_t glMultiDrawArraysEXT;
    glMultiDrawElementsEXT_t glMultiDrawElementsEXT;
    glClipPlanefIMG_t glClipPlanefIMG;
    glClipPlanexIMG_t glClipPlanexIMG;
    glRenderbufferStorageMultisampleIMG_t glRenderbufferStorageMultisampleIMG;
    glFramebufferTexture2DMultisampleIMG_t glFramebufferTexture2DMultisampleIMG;
    glDeleteFencesNV_t glDeleteFencesNV;
    glGenFencesNV_t glGenFencesNV;
    glIsFenceNV_t glIsFenceNV;
    glTestFenceNV_t glTestFenceNV;
    glGetFenceivNV_t glGetFenceivNV;
    glFinishFenceNV_t glFinishFenceNV;
    glSetFenceNV_t glSetFenceNV;
    glGetDriverControlsQCOM_t glGetDriverControlsQCOM;
    glGetDriverControlStringQCOM_t glGetDriverControlStringQCOM;
    glEnableDriverControlQCOM_t glEnableDriverControlQCOM;
    glDisableDriverControlQCOM_t glDisableDriverControlQCOM;
    glExtGetTexturesQCOM_t glExtGetTexturesQCOM;
    glExtGetBuffersQCOM_t glExtGetBuffersQCOM;
    glExtGetRenderbuffersQCOM_t glExtGetRenderbuffersQCOM;
    glExtGetFramebuffersQCOM_t glExtGetFramebuffersQCOM;
    glExtGetTexLevelParameterivQCOM_t glExtGetTexLevelParameterivQCOM;
    glExtTexObjectStateOverrideiQCOM_t glExtTexObjectStateOverrideiQCOM;
    glExtGetTexSubImageQCOM_t glExtGetTexSubImageQCOM;
    glExtGetBufferPointervQCOM_t glExtGetBufferPointervQCOM;
    glExtGetShadersQCOM_t glExtGetShadersQCOM;
    glExtGetProgramsQCOM_t glExtGetProgramsQCOM;
    glExtIsProgramBinaryQCOM_t glExtIsProgramBinaryQCOM;
    glExtGetProgramBinarySourceQCOM_t glExtGetProgramBinarySourceQCOM;
    glStartTilingQCOM_t glStartTilingQCOM;
    glEndTilingQCOM_t glEndTilingQCOM;
};

bool init_gl_dispatch();
void *gl_dispatch_get_proc_func(const char *name, void *userData);

extern GLDispatch s_gl;
#endif
