/*
 * Copyright (C) 2009 The Android Open Source Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <cstdlib>
#if defined BIONIC && !defined BIONIC_LIBSTDCPP_INCLUDE_CSTDLIB__
#error "Wrong header file included!!"
#endif


namespace {
const int kPassed = 0;
const int kFailed = 1;
#define FAIL_UNLESS(f) if (!android::f()) return kFailed;
}  // anonymous namespace

namespace android
{
using ::exit;
using ::abort;
using ::atexit;
using ::on_exit;

using ::getenv;
using ::putenv;
using ::setenv;
using ::unsetenv;
using ::clearenv;

using ::mktemp;
using ::mkstemp;

using ::strtol;
using ::strtoll;
using ::strtoul;
using ::strtoull;
using ::strtod;
using ::strtof;

using ::atoi;
using ::atol;
using ::atoll;
using ::atof;

using ::abs;
using ::labs;
using ::llabs;

using ::realpath;
using ::system;

using ::bsearch;
using ::qsort;

using ::jrand48;
using ::mrand48;
using ::nrand48;
using ::lrand48;
using ::seed48;
using ::srand48;

using ::rand;
using ::srand;
using ::random;
using ::srandom;

using ::malloc;
using ::free;
using ::calloc;
using ::realloc;

using ::unlockpt;
using ::ptsname;
using ::ptsname_r;
using ::getpt;
using ::grantpt;

using ::div_t;
using ::div;
using ::ldiv_t;
using ::ldiv;
using ::lldiv_t;
using ::lldiv;

using ::mblen;
using ::mbstowcs;
using ::mbtowc;
using ::wctomb;
using ::wcstombs;
}  // namespace android

int main(int argc, char **argv)
{
    //    FAIL_UNLESS(testTypesStd);
    return kPassed;
}
