########################################################################
#
#    Vision Macro - Python source code - file generated by vision
#    Thursday 01 July 2010 13:22:44 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/AutoDockTools/VisionInterface/Adt/Macro/AutodockVS.py,v 1.9 2010/07/02 00:22:59 jren Exp $
#
# $Id: AutodockVS.py,v 1.9 2010/07/02 00:22:59 jren Exp $
#

from NetworkEditor.macros import MacroNode
class AutodockVS(MacroNode):
    '''
    Runs Autodock Virtual Screening on remote server in parallel

    Inputs:
    port 1: LigandDB object containing info about the ligand library
    port 2: autogrid_result object containing info about autogrid results
    port 3: DPF template object
   
    Outputs:
    port 1: string containing URL to autodock virtual screening results
    '''

    def __init__(self, constrkw={}, name='AutodockVS', **kw):
        kw['name'] = name
        apply( MacroNode.__init__, (self,), kw)

    def beforeAddingToNetwork(self, net):
        MacroNode.beforeAddingToNetwork(self, net)
        from WebServices.VisionInterface.WSNodes import wslib
        from Vision.StandardNodes import stdlib
        net.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")
        from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
        try:
            addOpalServerAsCategory("http://kryptonite.nbcr.net/opal2", replace=False)
        except:
            pass

    def afterAddingToNetwork(self):
        masterNet = self.macroNetwork
        from NetworkEditor.macros import MacroNode
        MacroNode.afterAddingToNetwork(self)
        from WebServices.VisionInterface.WSNodes import wslib
        from Vision.StandardNodes import stdlib
        ## building macro network ##
        AutodockVS_9 = self
        from traceback import print_exc
        from WebServices.VisionInterface.WSNodes import wslib
        from Vision.StandardNodes import stdlib
        masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")
        from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
        try:
            addOpalServerAsCategory("http://kryptonite.nbcr.net/opal2", replace=False)
        except:
            pass
        try:
            ## saving node input Ports ##
            input_Ports_10 = self.macroNetwork.ipNode
            apply(input_Ports_10.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
        except:
            print "WARNING: failed to restore MacroInputNode named input Ports in network self.macroNetwork"
            print_exc()
            input_Ports_10=None

        try:
            ## saving node output Ports ##
            output_Ports_11 = self.macroNetwork.opNode
            apply(output_Ports_11.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
        except:
            print "WARNING: failed to restore MacroOutputNode named output Ports in network self.macroNetwork"
            print_exc()
            output_Ports_11=None

        try:
            ## saving node PrepareADVSInputs ##
            from Vision.StandardNodes import Generic
            PrepareADVSInputs_12 = Generic(constrkw={}, name='PrepareADVSInputs', library=stdlib)
            self.macroNetwork.addNode(PrepareADVSInputs_12,217,76)
            apply(PrepareADVSInputs_12.addInputPort, (), {'singleConnection': True, 'name': 'ligands', 'cast': True, 'datatype': 'LigandDB', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'rect', 'color': '#FFCCFF', 'originalDatatype': 'None'})
            apply(PrepareADVSInputs_12.addInputPort, (), {'singleConnection': True, 'name': 'autogrid_results', 'cast': True, 'datatype': 'autogrid_results', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'triangle', 'color': '#FF33CC', 'originalDatatype': 'None'})
            apply(PrepareADVSInputs_12.addInputPort, (), {'singleConnection': True, 'name': 'dpf_template_obj', 'cast': True, 'datatype': 'dpf_template', 'defaultValue': None, 'required': True, 'height': 8, 'width': 12, 'shape': 'triangle', 'color': '#9933FF', 'originalDatatype': 'None'})
            apply(PrepareADVSInputs_12.addOutputPort, (), {'name': 'filter_file', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
            apply(PrepareADVSInputs_12.addOutputPort, (), {'name': 'ligand_lib', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
            apply(PrepareADVSInputs_12.addOutputPort, (), {'name': 'dpf_template_file', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
            apply(PrepareADVSInputs_12.addOutputPort, (), {'name': 'autogrid_res_url', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
            apply(PrepareADVSInputs_12.addOutputPort, (), {'name': 'autogrid_res_local', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
            code = """def doit(self, ligands, autogrid_results, dpf_template_obj):
        dpf = dpf_template_obj.fullpath

        if not(os.path.exists(dpf)):
            print "ERROR: DPF template " + dpf + " does not exist!"
            return '''stop'''
    
        filter_file = ligands.filter_file
        
        if autogrid_results.type == '''url''':
            autogrid_result_url = autogrid_results.path
            autogrid_result_local = ""
        else:
            autogrid_result_url = ""
            autogrid_result_local = autogrid_results.path
        
        ligand_lib = ligands.loc
        
	pass

        self.outputData(filter_file=filter_file, ligand_lib=ligand_lib, dpf_template_file=dpf, autogrid_res_url=autogrid_result_url, autogrid_res_local=autogrid_result_local)

## to ouput data on port filter_file use
## self.outputData(filter_file=data)
## to ouput data on port ligand_lib use
## self.outputData(ligand_lib=data)
## to ouput data on port dpf_template_file use
## self.outputData(dpf_template_file=data)
## to ouput data on port autogrid_res_url use
## self.outputData(autogrid_res_url=data)
## to ouput data on port autogrid_res_local use
## self.outputData(autogrid_res_local=data)









"""
            PrepareADVSInputs_12.configure(function=code)
            apply(PrepareADVSInputs_12.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
        except:
            print "WARNING: failed to restore Generic named PrepareADVSInputs in network self.macroNetwork"
            print_exc()
            PrepareADVSInputs_12=None

        try:
            ## saving node autodock_kryptonite_nbcr_net ##
            from NetworkEditor.items import FunctionNode
            autodock_kryptonite_nbcr_net_13 = FunctionNode(functionOrString='autodock_kryptonite_nbcr_net', host="http://kryptonite.nbcr.net/opal2", namedArgs={'ga_run': '', 'lib': '', 'filter_file_url': '', 'ga_num_evals': '', 'filter_file': '', 'sched': 'SGE', 'urllib': '', 'ga_num_generations': '', 'dpf': '', 'u': '', 'utar': '', 'userlib': '', 'ga_pop_size': '', 'localRun': False, 'email': '', 'execPath': ''}, constrkw={'functionOrString': "'autodock_kryptonite_nbcr_net'", 'host': '"http://kryptonite.nbcr.net/opal2"', 'namedArgs': {'ga_run': '', 'lib': '', 'filter_file_url': '', 'ga_num_evals': '', 'filter_file': '', 'sched': 'SGE', 'urllib': '', 'ga_num_generations': '', 'dpf': '', 'u': '', 'utar': '', 'userlib': '', 'ga_pop_size': '', 'localRun': False, 'email': '', 'execPath': ''}}, name='autodock_kryptonite_nbcr_net', library=wslib)
            self.macroNetwork.addNode(autodock_kryptonite_nbcr_net_13,217,132)
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['ga_run'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['lib'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['filter_file_url'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['ga_num_evals'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['filter_file'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['sched'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['urllib'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['ga_num_generations'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['dpf'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['u'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['utar'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['userlib'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['ga_pop_size'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['localRun'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['email'].configure, (), {'defaultValue': None})
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['execPath'].configure, (), {'defaultValue': None})
            autodock_kryptonite_nbcr_net_13.inputPortByName['ga_run'].widget.set(r"", run=False)
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['lib'].widget.configure, (), {'choices': ('sample', 'NCIDS_SC', 'NCI_DS1', 'NCI_DS2', 'human_metabolome', 'chembridge_building_blocks', 'drugbank_nutraceutics', 'drugbank_smallmol', 'fda_approved')})
            autodock_kryptonite_nbcr_net_13.inputPortByName['lib'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['filter_file_url'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['ga_num_evals'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['filter_file'].rebindWidget()
            autodock_kryptonite_nbcr_net_13.inputPortByName['filter_file'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['filter_file'].unbindWidget()
            apply(autodock_kryptonite_nbcr_net_13.inputPortByName['sched'].widget.configure, (), {'choices': ('SGE', 'CSF')})
            autodock_kryptonite_nbcr_net_13.inputPortByName['sched'].widget.set(r"SGE", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['urllib'].rebindWidget()
            autodock_kryptonite_nbcr_net_13.inputPortByName['urllib'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['urllib'].unbindWidget()
            autodock_kryptonite_nbcr_net_13.inputPortByName['ga_num_generations'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['dpf'].rebindWidget()
            autodock_kryptonite_nbcr_net_13.inputPortByName['dpf'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['dpf'].unbindWidget()
            autodock_kryptonite_nbcr_net_13.inputPortByName['u'].rebindWidget()
            autodock_kryptonite_nbcr_net_13.inputPortByName['u'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['u'].unbindWidget()
            autodock_kryptonite_nbcr_net_13.inputPortByName['utar'].rebindWidget()
            autodock_kryptonite_nbcr_net_13.inputPortByName['utar'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['utar'].unbindWidget()
            autodock_kryptonite_nbcr_net_13.inputPortByName['userlib'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['ga_pop_size'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['localRun'].widget.set(0, run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['email'].widget.set(r"", run=False)
            autodock_kryptonite_nbcr_net_13.inputPortByName['execPath'].widget.set(r"", run=False)
            apply(autodock_kryptonite_nbcr_net_13.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
        except:
            print "WARNING: failed to restore FunctionNode named autodock_kryptonite_nbcr_net in network self.macroNetwork"
            print_exc()
            autodock_kryptonite_nbcr_net_13=None

        try:
            ## saving node GetMainURLFromList ##
            from WebServices.VisionInterface.WSNodes import GetMainURLFromListNode
            GetMainURLFromList_14 = GetMainURLFromListNode(constrkw={}, name='GetMainURLFromList', library=wslib)
            self.macroNetwork.addNode(GetMainURLFromList_14,217,188)
            apply(GetMainURLFromList_14.inputPortByName['urls'].configure, (), {'defaultValue': None})
            apply(GetMainURLFromList_14.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
        except:
            print "WARNING: failed to restore GetMainURLFromListNode named GetMainURLFromList in network self.macroNetwork"
            print_exc()
            GetMainURLFromList_14=None

        #self.macroNetwork.run()
        self.macroNetwork.freeze()

        ## saving connections for network AutodockVS ##
        input_Ports_10 = self.macroNetwork.ipNode
        if input_Ports_10 is not None and PrepareADVSInputs_12 is not None:
            try:
                self.macroNetwork.connectNodes(
                    input_Ports_10, PrepareADVSInputs_12, "new", "ligands", blocking=True
                    , splitratio=[0.60597534741634829, 0.41083180453223428])
            except:
                print "WARNING: failed to restore connection between input_Ports_10 and PrepareADVSInputs_12 in network self.macroNetwork"
        if input_Ports_10 is not None and PrepareADVSInputs_12 is not None:
            try:
                self.macroNetwork.connectNodes(
                    input_Ports_10, PrepareADVSInputs_12, "new", "autogrid_results", blocking=True
                    , splitratio=[0.64561658610430228, 0.21974682015753622])
            except:
                print "WARNING: failed to restore connection between input_Ports_10 and PrepareADVSInputs_12 in network self.macroNetwork"
        if input_Ports_10 is not None and PrepareADVSInputs_12 is not None:
            try:
                self.macroNetwork.connectNodes(
                    input_Ports_10, PrepareADVSInputs_12, "new", "dpf_template_obj", blocking=True
                    , splitratio=[0.52491295380143521, 0.32751034461281114])
            except:
                print "WARNING: failed to restore connection between input_Ports_10 and PrepareADVSInputs_12 in network self.macroNetwork"
        if autodock_kryptonite_nbcr_net_13 is not None and GetMainURLFromList_14 is not None:
            try:
                self.macroNetwork.connectNodes(
                    autodock_kryptonite_nbcr_net_13, GetMainURLFromList_14, "result", "urls", blocking=True
                    , splitratio=[0.36974288957131424, 0.63465596053596318])
            except:
                print "WARNING: failed to restore connection between autodock_kryptonite_nbcr_net_13 and GetMainURLFromList_14 in network self.macroNetwork"
        output_Ports_11 = self.macroNetwork.opNode
        if GetMainURLFromList_14 is not None and output_Ports_11 is not None:
            try:
                self.macroNetwork.connectNodes(
                    GetMainURLFromList_14, output_Ports_11, "newurl", "new", blocking=True
                    , splitratio=[0.34850477186787743, 0.35637513198385085])
            except:
                print "WARNING: failed to restore connection between GetMainURLFromList_14 and output_Ports_11 in network self.macroNetwork"
        if PrepareADVSInputs_12 is not None and autodock_kryptonite_nbcr_net_13 is not None:
            try:
                self.macroNetwork.connectNodes(
                    PrepareADVSInputs_12, autodock_kryptonite_nbcr_net_13, "filter_file", "filter_file", blocking=True
                    , splitratio=[0.33230642287344903, 0.65770700108889613])
            except:
                print "WARNING: failed to restore connection between PrepareADVSInputs_12 and autodock_kryptonite_nbcr_net_13 in network self.macroNetwork"
        if PrepareADVSInputs_12 is not None and autodock_kryptonite_nbcr_net_13 is not None:
            try:
                self.macroNetwork.connectNodes(
                    PrepareADVSInputs_12, autodock_kryptonite_nbcr_net_13, "ligand_lib", "urllib", blocking=True
                    , splitratio=[0.50680104599665787, 0.51414170500293577])
            except:
                print "WARNING: failed to restore connection between PrepareADVSInputs_12 and autodock_kryptonite_nbcr_net_13 in network self.macroNetwork"
        if PrepareADVSInputs_12 is not None and autodock_kryptonite_nbcr_net_13 is not None:
            try:
                self.macroNetwork.connectNodes(
                    PrepareADVSInputs_12, autodock_kryptonite_nbcr_net_13, "dpf_template_file", "dpf", blocking=True
                    , splitratio=[0.51615646597598808, 0.25661305528484007])
            except:
                print "WARNING: failed to restore connection between PrepareADVSInputs_12 and autodock_kryptonite_nbcr_net_13 in network self.macroNetwork"
        if PrepareADVSInputs_12 is not None and autodock_kryptonite_nbcr_net_13 is not None:
            try:
                self.macroNetwork.connectNodes(
                    PrepareADVSInputs_12, autodock_kryptonite_nbcr_net_13, "autogrid_res_url", "u", blocking=True
                    , splitratio=[0.5760732944947704, 0.2032376887917188])
            except:
                print "WARNING: failed to restore connection between PrepareADVSInputs_12 and autodock_kryptonite_nbcr_net_13 in network self.macroNetwork"
        if PrepareADVSInputs_12 is not None and autodock_kryptonite_nbcr_net_13 is not None:
            try:
                self.macroNetwork.connectNodes(
                    PrepareADVSInputs_12, autodock_kryptonite_nbcr_net_13, "autogrid_res_local", "utar", blocking=True
                    , splitratio=[0.52802808938949819, 0.66978534572736881])
            except:
                print "WARNING: failed to restore connection between PrepareADVSInputs_12 and autodock_kryptonite_nbcr_net_13 in network self.macroNetwork"
        self.macroNetwork.runOnNewData.value = False

        ## modifying MacroInputNode dynamic ports
        input_Ports_10 = self.macroNetwork.ipNode
        input_Ports_10.outputPorts[1].configure(name='PrepareADVSInputs_ligands')
        input_Ports_10.outputPorts[2].configure(name='PrepareADVSInputs_autogrid_results')
        input_Ports_10.outputPorts[3].configure(name='PrepareADVSInputs_dpf_template_obj')

        ## modifying MacroOutputNode dynamic ports
        output_Ports_11 = self.macroNetwork.opNode
        output_Ports_11.inputPorts[1].configure(singleConnection='auto')
        output_Ports_11.inputPorts[1].configure(name='GetMainURLFromList_newurl')
        ## configure MacroNode input ports
        AutodockVS_9.inputPorts[0].configure(name='PrepareADVSInputs_ligands')
        AutodockVS_9.inputPorts[0].configure(datatype='LigandDB')
        AutodockVS_9.inputPorts[1].configure(name='PrepareADVSInputs_autogrid_results')
        AutodockVS_9.inputPorts[1].configure(datatype='autogrid_results')
        AutodockVS_9.inputPorts[2].configure(name='PrepareADVSInputs_dpf_template_obj')
        AutodockVS_9.inputPorts[2].configure(datatype='dpf_template')
        ## configure MacroNode output ports
        AutodockVS_9.outputPorts[0].configure(name='GetMainURLFromList_newurl')
        AutodockVS_9.outputPorts[0].configure(datatype='string')

        AutodockVS_9.shrink()

        ## reset modifications ##
        AutodockVS_9.resetTags()
        AutodockVS_9.buildOriginalList()
