/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgCreateINI(void)

	Create a new INI file and open it for writing.

	Return:
		0 on success

ob(ject): cfgCreateINI
su(bsystem): inifile/1
sh(ort description): Open the application's INI file for writing
lo(ng description): Open the application's INI file for writing. Until cfgCreateCloseINI()
 is called, the file is kept as a temporary file. That reduces the case
 when the INI file would be corrupted, also the "old" INI file can be read
 during the write process.\par
 The name of the INI file is determined from the internally stored "name" and
 "path". They can be manually set by cfgChangeNameINI() and cfgChangePathINI().
 If not changed, their data is retreived by calling appNameEx() and
 appPathEx().
pr(erequistes):= \para{name} != NULL
fi(le): cfgici.c

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"
#include "dynstr.h"
#include "dfn.h"
#include "supplio.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICI.C 1.4 1999/12/13 02:22:18 ska Exp ska $";
#endif

int cfgCreateINI(void)
{	DBG_ENTER("cfgCreateINI", Suppl_inifile1)
	chkHeap
	if(cfgi_ini)		/* if tested in createFile(), the allocated
							filename would be left behind allocated */
		DBG_RETURN_I( CFG_ERR_ALREADY)

	DBG_RETURN_BI( cfgi_createFile(cfgi_userINIfile()))
}
