/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trace.ExpressionPresenter;

public class XsltExecutable {
    Processor processor;
    PreparedStylesheet pss;

    protected XsltExecutable(Processor processor, PreparedStylesheet pss) {
        this.processor = processor;
        this.pss = pss;
    }

    public XsltTransformer load() {
        return new XsltTransformer(this.processor, (Controller)this.pss.newTransformer());
    }

    public void explain(Destination destination) throws SaxonApiException {
        Configuration config = this.processor.getUnderlyingConfiguration();
        this.pss.explain(new ExpressionPresenter(config, destination.getReceiver(config)));
    }

    public PreparedStylesheet getUnderlyingCompiledStylesheet() {
        return this.pss;
    }
}

