/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_REGISTEREDSSHPROFILE_H_
#define OPENDRIM_REGISTEREDSSHPROFILE_H_

#include <Instance.h>

const static char* OpenDRIM_RegisteredSSHProfile_classnames[] = {"OpenDRIM_RegisteredSSHProfile"};
static string OpenDRIM_RegisteredSSHProfile_NAMESPACE = _INTEROP_NAMESPACE;

class OpenDRIM_RegisteredSSHProfile {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	unsigned long long Generation;
	bool Generation_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string OtherSpecificationType;
	bool OtherSpecificationType_isNULL;
	
	unsigned short RegisteredOrganization;
	bool RegisteredOrganization_isNULL;
	
	string OtherRegisteredOrganization;
	bool OtherRegisteredOrganization_isNULL;
	
	string RegisteredName;
	bool RegisteredName_isNULL;
	
	string RegisteredVersion;
	bool RegisteredVersion_isNULL;
	
	vector<unsigned short> AdvertiseTypes;
	bool AdvertiseTypes_isNULL;
	
	vector<string> AdvertiseTypeDescriptions;
	bool AdvertiseTypeDescriptions_isNULL;
	
	unsigned short SpecificationType;
	bool SpecificationType_isNULL;
	
	vector<string> ImplementedFeatures;
	bool ImplementedFeatures_isNULL;
	
	OpenDRIM_RegisteredSSHProfile() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		Generation_isNULL = true;
		InstanceID_isNULL = true;
		OtherSpecificationType_isNULL = true;
		RegisteredOrganization_isNULL = true;
		OtherRegisteredOrganization_isNULL = true;
		RegisteredName_isNULL = true;
		RegisteredVersion_isNULL = true;
		AdvertiseTypes_isNULL = true;
		AdvertiseTypeDescriptions_isNULL = true;
		SpecificationType_isNULL = true;
		ImplementedFeatures_isNULL = true;
	}
	
	~OpenDRIM_RegisteredSSHProfile() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getGeneration(unsigned long long& value) const {
		if (Generation_isNULL==true)
			return NOT_FOUND;
		value = Generation;
		return OK;
	}
	
	int setGeneration(const unsigned long long& newValue) {
		Generation = newValue;
		Generation_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getOtherSpecificationType(string& value) const {
		if (OtherSpecificationType_isNULL==true)
			return NOT_FOUND;
		value = OtherSpecificationType;
		return OK;
	}
	
	int setOtherSpecificationType(const string& newValue) {
		OtherSpecificationType = newValue;
		OtherSpecificationType_isNULL = false;
		return OK;
	}

	int getRegisteredOrganization(unsigned short& value) const {
		if (RegisteredOrganization_isNULL==true)
			return NOT_FOUND;
		value = RegisteredOrganization;
		return OK;
	}
	
	int setRegisteredOrganization(const unsigned short& newValue) {
		RegisteredOrganization = newValue;
		RegisteredOrganization_isNULL = false;
		return OK;
	}

	int getOtherRegisteredOrganization(string& value) const {
		if (OtherRegisteredOrganization_isNULL==true)
			return NOT_FOUND;
		value = OtherRegisteredOrganization;
		return OK;
	}
	
	int setOtherRegisteredOrganization(const string& newValue) {
		OtherRegisteredOrganization = newValue;
		OtherRegisteredOrganization_isNULL = false;
		return OK;
	}

	int getRegisteredName(string& value) const {
		if (RegisteredName_isNULL==true)
			return NOT_FOUND;
		value = RegisteredName;
		return OK;
	}
	
	int setRegisteredName(const string& newValue) {
		RegisteredName = newValue;
		RegisteredName_isNULL = false;
		return OK;
	}

	int getRegisteredVersion(string& value) const {
		if (RegisteredVersion_isNULL==true)
			return NOT_FOUND;
		value = RegisteredVersion;
		return OK;
	}
	
	int setRegisteredVersion(const string& newValue) {
		RegisteredVersion = newValue;
		RegisteredVersion_isNULL = false;
		return OK;
	}

	int getAdvertiseTypes(vector<unsigned short>& value) const {
		if (AdvertiseTypes_isNULL==true)
			return NOT_FOUND;
		value = AdvertiseTypes;
		return OK;
	}
	
	int setAdvertiseTypes(const vector<unsigned short>& newValue) {
		AdvertiseTypes = newValue;
		AdvertiseTypes_isNULL = false;
		return OK;
	}

	int getAdvertiseTypeDescriptions(vector<string>& value) const {
		if (AdvertiseTypeDescriptions_isNULL==true)
			return NOT_FOUND;
		value = AdvertiseTypeDescriptions;
		return OK;
	}
	
	int setAdvertiseTypeDescriptions(const vector<string>& newValue) {
		AdvertiseTypeDescriptions = newValue;
		AdvertiseTypeDescriptions_isNULL = false;
		return OK;
	}

	int getSpecificationType(unsigned short& value) const {
		if (SpecificationType_isNULL==true)
			return NOT_FOUND;
		value = SpecificationType;
		return OK;
	}
	
	int setSpecificationType(const unsigned short& newValue) {
		SpecificationType = newValue;
		SpecificationType_isNULL = false;
		return OK;
	}

	int getImplementedFeatures(vector<string>& value) const {
		if (ImplementedFeatures_isNULL==true)
			return NOT_FOUND;
		value = ImplementedFeatures;
		return OK;
	}
	
	int setImplementedFeatures(const vector<string>& newValue) {
		ImplementedFeatures = newValue;
		ImplementedFeatures_isNULL = false;
		return OK;
	}

};

class OpenDRIM_RegisteredSSHProfile_CloseConformantInstances_In {

public:

	string EnumerationContext;
	bool EnumerationContext_isNULL;

	OpenDRIM_RegisteredSSHProfile_CloseConformantInstances_In() {
		EnumerationContext_isNULL = true;
	}

	~OpenDRIM_RegisteredSSHProfile_CloseConformantInstances_In() {}

	int getEnumerationContext(string& value) const {
		if (EnumerationContext_isNULL == true)
			return NOT_FOUND;
		value = EnumerationContext;
		return OK;
	}
	int setEnumerationContext(const string&  newValue) {
		EnumerationContext = newValue;
		EnumerationContext_isNULL = false;
		return OK;
	}

};

class OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_In {

public:

	string ResultClass;
	bool ResultClass_isNULL;

	vector<string> IncludedPropertyList;
	bool IncludedPropertyList_isNULL;

	unsigned int OperationTimeout;
	bool OperationTimeout_isNULL;

	bool ContinueOnError;
	bool ContinueOnError_isNULL;

	unsigned int MaxObjectCount;
	bool MaxObjectCount_isNULL;

	string EnumerationContext;
	bool EnumerationContext_isNULL;

	bool EndOfSequence;
	bool EndOfSequence_isNULL;

	vector<unsigned short> InstanceType;
	bool InstanceType_isNULL;

	vector<string> InstanceWithPathList;
	bool InstanceWithPathList_isNULL;

	OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_In() {
		ResultClass_isNULL = true;
		IncludedPropertyList_isNULL = true;
		OperationTimeout_isNULL = true;
		ContinueOnError_isNULL = true;
		MaxObjectCount_isNULL = true;
		EnumerationContext_isNULL = true;
		EndOfSequence_isNULL = true;
		InstanceType_isNULL = true;
		InstanceWithPathList_isNULL = true;
	}

	~OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_In() {}

	int getResultClass(string& value) const {
		if (ResultClass_isNULL == true)
			return NOT_FOUND;
		value = ResultClass;
		return OK;
	}
	int setResultClass(const string&  newValue) {
		ResultClass = newValue;
		ResultClass_isNULL = false;
		return OK;
	}

	int getIncludedPropertyList(vector<string>& value) const {
		if (IncludedPropertyList_isNULL == true)
			return NOT_FOUND;
		value = IncludedPropertyList;
		return OK;
	}
	int setIncludedPropertyList(const vector<string>&  newValue) {
		IncludedPropertyList = newValue;
		IncludedPropertyList_isNULL = false;
		return OK;
	}

	int getOperationTimeout(unsigned int& value) const {
		if (OperationTimeout_isNULL == true)
			return NOT_FOUND;
		value = OperationTimeout;
		return OK;
	}
	int setOperationTimeout(const unsigned int&  newValue) {
		OperationTimeout = newValue;
		OperationTimeout_isNULL = false;
		return OK;
	}

	int getContinueOnError(bool& value) const {
		if (ContinueOnError_isNULL == true)
			return NOT_FOUND;
		value = ContinueOnError;
		return OK;
	}
	int setContinueOnError(const bool&  newValue) {
		ContinueOnError = newValue;
		ContinueOnError_isNULL = false;
		return OK;
	}

	int getMaxObjectCount(unsigned int& value) const {
		if (MaxObjectCount_isNULL == true)
			return NOT_FOUND;
		value = MaxObjectCount;
		return OK;
	}
	int setMaxObjectCount(const unsigned int&  newValue) {
		MaxObjectCount = newValue;
		MaxObjectCount_isNULL = false;
		return OK;
	}

	int getEnumerationContext(string& value) const {
		if (EnumerationContext_isNULL == true)
			return NOT_FOUND;
		value = EnumerationContext;
		return OK;
	}
	int setEnumerationContext(const string&  newValue) {
		EnumerationContext = newValue;
		EnumerationContext_isNULL = false;
		return OK;
	}

	int getEndOfSequence(bool& value) const {
		if (EndOfSequence_isNULL == true)
			return NOT_FOUND;
		value = EndOfSequence;
		return OK;
	}
	int setEndOfSequence(const bool&  newValue) {
		EndOfSequence = newValue;
		EndOfSequence_isNULL = false;
		return OK;
	}

	int getInstanceType(vector<unsigned short>& value) const {
		if (InstanceType_isNULL == true)
			return NOT_FOUND;
		value = InstanceType;
		return OK;
	}
	int setInstanceType(const vector<unsigned short>&  newValue) {
		InstanceType = newValue;
		InstanceType_isNULL = false;
		return OK;
	}

	int getInstanceWithPathList(vector<string>& value) const {
		if (InstanceWithPathList_isNULL == true)
			return NOT_FOUND;
		value = InstanceWithPathList;
		return OK;
	}
	int setInstanceWithPathList(const vector<string>&  newValue) {
		InstanceWithPathList = newValue;
		InstanceWithPathList_isNULL = false;
		return OK;
	}

};

class OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_Out {

public:

	string EnumerationContext;
	bool EnumerationContext_isNULL;

	bool EndOfSequence;
	bool EndOfSequence_isNULL;

	vector<unsigned short> InstanceType;
	bool InstanceType_isNULL;

	vector<string> InstanceWithPathList;
	bool InstanceWithPathList_isNULL;

	OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_Out() {
		EnumerationContext_isNULL = true;
		EndOfSequence_isNULL = true;
		InstanceType_isNULL = true;
		InstanceWithPathList_isNULL = true;
	}

	~OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_Out() {}

	int getEnumerationContext(string& value) const {
		if (EnumerationContext_isNULL == true)
			return NOT_FOUND;
		value = EnumerationContext;
		return OK;
	}
	int setEnumerationContext(const string&  newValue) {
		EnumerationContext = newValue;
		EnumerationContext_isNULL = false;
		return OK;
	}

	int getEndOfSequence(bool& value) const {
		if (EndOfSequence_isNULL == true)
			return NOT_FOUND;
		value = EndOfSequence;
		return OK;
	}
	int setEndOfSequence(const bool&  newValue) {
		EndOfSequence = newValue;
		EndOfSequence_isNULL = false;
		return OK;
	}

	int getInstanceType(vector<unsigned short>& value) const {
		if (InstanceType_isNULL == true)
			return NOT_FOUND;
		value = InstanceType;
		return OK;
	}
	int setInstanceType(const vector<unsigned short>&  newValue) {
		InstanceType = newValue;
		InstanceType_isNULL = false;
		return OK;
	}

	int getInstanceWithPathList(vector<string>& value) const {
		if (InstanceWithPathList_isNULL == true)
			return NOT_FOUND;
		value = InstanceWithPathList;
		return OK;
	}
	int setInstanceWithPathList(const vector<string>&  newValue) {
		InstanceWithPathList = newValue;
		InstanceWithPathList_isNULL = false;
		return OK;
	}

};

class OpenDRIM_RegisteredSSHProfile_PullConformantInstances_In {

public:

	unsigned int MaxObjectCount;
	bool MaxObjectCount_isNULL;

	string EnumerationContext;
	bool EnumerationContext_isNULL;

	bool EndOfSequence;
	bool EndOfSequence_isNULL;

	vector<unsigned short> InstanceType;
	bool InstanceType_isNULL;

	vector<string> InstanceWithPathList;
	bool InstanceWithPathList_isNULL;

	OpenDRIM_RegisteredSSHProfile_PullConformantInstances_In() {
		MaxObjectCount_isNULL = true;
		EnumerationContext_isNULL = true;
		EndOfSequence_isNULL = true;
		InstanceType_isNULL = true;
		InstanceWithPathList_isNULL = true;
	}

	~OpenDRIM_RegisteredSSHProfile_PullConformantInstances_In() {}

	int getMaxObjectCount(unsigned int& value) const {
		if (MaxObjectCount_isNULL == true)
			return NOT_FOUND;
		value = MaxObjectCount;
		return OK;
	}
	int setMaxObjectCount(const unsigned int&  newValue) {
		MaxObjectCount = newValue;
		MaxObjectCount_isNULL = false;
		return OK;
	}

	int getEnumerationContext(string& value) const {
		if (EnumerationContext_isNULL == true)
			return NOT_FOUND;
		value = EnumerationContext;
		return OK;
	}
	int setEnumerationContext(const string&  newValue) {
		EnumerationContext = newValue;
		EnumerationContext_isNULL = false;
		return OK;
	}

	int getEndOfSequence(bool& value) const {
		if (EndOfSequence_isNULL == true)
			return NOT_FOUND;
		value = EndOfSequence;
		return OK;
	}
	int setEndOfSequence(const bool&  newValue) {
		EndOfSequence = newValue;
		EndOfSequence_isNULL = false;
		return OK;
	}

	int getInstanceType(vector<unsigned short>& value) const {
		if (InstanceType_isNULL == true)
			return NOT_FOUND;
		value = InstanceType;
		return OK;
	}
	int setInstanceType(const vector<unsigned short>&  newValue) {
		InstanceType = newValue;
		InstanceType_isNULL = false;
		return OK;
	}

	int getInstanceWithPathList(vector<string>& value) const {
		if (InstanceWithPathList_isNULL == true)
			return NOT_FOUND;
		value = InstanceWithPathList;
		return OK;
	}
	int setInstanceWithPathList(const vector<string>&  newValue) {
		InstanceWithPathList = newValue;
		InstanceWithPathList_isNULL = false;
		return OK;
	}

};

class OpenDRIM_RegisteredSSHProfile_PullConformantInstances_Out {

public:

	string EnumerationContext;
	bool EnumerationContext_isNULL;

	bool EndOfSequence;
	bool EndOfSequence_isNULL;

	vector<unsigned short> InstanceType;
	bool InstanceType_isNULL;

	vector<string> InstanceWithPathList;
	bool InstanceWithPathList_isNULL;

	OpenDRIM_RegisteredSSHProfile_PullConformantInstances_Out() {
		EnumerationContext_isNULL = true;
		EndOfSequence_isNULL = true;
		InstanceType_isNULL = true;
		InstanceWithPathList_isNULL = true;
	}

	~OpenDRIM_RegisteredSSHProfile_PullConformantInstances_Out() {}

	int getEnumerationContext(string& value) const {
		if (EnumerationContext_isNULL == true)
			return NOT_FOUND;
		value = EnumerationContext;
		return OK;
	}
	int setEnumerationContext(const string&  newValue) {
		EnumerationContext = newValue;
		EnumerationContext_isNULL = false;
		return OK;
	}

	int getEndOfSequence(bool& value) const {
		if (EndOfSequence_isNULL == true)
			return NOT_FOUND;
		value = EndOfSequence;
		return OK;
	}
	int setEndOfSequence(const bool&  newValue) {
		EndOfSequence = newValue;
		EndOfSequence_isNULL = false;
		return OK;
	}

	int getInstanceType(vector<unsigned short>& value) const {
		if (InstanceType_isNULL == true)
			return NOT_FOUND;
		value = InstanceType;
		return OK;
	}
	int setInstanceType(const vector<unsigned short>&  newValue) {
		InstanceType = newValue;
		InstanceType_isNULL = false;
		return OK;
	}

	int getInstanceWithPathList(vector<string>& value) const {
		if (InstanceWithPathList_isNULL == true)
			return NOT_FOUND;
		value = InstanceWithPathList;
		return OK;
	}
	int setInstanceWithPathList(const vector<string>&  newValue) {
		InstanceWithPathList = newValue;
		InstanceWithPathList_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_REGISTEREDSSHPROFILE_H_*/
