#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The World Begins With You
# send your bug reports to contact@dotslashplay.it
###

script_version=20230308.1

GAME_ID='the-world-begins-with-you'
GAME_NAME='The World Begins With You'

ARCHIVE_BASE_0='TheWorldBeginsWithYou_v1_0_1_WIN.zip'
ARCHIVE_BASE_0_MD5='ae72427190719de31f59b2cc1ed4baa3'
ARCHIVE_BASE_0_SIZE='730000'
ARCHIVE_BASE_0_VERSION='1.0.1-itch'
ARCHIVE_BASE_0_URL='https://fabiandenter.itch.io/the-world-begins-with-you'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
TheWorldBeginsWithYou_v1_0_1.exe
TheWorldBeginsWithYou_v1_0_1_Data/Plugins
TheWorldBeginsWithYou_v1_0_1_Data/Managed
TheWorldBeginsWithYou_v1_0_1_Data/Mono
UnityPlayer.dll'
CONTENT_GAME_DATA_FILES='TheWorldBeginsWithYou_v1_0_1_Data'

APP_MAIN_EXE='TheWorldBeginsWithYou_v1_0_1.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Set up a WINE virtual desktop on first launch, using the current desktop resolution

PKG_BIN_DEPS="$PKG_BIN_DEPS xrandr sed"
sed_expression='s/.*primary.* ([0-9]+x[0-9]+).*/\1/p'
sed_options="--regexp-extended --silent --expression='$sed_expression'"
APP_WINETRICKS="$APP_WINETRICKS vd=\$(LANG=C xrandr | sed $sed_options)"

# Load common functions

target_version='2.22'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
	set_standard_permissions .
)

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
