----------------------------------------------------------------------------
-- |
-- Module      :  BluetileDock
-- Copyright   :  (c) Jan Vornberger 2009
-- License     :  BSD3-style (see LICENSE)
--
-- Maintainer  :  jan.vornberger@informatik.uni-oldenburg.de
-- Stability   :  unstable
-- Portability :  not portable
--
-----------------------------------------------------------------------------

module BluetileDock (bluetileDock) where

import XMonad
import qualified XMonad.StackSet as S
import System.IO
import Control.Monad(forM_)

data DockOutput = DO Int String String deriving (Show, Read)

bluetileDock :: Handle -> X ()
bluetileDock outputHandle = do
    ws <- gets windowset
    let allscreens = S.screens ws
    let outputs = for allscreens $ \s -> DO (getScreenId (S.screen s))
                                            (getLayoutDesc s)
                                            (getCurrentWorkspace s)
    forM_ outputs $ \o -> io $ hPutStrLn outputHandle $ show o

getScreenId :: ScreenId -> Int
getScreenId (S sid) = sid

getLayoutDesc :: S.Screen i (Layout Window) a sid sd -> String
getLayoutDesc = description . S.layout . S.workspace

getCurrentWorkspace :: S.Screen i l a sid sd -> i
getCurrentWorkspace = S.tag . S.workspace

for :: [a] -> (a -> b) -> [b]
for = flip map
