//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotComparison/FitFlowWidget.h
//! @brief     Defines class FitFlowWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOTCOMPARISON_FITFLOWWIDGET_H
#define BORNAGAIN_GUI_VIEW_PLOTCOMPARISON_FITFLOWWIDGET_H

#include "GUI/View/Common/DataAccessWidget.h"

class FitSuiteItem;
class HistogramPlot;

//! Intended for showing chi2 .vs interation count dependency.
//! The main goal is to fill vacant place in FitComparisonWidget.

class FitFlowWidget : public DataAccessWidget {
    Q_OBJECT
public:
    explicit FitFlowWidget(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_item) override;

private:
    void onIterationCountChanged(int iter);

    HistogramPlot* m_histPlot;
};

#endif // BORNAGAIN_GUI_VIEW_PLOTCOMPARISON_FITFLOWWIDGET_H
