//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/Interface/LayerInterface.cpp
//! @brief     Implements class LayerInterface.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "Sample/Interface/LayerInterface.h"
#include "Base/Util/Assert.h"
#include "Sample/Interface/LayerRoughness.h"

LayerInterface::LayerInterface()
    : m_topLayer(nullptr)
    , m_bottomLayer(nullptr)
{
}

LayerInterface::~LayerInterface() = default;

LayerInterface* LayerInterface::clone() const
{
    throw std::runtime_error("LayerInterface::clone -> Not allowed to clone.");
}

LayerInterface* LayerInterface::createInterface(const Layer* top_layer, const Layer* bottom_layer,
                                                const LayerRoughness* roughness)
{
    auto* result = new LayerInterface();
    result->setLayersTopBottom(top_layer, bottom_layer);
    if (roughness)
        result->setRoughness(roughness);
    return result;
}

void LayerInterface::setRoughness(const LayerRoughness* roughness)
{
    m_roughness.reset(roughness);
}

std::vector<const INode*> LayerInterface::nodeChildren() const
{
    return std::vector<const INode*>() << m_roughness;
}

//! Sets links to the layers above and below the interface.

void LayerInterface::setLayersTopBottom(const Layer* top_layer, const Layer* bottom_layer)
{
    ASSERT(top_layer && bottom_layer);
    m_topLayer = top_layer;
    m_bottomLayer = bottom_layer;
}

std::string LayerInterface::validate() const
{
    return "";
}
