#!/bin/sh

BASE_REL=$(dpkg-parsechangelog 2>/dev/null | sed -ne 's/Version: \([0-9.]\+\)+.*/\1/p')
OLDDIR=${PWD}
GOS_DIR=${OLDDIR}/get-orig-source
GIT_COMMIT='git log -1 --oneline | cut -d" " -f1'
GIT_DATE='git log -1 --date=iso | sed -ne "s/Date:\s\+\(.*\).*/\1/p" | cut -d" " -f1 | tr -d "-"'

if [ -z ${BASE_REL} ]; then
	echo 'Please run this script from the sources root directory.'
	exit 1
fi


rm -rf ${GOS_DIR}
mkdir ${GOS_DIR} && cd ${GOS_DIR}
git clone git://brp-pacu.git.sourceforge.net/gitroot/brp-pacu/brp-pacu brp-pacu
cd brp-pacu/
BRP_PACU_GIT_DATE=$(eval "${GIT_DATE}")
cd .. && tar cfz \
	${OLDDIR}/brp-pacu_${BASE_REL}+git${BRP_PACU_GIT_DATE}.orig.tar.gz \
	brp-pacu \
	--exclude-vcs \
	--exclude=.deps \
	--exclude=BRP-PACU-mac-2.1.1.dmg \
	--exclude=config.status \
	--exclude=testfft.o \
	--exclude=BRP_PACU-2.1.1.tar.gz
rm -rf ${GOS_DIR}
