{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDescription: String;
    procedure SetDescription(const Value: String);
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetGain: Single;
    procedure SetGain(const Value: Single);
    function GetPitch: Single;
    procedure SetPitch(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @code(Description). This wrapper API may change, we advise to access simpler @code(Description) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FFdEnabled: TSFBool;
    { Internal wrapper for property @code(Enabled). This wrapper API may change, we advise to access simpler @code(Enabled) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnabled: TSFBool read FFdEnabled;
    {  }
    property Enabled: Boolean read GetEnabled write SetEnabled;

    strict private FFdGain: TSFFloat;
    { Internal wrapper for property @code(Gain). This wrapper API may change, we advise to access simpler @code(Gain) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGain: TSFFloat read FFdGain;
    {  }
    property Gain: Single read GetGain write SetGain;

    strict private FFdPitch: TSFFloat;
    { Internal wrapper for property @code(Pitch). This wrapper API may change, we advise to access simpler @code(Pitch) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdPitch: TSFFloat read FFdPitch;
    {  }
    property Pitch: Single read GetPitch write SetPitch;

    strict private FEventDuration_changed: TSFTimeEvent;
    {  }
    public property EventDuration_changed: TSFTimeEvent read FEventDuration_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractSoundSourceNode ----------------------------------------------- }

function TAbstractSoundSourceNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure TAbstractSoundSourceNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

function TAbstractSoundSourceNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TAbstractSoundSourceNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TAbstractSoundSourceNode.GetGain: Single;
begin
  Result := FdGain.Value;
end;

procedure TAbstractSoundSourceNode.SetGain(const Value: Single);
begin
  FdGain.Send(Value);
end;

function TAbstractSoundSourceNode.GetPitch: Single;
begin
  Result := FdPitch.Value;
end;

procedure TAbstractSoundSourceNode.SetPitch(const Value: Single);
begin
  FdPitch.Send(Value);
end;

class function TAbstractSoundSourceNode.ClassX3DType: String;
begin
  Result := 'X3DSoundSourceNode';
end;

procedure TAbstractSoundSourceNode.CreateNode;
begin
  inherited;

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chNone;
  AddField(FFdDescription);

  FFdEnabled := TSFBool.Create(Self, True, 'enabled', true);
   FdEnabled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnabled);

  FFdGain := TSFFloat.Create(Self, True, 'gain', 1);
   FdGain.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGain);

  FFdPitch := TSFFloat.Create(Self, True, 'pitch', 1.0);
   FdPitch.ChangeAlways := chVisibleNonGeometry;
   FdPitch.MustBeNonnegative := true;
  AddField(FFdPitch);

  FEventDuration_changed := TSFTimeEvent.Create(Self, 'duration_changed', false);
  AddEvent(FEventDuration_changed);

  DefaultContainerField := 'children';
end;

{$endif read_implementation}
