/*
//
//  Copyright 1997-2009 Torsten Rohlfing
//
//  Copyright 2004-2010 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 2425 $
//
//  $LastChangedDate: 2010-10-07 16:14:23 -0700 (Thu, 07 Oct 2010) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#include "cmtkTypedArray.h"

namespace
cmtk
{

/** \addtogroup Base */
//@{

Types::DataItem
TypedArray
::GetPercentile
( const Types::DataItem percentile, const size_t nBins ) const
{
  const Histogram<unsigned int>::SmartPtr histogram( this->GetHistogram( nBins ) );
  return histogram->GetPercentile( percentile );
}

std::vector<Types::DataItem>
TypedArray
::GetPercentileList
( const std::vector<Types::DataItem>& percentileList, const size_t nBins ) const
{
  const Histogram<unsigned int>::SmartPtr histogram( this->GetHistogram( nBins ) );

  std::vector<Types::DataItem> results( percentileList.size() );
  for ( size_t i = 0; i < percentileList.size(); ++i )
    results[i] = histogram->GetPercentile( percentileList[i] );
  
  return results;
}

} // namespace cmtk
