'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

/**
 * ListViewGroupItem is a root node of each ListViewItem
 */
var ListViewGroupItem = function ListViewGroupItem(_ref) {
  var children = _ref.children,
      className = _ref.className,
      stacked = _ref.stacked,
      expanded = _ref.expanded,
      props = _objectWithoutProperties(_ref, ['children', 'className', 'stacked', 'expanded']);

  var classes = (0, _classnames2.default)('list-group-item', {
    'list-view-pf-expand-active': expanded,
    'list-view-pf-stacked': stacked
  }, className);
  return _react2.default.createElement(
    'div',
    _extends({ className: classes }, props),
    children
  );
};
ListViewGroupItem.propTypes = {
  /** Children nodes */
  children: _propTypes2.default.node,
  /** Additional css classes */
  className: _propTypes2.default.string,
  /** Toggles the item expanded */
  expanded: _propTypes2.default.bool,
  /** Toggles the item stacked */
  stacked: _propTypes2.default.bool
};
ListViewGroupItem.defaultProps = {
  children: null,
  expanded: false,
  stacked: false,
  className: ''
};
exports.default = ListViewGroupItem;