/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.JavaPlatform;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.trace.TimedTraceListener;
import net.sf.saxon.trace.XSLTTraceListener;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Transform {
    protected TransformerFactoryImpl factory;
    protected Configuration config;
    protected boolean useURLs = false;
    protected boolean showTime = false;
    protected int repeat = 1;
    String sourceParserName = null;

    public static void main(String[] stringArray) throws Exception {
        new Transform().doTransform(stringArray, "java net.sf.saxon.Transform");
    }

    public void setFactoryConfiguration(boolean bl) throws RuntimeException {
        if (bl) {
            this.config = Configuration.makeSchemaAwareConfiguration(null);
        } else {
            this.config = new Configuration();
            this.config.setAllNodesUntyped(true);
        }
        this.factory = new TransformerFactoryImpl(this.config);
    }

    public void doTransform(String[] stringArray, String string) {
        block113: {
            String string2 = null;
            String string3 = null;
            File file = null;
            ArrayList<String> arrayList = new ArrayList<String>(20);
            String string4 = null;
            String string5 = null;
            String string6 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            String string7 = null;
            boolean bl5 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-sa")) {
                    bl5 = true;
                    continue;
                }
                if (stringArray[i].equals("-val")) {
                    bl5 = true;
                    continue;
                }
                if (stringArray[i].equals("-vlax")) {
                    bl5 = true;
                    continue;
                }
                if (!stringArray[i].equals("-p")) continue;
                bl5 = true;
            }
            try {
                this.setFactoryConfiguration(bl5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Transform.quit(exception.getMessage(), 2);
            }
            this.config = this.factory.getConfiguration();
            bl5 = this.config.isSchemaAware(50);
            try {
                Object object;
                int n = 0;
                while (true) {
                    Object object2;
                    if (n >= stringArray.length) {
                        this.badUsage(string, "No source file name");
                    }
                    if (stringArray[n].charAt(0) != '-') break;
                    if (stringArray[n].equals("-a")) {
                        bl = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-c")) {
                        bl3 = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-cr")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No resolver after -cr");
                        }
                        object2 = stringArray[n++];
                        object = this.config.getInstance((String)object2, null);
                        this.factory.setAttribute("http://saxon.sf.net/feature/collection-uri-resolver", object);
                        continue;
                    }
                    if (stringArray[n].equals("-ds")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/treeModel", new Integer(0));
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-dt")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/treeModel", new Integer(1));
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-im")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No initial mode after -im");
                        }
                        string5 = stringArray[n++];
                        continue;
                    }
                    if (stringArray[n].equals("-it")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No initial template after -it");
                        }
                        string6 = stringArray[n++];
                        continue;
                    }
                    if (stringArray[n].equals("-l")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", true);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-m")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No message Emitter class");
                        }
                        this.factory.setAttribute("http://saxon.sf.net/feature/messageEmitterClass", stringArray[n++]);
                        continue;
                    }
                    if (stringArray[n].equals("-noext")) {
                        ++n;
                        this.factory.setAttribute("http://saxon.sf.net/feature/allow-external-functions", false);
                        continue;
                    }
                    if (stringArray[n].equals("-novw")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/version-warning", false);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-o")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No output file name");
                        }
                        string4 = stringArray[n++];
                        continue;
                    }
                    if (stringArray[n].equals("-or")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No resolver after -or");
                        }
                        object2 = stringArray[n++];
                        object = this.config.getInstance((String)object2, null);
                        this.factory.setAttribute("http://saxon.sf.net/feature/outputURIResolver", object);
                        continue;
                    }
                    if (stringArray[n].equals("-p")) {
                        ++n;
                        this.setPOption(this.config);
                        this.useURLs = true;
                        continue;
                    }
                    if (stringArray[n].equals("-r")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No URIResolver class");
                        }
                        object2 = stringArray[n++];
                        this.factory.setURIResolver(this.config.makeURIResolver((String)object2));
                        continue;
                    }
                    if (stringArray[n].equals("-sa")) {
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-snone")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/strip-whitespace", "none");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-sall")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/strip-whitespace", "all");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-signorable")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/strip-whitespace", "ignorable");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-t")) {
                        System.err.println(this.config.getProductTitle());
                        System.err.println(this.config.getPlatform().getPlatformVersion());
                        this.factory.setAttribute("http://saxon.sf.net/feature/timing", true);
                        this.showTime = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-T")) {
                        ++n;
                        object2 = new XSLTTraceListener();
                        this.factory.setAttribute("http://saxon.sf.net/feature/traceListener", object2);
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
                        continue;
                    }
                    if (stringArray[n].equals("-TJ")) {
                        ++n;
                        this.factory.setAttribute("http://saxon.sf.net/feature/trace-external-functions", Boolean.TRUE);
                        continue;
                    }
                    if (stringArray[n].equals("-TL")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No TraceListener class");
                        }
                        object2 = this.config.makeTraceListener(stringArray[n++]);
                        this.factory.setAttribute("http://saxon.sf.net/feature/traceListener", object2);
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
                        continue;
                    }
                    if (stringArray[n].equals("-TP")) {
                        ++n;
                        object2 = new TimedTraceListener();
                        this.factory.setAttribute("http://saxon.sf.net/feature/traceListener", object2);
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
                        continue;
                    }
                    if (stringArray[n].equals("-u")) {
                        this.useURLs = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-v")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/validation", true);
                        bl4 = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-val")) {
                        if (bl5) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/schema-validation", new Integer(1));
                        } else {
                            Transform.quit("The -val option requires a schema-aware processor", 2);
                        }
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-vlax")) {
                        if (bl5) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/schema-validation", new Integer(2));
                        } else {
                            Transform.quit("The -vlax option requires a schema-aware processor", 2);
                        }
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-vw")) {
                        if (bl5) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/validation-warnings", true);
                        } else {
                            Transform.quit("The -vw option requires a schema-aware processor", 2);
                        }
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-w0")) {
                        ++n;
                        this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(0));
                        continue;
                    }
                    if (stringArray[n].equals("-w1")) {
                        ++n;
                        this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(1));
                        continue;
                    }
                    if (stringArray[n].equals("-w2")) {
                        ++n;
                        this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(2));
                        continue;
                    }
                    if (stringArray[n].equals("-x")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No source parser class");
                        }
                        this.sourceParserName = stringArray[n++];
                        this.factory.setAttribute("http://saxon.sf.net/feature/sourceParserClass", this.sourceParserName);
                        continue;
                    }
                    if (stringArray[n].equals("-y")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No style parser class");
                        }
                        string7 = stringArray[n++];
                        this.factory.setAttribute("http://saxon.sf.net/feature/styleParserClass", string7);
                        continue;
                    }
                    if (stringArray[n].equals("-1.1")) {
                        ++n;
                        this.factory.setAttribute("http://saxon.sf.bet/feature/xml-version", "1.1");
                        continue;
                    }
                    if (stringArray[n].equals("-3")) {
                        ++n;
                        this.repeat = 3;
                        continue;
                    }
                    if (stringArray[n].equals("-9")) {
                        ++n;
                        this.repeat = 9;
                        continue;
                    }
                    if (stringArray[n].equals("-99")) {
                        ++n;
                        this.repeat = 999999;
                        continue;
                    }
                    if (stringArray[n].equals("-?")) {
                        this.badUsage(string, "");
                        continue;
                    }
                    if (stringArray[n].equals("-")) break;
                    this.badUsage(string, "Unknown option " + stringArray[n]);
                }
                if (string6 != null && bl) {
                    this.badUsage(string, "-it and -a options cannot be used together");
                }
                if (string6 == null) {
                    if (stringArray.length < n + 1) {
                        this.badUsage(string, "No source file name");
                    }
                    string2 = stringArray[n++];
                }
                if (!bl) {
                    if (stringArray.length < n + 1) {
                        this.badUsage(string, "No stylesheet file name");
                    }
                    string3 = stringArray[n++];
                }
                for (int i = n; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    int n2 = ((String)object).indexOf("=");
                    if (n2 < 1 || n2 >= ((String)object).length() - 1) {
                        this.badUsage(string, "Bad param=value pair on command line: " + (String)object);
                    }
                    arrayList.add((String)object);
                }
                this.config.displayLicenseMessage();
                List<Object> list = null;
                if (string6 == null) {
                    boolean bl6 = this.sourceParserName != null || bl4;
                    Object object3 = Transform.loadDocuments(string2, this.useURLs, this.config, bl6);
                    if (object3 instanceof List) {
                        bl2 = true;
                        list = (List)object3;
                    } else {
                        bl2 = false;
                        list = new ArrayList<Object>(1);
                        list.add(object3);
                    }
                    list = this.preprocess(list);
                    if (bl2) {
                        if (string4 == null) {
                            Transform.quit("To process a directory, -o must be specified", 2);
                        } else if (string4.equals(string2)) {
                            Transform.quit("Output directory must be different from input", 2);
                        } else {
                            file = new File(string4);
                            if (!file.isDirectory()) {
                                Transform.quit("Input is a directory, but output is not", 2);
                            }
                        }
                    }
                }
                if (string4 != null && !bl2 && (file = new File(string4)).isDirectory()) {
                    Transform.quit("Output is a directory, but input is not", 2);
                }
                if (bl) {
                    if (bl2) {
                        this.processDirectoryAssoc(list, file, arrayList, string5);
                    } else {
                        this.processFileAssoc((Source)list.get(0), null, file, arrayList, string5);
                    }
                    break block113;
                }
                long l = new Date().getTime();
                PreparedStylesheet preparedStylesheet = null;
                if (bl3) {
                    try {
                        preparedStylesheet = PreparedStylesheet.loadCompiledStylesheet(this.config, string3);
                        if (this.showTime) {
                            long l2 = new Date().getTime();
                            System.err.println("Stylesheet loading time: " + (l2 - l) + " milliseconds");
                            l = Transform.now();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    Source source;
                    XMLReader xMLReader = null;
                    if (this.useURLs || string3.startsWith("http:") || string3.startsWith("file:")) {
                        source = this.config.getURIResolver().resolve(string3, null);
                        if (source == null) {
                            source = this.config.getSystemURIResolver().resolve(string3, null);
                        }
                    } else if (string3.equals("-")) {
                        if (string7 == null) {
                            source = new StreamSource(System.in);
                        } else if (this.config.getPlatform() instanceof JavaPlatform) {
                            xMLReader = this.config.getStyleParser();
                            source = new SAXSource(xMLReader, new InputSource(System.in));
                        } else {
                            source = new StreamSource(System.in);
                        }
                    } else {
                        File file2 = new File(string3);
                        if (!file2.exists()) {
                            Transform.quit("Stylesheet file " + file2 + " does not exist", 2);
                        }
                        if (string7 == null) {
                            source = new StreamSource(file2.toURI().toString());
                        } else {
                            InputSource inputSource = new InputSource(file2.toURI().toString());
                            xMLReader = this.config.getStyleParser();
                            source = new SAXSource(xMLReader, inputSource);
                        }
                    }
                    if (source == null) {
                        Transform.quit("URIResolver for stylesheet file must return a Source", 2);
                    }
                    preparedStylesheet = (PreparedStylesheet)this.factory.newTemplates(source);
                    if (xMLReader != null) {
                        this.config.reuseStyleParser(xMLReader);
                    }
                    if (this.showTime) {
                        long l3 = Transform.now();
                        System.err.println("Stylesheet compilation time: " + (l3 - l) + " milliseconds");
                    }
                }
                if (string6 != null) {
                    this.execute(string6, preparedStylesheet, file, arrayList, string5);
                } else if (bl2) {
                    this.processDirectory(list, preparedStylesheet, file, arrayList, string5);
                } else {
                    this.processFile((Source)list.get(0), preparedStylesheet, file, arrayList, string5);
                }
            }
            catch (TerminationException terminationException) {
                Transform.quit(terminationException.getMessage(), 1);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                Transform.quit(transformerConfigurationException.getMessage(), 2);
            }
            catch (TransformerException transformerException) {
                Transform.quit("Transformation failed: " + transformerException.getMessage(), 2);
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                Transform.quit("Transformation failed: " + transformerFactoryConfigurationError.getMessage(), 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Transform.quit("Fatal error during transformation: " + exception.getMessage(), 2);
            }
        }
    }

    public List preprocess(List list) throws XPathException {
        return list;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    protected static void quit(String string, int n) {
        System.err.println(string);
        System.exit(n);
    }

    public static Object loadDocuments(String string, boolean bl, Configuration configuration, boolean bl2) throws TransformerException {
        Source source;
        XMLReader xMLReader = null;
        if (bl || string.startsWith("http:") || string.startsWith("file:")) {
            Source source2 = configuration.getURIResolver().resolve(string, null);
            if (source2 == null) {
                source2 = configuration.getSystemURIResolver().resolve(string, null);
            }
            return source2;
        }
        if (string.equals("-")) {
            Source source3;
            if (bl2) {
                xMLReader = configuration.getSourceParser();
                source3 = new SAXSource(xMLReader, new InputSource(System.in));
            } else {
                source3 = new StreamSource(System.in);
            }
            return source3;
        }
        File file = new File(string);
        if (!file.exists()) {
            Transform.quit("Source file " + file + " does not exist", 2);
        }
        if (file.isDirectory()) {
            xMLReader = configuration.getSourceParser();
            ArrayList<StreamSource> arrayList = new ArrayList<StreamSource>(20);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                Source source4;
                File file2 = new File(file, stringArray[i]);
                if (file2.isDirectory()) continue;
                if (bl2) {
                    InputSource inputSource = new InputSource(file2.toURI().toString());
                    source4 = new SAXSource(xMLReader, inputSource);
                } else {
                    source4 = new StreamSource(file2.toURI().toString());
                }
                arrayList.add((StreamSource)source4);
            }
            return arrayList;
        }
        if (bl2) {
            InputSource inputSource = new InputSource(file.toURI().toString());
            source = new SAXSource(configuration.getSourceParser(), inputSource);
        } else {
            source = new StreamSource(file.toURI().toString());
        }
        return source;
    }

    public void processDirectoryAssoc(List list, File file, ArrayList arrayList, String string) throws Exception {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            Source source = (Source)list.get(i);
            String string2 = Transform.getLocalFileName(source);
            try {
                this.processFileAssoc(source, string2, file, arrayList, string);
                continue;
            }
            catch (XPathException xPathException) {
                ++n;
                System.err.println("While processing " + string2 + ": " + xPathException.getMessage() + '\n');
            }
        }
        if (n > 0) {
            throw new DynamicError(n + " transformation" + (n == 1 ? "" : "s") + " failed");
        }
    }

    private File makeOutputFile(File file, String string, Templates templates) {
        String string2 = templates.getOutputProperties().getProperty("media-type");
        String string3 = ".xml";
        if ("text/html".equals(string2)) {
            string3 = ".html";
        } else if ("text/plain".equals(string2)) {
            string3 = ".txt";
        }
        String string4 = string;
        if (string.endsWith(".xml") || string.endsWith(".XML")) {
            string4 = string.substring(0, string.length() - 4);
        }
        return new File(file, string4 + string3);
    }

    public void processFileAssoc(Source source, String string, File file, ArrayList arrayList, String string2) throws TransformerException {
        File file2;
        if (this.showTime) {
            System.err.println("Processing " + source.getSystemId() + " using associated stylesheet");
        }
        long l = Transform.now();
        Source source2 = this.factory.getAssociatedStylesheet(source, null, null, null);
        Templates templates = this.factory.newTemplates(source2);
        if (this.showTime) {
            System.err.println("Prepared associated stylesheet " + source2.getSystemId());
        }
        Transformer transformer = templates.newTransformer();
        this.setParams(transformer, arrayList);
        if (string2 != null) {
            ((Controller)transformer).setInitialMode(string2);
        }
        if ((file2 = file) != null && file2.isDirectory()) {
            file2 = this.makeOutputFile(file2, string, templates);
        }
        StreamResult streamResult = file2 == null ? new StreamResult(System.out) : new StreamResult(file2.toURI().toString());
        try {
            transformer.transform(source, streamResult);
        }
        catch (TerminationException terminationException) {
            throw terminationException;
        }
        catch (XPathException xPathException) {
            throw new DynamicError("Run-time errors were reported");
        }
        if (this.showTime) {
            long l2 = Transform.now();
            System.err.println("Execution time: " + (l2 - l) + " milliseconds");
        }
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public void processDirectory(List list, Templates templates, File file, ArrayList arrayList, String string) throws TransformerException {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            Source source = (Source)list.get(i);
            String string2 = Transform.getLocalFileName(source);
            try {
                File file2 = this.makeOutputFile(file, string2, templates);
                this.processFile(source, templates, file2, arrayList, string);
                continue;
            }
            catch (XPathException xPathException) {
                ++n;
                System.err.println("While processing " + string2 + ": " + xPathException.getMessage() + '\n');
            }
        }
        if (n > 0) {
            throw new DynamicError(n + " transformation" + (n == 1 ? "" : "s") + " failed");
        }
    }

    private static String getLocalFileName(Source source) {
        try {
            String string = new URI(source.getSystemId()).getPath();
            while (true) {
                int n;
                if ((n = string.indexOf(47)) < 0) {
                    return string;
                }
                string = string.substring(n + 1);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException.getMessage());
        }
    }

    public void processFile(Source source, Templates templates, File file, ArrayList arrayList, String string) throws TransformerException {
        long l = 0L;
        int n = 0;
        for (int i = 0; i < this.repeat; ++i) {
            if (this.showTime) {
                System.err.println("Processing " + source.getSystemId());
            }
            long l2 = Transform.now();
            ++n;
            Transformer transformer = templates.newTransformer();
            this.setParams(transformer, arrayList);
            if (string != null) {
                ((Controller)transformer).setInitialMode(string);
            }
            StreamResult streamResult = file == null ? new StreamResult(System.out) : new StreamResult(file.toURI().toString());
            try {
                transformer.transform(source, streamResult);
            }
            catch (TerminationException terminationException) {
                throw terminationException;
            }
            catch (XPathException xPathException) {
                throw new DynamicError("Run-time errors were reported");
            }
            long l3 = Transform.now();
            l += l3 - l2;
            if (this.showTime) {
                System.err.println("Execution time: " + (l3 - l2) + " milliseconds");
                System.err.println("Memory used: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
                this.config.getNamePool().statistics();
                if (this.repeat > 1) {
                    System.err.println("-------------------------------");
                    Runtime.getRuntime().gc();
                }
            }
            if (this.repeat == 999999 && l > 60000L) break;
        }
        if (this.repeat > 1) {
            System.err.println("*** Average execution time over " + n + " runs: " + l / (long)n + "ms");
        }
    }

    public void execute(String string, Templates templates, File file, ArrayList arrayList, String string2) throws TransformerException {
        for (int i = 0; i < this.repeat; ++i) {
            if (this.showTime) {
                System.err.println("Calling template " + string);
            }
            long l = Transform.now();
            Transformer transformer = templates.newTransformer();
            this.setParams(transformer, arrayList);
            if (string2 != null) {
                ((Controller)transformer).setInitialMode(string2);
            }
            ((Controller)transformer).setInitialTemplate(string);
            StreamResult streamResult = file == null ? new StreamResult(System.out) : new StreamResult(file.toURI().toString());
            try {
                transformer.transform(null, streamResult);
            }
            catch (TerminationException terminationException) {
                throw terminationException;
            }
            catch (XPathException xPathException) {
                throw new DynamicError("Run-time errors were reported");
            }
            if (!this.showTime) continue;
            long l2 = Transform.now();
            System.err.println("Execution time: " + (l2 - l) + " milliseconds");
        }
    }

    private void setParams(Transformer transformer, ArrayList arrayList) throws TransformerException {
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            String string = (String)arrayList.get(i);
            String string2 = string.substring(0, n = string.indexOf("="));
            if (string2.startsWith("!")) {
                transformer.setOutputProperty(string2.substring(1), string.substring(n + 1));
                continue;
            }
            if (string2.startsWith("+")) {
                Object object = Transform.loadDocuments(string.substring(n + 1), this.useURLs, this.config, true);
                transformer.setParameter(string2.substring(1), object);
                continue;
            }
            transformer.setParameter(string2, new UntypedAtomicValue(string.substring(n + 1)));
        }
    }

    public void setPOption(Configuration configuration) {
        this.factory.setAttribute("http://saxon.sf.net/feature/recognize-uri-query-parameters", true);
    }

    protected void badUsage(String string, String string2) {
        if (!"".equals(string2)) {
            System.err.println(string2);
        }
        if (!this.showTime) {
            System.err.println(this.config.getProductTitle());
        }
        System.err.println("Usage: " + string + " [options] source-doc style-doc {param=value}...");
        System.err.println("Options: ");
        System.err.println("  -a              Use xml-stylesheet PI, not style-doc argument");
        System.err.println("  -c              Indicates that style-doc is a compiled stylesheet");
        System.err.println("  -cr classname   Use specified collection URI resolver class");
        System.err.println("  -ds             Use linked tree data structure");
        System.err.println("  -dt             Use tiny tree data structure (default)");
        System.err.println("  -im modename    Start transformation in specified mode");
        System.err.println("  -it template    Start transformation by calling named template");
        System.err.println("  -l              Retain line numbers in source document tree");
        System.err.println("  -o filename     Send output to named file or directory");
        System.err.println("  -or classname   Use specified OutputURIResolver class");
        System.err.println("  -m classname    Use specified Emitter class for xsl:message output");
        System.err.println("  -novw           Suppress warning when running with an XSLT 1.0 stylesheet");
        System.err.println("  -r classname    Use specified URIResolver class");
        System.err.println("  -p              Recognize Saxon file extensions and query parameters");
        System.err.println("  -sa             Schema-aware transformation");
        System.err.println("  -sall           Strip all whitespace text nodes");
        System.err.println("  -signorable     Strip ignorable whitespace text nodes (default)");
        System.err.println("  -snone          Strip no whitespace text nodes");
        System.err.println("  -t              Display version and timing information");
        System.err.println("  -T              Set standard TraceListener");
        System.err.println("  -TJ             Trace calls to external Java functions");
        System.err.println("  -TL classname   Set a specific TraceListener");
        System.err.println("  -TP             Collect timing profile");
        System.err.println("  -u              Names are URLs not filenames");
        System.err.println("  -v              Validate source documents using DTD");
        System.err.println("  -val            Validate source documents using schema");
        System.err.println("  -vlax           Lax validation of source documents using schema");
        System.err.println("  -vw             Treat validation errors on result document as warnings");
        System.err.println("  -w0             Recover silently from recoverable errors");
        System.err.println("  -w1             Report recoverable errors and continue (default)");
        System.err.println("  -w2             Treat recoverable errors as fatal");
        System.err.println("  -x classname    Use specified SAX parser for source file");
        System.err.println("  -y classname    Use specified SAX parser for stylesheet");
        System.err.println("  -1.1            Allow XML 1.1 documents");
        System.err.println("  -?              Display this message ");
        System.err.println("  param=value     Set stylesheet string parameter");
        System.err.println("  +param=file     Set stylesheet document parameter");
        System.err.println("  !option=value   Set serialization option");
        if ("".equals(string2)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }
}

