/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> void Options::set(
    options::assignFunctionValues__option_t,
    const options::assignFunctionValues__option_t::type& x)
{
  d_holder->assignFunctionValues = x;
}
template <> const options::assignFunctionValues__option_t::type& Options::operator[](
    options::assignFunctionValues__option_t) const
{
  return d_holder->assignFunctionValues;
}
template <> bool Options::wasSetByUser(options::assignFunctionValues__option_t) const
{
  return d_holder->assignFunctionValues__setByUser__;
}
template <> const options::condenseFunctionValues__option_t::type& Options::operator[](
    options::condenseFunctionValues__option_t) const
{
  return d_holder->condenseFunctionValues;
}
template <> bool Options::wasSetByUser(options::condenseFunctionValues__option_t) const
{
  return d_holder->condenseFunctionValues__setByUser__;
}
template <> void Options::set(
    options::theoryOfMode__option_t,
    const options::theoryOfMode__option_t::type& x)
{
  d_holder->theoryOfMode = x;
}
template <> const options::theoryOfMode__option_t::type& Options::operator[](
    options::theoryOfMode__option_t) const
{
  return d_holder->theoryOfMode;
}
template <> bool Options::wasSetByUser(options::theoryOfMode__option_t) const
{
  return d_holder->theoryOfMode__setByUser__;
}
template <> const options::useTheoryList__option_t::type& Options::operator[](
    options::useTheoryList__option_t) const
{
  return d_holder->useTheoryList;
}
template <> bool Options::wasSetByUser(options::useTheoryList__option_t) const
{
  return d_holder->useTheoryList__setByUser__;
}


namespace options {

struct assignFunctionValues__option_t assignFunctionValues;
struct condenseFunctionValues__option_t condenseFunctionValues;
struct theoryOfMode__option_t theoryOfMode;
struct useTheoryList__option_t useTheoryList;


}  // namespace options
}  // namespace CVC4
