package AllSrc;
use warnings;
use strict;
use integer;
use AllSrcBin;
our @ISA = ( 'AllSrcBin' );
use DebSrc;

sub new {
  my $class = shift;
  my $src   = AllSrcBin::new( 'AllSrc', @_ );
  bless $src, $class;
  return $src;
}

sub instantiate_one {
  my( $src, $fh ) = @_;
  return DebSrc->new( $fh );
}

# Refer each source to its respective binaries.  (Notice that the
# package cannot use AllBin, or there would be a circular package
# dependency.  However, because no AllBin method is called, because the
# AllBin object is treated here as a simple hash, it does not matter.
# This may breaks standard OO notions, but it seems to fit here.)
sub refer_to_bin {
  my( $src, $bin )     = @_;
  $src->{$_}{binaries} = [] for keys %$src;
  for my $pname ( sort grep {length} keys %$bin ) {
    my $source = $bin->{$pname}{Source};
    push @{ $src->{$source}{binaries} }, $pname;
  }
  return $src;
}

1;

