/*
 
   Derby - Class org.apache.derby.jdbc.Driver42
 
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at
 
      http://www.apache.org/licenses/LICENSE-2.0
 
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 
 */

package org.apache.derby.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.BrokeredConnection42;
import org.apache.derby.iapi.sql.ResultSet;

import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement42;
import org.apache.derby.impl.jdbc.EmbedCallableStatement42;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSet42;

/**
 * <p>
 * Embedded JDBC driver for JDBC 4.2.
 * </p>
 */
public class Driver42 extends Driver40
{
    public PreparedStatement newEmbedPreparedStatement
        (
         EmbedConnection conn,
         String stmt,
         boolean forMetaData,
         int resultSetType,
         int resultSetConcurrency,
         int resultSetHoldability,
         int autoGeneratedKeys,
         int[] columnIndexes,
         String[] columnNames
         )  throws SQLException
    {
        return new EmbedPreparedStatement42
            (
             conn,
             stmt,
             forMetaData,
             resultSetType,
             resultSetConcurrency,
             resultSetHoldability,
             autoGeneratedKeys,
             columnIndexes,
             columnNames
             );
    }

    public BrokeredConnection newBrokeredConnection(
            BrokeredConnectionControl control) throws SQLException {
        return new BrokeredConnection42(control);
    }
    
    public EmbedResultSet newEmbedResultSet
        (
         EmbedConnection conn, ResultSet results, boolean forMetaData,
         org.apache.derby.impl.jdbc.EmbedStatement statement,
         boolean isAtomic
         ) throws SQLException
    {
        return new EmbedResultSet42( conn, results, forMetaData, statement, isAtomic );
    }

    public CallableStatement newEmbedCallableStatement(
        EmbedConnection conn,
        String stmt,
        int resultSetType,
        int resultSetConcurrency,
        int resultSetHoldability)
        throws SQLException {
        return new EmbedCallableStatement42(conn,
            stmt,
            resultSetType,
            resultSetConcurrency,
            resultSetHoldability);
    }

}
