# -*- coding: utf-8 -*-
# Generated by Django 1.10.dev20151005181923 on 2015-10-09 22:39
from __future__ import absolute_import, unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import djcelery.picklefield


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CrontabSchedule',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID')),
                ('minute', models.CharField(
                    default='*', max_length=64, verbose_name='minute')),
                ('hour', models.CharField(
                    default='*', max_length=64, verbose_name='hour')),
                ('day_of_week', models.CharField(
                    default='*', max_length=64, verbose_name='day of week')),
                ('day_of_month', models.CharField(
                    default='*', max_length=64, verbose_name='day of month')),
                ('month_of_year', models.CharField(
                    default='*', max_length=64, verbose_name='month of year')),
            ],
            options={
                'ordering': [
                    'month_of_year', 'day_of_month',
                    'day_of_week', 'hour', 'minute'],
                'verbose_name': 'crontab',
                'verbose_name_plural': 'crontabs',
            },
        ),
        migrations.CreateModel(
            name='IntervalSchedule',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID')),
                ('every', models.IntegerField(verbose_name='every')),
                ('period', models.CharField(
                    choices=[
                        ('days', 'Days'),
                        ('hours', 'Hours'),
                        ('minutes', 'Minutes'),
                        ('seconds', 'Seconds'),
                        ('microseconds', 'Microseconds')],
                    max_length=24, verbose_name='period')),
            ],
            options={
                'ordering': ['period', 'every'],
                'verbose_name': 'interval',
                'verbose_name_plural': 'intervals',
            },
        ),
        migrations.CreateModel(
            name='PeriodicTask',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID')),
                ('name', models.CharField(
                    help_text='Useful description', max_length=200,
                    unique=True, verbose_name='name')),
                ('task', models.CharField(
                    max_length=200, verbose_name='task name')),
                ('args', models.TextField(
                    blank=True, default='[]',
                    help_text='JSON encoded positional arguments',
                    verbose_name='Arguments')),
                ('kwargs', models.TextField(
                    blank=True, default='{}',
                    help_text='JSON encoded keyword arguments',
                    verbose_name='Keyword arguments')),
                ('queue', models.CharField(
                    blank=True, default=None,
                    help_text='Queue defined in CELERY_QUEUES',
                    max_length=200, null=True, verbose_name='queue')),
                ('exchange', models.CharField(
                    blank=True, default=None, max_length=200,
                    null=True, verbose_name='exchange')),
                ('routing_key', models.CharField(
                    blank=True, default=None, max_length=200,
                    null=True, verbose_name='routing key')),
                ('expires', models.DateTimeField(
                    blank=True, null=True, verbose_name='expires')),
                ('enabled', models.BooleanField(
                    default=True, verbose_name='enabled')),
                ('last_run_at', models.DateTimeField(
                    blank=True, editable=False, null=True)),
                ('total_run_count', models.PositiveIntegerField(
                    default=0, editable=False)),
                ('date_changed', models.DateTimeField(
                    auto_now=True)),
                ('description', models.TextField(
                    blank=True, verbose_name='description')),
                ('crontab', models.ForeignKey(
                    blank=True,
                    help_text='Use one of interval/crontab', null=True,
                    on_delete=django.db.models.deletion.CASCADE,
                    to='djcelery.CrontabSchedule', verbose_name='crontab')),
                ('interval', models.ForeignKey(
                    blank=True, null=True,
                    on_delete=django.db.models.deletion.CASCADE,
                    to='djcelery.IntervalSchedule', verbose_name='interval')),
            ],
            options={
                'verbose_name': 'periodic task',
                'verbose_name_plural': 'periodic tasks',
            },
        ),
        migrations.CreateModel(
            name='PeriodicTasks',
            fields=[
                ('ident', models.SmallIntegerField(
                    default=1, primary_key=True,
                    serialize=False, unique=True)),
                ('last_update', models.DateTimeField()),
            ],
        ),
        migrations.CreateModel(
            name='TaskMeta',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID')),
                ('task_id', models.CharField(
                    max_length=255, unique=True,
                    verbose_name='task id')),
                ('status', models.CharField(
                    choices=[
                        (b'RECEIVED', b'RECEIVED'),
                        (b'RETRY', b'RETRY'),
                        (b'REVOKED', b'REVOKED'),
                        (b'SUCCESS', b'SUCCESS'),
                        (b'STARTED', b'STARTED'),
                        (b'FAILURE', b'FAILURE'),
                        (b'PENDING', b'PENDING')],
                    default=b'PENDING', max_length=50,
                    verbose_name='state')),
                ('result', djcelery.picklefield.PickledObjectField(
                    default=None, editable=False, null=True)),
                ('date_done', models.DateTimeField(
                    auto_now=True, verbose_name='done at')),
                ('traceback', models.TextField(
                    blank=True, null=True, verbose_name='traceback')),
                ('hidden', models.BooleanField(
                    db_index=True, default=False, editable=False)),
                ('meta', djcelery.picklefield.PickledObjectField(
                    default=None, editable=False, null=True)),
            ],
            options={
                'db_table': 'celery_taskmeta',
                'verbose_name': 'task state',
                'verbose_name_plural': 'task states',
            },
        ),
        migrations.CreateModel(
            name='TaskSetMeta',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID')),
                ('taskset_id', models.CharField(
                    max_length=255, unique=True,
                    verbose_name='group id')),
                ('result', djcelery.picklefield.PickledObjectField(
                    editable=False)),
                ('date_done', models.DateTimeField(
                    auto_now=True, verbose_name='created at')),
                ('hidden', models.BooleanField(
                    db_index=True, default=False, editable=False)),
            ],
            options={
                'db_table': 'celery_tasksetmeta',
                'verbose_name': 'saved group result',
                'verbose_name_plural': 'saved group results',
            },
        ),
        migrations.CreateModel(
            name='TaskState',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID')),
                ('state', models.CharField(
                    choices=[
                        (b'RECEIVED', b'RECEIVED'),
                        (b'RETRY', b'RETRY'),
                        (b'REVOKED', b'REVOKED'),
                        (b'SUCCESS', b'SUCCESS'),
                        (b'STARTED', b'STARTED'),
                        (b'FAILURE', b'FAILURE'),
                        (b'PENDING', b'PENDING')],
                    db_index=True, max_length=64, verbose_name='state')),
                ('task_id', models.CharField(
                    max_length=36, unique=True, verbose_name='UUID')),
                ('name', models.CharField(
                    db_index=True, max_length=200,
                    null=True, verbose_name='name')),
                ('tstamp', models.DateTimeField(
                    db_index=True, verbose_name='event received at')),
                ('args', models.TextField(
                    null=True, verbose_name='Arguments')),
                ('kwargs', models.TextField(
                    null=True, verbose_name='Keyword arguments')),
                ('eta', models.DateTimeField(
                    null=True, verbose_name='ETA')),
                ('expires', models.DateTimeField(
                    null=True, verbose_name='expires')),
                ('result', models.TextField(
                    null=True, verbose_name='result')),
                ('traceback', models.TextField(
                    null=True, verbose_name='traceback')),
                ('runtime', models.FloatField(
                    help_text='in seconds if task succeeded',
                    null=True, verbose_name='execution time')),
                ('retries', models.IntegerField(
                    default=0, verbose_name='number of retries')),
                ('hidden', models.BooleanField(
                    db_index=True, default=False, editable=False)),
            ],
            options={
                'ordering': ['-tstamp'],
                'get_latest_by': 'tstamp',
                'verbose_name': 'task',
                'verbose_name_plural': 'tasks',
            },
        ),
        migrations.CreateModel(
            name='WorkerState',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID')),
                ('hostname', models.CharField(
                    max_length=255, unique=True, verbose_name='hostname')),
                ('last_heartbeat', models.DateTimeField(
                    db_index=True, null=True, verbose_name='last heartbeat')),
            ],
            options={
                'ordering': ['-last_heartbeat'],
                'get_latest_by': 'last_heartbeat',
                'verbose_name': 'worker',
                'verbose_name_plural': 'workers',
            },
        ),
        migrations.AddField(
            model_name='taskstate',
            name='worker',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='djcelery.WorkerState', verbose_name='worker'),
        ),
    ]
