# Development Report for Mar 24, 2017

## Container Level Metrics

* https://github.com/containerd/containerd/pull/646

We merged a PR to add our first pass of container level metrics to our
prometheus output in containerd. We still have to review the metric names and
structure before having something we are all comfortable supporting in the long
run but we now have comprehensive metrics for all containers running on
containerd.

## Distribution

After hitting a major milestone of getting a proof of concept for end to end
pull and run, this week the focus was on getting that code in the right place
and figure out where the implementation gaps are.

### Image to OCI Spec

* https://github.com/containerd/containerd/pull/660

We merged support for getting an image config that was pulled off of a registry
and generating a spec based on the image properties in the `ctr` command.  This
will let you pull images off of a registry and run them based on the config and
how the image was built.

Its very simple at the moment but will will be porting over the default spec
and generation code from Docker soon into a package that can be easily consumed
by clients of containerd.

You can test this by running:

```console
bash
sudo dist pull docker.io/library/redis:alpine
sudo ctr run --id redis -t docker.io/library/redis:alpine
```

### Image handlers

* https://github.com/containerd/containerd/pull/638

We refactored the fetch command into a more generic image handler interface. As
we look forward to supporting the full oci image spec as well as the Docker
distribution specifications, we are removing any opinionated code to make
distribution as generalized and efficient as possible.

### Image listing now with full image size

```console
$ dist images
REF                                    TYPE                                                 DIGEST                                                                  SIZE     
docker.io/library/redis:latest         application/vnd.docker.distribution.manifest.v2+json sha256:1b358a2b0dc2629af3ed75737e2f07e5b3408eabf76a8fa99606ec0c276a93f8 71.0 MiB
```

## Snapshot driver improvements

* https://github.com/containerd/containerd/pull/635

The `overlay` and `btrfs` driver implementations are now fully implemented and
share an implementation for metadata storage. This new metadata storage package
allows not only making snapshot drivers easier, but allow us to focus on making
our existing drivers more resilient and stable once.
