<?php class Doctrine_Core { const VERSION = '1.2.3'; const ERR = -1; const ERR_SYNTAX = -2; const ERR_CONSTRAINT = -3; const ERR_NOT_FOUND = -4; const ERR_ALREADY_EXISTS = -5; const ERR_UNSUPPORTED = -6; const ERR_MISMATCH = -7; const ERR_INVALID = -8; const ERR_NOT_CAPABLE = -9; const ERR_TRUNCATED = -10; const ERR_INVALID_NUMBER = -11; const ERR_INVALID_DATE = -12; const ERR_DIVZERO = -13; const ERR_NODBSELECTED = -14; const ERR_CANNOT_CREATE = -15; const ERR_CANNOT_DELETE = -16; const ERR_CANNOT_DROP = -17; const ERR_NOSUCHTABLE = -18; const ERR_NOSUCHFIELD = -19; const ERR_NEED_MORE_DATA = -20; const ERR_NOT_LOCKED = -21; const ERR_VALUE_COUNT_ON_ROW = -22; const ERR_INVALID_DSN = -23; const ERR_CONNECT_FAILED = -24; const ERR_EXTENSION_NOT_FOUND = -25; const ERR_NOSUCHDB = -26; const ERR_ACCESS_VIOLATION = -27; const ERR_CANNOT_REPLACE = -28; const ERR_CONSTRAINT_NOT_NULL = -29; const ERR_DEADLOCK = -30; const ERR_CANNOT_ALTER = -31; const ERR_MANAGER = -32; const ERR_MANAGER_PARSE = -33; const ERR_LOADMODULE = -34; const ERR_INSUFFICIENT_DATA = -35; const ERR_CLASS_NAME = -36; const CASE_LOWER = 2; const CASE_NATURAL = 0; const CASE_UPPER = 1; const CURSOR_FWDONLY = 0; const CURSOR_SCROLL = 1; const ERRMODE_EXCEPTION = 2; const ERRMODE_SILENT = 0; const ERRMODE_WARNING = 1; const FETCH_ASSOC = 2; const FETCH_BOTH = 4; const FETCH_BOUND = 6; const FETCH_CLASS = 8; const FETCH_CLASSTYPE = 262144; const FETCH_COLUMN = 7; const FETCH_FUNC = 10; const FETCH_GROUP = 65536; const FETCH_INTO = 9; const FETCH_LAZY = 1; const FETCH_NAMED = 11; const FETCH_NUM = 3; const FETCH_OBJ = 5; const FETCH_ORI_ABS = 4; const FETCH_ORI_FIRST = 2; const FETCH_ORI_LAST = 3; const FETCH_ORI_NEXT = 0; const FETCH_ORI_PRIOR = 1; const FETCH_ORI_REL = 5; const FETCH_SERIALIZE = 524288; const FETCH_UNIQUE = 196608; const NULL_EMPTY_STRING = 1; const NULL_NATURAL = 0; const NULL_TO_STRING = NULL; const PARAM_BOOL = 5; const PARAM_INPUT_OUTPUT = -2147483648; const PARAM_INT = 1; const PARAM_LOB = 3; const PARAM_NULL = 0; const PARAM_STMT = 4; const PARAM_STR = 2; const ATTR_AUTOCOMMIT = 0; const ATTR_PREFETCH = 1; const ATTR_TIMEOUT = 2; const ATTR_ERRMODE = 3; const ATTR_SERVER_VERSION = 4; const ATTR_CLIENT_VERSION = 5; const ATTR_SERVER_INFO = 6; const ATTR_CONNECTION_STATUS = 7; const ATTR_CASE = 8; const ATTR_CURSOR_NAME = 9; const ATTR_CURSOR = 10; const ATTR_ORACLE_NULLS = 11; const ATTR_PERSISTENT = 12; const ATTR_STATEMENT_CLASS = 13; const ATTR_FETCH_TABLE_NAMES = 14; const ATTR_FETCH_CATALOG_NAMES = 15; const ATTR_DRIVER_NAME = 16; const ATTR_STRINGIFY_FETCHES = 17; const ATTR_MAX_COLUMN_LEN = 18; const ATTR_LISTENER = 100; const ATTR_QUOTE_IDENTIFIER = 101; const ATTR_FIELD_CASE = 102; const ATTR_IDXNAME_FORMAT = 103; const ATTR_SEQNAME_FORMAT = 104; const ATTR_SEQCOL_NAME = 105; const ATTR_CMPNAME_FORMAT = 118; const ATTR_DBNAME_FORMAT = 117; const ATTR_TBLCLASS_FORMAT = 119; const ATTR_TBLNAME_FORMAT = 120; const ATTR_FKNAME_FORMAT = 171; const ATTR_EXPORT = 140; const ATTR_DECIMAL_PLACES = 141; const ATTR_PORTABILITY = 106; const ATTR_VALIDATE = 107; const ATTR_COLL_KEY = 108; const ATTR_QUERY_LIMIT = 109; const ATTR_DEFAULT_TABLE_TYPE = 112; const ATTR_DEF_TEXT_LENGTH = 113; const ATTR_DEF_VARCHAR_LENGTH = 114; const ATTR_DEF_TABLESPACE = 115; const ATTR_EMULATE_DATABASE = 116; const ATTR_USE_NATIVE_ENUM = 117; const ATTR_DEFAULT_SEQUENCE = 133; const ATTR_FETCHMODE = 118; const ATTR_NAME_PREFIX = 121; const ATTR_CREATE_TABLES = 122; const ATTR_COLL_LIMIT = 123; const ATTR_CACHE = 150; const ATTR_RESULT_CACHE = 150; const ATTR_CACHE_LIFESPAN = 151; const ATTR_RESULT_CACHE_LIFESPAN = 151; const ATTR_LOAD_REFERENCES = 153; const ATTR_RECORD_LISTENER = 154; const ATTR_THROW_EXCEPTIONS = 155; const ATTR_DEFAULT_PARAM_NAMESPACE = 156; const ATTR_QUERY_CACHE = 157; const ATTR_QUERY_CACHE_LIFESPAN = 158; const ATTR_AUTOLOAD_TABLE_CLASSES = 160; const ATTR_MODEL_LOADING = 161; const ATTR_RECURSIVE_MERGE_FIXTURES = 162; const ATTR_USE_DQL_CALLBACKS = 164; const ATTR_AUTO_ACCESSOR_OVERRIDE = 165; const ATTR_AUTO_FREE_QUERY_OBJECTS = 166; const ATTR_DEFAULT_TABLE_CHARSET = 167; const ATTR_DEFAULT_TABLE_COLLATE = 168; const ATTR_DEFAULT_IDENTIFIER_OPTIONS = 169; const ATTR_DEFAULT_COLUMN_OPTIONS = 170; const ATTR_HYDRATE_OVERWRITE = 172; const ATTR_QUERY_CLASS = 173; const ATTR_CASCADE_SAVES = 174; const ATTR_COLLECTION_CLASS = 175; const ATTR_TABLE_CLASS = 176; const ATTR_USE_NATIVE_SET = 177; const ATTR_MODEL_CLASS_PREFIX = 178; const ATTR_TABLE_CLASS_FORMAT = 179; const ATTR_MAX_IDENTIFIER_LENGTH = 180; const LIMIT_ROWS = 1; const QUERY_LIMIT_ROWS = 1; const LIMIT_RECORDS = 2; const QUERY_LIMIT_RECORDS = 2; const PORTABILITY_NONE = 0; const PORTABILITY_FIX_CASE = 1; const PORTABILITY_RTRIM = 2; const PORTABILITY_DELETE_COUNT = 4; const PORTABILITY_EMPTY_TO_NULL = 8; const PORTABILITY_FIX_ASSOC_FIELD_NAMES = 16; const PORTABILITY_EXPR = 32; const PORTABILITY_ALL = 63; const LOCK_OPTIMISTIC = 0; const LOCK_PESSIMISTIC = 1; const EXPORT_NONE = 0; const EXPORT_TABLES = 1; const EXPORT_CONSTRAINTS = 2; const EXPORT_PLUGINS = 4; const EXPORT_ALL = 7; const HYDRATE_RECORD = 2; const HYDRATE_ARRAY = 3; const HYDRATE_NONE = 4; const HYDRATE_SCALAR = 5; const HYDRATE_SINGLE_SCALAR = 6; const HYDRATE_ON_DEMAND = 7; const HYDRATE_ARRAY_HIERARCHY = 8; const HYDRATE_RECORD_HIERARCHY = 9; const VALIDATE_NONE = 0; const VALIDATE_LENGTHS = 1; const VALIDATE_TYPES = 2; const VALIDATE_CONSTRAINTS = 4; const VALIDATE_ALL = 7; const VALIDATE_USER = 8; const IDENTIFIER_AUTOINC = 1; const IDENTIFIER_SEQUENCE = 2; const IDENTIFIER_NATURAL = 3; const IDENTIFIER_COMPOSITE = 4; const MODEL_LOADING_AGGRESSIVE = 1; const MODEL_LOADING_CONSERVATIVE = 2; const MODEL_LOADING_PEAR = 3; private static $_path; private static $_extensionsPath; private static $_debug = false; private static $_loadedModelFiles = array(); private static $_validators = array(); private static $_modelsDirectory; public function __construct() { throw new Doctrine_Exception('Doctrine is static class. No instances can be created.'); } public static function getLoadedModelFiles() { return self::$_loadedModelFiles; } public static function debug($bool = null) { if ($bool !== null) { self::$_debug = (bool) $bool; } return self::$_debug; } public static function setPath($path) { self::$_path = $path; } public static function getPath() { if ( ! self::$_path) { self::$_path = realpath(dirname(__FILE__) . '/..'); } return self::$_path; } public static function setExtensionsPath($extensionsPath) { self::$_extensionsPath = $extensionsPath; } public static function getExtensionsPath() { return self::$_extensionsPath; } public static function loadModel($className, $path = null) { self::$_loadedModelFiles[$className] = $path; } public static function setModelsDirectory($directory) { if(is_array(self::$_modelsDirectory)) self::$_modelsDirectory[] = $directory; else self::$_modelsDirectory = array($directory); } public static function getModelsDirectory() { return self::$_modelsDirectory; } public static function loadModels($directory, $modelLoading = null, $classPrefix = null) { $manager = Doctrine_Manager::getInstance(); $modelLoading = $modelLoading === null ? $manager->getAttribute(Doctrine_Core::ATTR_MODEL_LOADING) : $modelLoading; $classPrefix = $classPrefix === null ? $manager->getAttribute(Doctrine_Core::ATTR_MODEL_CLASS_PREFIX) : $classPrefix; $loadedModels = array(); if ($directory !== null) { foreach ((array) $directory as $dir) { $dir = rtrim($dir, '/'); if ( ! is_dir($dir)) { throw new Doctrine_Exception('You must pass a valid path to a directory containing Doctrine models'); } $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir), RecursiveIteratorIterator::LEAVES_ONLY); foreach ($it as $file) { $e = explode('.', $file->getFileName()); if (end($e) === 'php' && strpos($file->getFileName(), '.inc') === false) { if ($modelLoading == Doctrine_Core::MODEL_LOADING_PEAR) { $className = str_replace($dir . DIRECTORY_SEPARATOR, null, $file->getPathName()); $className = str_replace(DIRECTORY_SEPARATOR, '_', $className); $className = substr($className, 0, strpos($className, '.')); } else { $className = $e[0]; } if ($classPrefix && $classPrefix != substr($className, 0, strlen($classPrefix))) { $className = $classPrefix . $className; } if ( ! class_exists($className, false)) { if ($modelLoading == Doctrine_Core::MODEL_LOADING_CONSERVATIVE || $modelLoading == Doctrine_Core::MODEL_LOADING_PEAR) { self::loadModel($className, $file->getPathName()); $loadedModels[$className] = $className; } else { $declaredBefore = get_declared_classes(); require_once($file->getPathName()); $declaredAfter = get_declared_classes(); $foundClasses = array_slice($declaredAfter, count($declaredBefore)); if ($foundClasses) { foreach ($foundClasses as $className) { if (self::isValidModelClass($className)) { $loadedModels[$className] = $className; self::loadModel($className, $file->getPathName()); } } } $previouslyLoaded = array_keys(self::$_loadedModelFiles, $file->getPathName()); if ( ! empty($previouslyLoaded)) { $previouslyLoaded = array_combine(array_values($previouslyLoaded), array_values($previouslyLoaded)); $loadedModels = array_merge($loadedModels, $previouslyLoaded); } } } else if (self::isValidModelClass($className)) { $loadedModels[$className] = $className; } } } } } asort($loadedModels); return $loadedModels; } public static function getLoadedModels($classes = null) { if ($classes === null) { $classes = get_declared_classes(); $classes = array_merge($classes, array_keys(self::$_loadedModelFiles)); } return self::filterInvalidModels($classes); } public static function initializeModels($models) { $models = self::filterInvalidModels($models); foreach ($models as $model) { $declaredBefore = get_declared_classes(); Doctrine_Core::getTable($model); $declaredAfter = get_declared_classes(); $foundClasses = array_slice($declaredAfter, count($declaredBefore) - 1); foreach ($foundClasses as $class) { if (self::isValidModelClass($class)) { $models[] = $class; } } } $models = self::filterInvalidModels($models); return $models; } public static function filterInvalidModels($classes) { $validModels = array(); foreach ((array) $classes as $name) { if (self::isValidModelClass($name) && ! in_array($name, $validModels)) { $validModels[] = $name; } } return $validModels; } public static function isValidModelClass($class) { if ($class instanceof Doctrine_Record) { $class = get_class($class); } if (is_string($class) && class_exists($class)) { $class = new ReflectionClass($class); } if ($class instanceof ReflectionClass) { if ( ! $class->isAbstract() && $class->isSubClassOf('Doctrine_Record')) { return true; } } return false; } public static function getConnectionByTableName($tableName) { $loadedModels = self::getLoadedModels(); foreach ($loadedModels as $name) { $table = Doctrine_Core::getTable($name); if ($table->getTableName() == $tableName) { return $table->getConnection(); } } return Doctrine_Manager::connection(); } public static function generateModelsFromDb($directory, array $connections = array(), array $options = array()) { return Doctrine_Manager::connection()->import->importSchema($directory, $connections, $options); } public static function generateYamlFromDb($yamlPath, array $connections = array(), array $options = array()) { $directory = sys_get_temp_dir() . DIRECTORY_SEPARATOR . 'tmp_doctrine_models'; $options['generateBaseClasses'] = isset($options['generateBaseClasses']) ? $options['generateBaseClasses']:false; $result = Doctrine_Core::generateModelsFromDb($directory, $connections, $options); if ( empty($result) && ! is_dir($directory)) { throw new Doctrine_Exception('No models generated from your databases'); } $export = new Doctrine_Export_Schema(); $result = $export->exportSchema($yamlPath, 'yml', $directory, array(), Doctrine_Core::MODEL_LOADING_AGGRESSIVE); Doctrine_Lib::removeDirectories($directory); return $result; } public static function generateModelsFromYaml($yamlPath, $directory, $options = array()) { $import = new Doctrine_Import_Schema(); $import->setOptions($options); return $import->importSchema($yamlPath, 'yml', $directory); } public static function createTablesFromModels($directory = null) { return Doctrine_Manager::connection()->export->exportSchema($directory); } public static function createTablesFromArray($array) { return Doctrine_Manager::connection()->export->exportClasses($array); } public static function generateSqlFromArray($array) { return Doctrine_Manager::connection()->export->exportClassesSql($array); } public static function generateSqlFromModels($directory = null) { $conn = Doctrine_Manager::connection(); $sql = $conn->export->exportSql($directory); $build = ''; foreach ($sql as $query) { $build .= $query.$conn->sql_file_delimiter; } return $build; } public static function generateYamlFromModels($yamlPath, $directory) { $export = new Doctrine_Export_Schema(); return $export->exportSchema($yamlPath, 'yml', $directory); } public static function createDatabases($specifiedConnections = array()) { return Doctrine_Manager::getInstance()->createDatabases($specifiedConnections); } public static function dropDatabases($specifiedConnections = array()) { return Doctrine_Manager::getInstance()->dropDatabases($specifiedConnections); } public static function dumpData($yamlPath, $individualFiles = false) { $data = new Doctrine_Data(); return $data->exportData($yamlPath, 'yml', array(), $individualFiles); } public static function loadData($yamlPath, $append = false) { $data = new Doctrine_Data(); return $data->importData($yamlPath, 'yml', array(), $append); } public static function migrate($migrationsPath, $to = null) { $migration = new Doctrine_Migration($migrationsPath); return $migration->migrate($to); } public static function generateMigrationClass($className, $migrationsPath) { $builder = new Doctrine_Migration_Builder($migrationsPath); return $builder->generateMigrationClass($className); } public static function generateMigrationsFromDb($migrationsPath) { $builder = new Doctrine_Migration_Builder($migrationsPath); return $builder->generateMigrationsFromDb(); } public static function generateMigrationsFromModels($migrationsPath, $modelsPath = null, $modelLoading = null) { $builder = new Doctrine_Migration_Builder($migrationsPath); return $builder->generateMigrationsFromModels($modelsPath, $modelLoading); } public static function generateMigrationsFromDiff($migrationsPath, $from, $to) { $diff = new Doctrine_Migration_Diff($from, $to, $migrationsPath); return $diff->generateMigrationClasses(); } public static function getTable($componentName) { return Doctrine_Manager::getInstance()->getConnectionForComponent($componentName)->getTable($componentName); } public static function compile($target = null, $includedDrivers = array()) { return Doctrine_Compiler::compile($target, $includedDrivers); } public static function autoload($className) { if (strpos($className, 'sfYaml') === 0) { require dirname(__FILE__) . '/Parser/sfYaml/' . $className . '.php'; return true; } if (0 !== stripos($className, 'Doctrine') || class_exists($className, false) || interface_exists($className, false)) { return false; } $class = self::getPath() . DIRECTORY_SEPARATOR . str_replace('_', DIRECTORY_SEPARATOR, $className) . '.php'; if (file_exists($class)) { require $class; return true; } return false; } public static function modelsAutoload($className) { if (class_exists($className, false) || interface_exists($className, false)) { return false; } if ( ! self::$_modelsDirectory) { $loadedModels = self::$_loadedModelFiles; if (isset($loadedModels[$className]) && file_exists($loadedModels[$className])) { require $loadedModels[$className]; return true; } } else { if(!is_array(self::$_modelsDirectory)) self::$_modelsDirectory = array(self::$_modelsDirectory); foreach(self::$_modelsDirectory as $directory) { $class = $directory . DIRECTORY_SEPARATOR . str_replace('_', DIRECTORY_SEPARATOR, $className) . '.php'; if (file_exists($class)) { require $class; return true; } } } return false; } public static function extensionsAutoload($className) { if (class_exists($className, false) || interface_exists($className, false)) { return false; } $extensions = Doctrine_Manager::getInstance() ->getExtensions(); foreach ($extensions as $name => $path) { $class = $path . DIRECTORY_SEPARATOR . str_replace('_', DIRECTORY_SEPARATOR, $className) . '.php'; if (file_exists($class)) { require $class; return true; } } return false; } public static function dump($var, $output = true, $indent = "") { $ret = array(); switch (gettype($var)) { case 'array': $ret[] = 'Array('; $indent .= "    "; foreach ($var as $k => $v) { $ret[] = $indent . $k . ' : ' . self::dump($v, false, $indent); } $indent = substr($indent,0, -4); $ret[] = $indent . ")"; break; case 'object': $ret[] = 'Object(' . get_class($var) . ')'; break; default: $ret[] = var_export($var, true); } if ($output) { print implode("\n", $ret); } return implode("\n", $ret); } }class Doctrine extends Doctrine_Core { }class Doctrine_Compiler { public static function compile($target = null, $includedDrivers = array()) { if ( ! is_array($includedDrivers)) { $includedDrivers = array($includedDrivers); } $excludedDrivers = array(); if ( ! empty($includedDrivers)) { $drivers = array('db2', 'mssql', 'mysql', 'oracle', 'pgsql', 'sqlite'); $excludedDrivers = array_diff($drivers, $includedDrivers); } $path = Doctrine_Core::getPath(); $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path . '/Doctrine'), RecursiveIteratorIterator::LEAVES_ONLY); foreach ($it as $file) { $e = explode('.', $file->getFileName()); if (end($e) === 'php' && strpos($file->getFileName(), '.inc') === false && strpos($file->getFileName(), 'sfYaml') === false) { require_once $file->getPathName(); } } $classes = array_merge(get_declared_classes(), get_declared_interfaces()); $ret = array(); foreach ($classes as $class) { $e = explode('_', $class); if ($e[0] !== 'Doctrine') { continue; } if ( ! empty($excludedDrivers)) { foreach ($excludedDrivers as $excludedDriver) { $excludedDriver = ucfirst($excludedDriver); if (in_array($excludedDriver, $e)) { continue(2); } } } $refl = new ReflectionClass($class); $file = $refl->getFileName(); $lines = file($file); $start = $refl->getStartLine() - 1; $end = $refl->getEndLine(); $ret = array_merge($ret, array_slice($lines, $start, ($end - $start))); } if ($target == null) { $target = $path . DIRECTORY_SEPARATOR . 'Doctrine.compiled.php'; } $fp = @fopen($target, 'w'); if ($fp === false) { throw new Doctrine_Compiler_Exception("Couldn't write compiled data. Failed to open $target"); } fwrite($fp, "<?php ". implode('', $ret)); fclose($fp); $stripped = php_strip_whitespace($target); $fp = @fopen($target, 'w'); if ($fp === false) { throw new Doctrine_Compiler_Exception("Couldn't write compiled data. Failed to open $file"); } fwrite($fp, $stripped); fclose($fp); return $target; } }class Doctrine_Connection_Module { protected $conn; protected $moduleName; public function __construct($conn = null) { if ( ! ($conn instanceof Doctrine_Connection)) { $conn = Doctrine_Manager::getInstance()->getCurrentConnection(); } $this->conn = $conn; $e = explode('_', get_class($this)); $this->moduleName = $e[1]; } public function getConnection() { return $this->conn; } public function getModuleName() { return $this->moduleName; } }class Doctrine_Transaction extends Doctrine_Connection_Module { const STATE_SLEEP = 0; const STATE_ACTIVE = 1; const STATE_BUSY = 2; protected $_nestingLevel = 0; protected $_internalNestingLevel = 0; protected $invalid = array(); protected $savePoints = array(); protected $_collections = array(); public function addCollection(Doctrine_Collection $coll) { $this->_collections[] = $coll; return $this; } public function getState() { switch ($this->_nestingLevel) { case 0: return Doctrine_Transaction::STATE_SLEEP; break; case 1: return Doctrine_Transaction::STATE_ACTIVE; break; default: return Doctrine_Transaction::STATE_BUSY; } } public function addInvalid(Doctrine_Record $record) { if (in_array($record, $this->invalid, true)) { return false; } $this->invalid[] = $record; return true; } public function getInvalid() { return $this->invalid; } public function getTransactionLevel() { return $this->_nestingLevel; } public function getInternalTransactionLevel() { return $this->_internalNestingLevel; } public function beginTransaction($savepoint = null) { $this->conn->connect(); $listener = $this->conn->getAttribute(Doctrine_Core::ATTR_LISTENER); if ( ! is_null($savepoint)) { $this->savePoints[] = $savepoint; $event = new Doctrine_Event($this, Doctrine_Event::SAVEPOINT_CREATE); $listener->preSavepointCreate($event); if ( ! $event->skipOperation) { $this->createSavePoint($savepoint); } $listener->postSavepointCreate($event); } else { if ($this->_nestingLevel == 0) { $event = new Doctrine_Event($this, Doctrine_Event::TX_BEGIN); $listener->preTransactionBegin($event); if ( ! $event->skipOperation) { try { $this->_doBeginTransaction(); } catch (Exception $e) { throw new Doctrine_Transaction_Exception($e->getMessage()); } } $listener->postTransactionBegin($event); } } $level = ++$this->_nestingLevel; return $level; } public function commit($savepoint = null) { if ($this->_nestingLevel == 0) { throw new Doctrine_Transaction_Exception("Commit failed. There is no active transaction."); } $this->conn->connect(); $listener = $this->conn->getAttribute(Doctrine_Core::ATTR_LISTENER); if ( ! is_null($savepoint)) { $this->_nestingLevel -= $this->removeSavePoints($savepoint); $event = new Doctrine_Event($this, Doctrine_Event::SAVEPOINT_COMMIT); $listener->preSavepointCommit($event); if ( ! $event->skipOperation) { $this->releaseSavePoint($savepoint); } $listener->postSavepointCommit($event); } else { if ($this->_nestingLevel == 1 || $this->_internalNestingLevel == 1) { if ( ! empty($this->invalid)) { if ($this->_internalNestingLevel == 1) { $tmp = $this->invalid; $this->invalid = array(); throw new Doctrine_Validator_Exception($tmp); } } if ($this->_nestingLevel == 1) { foreach ($this->_collections as $coll) { $coll->takeSnapshot(); } $this->_collections = array(); $event = new Doctrine_Event($this, Doctrine_Event::TX_COMMIT); $listener->preTransactionCommit($event); if ( ! $event->skipOperation) { $this->_doCommit(); } $listener->postTransactionCommit($event); } } if ($this->_nestingLevel > 0) { $this->_nestingLevel--; } if ($this->_internalNestingLevel > 0) { $this->_internalNestingLevel--; } } return true; } public function rollback($savepoint = null) { if ($this->_nestingLevel == 0) { throw new Doctrine_Transaction_Exception("Rollback failed. There is no active transaction."); } $this->conn->connect(); if ($this->_internalNestingLevel >= 1 && $this->_nestingLevel > 1) { $this->_internalNestingLevel--; $this->_nestingLevel--; return false; } else if ($this->_nestingLevel > 1) { $this->_nestingLevel--; return false; } $listener = $this->conn->getAttribute(Doctrine_Core::ATTR_LISTENER); if ( ! is_null($savepoint)) { $this->_nestingLevel -= $this->removeSavePoints($savepoint); $event = new Doctrine_Event($this, Doctrine_Event::SAVEPOINT_ROLLBACK); $listener->preSavepointRollback($event); if ( ! $event->skipOperation) { $this->rollbackSavePoint($savepoint); } $listener->postSavepointRollback($event); } else { $event = new Doctrine_Event($this, Doctrine_Event::TX_ROLLBACK); $listener->preTransactionRollback($event); if ( ! $event->skipOperation) { $this->_nestingLevel = 0; $this->_internalNestingLevel = 0; try { $this->_doRollback(); } catch (Exception $e) { throw new Doctrine_Transaction_Exception($e->getMessage()); } } $listener->postTransactionRollback($event); } return true; } protected function createSavePoint($savepoint) { throw new Doctrine_Transaction_Exception('Savepoints not supported by this driver.'); } protected function releaseSavePoint($savepoint) { throw new Doctrine_Transaction_Exception('Savepoints not supported by this driver.'); } protected function rollbackSavePoint($savepoint) { throw new Doctrine_Transaction_Exception('Savepoints not supported by this driver.'); } protected function _doRollback() { $this->conn->getDbh()->rollback(); } protected function _doCommit() { $this->conn->getDbh()->commit(); } protected function _doBeginTransaction() { $this->conn->getDbh()->beginTransaction(); } private function removeSavePoints($savepoint) { $this->savePoints = array_values($this->savePoints); $found = false; $i = 0; foreach ($this->savePoints as $key => $sp) { if ( ! $found) { if ($sp === $savepoint) { $found = true; } } if ($found) { $i++; unset($this->savePoints[$key]); } } return $i; } public function setIsolation($isolation) { throw new Doctrine_Transaction_Exception('Transaction isolation levels not supported by this driver.'); } public function getIsolation() { throw new Doctrine_Transaction_Exception('Fetching transaction isolation level not supported by this driver.'); } public function beginInternalTransaction($savepoint = null) { $this->_internalNestingLevel++; return $this->beginTransaction($savepoint); } } class Doctrine_Transaction_Sqlite extends Doctrine_Transaction { public function setIsolation($isolation) { switch ($isolation) { case 'READ UNCOMMITTED': $isolation = 0; break; case 'READ COMMITTED': case 'REPEATABLE READ': case 'SERIALIZABLE': $isolation = 1; break; default: throw new Doctrine_Transaction_Exception('Isolation level ' . $isolation . 'is not supported.'); } $query = 'PRAGMA read_uncommitted = ' . $isolation; return $this->conn->execute($query); } }class Doctrine_Transaction_Mysql extends Doctrine_Transaction { protected function createSavePoint($savepoint) { $query = 'SAVEPOINT ' . $savepoint; return $this->conn->execute($query); } protected function releaseSavePoint($savepoint) { $query = 'RELEASE SAVEPOINT ' . $savepoint; return $this->conn->execute($query); } protected function rollbackSavePoint($savepoint) { $query = 'ROLLBACK TO SAVEPOINT ' . $savepoint; return $this->conn->execute($query); } public function setIsolation($isolation) { switch ($isolation) { case 'READ UNCOMMITTED': case 'READ COMMITTED': case 'REPEATABLE READ': case 'SERIALIZABLE': break; default: throw new Doctrine_Transaction_Exception('Isolation level ' . $isolation . ' is not supported.'); } $query = 'SET SESSION TRANSACTION ISOLATION LEVEL ' . $isolation; return $this->conn->execute($query); } public function getIsolation() { return $this->conn->fetchOne('SELECT @@tx_isolation'); } }class Doctrine_Transaction_Mssql extends Doctrine_Transaction { public function setIsolation($isolation, $options = array()) { switch ($isolation) { case 'READ UNCOMMITTED': case 'READ COMMITTED': case 'REPEATABLE READ': case 'SERIALIZABLE': case 'SNAPSHOT': break; default: throw new Doctrine_Transaction_Exception('isolation level is not supported: ' . $isolation); } $query = 'SET TRANSACTION ISOLATION LEVEL ' . $isolation; $this->conn->execute($query); } protected function _doRollback() { $this->conn->getDbh()->exec('ROLLBACK TRANSACTION'); } protected function _doCommit() { $this->conn->getDbh()->exec('COMMIT TRANSACTION'); } protected function _doBeginTransaction() { $this->conn->getDbh()->exec('BEGIN TRANSACTION'); } }class Doctrine_Transaction_Oracle extends Doctrine_Transaction { protected function createSavePoint($savepoint) { $query = 'SAVEPOINT ' . $savepoint; return $this->conn->execute($query); } protected function releaseSavePoint($savepoint) { return true; } protected function rollbackSavePoint($savepoint) { $query = 'ROLLBACK TO SAVEPOINT ' . $savepoint; return $this->conn->execute($query); } public function setIsolation($isolation) { switch ($isolation) { case 'READ UNCOMMITTED': $isolation = 'READ COMMITTED'; break; case 'READ COMMITTED': case 'REPEATABLE READ': case 'SERIALIZABLE': $isolation = 'SERIALIZABLE'; break; default: throw new Doctrine_Transaction_Exception('Isolation level ' . $isolation . ' is not supported.'); } $query = 'ALTER SESSION SET ISOLATION_LEVEL = ' . $isolation; return $this->conn->execute($query); } }class Doctrine_Transaction_Pgsql extends Doctrine_Transaction { protected function createSavePoint($savepoint) { $query = 'SAVEPOINT ' . $savepoint; return $this->conn->execute($query); } protected function releaseSavePoint($savepoint) { $query = 'RELEASE SAVEPOINT ' . $savepoint; return $this->conn->execute($query); } protected function rollbackSavePoint($savepoint) { $query = 'ROLLBACK TO SAVEPOINT ' . $savepoint; return $this->conn->execute($query); } public function setIsolation($isolation) { switch ($isolation) { case 'READ UNCOMMITTED': case 'READ COMMITTED': case 'REPEATABLE READ': case 'SERIALIZABLE': break; default: throw new Doctrine_Transaction_Exception('Isolation level '.$isolation.' is not supported.'); } $query = 'SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL ' . $isolation; return $this->conn->execute($query); } }class Doctrine_Transaction_Mock extends Doctrine_Transaction { }class Doctrine_Exception extends Exception { protected static $_errorMessages = array( Doctrine_Core::ERR => 'unknown error', Doctrine_Core::ERR_ALREADY_EXISTS => 'already exists', Doctrine_Core::ERR_CANNOT_CREATE => 'can not create', Doctrine_Core::ERR_CANNOT_ALTER => 'can not alter', Doctrine_Core::ERR_CANNOT_REPLACE => 'can not replace', Doctrine_Core::ERR_CANNOT_DELETE => 'can not delete', Doctrine_Core::ERR_CANNOT_DROP => 'can not drop', Doctrine_Core::ERR_CONSTRAINT => 'constraint violation', Doctrine_Core::ERR_CONSTRAINT_NOT_NULL=> 'null value violates not-null constraint', Doctrine_Core::ERR_DIVZERO => 'division by zero', Doctrine_Core::ERR_INVALID => 'invalid', Doctrine_Core::ERR_INVALID_DATE => 'invalid date or time', Doctrine_Core::ERR_INVALID_NUMBER => 'invalid number', Doctrine_Core::ERR_MISMATCH => 'mismatch', Doctrine_Core::ERR_NODBSELECTED => 'no database selected', Doctrine_Core::ERR_NOSUCHFIELD => 'no such field', Doctrine_Core::ERR_NOSUCHTABLE => 'no such table', Doctrine_Core::ERR_NOT_CAPABLE => 'Doctrine backend not capable', Doctrine_Core::ERR_NOT_FOUND => 'not found', Doctrine_Core::ERR_NOT_LOCKED => 'not locked', Doctrine_Core::ERR_SYNTAX => 'syntax error', Doctrine_Core::ERR_UNSUPPORTED => 'not supported', Doctrine_Core::ERR_VALUE_COUNT_ON_ROW => 'value count on row', Doctrine_Core::ERR_INVALID_DSN => 'invalid DSN', Doctrine_Core::ERR_CONNECT_FAILED => 'connect failed', Doctrine_Core::ERR_NEED_MORE_DATA => 'insufficient data supplied', Doctrine_Core::ERR_EXTENSION_NOT_FOUND=> 'extension not found', Doctrine_Core::ERR_NOSUCHDB => 'no such database', Doctrine_Core::ERR_ACCESS_VIOLATION => 'insufficient permissions', Doctrine_Core::ERR_LOADMODULE => 'error while including on demand module', Doctrine_Core::ERR_TRUNCATED => 'truncated', Doctrine_Core::ERR_DEADLOCK => 'deadlock detected', ); public function errorMessage($value = null) { if (is_null($value)) { return self::$_errorMessages; } return isset(self::$_errorMessages[$value]) ? self::$_errorMessages[$value] : self::$_errorMessages[Doctrine_Core::ERR]; } } class Doctrine_Transaction_Exception extends Doctrine_Exception { }class Doctrine_Import extends Doctrine_Connection_Module { protected $sql = array(); public function listDatabases() { if ( ! isset($this->sql['listDatabases'])) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } return $this->conn->fetchColumn($this->sql['listDatabases']); } public function listFunctions() { if ( ! isset($this->sql['listFunctions'])) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } return $this->conn->fetchColumn($this->sql['listFunctions']); } public function listTriggers($database = null) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } public function listSequences($database = null) { if ( ! isset($this->sql['listSequences'])) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } return $this->conn->fetchColumn($this->sql['listSequences']); } public function listTableConstraints($table) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } public function listTableRelations($table) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } public function listTableColumns($table) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } public function listTableIndexes($table) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } public function listTables($database = null) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } public function listTableTriggers($table) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } public function listTableViews($table) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } public function listUsers() { if ( ! isset($this->sql['listUsers'])) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } return $this->conn->fetchColumn($this->sql['listUsers']); } public function listViews($database = null) { if ( ! isset($this->sql['listViews'])) { throw new Doctrine_Import_Exception(__FUNCTION__ . ' not supported by this driver.'); } return $this->conn->fetchColumn($this->sql['listViews']); } public function databaseExists($database) { return in_array($database, $this->listDatabases()); } public function functionExists($function) { return in_array($function, $this->listFunctions()); } public function triggerExists($trigger, $database = null) { return in_array($trigger, $this->listTriggers($database)); } public function sequenceExists($sequence, $database = null) { return in_array($sequence, $this->listSequences($database)); } public function tableConstraintExists($constraint, $table) { return in_array($constraint, $this->listTableConstraints($table)); } public function tableColumnExists($column, $table) { return in_array($column, $this->listTableColumns($table)); } public function tableIndexExists($index, $table) { return in_array($index, $this->listTableIndexes($table)); } public function tableExists($table, $database = null) { return in_array($table, $this->listTables($database)); } public function tableTriggerExists($trigger, $table) { return in_array($trigger, $this->listTableTriggers($table)); } public function tableViewExists($view, $table) { return in_array($view, $this->listTableViews($table)); } public function userExists($user) { return in_array($user, $this->listUsers()); } public function viewExists($view, $database = null) { return in_array($view, $this->listViews($database)); } public function importSchema($directory, array $connections = array(), array $options = array()) { $classes = array(); $manager = Doctrine_Manager::getInstance(); foreach ($manager as $name => $connection) { if ( ! empty($connections) && ! in_array($name, $connections)) { continue; } $builder = new Doctrine_Import_Builder(); $builder->setTargetPath($directory); $builder->setOptions($options); $definitions = array(); foreach ($connection->import->listTables() as $table) { $definition = array(); $definition['tableName'] = $table; $definition['className'] = Doctrine_Inflector::classify(Doctrine_Inflector::tableize($table)); $definition['columns'] = $connection->import->listTableColumns($table); $definition['connection'] = $connection->getName(); $definition['connectionClassName'] = $definition['className']; try { $definition['relations'] = array(); $relations = $connection->import->listTableRelations($table); $relClasses = array(); foreach ($relations as $relation) { $table = $relation['table']; $class = Doctrine_Inflector::classify(Doctrine_Inflector::tableize($table)); if (in_array($class, $relClasses)) { $alias = $class . '_' . (count($relClasses) + 1); } else { $alias = $class; } $relClasses[] = $class; $definition['relations'][$alias] = array( 'alias' => $alias, 'class' => $class, 'local' => $relation['local'], 'foreign' => $relation['foreign'] ); } } catch (Exception $e) {} $definitions[strtolower($definition['className'])] = $definition; $classes[] = $definition['className']; } foreach ($definitions as $definition) { $className = $definition['className']; $relClasses = array(); foreach ($definition['relations'] as $alias => $relation) { if (in_array($relation['class'], $relClasses) || isset($definitions[$relation['class']]['relations'][$className])) { $alias = $className . '_' . (count($relClasses) + 1); } else { $alias = $className; } $relClasses[] = $relation['class']; $definitions[strtolower($relation['class'])]['relations'][$alias] = array( 'type' => Doctrine_Relation::MANY, 'alias' => $alias, 'class' => $className, 'local' => $relation['foreign'], 'foreign' => $relation['local'] ); } } foreach ($definitions as $definition) { $builder->buildRecord($definition); } } return $classes; } }class Doctrine_Sequence extends Doctrine_Connection_Module { public function nextId($seqName, $ondemand = true) { throw new Doctrine_Sequence_Exception('method not implemented'); } public function lastInsertId($table = null, $field = null) { throw new Doctrine_Sequence_Exception('method not implemented'); } public function currId($seqName) { $this->warnings[] = 'database does not support getting current
            sequence value, the sequence value was incremented'; return $this->nextId($seqName); } }class Doctrine_Sequence_Sqlite extends Doctrine_Sequence { public function nextId($seqName, $onDemand = true) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); $seqcolName = $this->conn->quoteIdentifier($this->conn->getAttribute(Doctrine_Core::ATTR_SEQCOL_NAME), true); $query = 'INSERT INTO ' . $sequenceName . ' (' . $seqcolName . ') VALUES (NULL)'; try { $this->conn->exec($query); } catch(Doctrine_Connection_Exception $e) { if ($onDemand && $e->getPortableCode() == Doctrine_Core::ERR_NOSUCHTABLE) { try { $result = $this->conn->export->createSequence($seqName, 2); } catch(Doctrine_Exception $e) { throw new Doctrine_Sequence_Exception('on demand sequence ' . $seqName . ' could not be created'); } return 1; } else { throw new Doctrine_Sequence_Exception('sequence ' .$seqName . ' does not exist'); } } $value = $this->conn->getDbh()->lastInsertId(); if (is_numeric($value)) { $query = 'DELETE FROM ' . $sequenceName . ' WHERE ' . $seqcolName . ' < ' . $value; $this->conn->exec($query); } return $value; } public function lastInsertId($table = null, $field = null) { return $this->conn->getDbh()->lastInsertId(); } public function currId($seqName) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); $seqcolName = $this->conn->quoteIdentifier($this->conn->getAttribute(Doctrine_Core::ATTR_SEQCOL_NAME), true); $query = 'SELECT MAX(' . $seqcolName . ') FROM ' . $sequenceName; return (int) $this->conn->fetchOne($query); } }class Doctrine_Sequence_Mysql extends Doctrine_Sequence { public function nextId($seqName, $onDemand = true) { $sequenceName = $this->conn->quoteIdentifier($seqName, true); $seqcolName = $this->conn->quoteIdentifier($this->conn->getAttribute(Doctrine_Core::ATTR_SEQCOL_NAME), true); $query = 'INSERT INTO ' . $sequenceName . ' (' . $seqcolName . ') VALUES (NULL)'; try { $this->conn->exec($query); } catch(Doctrine_Connection_Exception $e) { if ($onDemand && $e->getPortableCode() == Doctrine_Core::ERR_NOSUCHTABLE) { try { $result = $this->conn->export->createSequence($seqName, 2); } catch(Doctrine_Exception $e) { throw new Doctrine_Sequence_Exception('on demand sequence ' . $seqName . ' could not be created'); } return 1; } else { throw new Doctrine_Sequence_Exception('sequence ' .$seqName . ' does not exist'); } } $value = $this->lastInsertId(); if (is_numeric($value)) { $query = 'DELETE FROM ' . $sequenceName . ' WHERE ' . $seqcolName . ' < ' . $value; $this->conn->exec($query); } return $value; } public function lastInsertId($table = null, $field = null) { return $this->conn->getDbh()->lastInsertId(); } public function currId($seqName) { $sequenceName = $this->conn->quoteIdentifier($seqName, true); $seqcolName = $this->conn->quoteIdentifier($this->conn->getAttribute(Doctrine_Core::ATTR_SEQCOL_NAME), true); $query = 'SELECT MAX(' . $seqcolName . ') FROM ' . $sequenceName; return (int) $this->conn->fetchOne($query); } }class Doctrine_Sequence_Db2 extends Doctrine_Sequence { public function nextId($seqName, $ondemand = true) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); $query = 'SELECT NEXTVAL FOR ' . $sequenceName . ' AS VAL FROM SYSIBM.SYSDUMMY1'; try { $result = $this->conn->fetchOne($query); $result = ($result) ? $result['VAL'] : null; } catch(Doctrine_Connection_Exception $e) { if ($onDemand && $e->getPortableCode() == Doctrine_Core::ERR_NOSUCHTABLE) { try { $result = $this->conn->export->createSequence($seqName); } catch(Doctrine_Exception $e) { throw new Doctrine_Sequence_Exception('on demand sequence ' . $seqName . ' could not be created'); } return $this->nextId($seqName, false); } else { throw new Doctrine_Sequence_Exception('sequence ' .$seqName . ' does not exist'); } } return $result; } public function currId($sequenceName) { $sql = 'SELECT PREVVAL FOR ' . $this->quoteIdentifier($this->conn->formatter->getSequenceName($sequenceName)) . ' AS VAL FROM SYSIBM.SYSDUMMY1'; $stmt = $this->query($sql); $result = $stmt->fetchAll(Doctrine_Core::FETCH_ASSOC); if ($result) { return $result[0]['VAL']; } else { return null; } } public function lastInsertId($tableName = null, $primaryKey = null) { $this->_connect(); if ($tableName !== null) { $sequenceName = $tableName; if ($primaryKey) { $sequenceName .= "_$primaryKey"; } $sequenceName .= '_seq'; return $this->lastSequenceId($sequenceName); } $sql = 'SELECT IDENTITY_VAL_LOCAL() AS VAL FROM SYSIBM.SYSDUMMY1'; $stmt = $this->query($sql); $result = $stmt->fetchAll(Doctrine_Core::FETCH_ASSOC); if ($result) { return $result[0]['VAL']; } else { return null; } } }class Doctrine_Sequence_Mssql extends Doctrine_Sequence { public function nextId($seqName, $onDemand = true) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); $seqcolName = $this->conn->quoteIdentifier($this->conn->getAttribute(Doctrine_Core::ATTR_SEQCOL_NAME), true); if ($this->checkSequence($sequenceName)) { $query = 'SET IDENTITY_INSERT ' . $sequenceName . ' OFF ' . 'INSERT INTO ' . $sequenceName . ' DEFAULT VALUES'; } else { $query = 'INSERT INTO ' . $sequenceName . ' (' . $seqcolName . ') VALUES (0)'; } try { $this->conn->exec($query); } catch(Doctrine_Connection_Exception $e) { if ($onDemand && $e->getPortableCode() == Doctrine_Core::ERR_NOSUCHTABLE) { try { $result = $this->conn->export->createSequence($seqName, 2); } catch(Doctrine_Exception $e) { throw new Doctrine_Sequence_Exception('on demand sequence ' . $seqName . ' could not be created'); } if ($this->checkSequence($seqName)) { return $this->lastInsertId($seqName); } return 1; } throw $e; } $value = $this->lastInsertId($sequenceName); if (is_numeric($value)) { $query = 'DELETE FROM ' . $sequenceName . ' WHERE ' . $seqcolName . ' < ' . $value; try { $this->conn->exec($query); } catch (Doctrine_Connection_Exception $e) { throw new Doctrine_Sequence_Exception( 'Could not delete previous sequence from ' . $sequenceName . ' at ' . __FILE__ . ' in ' . __FUNCTION__ . ' with the message: ' . $e->getMessage() ); } } return $value; } public function checkSequence($seqName) { $query = 'SELECT COUNT(1) FROM ' . $seqName; try { $this->conn->execute($query); } catch (Doctrine_Connection_Exception $e) { if ($e->getPortableCode() == Doctrine_Core::ERR_NOSUCHTABLE) { return false; } } return true; } public function lastInsertId($table = null, $field = null) { $serverInfo = $this->conn->getServerVersion(); if (is_array($serverInfo) && ! is_null($serverInfo['major']) && $serverInfo['major'] >= 8) { if (isset($table)) { $query = 'SELECT IDENT_CURRENT(\'' . $this->conn->quoteIdentifier($table) . '\')'; } else { $query = 'SELECT SCOPE_IDENTITY()'; } } else { $query = 'SELECT @@IDENTITY'; } return (string) floor((float) $this->conn->fetchOne($query)); } public function currId($seqName) { $this->warnings[] = 'database does not support getting current
            sequence value, the sequence value was incremented'; return $this->nextId($seqName); } }class Doctrine_Sequence_Oracle extends Doctrine_Sequence { public function nextID($seqName, $onDemand = true) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); $query = 'SELECT ' . $sequenceName . '.nextval FROM DUAL'; try { $result = $this->conn->fetchOne($query); } catch(Doctrine_Connection_Exception $e) { if ($onDemand && $e->getPortableCode() == Doctrine_Core::ERR_NOSUCHTABLE) { try { $result = $this->conn->export->createSequence($seqName); } catch(Doctrine_Exception $e) { throw new Doctrine_Sequence_Exception('on demand sequence ' . $seqName . ' could not be created'); } return $this->nextId($seqName, false); } else { throw new Doctrine_Sequence_Exception('sequence ' .$seqName . ' does not exist'); } } return $result; } public function lastInsertID($table = null, $field = null) { $seqName = $table . (empty($field) ? '' : '_'.$field); $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); return $this->conn->fetchOne('SELECT ' . $sequenceName . '.currval FROM DUAL'); } public function currId($seqName) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); $query = 'SELECT (last_number-1) FROM user_sequences'; $query .= ' WHERE sequence_name=' . $this->conn->quote($sequenceName, 'text'); $query .= ' OR sequence_name=' . $this->conn->quote(strtoupper($sequenceName), 'text'); return $this->conn->fetchOne($query); } } class Doctrine_Sequence_Pgsql extends Doctrine_Sequence { public function nextId($seqName, $onDemand = true) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); $query = "SELECT NEXTVAL('" . $sequenceName . "')"; try { $result = (int) $this->conn->fetchOne($query); } catch(Doctrine_Connection_Exception $e) { if ($onDemand && $e->getPortableCode() == Doctrine_Core::ERR_NOSUCHTABLE) { try { $result = $this->conn->export->createSequence($seqName); } catch(Doctrine_Exception $e) { throw new Doctrine_Sequence_Exception('on demand sequence ' . $seqName . ' could not be created'); } return $this->nextId($seqName, false); } else { throw new Doctrine_Sequence_Exception('sequence ' .$seqName . ' does not exist'); } } return $result; } public function lastInsertId($table = null, $field = null) { $seqName = $table . (empty($field) ? '' : '_' . $field); $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); return (int) $this->conn->fetchOne("SELECT CURRVAL('" . $sequenceName . "')"); } public function currId($seqName) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); return (int) $this->conn->fetchOne('SELECT last_value FROM ' . $sequenceName); } }class Doctrine_Sequence_Exception extends Doctrine_Exception { }class Doctrine_Node implements IteratorAggregate { protected $record; protected $options; protected $iteratorType; protected $iteratorOptions; protected $_tree; public function __construct(Doctrine_Record $record, $options) { $this->record = $record; $this->options = $options; $class = $record->getTable()->getComponentName(); $thisTable = $record->getTable(); $table = $thisTable; if ($thisTable->getOption('inheritanceMap')) { while ( ! $subclasses = $table->getOption('subclasses')) { $class = get_parent_class($class); $reflectionClass = new ReflectionClass($class); if ($reflectionClass->isAbstract()) { continue; } if ($class == 'Doctrine_Record') { throw new Doctrine_Node_Exception("No subclasses specified. You are " . "using Single Table Inheritance with NestedSet but you have " . "not specified the subclasses correctly. Make sure you use " . "setSubclasses() in the root class of your hierarchy."); } $table = $table->getConnection()->getTable($class); } } if ($thisTable !== $table) { $this->_tree = $table->getTree(); } else { $this->_tree = $thisTable->getTree(); } } public static function factory(Doctrine_Record $record, $implName, $options = array()) { $class = 'Doctrine_Node_' . $implName; if ( ! class_exists($class)) { throw new Doctrine_Node_Exception("The class $class must exist and extend Doctrine_Node"); } return new $class($record, $options); } public function setRecord(Doctrine_Record $record) { $this->record = $record; } public function getRecord() { return $this->record; } public function traverse($type = 'Pre', $options = array()) { return $this->getIterator($type, $options); } public function getIterator($type = null, $options = null) { if ($type === null) { $type = (isset($this->iteratorType) ? $this->iteratorType : 'Pre'); } if ($options === null) { $options = (isset($this->iteratorOptions) ? $this->iteratorOptions : array()); } $implName = $this->record->getTable()->getOption('treeImpl'); $iteratorClass = 'Doctrine_Node_' . $implName . '_' . ucfirst(strtolower($type)) . 'OrderIterator'; return new $iteratorClass($this->record, $options); } public function setIteratorType($type) { $this->iteratorType = $type; } public function setIteratorOptions($options) { $this->iteratorOptions = $options; } } abstract class Doctrine_Node_AdjacencyList extends Doctrine_Node implements Doctrine_Node_Interface { }class Doctrine_Node_NestedSet_PostOrderIterator { }class Doctrine_Node_NestedSet_LevelOrderIterator { }class Doctrine_Node_NestedSet_PreOrderIterator implements Iterator { protected $collection; protected $keys; protected $key; protected $index; protected $prevIndex; protected $traverseLevel; protected $count; public function __construct($record, $opts) { $componentName = $record->getTable()->getComponentName(); $q = $record->getTable()->createQuery(); $params = array($record->get('lft'), $record->get('rgt')); if (isset($opts['include_record']) && $opts['include_record']) { $query = $q->where("$componentName.lft >= ? AND $componentName.rgt <= ?", $params)->orderBy("$componentName.lft asc"); } else { $query = $q->where("$componentName.lft > ? AND $componentName.rgt < ?", $params)->orderBy("$componentName.lft asc"); } $query = $record->getTable()->getTree()->returnQueryWithRootId($query, $record->getNode()->getRootValue()); $this->maxLevel = isset($opts['depth']) ? ($opts['depth'] + $record->getNode()->getLevel()) : 0; $this->options = $opts; $this->collection = isset($opts['collection']) ? $opts['collection'] : $query->execute(); $this->keys = $this->collection->getKeys(); $this->count = $this->collection->count(); $this->index = -1; $this->level = $record->getNode()->getLevel(); $this->prevLeft = $record->getNode()->getLeftValue(); $record->getTable()->clear(); } public function rewind() { $this->index = -1; $this->key = null; } public function key() { return $this->key; } public function current() { $record = $this->collection->get($this->key); $record->getNode()->setLevel($this->level); return $record; } public function next() { while ($current = $this->advanceIndex()) { if ($this->maxLevel && ($this->level > $this->maxLevel)) { continue; } return $current; } return false; } public function valid() { return ($this->index < $this->count); } public function count() { return $this->count; } private function updateLevel() { if ( ! (isset($this->options['include_record']) && $this->options['include_record'] && $this->index == 0)) { $left = $this->collection->get($this->key)->getNode()->getLeftValue(); $this->level += $this->prevLeft - $left + 2; $this->prevLeft = $left; } } private function advanceIndex() { $this->index++; $i = $this->index; if (isset($this->keys[$i])) { $this->key = $this->keys[$i]; $this->updateLevel(); return $this->current(); } return false; } }abstract class Doctrine_Node_MaterializedPath extends Doctrine_Node implements Doctrine_Node_Interface { }abstract class Doctrine_Node_AdjacencyList_PostOrderIterator implements Iterator { }abstract class Doctrine_Node_AdjacencyList_LevelOrderIterator implements Iterator { }abstract class Doctrine_Node_AdjacencyList_PreOrderIterator implements Iterator { }class Doctrine_Node_NestedSet extends Doctrine_Node implements Doctrine_Node_Interface { public function hasPrevSibling() { return $this->isValidNode($this->getPrevSibling()); } public function hasNextSibling() { return $this->isValidNode($this->getNextSibling()); } public function hasChildren() { return (($this->getRightValue() - $this->getLeftValue()) > 1); } public function hasParent() { return $this->isValidNode($this->getRecord()) && ! $this->isRoot(); } public function getPrevSibling() { $baseAlias = $this->_tree->getBaseAlias(); $q = $this->_tree->getBaseQuery(); $q = $q->addWhere("$baseAlias.rgt = ?", $this->getLeftValue() - 1); $q = $this->_tree->returnQueryWithRootId($q, $this->getRootValue()); $result = $q->execute(); if (count($result) <= 0) { return false; } if ($result instanceof Doctrine_Collection) { $sibling = $result->getFirst(); } else if (is_array($result)) { $sibling = array_shift($result); } return $sibling; } public function getNextSibling() { $baseAlias = $this->_tree->getBaseAlias(); $q = $this->_tree->getBaseQuery(); $q = $q->addWhere("$baseAlias.lft = ?", $this->getRightValue() + 1); $q = $this->_tree->returnQueryWithRootId($q, $this->getRootValue()); $result = $q->execute(); if (count($result) <= 0) { return false; } if ($result instanceof Doctrine_Collection) { $sibling = $result->getFirst(); } else if (is_array($result)) { $sibling = array_shift($result); } return $sibling; } public function getSiblings($includeNode = false) { $parent = $this->getParent(); $siblings = array(); if ($parent && $parent->exists()) { foreach ($parent->getNode()->getChildren() as $child) { if ($this->isEqualTo($child) && !$includeNode) { continue; } $siblings[] = $child; } } return $siblings; } public function getFirstChild() { $baseAlias = $this->_tree->getBaseAlias(); $q = $this->_tree->getBaseQuery(); $q->addWhere("$baseAlias.lft = ?", $this->getLeftValue() + 1); $this->_tree->returnQueryWithRootId($q, $this->getRootValue()); $result = $q->execute(); if (count($result) <= 0) { return false; } if ($result instanceof Doctrine_Collection) { $child = $result->getFirst(); } else if (is_array($result)) { $child = array_shift($result); } return $child; } public function getLastChild() { $baseAlias = $this->_tree->getBaseAlias(); $q = $this->_tree->getBaseQuery(); $q->addWhere("$baseAlias.rgt = ?", $this->getRightValue() - 1); $this->_tree->returnQueryWithRootId($q, $this->getRootValue()); $result = $q->execute(); if (count($result) <= 0) { return false; } if ($result instanceof Doctrine_Collection) { $child = $result->getFirst(); } else if (is_array($result)) { $child = array_shift($result); } return $child; } public function getChildren() { return $this->getDescendants(1); } public function getDescendants($depth = null, $includeNode = false) { $baseAlias = $this->_tree->getBaseAlias(); $q = $this->_tree->getBaseQuery(); $params = array($this->record->get('lft'), $this->record->get('rgt')); if ($includeNode) { $q->addWhere("$baseAlias.lft >= ? AND $baseAlias.rgt <= ?", $params)->addOrderBy("$baseAlias.lft asc"); } else { $q->addWhere("$baseAlias.lft > ? AND $baseAlias.rgt < ?", $params)->addOrderBy("$baseAlias.lft asc"); } if ($depth !== null) { $q->addWhere("$baseAlias.level <= ?", $this->record['level'] + $depth); } $q = $this->_tree->returnQueryWithRootId($q, $this->getRootValue()); $result = $q->execute(); if (count($result) <= 0) { return false; } return $result; } public function getParent() { $baseAlias = $this->_tree->getBaseAlias(); $q = $this->_tree->getBaseQuery(); $q->addWhere("$baseAlias.lft < ? AND $baseAlias.rgt > ?", array($this->getLeftValue(), $this->getRightValue())) ->addWhere("$baseAlias.level >= ?", $this->record['level'] - 1) ->addOrderBy("$baseAlias.rgt asc"); $q = $this->_tree->returnQueryWithRootId($q, $this->getRootValue()); $result = $q->execute(); if (count($result) <= 0) { return false; } if ($result instanceof Doctrine_Collection) { $parent = $result->getFirst(); } else if (is_array($result)) { $parent = array_shift($result); } return $parent; } public function getAncestors($depth = null) { $baseAlias = $this->_tree->getBaseAlias(); $q = $this->_tree->getBaseQuery(); $q->addWhere("$baseAlias.lft < ? AND $baseAlias.rgt > ?", array($this->getLeftValue(), $this->getRightValue())) ->addOrderBy("$baseAlias.lft asc"); if ($depth !== null) { $q->addWhere("$baseAlias.level >= ?", $this->record['level'] - $depth); } $q = $this->_tree->returnQueryWithRootId($q, $this->getRootValue()); $ancestors = $q->execute(); if (count($ancestors) <= 0) { return false; } return $ancestors; } public function getPath($seperator = ' > ', $includeRecord = false) { $path = array(); $ancestors = $this->getAncestors(); if ($ancestors) { foreach ($ancestors as $ancestor) { $path[] = $ancestor->__toString(); } } if ($includeRecord) { $path[] = $this->getRecord()->__toString(); } return implode($seperator, $path); } public function getNumberChildren() { $children = $this->getChildren(); return $children === false ? 0 : count($children); } public function getNumberDescendants() { return ($this->getRightValue() - $this->getLeftValue() - 1) / 2; } public function insertAsParentOf(Doctrine_Record $dest) { if ($this->isValidNode()) { return false; } if ($dest->getNode()->isRoot()) { return false; } if ( $dest === $this->record || ($dest->exists() && $this->record->exists() && $dest->identifier() === $this->record->identifier()) ) { throw new Doctrine_Tree_Exception("Cannot insert node as parent of itself"); return false; } $newLeft = $dest->getNode()->getLeftValue(); $newRight = $dest->getNode()->getRightValue() + 2; $newRoot = $dest->getNode()->getRootValue(); $newLevel = $dest->getNode()->getLevel(); $conn = $this->record->getTable()->getConnection(); try { $conn->beginInternalTransaction(); $this->shiftRLValues($dest->getNode()->getRightValue() + 1, 2, $newRoot); $componentName = $this->_tree->getBaseComponent(); $q = Doctrine_Core::getTable($componentName) ->createQuery() ->update(); $q->set("$componentName.lft", "$componentName.lft + 1"); $q->set("$componentName.rgt", "$componentName.rgt + 1"); $q->set("$componentName.level", "$componentName.level + 1"); $q->where("$componentName.lft >= ? AND $componentName.rgt <= ?", array($newLeft, $newRight)); $q = $this->_tree->returnQueryWithRootId($q, $newRoot); $q->execute(); $this->record['level'] = $newLevel; $this->insertNode($newLeft, $newRight, $newRoot); $conn->commit(); } catch (Exception $e) { $conn->rollback(); throw $e; } return true; } public function insertAsPrevSiblingOf(Doctrine_Record $dest) { if ($this->isValidNode()) { return false; } if ( $dest === $this->record || ($dest->exists() && $this->record->exists() && $dest->identifier() === $this->record->identifier()) ) { throw new Doctrine_Tree_Exception("Cannot insert node as previous sibling of itself"); return false; } $newLeft = $dest->getNode()->getLeftValue(); $newRight = $dest->getNode()->getLeftValue() + 1; $newRoot = $dest->getNode()->getRootValue(); $conn = $this->record->getTable()->getConnection(); try { $conn->beginInternalTransaction(); $this->shiftRLValues($newLeft, 2, $newRoot); $this->record['level'] = $dest['level']; $this->insertNode($newLeft, $newRight, $newRoot); $conn->commit(); } catch (Exception $e) { $conn->rollback(); throw $e; } return true; } public function insertAsNextSiblingOf(Doctrine_Record $dest) { if ($this->isValidNode()) { return false; } if ( $dest === $this->record || ($dest->exists() && $this->record->exists() && $dest->identifier() === $this->record->identifier()) ) { throw new Doctrine_Tree_Exception("Cannot insert node as next sibling of itself"); return false; } $newLeft = $dest->getNode()->getRightValue() + 1; $newRight = $dest->getNode()->getRightValue() + 2; $newRoot = $dest->getNode()->getRootValue(); $conn = $this->record->getTable()->getConnection(); try { $conn->beginInternalTransaction(); $this->shiftRLValues($newLeft, 2, $newRoot); $this->record['level'] = $dest['level']; $this->insertNode($newLeft, $newRight, $newRoot); $conn->commit(); } catch (Exception $e) { $conn->rollback(); throw $e; } return true; } public function insertAsFirstChildOf(Doctrine_Record $dest) { if ($this->isValidNode()) { return false; } if ( $dest === $this->record || ($dest->exists() && $this->record->exists() && $dest->identifier() === $this->record->identifier()) ) { throw new Doctrine_Tree_Exception("Cannot insert node as first child of itself"); return false; } $newLeft = $dest->getNode()->getLeftValue() + 1; $newRight = $dest->getNode()->getLeftValue() + 2; $newRoot = $dest->getNode()->getRootValue(); $conn = $this->record->getTable()->getConnection(); try { $conn->beginInternalTransaction(); $this->shiftRLValues($newLeft, 2, $newRoot); $this->record['level'] = $dest['level'] + 1; $this->insertNode($newLeft, $newRight, $newRoot); $conn->commit(); } catch (Exception $e) { $conn->rollback(); throw $e; } return true; } public function insertAsLastChildOf(Doctrine_Record $dest) { if ($this->isValidNode()) { return false; } if ( $dest === $this->record || ($dest->exists() && $this->record->exists() && $dest->identifier() === $this->record->identifier()) ) { throw new Doctrine_Tree_Exception("Cannot insert node as last child of itself"); return false; } $newLeft = $dest->getNode()->getRightValue(); $newRight = $dest->getNode()->getRightValue() + 1; $newRoot = $dest->getNode()->getRootValue(); $conn = $this->record->getTable()->getConnection(); try { $conn->beginInternalTransaction(); $this->shiftRLValues($newLeft, 2, $newRoot); $this->record['level'] = $dest['level'] + 1; $this->insertNode($newLeft, $newRight, $newRoot); $conn->commit(); } catch (Exception $e) { $conn->rollback(); throw $e; } return true; } private function _moveBetweenTrees(Doctrine_Record $dest, $newLeftValue, $moveType) { $conn = $this->record->getTable()->getConnection(); try { $conn->beginInternalTransaction(); $newRoot = $dest->getNode()->getRootValue(); $oldRoot = $this->getRootValue(); $oldLft = $this->getLeftValue(); $oldRgt = $this->getRightValue(); $oldLevel = $this->record['level']; $this->shiftRlValues($newLeftValue, $oldRgt - $oldLft - 1, $newRoot); $this->setRootValue($newRoot); $this->record->save(); $this->setRightValue(0); $this->setLeftValue(0); switch ($moveType) { case 'moveAsPrevSiblingOf': $this->insertAsPrevSiblingOf($dest); break; case 'moveAsFirstChildOf': $this->insertAsFirstChildOf($dest); break; case 'moveAsNextSiblingOf': $this->insertAsNextSiblingOf($dest); break; case 'moveAsLastChildOf': $this->insertAsLastChildOf($dest); break; default: throw new Doctrine_Node_Exception("Unknown move operation: $moveType."); } $diff = $oldRgt - $oldLft; $this->setRightValue($this->getLeftValue() + ($oldRgt - $oldLft)); $this->record->save(); $newLevel = $this->record['level']; $levelDiff = $newLevel - $oldLevel; $diff = $this->getLeftValue() - $oldLft; $componentName = $this->_tree->getBaseComponent(); $rootColName = $this->_tree->getAttribute('rootColumnName'); $q = Doctrine_Core::getTable($componentName) ->createQuery() ->update() ->set($componentName . '.lft', $componentName.'.lft + ?', $diff) ->set($componentName . '.rgt', $componentName.'.rgt + ?', $diff) ->set($componentName . '.level', $componentName.'.level + ?', $levelDiff) ->set($componentName . '.' . $rootColName, '?', $newRoot) ->where($componentName . '.lft > ? AND ' . $componentName . '.rgt < ?', array($oldLft, $oldRgt)); $q = $this->_tree->returnQueryWithRootId($q, $oldRoot); $q->execute(); $first = $oldRgt + 1; $delta = $oldLft - $oldRgt - 1; $this->shiftRLValues($first, $delta, $oldRoot); $conn->commit(); return true; } catch (Exception $e) { $conn->rollback(); throw $e; } return false; } public function moveAsPrevSiblingOf(Doctrine_Record $dest) { if ( $dest === $this->record || ($dest->exists() && $this->record->exists() && $dest->identifier() === $this->record->identifier()) ) { throw new Doctrine_Tree_Exception("Cannot move node as previous sibling of itself"); return false; } if ($dest->getNode()->getRootValue() != $this->getRootValue()) { return $this->_moveBetweenTrees($dest, $dest->getNode()->getLeftValue(), __FUNCTION__); } else { $oldLevel = $this->record['level']; $this->record['level'] = $dest['level']; $this->updateNode($dest->getNode()->getLeftValue(), $this->record['level'] - $oldLevel); } return true; } public function moveAsNextSiblingOf(Doctrine_Record $dest) { if ( $dest === $this->record || ($dest->exists() && $this->record->exists() && $dest->identifier() === $this->record->identifier()) ) { throw new Doctrine_Tree_Exception("Cannot move node as next sibling of itself"); return false; } if ($dest->getNode()->getRootValue() != $this->getRootValue()) { return $this->_moveBetweenTrees($dest, $dest->getNode()->getRightValue() + 1, __FUNCTION__); } else { $oldLevel = $this->record['level']; $this->record['level'] = $dest['level']; $this->updateNode($dest->getNode()->getRightValue() + 1, $this->record['level'] - $oldLevel); } return true; } public function moveAsFirstChildOf(Doctrine_Record $dest) { if ( $dest === $this->record || $this->isAncestorOf($dest) || ($dest->exists() && $this->record->exists() && $dest->identifier() === $this->record->identifier()) ) { throw new Doctrine_Tree_Exception("Cannot move node as first child of itself or into a descendant"); return false; } if ($dest->getNode()->getRootValue() != $this->getRootValue()) { return $this->_moveBetweenTrees($dest, $dest->getNode()->getLeftValue() + 1, __FUNCTION__); } else { $oldLevel = $this->record['level']; $this->record['level'] = $dest['level'] + 1; $this->updateNode($dest->getNode()->getLeftValue() + 1, $this->record['level'] - $oldLevel); } return true; } public function moveAsLastChildOf(Doctrine_Record $dest) { if ( $dest === $this->record || $this->isAncestorOf($dest) || ($dest->exists() && $this->record->exists() && $dest->identifier() === $this->record->identifier()) ) { throw new Doctrine_Tree_Exception("Cannot move node as last child of itself or into a descendant"); return false; } if ($dest->getNode()->getRootValue() != $this->getRootValue()) { return $this->_moveBetweenTrees($dest, $dest->getNode()->getRightValue(), __FUNCTION__); } else { $oldLevel = $this->record['level']; $this->record['level'] = $dest['level'] + 1; $this->updateNode($dest->getNode()->getRightValue(), $this->record['level'] - $oldLevel); } return true; } public function makeRoot($newRootId) { if ($this->getLeftValue() == 1 || ! $this->_tree->getAttribute('hasManyRoots')) { return false; } $oldRgt = $this->getRightValue(); $oldLft = $this->getLeftValue(); $oldRoot = $this->getRootValue(); $oldLevel = $this->record['level']; $conn = $this->record->getTable()->getConnection(); try { $conn->beginInternalTransaction(); $diff = 1 - $oldLft; $newRoot = $newRootId; $componentName = $this->_tree->getBaseComponent(); $rootColName = $this->_tree->getAttribute('rootColumnName'); $q = Doctrine_Core::getTable($componentName) ->createQuery() ->update() ->set($componentName . '.lft', $componentName.'.lft + ?', array($diff)) ->set($componentName . '.rgt', $componentName.'.rgt + ?', array($diff)) ->set($componentName . '.level', $componentName.'.level - ?', array($oldLevel)) ->set($componentName . '.' . $rootColName, '?', array($newRoot)) ->where($componentName . '.lft > ? AND ' . $componentName . '.rgt < ?', array($oldLft, $oldRgt)); $q = $this->_tree->returnQueryWithRootId($q, $oldRoot); $q->execute(); $first = $oldRgt + 1; $delta = $oldLft - $oldRgt - 1; $this->shiftRLValues($first, $delta, $this->getRootValue()); $this->setLeftValue(1); $this->setRightValue($oldRgt - $oldLft + 1); $this->setRootValue($newRootId); $this->record['level'] = 0; $this->record->save(); $conn->commit(); return true; } catch (Exception $e) { $conn->rollback(); throw $e; } return false; } public function addChild(Doctrine_Record $record) { $record->getNode()->insertAsLastChildOf($this->getRecord()); } public function isLeaf() { return (($this->getRightValue() - $this->getLeftValue()) == 1); } public function isRoot() { return ($this->getLeftValue() == 1); } public function isEqualTo(Doctrine_Record $subj) { return (($this->getLeftValue() == $subj->getNode()->getLeftValue()) && ($this->getRightValue() == $subj->getNode()->getRightValue()) && ($this->getRootValue() == $subj->getNode()->getRootValue()) ); } public function isDescendantOf(Doctrine_Record $subj) { return (($this->getLeftValue() > $subj->getNode()->getLeftValue()) && ($this->getRightValue() < $subj->getNode()->getRightValue()) && ($this->getRootValue() == $subj->getNode()->getRootValue())); } public function isDescendantOfOrEqualTo(Doctrine_Record $subj) { return (($this->getLeftValue() >= $subj->getNode()->getLeftValue()) && ($this->getRightValue() <= $subj->getNode()->getRightValue()) && ($this->getRootValue() == $subj->getNode()->getRootValue())); } public function isAncestorOf(Doctrine_Record $subj) { return (($subj->getNode()->getLeftValue() > $this->getLeftValue()) && ($subj->getNode()->getRightValue() < $this->getRightValue()) && ($subj->getNode()->getRootValue() == $this->getRootValue())); } public function isValidNode($record = null) { if ($record === null) { return ($this->getRightValue() > $this->getLeftValue()); } else if ( $record instanceof Doctrine_Record ) { return ($record->getNode()->getRightValue() > $record->getNode()->getLeftValue()); } else { return false; } } public function detach() { $this->setLeftValue(0); $this->setRightValue(0); } public function delete() { $conn = $this->record->getTable()->getConnection(); try { $conn->beginInternalTransaction(); $oldRoot = $this->getRootValue(); $q = $this->_tree->getBaseQuery(); $baseAlias = $this->_tree->getBaseAlias(); $componentName = $this->_tree->getBaseComponent(); $q = $q->addWhere("$baseAlias.lft >= ? AND $baseAlias.rgt <= ?", array($this->getLeftValue(), $this->getRightValue())); $q = $this->_tree->returnQueryWithRootId($q, $oldRoot); $coll = $q->execute(); $coll->delete(); $first = $this->getRightValue() + 1; $delta = $this->getLeftValue() - $this->getRightValue() - 1; $this->shiftRLValues($first, $delta, $oldRoot); $conn->commit(); } catch (Exception $e) { $conn->rollback(); throw $e; } return true; } private function insertNode($destLeft = 0, $destRight = 0, $destRoot = 1) { $this->setLeftValue($destLeft); $this->setRightValue($destRight); $this->setRootValue($destRoot); $this->record->save(); } private function updateNode($destLeft, $levelDiff) { $componentName = $this->_tree->getBaseComponent(); $left = $this->getLeftValue(); $right = $this->getRightValue(); $rootId = $this->getRootValue(); $treeSize = $right - $left + 1; $conn = $this->record->getTable()->getConnection(); try { $conn->beginInternalTransaction(); $this->shiftRLValues($destLeft, $treeSize, $rootId); if ($left >= $destLeft) { $left += $treeSize; $right += $treeSize; } $q = Doctrine_Core::getTable($componentName) ->createQuery() ->update() ->set($componentName . '.level', $componentName.'.level + ?', array($levelDiff)) ->where($componentName . '.lft > ? AND ' . $componentName . '.rgt < ?', array($left, $right)); $q = $this->_tree->returnQueryWithRootId($q, $rootId); $q->execute(); $this->shiftRLRange($left, $right, $destLeft - $left, $rootId); $this->shiftRLValues($right + 1, -$treeSize, $rootId); $this->record->save(); $this->record->refresh(); $conn->commit(); } catch (Exception $e) { $conn->rollback(); throw $e; } return true; } private function shiftRlValues($first, $delta, $rootId = 1) { $componentName = $this->_tree->getBaseComponent(); $qLeft = Doctrine_Core::getTable($componentName) ->createQuery() ->update($componentName); $qRight = Doctrine_Core::getTable($componentName) ->createQuery() ->update($componentName); $qLeft = $qLeft->set($componentName . '.lft', $componentName.'.lft + ?', $delta) ->where($componentName . '.lft >= ?', $first); $qLeft = $this->_tree->returnQueryWithRootId($qLeft, $rootId); $resultLeft = $qLeft->execute(); $qRight = $qRight->set($componentName . '.rgt', $componentName.'.rgt + ?', $delta) ->where($componentName . '.rgt >= ?', $first); $qRight = $this->_tree->returnQueryWithRootId($qRight, $rootId); $resultRight = $qRight->execute(); } private function shiftRlRange($first, $last, $delta, $rootId = 1) { $componentName = $this->_tree->getBaseComponent(); $qLeft = Doctrine_Core::getTable($componentName) ->createQuery() ->update(); $qRight = Doctrine_Core::getTable($componentName) ->createQuery() ->update(); $qLeft = $qLeft->set($componentName . '.lft', $componentName.'.lft + ?', $delta) ->where($componentName . '.lft >= ? AND ' . $componentName . '.lft <= ?', array($first, $last)); $qLeft = $this->_tree->returnQueryWithRootId($qLeft, $rootId); $resultLeft = $qLeft->execute(); $qRight = $qRight->set($componentName . '.rgt', $componentName.'.rgt + ?', $delta) ->where($componentName . '.rgt >= ? AND ' . $componentName . '.rgt <= ?', array($first, $last)); $qRight = $this->_tree->returnQueryWithRootId($qRight, $rootId); $resultRight = $qRight->execute(); } public function getLeftValue() { return $this->record->get('lft'); } public function setLeftValue($lft) { $this->record->set('lft', $lft); } public function getRightValue() { return $this->record->get('rgt'); } public function setRightValue($rgt) { $this->record->set('rgt', $rgt); } public function getLevel() { if ( ! isset($this->record['level'])) { $baseAlias = $this->_tree->getBaseAlias(); $componentName = $this->_tree->getBaseComponent(); $q = $this->_tree->getBaseQuery(); $q = $q->addWhere("$baseAlias.lft < ? AND $baseAlias.rgt > ?", array($this->getLeftValue(), $this->getRightValue())); $q = $this->_tree->returnQueryWithRootId($q, $this->getRootValue()); $coll = $q->execute(); $this->record['level'] = count($coll) ? count($coll) : 0; } return $this->record['level']; } public function getRootValue() { if ($this->_tree->getAttribute('hasManyRoots')) { return $this->record->get($this->_tree->getAttribute('rootColumnName')); } return 1; } public function setRootValue($value) { if ($this->_tree->getAttribute('hasManyRoots')) { $this->record->set($this->_tree->getAttribute('rootColumnName'), $value); } } } class Doctrine_Node_Exception extends Doctrine_Exception { }class Doctrine_Node_MaterializedPath_PostOrderIterator implements Iterator { private $topNode = null; private $curNode = null; public function __construct($node, $opts) { throw new Doctrine_Exception('Not yet implemented'); } public function rewind() { throw new Doctrine_Exception('Not yet implemented'); } public function valid() { throw new Doctrine_Exception('Not yet implemented'); } public function current() { throw new Doctrine_Exception('Not yet implemented'); } public function key() { throw new Doctrine_Exception('Not yet implemented'); } public function next() { throw new Doctrine_Exception('Not yet implemented'); } }class Doctrine_Node_MaterializedPath_LevelOrderIterator implements Iterator { private $topNode = null; private $curNode = null; public function __construct($node, $opts) { throw new Doctrine_Exception('Not yet implemented'); } public function rewind() { throw new Doctrine_Exception('Not yet implemented'); } public function valid() { throw new Doctrine_Exception('Not yet implemented'); } public function current() { throw new Doctrine_Exception('Not yet implemented'); } public function key() { throw new Doctrine_Exception('Not yet implemented'); } public function next() { throw new Doctrine_Exception('Not yet implemented'); } }class Doctrine_Node_MaterializedPath_PreOrderIterator implements Iterator { private $topNode = null; private $curNode = null; public function __construct($node, $opts) { throw new Doctrine_Exception('Not yet implemented'); } public function rewind() { throw new Doctrine_Exception('Not yet implemented'); } public function valid() { throw new Doctrine_Exception('Not yet implemented'); } public function current() { throw new Doctrine_Exception('Not yet implemented'); } public function key() { throw new Doctrine_Exception('Not yet implemented'); } public function next() { throw new Doctrine_Exception('Not yet implemented'); } }class Doctrine_Tree { protected $table; protected $options = array(); protected $_baseComponent; public function __construct(Doctrine_Table $table, $options) { $this->table = $table; $this->options = $options; $this->_baseComponent = $table->getComponentName(); $class = $this->_baseComponent; if ($table->getOption('inheritanceMap')) { $subclasses = $table->getOption('subclasses'); while (in_array($class, $subclasses)) { $class = get_parent_class($class); } $this->_baseComponent = $class; } } public function setTableDefinition() { throw new Doctrine_Tree_Exception('Table attributes have not been defined for this Tree implementation.'); } public function setUp() { } public static function factory(Doctrine_Table $table, $implName, $options = array()) { $class = 'Doctrine_Tree_' . $implName; if ( ! class_exists($class)) { throw new Doctrine_Exception('The chosen class must extend Doctrine_Tree'); } return new $class($table, $options); } public function getAttribute($name) { return isset($this->options[$name]) ? $this->options[$name] : null; } public function setAttribute($name, $value) { $this->options[$name] = $value; } public function getBaseComponent() { return $this->_baseComponent; } } abstract class Doctrine_Tree_AdjacencyList extends Doctrine_Tree implements Doctrine_Tree_Interface { }abstract class Doctrine_Tree_MaterializedPath extends Doctrine_Tree implements Doctrine_Tree_Interface { }class Doctrine_Tree_NestedSet extends Doctrine_Tree implements Doctrine_Tree_Interface { private $_baseQuery; private $_baseAlias = "base"; public function __construct(Doctrine_Table $table, $options) { $options['hasManyRoots'] = isset($options['hasManyRoots']) ? $options['hasManyRoots'] : false; if ($options['hasManyRoots']) { $options['rootColumnName'] = isset($options['rootColumnName']) ? $options['rootColumnName'] : 'root_id'; } parent::__construct($table, $options); } public function setTableDefinition() { if (($root = $this->getAttribute('rootColumnName')) && (!$this->table->hasColumn($root))) { $this->table->setColumn($root, 'integer'); } $this->table->setColumn('lft', 'integer', 4); $this->table->setColumn('rgt', 'integer', 4); if ($level = $this->getAttribute('levelColumnName')) { $this->table->setColumn($level . ' AS level', 'integer', 2); } else { $this->table->setColumn('level', 'integer', 2); } } public function createRoot(Doctrine_Record $record = null) { if ($this->getAttribute('hasManyRoots')) { if ( ! $record || ( ! $record->exists() && ! $record->getNode()->getRootValue()) || $record->getTable()->isIdentifierComposite()) { throw new Doctrine_Tree_Exception("Node must have a root id set or must " . " be persistent and have a single-valued numeric primary key in order to" . " be created as a root node. Automatic assignment of a root id on" . " transient/new records is no longer supported."); } if ($record->exists() && ! $record->getNode()->getRootValue()) { $identifier = $record->getTable()->getIdentifier(); $record->getNode()->setRootValue($record->get($identifier)); } } if ( ! $record) { $record = $this->table->create(); } $record->set('lft', '1'); $record->set('rgt', '2'); $record->set('level', 0); $record->save(); return $record; } public function fetchRoot($rootId = 1) { $q = $this->getBaseQuery(); $q = $q->addWhere($this->_baseAlias . '.lft = ?', 1); $q = $this->returnQueryWithRootId($q, $rootId); $data = $q->execute(); if (count($data) <= 0) { return false; } if ($data instanceof Doctrine_Collection) { $root = $data->getFirst(); $root['level'] = 0; } else if (is_array($data)) { $root = array_shift($data); $root['level'] = 0; } else { throw new Doctrine_Tree_Exception("Unexpected data structure returned."); } return $root; } public function fetchTree($options = array(), $hydrationMode = null) { $q = $this->getBaseQuery(); $depth = isset($options['depth']) ? $options['depth'] : null; $q->addWhere($this->_baseAlias . ".lft >= ?", 1); $rootId = isset($options['root_id']) ? $options['root_id'] : '1'; if (is_array($rootId)) { $q->addOrderBy($this->_baseAlias . "." . $this->getAttribute('rootColumnName') . ", " . $this->_baseAlias . ".lft ASC"); } else { $q->addOrderBy($this->_baseAlias . ".lft ASC"); } if ( ! is_null($depth)) { $q->addWhere($this->_baseAlias . ".level BETWEEN ? AND ?", array(0, $depth)); } $q = $this->returnQueryWithRootId($q, $rootId); $tree = $q->execute(array(), $hydrationMode); if (count($tree) <= 0) { return false; } return $tree; } public function fetchBranch($pk, $options = array(), $hydrationMode = null) { $record = $this->table->find($pk); if ( ! ($record instanceof Doctrine_Record) || !$record->exists()) { return false; } $depth = isset($options['depth']) ? $options['depth'] : null; $q = $this->getBaseQuery(); $params = array($record->get('lft'), $record->get('rgt')); $q->addWhere($this->_baseAlias . ".lft >= ? AND " . $this->_baseAlias . ".rgt <= ?", $params) ->addOrderBy($this->_baseAlias . ".lft asc"); if ( ! is_null($depth)) { $q->addWhere($this->_baseAlias . ".level BETWEEN ? AND ?", array($record->get('level'), $record->get('level')+$depth)); } $q = $this->returnQueryWithRootId($q, $record->getNode()->getRootValue()); return $q->execute(array(), $hydrationMode); } public function fetchRoots() { $q = $this->getBaseQuery(); $q = $q->addWhere($this->_baseAlias . '.lft = ?', 1); return $q->execute(); } public function returnQueryWithRootId($query, $rootId = 1) { if ($root = $this->getAttribute('rootColumnName')) { if (is_array($rootId)) { $query->addWhere($root . ' IN (' . implode(',', array_fill(0, count($rootId), '?')) . ')', $rootId); } else { $query->addWhere($root . ' = ?', $rootId); } } return $query; } public function getBaseQuery() { if ( ! isset($this->_baseQuery)) { $this->_baseQuery = $this->_createBaseQuery(); } return $this->_baseQuery->copy(); } public function getBaseAlias() { return $this->_baseAlias; } private function _createBaseQuery() { $this->_baseAlias = "base"; $q = Doctrine_Core::getTable($this->getBaseComponent()) ->createQuery($this->_baseAlias) ->select($this->_baseAlias . '.*'); return $q; } public function setBaseQuery(Doctrine_Query $query) { $this->_baseAlias = $query->getRootAlias(); $query->addSelect($this->_baseAlias . ".lft, " . $this->_baseAlias . ".rgt, ". $this->_baseAlias . ".level"); if ($this->getAttribute('rootColumnName')) { $query->addSelect($this->_baseAlias . "." . $this->getAttribute('rootColumnName')); } $this->_baseQuery = $query; } public function resetBaseQuery() { $this->_baseQuery = $this->_createBaseQuery(); } } class Doctrine_Tree_Exception extends Doctrine_Exception { }abstract class Doctrine_Task { public $dispatcher = null, $taskName = null, $description = null, $arguments = array(), $requiredArguments = array(), $optionalArguments = array(); public function __construct($dispatcher = null) { $this->dispatcher = $dispatcher; $taskName = $this->getTaskName(); if (! strlen($taskName)) { $taskName = self::deriveTaskName(get_class($this)); } $this->setTaskName($taskName); } public static function deriveTaskName($className) { $nameParts = explode('\\', $className); foreach ($nameParts as &$namePart) { $prefix = __CLASS__ . '_'; $baseName = strpos($namePart, $prefix) === 0 ? substr($namePart, strlen($prefix)) : $namePart; $namePart = str_replace('_', '-', Doctrine_Inflector::tableize($baseName)); } return implode('-', $nameParts); } public function notify($notification = null) { if (is_object($this->dispatcher) && method_exists($this->dispatcher, 'notify')) { $args = func_get_args(); return call_user_func_array(array($this->dispatcher, 'notify'), $args); } else if ( $notification !== null ) { return $notification; } else { return false; } } public function ask() { $args = func_get_args(); call_user_func_array(array($this, 'notify'), $args); $answer = strtolower(trim(fgets(STDIN))); return $answer; } abstract function execute(); public function validate() { $requiredArguments = $this->getRequiredArguments(); foreach ($requiredArguments as $arg) { if ( ! isset($this->arguments[$arg])) { return false; } } return true; } public function addArgument($name, $value) { $this->arguments[$name] = $value; } public function getArgument($name, $default = null) { if (isset($this->arguments[$name]) && $this->arguments[$name] !== null) { return $this->arguments[$name]; } else { return $default; } } public function getArguments() { return $this->arguments; } public function setArguments(array $args) { $this->arguments = $args; } protected static function validateTaskName($taskName) { return (bool) preg_match('/^[a-z0-9][a-z0-9\-]*$/', $taskName); } protected function setTaskName($taskName) { if (! self::validateTaskName($taskName)) { throw new InvalidArgumentException( sprintf('The task name "%s", in %s, is invalid', $taskName, get_class($this)) ); } $this->taskName = $taskName; } public function getTaskName() { return $this->taskName; } public function getDescription() { return $this->description; } public function getRequiredArguments() { return array_keys($this->requiredArguments); } public function getOptionalArguments() { return array_keys($this->optionalArguments); } public function getRequiredArgumentsDescriptions() { return $this->requiredArguments; } public function getOptionalArgumentsDescriptions() { return $this->optionalArguments; } }class Doctrine_DataDict extends Doctrine_Connection_Module { public function parseBoolean($value) { if ($value == 'true') { $value = 1; } elseif ($value == 'false') { $value = 0; } return $value; } }class Doctrine_DataDict_Sqlite extends Doctrine_DataDict { public function getNativeDeclaration(array $field) { if ( ! isset($field['type'])) { throw new Doctrine_DataDict_Exception('Missing column type.'); } switch ($field['type']) { case 'enum': $field['length'] = isset($field['length']) && $field['length'] ? $field['length']:255; case 'text': case 'object': case 'array': case 'string': case 'char': case 'gzip': case 'varchar': $length = (isset($field['length']) && $field['length']) ? $field['length'] : null; $fixed = ((isset($field['fixed']) && $field['fixed']) || $field['type'] == 'char') ? true : false; return $fixed ? ($length ? 'CHAR('.$length.')' : 'CHAR('.$this->conn->varchar_max_length.')') : ($length ? 'VARCHAR('.$length.')' : 'TEXT'); case 'clob': if ( ! empty($field['length'])) { $length = $field['length']; if ($length <= 255) { return 'TINYTEXT'; } elseif ($length <= 65535) { return 'TEXT'; } elseif ($length <= 16777215) { return 'MEDIUMTEXT'; } } return 'LONGTEXT'; case 'blob': if ( ! empty($field['length'])) { $length = $field['length']; if ($length <= 255) { return 'TINYBLOB'; } elseif ($length <= 65535) { return 'BLOB'; } elseif ($length <= 16777215) { return 'MEDIUMBLOB'; } } return 'LONGBLOB'; case 'integer': case 'boolean': case 'int': return 'INTEGER'; case 'date': return 'DATE'; case 'time': return 'TIME'; case 'timestamp': return 'DATETIME'; case 'float': case 'double': return 'DOUBLE'; case 'decimal': $length = !empty($field['length']) ? $field['length'] : 18; $scale = !empty($field['scale']) ? $field['scale'] : $this->conn->getAttribute(Doctrine_Core::ATTR_DECIMAL_PLACES); return 'DECIMAL('.$length.','.$scale.')'; } return $field['type'] . (isset($field['length']) ? '('.$field['length'].')':null); } public function getPortableDeclaration(array $field) { $e = explode('(', $field['type']); $field['type'] = $e[0]; if (isset($e[1])) { $length = trim($e[1], ')'); $field['length'] = $length; } $dbType = strtolower($field['type']); if ( ! $dbType) { throw new Doctrine_DataDict_Exception('Missing "type" from field definition'); } $length = (isset($field['length'])) ? $field['length'] : null; $unsigned = (isset($field['unsigned'])) ? $field['unsigned'] : null; $fixed = null; $type = array(); if ( ! isset($field['name'])) { $field['name'] = ''; } switch ($dbType) { case 'boolean': $type[] = 'boolean'; break; case 'tinyint': $type[] = 'integer'; $type[] = 'boolean'; if (preg_match('/^(is|has)/', $field['name'])) { $type = array_reverse($type); } $unsigned = preg_match('/ unsigned/i', $field['type']); $length = 1; break; case 'smallint': $type[] = 'integer'; $unsigned = preg_match('/ unsigned/i', $field['type']); $length = 2; break; case 'mediumint': $type[] = 'integer'; $unsigned = preg_match('/ unsigned/i', $field['type']); $length = 3; break; case 'int': case 'integer': case 'serial': $type[] = 'integer'; $unsigned = preg_match('/ unsigned/i', $field['type']); $length = 4; break; case 'bigint': case 'bigserial': $type[] = 'integer'; $unsigned = preg_match('/ unsigned/i', $field['type']); $length = 8; break; case 'clob': case 'tinytext': case 'mediumtext': case 'longtext': case 'text': case 'varchar': case 'varchar2': case 'nvarchar': case 'ntext': case 'image': case 'nchar': $fixed = false; case 'char': $type[] = 'text'; if ($length == '1') { $type[] = 'boolean'; if (preg_match('/^(is|has)/', $field['name'])) { $type = array_reverse($type); } } elseif (strstr($dbType, 'text')) { $type[] = 'clob'; } if ($fixed !== false) { $fixed = true; } break; case 'date': $type[] = 'date'; $length = null; break; case 'datetime': case 'timestamp': $type[] = 'timestamp'; $length = null; break; case 'time': $type[] = 'time'; $length = null; break; case 'float': case 'double': case 'real': $type[] = 'float'; $length = null; break; case 'decimal': case 'numeric': $type[] = 'decimal'; $length = null; break; case 'tinyblob': case 'mediumblob': case 'longblob': case 'blob': $type[] = 'blob'; $length = null; break; case 'year': $type[] = 'integer'; $type[] = 'date'; $length = null; break; default: $type[] = $field['type']; $length = isset($field['length']) ? $field['length']:null; } return array('type' => $type, 'length' => $length, 'unsigned' => $unsigned, 'fixed' => $fixed); } public function getIntegerDeclaration($name, array $field) { $default = $autoinc = ''; $type = $this->getNativeDeclaration($field); $autoincrement = isset($field['autoincrement']) && $field['autoincrement']; if ($autoincrement) { $autoinc = ' PRIMARY KEY AUTOINCREMENT'; $type = 'INTEGER'; } elseif (array_key_exists('default', $field)) { if ($field['default'] === '') { $field['default'] = empty($field['notnull']) ? null : 0; } $default = ' DEFAULT ' . (is_null($field['default']) ? 'NULL' : $this->conn->quote($field['default'], $field['type'])); } $notnull = (isset($field['notnull']) && $field['notnull']) ? ' NOT NULL' : ''; $unsigned = (isset($field['unsigned']) && $field['unsigned'] && !$autoincrement) ? ' UNSIGNED' : ''; $name = $this->conn->quoteIdentifier($name, true); return $name . ' ' . $type . $unsigned . $default . $notnull . $autoinc; } }class Doctrine_DataDict_Mysql extends Doctrine_DataDict { protected $keywords = array( 'ADD', 'ALL', 'ALTER', 'ANALYZE', 'AND', 'AS', 'ASC', 'ASENSITIVE', 'BEFORE', 'BETWEEN', 'BIGINT', 'BINARY', 'BLOB', 'BOTH', 'BY', 'BIT', 'CALL', 'CASCADE', 'CASE', 'CHANGE', 'CHAR', 'CHARACTER', 'CHECK', 'COLLATE', 'COLUMN', 'CONDITION', 'CONNECTION', 'CONSTRAINT', 'CONTINUE', 'CONVERT', 'CREATE', 'CROSS', 'CURRENT_DATE', 'CURRENT_TIME', 'CURRENT_TIMESTAMP', 'CURRENT_USER', 'CURSOR', 'DATABASE', 'DATABASES', 'DAY_HOUR', 'DAY_MICROSECOND', 'DAY_MINUTE', 'DAY_SECOND', 'DEC', 'DECIMAL', 'DECLARE', 'DEFAULT', 'DELAYED', 'DELETE', 'DESC', 'DESCRIBE', 'DETERMINISTIC', 'DISTINCT', 'DISTINCTROW', 'DIV', 'DOUBLE', 'DROP', 'DUAL', 'EACH', 'ELSE', 'ELSEIF', 'ENCLOSED', 'ESCAPED', 'EXISTS', 'EXIT', 'EXPLAIN', 'FALSE', 'FETCH', 'FLOAT', 'FLOAT4', 'FLOAT8', 'FOR', 'FORCE', 'FOREIGN', 'FROM', 'FULLTEXT', 'GRANT', 'GROUP', 'HAVING', 'HIGH_PRIORITY', 'HOUR_MICROSECOND', 'HOUR_MINUTE', 'HOUR_SECOND', 'IF', 'IGNORE', 'IN', 'INDEX', 'INFILE', 'INNER', 'INOUT', 'INSENSITIVE', 'INSERT', 'INT', 'INT1', 'INT2', 'INT3', 'INT4', 'INT8', 'INTEGER', 'INTERVAL', 'INTO', 'IS', 'ITERATE', 'JOIN', 'KEY', 'KEYS', 'KILL', 'LEADING', 'LEAVE', 'LEFT', 'LIKE', 'LIMIT', 'LINES', 'LOAD', 'LOCALTIME', 'LOCALTIMESTAMP', 'LOCK', 'LONG', 'LONGBLOB', 'LONGTEXT', 'LOOP', 'LOW_PRIORITY', 'MATCH', 'MEDIUMBLOB', 'MEDIUMINT', 'MEDIUMTEXT', 'MIDDLEINT', 'MINUTE_MICROSECOND', 'MINUTE_SECOND', 'MOD', 'MODIFIES', 'NATURAL', 'NOT', 'NO_WRITE_TO_BINLOG', 'NULL', 'NUMERIC', 'ON', 'OPTIMIZE', 'OPTION', 'OPTIONALLY', 'OR', 'ORDER', 'OUT', 'OUTER', 'OUTFILE', 'PRECISION', 'PRIMARY', 'PROCEDURE', 'PURGE', 'RAID0', 'READ', 'READS', 'REAL', 'REFERENCES', 'REGEXP', 'RELEASE', 'RENAME', 'REPEAT', 'REPLACE', 'REQUIRE', 'RESTRICT', 'RETURN', 'REVOKE', 'RIGHT', 'RLIKE', 'SCHEMA', 'SCHEMAS', 'SECOND_MICROSECOND', 'SELECT', 'SENSITIVE', 'SEPARATOR', 'SET', 'SHOW', 'SMALLINT', 'SONAME', 'SPATIAL', 'SPECIFIC', 'SQL', 'SQLEXCEPTION', 'SQLSTATE', 'SQLWARNING', 'SQL_BIG_RESULT', 'SQL_CALC_FOUND_ROWS', 'SQL_SMALL_RESULT', 'SSL', 'STARTING', 'STRAIGHT_JOIN', 'TABLE', 'TERMINATED', 'THEN', 'TINYBLOB', 'TINYINT', 'TINYTEXT', 'TO', 'TRAILING', 'TRIGGER', 'TRUE', 'UNDO', 'UNION', 'UNIQUE', 'UNLOCK', 'UNSIGNED', 'UPDATE', 'USAGE', 'USE', 'USING', 'UTC_DATE', 'UTC_TIME', 'UTC_TIMESTAMP', 'VALUES', 'VARBINARY', 'VARCHAR', 'VARCHARACTER', 'VARYING', 'WHEN', 'WHERE', 'WHILE', 'WITH', 'WRITE', 'X509', 'XOR', 'YEAR_MONTH', 'ZEROFILL' ); public function getNativeDeclaration($field) { if ( ! isset($field['type'])) { throw new Doctrine_DataDict_Exception('Missing column type.'); } switch ($field['type']) { case 'char': $length = ( ! empty($field['length'])) ? $field['length'] : false; return $length ? 'CHAR('.$length.')' : 'CHAR(255)'; case 'enum': if ($this->conn->getAttribute(Doctrine_Core::ATTR_USE_NATIVE_ENUM)) { $values = array(); foreach ($field['values'] as $value) { $values[] = $this->conn->quote($value, 'varchar'); } return 'ENUM('.implode(', ', $values).')'; } else { $field['length'] = isset($field['length']) && $field['length'] ? $field['length']:255; } case 'set': if ($this->conn->getAttribute(Doctrine_Core::ATTR_USE_NATIVE_SET)) { $values = array(); foreach ($field['values'] as $value) { $values[] = $this->conn->quote($value, 'varchar'); } return 'SET('.implode(', ', $values).')'; } else { $field['length'] = isset($field['length']) && $field['length'] ? $field['length']:255; } case 'varchar': case 'string': case 'gzip': if ( ! isset($field['length'])) { if (array_key_exists('default', $field)) { $field['length'] = $this->conn->varchar_max_length; } else { $field['length'] = false; } } $length = ($field['length'] <= $this->conn->varchar_max_length) ? $field['length'] : false; $fixed = (isset($field['fixed'])) ? $field['fixed'] : false; return $fixed ? ($length ? 'CHAR(' . $length . ')' : 'CHAR(255)') : ($length ? 'VARCHAR(' . $length . ')' : 'TEXT'); case 'array': case 'object': case 'clob': if ( ! empty($field['length'])) { $length = $field['length']; if ($length <= 255) { return 'TINYTEXT'; } elseif ($length <= 65532) { return 'TEXT'; } elseif ($length <= 16777215) { return 'MEDIUMTEXT'; } } return 'LONGTEXT'; case 'blob': if ( ! empty($field['length'])) { $length = $field['length']; if ($length <= 255) { return 'TINYBLOB'; } elseif ($length <= 65532) { return 'BLOB'; } elseif ($length <= 16777215) { return 'MEDIUMBLOB'; } } return 'LONGBLOB'; case 'integer': case 'int': if ( ! empty($field['length'])) { $length = $field['length']; if ($length <= 1) { return 'TINYINT'; } elseif ($length == 2) { return 'SMALLINT'; } elseif ($length == 3) { return 'MEDIUMINT'; } elseif ($length == 4) { return 'INT'; } elseif ($length > 4) { return 'BIGINT'; } } return 'INT'; case 'boolean': return 'TINYINT(1)'; case 'date': return 'DATE'; case 'time': return 'TIME'; case 'timestamp': return 'DATETIME'; case 'float': $length = !empty($field['length']) ? $field['length'] : 18; $scale = !empty($field['scale']) ? $field['scale'] : $this->conn->getAttribute(Doctrine_Core::ATTR_DECIMAL_PLACES); return 'FLOAT('.$length.', '.$scale.')'; case 'double': $length = !empty($field['length']) ? $field['length'] : 18; $scale = !empty($field['scale']) ? $field['scale'] : $this->conn->getAttribute(Doctrine_Core::ATTR_DECIMAL_PLACES); return 'DOUBLE('.$length.', '.$scale.')'; case 'decimal': $length = !empty($field['length']) ? $field['length'] : 18; $scale = !empty($field['scale']) ? $field['scale'] : $this->conn->getAttribute(Doctrine_Core::ATTR_DECIMAL_PLACES); return 'DECIMAL('.$length.', '.$scale.')'; case 'bit': return 'BIT'; } return $field['type'] . (isset($field['length']) ? '('.$field['length'].')':null); } public function getPortableDeclaration(array $field) { $dbType = strtolower($field['type']); $dbType = strtok($dbType, '(), '); if ($dbType == 'national') { $dbType = strtok('(), '); } if (isset($field['length'])) { $length = $field['length']; $decimal = ''; } else { $length = strtok('(), '); $decimal = strtok('(), '); if ( ! $decimal ) { $decimal = null; } } $type = array(); $unsigned = $fixed = null; if ( ! isset($field['name'])) { $field['name'] = ''; } $values = null; $scale = null; switch ($dbType) { case 'tinyint': $type[] = 'integer'; $type[] = 'boolean'; if (preg_match('/^(is|has)/', $field['name'])) { $type = array_reverse($type); } $unsigned = preg_match('/ unsigned/i', $field['type']); $length = 1; break; case 'smallint': $type[] = 'integer'; $unsigned = preg_match('/ unsigned/i', $field['type']); $length = 2; break; case 'mediumint': $type[] = 'integer'; $unsigned = preg_match('/ unsigned/i', $field['type']); $length = 3; break; case 'int': case 'integer': $type[] = 'integer'; $unsigned = preg_match('/ unsigned/i', $field['type']); $length = 4; break; case 'bigint': $type[] = 'integer'; $unsigned = preg_match('/ unsigned/i', $field['type']); $length = 8; break; case 'tinytext': case 'mediumtext': case 'longtext': case 'text': case 'text': case 'varchar': $fixed = false; case 'string': case 'char': $type[] = 'string'; if ($length == '1') { $type[] = 'boolean'; if (preg_match('/^(is|has)/', $field['name'])) { $type = array_reverse($type); } } elseif (strstr($dbType, 'text')) { $type[] = 'clob'; if ($decimal == 'binary') { $type[] = 'blob'; } } if ($fixed !== false) { $fixed = true; } break; case 'enum': $type[] = 'enum'; preg_match_all('/\'((?:\'\'|[^\'])*)\'/', $field['type'], $matches); $length = 0; $fixed = false; if (is_array($matches)) { foreach ($matches[1] as &$value) { $value = str_replace('\'\'', '\'', $value); $length = max($length, strlen($value)); } if ($length == '1' && count($matches[1]) == 2) { $type[] = 'boolean'; if (preg_match('/^(is|has)/', $field['name'])) { $type = array_reverse($type); } } $values = $matches[1]; } $type[] = 'integer'; break; case 'set': $fixed = false; $type[] = 'text'; $type[] = 'integer'; break; case 'date': $type[] = 'date'; $length = null; break; case 'datetime': case 'timestamp': $type[] = 'timestamp'; $length = null; break; case 'time': $type[] = 'time'; $length = null; break; case 'float': case 'double': case 'real': $type[] = 'float'; $unsigned = preg_match('/ unsigned/i', $field['type']); break; case 'unknown': case 'decimal': if ($decimal !== null) { $scale = $decimal; } case 'numeric': $type[] = 'decimal'; $unsigned = preg_match('/ unsigned/i', $field['type']); break; case 'tinyblob': case 'mediumblob': case 'longblob': case 'blob': case 'binary': case 'varbinary': $type[] = 'blob'; $length = null; break; case 'year': $type[] = 'integer'; $type[] = 'date'; $length = null; break; case 'bit': $type[] = 'bit'; break; case 'geometry': case 'geometrycollection': case 'point': case 'multipoint': case 'linestring': case 'multilinestring': case 'polygon': case 'multipolygon': $type[] = 'blob'; $length = null; break; default: $type[] = $field['type']; $length = isset($field['length']) ? $field['length']:null; } $length = ((int) $length == 0) ? null : (int) $length; $def = array('type' => $type, 'length' => $length, 'unsigned' => $unsigned, 'fixed' => $fixed); if ($values !== null) { $def['values'] = $values; } if ($scale !== null) { $def['scale'] = $scale; } return $def; } public function getCharsetFieldDeclaration($charset) { return 'CHARACTER SET ' . $charset; } public function getCollationFieldDeclaration($collation) { return 'COLLATE ' . $collation; } public function getIntegerDeclaration($name, $field) { $unique = (isset($field['unique']) && $field['unique']) ? ' UNIQUE' : ''; $default = $autoinc = ''; if ( ! empty($field['autoincrement'])) { $autoinc = ' AUTO_INCREMENT'; } elseif (array_key_exists('default', $field)) { if ($field['default'] === '') { $field['default'] = empty($field['notnull']) ? null : 0; } $default = ' DEFAULT ' . (is_null($field['default']) ? 'NULL' : $this->conn->quote($field['default'])); } $notnull = (isset($field['notnull']) && $field['notnull']) ? ' NOT NULL' : ''; $unsigned = (isset($field['unsigned']) && $field['unsigned']) ? ' UNSIGNED' : ''; $comment = (isset($field['comment']) && $field['comment']) ? " COMMENT " . $this->conn->quote($field['comment'], 'text') : ''; $name = $this->conn->quoteIdentifier($name, true); return $name . ' ' . $this->getNativeDeclaration($field) . $unsigned . $default . $unique . $notnull . $autoinc . $comment; } }class Doctrine_DataDict_Mssql extends Doctrine_DataDict { public function getNativeDeclaration($field) { if ( ! isset($field['type'])) { throw new Doctrine_DataDict_Exception('Missing column type.'); } switch ($field['type']) { case 'enum': $field['length'] = isset($field['length']) && $field['length'] ? $field['length']:255; case 'array': case 'object': case 'text': case 'char': case 'varchar': case 'string': case 'gzip': $length = !empty($field['length']) ? $field['length'] : false; $fixed = ((isset($field['fixed']) && $field['fixed']) || $field['type'] == 'char') ? true : false; return $fixed ? ($length ? 'CHAR('.$length.')' : 'CHAR('.$this->conn->varchar_max_length.')') : (($length && $length <= $this->conn->varchar_max_length) ? 'VARCHAR('.$length.')' : 'TEXT'); case 'clob': if ( ! empty($field['length'])) { $length = $field['length']; if ($length <= 8000) { return 'VARCHAR('.$length.')'; } } return 'TEXT'; case 'blob': if ( ! empty($field['length'])) { $length = $field['length']; if ($length <= 8000) { return "VARBINARY($length)"; } } return 'IMAGE'; case 'integer': case 'int': return (isset($field['unsigned']) && $field['unsigned']) ? 'BIGINT' : 'INT'; case 'boolean': return 'BIT'; case 'date': return 'CHAR(' . strlen('YYYY-MM-DD') . ')'; case 'time': return 'CHAR(' . strlen('HH:MM:SS') . ')'; case 'timestamp': return 'CHAR(' . strlen('YYYY-MM-DD HH:MM:SS') . ')'; case 'float': return 'FLOAT'; case 'decimal': $length = !empty($field['length']) ? $field['length'] : 18; $scale = !empty($field['scale']) ? $field['scale'] : $this->conn->getAttribute(Doctrine_Core::ATTR_DECIMAL_PLACES); return 'DECIMAL('.$length.','.$scale.')'; } return $field['type'] . (isset($field['length']) ? '('.$field['length'].')':null); } public function getPortableDeclaration($field) { $db_type = preg_replace('/[\d\(\)]/','', strtolower($field['type']) ); $length = (isset($field['length']) && $field['length'] > 0) ? $field['length'] : null; $type = array(); $unsigned = $fixed = null; if ( ! isset($field['name'])) $field['name'] = ''; switch ($db_type) { case 'bit': $type[0] = 'boolean'; break; case 'tinyint': case 'smallint': case 'bigint': case 'int': $type[0] = 'integer'; if ($length == 1) { $type[] = 'boolean'; } break; case 'date': $type[0] = 'date'; break; case 'datetime': case 'timestamp': case 'smalldatetime': $type[0] = 'timestamp'; break; case 'float': case 'real': case 'numeric': $type[0] = 'float'; break; case 'decimal': case 'money': case 'smallmoney': $type[0] = 'decimal'; break; case 'text': case 'varchar': case 'ntext': case 'nvarchar': $fixed = false; case 'char': case 'nchar': $type[0] = 'string'; if ($length == '1') { $type[] = 'boolean'; if (preg_match('/^[is|has]/', $field['name'])) { $type = array_reverse($type); } } elseif (strstr($db_type, 'text')) { $type[] = 'clob'; } if ($fixed !== false) { $fixed = true; } break; case 'image': case 'varbinary': $type[] = 'blob'; $length = null; break; case 'uniqueidentifier': $type[] = 'string'; $length = 36; break; case 'sql_variant': case 'sysname': case 'binary': $type[] = 'string'; $length = null; break; default: $type[] = $field['type']; $length = isset($field['length']) ? $field['length']:null; } return array('type' => $type, 'length' => $length, 'unsigned' => $unsigned, 'fixed' => $fixed); } public function getIntegerDeclaration($name, $field) { $default = $autoinc = ''; if ( ! empty($field['autoincrement'])) { $autoinc = ' identity'; } elseif (array_key_exists('default', $field)) { if ($field['default'] === '') { $field['default'] = empty($field['notnull']) ? null : 0; } $value = (is_null($field['default']) ? 'NULL' : $this->conn->quote($field['default'])); if (array_key_exists('defaultConstraintName', $field)) { $default .= ' CONSTRAINT ' . $field['defaultConstraintName']; } $default .= ' DEFAULT ' . $value; } $notnull = (isset($field['notnull']) && $field['notnull']) ? ' NOT NULL' : ' NULL'; $unsigned = ''; $comment = (isset($field['comment']) && $field['comment']) ? " COMMENT " . $this->conn->quote($field['comment'], 'text') : ''; $name = $this->conn->quoteIdentifier($name, true); return $name . ' ' . $this->getNativeDeclaration($field) . $unsigned . $default . $notnull . $autoinc . $comment; } }class Doctrine_DataDict_Oracle extends Doctrine_DataDict { public function getNativeDeclaration(array $field) { if ( ! isset($field['type'])) { throw new Doctrine_DataDict_Exception('Missing column type.'); } switch ($field['type']) { case 'enum': $field['length'] = isset($field['length']) && $field['length'] ? $field['length']:255; case 'string': case 'array': case 'object': case 'gzip': case 'char': case 'varchar': $length = !empty($field['length']) ? $field['length'] : false; $fixed = ((isset($field['fixed']) && $field['fixed']) || $field['type'] == 'char') ? true : false; $unit = $this->conn->getParam('char_unit'); $unit = ! is_null($unit) ? ' '.$unit : ''; if ($length && $length <= $this->conn->getParam('varchar2_max_length')) { return $fixed ? 'CHAR('.$length.$unit.')' : 'VARCHAR2('.$length.$unit.')'; } case 'clob': return 'CLOB'; case 'blob': return 'BLOB'; case 'integer': case 'int': $length = (!empty($field['length'])) ? $field['length'] : false; if ( $length && $length <= $this->conn->number_max_precision) { if ($length <= 1) { return 'NUMBER(3)'; } elseif ($length == 2) { return 'NUMBER(5)'; } elseif ($length == 3) { return 'NUMBER(8)'; } elseif ($length == 4) { return 'NUMBER(10)'; } elseif ($length <= 8) { return 'NUMBER(20)'; } else { return 'INTEGER'; } } return 'INTEGER'; case 'boolean': return 'NUMBER(1)'; case 'date': case 'time': case 'timestamp': return 'DATE'; case 'float': case 'double': return 'NUMBER'; case 'decimal': $scale = !empty($field['scale']) ? $field['scale'] : $this->conn->getAttribute(Doctrine_Core::ATTR_DECIMAL_PLACES); return 'NUMBER(*,'.$scale.')'; default: } return $field['type'] . (isset($field['length']) ? '('.$field['length'].')':null); } public function getPortableDeclaration(array $field) { if ( ! isset($field['data_type'])) { throw new Doctrine_DataDict_Exception('Native oracle definition must have a data_type key specified'); } $dbType = strtolower($field['data_type']); $type = array(); $length = $unsigned = $fixed = null; if ( ! empty($field['data_length'])) { $length = (int)$field['data_length']; } if ( ! isset($field['column_name'])) { $field['column_name'] = ''; } switch ($dbType) { case 'integer': case 'pls_integer': case 'binary_integer': $type[] = 'integer'; if ($length == '1') { $type[] = 'boolean'; if (preg_match('/^(is|has)/i', $field['column_name'])) { $type = array_reverse($type); } } break; case 'varchar': case 'varchar2': case 'nvarchar2': $fixed = false; case 'char': case 'nchar': $type[] = 'string'; if ($length == '1') { $type[] = 'boolean'; if (preg_match('/^(is|has)/i', $field['column_name'])) { $type = array_reverse($type); } } if ($fixed !== false) { $fixed = true; } break; case 'date': case 'timestamp': $type[] = 'timestamp'; $length = null; break; case 'float': $type[] = 'float'; break; case 'number': if ( ! empty($field['data_scale'])) { $type[] = 'decimal'; } else { $type[] = 'integer'; if ((int)$length == '1') { $type[] = 'boolean'; if (preg_match('/^(is|has)/i', $field['column_name'])) { $type = array_reverse($type); } else { $length = 1; } } elseif ( ! is_null($length) && (int)$length <= 3) { $length = 1; } elseif ( ! is_null($length) && (int)$length <= 5) { $length = 2; } elseif ( ! is_null($length) && (int)$length <= 8) { $length = 3; } elseif ( ! is_null($length) && (int)$length <= 10) { $length = 4; } elseif ( ! is_null($length) && (int)$length <= 20) { $length = 8; } } break; case 'long': $type[] = 'string'; case 'clob': case 'nclob': $type[] = 'clob'; break; case 'blob': case 'raw': case 'long raw': case 'bfile': $type[] = 'blob'; $length = null; break; case 'rowid': case 'urowid': default: $type[] = $field['type']; $length = isset($field['length']) ? $field['length']:null; } return array('type' => $type, 'length' => $length, 'unsigned' => $unsigned, 'fixed' => $fixed); } } class Doctrine_DataDict_Pgsql extends Doctrine_DataDict { protected static $reservedKeyWords = array( 'abort', 'absolute', 'access', 'action', 'add', 'after', 'aggregate', 'all', 'alter', 'analyse', 'analyze', 'and', 'any', 'as', 'asc', 'assertion', 'assignment', 'at', 'authorization', 'backward', 'before', 'begin', 'between', 'bigint', 'binary', 'bit', 'boolean', 'both', 'by', 'cache', 'called', 'cascade', 'case', 'cast', 'chain', 'char', 'character', 'characteristics', 'check', 'checkpoint', 'class', 'close', 'cluster', 'coalesce', 'collate', 'column', 'comment', 'commit', 'committed', 'constraint', 'constraints', 'conversion', 'convert', 'copy', 'create', 'createdb', 'createuser', 'cross', 'current_date', 'current_time', 'current_timestamp', 'current_user', 'cursor', 'cycle', 'database', 'day', 'deallocate', 'dec', 'decimal', 'declare', 'default', 'deferrable', 'deferred', 'definer', 'delete', 'delimiter', 'delimiters', 'desc', 'distinct', 'do', 'domain', 'double', 'drop', 'each', 'else', 'encoding', 'encrypted', 'end', 'escape', 'except', 'exclusive', 'execute', 'exists', 'explain', 'external', 'extract', 'false', 'fetch', 'float', 'for', 'force', 'foreign', 'forward', 'freeze', 'from', 'full', 'function', 'get', 'global', 'grant', 'group', 'handler', 'having', 'hour', 'ilike', 'immediate', 'immutable', 'implicit', 'in', 'increment', 'index', 'inherits', 'initially', 'inner', 'inout', 'input', 'insensitive', 'insert', 'instead', 'int', 'integer', 'intersect', 'interval', 'into', 'invoker', 'is', 'isnull', 'isolation', 'join', 'key', 'lancompiler', 'language', 'leading', 'left', 'level', 'like', 'limit', 'listen', 'load', 'local', 'localtime', 'localtimestamp', 'location', 'lock', 'match', 'maxvalue', 'minute', 'minvalue', 'mode', 'month', 'move', 'names', 'national', 'natural', 'nchar', 'new', 'next', 'no', 'nocreatedb', 'nocreateuser', 'none', 'not', 'nothing', 'notify', 'notnull', 'null', 'nullif', 'numeric', 'of', 'off', 'offset', 'oids', 'old', 'on', 'only', 'operator', 'option', 'or', 'order', 'out', 'outer', 'overlaps', 'overlay', 'owner', 'partial', 'password', 'path', 'pendant', 'placing', 'position', 'precision', 'prepare', 'primary', 'prior', 'privileges', 'procedural', 'procedure', 'read', 'real', 'recheck', 'references', 'reindex', 'relative', 'rename', 'replace', 'reset', 'restrict', 'returns', 'revoke', 'right', 'rollback', 'row', 'rule', 'schema', 'scroll', 'second', 'security', 'select', 'sequence', 'serializable', 'session', 'session_user', 'set', 'setof', 'share', 'show', 'similar', 'simple', 'smallint', 'some', 'stable', 'start', 'statement', 'statistics', 'stdin', 'stdout', 'storage', 'strict', 'substring', 'sysid', 'table', 'temp', 'template', 'temporary', 'then', 'time', 'timestamp', 'to', 'toast', 'trailing', 'transaction', 'treat', 'trigger', 'trim', 'true', 'truncate', 'trusted', 'type', 'unencrypted', 'union', 'unique', 'unknown', 'unlisten', 'until', 'update', 'usage', 'user', 'using', 'vacuum', 'valid', 'validator', 'values', 'varchar', 'varying', 'verbose', 'version', 'view', 'volatile', 'when', 'where', 'with', 'without', 'work', 'write', 'year', 'zone' ); public function getNativeDeclaration(array $field) { if ( ! isset($field['type'])) { throw new Doctrine_DataDict_Exception('Missing column type.'); } if (strpos($field['type'], 'enum') !== false){ $field['type'] = 'enum'; } switch ($field['type']) { case 'enum': $field['length'] = isset($field['length']) && $field['length'] ? $field['length']:255; case 'char': case 'string': case 'array': case 'object': case 'varchar': case 'gzip': $length = (isset($field['length']) && $field['length'] && $field['length'] < 10000) ? $field['length'] : null; $fixed = ((isset($field['fixed']) && $field['fixed']) || $field['type'] == 'char') ? true : false; return $fixed ? ($length ? 'CHAR(' . $length . ')' : 'CHAR('.$this->conn->varchar_max_length.')') : ($length ? 'VARCHAR(' .$length . ')' : 'TEXT'); case 'clob': return 'TEXT'; case 'blob': return 'BYTEA'; case 'integer': case 'int': if ( ! empty($field['autoincrement'])) { if ( ! empty($field['length'])) { $length = $field['length']; if ($length > 4) { return 'BIGSERIAL'; } } return 'SERIAL'; } if ( ! empty($field['length'])) { $length = $field['length']; if ($length <= 2) { return 'SMALLINT'; } elseif ($length == 3 || $length == 4) { return 'INT'; } elseif ($length > 4) { return 'BIGINT'; } } return 'INT'; case 'inet': return 'INET'; case 'bit': case 'varbit': return 'VARBIT'; case 'boolean': return 'BOOLEAN'; case 'date': return 'DATE'; case 'time': return 'TIME'; case 'timestamp': return 'TIMESTAMP'; case 'float': case 'double': return 'FLOAT'; case 'decimal': $length = !empty($field['length']) ? $field['length'] : 18; $scale = !empty($field['scale']) ? $field['scale'] : $this->conn->getAttribute(Doctrine_Core::ATTR_DECIMAL_PLACES); return 'NUMERIC('.$length.','.$scale.')'; } return $field['type'] . (isset($field['length']) ? '('.$field['length'].')':null); } public function getPortableDeclaration(array $field) { $length = (isset($field['length'])) ? $field['length'] : null; if ($length == '-1' && isset($field['atttypmod'])) { $length = $field['atttypmod'] - 4; } if ((int)$length <= 0) { $length = null; } $type = array(); $unsigned = $fixed = null; if ( ! isset($field['name'])) { $field['name'] = ''; } $dbType = strtolower($field['type']); $default = isset($field['default']) ? $field['default'] : null; $enumName = null; if (strpos($dbType, 'enum') !== false){ $enumName = $dbType; $dbType = 'enum'; } switch ($dbType) { case 'inet': $type[] = 'inet'; break; case 'bit': case 'varbit': $type[] = 'bit'; break; case 'smallint': case 'int2': $type[] = 'integer'; $unsigned = false; $length = 2; if ($length == '2') { $type[] = 'boolean'; if (preg_match('/^(is|has)/', $field['name'])) { $type = array_reverse($type); } } break; case 'int': case 'int4': case 'integer': case 'serial': case 'serial4': $type[] = 'integer'; $unsigned = false; $length = 4; break; case 'bigint': case 'int8': case 'bigserial': case 'serial8': $type[] = 'integer'; $unsigned = false; $length = 8; break; case 'bool': case 'boolean': $type[] = 'boolean'; $length = 1; break; case 'text': case 'varchar': case 'interval': case '_varchar': $fixed = false; case 'tsvector': case 'unknown': case 'char': case 'character': case 'bpchar': $type[] = 'string'; if ($length == '1') { $type[] = 'boolean'; if (preg_match('/^(is|has)/', $field['name'])) { $type = array_reverse($type); } } elseif (strstr($dbType, 'text')) { $type[] = 'clob'; } if ($fixed !== false) { $fixed = true; } break; case 'enum': $type[] = 'enum'; $length = $length ? $length :255; if($default) { $default = preg_replace('/\'(\w+)\'.*/', '${1}', $default); } break; case 'date': $type[] = 'date'; $length = null; break; case 'datetime': case 'timestamp': case 'timetz': case 'timestamptz': $type[] = 'timestamp'; $length = null; break; case 'time': $type[] = 'time'; $length = null; break; case 'float': case 'float4': case 'float8': case 'double': case 'double precision': case 'real': $type[] = 'float'; break; case 'decimal': case 'money': case 'numeric': $type[] = 'decimal'; break; case 'tinyblob': case 'mediumblob': case 'longblob': case 'blob': case 'bytea': case 'geometry': case 'geometrycollection': case 'point': case 'multipoint': case 'linestring': case 'multilinestring': case 'polygon': case 'multipolygon': $type[] = 'blob'; $length = null; break; case 'oid': $type[] = 'blob'; $type[] = 'clob'; $length = null; break; case 'year': $type[] = 'integer'; $type[] = 'date'; $length = null; break; default: $type[] = $field['type']; $length = isset($field['length']) ? $field['length']:null; } $ret = array('type' => $type, 'length' => $length, 'unsigned' => $unsigned, 'fixed' => $fixed); if ($default !== null) { $ret['default'] = $default; } if ($enumName !== null) { $ret['enumName'] = $enumName; } return $ret; } public function getIntegerDeclaration($name, $field) { if ( ! empty($field['autoincrement'])) { $name = $this->conn->quoteIdentifier($name, true); return $name . ' ' . $this->getNativeDeclaration($field); } $default = ''; if (array_key_exists('default', $field)) { if ($field['default'] === '') { $field['default'] = empty($field['notnull']) ? null : 0; } $default = ' DEFAULT ' . (is_null($field['default']) ? 'NULL' : $this->conn->quote($field['default'], $field['type'])); } $notnull = empty($field['notnull']) ? '' : ' NOT NULL'; $name = $this->conn->quoteIdentifier($name, true); return $name . ' ' . $this->getNativeDeclaration($field) . $default . $notnull; } public function parseBoolean($value) { return $value; } } class Doctrine_DataDict_Exception extends Doctrine_Exception { }class Doctrine_Locator_Injectable { protected $_locator; protected $_resources = array(); protected static $_null; public function setLocator(Doctrine_Locator $locator) { $this->_locator = $locator; return $this; } public function getLocator() { if ( ! isset($this->_locator)) { $this->_locator = Doctrine_Locator::instance(); } return $this->_locator; } public function locate($name) { if (isset($this->_resources[$name])) { if (is_object($this->_resources[$name])) { return $this->_resources[$name]; } else { $concreteImpl = $this->_resources[$name]; return $this->getLocator()->locate($concreteImpl); } } else { return $this->getLocator()->locate($name); } } public function bind($name, $resource) { $this->_resources[$name] = $resource; return $this; } public static function initNullObject(Doctrine_Null $null) { self::$_null = $null; } public static function getNullObject() { return self::$_null; } }abstract class Doctrine_Access extends Doctrine_Locator_Injectable implements ArrayAccess { public function setArray(array $array) { foreach ($array as $k => $v) { $this->set($k, $v); } return $this; } public function __set($name, $value) { $this->set($name, $value); } public function __get($name) { return $this->get($name); } public function __isset($name) { return $this->contains($name); } public function __unset($name) { return $this->remove($name); } public function offsetExists($offset) { return $this->contains($offset); } public function offsetGet($offset) { return $this->get($offset); } public function offsetSet($offset, $value) { if ( ! isset($offset)) { $this->add($value); } else { $this->set($offset, $value); } } public function offsetUnset($offset) { return $this->remove($offset); } public function remove($offset) { throw new Doctrine_Exception('Remove is not supported for ' . get_class($this)); } public function get($offset) { throw new Doctrine_Exception('Get is not supported for ' . get_class($this)); } public function set($offset, $value) { throw new Doctrine_Exception('Set is not supported for ' . get_class($this)); } public function contains($offset) { throw new Doctrine_Exception('Contains is not supported for ' . get_class($this)); } public function add($value) { throw new Doctrine_Exception('Add is not supported for ' . get_class($this)); } } class Doctrine_Collection extends Doctrine_Access implements Countable, IteratorAggregate, Serializable { protected $data = array(); protected $_table; protected $_snapshot = array(); protected $reference; protected $referenceField; protected $relation; protected $keyColumn; protected static $null; public function __construct($table, $keyColumn = null) { if ( ! ($table instanceof Doctrine_Table)) { $table = Doctrine_Core::getTable($table); } $this->_table = $table; if ($keyColumn === null) { $keyColumn = $table->getBoundQueryPart('indexBy'); } if ($keyColumn === null) { $keyColumn = $table->getAttribute(Doctrine_Core::ATTR_COLL_KEY); } if ($keyColumn !== null) { $this->keyColumn = $keyColumn; } } public static function initNullObject(Doctrine_Null $null) { self::$null = $null; } public static function create($table, $keyColumn = null, $class = null) { if (is_null($class)) { if ( ! $table instanceof Doctrine_Table) { $table = Doctrine_Core::getTable($table); } $class = $table->getAttribute(Doctrine_Core::ATTR_COLLECTION_CLASS); } return new $class($table, $keyColumn); } public function getTable() { return $this->_table; } public function setData(array $data) { $this->data = $data; } public function serialize() { $vars = get_object_vars($this); unset($vars['reference']); unset($vars['referenceField']); unset($vars['relation']); unset($vars['expandable']); unset($vars['expanded']); unset($vars['generator']); $vars['_table'] = $vars['_table']->getComponentName(); return serialize($vars); } public function unserialize($serialized) { $manager = Doctrine_Manager::getInstance(); $connection = $manager->getCurrentConnection(); $array = unserialize($serialized); foreach ($array as $name => $values) { $this->$name = $values; } $this->_table = $connection->getTable($this->_table); $keyColumn = isset($array['keyColumn']) ? $array['keyColumn'] : null; if ($keyColumn === null) { $keyColumn = $this->_table->getBoundQueryPart('indexBy'); } if ($keyColumn !== null) { $this->keyColumn = $keyColumn; } } public function setKeyColumn($column) { $this->keyColumn = $column; return $this; } public function getKeyColumn() { return $this->keyColumn; } public function getData() { return $this->data; } public function getFirst() { return reset($this->data); } public function getLast() { return end($this->data); } public function end() { return end($this->data); } public function key() { return key($this->data); } public function setReference(Doctrine_Record $record, Doctrine_Relation $relation) { $this->reference = $record; $this->relation = $relation; if ($relation instanceof Doctrine_Relation_ForeignKey || $relation instanceof Doctrine_Relation_LocalKey) { $this->referenceField = $relation->getForeignFieldName(); $value = $record->get($relation->getLocalFieldName()); foreach ($this->data as $record) { if ($value !== null) { $record->set($this->referenceField, $value, false); } else { $record->set($this->referenceField, $this->reference, false); } } } elseif ($relation instanceof Doctrine_Relation_Association) { } } public function getReference() { return $this->reference; } public function remove($key) { $removed = $this->data[$key]; unset($this->data[$key]); return $removed; } public function contains($key) { return isset($this->data[$key]); } public function search(Doctrine_Record $record) { return array_search($record, $this->data, true); } public function get($key) { if ( ! isset($this->data[$key])) { $record = $this->_table->create(); if (isset($this->referenceField)) { $value = $this->reference->get($this->relation->getLocalFieldName()); if ($value !== null) { $record->set($this->referenceField, $value, false); } else { $record->set($this->referenceField, $this->reference, false); } } if ($key === null) { $this->data[] = $record; } else { $this->data[$key] = $record; } if (isset($this->keyColumn)) { $record->set($this->keyColumn, $key); } return $record; } return $this->data[$key]; } public function getPrimaryKeys() { $list = array(); $name = $this->_table->getIdentifier(); foreach ($this->data as $record) { if (is_array($record) && isset($record[$name])) { $list[] = $record[$name]; } else { $list[] = $record->getIncremented(); } } return $list; } public function getKeys() { return array_keys($this->data); } public function count() { return count($this->data); } public function set($key, $record) { if (isset($this->referenceField)) { $record->set($this->referenceField, $this->reference, false); } $this->data[$key] = $record; } public function add($record, $key = null) { if (isset($this->referenceField)) { $value = $this->reference->get($this->relation->getLocalFieldName()); if ($value !== null) { $record->set($this->referenceField, $value, false); } else { $record->set($this->referenceField, $this->reference, false); } $relations = $this->relation['table']->getRelations(); foreach ($relations as $relation) { if ($this->relation['class'] == $relation['localTable']->getOption('name') && $relation->getLocal() == $this->relation->getForeignFieldName()) { $record->$relation['alias'] = $this->reference; break; } } } foreach ($this->data as $val) { if ($val === $record) { return false; } } if (isset($key)) { if (isset($this->data[$key])) { return false; } $this->data[$key] = $record; return true; } if (isset($this->keyColumn)) { $value = $record->get($this->keyColumn); if ($value === null) { throw new Doctrine_Collection_Exception("Couldn't create collection index. Record field '".$this->keyColumn."' was null."); } $this->data[$value] = $record; } else { $this->data[] = $record; } return true; } public function merge(Doctrine_Collection $coll) { $localBase = $this->getTable()->getComponentName(); $otherBase = $coll->getTable()->getComponentName(); if ($otherBase != $localBase && !is_subclass_of($otherBase, $localBase) ) { throw new Doctrine_Collection_Exception("Can't merge collections with incompatible record types"); } foreach ($coll->getData() as $record) { $this->add($record); } return $this; } public function loadRelated($name = null) { $list = array(); $query = $this->_table->createQuery(); if ( ! isset($name)) { foreach ($this->data as $record) { $value = $record->getIncremented(); if ($value !== null) { $list[] = $value; } } $query->where($this->_table->getComponentName() . '.id IN (' . substr(str_repeat("?, ", count($list)),0,-2) . ')'); if ( ! $list) { $query->where($this->_table->getComponentName() . '.id IN (' . substr(str_repeat("?, ", count($list)),0,-2) . ')', $list); } return $query; } $rel = $this->_table->getRelation($name); if ($rel instanceof Doctrine_Relation_LocalKey || $rel instanceof Doctrine_Relation_ForeignKey) { foreach ($this->data as $record) { $list[] = $record[$rel->getLocal()]; } } else { foreach ($this->data as $record) { $value = $record->getIncremented(); if ($value !== null) { $list[] = $value; } } } if ( ! $list) { return; } $dql = $rel->getRelationDql(count($list), 'collection'); $coll = $query->query($dql, $list); $this->populateRelated($name, $coll); } public function populateRelated($name, Doctrine_Collection $coll) { $rel = $this->_table->getRelation($name); $table = $rel->getTable(); $foreign = $rel->getForeign(); $local = $rel->getLocal(); if ($rel instanceof Doctrine_Relation_LocalKey) { foreach ($this->data as $key => $record) { foreach ($coll as $k => $related) { if ($related[$foreign] == $record[$local]) { $this->data[$key]->setRelated($name, $related); } } } } elseif ($rel instanceof Doctrine_Relation_ForeignKey) { foreach ($this->data as $key => $record) { if ( ! $record->exists()) { continue; } $sub = Doctrine_Collection::create($table); foreach ($coll as $k => $related) { if ($related[$foreign] == $record[$local]) { $sub->add($related); $coll->remove($k); } } $this->data[$key]->setRelated($name, $sub); } } elseif ($rel instanceof Doctrine_Relation_Association) { $identifier = $this->_table->getIdentifier(); $asf = $rel->getAssociationFactory(); $name = $table->getComponentName(); foreach ($this->data as $key => $record) { if ( ! $record->exists()) { continue; } $sub = Doctrine_Collection::create($table); foreach ($coll as $k => $related) { if ($related->get($local) == $record[$identifier]) { $sub->add($related->get($name)); } } $this->data[$key]->setRelated($name, $sub); } } } public function getNormalIterator() { return new Doctrine_Collection_Iterator_Normal($this); } public function takeSnapshot() { $this->_snapshot = $this->data; return $this; } public function getSnapshot() { return $this->_snapshot; } public function processDiff() { foreach (array_udiff($this->_snapshot, $this->data, array($this, "compareRecords")) as $record) { $record->delete(); } return $this; } public function toArray($deep = true, $prefixKey = false) { $data = array(); foreach ($this as $key => $record) { $key = $prefixKey ? get_class($record) . '_' .$key:$key; $data[$key] = $record->toArray($deep, $prefixKey); } return $data; } public function toKeyValueArray($key, $value) { $result = array(); foreach ($this as $record) { $result[$record->$key] = $record->$value; } return $result; } public function toHierarchy() { $collection = $this; $table = $collection->getTable(); if ( ! $table->isTree() || ! $table->hasColumn('level')) { throw new Doctrine_Exception('Cannot hydrate model that does not implements Tree behavior with `level` column'); } $trees = new Doctrine_Collection($table); $l = 0; if (count($collection) > 0) { $stack = new Doctrine_Collection($table); foreach ($collection as $child) { $item = $child; $item->mapValue('__children', new Doctrine_Collection($table)); $l = count($stack); while($l > 0 && $stack[$l - 1]['level'] >= $item['level']) { array_pop($stack->data); $l--; } if ($l == 0) { $i = count($trees); $trees[$i] = $item; $stack[] = $trees[$i]; } else { $i = count($stack[$l - 1]['__children']); $stack[$l - 1]['__children'][$i] = $item; $stack[] = $stack[$l - 1]['__children'][$i]; } } } return $trees; } public function fromArray($array, $deep = true) { $data = array(); foreach ($array as $rowKey => $row) { $this[$rowKey]->fromArray($row, $deep); } } public function synchronizeWithArray(array $array) { foreach ($this as $key => $record) { if (isset($array[$key])) { $record->synchronizeWithArray($array[$key]); unset($array[$key]); } else { $this->remove($key); } } foreach ($array as $rowKey => $row) { $this[$rowKey]->fromArray($row); } } public function synchronizeFromArray(array $array) { return $this->synchronizeWithArray($array); } public function exportTo($type, $deep = true) { if ($type == 'array') { return $this->toArray($deep); } else { return Doctrine_Parser::dump($this->toArray($deep, true), $type); } } public function importFrom($type, $data) { if ($type == 'array') { return $this->fromArray($data); } else { return $this->fromArray(Doctrine_Parser::load($data, $type)); } } public function getDeleteDiff() { return array_udiff($this->_snapshot, $this->data, array($this, 'compareRecords')); } public function getInsertDiff() { return array_udiff($this->data, $this->_snapshot, array($this, "compareRecords")); } protected function compareRecords($a, $b) { if ($a->getOid() == $b->getOid()) { return 0; } return ($a->getOid() > $b->getOid()) ? 1 : -1; } public function save(Doctrine_Connection $conn = null, $processDiff = true) { if ($conn == null) { $conn = $this->_table->getConnection(); } try { $conn->beginInternalTransaction(); $conn->transaction->addCollection($this); if ($processDiff) { $this->processDiff(); } foreach ($this->getData() as $key => $record) { $record->save($conn); } $conn->commit(); } catch (Exception $e) { $conn->rollback(); throw $e; } return $this; } public function replace(Doctrine_Connection $conn = null, $processDiff = true) { if ($conn == null) { $conn = $this->_table->getConnection(); } try { $conn->beginInternalTransaction(); $conn->transaction->addCollection($this); if ($processDiff) { $this->processDiff(); } foreach ($this->getData() as $key => $record) { $record->replace($conn); } $conn->commit(); } catch (Exception $e) { $conn->rollback(); throw $e; } return $this; } public function delete(Doctrine_Connection $conn = null, $clearColl = true) { if ($conn == null) { $conn = $this->_table->getConnection(); } try { $conn->beginInternalTransaction(); $conn->transaction->addCollection($this); foreach ($this as $key => $record) { $record->delete($conn); } $conn->commit(); } catch (Exception $e) { $conn->rollback(); throw $e; } if ($clearColl) { $this->clear(); } return $this; } public function clear() { $this->data = array(); } public function free($deep = false) { foreach ($this->getData() as $key => $record) { if ( ! ($record instanceof Doctrine_Null)) { $record->free($deep); } } $this->data = array(); if ($this->reference) { $this->reference->free($deep); $this->reference = null; } } public function getIterator() { $data = $this->data; return new ArrayIterator($data); } public function __toString() { return Doctrine_Lib::getCollectionAsString($this); } public function getRelation() { return $this->relation; } final public function isModified() { $dirty = (count($this->getInsertDiff()) > 0 || count($this->getDeleteDiff()) > 0); if ( ! $dirty) { foreach($this as $record) { if ($dirty = $record->isModified()) { break; } } } return $dirty; } }abstract class Doctrine_Record_Abstract extends Doctrine_Access { protected $_table; public function setTableDefinition() { } public function setUp() { } public function getTable() { return $this->_table; } public function addListener($listener, $name = null) { $this->_table->addRecordListener($listener, $name); return $this; } public function getListener() { return $this->_table->getRecordListener(); } public function setListener($listener) { $this->_table->setRecordListener($listener); return $this; } public function index($name, array $definition = array()) { if ( ! $definition) { return $this->_table->getIndex($name); } else { return $this->_table->addIndex($name, $definition); } } public function unique($fields, $options = array(), $createUniqueIndex = true) { return $this->_table->unique($fields, $options, $createUniqueIndex); } public function setAttribute($attr, $value) { $this->_table->setAttribute($attr, $value); } public function setTableName($tableName) { $this->_table->setTableName($tableName); } public function setInheritanceMap($map) { $this->_table->setOption('inheritanceMap', $map); } public function setSubclasses($map) { $class = get_class($this); if (isset($map[$class])) { $mapFieldNames = $map[$class]; $mapColumnNames = array(); foreach ($mapFieldNames as $fieldName => $val) { $mapColumnNames[$this->getTable()->getColumnName($fieldName)] = $val; } $this->_table->setOption('inheritanceMap', $mapColumnNames); return; } else { $mapFieldName = array_keys(end($map)); $this->index($this->getTable()->getTableName().'_'.$mapFieldName[0], array('fields' => array($mapFieldName[0]))); } $this->_table->setOption('subclasses', array_keys($map)); } public function attribute($attr, $value) { if ($value == null) { if (is_array($attr)) { foreach ($attr as $k => $v) { $this->_table->setAttribute($k, $v); } } else { return $this->_table->getAttribute($attr); } } else { $this->_table->setAttribute($attr, $value); } } public function option($name, $value = null) { if ($value === null) { if (is_array($name)) { foreach ($name as $k => $v) { $this->_table->setOption($k, $v); } } else { return $this->_table->getOption($name); } } else { $this->_table->setOption($name, $value); } } public function hasOne() { $this->_table->bind(func_get_args(), Doctrine_Relation::ONE); return $this; } public function hasMany() { $this->_table->bind(func_get_args(), Doctrine_Relation::MANY); return $this; } public function hasColumn($name, $type = null, $length = null, $options = array()) { $this->_table->setColumn($name, $type, $length, $options); } public function hasColumns(array $definitions) { foreach ($definitions as $name => $options) { $length = isset($options['length']) ? $options['length']:null; $this->hasColumn($name, $options['type'], $length, $options); } } public function setColumnOptions($name, array $options) { $this->_table->setColumnOptions($name, $options); } public function setColumnOption($columnName, $option, $value) { $this->_table->setColumnOption($columnName, $option, $value); } public function bindQueryParts(array $queryParts) { $this->_table->bindQueryParts($queryParts); return $this; } public function loadGenerator(Doctrine_Record_Generator $generator) { $generator->initialize($this->_table); $this->_table->addGenerator($generator, get_class($generator)); } public function actAs($tpl, array $options = array()) { if ( ! is_object($tpl)) { $className = 'Doctrine_Template_' . $tpl; if (class_exists($className, true)) { $tpl = new $className($options); } else if (class_exists($tpl, true)) { $tpl = new $tpl($options); } else { throw new Doctrine_Record_Exception('Could not load behavior named: "' . $tpl . '"'); } } if ( ! ($tpl instanceof Doctrine_Template)) { throw new Doctrine_Record_Exception('Loaded behavior class is not an instance of Doctrine_Template.'); } $className = get_class($tpl); $this->_table->addTemplate($className, $tpl); $tpl->setInvoker($this); $tpl->setTable($this->_table); $tpl->setUp(); $tpl->setTableDefinition(); return $this; } public function check($constraint, $name = null) { if (is_array($constraint)) { foreach ($constraint as $name => $def) { $this->_table->addCheckConstraint($def, $name); } } else { $this->_table->addCheckConstraint($constraint, $name); } return $this; } } abstract class Doctrine_Record extends Doctrine_Record_Abstract implements Countable, IteratorAggregate, Serializable { const STATE_DIRTY = 1; const STATE_TDIRTY = 2; const STATE_CLEAN = 3; const STATE_PROXY = 4; const STATE_TCLEAN = 5; const STATE_LOCKED = 6; const STATE_TLOCKED = 7; protected $_node; protected $_id = array(); protected $_data = array(); protected $_values = array(); protected $_state; protected $_lastModified = array(); protected $_modified = array(); protected $_oldValues = array(); protected $_errorStack; protected $_references = array(); protected $_pendingDeletes = array(); protected $_pendingUnlinks = array(); protected static $_customAccessors = array(); protected static $_customMutators = array(); protected $_serializeReferences = false; protected $_invokedSaveHooks = false; private static $_index = 1; private $_oid; public function __construct($table = null, $isNewEntry = false) { if (isset($table) && $table instanceof Doctrine_Table) { $this->_table = $table; $exists = ( ! $isNewEntry); } else { $class = get_class($this); $this->_table = Doctrine_Core::getTable($class); $exists = false; } if ( ! $this->_table->getConnection()->hasTable($this->_table->getComponentName())) { return; } $this->_oid = self::$_index; self::$_index++; $this->_data = $this->_table->getData(); $count = count($this->_data); $this->_values = $this->cleanData($this->_data); $this->prepareIdentifiers($exists); if ( ! $exists) { if ($count > count($this->_values)) { $this->_state = Doctrine_Record::STATE_TDIRTY; } else { $this->_state = Doctrine_Record::STATE_TCLEAN; } $this->assignDefaultValues(); } else { $this->_state = Doctrine_Record::STATE_CLEAN; if ($this->isInProxyState()) { $this->_state = Doctrine_Record::STATE_PROXY; } } $repository = $this->_table->getRepository(); if ($repository) { $repository->add($this); $this->construct(); } } public function serializeReferences($bool = null) { if ( ! is_null($bool)) { $this->_serializeReferences = $bool; } return $this->_serializeReferences; } public static function _index() { return self::$_index; } public function setUp() { } public function construct() { } public function getOid() { return $this->_oid; } public function oid() { return $this->_oid; } public function invokeSaveHooks($when, $type, $event = null) { $func = $when . ucfirst($type); if (is_null($event)) { $constant = constant('Doctrine_Event::RECORD_' . strtoupper($type)); $event = new Doctrine_Event($this, $constant); } if ( ! isset($this->_invokedSaveHooks[$func])) { $this->$func($event); $this->getTable()->getRecordListener()->$func($event); $this->_invokedSaveHooks[$func] = $event; } else { $event = $this->_invokedSaveHooks[$func]; } return $event; } public function clearInvokedSaveHooks() { $this->_invokedSaveHooks = array(); } public function isValid($deep = false, $hooks = true) { if ( ! $this->_table->getAttribute(Doctrine_Core::ATTR_VALIDATE)) { return true; } if ($this->_state == self::STATE_LOCKED || $this->_state == self::STATE_TLOCKED) { return true; } if ($hooks) { $this->invokeSaveHooks('pre', 'save'); $this->invokeSaveHooks('pre', $this->exists() ? 'update' : 'insert'); } $this->getErrorStack()->clear(); $event = new Doctrine_Event($this, Doctrine_Event::RECORD_VALIDATE); $this->preValidate($event); $this->getTable()->getRecordListener()->preValidate($event); if ( ! $event->skipOperation) { $validator = new Doctrine_Validator(); $validator->validateRecord($this); $this->validate(); if ($this->_state == self::STATE_TDIRTY || $this->_state == self::STATE_TCLEAN) { $this->validateOnInsert(); } else { $this->validateOnUpdate(); } } $this->getTable()->getRecordListener()->postValidate($event); $this->postValidate($event); $valid = $this->getErrorStack()->count() == 0 ? true : false; if ($valid && $deep) { $stateBeforeLock = $this->_state; $this->_state = $this->exists() ? self::STATE_LOCKED : self::STATE_TLOCKED; foreach ($this->_references as $reference) { if ($reference instanceof Doctrine_Record) { if ( ! $valid = $reference->isValid($deep)) { break; } } else if ($reference instanceof Doctrine_Collection) { foreach ($reference as $record) { if ( ! $valid = $record->isValid($deep)) { break; } } } } $this->_state = $stateBeforeLock; } return $valid; } protected function validate() { } protected function validateOnUpdate() { } protected function validateOnInsert() { } public function preSerialize($event) { } public function postSerialize($event) { } public function preUnserialize($event) { } public function postUnserialize($event) { } public function preSave($event) { } public function postSave($event) { } public function preDelete($event) { } public function postDelete($event) { } public function preUpdate($event) { } public function postUpdate($event) { } public function preInsert($event) { } public function postInsert($event) { } public function preValidate($event) { } public function postValidate($event) { } public function preDqlSelect($event) { } public function preDqlUpdate($event) { } public function preDqlDelete($event) { } public function preHydrate($event) { } public function postHydrate($event) { } public function getErrorStackAsString() { $errorStack = $this->getErrorStack(); if (count($errorStack)) { $message = sprintf("Validation failed in class %s\n\n", get_class($this)); $message .= "  " . count($errorStack) . " field" . (count($errorStack) > 1 ? 's' : null) . " had validation error" . (count($errorStack) > 1 ? 's' : null) . ":\n\n"; foreach ($errorStack as $field => $errors) { $message .= "    * " . count($errors) . " validator" . (count($errors) > 1 ? 's' : null) . " failed on $field (" . implode(", ", $errors) . ")\n"; } return $message; } else { return false; } } public function getErrorStack() { if ( ! $this->_errorStack) { $this->_errorStack = new Doctrine_Validator_ErrorStack(get_class($this)); } return $this->_errorStack; } public function errorStack($stack = null) { if ($stack !== null) { if ( ! ($stack instanceof Doctrine_Validator_ErrorStack)) { throw new Doctrine_Record_Exception('Argument should be an instance of Doctrine_Validator_ErrorStack.'); } $this->_errorStack = $stack; } else { return $this->getErrorStack(); } } public function assignInheritanceValues() { $map = $this->_table->inheritanceMap; foreach ($map as $k => $v) { $k = $this->_table->getFieldName($k); $old = $this->get($k, false); if (((string) $old !== (string) $v || $old === null) && !in_array($k, $this->_modified)) { $this->set($k, $v); } } } public function assignDefaultValues($overwrite = false) { if ( ! $this->_table->hasDefaultValues()) { return false; } foreach ($this->_data as $column => $value) { $default = $this->_table->getDefaultValueOf($column); if ($default === null) { continue; } if ($value === self::$_null || $overwrite) { $this->_data[$column] = $default; $this->_modified[] = $column; $this->_state = Doctrine_Record::STATE_TDIRTY; } } } public function cleanData(&$data) { $tmp = $data; $data = array(); foreach ($this->getTable()->getFieldNames() as $fieldName) { if (isset($tmp[$fieldName])) { $data[$fieldName] = $tmp[$fieldName]; } else if (array_key_exists($fieldName, $tmp)) { $data[$fieldName] = null; } else if ( !isset($this->_data[$fieldName])) { $data[$fieldName] = self::$_null; } unset($tmp[$fieldName]); } return $tmp; } public function hydrate(array $data, $overwriteLocalChanges = true) { if ($overwriteLocalChanges) { $this->_values = array_merge($this->_values, $this->cleanData($data)); $this->_data = array_merge($this->_data, $data); $this->_modified = array(); $this->_oldValues = array(); } else { $this->_values = array_merge($this->cleanData($data), $this->_values); $this->_data = array_merge($data, $this->_data); } if (!$this->isModified() && $this->isInProxyState()) { $this->_state = self::STATE_PROXY; } } private function prepareIdentifiers($exists = true) { switch ($this->_table->getIdentifierType()) { case Doctrine_Core::IDENTIFIER_AUTOINC: case Doctrine_Core::IDENTIFIER_SEQUENCE: case Doctrine_Core::IDENTIFIER_NATURAL: $name = $this->_table->getIdentifier(); if (is_array($name)) { $name = $name[0]; } if ($exists) { if (isset($this->_data[$name]) && $this->_data[$name] !== self::$_null) { $this->_id[$name] = $this->_data[$name]; } } break; case Doctrine_Core::IDENTIFIER_COMPOSITE: $names = $this->_table->getIdentifier(); foreach ($names as $name) { if ($this->_data[$name] === self::$_null) { $this->_id[$name] = null; } else { $this->_id[$name] = $this->_data[$name]; } } break; } } public function serialize() { $event = new Doctrine_Event($this, Doctrine_Event::RECORD_SERIALIZE); $this->preSerialize($event); $this->getTable()->getRecordListener()->preSerialize($event); $vars = get_object_vars($this); if ( ! $this->serializeReferences()) { unset($vars['_references']); } unset($vars['_table']); unset($vars['_errorStack']); unset($vars['_filter']); unset($vars['_node']); $data = $this->_data; if ($this->exists()) { $data = array_merge($data, $this->_id); } foreach ($data as $k => $v) { if ($v instanceof Doctrine_Record && $this->_table->getTypeOf($k) != 'object') { unset($vars['_data'][$k]); } elseif ($v === self::$_null) { unset($vars['_data'][$k]); } else { switch ($this->_table->getTypeOf($k)) { case 'array': case 'object': $vars['_data'][$k] = serialize($vars['_data'][$k]); break; case 'gzip': $vars['_data'][$k] = gzcompress($vars['_data'][$k]); break; case 'enum': $vars['_data'][$k] = $this->_table->enumIndex($k, $vars['_data'][$k]); break; } } } $str = serialize($vars); $this->postSerialize($event); $this->getTable()->getRecordListener()->postSerialize($event); return $str; } public function unserialize($serialized) { $event = new Doctrine_Event($this, Doctrine_Event::RECORD_UNSERIALIZE); $manager = Doctrine_Manager::getInstance(); $connection = $manager->getConnectionForComponent(get_class($this)); $this->_table = $connection->getTable(get_class($this)); $this->preUnserialize($event); $this->getTable()->getRecordListener()->preUnserialize($event); $array = unserialize($serialized); foreach($array as $k => $v) { $this->$k = $v; } foreach ($this->_data as $k => $v) { switch ($this->_table->getTypeOf($k)) { case 'array': case 'object': $this->_data[$k] = unserialize($this->_data[$k]); break; case 'gzip': $this->_data[$k] = gzuncompress($this->_data[$k]); break; case 'enum': $this->_data[$k] = $this->_table->enumValue($k, $this->_data[$k]); break; } } $this->_table->setData($this->_data); $existing_record = $this->_table->getRecord(); if ($existing_record->exists()) { $this->_table->getRepository()->evict($existing_record->getOid()); $this->_table->removeRecord($existing_record); } $this->_oid = self::$_index; self::$_index++; $this->_table->getRepository()->add($this); $this->_table->addRecord($this); $this->cleanData($this->_data); $this->prepareIdentifiers($this->exists()); $this->postUnserialize($event); $this->getTable()->getRecordListener()->postUnserialize($event); } public function state($state = null) { if ($state == null) { return $this->_state; } $err = false; if (is_integer($state)) { if ($state >= 1 && $state <= 7) { $this->_state = $state; } else { $err = true; } } else if (is_string($state)) { $upper = strtoupper($state); $const = 'Doctrine_Record::STATE_' . $upper; if (defined($const)) { $this->_state = constant($const); } else { $err = true; } } if ($this->_state === Doctrine_Record::STATE_TCLEAN || $this->_state === Doctrine_Record::STATE_CLEAN) { $this->_resetModified(); } if ($err) { throw new Doctrine_Record_State_Exception('Unknown record state ' . $state); } } public function refresh($deep = false) { $id = $this->identifier(); if ( ! is_array($id)) { $id = array($id); } if (empty($id)) { return false; } $id = array_values($id); $overwrite = $this->getTable()->getAttribute(Doctrine_Core::ATTR_HYDRATE_OVERWRITE); $this->getTable()->setAttribute(Doctrine_Core::ATTR_HYDRATE_OVERWRITE, true); if ($deep) { $query = $this->getTable()->createQuery(); foreach (array_keys($this->_references) as $name) { $query->leftJoin(get_class($this) . '.' . $name); } $query->where(implode(' = ? AND ', (array)$this->getTable()->getIdentifier()) . ' = ?'); $this->clearRelated(); $record = $query->fetchOne($id); } else { $record = $this->getTable()->find($id, Doctrine_Core::HYDRATE_ARRAY); if ($record) { $this->hydrate($record); } } $this->getTable()->setAttribute(Doctrine_Core::ATTR_HYDRATE_OVERWRITE, $overwrite); if ($record === false) { throw new Doctrine_Record_Exception('Failed to refresh. Record does not exist.'); } $this->_resetModified(); $this->prepareIdentifiers(); $this->_state = Doctrine_Record::STATE_CLEAN; return $this; } public function refreshRelated($name = null) { if (is_null($name)) { foreach ($this->_table->getRelations() as $rel) { $alias = $rel->getAlias(); unset($this->_references[$alias]); $reference = $rel->fetchRelatedFor($this); if ($reference instanceof Doctrine_Collection) { $this->_references[$alias] = $reference; } else if ($reference instanceof Doctrine_Record) { if ($reference->exists()) { $this->_references[$alias] = $reference; } else { $reference->free(); } } } } else { unset($this->_references[$name]); $rel = $this->_table->getRelation($name); $reference = $rel->fetchRelatedFor($this); if ($reference instanceof Doctrine_Collection) { $this->_references[$name] = $reference; } else if ($reference instanceof Doctrine_Record) { if ($reference->exists()) { $this->_references[$name] = $reference; } else { $reference->free(); } } } } public function clearRelated($name = null) { if (is_null($name)) { $this->_references = array(); } else { unset($this->_references[$name]); } } public function relatedExists($name) { if ($this->hasReference($name) && $this->_references[$name] !== self::$_null) { return true; } $reference = $this->$name; if ($reference instanceof Doctrine_Record) { $exists = $reference->exists(); } elseif ($reference instanceof Doctrine_Collection) { throw new Doctrine_Record_Exception( 'You can only call relatedExists() on a relationship that '. 'returns an instance of Doctrine_Record' ); } else { $exists = false; } if (!$exists) { $this->clearRelated($name); } return $exists; } public function getTable() { return $this->_table; } public function getData() { return $this->_data; } public function rawGet($fieldName) { if ( ! array_key_exists($fieldName, $this->_data)) { throw new Doctrine_Record_Exception('Unknown property '. $fieldName); } if ($this->_data[$fieldName] === self::$_null) { return null; } return $this->_data[$fieldName]; } public function load(array $data = array()) { if ($this->exists() && $this->isInProxyState()) { $id = $this->identifier(); if ( ! is_array($id)) { $id = array($id); } if (empty($id)) { return false; } $table = $this->getTable(); $data = empty($data) ? $table->find($id, Doctrine_Core::HYDRATE_ARRAY) : $data; if (is_array($data)) { foreach ($data as $field => $value) { if ($table->hasField($field) && ( ! array_key_exists($field, $this->_data) || $this->_data[$field] === self::$_null)) { $this->_data[$field] = $value; } } } if ($this->isModified()) { $this->_state = Doctrine_Record::STATE_DIRTY; } else if (!$this->isInProxyState()) { $this->_state = Doctrine_Record::STATE_CLEAN; } return true; } return false; } public function isInProxyState() { $count = 0; foreach ($this->_data as $value) { if ($value !== self::$_null) { $count++; } } if ($count < $this->_table->getColumnCount()) { return true; } return false; } public function hasAccessor($fieldName, $accessor = null) { $componentName = $this->_table->getComponentName(); if ($accessor) { self::$_customAccessors[$componentName][$fieldName] = $accessor; } else { return (isset(self::$_customAccessors[$componentName][$fieldName]) && self::$_customAccessors[$componentName][$fieldName]); } } public function clearAccessor($fieldName) { $componentName = $this->_table->getComponentName(); unset(self::$_customAccessors[$componentName][$fieldName]); } public function getAccessor($fieldName) { if ($this->hasAccessor($fieldName)) { $componentName = $this->_table->getComponentName(); return self::$_customAccessors[$componentName][$fieldName]; } } public function getAccessors() { $componentName = $this->_table->getComponentName(); return isset(self::$_customAccessors[$componentName]) ? self::$_customAccessors[$componentName] : array(); } public function hasMutator($fieldName, $mutator = null) { $componentName = $this->_table->getComponentName(); if ($mutator) { self::$_customMutators[$componentName][$fieldName] = $mutator; } else { return (isset(self::$_customMutators[$componentName][$fieldName]) && self::$_customMutators[$componentName][$fieldName]); } } public function getMutator($fieldName) { if ($this->hasMutator($fieldName)) { $componentName = $this->_table->getComponentName(); return self::$_customMutators[$componentName][$fieldName]; } } public function clearMutator($fieldName) { $componentName = $this->_table->getComponentName(); unset(self::$_customMutators[$componentName][$fieldName]); } public function getMutators() { $componentName = $this->_table->getComponentName(); return self::$_customMutators[$componentName]; } public function hasAccessorMutator($fieldName, $accessor, $mutator) { $this->hasAccessor($fieldName, $accessor); $this->hasMutator($fieldName, $mutator); } public function get($fieldName, $load = true) { if ($this->_table->getAttribute(Doctrine_Core::ATTR_AUTO_ACCESSOR_OVERRIDE) || $this->hasAccessor($fieldName)) { $componentName = $this->_table->getComponentName(); $accessor = $this->hasAccessor($fieldName) ? $this->getAccessor($fieldName) : 'get' . Doctrine_Inflector::classify($fieldName); if ($this->hasAccessor($fieldName) || method_exists($this, $accessor)) { $this->hasAccessor($fieldName, $accessor); return $this->$accessor($load, $fieldName); } } return $this->_get($fieldName, $load); } protected function _get($fieldName, $load = true) { $value = self::$_null; if (array_key_exists($fieldName, $this->_values)) { return $this->_values[$fieldName]; } if (array_key_exists($fieldName, $this->_data)) { if ($this->_data[$fieldName] === self::$_null && $load) { $this->load(); } if ($this->_data[$fieldName] === self::$_null) { $value = null; } else { $value = $this->_data[$fieldName]; } return $value; } try { if ( ! isset($this->_references[$fieldName])) { if ($load) { $rel = $this->_table->getRelation($fieldName); $this->_references[$fieldName] = $rel->fetchRelatedFor($this); } else { $this->_references[$fieldName] = null; } } if ($this->_references[$fieldName] === self::$_null) { return null; } return $this->_references[$fieldName]; } catch (Doctrine_Table_Exception $e) { $success = false; foreach ($this->_table->getFilters() as $filter) { try { $value = $filter->filterGet($this, $fieldName); $success = true; } catch (Doctrine_Exception $e) {} } if ($success) { return $value; } else { throw $e; } } } public function mapValue($name, $value = null) { $this->_values[$name] = $value; } public function hasMappedValue($name) { return array_key_exists($name, $this->_values); } public function set($fieldName, $value, $load = true) { if ($this->_table->getAttribute(Doctrine_Core::ATTR_AUTO_ACCESSOR_OVERRIDE) || $this->hasMutator($fieldName)) { $componentName = $this->_table->getComponentName(); $mutator = $this->hasMutator($fieldName) ? $this->getMutator($fieldName): 'set' . Doctrine_Inflector::classify($fieldName); if ($this->hasMutator($fieldName) || method_exists($this, $mutator)) { $this->hasMutator($fieldName, $mutator); return $this->$mutator($value, $load, $fieldName); } } return $this->_set($fieldName, $value, $load); } protected function _set($fieldName, $value, $load = true) { if (array_key_exists($fieldName, $this->_values)) { $this->_values[$fieldName] = $value; } else if (array_key_exists($fieldName, $this->_data)) { $type = $this->_table->getTypeOf($fieldName); if ($value instanceof Doctrine_Record) { $id = $value->getIncremented(); if ($id !== null && $type !== 'object') { $value = $id; } } if ($load) { $old = $this->get($fieldName, $load); } else { $old = $this->_data[$fieldName]; } if ($this->_isValueModified($type, $old, $value)) { if ($value === null) { $value = $this->_table->getDefaultValueOf($fieldName); } $this->_data[$fieldName] = $value; $this->_modified[] = $fieldName; $this->_oldValues[$fieldName] = $old; switch ($this->_state) { case Doctrine_Record::STATE_CLEAN: case Doctrine_Record::STATE_PROXY: $this->_state = Doctrine_Record::STATE_DIRTY; break; case Doctrine_Record::STATE_TCLEAN: $this->_state = Doctrine_Record::STATE_TDIRTY; break; } } } else { try { $this->coreSetRelated($fieldName, $value); } catch (Doctrine_Table_Exception $e) { $success = false; foreach ($this->_table->getFilters() as $filter) { try { $value = $filter->filterSet($this, $fieldName, $value); $success = true; } catch (Doctrine_Exception $e) {} } if ($success) { return $value; } else { throw $e; } } } return $this; } protected function _isValueModified($type, $old, $new) { if ($new instanceof Doctrine_Expression) { return true; } if ($type == 'boolean' && (is_bool($old) || is_numeric($old)) && (is_bool($new) || is_numeric($new)) && $old == $new) { return false; } else if (in_array($type, array('decimal', 'float')) && is_numeric($old) && is_numeric($new)) { return $old * 100 != $new * 100; } else if (in_array($type, array('integer', 'int')) && is_numeric($old) && is_numeric($new)) { return $old != $new; } else if ($type == 'timestamp' || $type == 'date') { $oldStrToTime = strtotime($old); $newStrToTime = strtotime($new); if ($oldStrToTime && $newStrToTime) { return $oldStrToTime !== $newStrToTime; } else { return $old !== $new; } } else { return $old !== $new; } } public function coreSetRelated($name, $value) { $rel = $this->_table->getRelation($name); if ($value === null) { $value = self::$_null; } if ($rel instanceof Doctrine_Relation_ForeignKey || $rel instanceof Doctrine_Relation_LocalKey) { if ( ! $rel->isOneToOne()) { if ( ! ($value instanceof Doctrine_Collection)) { throw new Doctrine_Record_Exception("Couldn't call Doctrine_Core::set(), second argument should be an instance of Doctrine_Collection when setting one-to-many references."); } if (isset($this->_references[$name])) { $this->_references[$name]->setData($value->getData()); return $this; } } else { $localFieldName = $this->_table->getFieldName($rel->getLocal()); if ($value !== self::$_null) { $relatedTable = $rel->getTable(); $foreignFieldName = $relatedTable->getFieldName($rel->getForeign()); } if ( ! ($value instanceof Doctrine_Record) && ! ($value instanceof Doctrine_Null)) { throw new Doctrine_Record_Exception("Couldn't call Doctrine_Core::set(), second argument should be an instance of Doctrine_Record or Doctrine_Null when setting one-to-one references."); } if ($rel instanceof Doctrine_Relation_LocalKey) { if ($value !== self::$_null && ! empty($foreignFieldName) && $foreignFieldName != $value->getTable()->getIdentifier()) { $this->set($localFieldName, $value->rawGet($foreignFieldName), false); } else { $this->set($localFieldName, $value, false); } } elseif ($value !== self::$_null) { $value->set($foreignFieldName, $this, false); } } } else if ($rel instanceof Doctrine_Relation_Association) { if ( ! ($value instanceof Doctrine_Collection)) { throw new Doctrine_Record_Exception("Couldn't call Doctrine_Core::set(), second argument should be an instance of Doctrine_Collection when setting many-to-many references."); } } $this->_references[$name] = $value; } public function contains($fieldName) { if (array_key_exists($fieldName, $this->_data)) { return true; } if (isset($this->_id[$fieldName])) { return true; } if (isset($this->_values[$fieldName])) { return true; } if (isset($this->_references[$fieldName]) && $this->_references[$fieldName] !== self::$_null) { return true; } return false; } public function __unset($name) { if (array_key_exists($name, $this->_data)) { $this->_data[$name] = array(); } else if (isset($this->_references[$name])) { if ($this->_references[$name] instanceof Doctrine_Record) { $this->_pendingDeletes[] = $this->$name; $this->_references[$name] = self::$_null; } elseif ($this->_references[$name] instanceof Doctrine_Collection) { $this->_pendingDeletes[] = $this->$name; $this->_references[$name]->setData(array()); } } } public function getPendingDeletes() { return $this->_pendingDeletes; } public function getPendingUnlinks() { return $this->_pendingUnlinks; } public function resetPendingUnlinks() { $this->_pendingUnlinks = array(); } public function save(Doctrine_Connection $conn = null) { if ($conn === null) { $conn = $this->_table->getConnection(); } $conn->unitOfWork->saveGraph($this); } public function trySave(Doctrine_Connection $conn = null) { try { $this->save($conn); return true; } catch (Doctrine_Validator_Exception $ignored) { return false; } } public function replace(Doctrine_Connection $conn = null) { if ($conn === null) { $conn = $this->_table->getConnection(); } return $conn->unitOfWork->saveGraph($this, true); } public function getModified($old = false, $last = false) { $a = array(); $modified = $last ? $this->_lastModified:$this->_modified; foreach ($modified as $fieldName) { if ($old) { $a[$fieldName] = isset($this->_oldValues[$fieldName]) ? $this->_oldValues[$fieldName] : $this->getTable()->getDefaultValueOf($fieldName); } else { $a[$fieldName] = $this->_data[$fieldName]; } } return $a; } public function getLastModified($old = false) { return $this->getModified($old, true); } public function getPrepared(array $array = array()) { $a = array(); if (empty($array)) { $modifiedFields = $this->_modified; } foreach ($modifiedFields as $field) { $type = $this->_table->getTypeOf($field); if ($this->_data[$field] === self::$_null) { $a[$field] = null; continue; } switch ($type) { case 'array': case 'object': $a[$field] = serialize($this->_data[$field]); break; case 'gzip': $a[$field] = gzcompress($this->_data[$field],5); break; case 'boolean': $a[$field] = $this->getTable()->getConnection()->convertBooleans($this->_data[$field]); break; case 'set': if (is_array($this->_data[$field])) { $a[$field] = implode(',', $this->_data[$field]); } else { $a[$field] = $this->_data[$field]; } break; default: if ($this->_data[$field] instanceof Doctrine_Record) { $a[$field] = $this->_data[$field]->getIncremented(); if ($a[$field] !== null) { $this->_data[$field] = $a[$field]; } } else { $a[$field] = $this->_data[$field]; } } } return $a; } public function count() { return count($this->_data); } public function columnCount() { return $this->count(); } public function toArray($deep = true, $prefixKey = false) { if ($this->_state == self::STATE_LOCKED || $this->_state == self::STATE_TLOCKED) { return false; } $stateBeforeLock = $this->_state; $this->_state = $this->exists() ? self::STATE_LOCKED : self::STATE_TLOCKED; $a = array(); foreach ($this as $column => $value) { if ($value === self::$_null || is_object($value)) { $value = null; } $columnValue = $this->get($column, false); if ($columnValue instanceof Doctrine_Record) { $a[$column] = $columnValue->getIncremented(); } else { $a[$column] = $columnValue; } } if ($this->_table->getIdentifierType() == Doctrine_Core::IDENTIFIER_AUTOINC) { $i = $this->_table->getIdentifier(); $a[$i] = $this->getIncremented(); } if ($deep) { foreach ($this->_references as $key => $relation) { if ( ! $relation instanceof Doctrine_Null) { $a[$key] = $relation->toArray($deep, $prefixKey); } } } foreach ($this->_values as $key => $value) { $a[$key] = ($value instanceof Doctrine_Record || $value instanceof Doctrine_Collection) ? $value->toArray($deep, $prefixKey) : $value; } $this->_state = $stateBeforeLock; return $a; } public function merge($data, $deep = true) { if ($data instanceof $this) { $array = $data->toArray($deep); } else if (is_array($data)) { $array = $data; } return $this->fromArray($array, $deep); } public function fromArray(array $array, $deep = true) { $refresh = false; foreach ($array as $key => $value) { if ($key == '_identifier') { $refresh = true; $this->assignIdentifier($value); continue; } if ($deep && $this->getTable()->hasRelation($key)) { if ( ! $this->$key) { $this->refreshRelated($key); } if (is_array($value)) { if (isset($value[0]) && ! is_array($value[0])) { $this->unlink($key, array(), false); $this->link($key, $value, false); } else { $this->$key->fromArray($value, $deep); } } } else if ($this->getTable()->hasField($key) || array_key_exists($key, $this->_values)) { $this->set($key, $value); } else { $method = 'set' . Doctrine_Inflector::classify($key); try { if (is_callable(array($this, $method))) { $this->$method($value); } } catch (Doctrine_Record_Exception $e) {} } } if ($refresh) { $this->refresh(); } } public function synchronizeWithArray(array $array, $deep = true) { $refresh = false; foreach ($array as $key => $value) { if ($key == '_identifier') { $refresh = true; $this->assignIdentifier($value); continue; } if ($deep && $this->getTable()->hasRelation($key)) { if ( ! $this->$key) { $this->refreshRelated($key); } if (is_array($value)) { if (isset($value[0]) && ! is_array($value[0])) { $this->unlink($key, array(), false); $this->link($key, $value, false); } else { $this->$key->synchronizeWithArray($value); $this->$key = $this->$key; } } } else if ($this->getTable()->hasField($key) || array_key_exists($key, $this->_values)) { $this->set($key, $value); } } foreach ($this->_references as $name => $relation) { $rel = $this->getTable()->getRelation($name); if ( ! $rel->isRefClass() && ! isset($array[$name]) && ( ! $rel->isOneToOne() || ! isset($array[$rel->getLocalFieldName()]))) { unset($this->$name); } } if ($refresh) { $this->refresh(); } } public function exportTo($type, $deep = true) { if ($type == 'array') { return $this->toArray($deep); } else { return Doctrine_Parser::dump($this->toArray($deep, true), $type); } } public function importFrom($type, $data, $deep = true) { if ($type == 'array') { return $this->fromArray($data, $deep); } else { return $this->fromArray(Doctrine_Parser::load($data, $type), $deep); } } public function exists() { return ($this->_state !== Doctrine_Record::STATE_TCLEAN && $this->_state !== Doctrine_Record::STATE_TDIRTY && $this->_state !== Doctrine_Record::STATE_TLOCKED && $this->_state !== null); } public function isModified($deep = false) { $modified = ($this->_state === Doctrine_Record::STATE_DIRTY || $this->_state === Doctrine_Record::STATE_TDIRTY); if ( ! $modified && $deep) { if ($this->_state == self::STATE_LOCKED || $this->_state == self::STATE_TLOCKED) { return false; } $stateBeforeLock = $this->_state; $this->_state = $this->exists() ? self::STATE_LOCKED : self::STATE_TLOCKED; foreach ($this->_references as $reference) { if ($reference instanceof Doctrine_Record) { if ($modified = $reference->isModified($deep)) { break; } } else if ($reference instanceof Doctrine_Collection) { foreach ($reference as $record) { if ($modified = $record->isModified($deep)) { break 2; } } } } $this->_state = $stateBeforeLock; } return $modified; } public function hasRelation($fieldName) { if (isset($this->_data[$fieldName]) || isset($this->_id[$fieldName])) { return true; } return $this->_table->hasRelation($fieldName); } public function getIterator() { return new Doctrine_Record_Iterator($this); } public function delete(Doctrine_Connection $conn = null) { if ($conn == null) { $conn = $this->_table->getConnection(); } return $conn->unitOfWork->delete($this); } public function copy($deep = false) { $data = $this->_data; $idtype = $this->_table->getIdentifierType(); if ($idtype === Doctrine_Core::IDENTIFIER_AUTOINC || $idtype === Doctrine_Core::IDENTIFIER_SEQUENCE) { $id = $this->_table->getIdentifier(); unset($data[$id]); } $ret = $this->_table->create($data); $modified = array(); foreach ($data as $key => $val) { if ( ! ($val instanceof Doctrine_Null)) { $ret->_modified[] = $key; } } if ($deep) { foreach ($this->_references as $key => $value) { if ($value instanceof Doctrine_Collection) { foreach ($value as $valueKey => $record) { $ret->{$key}[$valueKey] = $record->copy($deep); } } else if ($value instanceof Doctrine_Record) { $ret->set($key, $value->copy($deep)); } } } return $ret; } public function assignIdentifier($id = false) { if ($id === false) { $this->_id = array(); $this->_data = $this->cleanData($this->_data); $this->_state = Doctrine_Record::STATE_TCLEAN; $this->_resetModified(); } elseif ($id === true) { $this->prepareIdentifiers(true); $this->_state = Doctrine_Record::STATE_CLEAN; $this->_resetModified(); } else { if (is_array($id)) { foreach ($id as $fieldName => $value) { $this->_id[$fieldName] = $value; $this->_data[$fieldName] = $value; } } else { $name = $this->_table->getIdentifier(); $this->_id[$name] = $id; $this->_data[$name] = $id; } $this->_state = Doctrine_Record::STATE_CLEAN; $this->_resetModified(); } } public function identifier() { return $this->_id; } final public function getIncremented() { $id = current($this->_id); if ($id === false) { return null; } return $id; } public function getLast() { return $this; } public function hasReference($name) { return isset($this->_references[$name]); } public function reference($name) { if (isset($this->_references[$name])) { return $this->_references[$name]; } } public function obtainReference($name) { if (isset($this->_references[$name])) { return $this->_references[$name]; } throw new Doctrine_Record_Exception("Unknown reference $name"); } public function getReferences() { return $this->_references; } final public function setRelated($alias, Doctrine_Access $coll) { $this->_references[$alias] = $coll; } public function loadReference($name) { $rel = $this->_table->getRelation($name); $this->_references[$name] = $rel->fetchRelatedFor($this); } public function call($callback, $column) { $args = func_get_args(); array_shift($args); if (isset($args[0])) { $fieldName = $args[0]; $args[0] = $this->get($fieldName); $newvalue = call_user_func_array($callback, $args); $this->_data[$fieldName] = $newvalue; } return $this; } public function getNode() { if ( ! $this->_table->isTree()) { return false; } if ( ! isset($this->_node)) { $this->_node = Doctrine_Node::factory($this, $this->getTable()->getOption('treeImpl'), $this->getTable()->getOption('treeOptions') ); } return $this->_node; } public function unshiftFilter(Doctrine_Record_Filter $filter) { return $this->_table->unshiftFilter($filter); } public function unlink($alias, $ids = array(), $now = false) { $ids = (array) $ids; if ( ! isset($this->_references[$alias]) && $this->hasRelation($alias)) { $this->loadReference($alias); } $allIds = array(); if (isset($this->_references[$alias])) { if ($this->_references[$alias] instanceof Doctrine_Record) { $allIds[] = $this->_references[$alias]->identifier(); if (in_array($this->_references[$alias]->identifier(), $ids) || empty($ids)) { unset($this->_references[$alias]); } } else { $allIds = $this->get($alias)->getPrimaryKeys(); foreach ($this->_references[$alias] as $k => $record) { if (in_array(current($record->identifier()), $ids) || empty($ids)) { $this->_references[$alias]->remove($k); } } } } if ( ! $this->exists() || $now === false) { if ( ! $ids) { $ids = $allIds; } foreach ($ids as $id) { $this->_pendingUnlinks[$alias][$id] = true; } return $this; } else { return $this->unlinkInDb($alias, $ids); } } public function unlinkInDb($alias, $ids = array()) { $rel = $this->getTable()->getRelation($alias); if ($rel instanceof Doctrine_Relation_Association) { $q = $rel->getAssociationTable() ->createQuery() ->delete() ->where($rel->getLocal() . ' = ?', array_values($this->identifier())); if (count($ids) > 0) { $q->whereIn($rel->getForeign(), $ids); } $q->execute(); } else if ($rel instanceof Doctrine_Relation_ForeignKey) { $q = $rel->getTable()->createQuery() ->update() ->set($rel->getForeign(), '?', array(null)) ->addWhere($rel->getForeign() . ' = ?', array_values($this->identifier())); if (count($ids) > 0) { $q->whereIn($rel->getTable()->getIdentifier(), $ids); } $q->execute(); } return $this; } public function link($alias, $ids, $now = false) { $ids = (array) $ids; if ( ! count($ids)) { return $this; } if ( ! $this->exists() || $now === false) { $relTable = $this->getTable()->getRelation($alias)->getTable(); $records = $relTable->createQuery() ->whereIn($relTable->getIdentifier(), $ids) ->execute(); foreach ($records as $record) { if ($this->$alias instanceof Doctrine_Record) { $this->set($alias, $record); } else { if ($c = $this->get($alias)) { $c->add($record); } else { $this->set($alias, $record); } } } foreach ($ids as $id) { if (isset($this->_pendingUnlinks[$alias][$id])) { unset($this->_pendingUnlinks[$alias][$id]); } } return $this; } else { return $this->linkInDb($alias, $ids); } } public function linkInDb($alias, $ids) { $identifier = array_values($this->identifier()); $identifier = array_shift($identifier); $rel = $this->getTable()->getRelation($alias); if ($rel instanceof Doctrine_Relation_Association) { $modelClassName = $rel->getAssociationTable()->getComponentName(); $localFieldName = $rel->getLocalFieldName(); $localFieldDef = $rel->getAssociationTable()->getColumnDefinition($localFieldName); if ($localFieldDef['type'] == 'integer') { $identifier = (integer) $identifier; } $foreignFieldName = $rel->getForeignFieldName(); $foreignFieldDef = $rel->getAssociationTable()->getColumnDefinition($foreignFieldName); if ($foreignFieldDef['type'] == 'integer') { foreach ($ids as $i => $id) { $ids[$i] = (integer) $id; } } foreach ($ids as $id) { $record = new $modelClassName; $record[$localFieldName] = $identifier; $record[$foreignFieldName] = $id; $record->save(); } } else if ($rel instanceof Doctrine_Relation_ForeignKey) { $q = $rel->getTable() ->createQuery() ->update() ->set($rel->getForeign(), '?', array_values($this->identifier())); if (count($ids) > 0) { $q->whereIn($rel->getTable()->getIdentifier(), $ids); } $q->execute(); } else if ($rel instanceof Doctrine_Relation_LocalKey) { $q = $this->getTable() ->createQuery() ->update() ->set($rel->getLocalFieldName(), '?', $ids); if (count($ids) > 0) { $q->whereIn($rel->getTable()->getIdentifier(), array_values($this->identifier())); } $q->execute(); } return $this; } protected function _resetModified() { if ( ! empty($this->_modified)) { $this->_lastModified = $this->_modified; $this->_modified = array(); } } public function __call($method, $args) { if (($template = $this->_table->getMethodOwner($method)) !== false) { $template->setInvoker($this); return call_user_func_array(array($template, $method), $args); } foreach ($this->_table->getTemplates() as $template) { if (is_callable(array($template, $method))) { $template->setInvoker($this); $this->_table->setMethodOwner($method, $template); return call_user_func_array(array($template, $method), $args); } } throw new Doctrine_Record_UnknownPropertyException(sprintf('Unknown method %s::%s', get_class($this), $method)); } public function deleteNode() { $this->getNode()->delete(); } public function free($deep = false) { if ($this->_state != self::STATE_LOCKED && $this->_state != self::STATE_TLOCKED) { $this->_state = $this->exists() ? self::STATE_LOCKED : self::STATE_TLOCKED; $this->_table->getRepository()->evict($this->_oid); $this->_table->removeRecord($this); $this->_data = array(); $this->_id = array(); if ($deep) { foreach ($this->_references as $name => $reference) { if ( ! ($reference instanceof Doctrine_Null)) { $reference->free($deep); } } } $this->_references = array(); } } public function toString() { return Doctrine_Core::dump(get_object_vars($this)); } public function __toString() { return (string) $this->_oid; } } class Doctrine_File extends Doctrine_Record { public function setTableDefinition() { $this->hasColumn('url', 'string', 255); } public function setUp() { $this->actAs('Searchable', array('className' => 'Doctrine_File_Index', 'fields' => array('url', 'content'))); $this->index('url', array('fields' => array('url'))); } public function get($name, $load = true) { if ($name === 'content') { return file_get_contents(parent::get('url')); } return parent::get($name, $load); } }abstract class Doctrine_Relation implements ArrayAccess { const ONE = 0; const MANY = 1; protected $definition = array('alias' => true, 'foreign' => true, 'local' => true, 'class' => true, 'type' => true, 'table' => true, 'localTable' => true, 'name' => null, 'refTable' => null, 'onDelete' => null, 'onUpdate' => null, 'deferred' => null, 'deferrable' => null, 'constraint' => null, 'equal' => false, 'cascade' => array(), 'owningSide' => false, 'refClassRelationAlias' => null, 'foreignKeyName' => null, 'orderBy' => null, 'idField' => null, 'foreignId' => null ); protected $_isRefClass = null; public function __construct(array $definition) { $def = array(); foreach ($this->definition as $key => $val) { if ( ! isset($definition[$key]) && $val) { throw new Doctrine_Exception($key . ' is required!'); } if (isset($definition[$key])) { $def[$key] = $definition[$key]; } else { $def[$key] = $this->definition[$key]; } } $this->definition = $def; } public function hasConstraint() { return ($this->definition['constraint'] || ($this->definition['onUpdate']) || ($this->definition['onDelete'])); } public function isDeferred() { return $this->definition['deferred']; } public function isDeferrable() { return $this->definition['deferrable']; } public function isEqual() { return $this->definition['equal']; } public function offsetExists($offset) { return isset($this->definition[$offset]); } public function offsetGet($offset) { if (isset($this->definition[$offset])) { return $this->definition[$offset]; } return null; } public function offsetSet($offset, $value) { if (isset($this->definition[$offset])) { $this->definition[$offset] = $value; } } public function offsetUnset($offset) { $this->definition[$offset] = false; } public function toArray() { return $this->definition; } final public function getAlias() { return $this->definition['alias']; } final public function getType() { return $this->definition['type']; } public function isCascadeDelete() { return in_array('delete', $this->definition['cascade']); } final public function getTable() { return Doctrine_Manager::getInstance() ->getConnectionForComponent($this->definition['class']) ->getTable($this->definition['class']); } final public function getClass() { return $this->definition['class']; } final public function getLocal() { return $this->definition['local']; } final public function getLocalFieldName() { return $this->definition['localTable']->getFieldName($this->definition['local']); } final public function getLocalColumnName() { return $this->definition['localTable']->getColumnName($this->definition['local']); } final public function getForeign() { return $this->definition['foreign']; } final public function getForeignFieldName() { return $this->definition['table']->getFieldName($this->definition['foreign']); } final public function getForeignColumnName() { return $this->definition['table']->getColumnName($this->definition['foreign']); } final public function __getIdField() { return $this->definition["idField"]; } final public function __getForeignId() { return $this->definition["foreignId"]; } final public function isOneToOne() { return ($this->definition['type'] == Doctrine_Relation::ONE); } public function getRelationDql($count) { $component = $this->getTable()->getComponentName(); $dql = 'FROM ' . $component . ' WHERE ' . $component . '.' . $this->definition['foreign'] . ' IN (' . substr(str_repeat('?, ', $count), 0, -2) . ')' . $this->getOrderBy($component); return $dql; } abstract public function fetchRelatedFor(Doctrine_Record $record); public function getForeignKeyName() { if (isset($this->definition['foreignKeyName'])) { return $this->definition['foreignKeyName']; } return $this['localTable']->getConnection()->generateUniqueRelationForeignKeyName($this); } public function getOrderBy($alias = null, $columnNames = false) { if ( ! $alias) { $alias = $this->getTable()->getComponentName(); } if ($orderBy = $this->getOrderByStatement($alias, $columnNames)) { return ' ORDER BY ' . $orderBy; } } public function getOrderByStatement($alias = null, $columnNames = false) { $table = $this->getTable(); if ( ! $alias) { $alias = $table->getComponentName(); } if (isset($this->definition['orderBy'])) { return $table->processOrderBy($alias, $this->definition['orderBy'], $columnNames); } else { return $table->getOrderByStatement($alias, $columnNames); } } public function isRefClass() { if ($this->_isRefClass === null) { $this->_isRefClass = false; $table = $this->getTable(); foreach ($table->getRelations() as $name => $relation) { foreach ($relation['table']->getRelations() as $relation) { if (isset($relation['refTable']) && $relation['refTable'] === $table) { $this->_isRefClass = true; break(2); } } } } return $this->_isRefClass; } public function __toString() { $r[] = "<pre>"; foreach ($this->definition as $k => $v) { if (is_object($v)) { $v = 'Object(' . get_class($v) . ')'; } $r[] = $k . ' : ' . $v; } $r[] = "</pre>"; return implode("\n", $r); } } abstract class Doctrine_Migration_Base { private static $defaultTableOptions = array(); protected $_changes = array(); protected static $_opposites = array('created_table' => 'dropped_table', 'dropped_table' => 'created_table', 'created_constraint' => 'dropped_constraint', 'dropped_constraint' => 'created_constraint', 'created_foreign_key' => 'dropped_foreign_key', 'dropped_foreign_key' => 'created_foreign_key', 'created_column' => 'dropped_column', 'dropped_column' => 'created_column', 'created_index' => 'dropped_index', 'dropped_index' => 'created_index', ); public function getChanges() { return $this->_changes; } public function getNumChanges() { return count($this->_changes); } protected function _addChange($type, array $change = array()) { if (isset($change['upDown']) && $change['upDown'] !== null && isset(self::$_opposites[$type])) { $upDown = $change['upDown']; unset($change['upDown']); if ($upDown == 'down') { $opposite = self::$_opposites[$type]; return $this->_changes[] = array($opposite, $change); } } return $this->_changes[] = array($type, $change); } public static function setDefaultTableOptions(array $options) { self::$defaultTableOptions = $options; } public static function getDefaultTableOptions() { return self::$defaultTableOptions; } public function table($upDown, $tableName, array $fields = array(), array $options = array()) { $options = get_defined_vars(); $this->_addChange('created_table', $options); } public function createTable($tableName, array $fields = array(), array $options = array()) { $this->table('up', $tableName, $fields, array_merge(self::getDefaultTableOptions(), $options)); } public function dropTable($tableName) { $this->table('down', $tableName); } public function renameTable($oldTableName, $newTableName) { $options = get_defined_vars(); $this->_addChange('renamed_table', $options); } public function constraint($upDown, $tableName, $constraintName, array $definition) { $options = get_defined_vars(); $this->_addChange('created_constraint', $options); } public function createConstraint($tableName, $constraintName, array $definition) { $this->constraint('up', $tableName, $constraintName, $definition); } public function dropConstraint($tableName, $constraintName, $primary = false) { $this->constraint('down', $tableName, $constraintName, array('primary' => $primary)); } public function primaryKey($direction, $tableName, $columnNames) { if ($direction == 'up') { $this->createPrimaryKey($tableName, $columnNames); } else { $this->dropPrimaryKey($tableName, $columnNames); } } public function createPrimaryKey($tableName, $columnNames) { $autoincrement = false; $fields = array(); foreach ($columnNames as $columnName => $def) { $type = $def['type']; $length = isset($def['length']) ? $def['length'] : null; $options = isset($def['options']) ? $def['options'] : array(); $this->addColumn($tableName, $columnName, $type, $length, $options); $fields[$columnName] = array(); if (isset($def['autoincrement'])) { $autoincrement = true; $autoincrementColumn = $columnName; $autoincrementType = $type; $autoincrementLength = $length; $autoincrementOptions = $options; $autoincrementOptions['autoincrement'] = true; } } $this->createConstraint($tableName, null, array( 'primary' => true, 'fields' => $fields )); if ($autoincrement) { $this->changeColumn($tableName, $autoincrementColumn, $autoincrementType, $autoincrementLength, $autoincrementOptions); } } public function dropPrimaryKey($tableName, $columnNames) { foreach ((array) $columnNames as $columnName => $def) { if (isset($def['autoincrement'])) { $changeDef = $def; unset($changeDef['autoincrement']); $this->changeColumn($tableName, $columnName, $changeDef['type'], $changeDef['length'], $changeDef); } } $this->dropConstraint($tableName, null, true); foreach (array_keys((array) $columnNames) as $columnName) { $this->removeColumn($tableName, $columnName); } } public function foreignKey($upDown, $tableName, $name, array $definition = array()) { $definition['name'] = $name; $options = get_defined_vars(); $this->_addChange('created_foreign_key', $options); } public function createForeignKey($tableName, $name, array $definition) { $this->foreignKey('up', $tableName, $name, $definition); } public function dropForeignKey($tableName, $name) { $this->foreignKey('down', $tableName, $name); } public function column($upDown, $tableName, $columnName, $type = null, $length = null, array $options = array()) { $options = get_defined_vars(); if ( ! isset($options['options']['length'])) { $options['options']['length'] = $length; } $options = array_merge($options, $options['options']); unset($options['options']); $this->_addChange('created_column', $options); } public function addColumn($tableName, $columnName, $type, $length = null, array $options = array()) { $this->column('up', $tableName, $columnName, $type, $length, $options); } public function removeColumn($tableName, $columnName) { $this->column('down', $tableName, $columnName); } public function renameColumn($tableName, $oldColumnName, $newColumnName) { $options = get_defined_vars(); $this->_addChange('renamed_column', $options); } public function changeColumn($tableName, $columnName, $type = null, $length = null, array $options = array()) { $options = get_defined_vars(); $options['options']['length'] = $length; $this->_addChange('changed_column', $options); } public function index($upDown, $tableName, $indexName, array $definition = array()) { $options = get_defined_vars(); $this->_addChange('created_index', $options); } public function addIndex($tableName, $indexName, array $definition) { $this->index('up', $tableName, $indexName, $definition); } public function removeIndex($tableName, $indexName) { $this->index('down', $tableName, $indexName); } public function preUp() { } public function postUp() { } public function preDown() { } public function postDown() { } }class Doctrine_Builder { public function varExport($var) { $export = var_export($var, true); $export = str_replace("\n", PHP_EOL . str_repeat(' ', 50), $export); $export = str_replace('  ', ' ', $export); $export = str_replace('array (', 'array(', $export); $export = str_replace('array( ', 'array(', $export); $export = str_replace(',)', ')', $export); $export = str_replace(', )', ')', $export); $export = str_replace('  ', ' ', $export); return $export; } }class Doctrine_Migration_Builder extends Doctrine_Builder { private $migrationsPath = ''; private $suffix = '.php'; private $migration; private static $tpl; public function __construct($migrationsPath = null) { if ($migrationsPath instanceof Doctrine_Migration) { $this->setMigrationsPath($migrationsPath->getMigrationClassesDirectory()); $this->migration = $migrationsPath; } else if (is_dir($migrationsPath)) { $this->setMigrationsPath($migrationsPath); $this->migration = new Doctrine_Migration($migrationsPath); } $this->loadTemplate(); } public function setMigrationsPath($path) { Doctrine_Lib::makeDirectories($path); $this->migrationsPath = $path; } public function getMigrationsPath() { return $this->migrationsPath; } protected function loadTemplate() { if (isset(self::$tpl)) { return; } self::$tpl =<<<END
/**
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class %s extends %s
{
    public function up()
    {
%s
    }

    public function down()
    {
%s
    }
}
END;
} public function generateMigrationsFromDiff(Doctrine_Migration_Diff $diff) { $changes = $diff->generateChanges(); $up = array(); $down = array(); if ( ! empty($changes['dropped_tables'])) { foreach ($changes['dropped_tables'] as $tableName => $table) { $up[] = $this->buildDropTable($table); $down[] = $this->buildCreateTable($table); } } if ( ! empty($changes['created_tables'])) { foreach ($changes['created_tables'] as $tableName => $table) { $up[] = $this->buildCreateTable($table); $down[] = $this->buildDropTable($table); } } if ( ! empty($changes['dropped_columns'])) { foreach ($changes['dropped_columns'] as $tableName => $removedColumns) { foreach ($removedColumns as $name => $column) { $up[] = $this->buildRemoveColumn($tableName, $name, $column); $down[] = $this->buildAddColumn($tableName, $name, $column); } } } if ( ! empty($changes['created_columns'])) { foreach ($changes['created_columns'] as $tableName => $addedColumns) { foreach ($addedColumns as $name => $column) { $up[] = $this->buildAddColumn($tableName, $name, $column); $down[] = $this->buildRemoveColumn($tableName, $name, $column); } } } if ( ! empty($changes['changed_columns'])) { foreach ($changes['changed_columns'] as $tableName => $changedColumns) { foreach ($changedColumns as $name => $column) { $up[] = $this->buildChangeColumn($tableName, $name, $column); } } } if ( ! empty($up) || ! empty($down)) { $up = implode("\n", $up); $down = implode("\n", $down); $className = 'Version' . $this->migration->getNextMigrationClassVersion(); $this->generateMigrationClass($className, array(), $up, $down); } $up = array(); $down = array(); if ( ! empty($changes['dropped_foreign_keys'])) { foreach ($changes['dropped_foreign_keys'] as $tableName => $droppedFks) { if ( ! empty($changes['dropped_tables']) && isset($changes['dropped_tables'][$tableName])) { continue; } foreach ($droppedFks as $name => $foreignKey) { $up[] = $this->buildDropForeignKey($tableName, $foreignKey); $down[] = $this->buildCreateForeignKey($tableName, $foreignKey); } } } if ( ! empty($changes['dropped_indexes'])) { foreach ($changes['dropped_indexes'] as $tableName => $removedIndexes) { if ( ! empty($changes['dropped_tables']) && isset($changes['dropped_tables'][$tableName])) { continue; } foreach ($removedIndexes as $name => $index) { $up[] = $this->buildRemoveIndex($tableName, $name, $index); $down[] = $this->buildAddIndex($tableName, $name, $index); } } } if ( ! empty($changes['created_foreign_keys'])) { foreach ($changes['created_foreign_keys'] as $tableName => $createdFks) { if ( ! empty($changes['dropped_tables']) && isset($changes['dropped_tables'][$tableName])) { continue; } foreach ($createdFks as $name => $foreignKey) { $up[] = $this->buildCreateForeignKey($tableName, $foreignKey); $down[] = $this->buildDropForeignKey($tableName, $foreignKey); } } } if ( ! empty($changes['created_indexes'])) { foreach ($changes['created_indexes'] as $tableName => $addedIndexes) { if ( ! empty($changes['dropped_tables']) && isset($changes['dropped_tables'][$tableName])) { continue; } foreach ($addedIndexes as $name => $index) { if (isset($changes['created_tables'][$tableName]['options']['indexes'][$name])) { continue; } $up[] = $this->buildAddIndex($tableName, $name, $index); $down[] = $this->buildRemoveIndex($tableName, $name, $index); } } } if ( ! empty($up) || ! empty($down)) { $up = implode("\n", $up); $down = implode("\n", $down); $className = 'Version' . $this->migration->getNextMigrationClassVersion(); $this->generateMigrationClass($className, array(), $up, $down); } return $changes; } public function generateMigrationsFromDb() { $directory = sys_get_temp_dir() . DIRECTORY_SEPARATOR . 'tmp_doctrine_models'; Doctrine_Core::generateModelsFromDb($directory); $result = $this->generateMigrationsFromModels($directory, Doctrine_Core::MODEL_LOADING_CONSERVATIVE); Doctrine_Lib::removeDirectories($directory); return $result; } public function generateMigrationsFromModels($modelsPath = null, $modelLoading = null) { if ($modelsPath !== null) { $models = Doctrine_Core::filterInvalidModels(Doctrine_Core::loadModels($modelsPath, $modelLoading)); } else { $models = Doctrine_Core::getLoadedModels(); } $models = Doctrine_Core::initializeModels($models); $foreignKeys = array(); foreach ($models as $model) { $table = Doctrine_Core::getTable($model); if ($table->getTableName() !== $this->migration->getTableName()) { $export = $table->getExportableFormat(); $foreignKeys[$export['tableName']] = $export['options']['foreignKeys']; $up = $this->buildCreateTable($export); $down = $this->buildDropTable($export); $className = 'Add' . Doctrine_Inflector::classify($export['tableName']); $this->generateMigrationClass($className, array(), $up, $down); } } if ( ! empty($foreignKeys)) { $className = 'AddFks'; $up = array(); $down = array(); foreach ($foreignKeys as $tableName => $definitions) { $tableForeignKeyNames[$tableName] = array(); foreach ($definitions as $definition) { $up[] = $this->buildCreateForeignKey($tableName, $definition); $down[] = $this->buildDropForeignKey($tableName, $definition); } } $up = implode("\n", $up); $down = implode("\n", $down); if ($up || $down) { $this->generateMigrationClass($className, array(), $up, $down); } } return true; } public function buildCreateForeignKey($tableName, $definition) { return "        \$this->createForeignKey('" . $tableName . "', '" . $definition['name'] . "', " . $this->varExport($definition, true) . ");"; } public function buildDropForeignKey($tableName, $definition) { return "        \$this->dropForeignKey('" . $tableName . "', '" . $definition['name'] . "');"; } public function buildCreateTable($tableData) { $code = "        \$this->createTable('" . $tableData['tableName'] . "', "; $code .= $this->varExport($tableData['columns'], true) . ", "; $optionsWeNeed = array('type', 'indexes', 'primary', 'collate', 'charset'); $options = array(); foreach ($optionsWeNeed as $option) { if (isset($tableData['options'][$option])) { $options[$option] = $tableData['options'][$option]; } } $code .= $this->varExport($options, true); $code .= ");"; return $code; } public function buildDropTable($tableData) { return "        \$this->dropTable('" . $tableData['tableName'] . "');"; } public function buildAddColumn($tableName, $columnName, $column) { $length = $column['length']; $type = $column['type']; unset($column['length'], $column['type']); return "        \$this->addColumn('" . $tableName . "', '" . $columnName. "', '" . $type . "', '" . $length . "', " . $this->varExport($column) . ");"; } public function buildRemoveColumn($tableName, $columnName, $column) { return "        \$this->removeColumn('" . $tableName . "', '" . $columnName. "');"; } public function buildChangeColumn($tableName, $columnName, $column) { $length = $column['length']; $type = $column['type']; unset($column['length'], $column['type']); return "        \$this->changeColumn('" . $tableName . "', '" . $columnName. "', '" . $type . "', '" . $length . "', " . $this->varExport($column) . ");"; } public function buildAddIndex($tableName, $indexName, $index) { return "        \$this->addIndex('$tableName', '$indexName', " . $this->varExport($index) . ");"; } public function buildRemoveIndex($tableName, $indexName, $index) { return "        \$this->removeIndex('$tableName', '$indexName', " . $this->varExport($index) . ");"; } public function generateMigrationClass($className, $options = array(), $up = null, $down = null, $return = false) { $className = Doctrine_Inflector::urlize($className); $className = str_replace('-', '_', $className); $className = Doctrine_Inflector::classify($className); if ($return || ! $this->getMigrationsPath()) { return $this->buildMigrationClass($className, null, $options, $up, $down); } else { if ( ! $this->getMigrationsPath()) { throw new Doctrine_Migration_Exception('You must specify the path to your migrations.'); } $next = time() + $this->migration->getNextMigrationClassVersion(); $fileName = $next . '_' . Doctrine_Inflector::tableize($className) . $this->suffix; $class = $this->buildMigrationClass($className, $fileName, $options, $up, $down); $path = $this->getMigrationsPath() . DIRECTORY_SEPARATOR . $fileName; if (class_exists($className) || file_exists($path)) { $this->migration->loadMigrationClass($className); return false; } file_put_contents($path, $class); require_once($path); $this->migration->loadMigrationClass($className); return true; } } public function buildMigrationClass($className, $fileName = null, $options = array(), $up = null, $down = null) { $extends = isset($options['extends']) ? $options['extends']:'Doctrine_Migration_Base'; $content = '<?php' . PHP_EOL; $content .= sprintf(self::$tpl, $className, $extends, $up, $down); return $content; } }class Doctrine_Migration_Process { protected $_migration; public function __construct(Doctrine_Migration $migration) { $this->_migration = $migration; } public function getConnection() { return $this->_migration->getConnection(); } public function processCreatedTable(array $table) { $this->getConnection()->export->createTable($table['tableName'], $table['fields'], $table['options']); } public function processDroppedTable(array $table) { $this->getConnection()->export->dropTable($table['tableName']); } public function processRenamedTable(array $table) { $this->getConnection()->export->alterTable($table['oldTableName'], array('name' => $table['newTableName'])); } public function processCreatedColumn(array $column) { $this->getConnection()->export->alterTable($column['tableName'], array('add' => array($column['columnName'] => $column))); } public function processDroppedColumn(array $column) { $this->getConnection()->export->alterTable($column['tableName'], array('remove' => array($column['columnName'] => array()))); } public function processRenamedColumn(array $column) { $columnList = $this->getConnection()->import->listTableColumns($column['tableName']); if (isset($columnList[$column['oldColumnName']])) { $this->getConnection()->export->alterTable($column['tableName'], array('rename' => array($column['oldColumnName'] => array('name' => $column['newColumnName'], 'definition' => $columnList[$column['oldColumnName']])))); } } public function processChangedColumn(array $column) { $options = array(); $options = $column['options']; $options['type'] = $column['type']; $this->getConnection()->export->alterTable($column['tableName'], array('change' => array($column['columnName'] => array('definition' => $options)))); } public function processCreatedIndex(array $index) { $this->getConnection()->export->createIndex($index['tableName'], $index['indexName'], $index['definition']); } public function processDroppedIndex(array $index) { $this->getConnection()->export->dropIndex($index['tableName'], $index['indexName']); } public function processCreatedConstraint(array $constraint) { $this->getConnection()->export->createConstraint($constraint['tableName'], $constraint['constraintName'], $constraint['definition']); } public function processDroppedConstraint(array $constraint) { $this->getConnection()->export->dropConstraint($constraint['tableName'], $constraint['constraintName'], isset($constraint['definition']['primary']) && $constraint['definition']['primary']); } public function processCreatedForeignKey(array $foreignKey) { $this->getConnection()->export->createForeignKey($foreignKey['tableName'], $foreignKey['definition']); } public function processDroppedForeignKey(array $foreignKey) { $this->getConnection()->export->dropForeignKey($foreignKey['tableName'], $foreignKey['definition']['name']); } }class Doctrine_Migration_Exception extends Doctrine_Exception { }class Doctrine_Migration_IrreversibleMigrationException extends Doctrine_Migration_Exception { }class Doctrine_Migration_Diff { protected $_from, $_to, $_changes = array('created_tables' => array(), 'dropped_tables' => array(), 'created_foreign_keys'=> array(), 'dropped_foreign_keys'=> array(), 'created_columns' => array(), 'dropped_columns' => array(), 'changed_columns' => array(), 'created_indexes' => array(), 'dropped_indexes' => array()), $_migration, $_startingModelFiles = array(), $_tmpPath; protected static $_toPrefix = 'ToPrfx', $_fromPrefix = 'FromPrfx'; public function __construct($from, $to, $migration) { $this->_from = $from; $this->_to = $to; $this->_startingModelFiles = Doctrine_Core::getLoadedModelFiles(); $this->setTmpPath(sys_get_temp_dir() . DIRECTORY_SEPARATOR . getmypid()); if ($migration instanceof Doctrine_Migration) { $this->_migration = $migration; } else if (is_dir($migration)) { $this->_migration = new Doctrine_Migration($migration); } } public function setTmpPath($tmpPath) { if ( ! is_dir($tmpPath)) { mkdir($tmpPath, 0777, true); } $this->_tmpPath = $tmpPath; } protected function getUniqueId() { return md5($this->_from . $this->_to); } public function generateChanges() { $this->_cleanup(); $from = $this->_generateModels(self::$_fromPrefix, $this->_from); $to = $this->_generateModels( Doctrine_Manager::getInstance()->getAttribute(Doctrine_Core::ATTR_MODEL_CLASS_PREFIX) . self::$_toPrefix, $this->_to ); return $this->_diff($from, $to); } public function generateMigrationClasses() { $builder = new Doctrine_Migration_Builder($this->_migration); return $builder->generateMigrationsFromDiff($this); } protected function _initializeModels($path) { $manager = Doctrine_Manager::getInstance(); $modelLoading = $manager->getAttribute(Doctrine_Core::ATTR_MODEL_LOADING); if ($modelLoading === Doctrine_Core::MODEL_LOADING_PEAR) { $orig = Doctrine_Core::getModelsDirectory(); Doctrine_Core::setModelsDirectory($path); $models = Doctrine_Core::initializeModels(Doctrine_Core::loadModels($path)); Doctrine_Core::setModelsDirectory($orig); } else { $models = Doctrine_Core::initializeModels(Doctrine_Core::loadModels($path)); } return $models; } protected function _diff($from, $to) { $fromModels = $this->_initializeModels($from); $toModels = $this->_initializeModels($to); $fromInfo = $this->_buildModelInformation($fromModels); $toInfo = $this->_buildModelInformation($toModels); $changes = $this->_buildChanges($fromInfo, $toInfo); $this->_cleanup(); return $changes; } protected function _buildChanges($from, $to) { foreach ($to as $className => $info) { if ( ! isset($from[$className])) { $names = array('type', 'charset', 'collate', 'indexes', 'foreignKeys', 'primary'); $options = array(); foreach ($names as $name) { if (isset($info['options'][$name]) && $info['options'][$name]) { $options[$name] = $info['options'][$name]; } } $table = array('tableName' => $info['tableName'], 'columns' => $info['columns'], 'options' => $options); $this->_changes['created_tables'][$info['tableName']] = $table; } foreach ($info['columns'] as $name => $column) { if (isset($from[$className]) && ! isset($from[$className]['columns'][$name])) { $this->_changes['created_columns'][$info['tableName']][$name] = $column; } if (isset($from[$className]['columns'][$name]) && $from[$className]['columns'][$name] != $column) { $this->_changes['changed_columns'][$info['tableName']][$name] = $column; } } foreach ($info['options']['foreignKeys'] as $name => $foreignKey) { $foreignKey['name'] = $name; if ( ! isset($from[$className]['options']['foreignKeys'][$name])) { $this->_changes['created_foreign_keys'][$info['tableName']][$name] = $foreignKey; $indexName = Doctrine_Manager::connection()->generateUniqueIndexName($info['tableName'], $foreignKey['local']); $this->_changes['created_indexes'][$info['tableName']][$indexName] = array('fields' => array($foreignKey['local'])); } else if (isset($from[$className]['options']['foreignKeys'][$name])) { $oldForeignKey = $from[$className]['options']['foreignKeys'][$name]; $oldForeignKey['name'] = $name; if ($foreignKey !== $oldForeignKey) { $this->_changes['dropped_foreign_keys'][$info['tableName']][$name] = $oldForeignKey; $this->_changes['created_foreign_keys'][$info['tableName']][$name] = $foreignKey; } } } foreach ($info['options']['indexes'] as $name => $index) { if ( ! isset($from[$className]['options']['indexes'][$name])) { $this->_changes['created_indexes'][$info['tableName']][$name] = $index; } } } foreach ($from as $className => $info) { if ( ! isset($to[$className])) { $table = array('tableName' => $info['tableName'], 'columns' => $info['columns'], 'options' => array('type' => $info['options']['type'], 'charset' => $info['options']['charset'], 'collate' => $info['options']['collate'], 'indexes' => $info['options']['indexes'], 'foreignKeys' => $info['options']['foreignKeys'], 'primary' => $info['options']['primary'])); $this->_changes['dropped_tables'][$info['tableName']] = $table; } foreach ($info['columns'] as $name => $column) { if (isset($to[$className]) && ! isset($to[$className]['columns'][$name])) { $this->_changes['dropped_columns'][$info['tableName']][$name] = $column; } } foreach ($info['options']['foreignKeys'] as $name => $foreignKey) { if ( ! isset($to[$className]['options']['foreignKeys'][$name])) { $this->_changes['dropped_foreign_keys'][$info['tableName']][$name] = $foreignKey; } } foreach ($info['options']['indexes'] as $name => $index) { if ( ! isset($to[$className]['options']['indexes'][$name])) { $this->_changes['dropped_indexes'][$info['tableName']][$name] = $index; } } } return $this->_changes; } protected function _buildModelInformation(array $models) { $info = array(); foreach ($models as $key => $model) { $table = Doctrine_Core::getTable($model); if ($table->getTableName() !== $this->_migration->getTableName()) { $info[$model] = $table->getExportableFormat(); } } $info = $this->_cleanModelInformation($info); return $info; } protected function _cleanModelInformation($info) { if (is_array($info)) { foreach ($info as $key => $value) { unset($info[$key]); $key = $this->_cleanModelInformation($key); $info[$key] = $this->_cleanModelInformation($value); } return $info; } else { $find = array( self::$_toPrefix, self::$_fromPrefix, Doctrine_Inflector::tableize(self::$_toPrefix) . '_', Doctrine_Inflector::tableize(self::$_fromPrefix) . '_', Doctrine_Inflector::tableize(self::$_toPrefix), Doctrine_Inflector::tableize(self::$_fromPrefix) ); return str_replace($find, null, $info); } } protected function _getItemExtension($item) { if (is_dir($item)) { $files = glob($item . DIRECTORY_SEPARATOR . '*'); } else { $files = array($item); } $extension = null; if (isset($files[0])) { if (is_dir($files[0])) { $extension = $this->_getItemExtension($files[0]); } else { $pathInfo = pathinfo($files[0]); $extension = $pathInfo['extension']; } } return $extension; } protected function _generateModels($prefix, $item) { $path = $this->_tmpPath . DIRECTORY_SEPARATOR . strtolower($prefix) . '_doctrine_tmp_dirs'; $options = array( 'classPrefix' => $prefix, 'generateBaseClasses' => false ); if (is_string($item) && file_exists($item)) { $extension = $this->_getItemExtension($item); if ($extension === 'yml') { Doctrine_Core::generateModelsFromYaml($item, $path, $options); return $path; } else if ($extension === 'php') { Doctrine_Lib::copyDirectory($item, $path); return $path; } else { throw new Doctrine_Migration_Exception('No php or yml files found at path: "' . $item . '"'); } } else { try { Doctrine_Core::generateModelsFromDb($path, (array) $item, $options); return $path; } catch (Exception $e) { throw new Doctrine_Migration_Exception('Could not generate models from connection: ' . $e->getMessage()); } } } protected function _cleanup() { $modelFiles = Doctrine_Core::getLoadedModelFiles(); $filesToClean = array_diff($modelFiles, $this->_startingModelFiles); foreach ($filesToClean as $file) { if (file_exists($file)) { unlink($file); } } Doctrine_Lib::removeDirectories($this->_tmpPath . DIRECTORY_SEPARATOR . strtolower(self::$_fromPrefix) . '_doctrine_tmp_dirs'); Doctrine_Lib::removeDirectories($this->_tmpPath . DIRECTORY_SEPARATOR . strtolower(self::$_toPrefix) . '_doctrine_tmp_dirs'); } } class Doctrine_Record_Listener implements Doctrine_Record_Listener_Interface { protected $_options = array('disabled' => false); public function setOption($name, $value = null) { if (is_array($name)) { $this->_options = Doctrine_Lib::arrayDeepMerge($this->_options, $name); } else { $this->_options[$name] = $value; } } public function getOptions() { return $this->_options; } public function getOption($name) { if (isset($this->_options[$name])) { return $this->_options[$name]; } return null; } public function preSerialize(Doctrine_Event $event) { } public function postSerialize(Doctrine_Event $event) { } public function preUnserialize(Doctrine_Event $event) { } public function postUnserialize(Doctrine_Event $event) { } public function preDqlSelect(Doctrine_Event $event) { } public function preSave(Doctrine_Event $event) { } public function postSave(Doctrine_Event $event) { } public function preDqlDelete(Doctrine_Event $event) { } public function preDelete(Doctrine_Event $event) { } public function postDelete(Doctrine_Event $event) { } public function preDqlUpdate(Doctrine_Event $event) { } public function preUpdate(Doctrine_Event $event) { } public function postUpdate(Doctrine_Event $event) { } public function preInsert(Doctrine_Event $event) { } public function postInsert(Doctrine_Event $event) { } public function preHydrate(Doctrine_Event $event) { } public function postHydrate(Doctrine_Event $event) { } public function preValidate(Doctrine_Event $event) { } public function postValidate(Doctrine_Event $event) { } }class Doctrine_AuditLog_Listener extends Doctrine_Record_Listener { protected $_auditLog; public function __construct(Doctrine_AuditLog $auditLog) { $this->_auditLog = $auditLog; } public function preInsert(Doctrine_Event $event) { $version = $this->_auditLog->getOption('version'); $name = $version['alias'] === null ? $version['name'] : $version['alias']; $record = $event->getInvoker(); $record->set($name, $this->_getInitialVersion($record)); } public function postInsert(Doctrine_Event $event) { if ($this->_auditLog->getOption('auditLog')) { $class = $this->_auditLog->getOption('className'); $record = $event->getInvoker(); $version = new $class(); $version->merge($record->toArray(), false); $version->save(); } } public function preDelete(Doctrine_Event $event) { if ($this->_auditLog->getOption('auditLog')) { $className = $this->_auditLog->getOption('className'); $version = $this->_auditLog->getOption('version'); $name = $version['alias'] === null ? $version['name'] : $version['alias']; $event->getInvoker()->set($name, null); if ($this->_auditLog->getOption('deleteVersions')) { $q = Doctrine_Core::getTable($className) ->createQuery('obj') ->delete(); foreach ((array) $this->_auditLog->getOption('table')->getIdentifier() as $id) { $conditions[] = 'obj.' . $id . ' = ?'; $values[] = $event->getInvoker()->get($id); } $rows = $q->where(implode(' AND ', $conditions)) ->execute($values); } } } public function preUpdate(Doctrine_Event $event) { if ($this->_auditLog->getOption('auditLog')) { $class = $this->_auditLog->getOption('className'); $record = $event->getInvoker(); $version = $this->_auditLog->getOption('version'); $name = $version['alias'] === null ? $version['name'] : $version['alias']; $record->set($name, $this->_getNextVersion($record)); $version = new $class(); $version->merge($record->toArray(), false); $version->save(); } } protected function _getInitialVersion(Doctrine_Record $record) { return 1; } protected function _getNextVersion(Doctrine_Record $record) { if ($this->_auditLog->getOption('auditLog')) { return ($this->_auditLog->getMaxVersion($record) + 1); } } }class Doctrine_AuditLog_Listener_Microtime extends Doctrine_AuditLog_Listener { protected $accuracy = 10; public function __construct(Doctrine_AuditLog $auditLog) { parent::__construct($auditLog); $version = $this->_auditLog->getOption('version'); if (!empty($version['accuracy'])) { $this->accuracy = $version['accuracy']; } } protected function _getInitialVersion(Doctrine_Record $record) { return $this->_microtime(); } protected function _getNextVersion(Doctrine_Record $record) { return $this->_microtime(); } protected function _microtime() { $version = microtime(true) - 1073741824; $version = str_replace('.', '', (string)$version); return substr($version, 0, $this->accuracy); } }class Doctrine_Hydrator { protected static $_totalHydrationTime = 0; protected $_hydrators, $_rootAlias = null, $_hydrationMode = Doctrine_Core::HYDRATE_RECORD, $_queryComponents = array(); public function __construct() { $this->_hydrators = Doctrine_Manager::getInstance()->getHydrators(); } public function setHydrationMode($hydrationMode) { $this->_hydrationMode = $hydrationMode; } public function getHydrationMode() { return $this->_hydrationMode; } public function setQueryComponents(array $queryComponents) { $this->_queryComponents = $queryComponents; } public function getQueryComponents() { return $this->_queryComponents; } public function getHydratorDriverClassName($mode = null) { if ($mode === null) { $mode = $this->_hydrationMode; } if ( ! isset($this->_hydrators[$mode])) { throw new Doctrine_Hydrator_Exception('Invalid hydration mode specified: '.$this->_hydrationMode); } return $this->_hydrators[$mode]; } public function getHydratorDriver($mode, $tableAliases) { $driverClass = $this->getHydratorDriverClassName($mode); if (is_object($driverClass)) { if (!$driverClass instanceOf Doctrine_Hydrator_Abstract) { throw new Doctrine_Hydrator_Exception('Invalid hydration class specified: '.get_class($driverClass)); } $driver = $driverClass; $driver->setQueryComponents($this->_queryComponents); $driver->setTableAliases($tableAliases); $driver->setHydrationMode($mode); } else { $driver = new $driverClass($this->_queryComponents, $tableAliases, $mode); } return $driver; } public function hydrateResultSet($stmt, $tableAliases) { $driver = $this->getHydratorDriver($this->_hydrationMode, $tableAliases); $result = $driver->hydrateResultSet($stmt); return $result; } }class Doctrine_Cli_Formatter { protected $_size = 65; function __construct($maxLineSize = 65) { $this->_size = $maxLineSize; } public function format($text = '', $parameters = array(), $stream = STDOUT) { return $text; } public function formatSection($section, $text, $size = null) { return sprintf(">> %-$9s %s", $section, $this->excerpt($text, $size)); } public function excerpt($text, $size = null) { if ( ! $size) { $size = $this->_size; } if (strlen($text) < $size) { return $text; } $subsize = floor(($size - 3) / 2); return substr($text, 0, $subsize).'...'.substr($text, -$subsize); } public function setMaxLineSize($size) { $this->_size = $size; } }class Doctrine_Cli_AnsiColorFormatter extends Doctrine_Cli_Formatter { protected $_styles = array( 'HEADER' => array('fg' => 'black', 'bold' => true), 'ERROR' => array('bg' => 'red', 'fg' => 'white', 'bold' => true), 'INFO' => array('fg' => 'green', 'bold' => true), 'COMMENT' => array('fg' => 'yellow'), ), $_options = array('bold' => 1, 'underscore' => 4, 'blink' => 5, 'reverse' => 7, 'conceal' => 8), $_foreground = array('black' => 30, 'red' => 31, 'green' => 32, 'yellow' => 33, 'blue' => 34, 'magenta' => 35, 'cyan' => 36, 'white' => 37), $_background = array('black' => 40, 'red' => 41, 'green' => 42, 'yellow' => 43, 'blue' => 44, 'magenta' => 45, 'cyan' => 46, 'white' => 47); public function setStyle($name, $options = array()) { $this->_styles[$name] = $options; } public function format($text = '', $parameters = array(), $stream = STDOUT) { if ( ! $this->supportsColors($stream)) { return $text; } if ( ! is_array($parameters) && 'NONE' == $parameters) { return $text; } if ( ! is_array($parameters) && isset($this->_styles[$parameters])) { $parameters = $this->_styles[$parameters]; } $codes = array(); if (isset($parameters['fg'])) { $codes[] = $this->_foreground[$parameters['fg']]; } if (isset($parameters['bg'])) { $codes[] = $this->_background[$parameters['bg']]; } foreach ($this->_options as $option => $value) { if (isset($parameters[$option]) && $parameters[$option]) { $codes[] = $value; } } return "\033[".implode(';', $codes).'m'.$text."\033[0m"; } public function formatSection($section, $text, $size = null) { $width = 9 + strlen($this->format('', 'INFO')); return sprintf(">> %-${width}s %s", $this->format($section, 'INFO'), $this->excerpt($text, $size)); } public function excerpt($text, $size = null) { if ( ! $size) { $size = $this->size; } if (strlen($text) < $size) { return $text; } $subsize = floor(($size - 3) / 2); return substr($text, 0, $subsize) . $this->format('...', 'INFO').substr($text, -$subsize); } public function supportsColors($stream) { return DIRECTORY_SEPARATOR != '\\' && function_exists('posix_isatty') && @posix_isatty($stream); } }class Doctrine_Cli_Exception extends Doctrine_Exception { }class Doctrine_View_Exception extends Doctrine_Exception { }class Doctrine_Data { protected $_formats = array('csv', 'yml', 'xml'); protected $_format = 'yml'; protected $_directory = null; protected $_models = array(); protected $_exportIndividualFiles = false; public function setFormat($format) { $this->_format = $format; } public function getFormat() { return $this->_format; } public function getFormats() { return $this->_formats; } public function setDirectory($directory) { $this->_directory = $directory; } public function getDirectory() { return $this->_directory; } public function setModels($models) { $this->_models = $models; } public function getModels() { return $this->_models; } public function exportIndividualFiles($bool = null) { if ($bool !== null) { $this->_exportIndividualFiles = $bool; } return $this->_exportIndividualFiles; } public function exportData($directory, $format = 'yml', $models = array(), $_exportIndividualFiles = false) { $export = new Doctrine_Data_Export($directory); $export->setFormat($format); $export->setModels($models); $export->exportIndividualFiles($_exportIndividualFiles); return $export->doExport(); } public function importData($directory, $format = 'yml', $models = array(), $append = false) { $import = new Doctrine_Data_Import($directory); $import->setFormat($format); $import->setModels($models); return $import->doImport($append); } public function isRelation(Doctrine_Record $record, $fieldName) { $relations = $record->getTable()->getRelations(); foreach ($relations as $relation) { $relationData = $relation->toArray(); if ($relationData['local'] === $fieldName) { return $relationData; } } return false; } public function purge($models = null) { if ($models) { $models = Doctrine_Core::filterInvalidModels($models); } else { $models = Doctrine_Core::getLoadedModels(); } $connections = array(); foreach ($models as $model) { $connections[Doctrine_Core::getTable($model)->getConnection()->getName()][] = $model; } foreach ($connections as $connection => $models) { $models = Doctrine_Manager::getInstance()->getConnection($connection)->unitOfWork->buildFlushTree($models); $models = array_reverse($models); foreach ($models as $model) { Doctrine_Core::getTable($model)->createQuery()->delete()->execute(); } } } }abstract class Doctrine_Record_Generator extends Doctrine_Record_Abstract { protected $_options = array( 'generateFiles' => false, 'generatePath' => false, 'builderOptions' => array(), 'identifier' => false, 'table' => false, 'pluginTable' => false, 'children' => array(), 'cascadeDelete' => true, 'appLevelDelete' => false ); protected $_initialized = false; public function __get($option) { if (isset($this->_options[$option])) { return $this->_options[$option]; } return null; } public function __isset($option) { return isset($this->_options[$option]); } public function getOption($name) { if ( ! isset($this->_options[$name])) { throw new Doctrine_Exception('Unknown option ' . $name); } return $this->_options[$name]; } public function setOption($name, $value) { $this->_options[$name] = $value; return $this; } public function addChild($generator) { $this->_options['children'][] = $generator; } public function getOptions() { return $this->_options; } public function initialize(Doctrine_Table $table) { if ($this->_initialized) { return false; } $this->_initialized = true; $this->initOptions(); $table->addGenerator($this, get_class($this)); $this->_options['table'] = $table; $ownerClassName = $this->_options['table']->getComponentName(); $className = $this->_options['className']; $this->_options['className'] = str_replace('%CLASS%', $ownerClassName, $className); if (isset($this->_options['tableName'])) { $ownerTableName = $this->_options['table']->getTableName(); $tableName = $this->_options['tableName']; $this->_options['tableName'] = str_replace('%TABLE%', $ownerTableName, $tableName); } if ($this->_options['generateFiles'] === false && class_exists($this->_options['className'])) { $this->_table = Doctrine_Core::getTable($this->_options['className']); return false; } $this->buildTable(); $fk = $this->buildForeignKeys($this->_options['table']); $this->_table->setColumns($fk); $this->buildRelation(); $this->setTableDefinition(); $this->setUp(); $this->generateClassFromTable($this->_table); $this->buildChildDefinitions(); $this->_table->initIdentifier(); } public function buildTable() { $conn = $this->_options['table']->getConnection(); $bindConnName = $conn->getManager()->getConnectionForComponent($this->_options['table']->getComponentName())->getName(); if ($bindConnName) { $conn->getManager()->bindComponent($this->_options['className'], $bindConnName); } else { $conn->getManager()->bindComponent($this->_options['className'], $conn->getName()); } $tableClass = $conn->getAttribute(Doctrine_Core::ATTR_TABLE_CLASS); $this->_table = new $tableClass($this->_options['className'], $conn); $this->_table->setGenerator($this); if (isset($this->_options['tableName']) && $this->_options['tableName']) { $this->_table->setTableName($this->_options['tableName']); } $options = $this->_options['table']->getOptions(); $newOptions = array(); $maintain = array('type', 'collate', 'charset'); foreach ($maintain as $key) { if (isset($options[$key])) { $newOptions[$key] = $options[$key]; } } $this->_table->setOptions($newOptions); $conn->addTable($this->_table); } public function initOptions() { } public function buildChildDefinitions() { if ( ! isset($this->_options['children'])) { throw new Doctrine_Record_Exception("Unknown option 'children'."); } foreach ($this->_options['children'] as $child) { if ($child instanceof Doctrine_Template) { if ($child->getPlugin() !== null) { $this->_table->addGenerator($child->getPlugin(), get_class($child->getPlugin())); } $this->_table->addTemplate(get_class($child), $child); $child->setInvoker($this); $child->setTable($this->_table); $child->setTableDefinition(); $child->setUp(); } else { $this->_table->addGenerator($child, get_class($child)); $child->initialize($this->_table); } } } public function buildForeignKeys(Doctrine_Table $table) { $fk = array(); foreach ((array) $table->getIdentifier() as $column) { $def = $table->getDefinitionOf($column); unset($def['autoincrement']); unset($def['sequence']); unset($def['primary']); $col = $column; $def['primary'] = true; $fk[$col] = $def; } return $fk; } public function buildLocalRelation($alias = null) { $options = array( 'local' => $this->getRelationLocalKey(), 'foreign' => $this->getRelationForeignKey(), 'owningSide' => true ); if (isset($this->_options['cascadeDelete']) && $this->_options['cascadeDelete'] && ! $this->_options['appLevelDelete']) { $options['onDelete'] = 'CASCADE'; $options['onUpdate'] = 'CASCADE'; } $aliasStr = ''; if ($alias !== null) { $aliasStr = ' as ' . $alias; } $this->hasOne($this->_options['table']->getComponentName() . $aliasStr, $options); } public function ownerHasMany($name, $options) { $this->_options['table']->hasMany($name, $options); } public function ownerHasOne($name, $options) { $this->_options['table']->hasOne($name, $options); } public function buildForeignRelation($alias = null) { $options = array( 'local' => $this->getRelationForeignKey(), 'foreign' => $this->getRelationLocalKey(), 'localKey' => false ); if (isset($this->_options['cascadeDelete']) && $this->_options['cascadeDelete'] && $this->_options['appLevelDelete']) { $options['cascade'] = array('delete'); } $aliasStr = ''; if ($alias !== null) { $aliasStr = ' as ' . $alias; } $this->ownerHasMany($this->_table->getComponentName() . $aliasStr, $options); } public function getRelationLocalKey() { return $this->getRelationForeignKey(); } public function getRelationForeignKey() { $table = $this->_options['table']; $identifier = $table->getIdentifier(); foreach ((array) $identifier as $column) { $def = $table->getDefinitionOf($column); if (isset($def['primary']) && $def['primary'] && isset($def['autoincrement']) && $def['autoincrement']) { return $column; } } return $identifier; } public function buildRelation() { $this->buildForeignRelation(); $this->buildLocalRelation(); } public function generateClassFromTable(Doctrine_Table $table) { $definition = array(); $definition['columns'] = $table->getColumns(); $definition['tableName'] = $table->getTableName(); $definition['actAs'] = $table->getTemplates(); return $this->generateClass($definition); } public function generateClass(array $definition = array()) { $definition['className'] = $this->_options['className']; $definition['toString'] = isset($this->_options['toString']) ? $this->_options['toString'] : false; if (isset($this->_options['listeners'])) { $definition['listeners'] = $this->_options['listeners']; } $builder = new Doctrine_Import_Builder(); $builderOptions = isset($this->_options['builderOptions']) ? (array) $this->_options['builderOptions']:array(); $builder->setOptions($builderOptions); if ($this->_options['generateFiles']) { if (isset($this->_options['generatePath']) && $this->_options['generatePath']) { $builder->setTargetPath($this->_options['generatePath']); $builder->buildRecord($definition); } else { throw new Doctrine_Record_Exception('If you wish to generate files then you must specify the path to generate the files in.'); } } else { $def = $builder->buildDefinition($definition); eval($def); } } }class Doctrine_I18n extends Doctrine_Record_Generator { protected $_options = array( 'className' => '%CLASS%Translation', 'tableName' => '%TABLE%_translation', 'fields' => array(), 'generateFiles' => false, 'table' => false, 'pluginTable' => false, 'children' => array(), 'i18nField' => 'lang', 'type' => 'string', 'length' => 2, 'options' => array(), 'cascadeDelete' => true, 'appLevelDelete'=> false ); public function __construct($options) { $this->_options = Doctrine_Lib::arrayDeepMerge($this->_options, $options); } public function buildRelation() { $this->buildForeignRelation('Translation'); $this->buildLocalRelation(); } public function setTableDefinition() { if (empty($this->_options['fields'])) { throw new Doctrine_I18n_Exception('Fields not set.'); } $options = array('className' => $this->_options['className']); $cols = $this->_options['table']->getColumns(); $columns = array(); foreach ($cols as $column => $definition) { $fieldName = $this->_options['table']->getFieldName($column); if (in_array($fieldName, $this->_options['fields'])) { if ($column != $fieldName) { $column .= ' as ' . $fieldName; } $columns[$column] = $definition; $this->_options['table']->removeColumn($fieldName); } } $this->hasColumns($columns); $defaultOptions = array( 'fixed' => true, 'primary' => true ); $options = array_merge($defaultOptions, $this->_options['options']); $this->hasColumn($this->_options['i18nField'], $this->_options['type'], $this->_options['length'], $options); $this->bindQueryParts(array('indexBy' => $this->_options['i18nField'])); $originalName = $this->_options['table']->getClassnameToReturn(); $relations = $this->_options['table']->getRelationParser()->getPendingRelations(); foreach($relations as $table => $relation) { if ($table != $this->_table->getTableName() ) { if (isset($relation['local']) && in_array($relation['local'], $this->_options['fields'])) { $this->_options['table']->getRelationParser()->unsetPendingRelations($table); $this->_table->getRelationParser()->bind($table, $relation); $rp = Doctrine_Core::getTable($table)->getRelationParser(); $others = $rp->getPendingRelation($originalName); if (isset($others)) { $others['class'] = $this->_table->getClassnameToReturn(); $others['alias'] = $this->_table->getClassnameToReturn(); $rp->unsetPendingRelations($originalName); $rp->bind($this->_table->getClassnameToReturn() ,$others); } } } } } }abstract class Doctrine_Query_Abstract { const SELECT = 0; const DELETE = 1; const UPDATE = 2; const INSERT = 3; const CREATE = 4; const STATE_CLEAN = 1; const STATE_DIRTY = 2; const STATE_DIRECT = 3; const STATE_LOCKED = 4; protected $_tableAliasMap = array(); protected $_view; protected $_state = Doctrine_Query::STATE_CLEAN; protected $_params = array('exec' => array(), 'join' => array(), 'where' => array(), 'set' => array(), 'having' => array()); protected $_execParams = array(); protected $_resultCache; protected $_resultCacheHash; protected $_expireResultCache = false; protected $_resultCacheTTL; protected $_queryCache; protected $_expireQueryCache = false; protected $_queryCacheTTL; protected $_conn; protected $_passedConn = false; protected $_sqlParts = array( 'select' => array(), 'distinct' => false, 'forUpdate' => false, 'from' => array(), 'set' => array(), 'join' => array(), 'where' => array(), 'groupby' => array(), 'having' => array(), 'orderby' => array(), 'limit' => false, 'offset' => false, ); protected $_dqlParts = array( 'from' => array(), 'select' => array(), 'forUpdate' => false, 'set' => array(), 'join' => array(), 'where' => array(), 'groupby' => array(), 'having' => array(), 'orderby' => array(), 'limit' => array(), 'offset' => array(), ); protected $_queryComponents = array(); protected $_rootAlias = ''; protected $_type = self::SELECT; protected $_hydrator; protected $_tokenizer; protected $_parser; protected $_tableAliasSeeds = array(); protected $_options = array( 'hydrationMode' => Doctrine_Core::HYDRATE_RECORD ); protected $_isLimitSubqueryUsed = false; protected $_components; protected $_preQueried = false; public function __construct(Doctrine_Connection $connection = null, Doctrine_Hydrator_Abstract $hydrator = null) { if ($connection === null) { $connection = Doctrine_Manager::getInstance()->getCurrentConnection(); } else { $this->_passedConn = true; } if ($hydrator === null) { $hydrator = new Doctrine_Hydrator(); } $this->_conn = $connection; $this->_hydrator = $hydrator; $this->_tokenizer = new Doctrine_Query_Tokenizer(); $this->_resultCacheTTL = $this->_conn->getAttribute(Doctrine_Core::ATTR_RESULT_CACHE_LIFESPAN); $this->_queryCacheTTL = $this->_conn->getAttribute(Doctrine_Core::ATTR_QUERY_CACHE_LIFESPAN); } public function setConnection(Doctrine_Connection $connection) { $this->_passedConn = true; $this->_conn = $connection; } public function setOption($name, $value) { if ( ! isset($this->_options[$name])) { throw new Doctrine_Query_Exception('Unknown option ' . $name); } $this->_options[$name] = $value; } public function hasSqlTableAlias($sqlTableAlias) { return (isset($this->_tableAliasMap[$sqlTableAlias])); } public function getTableAliasMap() { return $this->_tableAliasMap; } public function getDql() { $q = ''; if ($this->_type == self::SELECT) { $q .= ( ! empty($this->_dqlParts['select'])) ? 'SELECT ' . implode(', ', $this->_dqlParts['select']) : ''; $q .= ( ! empty($this->_dqlParts['from'])) ? ' FROM ' . implode(' ', $this->_dqlParts['from']) : ''; } else if ($this->_type == self::DELETE) { $q .= 'DELETE'; $q .= ( ! empty($this->_dqlParts['from'])) ? ' FROM ' . implode(' ', $this->_dqlParts['from']) : ''; } else if ($this->_type == self::UPDATE) { $q .= 'UPDATE '; $q .= ( ! empty($this->_dqlParts['from'])) ? implode(' ', $this->_dqlParts['from']) : ''; $q .= ( ! empty($this->_dqlParts['set'])) ? ' SET ' . implode(' ', $this->_dqlParts['set']) : ''; } $q .= ( ! empty($this->_dqlParts['where'])) ? ' WHERE ' . implode(' ', $this->_dqlParts['where']) : ''; $q .= ( ! empty($this->_dqlParts['groupby'])) ? ' GROUP BY ' . implode(', ', $this->_dqlParts['groupby']) : ''; $q .= ( ! empty($this->_dqlParts['having'])) ? ' HAVING ' . implode(' AND ', $this->_dqlParts['having']) : ''; $q .= ( ! empty($this->_dqlParts['orderby'])) ? ' ORDER BY ' . implode(', ', $this->_dqlParts['orderby']) : ''; $q .= ( ! empty($this->_dqlParts['limit'])) ? ' LIMIT ' . implode(' ', $this->_dqlParts['limit']) : ''; $q .= ( ! empty($this->_dqlParts['offset'])) ? ' OFFSET ' . implode(' ', $this->_dqlParts['offset']) : ''; return $q; } public function getSqlQueryPart($part) { if ( ! isset($this->_sqlParts[$part])) { throw new Doctrine_Query_Exception('Unknown SQL query part ' . $part); } return $this->_sqlParts[$part]; } public function setSqlQueryPart($name, $part) { if ( ! isset($this->_sqlParts[$name])) { throw new Doctrine_Query_Exception('Unknown query part ' . $name); } if ($name !== 'limit' && $name !== 'offset') { if (is_array($part)) { $this->_sqlParts[$name] = $part; } else { $this->_sqlParts[$name] = array($part); } } else { $this->_sqlParts[$name] = $part; } return $this; } public function addSqlQueryPart($name, $part) { if ( ! isset($this->_sqlParts[$name])) { throw new Doctrine_Query_Exception('Unknown query part ' . $name); } if (is_array($part)) { $this->_sqlParts[$name] = array_merge($this->_sqlParts[$name], $part); } else { $this->_sqlParts[$name][] = $part; } return $this; } public function removeSqlQueryPart($name) { if ( ! isset($this->_sqlParts[$name])) { throw new Doctrine_Query_Exception('Unknown query part ' . $name); } if ($name == 'limit' || $name == 'offset' || $name == 'forUpdate') { $this->_sqlParts[$name] = false; } else { $this->_sqlParts[$name] = array(); } return $this; } public function removeDqlQueryPart($name) { if ( ! isset($this->_dqlParts[$name])) { throw new Doctrine_Query_Exception('Unknown query part ' . $name); } if ($name == 'limit' || $name == 'offset') { $this->_dqlParts[$name] = false; } else { $this->_dqlParts[$name] = array(); } return $this; } public function getParams() { return $this->_params; } public function getFlattenedParams($params = array()) { return array_merge( (array) $params, (array) $this->_params['exec'], $this->_params['join'], $this->_params['set'], $this->_params['where'], $this->_params['having'] ); } public function getInternalParams($params = array()) { return array_merge($params, $this->_execParams); } public function setParams(array $params = array()) { $this->_params = $params; } public function getCountQueryParams($params = array()) { if ( ! is_array($params)) { $params = array($params); } $this->_params['exec'] = $params; $params = array_merge($this->_params['join'], $this->_params['where'], $this->_params['having'], $this->_params['exec']); $this->fixArrayParameterValues($params); return $this->_execParams; } public function fixArrayParameterValues($params = array()) { $i = 0; foreach ($params as $param) { if (is_array($param)) { $c = count($param); array_splice($params, $i, 1, $param); $i += $c; } else { $i++; } } $this->_execParams = $params; } public function setView(Doctrine_View $view) { $this->_view = $view; } public function getView() { return $this->_view; } public function isLimitSubqueryUsed() { return $this->_isLimitSubqueryUsed; } public function getInheritanceCondition($componentAlias) { $map = $this->_queryComponents[$componentAlias]['table']->inheritanceMap; if (empty($map)) { return; } $tableAlias = $this->getSqlTableAlias($componentAlias); if ($this->_type !== Doctrine_Query::SELECT) { $tableAlias = ''; } else { $tableAlias .= '.'; } $retVal = ""; $count = 0; foreach ($map as $field => $value) { if ($count++ > 0) { $retVal .= ' AND '; } $identifier = $this->_conn->quoteIdentifier($tableAlias . $field); $retVal .= $identifier . ' = ' . $this->_conn->quote($value); } return $retVal; } public function getSqlTableAlias($componentAlias, $tableName = null) { $alias = array_search($componentAlias, $this->_tableAliasMap); if ($alias !== false) { return $alias; } if ($tableName === null) { throw new Doctrine_Query_Exception("Couldn't get short alias for " . $componentAlias); } return $this->generateSqlTableAlias($componentAlias, $tableName); } public function generateNewSqlTableAlias($oldAlias) { if (isset($this->_tableAliasMap[$oldAlias])) { $name = substr($oldAlias, 0, 1); $i = ((int) substr($oldAlias, 1)); if ( ! isset($this->_tableAliasSeeds[$name])) { $this->_tableAliasSeeds[$name] = 1; } $newIndex = ($this->_tableAliasSeeds[$name] + (($i == 0) ? 1 : $i)); return $name . $newIndex; } return $oldAlias; } public function getSqlTableAliasSeed($sqlTableAlias) { if ( ! isset($this->_tableAliasSeeds[$sqlTableAlias])) { return 0; } return $this->_tableAliasSeeds[$sqlTableAlias]; } public function hasAliasDeclaration($componentAlias) { return isset($this->_queryComponents[$componentAlias]); } public function getQueryComponent($componentAlias) { if ( ! isset($this->_queryComponents[$componentAlias])) { throw new Doctrine_Query_Exception('Unknown component alias ' . $componentAlias); } return $this->_queryComponents[$componentAlias]; } public function copySubqueryInfo(Doctrine_Query_Abstract $query) { $this->_params =& $query->_params; $this->_tableAliasMap =& $query->_tableAliasMap; $this->_queryComponents =& $query->_queryComponents; $this->_tableAliasSeeds = $query->_tableAliasSeeds; return $this; } public function getRootAlias() { if ( ! $this->_queryComponents) { $this->getSqlQuery(array(), false); } return $this->_rootAlias; } public function getRootDeclaration() { $map = $this->_queryComponents[$this->_rootAlias]; return $map; } public function getRoot() { $map = $this->_queryComponents[$this->_rootAlias]; if ( ! isset($map['table'])) { throw new Doctrine_Query_Exception('Root component not initialized.'); } return $map['table']; } public function generateSqlTableAlias($componentAlias, $tableName) { preg_match('/([^_|\d])/', $tableName, $matches); $char = strtolower($matches[0]); $alias = $char; if ( ! isset($this->_tableAliasSeeds[$alias])) { $this->_tableAliasSeeds[$alias] = 1; } while (isset($this->_tableAliasMap[$alias])) { if ( ! isset($this->_tableAliasSeeds[$alias])) { $this->_tableAliasSeeds[$alias] = 1; } $alias = $char . ++$this->_tableAliasSeeds[$alias]; } $this->_tableAliasMap[$alias] = $componentAlias; return $alias; } public function getComponentAlias($sqlTableAlias) { $sqlTableAlias = trim($sqlTableAlias, '[]`"'); if ( ! isset($this->_tableAliasMap[$sqlTableAlias])) { throw new Doctrine_Query_Exception('Unknown table alias ' . $sqlTableAlias); } return $this->_tableAliasMap[$sqlTableAlias]; } public function calculateQueryCacheHash() { $dql = $this->getDql(); $hash = md5($dql . var_export($this->_pendingJoinConditions, true) . 'DOCTRINE_QUERY_CACHE_SALT'); return $hash; } public function calculateResultCacheHash($params = array()) { $dql = $this->getDql(); $conn = $this->getConnection(); $params = $this->getFlattenedParams($params); $hash = md5($this->_hydrator->getHydrationMode() . $conn->getName() . $conn->getOption('dsn') . $dql . var_export($this->_pendingJoinConditions, true) . var_export($params, true)); return $hash; } public function getResultCacheHash($params = array()) { if ($this->_resultCacheHash) { return $this->_resultCacheHash; } else { return $this->calculateResultCacheHash($params); } } protected function _execute($params) { $params = $this->_conn->convertBooleans($params); foreach ($this->_params as $k => $v) { $this->_params[$k] = $this->_conn->convertBooleans($v); } $dqlParams = $this->getFlattenedParams($params); if ( ! $this->_view) { if ($this->_queryCache !== false && ($this->_queryCache || $this->_conn->getAttribute(Doctrine_Core::ATTR_QUERY_CACHE))) { $queryCacheDriver = $this->getQueryCacheDriver(); $hash = $this->calculateQueryCacheHash(); $cached = $queryCacheDriver->fetch($hash); if ($cached) { $query = $this->_constructQueryFromCache($cached); $this->_params['exec'] = $params; $this->_execParams = $this->getFlattenedParams(); $this->fixArrayParameterValues($this->getInternalParams()); } else { $query = $this->getSqlQuery($params); if ($this->_queryCache !== false && ($this->_queryCache || $this->_conn->getAttribute(Doctrine_Core::ATTR_QUERY_CACHE))) { $serializedQuery = $this->getCachedForm($query); $queryCacheDriver->save($hash, $serializedQuery, $this->getQueryCacheLifeSpan()); } } } else { $query = $this->getSqlQuery($params); } } else { $query = $this->_view->getSelectSql(); } $params = $this->getInternalParams(); if ($this->isLimitSubqueryUsed() && $this->_conn->getAttribute(Doctrine_Core::ATTR_DRIVER_NAME) !== 'mysql') { $params = array_merge((array) $params, (array) $params); } if ($this->_type !== self::SELECT) { return $this->_conn->exec($query, $params); } $stmt = $this->_conn->execute($query, $params); $this->_params['exec'] = array(); return $stmt; } public function execute($params = array(), $hydrationMode = null) { $this->_execParams = array(); if (empty($this->_dqlParts['from']) && empty($this->_sqlParts['from'])) { throw new Doctrine_Query_Exception('You must have at least one component specified in your from.'); } $dqlParams = $this->getFlattenedParams($params); $this->_preQuery($dqlParams); if ($hydrationMode !== null) { $this->_hydrator->setHydrationMode($hydrationMode); } $hydrationMode = $this->_hydrator->getHydrationMode(); if ($this->_resultCache && $this->_type == self::SELECT) { $cacheDriver = $this->getResultCacheDriver(); $hash = $this->getResultCacheHash($params); $cached = ($this->_expireResultCache) ? false : $cacheDriver->fetch($hash); if ($cached === false) { $stmt = $this->_execute($params); $this->_hydrator->setQueryComponents($this->_queryComponents); $result = $this->_hydrator->hydrateResultSet($stmt, $this->_tableAliasMap); $cached = $this->getCachedForm($result); $cacheDriver->save($hash, $cached, $this->getResultCacheLifeSpan()); } else { $result = $this->_constructQueryFromCache($cached); } } else { $stmt = $this->_execute($params); if (is_integer($stmt)) { $result = $stmt; } else { $this->_hydrator->setQueryComponents($this->_queryComponents); if ($this->_type == self::SELECT && $hydrationMode == Doctrine_Core::HYDRATE_ON_DEMAND) { $hydrationDriver = $this->_hydrator->getHydratorDriver($hydrationMode, $this->_tableAliasMap); $result = new Doctrine_Collection_OnDemand($stmt, $hydrationDriver, $this->_tableAliasMap); } else { $result = $this->_hydrator->hydrateResultSet($stmt, $this->_tableAliasMap); } } } if ($this->getConnection()->getAttribute(Doctrine_Core::ATTR_AUTO_FREE_QUERY_OBJECTS)) { $this->free(); } return $result; } public function free() { } protected function _getDqlCallback() { $callback = false; if ( ! empty($this->_dqlParts['from'])) { switch ($this->_type) { case self::DELETE: $callback = array( 'callback' => 'preDqlDelete', 'const' => Doctrine_Event::RECORD_DQL_DELETE ); break; case self::UPDATE: $callback = array( 'callback' => 'preDqlUpdate', 'const' => Doctrine_Event::RECORD_DQL_UPDATE ); break; case self::SELECT: $callback = array( 'callback' => 'preDqlSelect', 'const' => Doctrine_Event::RECORD_DQL_SELECT ); break; } } return $callback; } protected function _preQuery($params = array()) { if ( ! $this->_preQueried && $this->getConnection()->getAttribute(Doctrine_Core::ATTR_USE_DQL_CALLBACKS)) { $this->_preQueried = true; $callback = $this->_getDqlCallback(); if ( ! $callback) { return; } foreach ($this->_getDqlCallbackComponents($params) as $alias => $component) { $table = $component['table']; $record = $table->getRecordInstance(); $params = array('component' => $component, 'alias' => $alias); $event = new Doctrine_Event($record, $callback['const'], $this, $params); $record->$callback['callback']($event); $table->getRecordListener()->$callback['callback']($event); } } $this->preQuery(); } protected function _getDqlCallbackComponents($params = array()) { $componentsBefore = array(); if ($this->isSubquery()) { $componentsBefore = $this->getQueryComponents(); } $copy = $this->copy(); $copy->getSqlQuery($params, false); $componentsAfter = $copy->getQueryComponents(); $this->_rootAlias = $copy->getRootAlias(); $copy->free(); if ($componentsBefore !== $componentsAfter) { return array_diff($componentsAfter, $componentsBefore); } else { return $componentsAfter; } } public function preQuery() { } protected function _constructQueryFromCache($cached) { $cached = unserialize($cached); $this->_tableAliasMap = $cached[2]; $customComponent = $cached[0]; $queryComponents = array(); $cachedComponents = $cached[1]; foreach ($cachedComponents as $alias => $components) { $e = explode('.', $components['name']); if (count($e) === 1) { $manager = Doctrine_Manager::getInstance(); if ( ! $this->_passedConn && $manager->hasConnectionForComponent($e[0])) { $this->_conn = $manager->getConnectionForComponent($e[0]); } $queryComponents[$alias]['table'] = $this->_conn->getTable($e[0]); } else { $queryComponents[$alias]['parent'] = $e[0]; $queryComponents[$alias]['relation'] = $queryComponents[$e[0]]['table']->getRelation($e[1]); $queryComponents[$alias]['table'] = $queryComponents[$alias]['relation']->getTable(); } if (isset($components['agg'])) { $queryComponents[$alias]['agg'] = $components['agg']; } if (isset($components['map'])) { $queryComponents[$alias]['map'] = $components['map']; } } $this->_queryComponents = $queryComponents; return $customComponent; } public function getCachedForm($customComponent = null) { $componentInfo = array(); foreach ($this->getQueryComponents() as $alias => $components) { if ( ! isset($components['parent'])) { $componentInfo[$alias]['name'] = $components['table']->getComponentName(); } else { $componentInfo[$alias]['name'] = $components['parent'] . '.' . $components['relation']->getAlias(); } if (isset($components['agg'])) { $componentInfo[$alias]['agg'] = $components['agg']; } if (isset($components['map'])) { $componentInfo[$alias]['map'] = $components['map']; } } if ($customComponent instanceof Doctrine_Collection) { foreach ($customComponent as $record) { $record->serializeReferences(true); } } return serialize(array($customComponent, $componentInfo, $this->getTableAliasMap())); } public function addSelect($select) { return $this->_addDqlQueryPart('select', $select, true); } public function addSqlTableAlias($sqlTableAlias, $componentAlias) { $this->_tableAliasMap[$sqlTableAlias] = $componentAlias; return $this; } public function addFrom($from) { return $this->_addDqlQueryPart('from', $from, true); } public function addWhere($where, $params = array()) { return $this->andWhere($where, $params); } public function andWhere($where, $params = array()) { if (is_array($params)) { $this->_params['where'] = array_merge($this->_params['where'], $params); } else { $this->_params['where'][] = $params; } if ($this->_hasDqlQueryPart('where')) { $this->_addDqlQueryPart('where', 'AND', true); } return $this->_addDqlQueryPart('where', $where, true); } public function orWhere($where, $params = array()) { if (is_array($params)) { $this->_params['where'] = array_merge($this->_params['where'], $params); } else { $this->_params['where'][] = $params; } if ($this->_hasDqlQueryPart('where')) { $this->_addDqlQueryPart('where', 'OR', true); } return $this->_addDqlQueryPart('where', $where, true); } public function whereIn($expr, $params = array(), $not = false) { return $this->andWhereIn($expr, $params, $not); } public function andWhereIn($expr, $params = array(), $not = false) { if (isset($params) and (count($params) == 0)) { return $this; } if ($this->_hasDqlQueryPart('where')) { $this->_addDqlQueryPart('where', 'AND', true); } return $this->_addDqlQueryPart('where', $this->_processWhereIn($expr, $params, $not), true); } public function orWhereIn($expr, $params = array(), $not = false) { if (isset($params) and (count($params) == 0)) { return $this; } if ($this->_hasDqlQueryPart('where')) { $this->_addDqlQueryPart('where', 'OR', true); } return $this->_addDqlQueryPart('where', $this->_processWhereIn($expr, $params, $not), true); } protected function _processWhereIn($expr, $params = array(), $not = false) { $params = (array) $params; if (count($params) == 0) { throw new Doctrine_Query_Exception('You must pass at least one parameter when using an IN() condition.'); } $a = array(); foreach ($params as $k => $value) { if ($value instanceof Doctrine_Expression) { $value = $value->getSql(); unset($params[$k]); } else { $value = '?'; } $a[] = $value; } $this->_params['where'] = array_merge($this->_params['where'], $params); return $expr . ($not === true ? ' NOT' : '') . ' IN (' . implode(', ', $a) . ')'; } public function whereNotIn($expr, $params = array()) { return $this->whereIn($expr, $params, true); } public function andWhereNotIn($expr, $params = array()) { return $this->andWhereIn($expr, $params, true); } public function orWhereNotIn($expr, $params = array()) { return $this->orWhereIn($expr, $params, true); } public function addGroupBy($groupby) { return $this->_addDqlQueryPart('groupby', $groupby, true); } public function addHaving($having, $params = array()) { if (is_array($params)) { $this->_params['having'] = array_merge($this->_params['having'], $params); } else { $this->_params['having'][] = $params; } return $this->_addDqlQueryPart('having', $having, true); } public function addOrderBy($orderby) { return $this->_addDqlQueryPart('orderby', $orderby, true); } public function select($select = null) { $this->_type = self::SELECT; if ($select) { return $this->_addDqlQueryPart('select', $select); } else { return $this; } } public function distinct($flag = true) { $this->_sqlParts['distinct'] = (bool) $flag; return $this; } public function forUpdate($flag = true) { $this->_sqlParts['forUpdate'] = (bool) $flag; return $this; } public function delete($from = null) { $this->_type = self::DELETE; if ($from != null) { return $this->_addDqlQueryPart('from', $from); } return $this; } public function update($from = null) { $this->_type = self::UPDATE; if ($from != null) { return $this->_addDqlQueryPart('from', $from); } return $this; } public function set($key, $value = null, $params = null) { if (is_array($key)) { foreach ($key as $k => $v) { $this->set($k, '?', array($v)); } return $this; } else { if ($params !== null) { if (is_array($params)) { $this->_params['set'] = array_merge($this->_params['set'], $params); } else { $this->_params['set'][] = $params; } } return $this->_addDqlQueryPart('set', $key . ' = ' . $value, true); } } public function from($from) { return $this->_addDqlQueryPart('from', $from); } public function innerJoin($join, $params = array()) { if (is_array($params)) { $this->_params['join'] = array_merge($this->_params['join'], $params); } else { $this->_params['join'][] = $params; } return $this->_addDqlQueryPart('from', 'INNER JOIN ' . $join, true); } public function leftJoin($join, $params = array()) { if (is_array($params)) { $this->_params['join'] = array_merge($this->_params['join'], $params); } else { $this->_params['join'][] = $params; } return $this->_addDqlQueryPart('from', 'LEFT JOIN ' . $join, true); } public function groupBy($groupby) { return $this->_addDqlQueryPart('groupby', $groupby); } public function where($where, $params = array()) { $this->_params['where'] = array(); if (is_array($params)) { $this->_params['where'] = $params; } else { $this->_params['where'][] = $params; } return $this->_addDqlQueryPart('where', $where); } public function having($having, $params = array()) { $this->_params['having'] = array(); if (is_array($params)) { $this->_params['having'] = $params; } else { $this->_params['having'][] = $params; } return $this->_addDqlQueryPart('having', $having); } public function orderBy($orderby) { return $this->_addDqlQueryPart('orderby', $orderby); } public function limit($limit) { return $this->_addDqlQueryPart('limit', $limit); } public function offset($offset) { return $this->_addDqlQueryPart('offset', $offset); } protected function clear() { $this->_sqlParts = array( 'select' => array(), 'distinct' => false, 'forUpdate' => false, 'from' => array(), 'set' => array(), 'join' => array(), 'where' => array(), 'groupby' => array(), 'having' => array(), 'orderby' => array(), 'limit' => false, 'offset' => false, ); } public function setHydrationMode($hydrationMode) { $this->_hydrator->setHydrationMode($hydrationMode); return $this; } public function getQueryComponents() { return $this->_queryComponents; } public function getSqlParts() { return $this->_sqlParts; } public function getType() { return $this->_type; } public function useResultCache($driver = true, $timeToLive = null, $resultCacheHash = null) { if ($driver !== null && $driver !== true && ! ($driver instanceOf Doctrine_Cache_Interface)) { $msg = 'First argument should be instance of Doctrine_Cache_Interface or null.'; throw new Doctrine_Query_Exception($msg); } $this->_resultCache = $driver; $this->_resultCacheHash = $resultCacheHash; if ($timeToLive !== null) { $this->setResultCacheLifeSpan($timeToLive); } return $this; } public function setResultCacheHash($resultCacheHash) { $this->_resultCacheHash = $resultCacheHash; return $this; } public function clearResultCache() { $this->getResultCacheDriver() ->delete($this->getResultCacheHash()); return $this; } public function useQueryCache($driver = true, $timeToLive = null) { if ($driver !== null && $driver !== true && $driver !== false && ! ($driver instanceOf Doctrine_Cache_Interface)) { $msg = 'First argument should be instance of Doctrine_Cache_Interface or null.'; throw new Doctrine_Query_Exception($msg); } $this->_queryCache = $driver; if ($timeToLive !== null) { $this->setQueryCacheLifeSpan($timeToLive); } return $this; } public function expireResultCache($expire = true) { $this->_expireResultCache = $expire; return $this; } public function expireQueryCache($expire = true) { $this->_expireQueryCache = $expire; return $this; } public function setResultCacheLifeSpan($timeToLive) { if ($timeToLive !== null) { $timeToLive = (int) $timeToLive; } $this->_resultCacheTTL = $timeToLive; return $this; } public function getResultCacheLifeSpan() { return $this->_resultCacheTTL; } public function setQueryCacheLifeSpan($timeToLive) { if ($timeToLive !== null) { $timeToLive = (int) $timeToLive; } $this->_queryCacheTTL = $timeToLive; return $this; } public function getQueryCacheLifeSpan() { return $this->_queryCacheTTL; } public function getResultCacheDriver() { if ($this->_resultCache instanceof Doctrine_Cache_Interface) { return $this->_resultCache; } else { return $this->_conn->getResultCacheDriver(); } } public function getQueryCacheDriver() { if ($this->_queryCache instanceof Doctrine_Cache_Interface) { return $this->_queryCache; } else { return $this->_conn->getQueryCacheDriver(); } } public function getConnection() { return $this->_conn; } protected function _hasDqlQueryPart($queryPartName) { return count($this->_dqlParts[$queryPartName]) > 0; } protected function _addDqlQueryPart($queryPartName, $queryPart, $append = false) { if ($queryPart === null) { throw new Doctrine_Query_Exception('Cannot define NULL as part of query when defining \'' . $queryPartName . '\'.'); } if ($append) { $this->_dqlParts[$queryPartName][] = $queryPart; } else { $this->_dqlParts[$queryPartName] = array($queryPart); } $this->_state = Doctrine_Query::STATE_DIRTY; return $this; } protected function _processDqlQueryPart($queryPartName, $queryParts) { $this->removeSqlQueryPart($queryPartName); if (is_array($queryParts) && ! empty($queryParts)) { foreach ($queryParts as $queryPart) { $parser = $this->_getParser($queryPartName); $sql = $parser->parse($queryPart); if (isset($sql)) { if ($queryPartName == 'limit' || $queryPartName == 'offset') { $this->setSqlQueryPart($queryPartName, $sql); } else { $this->addSqlQueryPart($queryPartName, $sql); } } } } } protected function _getParser($name) { if ( ! isset($this->_parsers[$name])) { $class = 'Doctrine_Query_' . ucwords(strtolower($name)); Doctrine_Core::autoload($class); if ( ! class_exists($class)) { throw new Doctrine_Query_Exception('Unknown parser ' . $name); } $this->_parsers[$name] = new $class($this, $this->_tokenizer); } return $this->_parsers[$name]; } abstract public function getSqlQuery($params = array()); abstract public function parseDqlQuery($query); public function __toString() { return $this->getDql(); } } class Doctrine_RawSql extends Doctrine_Query_Abstract { private $fields = array(); function __construct(Doctrine_Connection $connection = null, Doctrine_Hydrator_Abstract $hydrator = null) { parent::__construct($connection, $hydrator); $this->useQueryCache(false); } protected function clear() { $this->_preQuery = false; $this->_pendingJoinConditions = array(); } public function parseDqlQueryPart($queryPartName, $queryPart, $append = false) { if ($queryPartName == 'select') { $this->_parseSelectFields($queryPart); return $this; } if ( ! isset($this->_sqlParts[$queryPartName])) { $this->_sqlParts[$queryPartName] = array(); } if ( ! $append) { $this->_sqlParts[$queryPartName] = array($queryPart); } else { $this->_sqlParts[$queryPartName][] = $queryPart; } return $this; } protected function _addDqlQueryPart($queryPartName, $queryPart, $append = false) { return $this->parseDqlQueryPart($queryPartName, $queryPart, $append); } private function _parseSelectFields($queryPart) { preg_match_all('/{([^}{]*)}/U', $queryPart, $m); $this->fields = $m[1]; $this->_sqlParts['select'] = array(); } public function parseDqlQuery($query) { $this->_parseSelectFields($query); $this->clear(); $tokens = $this->_tokenizer->sqlExplode($query, ' '); $parts = array(); foreach ($tokens as $key => $part) { $partLowerCase = strtolower($part); switch ($partLowerCase) { case 'select': case 'from': case 'where': case 'limit': case 'offset': case 'having': $type = $partLowerCase; if ( ! isset($parts[$partLowerCase])) { $parts[$partLowerCase] = array(); } break; case 'order': case 'group': $i = $key + 1; if (isset($tokens[$i]) && strtolower($tokens[$i]) === 'by') { $type = $partLowerCase . 'by'; $parts[$type] = array(); } else { $parts[$type][] = $part; } break; case 'by': continue; default: if ( ! isset($parts[$type][0])) { $parts[$type][0] = $part; } else { $parts[$type][0] .= ' '.$part; } } } $this->_sqlParts = $parts; $this->_sqlParts['select'] = array(); return $this; } public function getSqlQuery($params = array()) { $this->_params['exec'] = $params; $this->_execParams = $this->getFlattenedParams(); $this->fixArrayParameterValues($this->_execParams); $select = array(); $formatter = $this->getConnection()->formatter; foreach ($this->fields as $field) { $e = explode('.', $field); if ( ! isset($e[1])) { throw new Doctrine_RawSql_Exception('All selected fields in Sql query must be in format tableAlias.fieldName'); } if ( ! $this->hasSqlTableAlias($e[0])) { try { $this->addComponent($e[0], ucwords($e[0])); } catch (Doctrine_Exception $exception) { throw new Doctrine_RawSql_Exception('The associated component for table alias ' . $e[0] . ' couldn\'t be found.'); } } $componentAlias = $this->getComponentAlias($e[0]); if ($e[1] == '*') { foreach ($this->_queryComponents[$componentAlias]['table']->getColumnNames() as $name) { $field = $formatter->quoteIdentifier($e[0]) . '.' . $formatter->quoteIdentifier($name); $select[$componentAlias][$field] = $field . ' AS ' . $formatter->quoteIdentifier($e[0] . '__' . $name); } } else { $field = $formatter->quoteIdentifier($e[0]) . '.' . $formatter->quoteIdentifier($e[1]); $select[$componentAlias][$field] = $field . ' AS ' . $formatter->quoteIdentifier($e[0] . '__' . $e[1]); } } if ( ! isset($this->_sqlParts['distinct']) || $this->_sqlParts['distinct'] != true) { foreach ($this->getTableAliasMap() as $tableAlias => $componentAlias) { $map = $this->_queryComponents[$componentAlias]; foreach ((array) $map['table']->getIdentifierColumnNames() as $key) { $field = $formatter->quoteIdentifier($tableAlias) . '.' . $formatter->quoteIdentifier($key); if ( ! isset($this->_sqlParts['select'][$field])) { $select[$componentAlias][$field] = $field . ' AS ' . $formatter->quoteIdentifier($tableAlias . '__' . $key); } } } } $q = 'SELECT '; if (isset($this->_sqlParts['distinct']) && $this->_sqlParts['distinct'] == true) { $q .= 'DISTINCT '; } reset($this->_queryComponents); $componentAlias = key($this->_queryComponents); $this->_rootAlias = $componentAlias; $q .= implode(', ', $select[$componentAlias]); unset($select[$componentAlias]); foreach ($select as $component => $fields) { if ( ! empty($fields)) { $q .= ', ' . implode(', ', $fields); } } $string = $this->getInheritanceCondition($this->getRootAlias()); if ( ! empty($string)) { $this->_sqlParts['where'][] = $string; } $q .= ( ! empty($this->_sqlParts['from']))? ' FROM ' . implode(' ', $this->_sqlParts['from']) : ''; $q .= ( ! empty($this->_sqlParts['where']))? ' WHERE ' . implode(' AND ', $this->_sqlParts['where']) : ''; $q .= ( ! empty($this->_sqlParts['groupby']))? ' GROUP BY ' . implode(', ', $this->_sqlParts['groupby']) : ''; $q .= ( ! empty($this->_sqlParts['having']))? ' HAVING ' . implode(' AND ', $this->_sqlParts['having']) : ''; $q .= ( ! empty($this->_sqlParts['orderby']))? ' ORDER BY ' . implode(', ', $this->_sqlParts['orderby']) : ''; $q .= ( ! empty($this->_sqlParts['limit']))? ' LIMIT ' . implode(' ', $this->_sqlParts['limit']) : ''; $q .= ( ! empty($this->_sqlParts['offset']))? ' OFFSET ' . implode(' ', $this->_sqlParts['offset']) : ''; if ( ! empty($string)) { array_pop($this->_sqlParts['where']); } return $q; } public function getCountSqlQuery($params = array()) { reset($this->_queryComponents); $componentAlias = key($this->_queryComponents); $this->_rootAlias = $componentAlias; $tableAlias = $this->getSqlTableAlias($componentAlias); $fields = array(); foreach ((array) $this->_queryComponents[$componentAlias]['table']->getIdentifierColumnNames() as $key) { $fields[] = $tableAlias . '.' . $key; } $q = 'SELECT COUNT(*) as num_results FROM (SELECT DISTINCT '.implode(', ',$fields); $string = $this->getInheritanceCondition($this->getRootAlias()); if ( ! empty($string)) { $this->_sqlParts['where'][] = $string; } $q .= ( ! empty($this->_sqlParts['from']))? ' FROM ' . implode(' ', $this->_sqlParts['from']) : ''; $q .= ( ! empty($this->_sqlParts['where']))? ' WHERE ' . implode(' AND ', $this->_sqlParts['where']) : ''; $q .= ( ! empty($this->_sqlParts['groupby']))? ' GROUP BY ' . implode(', ', $this->_sqlParts['groupby']) : ''; $q .= ( ! empty($this->_sqlParts['having']))? ' HAVING ' . implode(' AND ', $this->_sqlParts['having']) : ''; $q .= ') as results'; if ( ! empty($string)) { array_pop($this->_sqlParts['where']); } return $q; } public function count($params = array()) { $sql = $this->getCountSqlQuery(); $params = $this->getCountQueryParams($params); $results = $this->getConnection()->fetchAll($sql, $params); if (count($results) > 1) { $count = count($results); } else { if (isset($results[0])) { $results[0] = array_change_key_case($results[0], CASE_LOWER); $count = $results[0]['num_results']; } else { $count = 0; } } return (int) $count; } public function getFields() { return $this->fields; } public function addComponent($tableAlias, $path) { $tmp = explode(' ', $path); $originalAlias = (count($tmp) > 1) ? end($tmp) : null; $e = explode('.', $tmp[0]); $fullPath = $tmp[0]; $fullLength = strlen($fullPath); $table = null; $currPath = ''; if (isset($this->_queryComponents[$e[0]])) { $table = $this->_queryComponents[$e[0]]['table']; $currPath = $parent = array_shift($e); } foreach ($e as $k => $component) { $length = strlen($currPath); $currPath = ($currPath) ? $currPath . '.' . $component : $component; $delimeter = substr($fullPath, $length, 1); if (strlen($currPath) === $fullLength && isset($originalAlias)) { $componentAlias = $originalAlias; } else { $componentAlias = $currPath; } if ( ! isset($table)) { $conn = Doctrine_Manager::getInstance() ->getConnectionForComponent($component); $table = $conn->getTable($component); $this->_queryComponents[$componentAlias] = array('table' => $table); } else { $relation = $table->getRelation($component); $this->_queryComponents[$componentAlias] = array('table' => $relation->getTable(), 'parent' => $parent, 'relation' => $relation); } $this->addSqlTableAlias($tableAlias, $componentAlias); $parent = $currPath; } return $this; } public function calculateResultCacheHash($params = array()) { $sql = $this->getSqlQuery(); $conn = $this->getConnection(); $params = $this->getFlattenedParams($params); $hash = md5($this->_hydrator->getHydrationMode() . $conn->getName() . $conn->getOption('dsn') . $sql . var_export($params, true)); return $hash; } } class Doctrine_View { const DROP = 'DROP VIEW %s'; const CREATE = 'CREATE VIEW %s AS %s'; const SELECT = 'SELECT * FROM %s'; protected $_name; protected $_query; protected $_conn; protected $_dql; protected $_sql; public function __construct(Doctrine_Query $query, $viewName) { $this->_name = $viewName; $this->_query = $query; $this->_query->setView($this); $this->_conn = $query->getConnection(); $this->_dql = $query->getDql(); $this->_sql = $query->getSqlQuery(); } public function getQuery() { return $this->_query; } public function getName() { return $this->_name; } public function getConnection() { return $this->_conn; } public function create() { $sql = sprintf(self::CREATE, $this->_name, $this->_query->getSqlQuery()); try { $this->_conn->execute($sql, $this->_query->getFlattenedParams()); } catch(Doctrine_Exception $e) { throw new Doctrine_View_Exception($e->__toString()); } } public function drop() { try { $this->_conn->execute(sprintf(self::DROP, $this->_name)); } catch(Doctrine_Exception $e) { throw new Doctrine_View_Exception($e->__toString()); } } public function execute() { return $this->_query->execute(); } public function getSelectSql() { return sprintf(self::SELECT, $this->_name); } public function getViewSql() { return $this->_sql; } public function getViewDql() { return $this->_dql; } }class Doctrine_Expression { protected $_expression; protected $_conn; protected $_tokenizer; public function __construct($expr, $conn = null) { if ($conn !== null) { $this->_conn = $conn; } $this->_tokenizer = new Doctrine_Query_Tokenizer(); $this->setExpression($expr); } public function getConnection() { if ( ! isset($this->_conn)) { return Doctrine_Manager::connection(); } return $this->_conn; } public function setExpression($clause) { $this->_expression = $this->parseClause($clause); } public function parseExpression($expr) { $pos = strpos($expr, '('); $quoted = (substr($expr, 0, 1) === "'" && substr($expr, -1) === "'"); if ($pos === false || $quoted) { return $expr; } $name = substr($expr, 0, $pos); $argStr = substr($expr, ($pos + 1), -1); foreach ($this->_tokenizer->bracketExplode($argStr, ',') as $arg) { $args[] = $this->parseClause($arg); } return call_user_func_array(array($this->getConnection()->expression, $name), $args); } public function parseClause($clause) { $e = $this->_tokenizer->bracketExplode($clause, ' '); foreach ($e as $k => $expr) { $e[$k] = $this->parseExpression($expr); } return implode(' ', $e); } public function getSql() { return $this->_expression; } public function __toString() { return $this->getSql(); } }class Doctrine_Hook { protected $query; protected $joins; protected $hooks = array( 'where', 'orderby', 'limit', 'offset' ); protected $fieldParsers = array(); protected $typeParsers = array( 'char' => 'Doctrine_Hook_WordLike', 'string' => 'Doctrine_Hook_WordLike', 'varchar' => 'Doctrine_Hook_WordLike', 'integer' => 'Doctrine_Hook_Integer', 'enum' => 'Doctrine_Hook_Integer', 'time' => 'Doctrine_Hook_Time', 'date' => 'Doctrine_Hook_Date', ); public function __construct($query) { if (is_string($query)) { $this->query = Doctrine_Query::create(); $this->query->parseDqlQuery($query); } elseif ($query instanceof Doctrine_Query) { $this->query = $query; } else { throw new Doctrine_Exception('Constructor argument should be either Doctrine_Query object or valid DQL query'); } $this->query->getSqlQuery(); } public function getQuery() { return $this->query; } public function setTypeParser($type, $parser) { $this->typeParsers[$type] = $parser; } public function setFieldParser($field, $parser) { $this->fieldParsers[$field] = $parser; } public function hookWhere($params) { if ( ! is_array($params)) { return false; } foreach ($params as $name => $value) { if ($value === '' || $value === '-') { continue; } $e = explode('.', $name); if (count($e) == 2) { list($alias, $column) = $e; $map = $this->query->getQueryComponent($alias); $table = $map['table']; if ( ! $table) { throw new Doctrine_Exception('Unknown alias ' . $alias); } if ($def = $table->getDefinitionOf($column)) { $def[0] = gettype($value); if (isset($this->typeParsers[$def[0]])) { $name = $this->typeParsers[$def[0]]; $parser = new $name; } $parser->parse($alias, $column, $value); $this->query->addWhere($parser->getCondition(), $parser->getParams()); } } } return true; } public function hookOrderby($params) { if ( ! is_array($params)) { return false; } foreach ($params as $name) { $e = explode(' ', $name); $order = 'ASC'; if (count($e) > 1) { $order = ($e[1] == 'DESC') ? 'DESC' : 'ASC'; } $e = explode('.', $e[0]); if (count($e) == 2) { list($alias, $column) = $e; $map = $this->query->getQueryComponent($alias); $table = $map['table']; if ($def = $table->getDefinitionOf($column)) { $this->query->addOrderBy($alias . '.' . $column . ' ' . $order); } } } return true; } public function hookLimit($limit) { $this->query->limit((int) $limit); } public function hookOffset($offset) { $this->query->offset((int) $offset); } } abstract class Doctrine_Configurable extends Doctrine_Locator_Injectable { protected $attributes = array(); protected $parent; protected $_impl = array(); protected $_params = array(); public function setAttribute($attribute, $value) { switch ($attribute) { case Doctrine_Core::ATTR_LISTENER: $this->setEventListener($value); break; case Doctrine_Core::ATTR_COLL_KEY: if ( ! ($this instanceof Doctrine_Table)) { throw new Doctrine_Exception("This attribute can only be set at table level."); } if ($value !== null && ! $this->hasField($value)) { throw new Doctrine_Exception("Couldn't set collection key attribute. No such field '$value'."); } break; case Doctrine_Core::ATTR_CACHE: case Doctrine_Core::ATTR_RESULT_CACHE: case Doctrine_Core::ATTR_QUERY_CACHE: if ($value !== null) { if ( ! ($value instanceof Doctrine_Cache_Interface)) { throw new Doctrine_Exception('Cache driver should implement Doctrine_Cache_Interface'); } } break; case Doctrine_Core::ATTR_SEQCOL_NAME: if ( ! is_string($value)) { throw new Doctrine_Exception('Sequence column name attribute only accepts string values'); } break; case Doctrine_Core::ATTR_FIELD_CASE: if ($value != 0 && $value != CASE_LOWER && $value != CASE_UPPER) throw new Doctrine_Exception('Field case attribute should be either 0, CASE_LOWER or CASE_UPPER constant.'); break; case Doctrine_Core::ATTR_SEQNAME_FORMAT: case Doctrine_Core::ATTR_IDXNAME_FORMAT: case Doctrine_Core::ATTR_TBLNAME_FORMAT: case Doctrine_Core::ATTR_FKNAME_FORMAT: if ($this instanceof Doctrine_Table) { throw new Doctrine_Exception('Sequence / index name format attributes cannot be set' . 'at table level (only at connection or global level).'); } break; } $this->attributes[$attribute] = $value; } public function getParams($namespace = null) { if ($namespace == null) { $namespace = $this->getAttribute(Doctrine_Core::ATTR_DEFAULT_PARAM_NAMESPACE); } if ( ! isset($this->_params[$namespace])) { return null; } return $this->_params[$namespace]; } public function getParamNamespaces() { return array_keys($this->_params); } public function setParam($name, $value, $namespace = null) { if ($namespace == null) { $namespace = $this->getAttribute(Doctrine_Core::ATTR_DEFAULT_PARAM_NAMESPACE); } $this->_params[$namespace][$name] = $value; return $this; } public function getParam($name, $namespace = null) { if ($namespace == null) { $namespace = $this->getAttribute(Doctrine_Core::ATTR_DEFAULT_PARAM_NAMESPACE); } if ( ! isset($this->_params[$namespace][$name])) { if (isset($this->parent)) { return $this->parent->getParam($name, $namespace); } return null; } return $this->_params[$namespace][$name]; } public function setImpl($template, $class) { $this->_impl[$template] = $class; return $this; } public function getImpl($template) { if ( ! isset($this->_impl[$template])) { if (isset($this->parent)) { return $this->parent->getImpl($template); } return null; } return $this->_impl[$template]; } public function hasImpl($template) { if ( ! isset($this->_impl[$template])) { if (isset($this->parent)) { return $this->parent->hasImpl($template); } return false; } return true; } public function setEventListener($listener) { return $this->setListener($listener); } public function addRecordListener($listener, $name = null) { if ( ! isset($this->attributes[Doctrine_Core::ATTR_RECORD_LISTENER]) || ! ($this->attributes[Doctrine_Core::ATTR_RECORD_LISTENER] instanceof Doctrine_Record_Listener_Chain)) { $this->attributes[Doctrine_Core::ATTR_RECORD_LISTENER] = new Doctrine_Record_Listener_Chain(); } $this->attributes[Doctrine_Core::ATTR_RECORD_LISTENER]->add($listener, $name); return $this; } public function getRecordListener() { if ( ! isset($this->attributes[Doctrine_Core::ATTR_RECORD_LISTENER])) { if (isset($this->parent)) { return $this->parent->getRecordListener(); } return null; } return $this->attributes[Doctrine_Core::ATTR_RECORD_LISTENER]; } public function setRecordListener($listener) { if ( ! ($listener instanceof Doctrine_Record_Listener_Interface) && ! ($listener instanceof Doctrine_Overloadable) ) { throw new Doctrine_Exception("Couldn't set eventlistener. Record listeners should implement either Doctrine_Record_Listener_Interface or Doctrine_Overloadable"); } $this->attributes[Doctrine_Core::ATTR_RECORD_LISTENER] = $listener; return $this; } public function addListener($listener, $name = null) { if ( ! isset($this->attributes[Doctrine_Core::ATTR_LISTENER]) || ! ($this->attributes[Doctrine_Core::ATTR_LISTENER] instanceof Doctrine_EventListener_Chain)) { $this->attributes[Doctrine_Core::ATTR_LISTENER] = new Doctrine_EventListener_Chain(); } $this->attributes[Doctrine_Core::ATTR_LISTENER]->add($listener, $name); return $this; } public function getListener() { if ( ! isset($this->attributes[Doctrine_Core::ATTR_LISTENER])) { if (isset($this->parent)) { return $this->parent->getListener(); } return null; } return $this->attributes[Doctrine_Core::ATTR_LISTENER]; } public function setListener($listener) { if ( ! ($listener instanceof Doctrine_EventListener_Interface) && ! ($listener instanceof Doctrine_Overloadable) ) { throw new Doctrine_EventListener_Exception("Couldn't set eventlistener. EventListeners should implement either Doctrine_EventListener_Interface or Doctrine_Overloadable"); } $this->attributes[Doctrine_Core::ATTR_LISTENER] = $listener; return $this; } public function getAttribute($attribute) { if (isset($this->attributes[$attribute])) { return $this->attributes[$attribute]; } if (isset($this->parent)) { return $this->parent->getAttribute($attribute); } return null; } public function unsetAttribute($attribute) { if (isset($this->attributes[$attribute])) { unset($this->attributes[$attribute]); } } public function getAttributes() { return $this->attributes; } public function setCharset($charset) { $this->setAttribute(Doctrine_Core::ATTR_DEFAULT_TABLE_CHARSET, $charset); } public function getCharset() { return $this->getAttribute(Doctrine_Core::ATTR_DEFAULT_TABLE_CHARSET); } public function setCollate($collate) { $this->setAttribute(Doctrine_Core::ATTR_DEFAULT_TABLE_COLLATE, $collate); } public function getCollate() { return $this->getAttribute(Doctrine_Core::ATTR_DEFAULT_TABLE_COLLATE); } public function setParent(Doctrine_Configurable $component) { $this->parent = $component; } public function getParent() { return $this->parent; } }abstract class Doctrine_Connection extends Doctrine_Configurable implements Countable, IteratorAggregate, Serializable { protected $dbh; protected $tables = array(); protected $prefix = ""; protected $_name; protected $driverName; protected $isConnected = false; protected $supported = array(); protected $pendingAttributes = array(); private $modules = array('transaction' => false, 'expression' => false, 'dataDict' => false, 'export' => false, 'import' => false, 'sequence' => false, 'unitOfWork' => false, 'formatter' => false, 'util' => false, ); protected $properties = array('sql_comments' => array(array('start' => '--', 'end' => "\n", 'escape' => false), array('start' => '/*', 'end' => '*/', 'escape' => false)), 'identifier_quoting' => array('start' => '"', 'end' => '"','escape' => '"'), 'string_quoting' => array('start' => "'", 'end' => "'", 'escape' => false, 'escape_pattern' => false), 'wildcards' => array('%', '_'), 'varchar_max_length' => 255, 'sql_file_delimiter' => ";\n", 'max_identifier_length' => 64, ); protected $serverInfo = array(); protected $options = array(); private static $supportedDrivers = array( 'Mysql', 'Pgsql', 'Oracle', 'Mssql', 'Sqlite', ); protected $_count = 0; protected $_usedNames = array( 'foreign_keys' => array(), 'indexes' => array() ); public function __construct(Doctrine_Manager $manager, $adapter, $user = null, $pass = null) { if (is_object($adapter)) { if ( ! ($adapter instanceof PDO) && ! in_array('Doctrine_Adapter_Interface', class_implements($adapter))) { throw new Doctrine_Connection_Exception('First argument should be an instance of PDO or implement Doctrine_Adapter_Interface'); } $this->dbh = $adapter; $this->isConnected = true; } else if (is_array($adapter)) { $this->pendingAttributes[Doctrine_Core::ATTR_DRIVER_NAME] = $adapter['scheme']; $this->options['dsn'] = $adapter['dsn']; $this->options['username'] = $adapter['user']; $this->options['password'] = $adapter['pass']; $this->options['other'] = array(); if (isset($adapter['other'])) { $this->options['other'] = array(Doctrine_Core::ATTR_PERSISTENT => $adapter['persistent']); } } $this->setParent($manager); $this->setAttribute(Doctrine_Core::ATTR_CASE, Doctrine_Core::CASE_NATURAL); $this->setAttribute(Doctrine_Core::ATTR_ERRMODE, Doctrine_Core::ERRMODE_EXCEPTION); $this->getAttribute(Doctrine_Core::ATTR_LISTENER)->onOpen($this); } public function isConnected() { return $this->isConnected; } public function getOptions() { return $this->options; } public function getPrefix() { return $this->prefix; } public function getOption($option) { if (isset($this->options[$option])) { return $this->options[$option]; } } public function setOption($option, $value) { return $this->options[$option] = $value; } public function setPrefix($prefix) { $this->prefix = $prefix; } public function getAttribute($attribute) { if ($attribute >= 100 && $attribute < 1000) { if ( ! isset($this->attributes[$attribute])) { return parent::getAttribute($attribute); } return $this->attributes[$attribute]; } if ($this->isConnected) { try { return $this->dbh->getAttribute($attribute); } catch (Exception $e) { throw new Doctrine_Connection_Exception('Attribute ' . $attribute . ' not found.'); } } else { if ( ! isset($this->pendingAttributes[$attribute])) { $this->connect(); $this->getAttribute($attribute); } return $this->pendingAttributes[$attribute]; } } public static function getAvailableDrivers() { return PDO::getAvailableDrivers(); } public static function getSupportedDrivers() { return self::$supportedDrivers; } public function setAttribute($attribute, $value) { if ($attribute >= 100 && $attribute < 1000) { parent::setAttribute($attribute, $value); } else { if ($this->isConnected) { $this->dbh->setAttribute($attribute, $value); } else { $this->pendingAttributes[$attribute] = $value; } } return $this; } public function getName() { return $this->_name; } public function setName($name) { $this->_name = $name; } public function getDriverName() { return $this->driverName; } public function __get($name) { if (isset($this->properties[$name])) { return $this->properties[$name]; } if ( ! isset($this->modules[$name])) { throw new Doctrine_Connection_Exception('Unknown module / property ' . $name); } if ($this->modules[$name] === false) { switch ($name) { case 'unitOfWork': $this->modules[$name] = new Doctrine_Connection_UnitOfWork($this); break; case 'formatter': $this->modules[$name] = new Doctrine_Formatter($this); break; default: $class = 'Doctrine_' . ucwords($name) . '_' . $this->getDriverName(); $this->modules[$name] = new $class($this); } } return $this->modules[$name]; } public function getManager() { return $this->getParent(); } public function getDbh() { $this->connect(); return $this->dbh; } public function connect() { if ($this->isConnected) { return false; } $event = new Doctrine_Event($this, Doctrine_Event::CONN_CONNECT); $this->getListener()->preConnect($event); $e = explode(':', $this->options['dsn']); $found = false; if (extension_loaded('pdo')) { if (in_array($e[0], self::getAvailableDrivers())) { try { $this->dbh = new PDO($this->options['dsn'], $this->options['username'], (!$this->options['password'] ? '':$this->options['password']), $this->options['other']); $this->dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); } catch (PDOException $e) { throw new Doctrine_Connection_Exception('PDO Connection Error: ' . $e->getMessage()); } $found = true; } } if ( ! $found) { $class = 'Doctrine_Adapter_' . ucwords($e[0]); if (class_exists($class)) { $this->dbh = new $class($this->options['dsn'], $this->options['username'], $this->options['password'], $this->options); } else { throw new Doctrine_Connection_Exception("Couldn't locate driver named " . $e[0]); } } foreach($this->pendingAttributes as $attr => $value) { if ($attr == Doctrine_Core::ATTR_DRIVER_NAME) { continue; } $this->dbh->setAttribute($attr, $value); } $this->isConnected = true; $this->getListener()->postConnect($event); return true; } public function incrementQueryCount() { $this->_count++; } public function driverName($name) { } public function supports($feature) { return (isset($this->supported[$feature]) && ($this->supported[$feature] === 'emulated' || $this->supported[$feature])); } public function replace(Doctrine_Table $table, array $fields, array $keys) { if (empty($keys)) { throw new Doctrine_Connection_Exception('Not specified which fields are keys'); } $identifier = (array) $table->getIdentifier(); $condition = array(); foreach ($fields as $fieldName => $value) { if (in_array($fieldName, $keys)) { if ($value !== null) { $condition[] = $table->getColumnName($fieldName) . ' = ?'; $conditionValues[] = $value; } } } $affectedRows = 0; if ( ! empty($condition) && ! empty($conditionValues)) { $query = 'DELETE FROM ' . $this->quoteIdentifier($table->getTableName()) . ' WHERE ' . implode(' AND ', $condition); $affectedRows = $this->exec($query, $conditionValues); } $this->insert($table, $fields); $affectedRows++; return $affectedRows; } public function delete(Doctrine_Table $table, array $identifier) { $tmp = array(); foreach (array_keys($identifier) as $id) { $tmp[] = $this->quoteIdentifier($table->getColumnName($id)) . ' = ?'; } $query = 'DELETE FROM ' . $this->quoteIdentifier($table->getTableName()) . ' WHERE ' . implode(' AND ', $tmp); return $this->exec($query, array_values($identifier)); } public function update(Doctrine_Table $table, array $fields, array $identifier) { if (empty($fields)) { return false; } $set = array(); foreach ($fields as $fieldName => $value) { if ($value instanceof Doctrine_Expression) { $set[] = $this->quoteIdentifier($table->getColumnName($fieldName)) . ' = ' . $value->getSql(); unset($fields[$fieldName]); } else { $set[] = $this->quoteIdentifier($table->getColumnName($fieldName)) . ' = ?'; } } $params = array_merge(array_values($fields), array_values($identifier)); $sql = 'UPDATE ' . $this->quoteIdentifier($table->getTableName()) . ' SET ' . implode(', ', $set) . ' WHERE ' . implode(' = ? AND ', $this->quoteMultipleIdentifier($table->getIdentifierColumnNames())) . ' = ?'; return $this->exec($sql, $params); } public function insert(Doctrine_Table $table, array $fields) { $tableName = $table->getTableName(); $cols = array(); $a = array(); foreach ($fields as $fieldName => $value) { $cols[] = $this->quoteIdentifier($table->getColumnName($fieldName)); if ($value instanceof Doctrine_Expression) { $a[] = $value->getSql(); unset($fields[$fieldName]); } else { $a[] = '?'; } } $query = 'INSERT INTO ' . $this->quoteIdentifier($tableName) . ' (' . implode(', ', $cols) . ')' . ' VALUES (' . implode(', ', $a) . ')'; return $this->exec($query, array_values($fields)); } public function quoteIdentifier($str, $checkOption = true) { if (strpos($str, '.')) { $e = explode('.', $str); return $this->formatter->quoteIdentifier($e[0], $checkOption) . '.' . $this->formatter->quoteIdentifier($e[1], $checkOption); } return $this->formatter->quoteIdentifier($str, $checkOption); } public function quoteMultipleIdentifier($arr, $checkOption = true) { foreach ($arr as $k => $v) { $arr[$k] = $this->quoteIdentifier($v, $checkOption); } return $arr; } public function convertBooleans($item) { return $this->formatter->convertBooleans($item); } public function quote($input, $type = null) { return $this->formatter->quote($input, $type); } public function setDateFormat($format = null) { } public function fetchAll($statement, array $params = array()) { return $this->execute($statement, $params)->fetchAll(Doctrine_Core::FETCH_ASSOC); } public function fetchOne($statement, array $params = array(), $colnum = 0) { return $this->execute($statement, $params)->fetchColumn($colnum); } public function fetchRow($statement, array $params = array()) { return $this->execute($statement, $params)->fetch(Doctrine_Core::FETCH_ASSOC); } public function fetchArray($statement, array $params = array()) { return $this->execute($statement, $params)->fetch(Doctrine_Core::FETCH_NUM); } public function fetchColumn($statement, array $params = array(), $colnum = 0) { return $this->execute($statement, $params)->fetchAll(Doctrine_Core::FETCH_COLUMN, $colnum); } public function fetchAssoc($statement, array $params = array()) { return $this->execute($statement, $params)->fetchAll(Doctrine_Core::FETCH_ASSOC); } public function fetchBoth($statement, array $params = array()) { return $this->execute($statement, $params)->fetchAll(Doctrine_Core::FETCH_BOTH); } public function query($query, array $params = array(), $hydrationMode = null) { $parser = Doctrine_Query::create($this); $res = $parser->query($query, $params, $hydrationMode); $parser->free(); return $res; } public function prepare($statement) { $this->connect(); try { $event = new Doctrine_Event($this, Doctrine_Event::CONN_PREPARE, $statement); $this->getAttribute(Doctrine_Core::ATTR_LISTENER)->prePrepare($event); $stmt = false; if ( ! $event->skipOperation) { $stmt = $this->dbh->prepare($statement); } $this->getAttribute(Doctrine_Core::ATTR_LISTENER)->postPrepare($event); return new Doctrine_Connection_Statement($this, $stmt); } catch(Doctrine_Adapter_Exception $e) { } catch(PDOException $e) { } $this->rethrowException($e, $this, $statement); } public function queryOne($query, array $params = array()) { $parser = Doctrine_Query::create(); $coll = $parser->query($query, $params); if ( ! $coll->contains(0)) { return false; } return $coll[0]; } public function select($query, $limit = 0, $offset = 0) { if ($limit > 0 || $offset > 0) { $query = $this->modifyLimitQuery($query, $limit, $offset); } return $this->execute($query); } public function standaloneQuery($query, $params = array()) { return $this->execute($query, $params); } public function execute($query, array $params = array()) { $this->connect(); try { if ( ! empty($params)) { $stmt = $this->prepare($query); $stmt->execute($params); return $stmt; } else { $event = new Doctrine_Event($this, Doctrine_Event::CONN_QUERY, $query, $params); $this->getAttribute(Doctrine_Core::ATTR_LISTENER)->preQuery($event); if ( ! $event->skipOperation) { $stmt = $this->dbh->query($query); $this->_count++; } $this->getAttribute(Doctrine_Core::ATTR_LISTENER)->postQuery($event); return $stmt; } } catch (Doctrine_Adapter_Exception $e) { } catch (PDOException $e) { } $this->rethrowException($e, $this, $query); } public function exec($query, array $params = array()) { $this->connect(); try { if ( ! empty($params)) { $stmt = $this->prepare($query); $stmt->execute($params); return $stmt->rowCount(); } else { $event = new Doctrine_Event($this, Doctrine_Event::CONN_EXEC, $query, $params); $this->getAttribute(Doctrine_Core::ATTR_LISTENER)->preExec($event); if ( ! $event->skipOperation) { $count = $this->dbh->exec($query); $this->_count++; } $this->getAttribute(Doctrine_Core::ATTR_LISTENER)->postExec($event); return $count; } } catch (Doctrine_Adapter_Exception $e) { } catch (PDOException $e) { } $this->rethrowException($e, $this, $query); } public function rethrowException(Exception $e, $invoker, $query = null) { $event = new Doctrine_Event($this, Doctrine_Event::CONN_ERROR); $this->getListener()->preError($event); $name = 'Doctrine_Connection_' . $this->driverName . '_Exception'; $message = $e->getMessage(); if ($query) { $message .= sprintf('. Failing Query: "%s"', $query); } $exc = new $name($message, (int) $e->getCode()); if ( ! isset($e->errorInfo) || ! is_array($e->errorInfo)) { $e->errorInfo = array(null, null, null, null); } $exc->processErrorInfo($e->errorInfo); if ($this->getAttribute(Doctrine_Core::ATTR_THROW_EXCEPTIONS)) { throw $exc; } $this->getListener()->postError($event); } public function hasTable($name) { return isset($this->tables[$name]); } public function getTable($name) { if (isset($this->tables[$name])) { return $this->tables[$name]; } $class = sprintf($this->getAttribute(Doctrine_Core::ATTR_TABLE_CLASS_FORMAT), $name); if (class_exists($class, $this->getAttribute(Doctrine_Core::ATTR_AUTOLOAD_TABLE_CLASSES)) && in_array('Doctrine_Table', class_parents($class))) { $table = new $class($name, $this, true); } else { $tableClass = $this->getAttribute(Doctrine_Core::ATTR_TABLE_CLASS); $table = new $tableClass($name, $this, true); } return $table; } public function getTables() { return $this->tables; } public function getIterator() { return new ArrayIterator($this->tables); } public function count() { return $this->_count; } public function addTable(Doctrine_Table $table) { $name = $table->getComponentName(); if (isset($this->tables[$name])) { return false; } $this->tables[$name] = $table; return true; } public function create($name) { return $this->getTable($name)->create(); } public function createQuery() { return Doctrine_Query::create(); } public function flush() { try { $this->beginInternalTransaction(); $this->unitOfWork->saveAll(); $this->commit(); } catch (Exception $e) { $this->rollback(); throw $e; } } public function clear() { foreach ($this->tables as $k => $table) { $table->getRepository()->evictAll(); $table->clear(); } } public function evictTables() { $this->tables = array(); $this->exported = array(); } public function close() { $event = new Doctrine_Event($this, Doctrine_Event::CONN_CLOSE); $this->getAttribute(Doctrine_Core::ATTR_LISTENER)->preClose($event); $this->clear(); unset($this->dbh); $this->isConnected = false; $this->getAttribute(Doctrine_Core::ATTR_LISTENER)->postClose($event); } public function getTransactionLevel() { return $this->transaction->getTransactionLevel(); } public function errorCode() { $this->connect(); return $this->dbh->errorCode(); } public function errorInfo() { $this->connect(); return $this->dbh->errorInfo(); } public function getResultCacheDriver() { if ( ! $this->getAttribute(Doctrine_Core::ATTR_RESULT_CACHE)) { throw new Doctrine_Exception('Result Cache driver not initialized.'); } return $this->getAttribute(Doctrine_Core::ATTR_RESULT_CACHE); } public function getQueryCacheDriver() { if ( ! $this->getAttribute(Doctrine_Core::ATTR_QUERY_CACHE)) { throw new Doctrine_Exception('Query Cache driver not initialized.'); } return $this->getAttribute(Doctrine_Core::ATTR_QUERY_CACHE); } public function lastInsertId($table = null, $field = null) { return $this->sequence->lastInsertId($table, $field); } public function beginTransaction($savepoint = null) { return $this->transaction->beginTransaction($savepoint); } public function beginInternalTransaction($savepoint = null) { return $this->transaction->beginInternalTransaction($savepoint); } public function commit($savepoint = null) { return $this->transaction->commit($savepoint); } public function rollback($savepoint = null) { return $this->transaction->rollback($savepoint); } public function createDatabase() { if ( ! $dsn = $this->getOption('dsn')) { throw new Doctrine_Connection_Exception('You must create your Doctrine_Connection by using a valid Doctrine style dsn in order to use the create/drop database functionality'); } $info = $this->getManager()->parsePdoDsn($dsn); $tmpConnection = $this->getTmpConnection($info); try { $tmpConnection->export->createDatabase($info['dbname']); } catch (Exception $e) {} $this->getManager()->closeConnection($tmpConnection); if (isset($e)) { throw $e; } } public function dropDatabase() { if ( ! $dsn = $this->getOption('dsn')) { throw new Doctrine_Connection_Exception('You must create your Doctrine_Connection by using a valid Doctrine style dsn in order to use the create/drop database functionality'); } $info = $this->getManager()->parsePdoDsn($dsn); $tmpConnection = $this->getTmpConnection($info); try { $tmpConnection->export->dropDatabase($info['dbname']); } catch (Exception $e) {} $this->getManager()->closeConnection($tmpConnection); if (isset($e)) { throw $e; } } public function getTmpConnection($info) { $pdoDsn = $info['scheme'] . ':'; if ($info['unix_socket']) { $pdoDsn .= 'unix_socket=' . $info['unix_socket'] . ';'; } $pdoDsn .= 'host=' . $info['host']; if ($info['port']) { $pdoDsn .= ';port=' . $info['port']; } if (isset($this->export->tmpConnectionDatabase) && $this->export->tmpConnectionDatabase) { $pdoDsn .= ';dbname=' . $this->export->tmpConnectionDatabase; } $username = $this->getOption('username'); $password = $this->getOption('password'); $conn = $this->getManager()->openConnection(array($pdoDsn, $username, $password), 'doctrine_tmp_connection', false); $conn->setOption('username', $username); $conn->setOption('password', $password); return $conn; } public function modifyLimitQuery($query, $limit = false, $offset = false, $isManip = false) { return $query; } public function modifyLimitSubquery(Doctrine_Table $rootTable, $query, $limit = false, $offset = false, $isManip = false) { return $this->modifyLimitQuery($query, $limit, $offset, $isManip); } public function __toString() { return Doctrine_Lib::getConnectionAsString($this); } public function serialize() { $vars = get_object_vars($this); $vars['dbh'] = null; $vars['isConnected'] = false; return serialize($vars); } public function unserialize($serialized) { $array = unserialize($serialized); foreach ($array as $name => $values) { $this->$name = $values; } } public function generateUniqueRelationForeignKeyName(Doctrine_Relation $relation) { $parts = array( $relation['localTable']->getTableName(), $relation->getLocalColumnName(), $relation['table']->getTableName(), $relation->getForeignColumnName(), ); $key = implode('_', array_merge($parts, array($relation['onDelete']), array($relation['onUpdate']))); $format = $this->getAttribute(Doctrine_Core::ATTR_FKNAME_FORMAT); return $this->_generateUniqueName('foreign_keys', $parts, $key, $format, $this->getAttribute(Doctrine_Core::ATTR_MAX_IDENTIFIER_LENGTH)); } public function generateUniqueIndexName($tableName, $fields) { $fields = (array) $fields; $parts = array($tableName); $parts = array_merge($parts, $fields); $key = implode('_', $parts); $format = $this->getAttribute(Doctrine_Core::ATTR_IDXNAME_FORMAT); return $this->_generateUniqueName('indexes', $parts, $key, $format, $this->getAttribute(Doctrine_Core::ATTR_MAX_IDENTIFIER_LENGTH)); } protected function _generateUniqueName($type, $parts, $key, $format = '%s', $maxLength = null) { if (isset($this->_usedNames[$type][$key])) { return $this->_usedNames[$type][$key]; } if ($maxLength === null) { $maxLength = $this->properties['max_identifier_length']; } $generated = implode('_', $parts); if (strlen(sprintf($format, $generated)) > $maxLength) { $generated = ''; foreach ($parts as $part) { $generated .= $part[0]; } $name = $generated; } else { $name = $generated; } while (in_array($name, $this->_usedNames[$type])) { $e = explode('_', $name); $end = end($e); if (is_numeric($end)) { unset($e[count($e) - 1]); $fkName = implode('_', $e); $name = $fkName . '_' . ++$end; } else { $name .= '_1'; } } $this->_usedNames[$type][$key] = $name; return $name; } }class Doctrine_AuditLog extends Doctrine_Record_Generator { protected $_options = array('className' => '%CLASS%Version', 'version' => array('name' => 'version', 'alias' => null, 'type' => 'integer', 'length' => 8, 'options' => array('primary' => true)), 'tableName' => false, 'generateFiles' => false, 'table' => false, 'pluginTable' => false, 'children' => array(), 'auditLog' => true, 'deleteVersions' => true, 'cascadeDelete' => true, 'excludeFields' => array(), 'appLevelDelete' => false); public function __construct(array $options = array()) { $this->_options = Doctrine_Lib::arrayDeepMerge($this->_options, $options); } public function buildRelation() { $this->buildForeignRelation('Version'); $this->buildLocalRelation(); } public function setTableDefinition() { $name = $this->_options['table']->getComponentName(); $columns = $this->_options['table']->getColumns(); foreach ($columns as $column => $definition) { if (in_array($column, $this->_options['excludeFields'])) { continue; } unset($definition['autoincrement']); unset($definition['sequence']); unset($definition['unique']); $fieldName = $this->_options['table']->getFieldName($column); if ($fieldName != $column) { $name = $column . ' as ' . $fieldName; } else { $name = $fieldName; } $this->hasColumn($name, $definition['type'], $definition['length'], $definition); } $this->hasColumn( $this->_options['version']['name'], $this->_options['version']['type'], $this->_options['version']['length'], $this->_options['version']['options']); } public function getVersion(Doctrine_Record $record, $version, $hydrationMode = Doctrine_Core::HYDRATE_ARRAY, $asCollection = true) { $className = $this->_options['className']; $method = ($asCollection) ? 'execute' : 'fetchOne'; $q = Doctrine_Core::getTable($className) ->createQuery(); $values = array(); foreach ((array) $this->_options['table']->getIdentifier() as $id) { $conditions[] = $className . '.' . $id . ' = ?'; $values[] = $record->get($id); } $where = implode(' AND ', $conditions) . ' AND ' . $className . '.' . $this->_options['version']['name'] . ' = ?'; $values[] = $version; $q->where($where); return $q->$method($values, $hydrationMode); } public function getMaxVersion(Doctrine_Record $record) { $className = $this->_options['className']; $select = 'MAX(' . $className . '.' . $this->_options['version']['name'] . ') max_version'; foreach ((array) $this->_options['table']->getIdentifier() as $id) { $conditions[] = $className . '.' . $id . ' = ?'; $values[] = $record->get($id); } $q = Doctrine_Core::getTable($className) ->createQuery() ->select($select) ->where(implode(' AND ',$conditions)); $result = $q->execute($values, Doctrine_Core::HYDRATE_ARRAY); return isset($result[0]['max_version']) ? $result[0]['max_version']:0; } }abstract class Doctrine_Hydrator_Abstract extends Doctrine_Locator_Injectable { protected $_queryComponents = array(), $_tableAliases = array(), $_priorRow, $_hydrationMode; public function __construct($queryComponents = null, $tableAliases = null, $hydrationMode = null) { $this->setQueryComponents($queryComponents); $this->setTableAliases($tableAliases); $this->setHydrationMode($hydrationMode); } public function setQueryComponents($queryComponents) { $this->_queryComponents = $queryComponents; } public function setTableAliases($tableAliases) { $this->_tableAliases = $tableAliases; } public function setHydrationMode($hydrationMode) { $this->_hydrationMode = $hydrationMode; } public function getRootComponent() { $queryComponents = array_values($this->_queryComponents); return $queryComponents[0]['table']; } public function onDemandReset() { $this->_priorRow = null; } protected function _isIgnoredName($name) { return $name == 'DOCTRINE_ROWNUM'; } abstract public function hydrateResultSet($stmt); }class Doctrine_Hydrator_NoneDriver extends Doctrine_Hydrator_Abstract { public function hydrateResultSet($stmt) { return $stmt->fetchAll(PDO::FETCH_NUM); } }abstract class Doctrine_Hydrator_Graph extends Doctrine_Hydrator_Abstract { protected $_tables = array(); private static $i = 0; protected function _getCustomIndexField($alias) { return isset($this->_queryComponents[$alias]['map']) ? $this->_queryComponents[$alias]['map'] : null; } public function hydrateResultSet($stmt) { reset($this->_queryComponents); $rootAlias = key($this->_queryComponents); $this->_rootAlias = $rootAlias; $rootComponentName = $this->_queryComponents[$rootAlias]['table']->getComponentName(); $isSimpleQuery = count($this->_queryComponents) <= 1; $result = array(); $instances = array(); $listeners = array(); $identifierMap = array(); $prev = array(); $id = array(); $idTemplate = array(); foreach ($this->_queryComponents as $dqlAlias => $data) { $componentName = $data['table']->getComponentName(); $instances[$componentName] = $data['table']->getRecordInstance(); $listeners[$componentName] = $data['table']->getRecordListener(); $identifierMap[$dqlAlias] = array(); $prev[$dqlAlias] = null; $idTemplate[$dqlAlias] = ''; } $cache = array(); $result = $this->getElementCollection($rootComponentName); if ($result instanceof Doctrine_Collection && $indexField = $this->_getCustomIndexField($rootAlias)) { $result->setKeyColumn($indexField); } if ($stmt === false || $stmt === 0) { return $result; } $cache = array(); $event = new Doctrine_Event(null, Doctrine_Event::HYDRATE, null); if ($this->_hydrationMode == Doctrine_Core::HYDRATE_ON_DEMAND) { if ( ! is_null($this->_priorRow)) { $data = $this->_priorRow; $this->_priorRow = null; } else { $data = $stmt->fetch(Doctrine_Core::FETCH_ASSOC); if ( ! $data) { return $result; } } $activeRootIdentifier = null; } else { $data = $stmt->fetch(Doctrine_Core::FETCH_ASSOC); if ( ! $data) { return $result; } } do { $table = $this->_queryComponents[$rootAlias]['table']; if ($table->getConnection()->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_RTRIM) { array_map('rtrim', $data); } $id = $idTemplate; $nonemptyComponents = array(); $rowData = $this->_gatherRowData($data, $cache, $id, $nonemptyComponents); if ($this->_hydrationMode == Doctrine_Core::HYDRATE_ON_DEMAND) { if (is_null($activeRootIdentifier)) { $activeRootIdentifier = $id[$rootAlias]; } else if ($activeRootIdentifier != $id[$rootAlias]) { $this->_priorRow = $data; return $result; } } $componentName = $table->getComponentName(); $event->setInvoker($table); $event->set('data', $rowData[$rootAlias]); $listeners[$componentName]->preHydrate($event); $instances[$componentName]->preHydrate($event); $index = false; if ($isSimpleQuery || ! isset($identifierMap[$rootAlias][$id[$rootAlias]])) { $element = $this->getElement($rowData[$rootAlias], $componentName); $event->set('data', $element); $listeners[$componentName]->postHydrate($event); $instances[$componentName]->postHydrate($event); if ($field = $this->_getCustomIndexField($rootAlias)) { if ( ! isset($element[$field])) { throw new Doctrine_Hydrator_Exception("Couldn't hydrate. Found a non-existent key named '$field'."); } else if (isset($result[$element[$field]])) { throw new Doctrine_Hydrator_Exception("Couldn't hydrate. Found non-unique key mapping named '{$element[$field]}' for the field named '$field'."); } $result[$element[$field]] = $element; } else { $result[] = $element; } $identifierMap[$rootAlias][$id[$rootAlias]] = $this->getLastKey($result); } else { $index = $identifierMap[$rootAlias][$id[$rootAlias]]; } $this->setLastElement($prev, $result, $index, $rootAlias, false); unset($rowData[$rootAlias]); foreach ($rowData as $dqlAlias => $data) { $index = false; $map = $this->_queryComponents[$dqlAlias]; $table = $map['table']; $componentName = $table->getComponentName(); $event->set('data', $data); $event->setInvoker($table); $listeners[$componentName]->preHydrate($event); $instances[$componentName]->preHydrate($event); if ( ! isset($map['parent'])) { throw new Doctrine_Hydrator_Exception( '"' . $componentName . '" with an alias of "' . $dqlAlias . '"' . ' in your query does not reference the parent component it is related to.' ); } $parent = $map['parent']; $relation = $map['relation']; $relationAlias = $map['relation']->getAlias(); $path = $parent . '.' . $dqlAlias; if ( ! isset($prev[$parent])) { unset($prev[$dqlAlias]); continue; } $indexField = $this->_getCustomIndexField($dqlAlias); if ( ! $relation->isOneToOne() && $this->initRelated($prev[$parent], $relationAlias, $indexField)) { $oneToOne = false; if (isset($nonemptyComponents[$dqlAlias])) { $indexExists = isset($identifierMap[$path][$id[$parent]][$id[$dqlAlias]]); $index = $indexExists ? $identifierMap[$path][$id[$parent]][$id[$dqlAlias]] : false; $indexIsValid = $index !== false ? isset($prev[$parent][$relationAlias][$index]) : false; if ( ! $indexExists || ! $indexIsValid) { $element = $this->getElement($data, $componentName); $event->set('data', $element); $listeners[$componentName]->postHydrate($event); $instances[$componentName]->postHydrate($event); if ($field = $this->_getCustomIndexField($dqlAlias)) { if ( ! isset($element[$field])) { throw new Doctrine_Hydrator_Exception("Couldn't hydrate. Found a non-existent key named '$field'."); } else if (isset($prev[$parent][$relationAlias][$element[$field]])) { throw new Doctrine_Hydrator_Exception("Couldn't hydrate. Found non-unique key mapping named '$field'."); } $prev[$parent][$relationAlias][$element[$field]] = $element; } else { $prev[$parent][$relationAlias][] = $element; } $identifierMap[$path][$id[$parent]][$id[$dqlAlias]] = $this->getLastKey($prev[$parent][$relationAlias]); } $collection = $prev[$parent][$relationAlias]; if ($collection instanceof Doctrine_Collection && $indexField) { $collection->setKeyColumn($indexField); } $this->registerCollection($collection); } } else { $oneToOne = true; if ( ! isset($nonemptyComponents[$dqlAlias]) && ! isset($prev[$parent][$relationAlias])) { $prev[$parent][$relationAlias] = $this->getNullPointer(); } else if ( ! isset($prev[$parent][$relationAlias])) { $element = $this->getElement($data, $componentName); $event->set('data', $element); $listeners[$componentName]->postHydrate($event); $instances[$componentName]->postHydrate($event); $prev[$parent][$relationAlias] = $element; } } if ($prev[$parent][$relationAlias] !== null) { $coll =& $prev[$parent][$relationAlias]; $this->setLastElement($prev, $coll, $index, $dqlAlias, $oneToOne); } } } while ($data = $stmt->fetch(Doctrine_Core::FETCH_ASSOC)); $stmt->closeCursor(); $this->flush(); return $result; } protected function _gatherRowData(&$data, &$cache, &$id, &$nonemptyComponents) { $rowData = array(); foreach ($data as $key => $value) { if ( ! isset($cache[$key])) { if ($this->_isIgnoredName($key)) { continue; } $e = explode('__', $key); if(count($e)<2) { continue; } $last = strtolower(array_pop($e)); $cache[$key]['dqlAlias'] = $this->_tableAliases[strtolower(implode('__', $e))]; $table = $this->_queryComponents[$cache[$key]['dqlAlias']]['table']; $fieldName = $table->getFieldName($last); $cache[$key]['fieldName'] = $fieldName; if ($table->isIdentifier($fieldName)) { $cache[$key]['isIdentifier'] = true; } else { $cache[$key]['isIdentifier'] = false; } $type = $table->getTypeOfColumn($last); if ($type == 'integer' || $type == 'string') { $cache[$key]['isSimpleType'] = true; } else { $cache[$key]['type'] = $type; $cache[$key]['isSimpleType'] = false; } } $map = $this->_queryComponents[$cache[$key]['dqlAlias']]; $table = $map['table']; $dqlAlias = $cache[$key]['dqlAlias']; $fieldName = $cache[$key]['fieldName']; $agg = false; if (isset($this->_queryComponents[$dqlAlias]['agg'][$fieldName])) { $fieldName = $this->_queryComponents[$dqlAlias]['agg'][$fieldName]; $agg = true; } if ($cache[$key]['isIdentifier']) { $id[$dqlAlias] .= '|' . $value; } if ($cache[$key]['isSimpleType']) { $preparedValue = $value; } else { $preparedValue = $table->prepareValue($fieldName, $value, $cache[$key]['type']); } if ($agg) { $rowData[$this->_rootAlias][$fieldName] = $preparedValue; if (isset($rowData[$dqlAlias])) { $rowData[$dqlAlias][$fieldName] = $preparedValue; } } else { $rowData[$dqlAlias][$fieldName] = $preparedValue; } if ( ! isset($nonemptyComponents[$dqlAlias]) && $value !== null) { $nonemptyComponents[$dqlAlias] = true; } } return $rowData; } abstract public function getElementCollection($component); abstract public function registerCollection($coll); abstract public function initRelated(&$record, $name, $keyColumn = null); abstract public function getNullPointer(); abstract public function getElement(array $data, $component); abstract public function getLastKey(&$coll); abstract public function setLastElement(&$prev, &$coll, $index, $dqlAlias, $oneToOne); public function flush() { } protected function _getClassnameToReturn(array &$data, $component) { if ( ! isset($this->_tables[$component])) { $this->_tables[$component] = Doctrine_Core::getTable($component); } if ( ! ($subclasses = $this->_tables[$component]->getOption('subclasses'))) { return $component; } $matchedComponents = array($component); foreach ($subclasses as $subclass) { $table = Doctrine_Core::getTable($subclass); $inheritanceMap = $table->getOption('inheritanceMap'); if (count($inheritanceMap) > 1) { $needMatches = count($inheritanceMap); foreach ($inheritanceMap as $key => $value) { $key = $this->_tables[$component]->getFieldName($key); if ( isset($data[$key]) && $data[$key] == $value) { --$needMatches; } } if ($needMatches == 0) { $matchedComponents[] = $table->getComponentName(); } } else { list($key, $value) = each($inheritanceMap); $key = $this->_tables[$component]->getFieldName($key); if ( ! isset($data[$key]) || $data[$key] != $value) { continue; } else { $matchedComponents[] = $table->getComponentName(); } } } $matchedComponent = $matchedComponents[count($matchedComponents)-1]; if ( ! isset($this->_tables[$matchedComponent])) { $this->_tables[$matchedComponent] = Doctrine_Core::getTable($matchedComponent); } return $matchedComponent; } } class Doctrine_Hydrator_ArrayDriver extends Doctrine_Hydrator_Graph { public function getElementCollection($component) { return array(); } public function getElement(array $data, $component) { return $data; } public function registerCollection($coll) { } public function initRelated(&$record, $name, $keyColumn = null) { if ( ! isset($record[$name])) { $record[$name] = array(); } return true; } public function getNullPointer() { return null; } public function getLastKey(&$coll) { end($coll); return key($coll); } public function setLastElement(&$prev, &$coll, $index, $dqlAlias, $oneToOne) { if ($coll === null) { unset($prev[$dqlAlias]); return; } if ($index !== false) { $prev[$dqlAlias] =& $coll[$index]; return; } if ($coll) { if ($oneToOne) { $prev[$dqlAlias] =& $coll; } else { end($coll); $prev[$dqlAlias] =& $coll[key($coll)]; } } } }class Doctrine_Hydrator_RecordDriver extends Doctrine_Hydrator_Graph { protected $_collections = array(); private $_initializedRelations = array(); public function getElementCollection($component) { $coll = Doctrine_Collection::create($component); $this->_collections[] = $coll; return $coll; } public function initRelated(&$record, $name, $keyColumn = null) { if ( ! isset($this->_initializedRelations[$record->getOid()][$name])) { $relation = $record->getTable()->getRelation($name); $coll = Doctrine_Collection::create($relation->getTable()->getComponentName(), $keyColumn); $coll->setReference($record, $relation); $record[$name] = $coll; $this->_initializedRelations[$record->getOid()][$name] = true; } return true; } public function registerCollection($coll) { $this->_collections[] = $coll; } public function getNullPointer() { return self::$_null; } public function getElement(array $data, $component) { $component = $this->_getClassNameToReturn($data, $component); $this->_tables[$component]->setData($data); $record = $this->_tables[$component]->getRecord(); return $record; } public function getLastKey(&$coll) { $coll->end(); return $coll->key(); } public function setLastElement(&$prev, &$coll, $index, $dqlAlias, $oneToOne) { if ($coll === self::$_null) { unset($prev[$dqlAlias]); return; } if ($index !== false) { $prev[$dqlAlias] = $coll[$index]; return; } if (count($coll) > 0) { $prev[$dqlAlias] = $coll->getLast(); } } public function flush() { foreach ($this->_collections as $key => $coll) { $coll->takeSnapshot(); } $this->_initializedRelations = null; $this->_collections = null; $this->_tables = null; } }class Doctrine_Hydrator_RecordHierarchyDriver extends Doctrine_Hydrator_RecordDriver { public function hydrateResultSet($stmt) { return parent::hydrateResultSet($stmt)->toHierarchy(); } }class Doctrine_Hydrator_SingleScalarDriver extends Doctrine_Hydrator_Abstract { public function hydrateResultSet($stmt) { $result = array(); while (($val = $stmt->fetchColumn()) !== false) { $result[] = $val; } if (count($result) === 1) { return $result[0]; } else { return $result; } } }class Doctrine_Hydrator_ScalarDriver extends Doctrine_Hydrator_Abstract { public function hydrateResultSet($stmt) { $cache = array(); $result = array(); while ($data = $stmt->fetch(Doctrine_Core::FETCH_ASSOC)) { $result[] = $this->_gatherRowData($data, $cache); } return $result; } protected function _gatherRowData($data, &$cache, $aliasPrefix = true) { $rowData = array(); foreach ($data as $key => $value) { if ( ! isset($cache[$key])) { if ($key == 'DOCTRINE_ROWNUM') { continue; } $e = explode('__', $key); $columnName = strtolower(array_pop($e)); if(!isset($this->_tableAliases[strtolower(implode('__', $e))])) continue; $cache[$key]['dqlAlias'] = $this->_tableAliases[strtolower(implode('__', $e))]; $table = $this->_queryComponents[$cache[$key]['dqlAlias']]['table']; if (isset($this->_queryComponents[$cache[$key]['dqlAlias']]['agg'][$columnName])) { $fieldName = $this->_queryComponents[$cache[$key]['dqlAlias']]['agg'][$columnName]; $cache[$key]['isAgg'] = true; } else { $fieldName = $table->getFieldName($columnName); $cache[$key]['isAgg'] = false; } $cache[$key]['fieldName'] = $fieldName; $type = $table->getTypeOfColumn($columnName); if ($type == 'integer' || $type == 'string') { $cache[$key]['isSimpleType'] = true; } else { $cache[$key]['type'] = $type; $cache[$key]['isSimpleType'] = false; } } $table = $this->_queryComponents[$cache[$key]['dqlAlias']]['table']; $dqlAlias = $cache[$key]['dqlAlias']; $fieldName = $cache[$key]['fieldName']; $rowDataKey = $aliasPrefix ? $dqlAlias . '_' . $fieldName:$fieldName; if ($cache[$key]['isSimpleType'] || $cache[$key]['isAgg']) { $rowData[$rowDataKey] = $value; } else { $rowData[$rowDataKey] = $table->prepareValue( $fieldName, $value, $cache[$key]['type']); } } return $rowData; } } class Doctrine_Hydrator_ArrayHierarchyDriver extends Doctrine_Hydrator_ArrayDriver { public function hydrateResultSet($stmt) { $collection = parent::hydrateResultSet($stmt); $table = $this->getRootComponent(); if ( ! $table->isTree() || ! $table->hasColumn('level')) { throw new Doctrine_Exception('Cannot hydrate model that does not implements Tree behavior with `level` column'); } $trees = array(); $l = 0; if (count($collection) > 0) { $stack = array(); foreach ($collection as $child) { $item = $child; $item['__children'] = array(); $l = count($stack); while($l > 0 && $stack[$l - 1]['level'] >= $item['level']) { array_pop($stack); $l--; } if ($l == 0) { $i = count($trees); $trees[$i] = $item; $stack[] = & $trees[$i]; } else { $i = count($stack[$l - 1]['__children']); $stack[$l - 1]['__children'][$i] = $item; $stack[] = & $stack[$l - 1]['__children'][$i]; } } } return $trees; } }class Doctrine_Hydrator_Exception extends Doctrine_Exception { }class Doctrine_Locator_Exception extends Doctrine_Exception { } class Doctrine_Data_Import extends Doctrine_Data { protected $_importedObjects = array(); protected $_rows = array(); public function __construct($directory = null) { if ($directory !== null) { $this->setDirectory($directory); } } public function doParsing() { $recursiveMerge = Doctrine_Manager::getInstance()->getAttribute(Doctrine_Core::ATTR_RECURSIVE_MERGE_FIXTURES); $mergeFunction = $recursiveMerge === true ? 'array_merge_recursive':'array_merge'; $directory = $this->getDirectory(); $array = array(); if ($directory !== null) { foreach ((array) $directory as $dir) { $e = explode('.', $dir); if (end($e) == 'yml') { $array = $mergeFunction($array, Doctrine_Parser::load($dir, $this->getFormat())); } else if (is_dir($dir)) { $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir), RecursiveIteratorIterator::LEAVES_ONLY); $filesOrdered = array(); foreach ($it as $file) { $filesOrdered[] = $file; } natcasesort($filesOrdered); foreach ($filesOrdered as $file) { $e = explode('.', $file->getFileName()); if (in_array(end($e), $this->getFormats())) { $array = $mergeFunction($array, Doctrine_Parser::load($file->getPathName(), $this->getFormat())); } } } } } return $array; } public function doImport($append = false) { $array = $this->doParsing(); if ( ! $append) { $this->purge(array_reverse(array_keys($array))); } $this->_loadData($array); } protected function _buildRows($className, $data) { $table = Doctrine_Core::getTable($className); foreach ($data as $rowKey => $row) { $this->_rows[$className][$rowKey] = $row; foreach ((array) $row as $key => $value) { if ($table->hasRelation($key) && is_array($value) && ! $table->hasTemplate('Doctrine_Template_I18n')) { if ( ! isset($value[0]) || (isset($value[0]) && is_array($value[0]))) { $rel = $table->getRelation($key); $relClassName = $rel->getTable()->getOption('name'); $relRowKey = $rowKey . '_' . $relClassName; if ($rel->getType() == Doctrine_Relation::ONE) { $val = array($relRowKey => $value); $this->_rows[$className][$rowKey][$key] = $relRowKey; } else { $val = $value; $this->_rows[$className][$rowKey][$key] = array_keys($val); } $this->_buildRows($relClassName, $val); } } } } } protected function _buildNestedSetRows($className, $data) { foreach ($data as $rowKey => $row) { $children = isset($row['children']) ? $row['children']:array(); unset($row['children']); $this->_rows[$className][$rowKey] = $row; $this->_buildNestedSetRows($className, $children); } } protected function _getImportedObject($rowKey, Doctrine_Record $record, $relationName, $referringRowKey) { $relation = $record->getTable()->getRelation($relationName); $rowKey = $this->_getRowKeyPrefix($relation->getTable()) . $rowKey; if ( ! isset($this->_importedObjects[$rowKey])) { throw new Doctrine_Data_Exception( sprintf('Invalid row key specified: %s, referred to in %s', $rowKey, $referringRowKey) ); } $relatedRowKeyObject = $this->_importedObjects[$rowKey]; $relationClass = $relation->getClass(); if ( ! $relatedRowKeyObject instanceof $relationClass) { throw new Doctrine_Data_Exception(sprintf( 'Class referred to in "%s" is expected to be "%s" and "%s" was given', $referringRowKey, $relation->getClass(), get_class($relatedRowKeyObject) )); } return $relatedRowKeyObject; } protected function _processRow($rowKey, $row) { $obj = $this->_importedObjects[$rowKey]; foreach ((array) $row as $key => $value) { if (method_exists($obj, 'set' . Doctrine_Inflector::classify($key))) { $func = 'set' . Doctrine_Inflector::classify($key); $obj->$func($value); } else if ($obj->getTable()->hasField($key)) { if ($obj->getTable()->getTypeOf($key) == 'object') { $value = unserialize($value); } $obj->set($key, $value); } else if ($obj->getTable()->hasRelation($key)) { if (is_array($value)) { if (isset($value[0]) && ! is_array($value[0])) { foreach ($value as $link) { if ($obj->getTable()->getRelation($key)->getType() === Doctrine_Relation::ONE) { $obj->set($key, $this->_getImportedObject($link, $obj, $key, $rowKey)); } else if ($obj->getTable()->getRelation($key)->getType() === Doctrine_Relation::MANY) { $relation = $obj->$key; $relation[] = $this->_getImportedObject($link, $obj, $key, $rowKey); } } } else { $obj->$key->fromArray($value); } } else { $obj->set($key, $this->_getImportedObject($value, $obj, $key, $rowKey)); } } else { try { $obj->$key = $value; } catch (Exception $e) { if (is_callable(array($obj, 'set' . Doctrine_Inflector::classify($key)))) { $func = 'set' . Doctrine_Inflector::classify($key); $obj->$func($value); } else { throw new Doctrine_Data_Exception('Invalid fixture element "'. $key . '" under "' . $rowKey . '"'); } } } } } protected function _hasNaturalNestedSetFormat($className, array &$data) { if (Doctrine_Core::getTable($className)->isTree()) { if (isset($data['NestedSet']) && $data['NestedSet'] == true) { unset($data['NestedSet']); return true; } else { $first = current($data); return array_key_exists('children', $first); } } else { return false; } } protected function _loadData(array $array) { $nestedSets = array(); $specifiedModels = $this->getModels(); $rows = array(); foreach ($array as $className => $data) { if ( ! empty($specifiedModels) && !in_array($className, $specifiedModels)) { continue; } if ($this->_hasNaturalNestedSetFormat($className, $data)) { $nestedSets[$className][] = $data; $this->_buildNestedSetRows($className, $data); } else { $this->_buildRows($className, $data); } } $buildRows = array(); foreach ($this->_rows as $className => $classRows) { $rowKeyPrefix = $this->_getRowKeyPrefix(Doctrine_Core::getTable($className)); foreach ($classRows as $rowKey => $row) { $rowKey = $rowKeyPrefix . $rowKey; $buildRows[$rowKey] = $row; $this->_importedObjects[$rowKey] = new $className(); $this->_importedObjects[$rowKey]->state('TDIRTY'); } } foreach($buildRows as $rowKey => $row) { $this->_processRow($rowKey, $row); } foreach ($nestedSets as $className => $sets) { foreach ($sets as $data) { $this->_loadNestedSetData($className, $data); } } $manager = Doctrine_Manager::getInstance(); foreach ($manager as $connection) { $tree = $connection->unitOfWork->buildFlushTree(array_keys($array)); foreach ($tree as $model) { foreach ($this->_importedObjects as $obj) { if ($obj instanceof $model) { $obj->save(); } } } } } protected function _loadNestedSetData($model, $nestedSetData, $parent = null) { foreach($nestedSetData AS $rowKey => $nestedSet) { $children = array(); $data = array(); if (array_key_exists('children', $nestedSet)) { $children = (array) $nestedSet['children']; $children = array_reverse($children, true); unset($nestedSet['children']); } $rowKey = $this->_getRowKeyPrefix(Doctrine_Core::getTable($model)) . $rowKey; $record = $this->_importedObjects[$rowKey]; unset($this->_importedObjects[$rowKey]); if ( ! $parent) { $record->save(); Doctrine_Core::getTable($model)->getTree()->createRoot($record); } else { $parent->getNode()->addChild($record); } if (is_array($children) AND !empty($children)) { $this->_loadNestedSetData($model, $children, $record); } } } protected function _getRowKeyPrefix(Doctrine_Table $table) { return sprintf('(%s) ', $table->getTableName()); } }class Doctrine_Data_Export extends Doctrine_Data { public function __construct($directory) { $this->setDirectory($directory); } public function doExport() { $models = Doctrine_Core::getLoadedModels(); $specifiedModels = $this->getModels(); $data = array(); if (empty($models)) { $models = $specifiedModels; } $models = Doctrine_Core::initializeModels($models); $originalIndexBy = array(); foreach ($models AS $name) { $table = Doctrine_Core::getTable($name); if ( !is_null($indexBy = $table->getBoundQueryPart('indexBy'))) { $originalIndexBy[$name] = $indexBy; $table->bindQueryPart('indexBy', null); } } foreach ($models AS $name) { if ( ! empty($specifiedModels) AND ! in_array($name, $specifiedModels)) { continue; } $results = Doctrine_Core::getTable($name)->findAll(); if ($results->count() > 0) { $data[$name] = $results; } } foreach($originalIndexBy AS $name => $indexBy) { Doctrine_Core::getTable($name)->bindQueryPart('indexBy', $indexBy); } $data = $this->prepareData($data); return $this->dumpData($data); } public function dumpData(array $data) { $directory = $this->getDirectory(); $format = $this->getFormat(); if ($this->exportIndividualFiles()) { if (is_array($directory)) { throw new Doctrine_Data_Exception('You must specify a single path to a folder in order to export individual files.'); } else if ( ! is_dir($directory) && is_file($directory)) { $directory = dirname($directory); } foreach ($data as $className => $classData) { if ( ! empty($classData)) { Doctrine_Parser::dump(array($className => $classData), $format, $directory.DIRECTORY_SEPARATOR.$className.'.'.$format); } } } else { if (is_dir($directory)) { $directory .= DIRECTORY_SEPARATOR . 'data.' . $format; } if ( ! empty($data)) { return Doctrine_Parser::dump($data, $format, $directory); } } } public function prepareData($data) { $preparedData = array(); foreach ($data AS $className => $classData) { $preparedData[$className] = array(); $keyType = $classData->getTable()->getIdentifierType(); foreach ($classData as $record) { $className = get_class($record); $recordKey = $className . '_' . implode('_', $record->identifier()); $preparedData[$className][$recordKey] = array(); $keys = $record->getTable()->getIdentifier(); $recordData = $record->toArray(false); foreach ($recordData as $key => $value) { if ( ! is_array($keys)) { $keys = array($keys); } if ($keyType !== Doctrine_Core::IDENTIFIER_NATURAL && count($keys) <= 1 && in_array($key, $keys)) { continue; } if (is_object($record[$key])) { $value = serialize($record[$key]); } if ($relation = $this->isRelation($record, $key)) { if ( ! $value) { continue; } $relationAlias = $relation['alias']; $relationRecord = $record->$relationAlias; if ($relationRecord instanceof Doctrine_Collection) { $relationRecord = $relationRecord->getFirst(); } if ($relationRecord instanceof Doctrine_Null || ! $relationRecord) { continue; } $relationClassName = get_class($relationRecord); $relationValue = $relationClassName . '_' . $value; $preparedData[$className][$recordKey][$relationAlias] = $relationValue; } else if ($record->getTable()->hasField($key)) { $preparedData[$className][$recordKey][$key] = $value; } } } } return $preparedData; } }class Doctrine_Data_Exception extends Doctrine_Exception { }class Doctrine_Import_Sqlite extends Doctrine_Import { public function listDatabases() { } public function listFunctions() { } public function listTriggers($database = null) { } public function listSequences($database = null) { $query = "SELECT name FROM sqlite_master WHERE type='table' AND sql NOT NULL ORDER BY name"; $tableNames = $this->conn->fetchColumn($query); $result = array(); foreach ($tableNames as $tableName) { if ($sqn = $this->conn->fixSequenceName($tableName, true)) { $result[] = $sqn; } } if ($this->conn->getAttribute(Doctrine_Core::ATTR_FIELD_CASE) && ($this->conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_FIX_CASE)) { $result = array_map(($this->conn->getAttribute(Doctrine_Core::ATTR_FIELD_CASE) == CASE_LOWER ? 'strtolower' : 'strtoupper'), $result); } return $result; } public function listTableConstraints($table) { $table = $this->conn->quote($table, 'text'); $query = "SELECT sql FROM sqlite_master WHERE type='index' AND "; if ($this->conn->getAttribute(Doctrine_Core::ATTR_FIELD_CASE) && ($this->conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_FIX_CASE)) { $query .= 'LOWER(tbl_name) = ' . strtolower($table); } else { $query .= 'tbl_name = ' . $table; } $query .= ' AND sql NOT NULL ORDER BY name'; $indexes = $this->conn->fetchColumn($query); $result = array(); foreach ($indexes as $sql) { if (preg_match("/^create unique index ([^ ]+) on /i", $sql, $tmp)) { $index = $this->conn->formatter->fixIndexName($tmp[1]); if ( ! empty($index)) { $result[$index] = true; } } } if ($this->conn->getAttribute(Doctrine_Core::ATTR_FIELD_CASE) && ($this->conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_FIX_CASE)) { $result = array_change_key_case($result, $this->conn->getAttribute(Doctrine_Core::ATTR_FIELD_CASE)); } return array_keys($result); } public function listTableColumns($table) { $sql = 'PRAGMA table_info(' . $table . ')'; $result = $this->conn->fetchAll($sql); $description = array(); $columns = array(); foreach ($result as $key => $val) { $val = array_change_key_case($val, CASE_LOWER); $decl = $this->conn->dataDict->getPortableDeclaration($val); $description = array( 'name' => $val['name'], 'ntype' => $val['type'], 'type' => $decl['type'][0], 'alltypes' => $decl['type'], 'notnull' => (bool) $val['notnull'], 'default' => $val['dflt_value'], 'primary' => (bool) $val['pk'], 'length' => null, 'scale' => null, 'precision' => null, 'unsigned' => null, 'autoincrement' => (bool) ($val['pk'] == 1 && $decl['type'][0] == 'integer'), ); $columns[$val['name']] = $description; } return $columns; } public function listTableIndexes($table) { $sql = 'PRAGMA index_list(' . $table . ')'; return $this->conn->fetchColumn($sql); } public function listTables($database = null) { $sql = "SELECT name FROM sqlite_master WHERE type = 'table' AND name != 'sqlite_sequence' " . "UNION ALL SELECT name FROM sqlite_temp_master " . "WHERE type = 'table' ORDER BY name"; return $this->conn->fetchColumn($sql); } public function listTableTriggers($table) { } public function listTableViews($table) { $query = "SELECT name, sql FROM sqlite_master WHERE type='view' AND sql NOT NULL"; $views = $db->fetchAll($query); $result = array(); foreach ($views as $row) { if (preg_match("/^create view .* \bfrom\b\s+\b{$table}\b /i", $row['sql'])) { if ( ! empty($row['name'])) { $result[$row['name']] = true; } } } return $result; } public function listUsers() { } public function listViews($database = null) { $query = "SELECT name FROM sqlite_master WHERE type='view' AND sql NOT NULL"; return $this->conn->fetchColumn($query); } }class Doctrine_Import_Builder extends Doctrine_Builder { protected $_path = ''; protected $_packagesPrefix = 'Package'; protected $_packagesPath = ''; protected $_packagesFolderName = 'packages'; protected $_suffix = '.php'; protected $_generateBaseClasses = true; protected $_generateTableClasses = false; protected $_baseClassPrefix = 'Base'; protected $_baseClassesDirectory = 'generated'; protected $_baseClassName = 'Doctrine_Record'; protected $_baseTableClassName = 'Doctrine_Table'; protected $_tableClassFormat = '%sTable'; protected $_classPrefix = null; protected $_classPrefixFiles = true; protected $_pearStyle = false; protected $_eolStyle = null; protected $_phpDocPackage = '##PACKAGE##'; protected $_phpDocSubpackage = '##SUBPACKAGE##'; protected $_phpDocName = '##NAME##'; protected $_phpDocEmail = '##EMAIL##'; protected static $_tpl; public function __construct() { $manager = Doctrine_Manager::getInstance(); if ($tableClass = $manager->getAttribute(Doctrine_Core::ATTR_TABLE_CLASS)) { $this->_baseTableClassName = $tableClass; } if ($classPrefix = $manager->getAttribute(Doctrine_Core::ATTR_MODEL_CLASS_PREFIX)) { $this->_classPrefix = $classPrefix; } if ($tableClassFormat = $manager->getAttribute(Doctrine_Core::ATTR_TABLE_CLASS_FORMAT)) { $this->_tableClassFormat = $tableClassFormat; } $this->loadTemplate(); } public function setTargetPath($path) { if ($path) { if ( ! $this->_packagesPath) { $this->setOption('packagesPath', $path . DIRECTORY_SEPARATOR . $this->_packagesFolderName); } $this->_path = $path; } } public function generateBaseClasses($bool = null) { if ($bool !== null) { $this->_generateBaseClasses = $bool; } return $this->_generateBaseClasses; } public function generateTableClasses($bool = null) { if ($bool !== null) { $this->_generateTableClasses = $bool; } return $this->_generateTableClasses; } public function getTargetPath() { return $this->_path; } public function setOptions($options) { if ( ! empty($options)) { foreach ($options as $key => $value) { $this->setOption($key, $value); } } } public function setOption($key, $value) { $name = 'set' . Doctrine_Inflector::classify($key); if (method_exists($this, $name)) { $this->$name($value); } else { $key = '_' . $key; $this->$key = $value; } } public function loadTemplate() { if (isset(self::$_tpl)) { return; } self::$_tpl = '/**' . '%s' . PHP_EOL . ' */' . PHP_EOL . '%sclass %s extends %s' . PHP_EOL . '{' . '%s' . PHP_EOL . '%s' . PHP_EOL . '}'; } public function buildTableDefinition(array $definition) { if (isset($definition['inheritance']['type']) && ($definition['inheritance']['type'] == 'simple' || $definition['inheritance']['type'] == 'column_aggregation')) { return; } $ret = array(); $i = 0; if (isset($definition['inheritance']['type']) && $definition['inheritance']['type'] == 'concrete') { $ret[$i] = "        parent::setTableDefinition();"; $i++; } if (isset($definition['tableName']) && !empty($definition['tableName'])) { $ret[$i] = "        ".'$this->setTableName(\''. $definition['tableName'].'\');'; $i++; } if (isset($definition['columns']) && is_array($definition['columns']) && !empty($definition['columns'])) { $ret[$i] = $this->buildColumns($definition['columns']); $i++; } if (isset($definition['indexes']) && is_array($definition['indexes']) && !empty($definition['indexes'])) { $ret[$i] = $this->buildIndexes($definition['indexes']); $i++; } if (isset($definition['attributes']) && is_array($definition['attributes']) && !empty($definition['attributes'])) { $ret[$i] = $this->buildAttributes($definition['attributes']); $i++; } if (isset($definition['options']) && is_array($definition['options']) && !empty($definition['options'])) { $ret[$i] = $this->buildOptions($definition['options']); $i++; } if (isset($definition['checks']) && is_array($definition['checks']) && !empty($definition['checks'])) { $ret[$i] = $this->buildChecks($definition['checks']); $i++; } if (isset($definition['inheritance']['subclasses']) && ! empty($definition['inheritance']['subclasses'])) { $subClasses = array(); foreach ($definition['inheritance']['subclasses'] as $className => $def) { $className = $this->_classPrefix . $className; $subClasses[$className] = $def; } $ret[$i] = "        ".'$this->setSubClasses('. $this->varExport($subClasses).');'; $i++; } $code = implode(PHP_EOL, $ret); $code = trim($code); return PHP_EOL . "    public function setTableDefinition()" . PHP_EOL . '    {' . PHP_EOL . '        ' . $code . PHP_EOL . '    }'; } public function buildSetUp(array $definition) { $ret = array(); $i = 0; if (isset($definition['relations']) && is_array($definition['relations']) && ! empty($definition['relations'])) { foreach ($definition['relations'] as $name => $relation) { $class = isset($relation['class']) ? $relation['class']:$name; $alias = (isset($relation['alias']) && $relation['alias'] !== $this->_classPrefix . $relation['class']) ? ' as ' . $relation['alias'] : ''; if ( ! isset($relation['type'])) { $relation['type'] = Doctrine_Relation::ONE; } if ($relation['type'] === Doctrine_Relation::ONE) { $ret[$i] = "        ".'$this->hasOne(\'' . $class . $alias . '\''; } else { $ret[$i] = "        ".'$this->hasMany(\'' . $class . $alias . '\''; } $a = array(); if (isset($relation['refClass'])) { $a[] = '\'refClass\' => ' . $this->varExport($relation['refClass']); } if (isset($relation['refClassRelationAlias'])) { $a[] = '\'refClassRelationAlias\' => ' . $this->varExport($relation['refClassRelationAlias']); } if (isset($relation['deferred']) && $relation['deferred']) { $a[] = '\'default\' => ' . $this->varExport($relation['deferred']); } if (isset($relation['local']) && $relation['local']) { $a[] = '\'local\' => ' . $this->varExport($relation['local']); } if (isset($relation['foreign']) && $relation['foreign']) { $a[] = '\'foreign\' => ' . $this->varExport($relation['foreign']); } if (isset($relation['onDelete']) && $relation['onDelete']) { $a[] = '\'onDelete\' => ' . $this->varExport($relation['onDelete']); } if (isset($relation['onUpdate']) && $relation['onUpdate']) { $a[] = '\'onUpdate\' => ' . $this->varExport($relation['onUpdate']); } if (isset($relation['cascade']) && $relation['cascade']) { $a[] = '\'cascade\' => ' . $this->varExport($relation['cascade']); } if (isset($relation['equal']) && $relation['equal']) { $a[] = '\'equal\' => ' . $this->varExport($relation['equal']); } if (isset($relation['owningSide']) && $relation['owningSide']) { $a[] = '\'owningSide\' => ' . $this->varExport($relation['owningSide']); } if (isset($relation['foreignKeyName']) && $relation['foreignKeyName']) { $a[] = '\'foreignKeyName\' => ' . $this->varExport($relation['foreignKeyName']); } if (isset($relation['orderBy']) && $relation['orderBy']) { $a[] = '\'orderBy\' => ' . $this->varExport($relation['orderBy']); } if ( ! empty($a)) { $ret[$i] .= ', ' . 'array(' . PHP_EOL . str_repeat(' ', 13); $length = strlen($ret[$i]); $ret[$i] .= implode(',' . PHP_EOL . str_repeat(' ', 13), $a) . ')'; } $ret[$i] .= ');'.PHP_EOL; $i++; } } if (isset($definition['actAs']) && is_array($definition['actAs']) && !empty($definition['actAs'])) { $ret[$i] = $this->buildActAs($definition['actAs']); $i++; } if (isset($definition['listeners']) && is_array($definition['listeners']) && !empty($definition['listeners'])) { $ret[$i] = $this->buildListeners($definition['listeners']); $i++; } $code = implode(PHP_EOL, $ret); $code = trim($code); $code = "parent::setUp();" . PHP_EOL . '        ' . $code; if ($code) { return '    public function setUp()' . PHP_EOL . '    {' . PHP_EOL . '        ' . $code . PHP_EOL . '    }'; } } public function buildChecks($checks) { $build = ''; foreach ($checks as $check) { $build .= "        \$this->check('" . $check . "');" . PHP_EOL; } return $build; } public function buildColumns(array $columns) { $manager = Doctrine_Manager::getInstance(); $refl = new ReflectionClass($this->_baseClassName); $build = null; foreach ($columns as $name => $column) { $columnName = isset($column['name']) ? $column['name']:$name; if ($manager->getAttribute(Doctrine_Core::ATTR_AUTO_ACCESSOR_OVERRIDE)) { $e = explode(' as ', $columnName); $fieldName = isset($e[1]) ? $e[1] : $e[0]; $classified = Doctrine_Inflector::classify($fieldName); $getter = 'get' . $classified; $setter = 'set' . $classified; if ($refl->hasMethod($getter) || $refl->hasMethod($setter)) { throw new Doctrine_Import_Exception( sprintf('When using the attribute ATTR_AUTO_ACCESSOR_OVERRIDE you cannot use the field name "%s" because it is reserved by Doctrine. You must choose another field name.', $fieldName) ); } } $build .= "        ".'$this->hasColumn(\'' . $columnName . '\', \'' . $column['type'] . '\''; if ($column['length']) { $build .= ', ' . $column['length']; } else { $build .= ', null'; } $options = $column; unset($options['name']); unset($options['alltypes']); unset($options['ntype']); if (isset($options['primary']) && $options['primary'] == true && (isset($options['notnull']) && $options['notnull'] == true)) { unset($options['notnull']); } if (isset($options['primary']) && $options['primary'] == true && (isset($options['default']) && $options['default'] == 0)) { unset($options['default']); } foreach ($options as $key => $value) { if (is_null($value) || (is_array($value) && empty($value))) { unset($options[$key]); } } if (is_array($options) && !empty($options)) { $build .= ', ' . $this->varExport($options); } $build .= ');' . PHP_EOL; } return $build; } public function buildAccessors(array $definition) { $accessors = array(); foreach (array_keys($definition['columns']) as $name) { $accessors[] = $name; } foreach ($definition['relations'] as $relation) { $accessors[] = $relation['alias']; } $ret = ''; foreach ($accessors as $name) { $ret .= PHP_EOL . '  public function get' . Doctrine_Inflector::classify(Doctrine_Inflector::tableize($name)) . "(\$load = true)" . PHP_EOL; $ret .= "  {" . PHP_EOL; $ret .= "    return \$this->get('{$name}', \$load);" . PHP_EOL; $ret .= "  }" . PHP_EOL; $ret .= PHP_EOL . '  public function set' . Doctrine_Inflector::classify(Doctrine_Inflector::tableize($name)) . "(\${$name}, \$load = true)" . PHP_EOL; $ret .= "  {" . PHP_EOL; $ret .= "    return \$this->set('{$name}', \${$name}, \$load);" . PHP_EOL; $ret .= "  }" . PHP_EOL; } return $ret; } public function buildPhpDocs(array $definition) { $ret = array(); $ret[] = $definition['className']; $ret[] = ''; $ret[] = 'This class has been auto-generated by the Doctrine ORM Framework'; $ret[] = ''; if ((isset($definition['is_base_class']) && $definition['is_base_class']) || ! $this->generateBaseClasses()) { foreach ($definition['columns'] as $name => $column) { $name = isset($column['name']) ? $column['name']:$name; if (stripos($name, ' as ')) { if (strpos($name, ' as')) { $parts = explode(' as ', $name); } else { $parts = explode(' AS ', $name); } if (count($parts) > 1) { $fieldName = $parts[1]; } else { $fieldName = $parts[0]; } $name = $parts[0]; } else { $fieldName = $name; $name = $name; } $name = trim($name); $fieldName = trim($fieldName); $ret[] = '@property ' . $column['type'] . ' $' . $fieldName; } if (isset($definition['relations']) && ! empty($definition['relations'])) { foreach ($definition['relations'] as $relation) { $type = (isset($relation['type']) && $relation['type'] == Doctrine_Relation::MANY) ? 'Doctrine_Collection' : $this->_classPrefix . $relation['class']; $ret[] = '@property ' . $type . ' $' . $relation['alias']; } } $ret[] = ''; } $ret[] = '@package    ' . $this->_phpDocPackage; $ret[] = '@subpackage ' . $this->_phpDocSubpackage; $ret[] = '@author     ' . $this->_phpDocName . ' <' . $this->_phpDocEmail . '>'; $ret[] = '@version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $'; $ret = ' * ' . implode(PHP_EOL . ' * ', $ret); $ret = ' ' . trim($ret); return $ret; } private function emitAssign($level, $name, $option) { $classname = $name; if (class_exists("Doctrine_Template_$name", true)) { $classname = "Doctrine_Template_$name"; } return "        \$" . strtolower($name) . "$level = new $classname($option);". PHP_EOL; } private function emitAddChild($level, $parent, $name) { return "        \$" . strtolower($parent) . ($level - 1) . "->addChild(\$" . strtolower($name) . "$level);" . PHP_EOL; } private function emitActAs($level, $name) { return "        \$this->actAs(\$" . strtolower($name) . "$level);" . PHP_EOL; } public function buildActAs($actAs) { $emittedActAs = array(); $build = $this->innerBuildActAs($actAs, 0, null, $emittedActAs); foreach($emittedActAs as $str) { $build .= $str; } return $build; } private function innerBuildActAs($actAs, $level = 0, $parent = null, array &$emittedActAs) { if (is_array($actAs) && isset($actAs[0]) && !is_array($actAs[0])) { $tmp = array(); foreach ($actAs as $key => $value) { if (is_numeric($key)) { $tmp[(string)$value] = null; } else { $tmp[$key] = $value; } } $actAs = $tmp; } $build = ''; $currentParent = $parent; if (is_array($actAs)) { foreach($actAs as $template => $options) { if ($template == 'actAs') { $build .= $this->innerBuildActAs($options, $level + 1, $parent, $emittedActAs); } else if (is_array($options)) { $realOptions = array(); $leftActAs = array(); foreach($options as $name => $value) { if ($name != 'actAs') { $realOptions[$name] = $options[$name]; } else { $leftActAs[$name] = $options[$name]; } } $optionPHP = $this->varExport($realOptions); $build .= $this->emitAssign($level, $template, $optionPHP); if ($level == 0) { $emittedActAs[] = $this->emitActAs($level, $template); } else { $build .= $this->emitAddChild($level, $currentParent, $template); } $parent = $template; $build .= $this->innerBuildActAs($leftActAs, $level, $template, $emittedActAs); } else { $build .= $this->emitAssign($level, $template, null); if ($level == 0) { $emittedActAs[] = $this->emitActAs($level, $template); } else { $build .= $this->emitAddChild($level, $currentParent, $template); } $parent = $template; } } } else { $build .= $this->emitAssign($level, $actAs, null); if ($level == 0) { $emittedActAs[] = $this->emitActAs($level, $actAs); } else { $build .= $this->emitAddChild($level, $currentParent, $actAs); } } return $build; } public function buildListeners($listeners) { $build = ''; foreach($listeners as $name => $options) { if ( ! is_array($options) && $options !== null) { $name = $options; $options = null; } $useOptions = ( ! empty($options) && isset($options['useOptions']) && $options['useOptions'] == true) ? '$this->getTable()->getOptions()' : 'array()'; $class = ( ! empty($options) && isset($options['class'])) ? $options['class'] : $name; $build .= "    \$this->addListener(new " . $class . "(" . $useOptions . "), '" . $name . "');" . PHP_EOL; } return $build; } public function buildAttributes(array $attributes) { $build = PHP_EOL; foreach ($attributes as $key => $value) { $values = array(); if (is_bool($value)) { $values[] = $value ? 'true':'false'; } else { if ( ! is_array($value)) { $value = array($value); } foreach ($value as $attr) { $const = "Doctrine_Core::" . strtoupper($key) . "_" . strtoupper($attr); if (defined($const)) { $values[] = $const; } else { $values[] = "'" . $attr . "'"; } } } $string = implode(' ^ ', $values); $build .= "        \$this->setAttribute(Doctrine_Core::ATTR_" . strtoupper($key) . ", " . $string . ");" . PHP_EOL; } return $build; } public function buildOptions(array $options) { $build = ''; foreach ($options as $name => $value) { $build .= "        \$this->option('$name', " . $this->varExport($value) . ");" . PHP_EOL; } return $build; } public function buildIndexes(array $indexes) { $build = ''; foreach ($indexes as $indexName => $definitions) { $build .= PHP_EOL . "        \$this->index('" . $indexName . "'"; $build .= ', ' . $this->varExport($definitions); $build .= ');'; } return $build; } public function buildToString(array $definition) { if ( empty($definition['toString'])) { return ''; } $ret = PHP_EOL . PHP_EOL . '    public function __toString()' . PHP_EOL; $ret .= "    {" . PHP_EOL; $ret .= "      return (string) \$this->".$definition['toString'].";" . PHP_EOL; $ret .= "    }"; return $ret; } public function buildDefinition(array $definition) { if ( ! isset($definition['className'])) { throw new Doctrine_Import_Builder_Exception('Missing class name.'); } $abstract = isset($definition['abstract']) && $definition['abstract'] === true ? 'abstract ':null; $className = $definition['className']; $extends = isset($definition['inheritance']['extends']) ? $definition['inheritance']['extends']:$this->_baseClassName; if ( ! (isset($definition['no_definition']) && $definition['no_definition'] === true)) { $tableDefinitionCode = $this->buildTableDefinition($definition); $setUpCode = $this->buildSetUp($definition); } else { $tableDefinitionCode = null; $setUpCode = null; } if ($tableDefinitionCode && $setUpCode) { $setUpCode = PHP_EOL . $setUpCode; } $setUpCode.= $this->buildToString($definition); $docs = PHP_EOL . $this->buildPhpDocs($definition); $content = sprintf(self::$_tpl, $docs, $abstract, $className, $extends, $tableDefinitionCode, $setUpCode); return $content; } public function buildRecord(array $definition) { if ( ! isset($definition['className'])) { throw new Doctrine_Import_Builder_Exception('Missing class name.'); } $definition['topLevelClassName'] = $definition['className']; if ($this->generateBaseClasses()) { $definition['is_package'] = (isset($definition['package']) && $definition['package']) ? true:false; if ($definition['is_package']) { $e = explode('.', trim($definition['package'])); $definition['package_name'] = $e[0]; $definition['package_path'] = ! empty($e) ? implode(DIRECTORY_SEPARATOR, $e):$definition['package_name']; } $topLevel = $definition; unset($topLevel['tableName']); $topLevel['inheritance']['extends'] = (isset($topLevel['package']) && $topLevel['package']) ? $this->_packagesPrefix . $topLevel['className']:$this->_baseClassPrefix . $topLevel['className']; $topLevel['no_definition'] = true; $topLevel['generate_once'] = true; $topLevel['is_main_class'] = true; unset($topLevel['connection']); if (isset($definition['package'])) { $packageLevel = $definition; $packageLevel['className'] = $topLevel['inheritance']['extends']; $packageLevel['inheritance']['extends'] = $this->_baseClassPrefix . $topLevel['className']; $packageLevel['no_definition'] = true; $packageLevel['abstract'] = true; $packageLevel['override_parent'] = true; $packageLevel['generate_once'] = true; $packageLevel['is_package_class'] = true; unset($packageLevel['connection']); $packageLevel['tableClassName'] = sprintf($this->_tableClassFormat, $packageLevel['className']); $packageLevel['inheritance']['tableExtends'] = isset($definition['inheritance']['extends']) ? sprintf($this->_tableClassFormat, $definition['inheritance']['extends']):$this->_baseTableClassName; $topLevel['tableClassName'] = sprintf($this->_tableClassFormat, $topLevel['topLevelClassName']); $topLevel['inheritance']['tableExtends'] = sprintf($this->_tableClassFormat, $packageLevel['className']); } else { $topLevel['tableClassName'] = sprintf($this->_tableClassFormat, $topLevel['className']); $topLevel['inheritance']['tableExtends'] = isset($definition['inheritance']['extends']) ? sprintf($this->_tableClassFormat, $definition['inheritance']['extends']):$this->_baseTableClassName; } $baseClass = $definition; $baseClass['className'] = $this->_getBaseClassName($baseClass['className']); $baseClass['abstract'] = true; $baseClass['override_parent'] = false; $baseClass['is_base_class'] = true; $this->writeDefinition($baseClass); if ( ! empty($packageLevel)) { $this->writeDefinition($packageLevel); } $this->writeDefinition($topLevel); } else { $this->writeDefinition($definition); } } protected function _getBaseClassName($className) { return $this->_baseClassPrefix . $className; } public function buildTableClassDefinition($className, $definition, $options = array()) { $extends = isset($options['extends']) ? $options['extends']:$this->_baseTableClassName; if ($extends !== $this->_baseTableClassName) { $extends = $this->_classPrefix . $extends; } $code = sprintf("    /**
     * Returns an instance of this class.
     *
     * @return object %s
     */
    public static function getInstance()
    {
        return Doctrine_Core::getTable('%s');
    }", $className, $definition['className']); $docBlock = array(); $docBlock[] = $className; $docBlock[] = ''; $docBlock[] = 'This class has been auto-generated by the Doctrine ORM Framework'; $docBlock = PHP_EOL.' * ' . implode(PHP_EOL . ' * ', $docBlock); $content = '<?php' . PHP_EOL.PHP_EOL; $content .= sprintf(self::$_tpl, $docBlock, false, $className, $extends, null, $code, null ); if ($this->_eolStyle) { $content = str_replace(PHP_EOL, $this->_eolStyle, $content); } return $content; } public function writeTableClassDefinition(array $definition, $path, $options = array()) { if ($prefix = $this->_classPrefix) { $className = $prefix . $definition['tableClassName']; if ($this->_classPrefixFiles) { $fileName = $className . $this->_suffix; } else { $fileName = $definition['tableClassName'] . $this->_suffix; } $writePath = $path . DIRECTORY_SEPARATOR . $fileName; } else { $className = $definition['tableClassName']; $fileName = $className . $this->_suffix; } if ($this->_pearStyle) { $writePath = $path . DIRECTORY_SEPARATOR . str_replace('_', '/', $fileName); } else { $writePath = $path . DIRECTORY_SEPARATOR . $fileName; } $content = $this->buildTableClassDefinition($className, $definition, $options); Doctrine_Lib::makeDirectories(dirname($writePath)); Doctrine_Core::loadModel($className, $writePath); if ( ! file_exists($writePath)) { file_put_contents($writePath, $content); } } protected function _getFileName($originalClassName, $definition) { if ($this->_classPrefixFiles) { $fileName = $definition['className'] . $this->_suffix; } else { $fileName = $originalClassName . $this->_suffix; } if ($this->_pearStyle) { $fileName = str_replace('_', '/', $fileName); } return $fileName; } public function writeDefinition(array $definition) { $originalClassName = $definition['className']; if ($prefix = $this->_classPrefix) { $definition['className'] = $prefix . $definition['className']; if (isset($definition['connectionClassName'])) { $definition['connectionClassName'] = $prefix . $definition['connectionClassName']; } $definition['topLevelClassName'] = $prefix . $definition['topLevelClassName']; if (isset($definition['inheritance']['extends'])) { $definition['inheritance']['extends'] = $prefix . $definition['inheritance']['extends']; } } $definitionCode = $this->buildDefinition($definition); if ($prefix) { $definitionCode = str_replace("this->hasOne('", "this->hasOne('$prefix", $definitionCode); $definitionCode = str_replace("this->hasMany('", "this->hasMany('$prefix", $definitionCode); $definitionCode = str_replace("'refClass' => '", "'refClass' => '$prefix", $definitionCode); } $fileName = $this->_getFileName($originalClassName, $definition); $packagesPath = $this->_packagesPath ? $this->_packagesPath:$this->_path; if (isset($definition['is_main_class']) && $definition['is_main_class']) { if (isset($definition['is_package']) && $definition['is_package']) { $writePath = $this->_path . DIRECTORY_SEPARATOR . $definition['package_name']; } else { $writePath = $this->_path; } if ($this->generateTableClasses()) { $this->writeTableClassDefinition($definition, $writePath, array('extends' => $definition['inheritance']['tableExtends'])); } } else if (isset($definition['is_package_class']) && $definition['is_package_class']) { if (isset($definition['package_custom_path'])) { $writePath = $definition['package_custom_path']; } else { $writePath = $packagesPath . DIRECTORY_SEPARATOR . $definition['package_path']; } if ($this->generateTableClasses()) { $this->writeTableClassDefinition($definition, $writePath, array('extends' => $definition['inheritance']['tableExtends'])); } } else if (isset($definition['is_base_class']) && $definition['is_base_class']) { if (isset($definition['is_package']) && $definition['is_package']) { $basePath = $this->_path . DIRECTORY_SEPARATOR . $definition['package_name']; $writePath = $basePath . DIRECTORY_SEPARATOR . $this->_baseClassesDirectory; } else { $writePath = $this->_path . DIRECTORY_SEPARATOR . $this->_baseClassesDirectory; } } if (isset($writePath)) { Doctrine_Lib::makeDirectories($writePath); $writePath .= DIRECTORY_SEPARATOR . $fileName; } else { Doctrine_Lib::makeDirectories($this->_path); $writePath = $this->_path . DIRECTORY_SEPARATOR . $fileName; } $code = "<?php" . PHP_EOL; if (isset($definition['connection']) && $definition['connection']) { $code .= "// Connection Component Binding" . PHP_EOL; $code .= "Doctrine_Manager::getInstance()->bindComponent('" . $definition['connectionClassName'] . "', '" . $definition['connection'] . "');" . PHP_EOL; } $code .= PHP_EOL . $definitionCode; if ($this->_eolStyle) { $code = str_replace(PHP_EOL, $this->_eolStyle, $code); } Doctrine_Lib::makeDirectories(dirname($writePath)); if (isset($definition['generate_once']) && $definition['generate_once'] === true) { if ( ! file_exists($writePath)) { $bytes = file_put_contents($writePath, $code); } } else { $bytes = file_put_contents($writePath, $code); } if (isset($bytes) && $bytes === false) { throw new Doctrine_Import_Builder_Exception("Couldn't write file " . $writePath); } Doctrine_Core::loadModel($definition['className'], $writePath); } }class Doctrine_Import_Mysql extends Doctrine_Import { protected $sql = array( 'listDatabases' => 'SHOW DATABASES', 'listTableFields' => 'DESCRIBE %s', 'listSequences' => 'SHOW TABLES', 'listTables' => 'SHOW TABLES', 'listUsers' => 'SELECT DISTINCT USER FROM USER', 'listViews' => "SHOW FULL TABLES %s WHERE Table_type = 'VIEW'", ); public function listSequences($database = null) { $query = 'SHOW TABLES'; if ( ! is_null($database)) { $query .= ' FROM ' . $database; } $tableNames = $this->conn->fetchColumn($query); return array_map(array($this->conn->formatter, 'fixSequenceName'), $tableNames); } public function listTableConstraints($table) { $keyName = 'Key_name'; $nonUnique = 'Non_unique'; if ($this->conn->getAttribute(Doctrine_Core::ATTR_FIELD_CASE) && ($this->conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_FIX_CASE)) { if ($this->conn->getAttribute(Doctrine_Core::ATTR_FIELD_CASE) == CASE_LOWER) { $keyName = strtolower($keyName); $nonUnique = strtolower($nonUnique); } else { $keyName = strtoupper($keyName); $nonUnique = strtoupper($nonUnique); } } $table = $this->conn->quoteIdentifier($table, true); $query = 'SHOW INDEX FROM ' . $table; $indexes = $this->conn->fetchAssoc($query); $result = array(); foreach ($indexes as $indexData) { if ( ! $indexData[$nonUnique]) { if ($indexData[$keyName] !== 'PRIMARY') { $index = $this->conn->formatter->fixIndexName($indexData[$keyName]); } else { $index = 'PRIMARY'; } if ( ! empty($index)) { $result[] = $index; } } } return $result; } public function listTableRelations($tableName) { $relations = array(); $sql = "SELECT column_name, REFERENCED_TABLE_NAME, REFERENCED_COLUMN_NAME FROM information_schema.key_column_usage WHERE table_name = '" . $tableName . "' AND table_schema = '" . $this->conn->getDatabaseName() . "' and REFERENCED_COLUMN_NAME is not NULL"; $results = $this->conn->fetchAssoc($sql); foreach ($results as $result) { $result = array_change_key_case($result, CASE_LOWER); $relations[] = array('table' => $result['referenced_table_name'], 'local' => $result['column_name'], 'foreign' => $result['referenced_column_name']); } return $relations; } public function listTableColumns($table) { $sql = 'DESCRIBE ' . $this->conn->quoteIdentifier($table, true); $result = $this->conn->fetchAssoc($sql); $description = array(); $columns = array(); foreach ($result as $key => $val) { $val = array_change_key_case($val, CASE_LOWER); $decl = $this->conn->dataDict->getPortableDeclaration($val); $values = isset($decl['values']) ? $decl['values'] : array(); $val['default'] = $val['default'] == 'CURRENT_TIMESTAMP' ? null : $val['default']; $description = array( 'name' => $val['field'], 'type' => $decl['type'][0], 'alltypes' => $decl['type'], 'ntype' => $val['type'], 'length' => $decl['length'], 'fixed' => (bool) $decl['fixed'], 'unsigned' => (bool) $decl['unsigned'], 'values' => $values, 'primary' => (strtolower($val['key']) == 'pri'), 'default' => $val['default'], 'notnull' => (bool) ($val['null'] != 'YES'), 'autoincrement' => (bool) (strpos($val['extra'], 'auto_increment') !== false), ); if (isset($decl['scale'])) { $description['scale'] = $decl['scale']; } $columns[$val['field']] = $description; } return $columns; } public function listTableIndexes($table) { $keyName = 'Key_name'; $nonUnique = 'Non_unique'; if ($this->conn->getAttribute(Doctrine_Core::ATTR_FIELD_CASE) && ($this->conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_FIX_CASE)) { if ($this->conn->getAttribute(Doctrine_Core::ATTR_FIELD_CASE) == CASE_LOWER) { $keyName = strtolower($keyName); $nonUnique = strtolower($nonUnique); } else { $keyName = strtoupper($keyName); $nonUnique = strtoupper($nonUnique); } } $table = $this->conn->quoteIdentifier($table, true); $query = 'SHOW INDEX FROM ' . $table; $indexes = $this->conn->fetchAssoc($query); $result = array(); foreach ($indexes as $indexData) { if ($indexData[$nonUnique] && ($index = $this->conn->formatter->fixIndexName($indexData[$keyName]))) { $result[] = $index; } } return $result; } public function listTables($database = null) { return $this->conn->fetchColumn($this->sql['listTables']); } public function listViews($database = null) { if (is_null($database)) { $query = 'SELECT table_name FROM information_schema.VIEWS'; } else { $query = sprintf($this->sql['listViews'], ' FROM ' . $database); } return $this->conn->fetchColumn($query); } }class Doctrine_Import_Mssql extends Doctrine_Import { public function listSequences($database = null) { $query = "SELECT name FROM sysobjects WHERE xtype = 'U'"; $tableNames = $this->conn->fetchColumn($query); return array_map(array($this->conn->formatter, 'fixSequenceName'), $tableNames); } public function listTableRelations($tableName) { $relations = array(); $sql = 'SELECT o1.name as table_name, c1.name as column_name, o2.name as referenced_table_name, c2.name as referenced_column_name, s.name as constraint_name FROM sysforeignkeys fk	inner join sysobjects o1 on fk.fkeyid = o1.id inner join sysobjects o2 on fk.rkeyid = o2.id inner join syscolumns c1 on c1.id = o1.id and c1.colid = fk.fkey inner join syscolumns c2 on c2.id = o2.id and c2.colid = fk.rkey inner join sysobjects s on fk.constid = s.id AND o1.name = \'' . $tableName . '\''; $results = $this->conn->fetchAssoc($sql); foreach ($results as $result) { $result = array_change_key_case($result, CASE_LOWER); $relations[] = array('table' => $result['referenced_table_name'], 'local' => $result['column_name'], 'foreign' => $result['referenced_column_name']); } return $relations; } public function listTableColumns($table) { $sql = 'EXEC sp_primary_keys_rowset @table_name = ' . $this->conn->quoteIdentifier($table, true); $result = $this->conn->fetchAssoc($sql); $primary = array(); foreach ($result as $key => $val) { $primary[] = $val['COLUMN_NAME']; } $sql = 'EXEC sp_columns @table_name = ' . $this->conn->quoteIdentifier($table, true); $result = $this->conn->fetchAssoc($sql); $columns = array(); foreach ($result as $key => $val) { $val = array_change_key_case($val, CASE_LOWER); if (strstr($val['type_name'], ' ')) { list($type, $identity) = explode(' ', $val['type_name']); } else { $type = $val['type_name']; $identity = ''; } if ($type == 'varchar') { $type .= '(' . $val['length'] . ')'; } $val['type'] = $type; $val['identity'] = $identity; $decl = $this->conn->dataDict->getPortableDeclaration($val); $isIdentity = (bool) (strtoupper(trim($identity)) == 'IDENTITY'); $isNullable = (bool) (strtoupper(trim($val['is_nullable'])) == 'NO'); $isPrimary = in_array($val['column_name'], $primary); $description = array( 'name' => $val['column_name'], 'ntype' => $type, 'type' => $decl['type'][0], 'alltypes' => $decl['type'], 'length' => $decl['length'], 'fixed' => (bool) $decl['fixed'], 'unsigned' => (bool) $decl['unsigned'], 'notnull' => $isIdentity ? true : $isNullable, 'default' => $val['column_def'], 'primary' => $isPrimary, 'autoincrement' => $isIdentity, ); $columns[$val['column_name']] = $description; } return $columns; } public function listTableIndexes($table) { } public function listTables($database = null) { $sql = "SELECT name FROM sysobjects WHERE type = 'U' AND name <> 'dtproperties' AND name <> 'sysdiagrams' ORDER BY name"; return $this->conn->fetchColumn($sql); } public function listTriggers($database = null) { $query = "SELECT name FROM sysobjects WHERE xtype = 'TR'"; $result = $this->conn->fetchColumn($query); return $result; } public function listTableTriggers($table) { $table = $this->conn->quote($table, 'text'); $query = "SELECT name FROM sysobjects WHERE xtype = 'TR' AND object_name(parent_obj) = " . $this->conn->quoteIdentifier($table, true); $result = $this->conn->fetchColumn($query); return $result; } public function listTableViews($table) { $keyName = 'INDEX_NAME'; $pkName = 'PK_NAME'; if ($this->conn->getAttribute(Doctrine_Core::ATTR_FIELD_CASE) && ($this->conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_FIX_CASE)) { if ($this->conn->getAttribute(Doctrine_Core::ATTR_FIELD_CASE) == CASE_LOWER) { $keyName = strtolower($keyName); $pkName = strtolower($pkName); } else { $keyName = strtoupper($keyName); $pkName = strtoupper($pkName); } } $table = $this->conn->quote($table, 'text'); $query = 'EXEC sp_statistics @table_name = ' . $this->conn->quoteIdentifier($table, true); $indexes = $this->conn->fetchColumn($query, $keyName); $query = 'EXEC sp_pkeys @table_name = ' . $this->conn->quoteIdentifier($table, true); $pkAll = $this->conn->fetchColumn($query, $pkName); $result = array(); foreach ($indexes as $index) { if ( ! in_array($index, $pkAll) && $index != null) { $result[] = $this->conn->formatter->fixIndexName($index); } } return $result; } public function listViews($database = null) { $query = "SELECT name FROM sysobjects WHERE xtype = 'V'"; return $this->conn->fetchColumn($query); } }class Doctrine_Import_Exception extends Doctrine_Exception { }class Doctrine_Import_Builder_Exception extends Doctrine_Import_Exception { }class Doctrine_Import_Oracle extends Doctrine_Import { public function listDatabases() { if ( ! $this->conn->getAttribute(Doctrine_Core::ATTR_EMULATE_DATABASE)) { throw new Doctrine_Import_Exception('database listing is only supported if the "emulate_database" option is enabled'); } $query = 'SELECT username FROM sys.user_users'; $result2 = $this->conn->standaloneQuery($query); $result = $result2->fetchColumn(); return $result; } public function listFunctions() { $query = "SELECT name FROM sys.user_source WHERE line = 1 AND type = 'FUNCTION'"; return $this->conn->fetchColumn($query); } public function listTriggers($database = null) { $query = "SELECT trigger_name FROM sys.user_triggers"; return $this->conn->fetchColumn($query); } public function listSequences($database = null) { $query = "SELECT sequence_name FROM sys.user_sequences"; $tableNames = $this->conn->fetchColumn($query); return array_map(array($this->conn->formatter, 'fixSequenceName'), $tableNames); } public function listTableConstraints($table) { $table = $this->conn->quote($table, 'text'); $query = 'SELECT index_name name FROM user_constraints' . ' WHERE table_name = ' . $table . ' OR table_name = ' . strtoupper($table); $constraints = $this->conn->fetchColumn($query); return array_map(array($this->conn->formatter, 'fixIndexName'), $constraints); } public function listTableColumns($table) { $sql = <<<QEND
SELECT tc.column_name, data_type,
CASE WHEN data_type = 'NUMBER' THEN data_precision ELSE data_length END AS data_length,
nullable, data_default, data_scale, data_precision, pk.primary
FROM all_tab_columns tc
LEFT JOIN (
 select 'primary' primary, cc.table_name, cc.column_name from all_constraints cons
 join all_cons_columns cc on cons.constraint_name = cc.constraint_name
 where cons.constraint_type = 'P'
) pk ON pk.column_name = tc.column_name and pk.table_name = tc.table_name
WHERE tc.table_name = :tableName ORDER BY column_id
QEND;
$result = $this->conn->fetchAssoc($sql, array(':tableName' => $table)); $descr = array(); foreach($result as $val) { $val = array_change_key_case($val, CASE_LOWER); $decl = $this->conn->dataDict->getPortableDeclaration($val); $descr[$val['column_name']] = array( 'name' => $val['column_name'], 'notnull' => (bool) ($val['nullable'] === 'N'), 'ntype' => $val['data_type'], 'type' => $decl['type'][0], 'alltypes' => $decl['type'], 'fixed' => (bool) $decl['fixed'], 'unsigned' => (bool) $decl['unsigned'], 'default' => $val['data_default'], 'length' => $val['data_length'], 'primary' => (bool) $val['primary'], 'scale' => isset($val['scale']) ? $val['scale']:null, ); } return $descr; } public function listTableIndexes($table) { $table = $this->conn->quote($table, 'text'); $query = 'SELECT index_name name FROM user_indexes' . ' WHERE table_name = ' . $table . ' OR table_name = ' . strtoupper($table) . ' AND generated = ' . $this->conn->quote('N', 'text'); $indexes = $this->conn->fetchColumn($query); return array_map(array($this->conn->formatter, 'fixIndexName'), $indexes); } public function listTableRelations($table) { $relations = array(); $sql = 'SELECT ' . 'rcc.table_name AS referenced_table_name, ' . 'lcc.column_name AS local_column_name, ' . 'rcc.column_name AS referenced_column_name ' . 'FROM user_constraints ac ' . 'JOIN user_cons_columns rcc ON ac.r_constraint_name = rcc.constraint_name ' . 'JOIN user_cons_columns lcc ON ac.constraint_name = lcc.constraint_name ' . "WHERE ac.constraint_type = 'R' AND ac.table_name = :tableName"; $results = $this->conn->fetchAssoc($sql, array(':tableName' => $table)); foreach ($results as $result) { $result = array_change_key_case($result, CASE_LOWER); $relations[] = array('table' => $result['referenced_table_name'], 'local' => $result['local_column_name'], 'foreign' => $result['referenced_column_name']); } return $relations; } public function listTables($database = null) { $query = "SELECT * FROM user_objects WHERE object_type = 'TABLE' and object_name in (select table_name from user_tables)"; return $this->conn->fetchColumn($query); } public function listTableTriggers($table) { } public function listTableViews($table) { } public function listUsers() { $query = 'SELECT username FROM sys.all_users'; return $this->conn->fetchColumn($query); } public function listViews($database = null) { $query = 'SELECT view_name FROM sys.user_views'; return $this->conn->fetchColumn($query); } }class Doctrine_Import_Pgsql extends Doctrine_Import { protected $sql = array( 'listDatabases' => 'SELECT datname FROM pg_database', 'listFunctions' => "SELECT
                                                proname
                                            FROM
                                                pg_proc pr,
                                                pg_type tp
                                            WHERE
                                                tp.oid = pr.prorettype
                                                AND pr.proisagg = FALSE
                                                AND tp.typname <> 'trigger'
                                                AND pr.pronamespace IN
                                                    (SELECT oid FROM pg_namespace
                                                     WHERE nspname NOT LIKE 'pg_%' AND nspname != 'information_schema'", 'listSequences' => "SELECT
                                                regexp_replace(relname, '_seq$', '')
                                            FROM
                                                pg_class
                                            WHERE relkind = 'S' AND relnamespace IN
                                                (SELECT oid FROM pg_namespace
                                                 WHERE nspname NOT LIKE 'pg_%' AND nspname != 'information_schema')", 'listTables' => "SELECT
                                                c.relname AS table_name
                                            FROM pg_class c, pg_user u
                                            WHERE c.relowner = u.usesysid
                                                AND c.relkind = 'r'
                                                AND NOT EXISTS (SELECT 1 FROM pg_views WHERE viewname = c.relname AND schemaname <> 'information_schema')
                                                AND c.relname !~ '^(pg_|sql_)'
                                            UNION
                                            SELECT c.relname AS table_name
                                            FROM pg_class c
                                            WHERE c.relkind = 'r'
                                                AND NOT EXISTS (SELECT 1 FROM pg_views WHERE viewname = c.relname)
                                                AND NOT EXISTS (SELECT 1 FROM pg_user WHERE usesysid = c.relowner)
                                                AND c.relname !~ '^pg_'", 'listViews' => 'SELECT viewname FROM pg_views', 'listUsers' => 'SELECT usename FROM pg_user', 'listTableConstraints' => "SELECT
                                                        relname
                                                   FROM
                                                        pg_class
                                                   WHERE oid IN (
                                                        SELECT indexrelid
                                                        FROM pg_index, pg_class
                                                        WHERE pg_class.relname = %s
                                                            AND pg_class.oid = pg_index.indrelid
                                                            AND (indisunique = 't' OR indisprimary = 't')
                                                        )", 'listTableIndexes' => "SELECT
                                                        relname
                                                   FROM
                                                        pg_class
                                                   WHERE oid IN (
                                                        SELECT indexrelid
                                                        FROM pg_index, pg_class
                                                        WHERE pg_class.relname = %s
                                                            AND pg_class.oid=pg_index.indrelid
                                                            AND indisunique != 't'
                                                            AND indisprimary != 't'
                                                        )", 'listTableColumns' => "SELECT
                                                     ordinal_position as attnum,
                                                     column_name as field,
                                                     udt_name as type,
                                                     data_type as complete_type,
                                                     t.typtype AS typtype,
                                                     is_nullable as isnotnull,
                                                     column_default as default,
                                                     (
                                                       SELECT 't'
                                                         FROM pg_index, pg_attribute a, pg_class c, pg_type t
                                                         WHERE c.relname = table_name AND a.attname = column_name
                                                         AND a.attnum > 0 AND a.attrelid = c.oid AND a.atttypid = t.oid
                                                         AND c.oid = pg_index.indrelid AND a.attnum = ANY (pg_index.indkey)
                                                         AND pg_index.indisprimary = 't'
                                                         AND format_type(a.atttypid, a.atttypmod) NOT LIKE 'information_schema%%'
                                                     ) as pri,
                                                     character_maximum_length as length
                                                   FROM information_schema.COLUMNS
                                                   WHERE table_name = %s
                                                   ORDER BY ordinal_position", 'listTableRelations' => "SELECT pg_catalog.pg_get_constraintdef(oid, true) as condef
                                                          FROM pg_catalog.pg_constraint r
                                                          WHERE r.conrelid =
                                                          (
                                                              SELECT c.oid
                                                              FROM pg_catalog.pg_class c
                                                              LEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
                                                              WHERE c.relname ~ ? AND pg_catalog.pg_table_is_visible(c.oid)
                                                          )
                                                          AND r.contype = 'f'" ); public function listTriggers($database = null) { } public function listTableConstraints($table) { $table = $this->conn->quote($table); $query = sprintf($this->sql['listTableConstraints'], $table); return $this->conn->fetchColumn($query); } public function listTableColumns($table) { $table = $this->conn->quote($table); $query = sprintf($this->sql['listTableColumns'], $table); $result = $this->conn->fetchAssoc($query); $columns = array(); foreach ($result as $key => $val) { $val = array_change_key_case($val, CASE_LOWER); if ($val['type'] == 'character varying') { $length = preg_replace('~.*\(([0-9]*)\).*~', '$1', $val['complete_type']); $val['length'] = $length; } else if (strpos($val['complete_type'], 'character varying') !== false) { $length = preg_replace('~.*\(([0-9]*)\).*~', '$1', $val['complete_type']); $val['length'] = $length; } $decl = $this->conn->dataDict->getPortableDeclaration($val); $description = array( 'name' => $val['field'], 'ntype' => $val['type'], 'type' => $decl['type'][0], 'alltypes' => $decl['type'], 'length' => $decl['length'], 'fixed' => (bool) $decl['fixed'], 'unsigned' => (bool) $decl['unsigned'], 'notnull' => ($val['isnotnull'] == 'NO'), 'default' => $val['default'], 'primary' => ($val['pri'] == 't'), ); if ($val['typtype'] == 'e'){ $description['default'] = isset($decl['default']) ? $decl['default'] : null; $t_result = $this->conn->fetchAssoc(sprintf('select enum_range(null::%s) as range ', $decl['enum_name'])); if (isset($t_result[0])){ $range = $t_result[0]['range']; $range = str_replace('{','',$range); $range = str_replace('}','',$range); $range = explode(',',$range); $description['values'] = $range; } } $matches = array(); if (preg_match("/^nextval\('(.*)'(::.*)?\)$/", $description['default'], $matches)) { $description['sequence'] = $this->conn->formatter->fixSequenceName($matches[1]); $description['default'] = null; } else if (preg_match("/^'(.*)'::character varying$/", $description['default'], $matches)) { $description['default'] = $matches[1]; } else if (preg_match("/^(.*)::character varying$/", $description['default'], $matches)) { $description['default'] = $matches[1]; } else if ($description['type'] == 'boolean') { if ($description['default'] === 'true') { $description['default'] = true; } else if ($description['default'] === 'false') { $description['default'] = false; } } $columns[$val['field']] = $description; } return $columns; } public function listTableIndexes($table) { $table = $this->conn->quote($table); $query = sprintf($this->sql['listTableIndexes'], $table); return $this->conn->fetchColumn($query); } public function listTables($database = null) { return $this->conn->fetchColumn($this->sql['listTables']); } public function listTableTriggers($table) { $query = 'SELECT trg.tgname AS trigger_name
                    FROM pg_trigger trg,
                         pg_class tbl
                   WHERE trg.tgrelid = tbl.oid'; if ($table !== null) { $table = $this->conn->quote(strtoupper($table), 'string'); $query .= " AND tbl.relname = $table"; } return $this->conn->fetchColumn($query); } public function listTableViews($table) { return $this->conn->fetchColumn($table); } public function listTableRelations($table) { $sql = $this->sql['listTableRelations']; $param = array('^(' . $table . ')$'); $relations = array(); $results = $this->conn->fetchAssoc($sql, $param); foreach ($results as $result) { preg_match('/FOREIGN KEY \((.+)\) REFERENCES (.+)\((.+)\)/', $result['condef'], $values); if ((strpos($values[1], ',') === false) && (strpos($values[3], ',') === false)) { $tableName = trim($values[2], '"'); $relations[] = array('table' => $tableName, 'local' => $values[1], 'foreign' => $values[3]); } } return $relations; } }class Doctrine_Import_Schema { protected static $_globalDefinitionKeys = array( 'connection', 'attributes', 'templates', 'actAs', 'options', 'package', 'package_custom_path', 'inheritance', 'detect_relations'); protected $_relations = array(); protected $_options = array('packagesPrefix' => 'Package', 'packagesPath' => '', 'packagesFolderName' => 'packages', 'suffix' => '.php', 'generateBaseClasses' => true, 'generateTableClasses' => false, 'generateAccessors' => false, 'baseClassPrefix' => 'Base', 'baseClassesDirectory' => 'generated', 'baseClassName' => 'Doctrine_Record'); protected $_validation = array('root' => array('abstract', 'connection', 'className', 'tableName', 'connection', 'relations', 'columns', 'indexes', 'attributes', 'templates', 'actAs', 'options', 'package', 'package_custom_path', 'inheritance', 'detect_relations', 'listeners', 'checks', 'comment'), 'column' => array('name', 'format', 'fixed', 'primary', 'autoincrement', 'type', 'length', 'size', 'default', 'scale', 'values', 'comment', 'sequence', 'protected', 'zerofill', 'owner', 'extra', 'comment', 'charset', 'collation'), 'relation' => array('key', 'class', 'alias', 'type', 'refClass', 'local', 'foreign', 'foreignClass', 'foreignAlias', 'foreignType', 'autoComplete', 'cascade', 'onDelete', 'onUpdate', 'equal', 'owningSide', 'refClassRelationAlias', 'foreignKeyName', 'orderBy'), 'inheritance'=> array('type', 'extends', 'keyField', 'keyValue')); public static function getGlobalDefinitionKeys() { return self::$_globalDefinitionKeys; } public function getOption($name) { if (isset($this->_options[$name])) { return $this->_options[$name]; } } public function getOptions() { return $this->_options; } public function setOption($name, $value) { if (isset($this->_options[$name])) { $this->_options[$name] = $value; } } public function setOptions($options) { if ( ! empty($options)) { $this->_options = $options; } } public function buildSchema($schema, $format) { $array = array(); foreach ((array) $schema AS $s) { if (is_file($s)) { $e = explode('.', $s); if (end($e) === $format) { $array = array_merge($array, $this->parseSchema($s, $format)); } } else if (is_dir($s)) { $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($s), RecursiveIteratorIterator::LEAVES_ONLY); foreach ($it as $file) { $e = explode('.', $file->getFileName()); if (end($e) === $format) { $array = array_merge($array, $this->parseSchema($file->getPathName(), $format)); } } } else { $array = array_merge($array, $this->parseSchema($s, $format)); } } $array = $this->_buildRelationships($array); $array = $this->_processInheritance($array); return $array; } public function importSchema($schema, $format = 'yml', $directory = null, $models = array()) { $schema = (array) $schema; $builder = new Doctrine_Import_Builder(); $builder->setTargetPath($directory); $builder->setOptions($this->getOptions()); $array = $this->buildSchema($schema, $format); if (count($array) == 0) { throw new Doctrine_Import_Exception( sprintf('No ' . $format . ' schema found in ' . implode(", ", $schema)) ); } foreach ($array as $name => $definition) { if ( ! empty($models) && !in_array($definition['className'], $models)) { continue; } $builder->buildRecord($definition); } } public function parseSchema($schema, $type) { $defaults = array('abstract' => false, 'className' => null, 'tableName' => null, 'connection' => null, 'relations' => array(), 'indexes' => array(), 'attributes' => array(), 'templates' => array(), 'actAs' => array(), 'options' => array(), 'package' => null, 'inheritance' => array(), 'detect_relations' => false); $array = Doctrine_Parser::load($schema, $type); $globals = array(); foreach ($array as $key => $value) { if (in_array($key, self::$_globalDefinitionKeys)) { unset($array[$key]); $globals[$key] = $value; } } foreach ($array as $className => $table) { $array[$className] = Doctrine_Lib::arrayDeepMerge($globals, $array[$className]); } $build = array(); foreach ($array as $className => $table) { $table = (array) $table; $this->_validateSchemaElement('root', array_keys($table), $className); $columns = array(); $className = isset($table['className']) ? (string) $table['className']:(string) $className; if (isset($table['inheritance']['keyField']) || isset($table['inheritance']['keyValue'])) { $table['inheritance']['type'] = 'column_aggregation'; } if (isset($table['tableName']) && $table['tableName']) { $tableName = $table['tableName']; } else { if (isset($table['inheritance']['type']) && ($table['inheritance']['type'] == 'column_aggregation')) { $tableName = null; } else { $tableName = Doctrine_Inflector::tableize($className); } } $connection = isset($table['connection']) ? $table['connection']:'current'; $columns = isset($table['columns']) ? $table['columns']:array(); if ( ! empty($columns)) { foreach ($columns as $columnName => $field) { if ( ! is_array($field)) { $original = $field; $field = array(); $field['type'] = $original; } $colDesc = array(); if (isset($field['name'])) { $colDesc['name'] = $field['name']; } else { $colDesc['name'] = $columnName; } $this->_validateSchemaElement('column', array_keys($field), $className . '->columns->' . $colDesc['name']); $e = explode('(', $field['type']); if (isset($e[0]) && isset($e[1])) { $colDesc['type'] = $e[0]; $value = substr($e[1], 0, strlen($e[1]) - 1); $e = explode(',', $value); $colDesc['length'] = $e[0]; if (isset($e[1]) && $e[1]) { $colDesc['scale'] = $e[1]; } } else { $colDesc['type'] = isset($field['type']) ? (string) $field['type']:null; $colDesc['length'] = isset($field['length']) ? (int) $field['length']:null; $colDesc['length'] = isset($field['size']) ? (int) $field['size']:$colDesc['length']; } $colDesc['fixed'] = isset($field['fixed']) ? (int) $field['fixed']:null; $colDesc['primary'] = isset($field['primary']) ? (bool) (isset($field['primary']) && $field['primary']):null; $colDesc['default'] = isset($field['default']) ? $field['default']:null; $colDesc['autoincrement'] = isset($field['autoincrement']) ? (bool) (isset($field['autoincrement']) && $field['autoincrement']):null; if (isset($field['sequence'])) { if (true === $field['sequence']) { $colDesc['sequence'] = $tableName; } else { $colDesc['sequence'] = (string) $field['sequence']; } } else { $colDesc['sequence'] = null; } $colDesc['values'] = isset($field['values']) ? (array) $field['values']:null; $validators = Doctrine_Manager::getInstance()->getValidators(); foreach ($validators as $validator) { if (isset($field[$validator])) { $colDesc[$validator] = $field[$validator]; } } $columns[(string) $columnName] = $colDesc; } } foreach ($defaults as $key => $defaultValue) { if (isset($table[$key]) && ! isset($build[$className][$key])) { $build[$className][$key] = $table[$key]; } else { $build[$className][$key] = isset($build[$className][$key]) ? $build[$className][$key]:$defaultValue; } } $build[$className]['className'] = $className; $build[$className]['tableName'] = $tableName; $build[$className]['columns'] = $columns; $build[$className] = Doctrine_Lib::arrayDeepMerge($table, $build[$className]); $build[$className]['connectionClassName'] = $build[$className]['className']; } return $build; } protected function _processInheritance($array) { foreach ($array as $className => $definition) { if ( ! empty($array[$className]['inheritance'])) { $this->_validateSchemaElement('inheritance', array_keys($definition['inheritance']), $className . '->inheritance'); if ( ! isset($array[$className]['inheritance']['type'])) { $array[$className]['inheritance']['type'] = 'concrete'; } if ($array[$className]['inheritance']['type'] == 'column_aggregation') { if ( ! isset($array[$className]['inheritance']['keyField'])) { $array[$className]['inheritance']['keyField'] = 'type'; } if ( ! isset($array[$className]['inheritance']['keyValue'])) { $array[$className]['inheritance']['keyValue'] = $className; } $parent = $this->_findBaseSuperClass($array, $definition['className']); if ( ! isset($array[$parent]['columns'][$array[$className]['inheritance']['keyField']])) { $array[$parent]['columns'][$array[$className]['inheritance']['keyField']] = array('name' => $array[$className]['inheritance']['keyField'], 'type' => 'string', 'length' => 255); } } } } $moves = array('columns' => array(), 'indexes' => array(), 'attributes' => array(), 'options' => array(), 'checks' => array()); foreach ($array as $className => $definition) { if (isset($definition['inheritance']['extends']) && isset($definition['inheritance']['type']) && ($definition['inheritance']['type'] == 'simple' || $definition['inheritance']['type'] == 'column_aggregation')) { $parent = $this->_findBaseSuperClass($array, $definition['className']); foreach ($moves as $move => $resetValue) { if (isset($array[$parent][$move]) && isset($definition[$move])) { $array[$parent][$move] = Doctrine_Lib::arrayDeepMerge($array[$parent][$move], $definition[$move]); $array[$definition['className']][$move] = $resetValue; } } if ($definition['inheritance']['type'] == 'column_aggregation') { $inheritanceFields = array($definition['inheritance']['keyField'] => $definition['inheritance']['keyValue']); $superClass = $definition['inheritance']['extends']; $multiInheritanceDef = $array[$superClass]; while (count($multiInheritanceDef['inheritance']) > 0 && array_key_exists('extends', $multiInheritanceDef['inheritance']) && $multiInheritanceDef['inheritance']['type'] == 'column_aggregation') { $superClass = $multiInheritanceDef['inheritance']['extends']; if ( ! isset($inheritanceFields[$multiInheritanceDef['inheritance']['keyField']])) { $inheritanceFields[$multiInheritanceDef['inheritance']['keyField']] = $multiInheritanceDef['inheritance']['keyValue']; } $multiInheritanceDef = $array[$superClass]; } $array[$parent]['inheritance']['subclasses'][$definition['className']] = $inheritanceFields; } } } return $array; } protected function _findBaseSuperClass($array, $class) { if (isset($array[$class]['inheritance']['extends']) && isset($array[$class]['inheritance']['type']) && ($array[$class]['inheritance']['type'] == 'simple' || $array[$class]['inheritance']['type'] == 'column_aggregation')) { return $this->_findBaseSuperClass($array, $array[$class]['inheritance']['extends']); } else { return $class; } } protected function _buildRelationships($array) { foreach ($array as $className => $properties) { if (isset($properties['columns']) && ! empty($properties['columns']) && isset($properties['detect_relations']) && $properties['detect_relations']) { foreach ($properties['columns'] as $column) { if (strpos($column['name'], '_id')) { $columnClassName = Doctrine_Inflector::classify(str_replace('_id', '', $column['name'])); if (isset($array[$columnClassName]) && !isset($array[$className]['relations'][$columnClassName])) { $array[$className]['relations'][$columnClassName] = array(); $type = isset($array[$columnClassName]['columns']['id']['type']) ? $array[$columnClassName]['columns']['id']['type']:'integer'; $length = isset($array[$columnClassName]['columns']['id']['length']) ? $array[$columnClassName]['columns']['id']['length']:8; $array[$className]['columns'][$column['name']]['type'] = $type; $array[$className]['columns'][$column['name']]['length'] = $length; } } } } } foreach ($array as $name => $properties) { if ( ! isset($properties['relations'])) { continue; } $className = $properties['className']; $relations = $properties['relations']; foreach ($relations as $alias => $relation) { $class = isset($relation['class']) ? $relation['class']:$alias; if ( ! isset($array[$class])) { continue; } $relation['class'] = $class; $relation['alias'] = isset($relation['alias']) ? $relation['alias'] : $alias; if (isset($relation['refClass'])) { $relation['local'] = isset($relation['local']) ? $relation['local']:Doctrine_Inflector::tableize($name) . '_id'; $relation['foreign'] = isset($relation['foreign']) ? $relation['foreign']:Doctrine_Inflector::tableize($class) . '_id'; } else { $relation['local'] = isset($relation['local']) ? $relation['local']:Doctrine_Inflector::tableize($relation['class']) . '_id'; $relation['foreign'] = isset($relation['foreign']) ? $relation['foreign']:'id'; } if (isset($relation['refClass'])) { $relation['type'] = 'many'; } if (isset($relation['type']) && $relation['type']) { $relation['type'] = $relation['type'] === 'one' ? Doctrine_Relation::ONE:Doctrine_Relation::MANY; } else { $relation['type'] = Doctrine_Relation::ONE; } if (isset($relation['foreignType']) && $relation['foreignType']) { $relation['foreignType'] = $relation['foreignType'] === 'one' ? Doctrine_Relation::ONE:Doctrine_Relation::MANY; } $relation['key'] = $this->_buildUniqueRelationKey($relation); $this->_validateSchemaElement('relation', array_keys($relation), $className . '->relation->' . $relation['alias']); $this->_relations[$className][$alias] = $relation; } } $this->_autoCompleteOppositeRelations(); $this->_fixDuplicateRelations(); foreach ($this->_relations as $className => $relations) { $array[$className]['relations'] = $relations; } return $array; } protected function _autoCompleteOppositeRelations() { foreach($this->_relations as $className => $relations) { foreach ($relations AS $alias => $relation) { if ((isset($relation['equal']) && $relation['equal']) || (isset($relation['autoComplete']) && $relation['autoComplete'] === false)) { continue; } $newRelation = array(); $newRelation['foreign'] = $relation['local']; $newRelation['local'] = $relation['foreign']; $newRelation['class'] = isset($relation['foreignClass']) ? $relation['foreignClass']:$className; $newRelation['alias'] = isset($relation['foreignAlias']) ? $relation['foreignAlias']:$className; $newRelation['foreignAlias'] = $alias; $newRelation['autogenerated'] = true; if (isset($relation['refClass'])) { $newRelation['refClass'] = $relation['refClass']; $newRelation['type'] = isset($relation['foreignType']) ? $relation['foreignType']:$relation['type']; } else { if (isset($relation['foreignType'])) { $newRelation['type'] = $relation['foreignType']; } else { $newRelation['type'] = $relation['type'] === Doctrine_Relation::ONE ? Doctrine_Relation::MANY:Doctrine_Relation::ONE; } } if ( ! isset($this->_relations[$relation['class']][$newRelation['alias']])) { $newRelation['key'] = $this->_buildUniqueRelationKey($newRelation); $this->_relations[$relation['class']][$newRelation['alias']] = $newRelation; } } } } protected function _fixDuplicateRelations() { foreach($this->_relations as $className => $relations) { $existingRelations = array(); $uniqueRelations = array(); foreach ($relations as $relation) { if ( ! in_array($relation['key'], $existingRelations)) { $existingRelations[] = $relation['key']; $uniqueRelations = array_merge($uniqueRelations, array($relation['alias'] => $relation)); } else { if ( ! isset($relation['autogenerated']) || $relation['autogenerated'] != true) { $uniqueRelations = array_merge($uniqueRelations, array($relation['alias'] => $relation)); } } } $this->_relations[$className] = $uniqueRelations; } } protected function _buildUniqueRelationKey($relation) { return md5($relation['local'].$relation['foreign'].$relation['class'].(isset($relation['refClass']) ? $relation['refClass']:null)); } protected function _validateSchemaElement($name, $element, $path) { $element = (array) $element; $validation = $this->_validation[$name]; if ($name == 'column') { $validators = Doctrine_Manager::getInstance()->getValidators(); $validation = array_merge($validation, $validators); } $validation = array_flip($validation); foreach ($element as $key => $value) { if ( ! isset($validation[$value])) { throw new Doctrine_Import_Exception( sprintf('Invalid schema element named "' . $value . '" at path "' . $path . '"') ); } } } }class Doctrine_Adapter_Oracle implements Doctrine_Adapter_Interface { protected $executeMode = OCI_COMMIT_ON_SUCCESS; protected $connection = false; protected $attributes = array(Doctrine_Core::ATTR_DRIVER_NAME => "oci8", Doctrine_Core::ATTR_ERRMODE => Doctrine_Core::ERRMODE_SILENT); protected $config = array( 'dbname' => null, 'username' => null, 'password' => null, 'charset' => null, 'persistent' => false ); public function __construct($config = array(), $username = null, $password = null) { if (is_string($config)) { $config = str_replace("oracle:","",$config); $parts = explode(";", $config); foreach($parts as $part) { $e = explode("=", $part); $key = array_shift($e); $this->config[$key] = implode('=', $e); } if ($username) { $this->config['username'] = $username; } if ($password) { $this->config['password'] = $password; } } else { if ( ! isset($config['password']) || ! isset($config['username'])) { throw new Doctrine_Adapter_Exception('config array must have at least a username and a password'); } $this->config['username'] = $config['username']; $this->config['password'] = $config['password']; $this->config['dbname'] = $config['dbname']; if (isset($config['charset'])) { $this->config['charset'] = $config['charset']; } if (isset($config['persistent'])) { $this->config['persistent'] = $config['persistent']; } } if ($this->config['persistent'] == 'true'){ $this->connection = @oci_pconnect($this->config['username'], $this->config['password'], $this->config['dbname'], $this->config['charset']); } else { $this->connection = @oci_new_connect($this->config['username'], $this->config['password'], $this->config['dbname'], $this->config['charset']); } if ($this->connection === false) { throw new Doctrine_Adapter_Exception(sprintf("Unable to Connect to :'%s' as '%s'", $this->config['dbname'], $this->config['username'])); } } public function prepare($query) { $stmt = new Doctrine_Adapter_Statement_Oracle($this, $query, $this->executeMode); return $stmt; } public function query($query) { $stmt = new Doctrine_Adapter_Statement_Oracle($this, $query, $this->executeMode); $stmt->execute(); return $stmt; } public function quote($input) { return "'" . str_replace("'","''",$input) . "'"; } public function exec($statement) { $stmt = new Doctrine_Adapter_Statement_Oracle($this, $statement, $this->executeMode); $stmt->execute(); $count = $stmt->rowCount(); return $count; } public function lastInsertId() { throw new Doctrine_Adapter_Exception("unsupported"); } public function beginTransaction() { $this->executeMode = OCI_DEFAULT; return true; } public function commit() { return @oci_commit($this->connection); } public function rollBack() { return @oci_rollback($this->connection); } public function setAttribute($attribute, $value) { switch ($attribute) { case Doctrine_Core::ATTR_DRIVER_NAME: case Doctrine_Core::ATTR_ERRMODE: break; case Doctrine_Core::ATTR_CASE: if ($value == Doctrine_Core::CASE_NATURAL) { break; } else { throw new Doctrine_Adapter_Exception("Unsupported Option for ATTR_CASE: $value"); } default: throw new Doctrine_Adapter_Exception("Unsupported Attribute: $attribute"); return false; } $this->attributes[$attribute] = $value; return true; } public function getAttribute($attribute) { return $this->attributes[$attribute]; } public function getConnection() { return $this->connection; } public function getUserName() { return $this->config['username']; } public function errorCode() { if (is_resource($this->connection)) { $error = @oci_error($this->connection); } else { $error = @oci_error(); } return $error['code']; } public function errorInfo() { if (is_resource($this->connection)) { $error = @oci_error($this->connection); } else { $error = @oci_error(); } return $error['message']; } public function __destruct() { if (is_resource($this->connection)) { @oci_rollback($this->connection); @oci_close($this->connection); } } }class Doctrine_Adapter_IcingaOracle extends Doctrine_Adapter_Oracle implements Doctrine_Adapter_Interface { protected $executeMode = OCI_COMMIT_ON_SUCCESS; protected $connection = false; protected $attributes = array(Doctrine_Core::ATTR_DRIVER_NAME => "oci8", Doctrine_Core::ATTR_ERRMODE => Doctrine_Core::ERRMODE_SILENT); protected $config = array( 'dbname' => null, 'username' => null, 'password' => null, 'charset' => null, 'persistent' => false ); public function __construct($config = array(), $username = null, $password = null) { if (is_string($config)) { $config = str_replace("oracle:","",$config); $parts = explode(";", $config); foreach($parts as $part) { $e = explode("=", $part); $key = array_shift($e); $this->config[$key] = implode('=', $e); } if ($username) { $this->config['username'] = $username; } if ($password) { $this->config['password'] = $password; } } else { if ( ! isset($config['password']) || ! isset($config['username'])) { throw new Doctrine_Adapter_Exception('config array must have at least a username and a password'); } $this->config['username'] = $config['username']; $this->config['password'] = $config['password']; $this->config['dbname'] = $config['dbname']; if (isset($config['charset'])) { $this->config['charset'] = $config['charset']; } if (isset($config['persistent'])) { $this->config['persistent'] = $config['persistent']; } } if ($this->config['persistent'] == 'true'){ $this->connection = @oci_pconnect($this->config['username'], $this->config['password'], $this->config['dbname'], $this->config['charset']); } else { $this->connection = @oci_new_connect($this->config['username'], $this->config['password'], $this->config['dbname'], $this->config['charset']); } if ($this->connection === false) { throw new Doctrine_Adapter_Exception(sprintf("Unable to Connect to :'%s' as '%s' : %s", $this->config['dbname'], $this->config['username'],print_r(oci_error(),true))); } } public function prepare($query) { $stmt = new Doctrine_Adapter_Statement_IcingaOracle($this, $query, $this->executeMode); return $stmt; } public function prepareBase($query) { $stmt = new Doctrine_Adapter_Statement_Oracle($this, $query, $this->executeMode); return $stmt; } public function query($query) { $stmt = new Doctrine_Adapter_Statement_IcingaOracle($this, $query, $this->executeMode); $stmt->execute(); return $stmt; } public function quote($input) { return "'" . str_replace("'","''",$input) . "'"; } public function exec($statement) { $stmt = new Doctrine_Adapter_Statement_IcingaOracle($this, $statement, $this->executeMode); $stmt->execute(); $count = $stmt->rowCount(); return $count; } public function lastInsertId() { throw new Doctrine_Adapter_Exception("unsupported"); } public function beginTransaction() { $this->executeMode = OCI_DEFAULT; return true; } public function commit() { return @oci_commit($this->connection); } public function rollBack() { return @oci_rollback($this->connection); } public function setAttribute($attribute, $value) { switch ($attribute) { case Doctrine_Core::ATTR_DRIVER_NAME: case Doctrine_Core::ATTR_ERRMODE: break; case Doctrine_Core::ATTR_CASE: if ($value == Doctrine_Core::CASE_NATURAL) { break; } else { throw new Doctrine_Adapter_Exception("Unsupported Option for ATTR_CASE: $value"); } default: throw new Doctrine_Adapter_Exception("Unsupported Attribute: $attribute"); return false; } $this->attributes[$attribute] = $value; return true; } public function getAttribute($attribute) { return $this->attributes[$attribute]; } public function getConnection() { return $this->connection; } public function getUserName() { return $this->config['username']; } public function errorCode() { if (is_resource($this->connection)) { $error = @oci_error($this->connection); } else { $error = @oci_error(); } return $error['code']; } public function errorInfo() { if (is_resource($this->connection)) { $error = @oci_error($this->connection); } else { $error = @oci_error(); } return $error['message']; } public function __destruct() { if (is_resource($this->connection)) { @oci_rollback($this->connection); @oci_close($this->connection); } } } class Doctrine_Adapter_Statement_IcingaOracle implements Doctrine_Adapter_Statement_Interface { public $queryString; protected $connection; protected $statement; protected $executeMode = OCI_COMMIT_ON_SUCCESS; protected $bindParams = array(); protected $attributes = array(); protected $ociErrors = array(); public function __construct( Doctrine_Adapter_IcingaOracle $connection, $query, $executeMode) { $this->connection = $connection->getConnection(); $this->queryString =$this->fixCrappyIcingaTables($query); $this->executeMode = $executeMode; $this->attributes[Doctrine_Core::ATTR_ERRMODE] = $connection->getAttribute(Doctrine_Core::ATTR_ERRMODE); $this->parseQuery(); } private $aliasMap = array(); public function fixCrappyIcingaTables($query) { $this->resolveIdFields($query); $this->createAliasMap($query); $this->removeInvalidAliases($query); $query = preg_replace("/notification_timeperiod_object_id/", "notif_timeperiod_object_id",$query); $query = preg_replace("/([^ ]*long_output)/i", "TO_CHAR($1)",$query); $query = preg_replace("/([^ ]*perfdata)/i", "TO_CHAR($1)",$query); $query = preg_replace("/([^ ]*logentry_data)/i", "TO_CHAR($1)",$query); if(substr_count($query,"(") != substr_count($query,")")) $query .= ")"; return $query; } private function removeInvalidAliases(&$query) { $query = preg_replace("/(ORDER BY) *([A-Za-z._0-9]+) +AS +[_A-Za-z0-9]+/i","$1 $2",$query); } private function resolveIdFields(&$query) { $tableRefMapRegExpNoAlias = "/(FROM|JOIN) *(?<table>\w+) *(WHERE|INNER|JOIN|ON|ORDER|LIMIT|GROUP)/"; $tableRefMapRegExp = "/(FROM|JOIN) *(?<table>\w+) *(AS)? *(?<alias>\w+) */"; $aliasedSelectExp = "/FROM *\( *SELECT.*?FROM *(?<table>\w+) .*\) *(?<alias>\w+) *WHERE/"; $matches = array(); $noAliasMatches = array(); $aliasedSelectMatches = array(); preg_match_all($tableRefMapRegExpNoAlias,$query,$noAliasMatches); preg_match_all($tableRefMapRegExp,$query,$matches); preg_match_all($aliasedSelectExp,$query,$aliasedSelectMatches); foreach($noAliasMatches["table"] as $entry) { $matches["table"][] = $entry; $matches["alias"][] = $entry; } $matches["table"] = array_merge($matches["table"],$aliasedSelectMatches["table"]); $matches["alias"] = array_merge($matches["alias"],$aliasedSelectMatches["alias"]); for($i=0;$i<count($matches["table"]);$i++) { $table = $matches["table"][$i]; $alias = $matches["alias"][$i]; $editedTable = $table; if(preg_match("/[^uai]s$/",$table)) $editedTable = substr($table,0,-1); $editedTable = preg_replace("/ie$/","y",$editedTable); $id = $alias.".".$editedTable."_id"; $query = preg_replace("/".$id."/",$alias.".id",$query); } } private function createAliasMap(&$query) { $ctr = 0; $matches = array(); $reg = "/AS +(?<alias>\w+)/"; $this->aliasMap = array(); preg_match_all($reg,$query,$matches); foreach($matches["alias"] as $alias) { if(preg_match("/DOCTRINE.*?/i",$alias)) continue; $query = preg_replace("/(AS +)".$alias."/","AS f_".$ctr,$query,1); $this->aliasMap[("f_".($ctr++))] = $alias; } } public function bindColumn($column, $param, $type = null) { throw new Doctrine_Adapter_Exception("Unsupported"); } public function bindValue($param, $value, $type = null) { $this->bindParams[] = $value; $this->bindParam($param, $this->bindParams[count($this->bindParams) - 1], $type); } public function bindParam($column, &$variable, $type = null, $length = null, $driverOptions = array()) { if ($driverOptions || $length ) { throw new Doctrine_Adapter_Exception('Unsupported parameters:$length, $driverOptions'); } if ($length === null) { $oci_length = -1; } $oci_type = SQLT_CHR; switch ($type) { case Doctrine_Core::PARAM_STR: $oci_type = SQLT_CHR; break; } if (is_integer($column)) { $variable_name = ":oci_b_var_$column"; } else { $variable_name = $column; } $status = @oci_bind_by_name($this->statement, $variable_name, $variable, $oci_length, $oci_type); if ($status === false) { $this->handleError(); } return $status; } public function closeCursor() { $this->bindParams = array(); return oci_free_statement($this->statement); } public function columnCount() { return oci_num_fields ( $this->statement ); } public function errorCode() { $oci_error = $this->getOciError(); return $oci_error['code']; } public function errorInfo() { $oci_error = $this->getOciError(); return $oci_error['message'] . " : " . $oci_error['sqltext']; } private function getOciError() { if (is_resource($this->statement)) { $oci_error = oci_error ($this->statement); } else { $oci_error = oci_error (); } if ($oci_error) { $this->oci_errors[] = $oci_error; } else if (count($this->ociErrors) > 0) { $oci_error = $this->ociErrors[count($this->ociErrors)-1]; } return $oci_error; } public function execute($params = null) { if (is_array($params)) { foreach ($params as $var => $value) { $this->bindValue($var+1, $value); } } $result = @oci_execute($this->statement , $this->executeMode ); if ($result === false) { $this->handleError(); return false; } return true; } public function fetch($fetchStyle = Doctrine_Core::FETCH_BOTH, $cursorOrientation = Doctrine_Core::FETCH_ORI_NEXT, $cursorOffset = null) { switch ($fetchStyle) { case Doctrine_Core::FETCH_BOTH : $result = oci_fetch_array($this->statement, OCI_BOTH + OCI_RETURN_NULLS + OCI_RETURN_LOBS); break; case Doctrine_Core::FETCH_ASSOC : $result = oci_fetch_array($this->statement, OCI_ASSOC + OCI_RETURN_NULLS + OCI_RETURN_LOBS); break; case Doctrine_Core::FETCH_NUM : $result = oci_fetch_array($this->statement, OCI_NUM + OCI_RETURN_NULLS + OCI_RETURN_LOBS); break; case Doctrine_Core::FETCH_OBJ: $result = oci_fetch_object($this->statement, OCI_NUM + OCI_RETURN_NULLS + OCI_RETURN_LOBS); break; default: throw new Doctrine_Adapter_Exception("This type of fetch is not supported: ".$fetchStyle); } $result = $this->resolveAliases($result,$fetchStyle); return $result; } protected function resolveAliases($result, $fetchStyle) { if(empty($result)) return $result; switch($fetchStyle) { case Doctrine_Core::FETCH_BOTH: case Doctrine_Core::FETCH_ASSOC: foreach($this->aliasMap as $alias=>$value) { if(!array_key_exists(strtoupper($alias),$result)) { continue; } $result[$value] = $result[strtoupper($alias)]; } return $result; case Doctrine_Core::FETCH_NUM: return $result; case Doctrine_Core::FETCH_OBJ: foreach($this->aliasMap as $alias=>$value) { $result->{$value} = $result->{$alias}; } return $result; } } public function fetchAll($fetchStyle = Doctrine_Core::FETCH_BOTH, $colnum=0) { $fetchColumn = false; $skip = 0; $maxrows = -1; $data = array(); $flags = OCI_FETCHSTATEMENT_BY_ROW + OCI_ASSOC; $int = $fetchStyle & Doctrine_Core::FETCH_COLUMN; if ($fetchStyle == Doctrine_Core::FETCH_BOTH) { $flags = OCI_BOTH; $numberOfRows = @oci_fetch_all($this->statement, $data, $skip, $maxrows, OCI_FETCHSTATEMENT_BY_ROW + OCI_ASSOC + OCI_RETURN_LOBS); } else if ($fetchStyle == Doctrine_Core::FETCH_ASSOC) { $numberOfRows = @oci_fetch_all($this->statement, $data, $skip, $maxrows, OCI_FETCHSTATEMENT_BY_ROW + OCI_ASSOC + OCI_RETURN_LOBS); } else if ($fetchStyle == Doctrine_Core::FETCH_NUM) { $numberOfRows = @oci_fetch_all($this->statement, $data, $skip, $maxrows, OCI_FETCHSTATEMENT_BY_ROW + OCI_NUM + OCI_RETURN_LOBS); } else if ($fetchStyle == Doctrine_Core::FETCH_COLUMN) { while ($row = @oci_fetch_array ($this->statement, OCI_NUM+OCI_RETURN_LOBS)) { $data[] = $row[$colnum]; } } else { throw new Doctrine_Adapter_Exception("Unsupported mode: '" . $fetchStyle . "' "); } foreach($data as &$i) { $i = $this->resolveAliases($i,$fetchStyle); } return $data; } public function fetchColumn($columnIndex = 0) { if ( ! is_integer($columnIndex)) { $this->handleError(array('message'=>"columnIndex parameter should be numeric")); return false; } $row = $this->fetch(Doctrine_Core::FETCH_NUM); return isset($row[$columnIndex]) ? $row[$columnIndex] : false; } public function fetchObject($className = 'stdClass', $args = array()) { $row = $this->fetch(Doctrine_Core::FETCH_ASSOC); if ($row === false) { return false; } $instantiation_code = "\$object = new $className("; $firstParam=true; foreach ($args as $index=>$value) { if ( ! $firstParam ) { $instantiation_code = $instantiation_code . ","; } else { $firstParam= false; } if ( is_string($index)) { $instantiation_code = $instantiation_code . " \$args['$index']"; } else { $instantiation_code = $instantiation_code . "\$args[$index]"; } } $instantiation_code = $instantiation_code . ");"; eval($instantiation_code); foreach ($row as $col => $value) { $object->$col = $value; } return $object; } public function getColumnMeta($column) { if (is_integer($column)) { $internal_column = $column +1; } else { $internal_column = $column; } $data = array(); $data['native_type'] = oci_field_type($this->statement, $internal_column); $data['flags'] = ""; $data['len'] = oci_field_size($this->statement, $internal_column); $data['name'] = oci_field_name($this->statement, $internal_column); $data['precision'] = oci_field_precision($this->statement, $internal_column); return $data; } public function nextRowset() { throw new Doctrine_Adapter_Exception("Unsupported"); } public function rowCount() { return @oci_num_rows($this->statement); } public function setAttribute($attribute, $value) { switch ($attribute) { case Doctrine_Core::ATTR_ERRMODE; break; default: throw new Doctrine_Adapter_Exception("Unsupported Attribute: $attribute"); } $this->attributes[$attribute] = $value; } public function getAttribute($attribute) { return $this->attributes[$attribute]; } public function setFetchMode($mode, $arg1 = null, $arg2 = null) { throw new Doctrine_Adapter_Exception("Unsupported"); } private function handleError($params=array()) { switch ($this->attributes[Doctrine_Core::ATTR_ERRMODE]) { case Doctrine_Core::ERRMODE_EXCEPTION: if (isset($params['message'])) { throw new Doctrine_Adapter_Exception($params['message']); } else { throw new Doctrine_Adapter_Exception($this->errorInfo()); } break; case Doctrine_Core::ERRMODE_WARNING: case Doctrine_Core::ERRMODE_SILENT: break; } } private function parseQuery($query=null) { if (is_null($query)) { $query = $this->queryString; } $bind_index = 1; $query = preg_replace("/(\?)/e", '":oci_b_var_". $bind_index++' , $query); $this->statement = @oci_parse($this->connection, $query); if ( $this->statement == false ) { throw new Doctrine_Adapter_Exception($this->getOciError()); } return $this->statement; } } class Doctrine_Adapter_Statement_Oracle implements Doctrine_Adapter_Statement_Interface { public $queryString; protected $connection; protected $statement; protected $executeMode = OCI_COMMIT_ON_SUCCESS; protected $bindParams = array(); protected $attributes = array(); protected $ociErrors = array(); public function __construct( Doctrine_Adapter_Oracle $connection, $query, $executeMode) { $this->connection = $connection->getConnection(); $this->queryString = $query; $this->executeMode = $executeMode; $this->attributes[Doctrine_Core::ATTR_ERRMODE] = $connection->getAttribute(Doctrine_Core::ATTR_ERRMODE); $this->parseQuery(); } public function bindColumn($column, $param, $type = null) { throw new Doctrine_Adapter_Exception("Unsupported"); } public function bindValue($param, $value, $type = null) { $this->bindParams[] = $value; $this->bindParam($param, $this->bindParams[count($this->bindParams) - 1], $type); } public function bindParam($column, &$variable, $type = null, $length = null, $driverOptions = array()) { if ($driverOptions || $length ) { throw new Doctrine_Adapter_Exception('Unsupported parameters:$length, $driverOptions'); } if ($length === null) { $oci_length = -1; } $oci_type = SQLT_CHR; switch ($type) { case Doctrine_Core::PARAM_STR: $oci_type = SQLT_CHR; break; } if (is_integer($column)) { $variable_name = ":oci_b_var_$column"; } else { $variable_name = $column; } $status = @oci_bind_by_name($this->statement, $variable_name, $variable, $oci_length, $oci_type); if ($status === false) { $this->handleError(); } return $status; } public function closeCursor() { $this->bindParams = array(); return oci_free_statement($this->statement); } public function columnCount() { return oci_num_fields ( $this->statement ); } public function errorCode() { $oci_error = $this->getOciError(); return $oci_error['code']; } public function errorInfo() { $oci_error = $this->getOciError(); return $oci_error['message'] . " : " . $oci_error['sqltext']; } private function getOciError() { if (is_resource($this->statement)) { $oci_error = oci_error ($this->statement); } else { $oci_error = oci_error (); } if ($oci_error) { $this->oci_errors[] = $oci_error; } else if (count($this->ociErrors) > 0) { $oci_error = $this->ociErrors[count($this->ociErrors)-1]; } return $oci_error; } public function execute($params = null) { if (is_array($params)) { foreach ($params as $var => $value) { $this->bindValue($var+1, $value); } } $result = @oci_execute($this->statement , $this->executeMode ); if ($result === false) { $this->handleError(); return false; } return true; } public function fetch($fetchStyle = Doctrine_Core::FETCH_BOTH, $cursorOrientation = Doctrine_Core::FETCH_ORI_NEXT, $cursorOffset = null) { switch ($fetchStyle) { case Doctrine_Core::FETCH_BOTH : return oci_fetch_array($this->statement, OCI_BOTH + OCI_RETURN_NULLS + OCI_RETURN_LOBS); break; case Doctrine_Core::FETCH_ASSOC : return oci_fetch_array($this->statement, OCI_ASSOC + OCI_RETURN_NULLS + OCI_RETURN_LOBS); break; case Doctrine_Core::FETCH_NUM : return oci_fetch_array($this->statement, OCI_NUM + OCI_RETURN_NULLS + OCI_RETURN_LOBS); break; case Doctrine_Core::FETCH_OBJ: return oci_fetch_object($this->statement, OCI_NUM + OCI_RETURN_NULLS + OCI_RETURN_LOBS); break; default: throw new Doctrine_Adapter_Exception("This type of fetch is not supported: ".$fetchStyle); } } public function fetchAll($fetchStyle = Doctrine_Core::FETCH_BOTH, $colnum=0) { $fetchColumn = false; $skip = 0; $maxrows = -1; $data = array(); $flags = OCI_FETCHSTATEMENT_BY_ROW + OCI_ASSOC; $int = $fetchStyle & Doctrine_Core::FETCH_COLUMN; if ($fetchStyle == Doctrine_Core::FETCH_BOTH) { $flags = OCI_BOTH; $numberOfRows = @oci_fetch_all($this->statement, $data, $skip, $maxrows, OCI_FETCHSTATEMENT_BY_ROW + OCI_ASSOC + OCI_RETURN_LOBS); } else if ($fetchStyle == Doctrine_Core::FETCH_ASSOC) { $numberOfRows = @oci_fetch_all($this->statement, $data, $skip, $maxrows, OCI_FETCHSTATEMENT_BY_ROW + OCI_ASSOC + OCI_RETURN_LOBS); } else if ($fetchStyle == Doctrine_Core::FETCH_NUM) { $numberOfRows = @oci_fetch_all($this->statement, $data, $skip, $maxrows, OCI_FETCHSTATEMENT_BY_ROW + OCI_NUM + OCI_RETURN_LOBS); } else if ($fetchStyle == Doctrine_Core::FETCH_COLUMN) { while ($row = @oci_fetch_array ($this->statement, OCI_NUM+OCI_RETURN_LOBS)) { $data[] = $row[$colnum]; } } else { throw new Doctrine_Adapter_Exception("Unsupported mode: '" . $fetchStyle . "' "); } return $data; } public function fetchColumn($columnIndex = 0) { if ( ! is_integer($columnIndex)) { $this->handleError(array('message'=>"columnIndex parameter should be numeric")); return false; } $row = $this->fetch(Doctrine_Core::FETCH_NUM); return isset($row[$columnIndex]) ? $row[$columnIndex] : false; } public function fetchObject($className = 'stdClass', $args = array()) { $row = $this->fetch(Doctrine_Core::FETCH_ASSOC); if ($row === false) { return false; } $instantiation_code = "\$object = new $className("; $firstParam=true; foreach ($args as $index=>$value) { if ( ! $firstParam ) { $instantiation_code = $instantiation_code . ","; } else { $firstParam= false; } if ( is_string($index)) { $instantiation_code = $instantiation_code . " \$args['$index']"; } else { $instantiation_code = $instantiation_code . "\$args[$index]"; } } $instantiation_code = $instantiation_code . ");"; eval($instantiation_code); foreach ($row as $col => $value) { $object->$col = $value; } return $object; } public function getColumnMeta($column) { if (is_integer($column)) { $internal_column = $column +1; } else { $internal_column = $column; } $data = array(); $data['native_type'] = oci_field_type($this->statement, $internal_column); $data['flags'] = ""; $data['len'] = oci_field_size($this->statement, $internal_column); $data['name'] = oci_field_name($this->statement, $internal_column); $data['precision'] = oci_field_precision($this->statement, $internal_column); return $data; } public function nextRowset() { throw new Doctrine_Adapter_Exception("Unsupported"); } public function rowCount() { return @oci_num_rows($this->statement); } public function setAttribute($attribute, $value) { switch ($attribute) { case Doctrine_Core::ATTR_ERRMODE; break; default: throw new Doctrine_Adapter_Exception("Unsupported Attribute: $attribute"); } $this->attributes[$attribute] = $value; } public function getAttribute($attribute) { return $this->attributes[$attribute]; } public function setFetchMode($mode, $arg1 = null, $arg2 = null) { throw new Doctrine_Adapter_Exception("Unsupported"); } private function handleError($params=array()) { switch ($this->attributes[Doctrine_Core::ATTR_ERRMODE]) { case Doctrine_Core::ERRMODE_EXCEPTION: if (isset($params['message'])) { throw new Doctrine_Adapter_Exception($params['message']); } else { throw new Doctrine_Adapter_Exception($this->errorInfo()); } break; case Doctrine_Core::ERRMODE_WARNING: case Doctrine_Core::ERRMODE_SILENT: break; } } private function parseQuery($query=null) { if (is_null($query)) { $query = $this->queryString; } $bind_index = 1; $query = preg_replace("/(\?)/e", '":oci_b_var_". $bind_index++' , $query); $this->statement = @oci_parse($this->connection, $query); if ( $this->statement == false ) { throw new Doctrine_Adapter_Exception($this->getOciError()); } return $this->statement; } }class Doctrine_Adapter_Statement_Mock implements Doctrine_Adapter_Statement_Interface { private $_mock; public $queryString; public function __construct($mock) { $this->_mock = $mock; } public function bindColumn($column, $param, $type = null) { } public function bindValue($param, $value, $type = null) { } public function bindParam($column, &$variable, $type = null, $length = null, $driverOptions = array()) { } public function closeCursor() { return true; } public function columnCount() { return 0; } public function errorCode() { return array(); } public function errorInfo() { return array(); } public function fetch($fetchStyle = Doctrine_Core::FETCH_BOTH, $cursorOrientation = Doctrine_Core::FETCH_ORI_NEXT, $cursorOffset = null) { return array(); } public function fetchAll($fetchMode = Doctrine_Core::FETCH_BOTH) { return array(); } public function execute($params = null) { if (is_object($this->_mock)) { $this->_mock->addQuery($this->queryString); } return true; } public function fetchColumn($columnIndex = 0) { return 0; } public function fetchObject($className = 'stdClass', $args = array()) { return new $className(); } public function nextRowset() { return true; } public function rowCount() { return 0; } public function getColumnMeta($column) { } public function getAttribute($attribute) { } public function setAttribute($attribute, $value) { } public function setFetchMode($mode, $arg1 = null, $arg2 = null) { } }abstract class Doctrine_Adapter_Statement { public function bindValue($no, $value) { } public function fetch() { } public function nextRowset() { } public function execute() { } public function errorCode() { } public function errorInfo() { } public function rowCount() { } public function setFetchMode($mode) { } public function columnCount() { } }class Doctrine_Adapter_Mock implements Doctrine_Adapter_Interface, Countable { private $_name; private $_queries = array(); private $_exception = array(); private $_lastInsertIdFail = false; public function __construct($name = null) { $this->_name = $name; } public function getName() { return $this->_name; } public function pop() { return array_pop($this->_queries); } public function forceException($name, $message = '', $code = 0) { $this->_exception = array($name, $message, $code); } public function prepare($query) { $mock = new Doctrine_Adapter_Statement_Mock($this, $query); $mock->queryString = $query; return $mock; } public function addQuery($query) { $this->_queries[] = $query; } public function query($query) { $this->_queries[] = $query; $e = $this->_exception; if ( ! empty($e)) { $name = $e[0]; $this->_exception = array(); throw new $name($e[1], $e[2]); } $stmt = new Doctrine_Adapter_Statement_Mock($this, $query); $stmt->queryString = $query; return $stmt; } public function getAll() { return $this->_queries; } public function quote($input) { return "'" . addslashes($input) . "'"; } public function exec($statement) { $this->_queries[] = $statement; $e = $this->_exception; if ( ! empty($e)) { $name = $e[0]; $this->_exception = array(); throw new $name($e[1], $e[2]); } return 0; } public function forceLastInsertIdFail($fail = true) { if ($fail) { $this->_lastInsertIdFail = true; } else { $this->_lastInsertIdFail = false; } } public function lastInsertId() { $this->_queries[] = 'LAST_INSERT_ID()'; if ($this->_lastInsertIdFail) { return null; } else { return 1; } } public function count() { return count($this->_queries); } public function beginTransaction() { $this->_queries[] = 'BEGIN TRANSACTION'; } public function commit() { $this->_queries[] = 'COMMIT'; } public function rollBack() { $this->_queries[] = 'ROLLBACK'; } public function getAttribute($attribute) { if ($attribute == Doctrine_Core::ATTR_DRIVER_NAME) { return strtolower($this->_name); } } public function errorCode() { } public function errorInfo() { } public function setAttribute($attribute, $value) { } public function sqliteCreateFunction() { } }class Doctrine_Adapter_Exception extends Doctrine_Exception { }class Doctrine_Inflector { public static function tableize($word) { return strtolower(preg_replace('~(?<=\\w)([A-Z])~', '_$1', $word)); } public static function classify($word) { static $cache = array(); if (!isset($cache[$word])) { $word = preg_replace('/[$]/', '', $word); $classify = preg_replace_callback('~(_?)([-_])([\w])~', array("Doctrine_Inflector", "classifyCallback"), ucfirst(strtolower($word))); $cache[$word] = $classify; } return $cache[$word]; } public static function classifyCallback($matches) { return $matches[1] . strtoupper($matches[3]); } public static function seemsUtf8($string) { for ($i = 0; $i < strlen($string); $i++) { if (ord($string[$i]) < 0x80) continue; elseif ((ord($string[$i]) & 0xE0) == 0xC0) $n=1; elseif ((ord($string[$i]) & 0xF0) == 0xE0) $n=2; elseif ((ord($string[$i]) & 0xF8) == 0xF0) $n=3; elseif ((ord($string[$i]) & 0xFC) == 0xF8) $n=4; elseif ((ord($string[$i]) & 0xFE) == 0xFC) $n=5; else return false; for ($j=0; $j<$n; $j++) { if ((++$i == strlen($string)) || ((ord($string[$i]) & 0xC0) != 0x80)) return false; } } return true; } public static function unaccent($string) { if ( ! preg_match('/[\x80-\xff]/', $string) ) { return $string; } if (self::seemsUtf8($string)) { $chars = array( chr(195).chr(128) => 'A', chr(195).chr(129) => 'A', chr(195).chr(130) => 'A', chr(195).chr(131) => 'A', chr(195).chr(132) => 'A', chr(195).chr(133) => 'A', chr(195).chr(135) => 'C', chr(195).chr(136) => 'E', chr(195).chr(137) => 'E', chr(195).chr(138) => 'E', chr(195).chr(139) => 'E', chr(195).chr(140) => 'I', chr(195).chr(141) => 'I', chr(195).chr(142) => 'I', chr(195).chr(143) => 'I', chr(195).chr(145) => 'N', chr(195).chr(146) => 'O', chr(195).chr(147) => 'O', chr(195).chr(148) => 'O', chr(195).chr(149) => 'O', chr(195).chr(150) => 'O', chr(195).chr(153) => 'U', chr(195).chr(154) => 'U', chr(195).chr(155) => 'U', chr(195).chr(156) => 'U', chr(195).chr(157) => 'Y', chr(195).chr(159) => 's', chr(195).chr(160) => 'a', chr(195).chr(161) => 'a', chr(195).chr(162) => 'a', chr(195).chr(163) => 'a', chr(195).chr(164) => 'a', chr(195).chr(165) => 'a', chr(195).chr(167) => 'c', chr(195).chr(168) => 'e', chr(195).chr(169) => 'e', chr(195).chr(170) => 'e', chr(195).chr(171) => 'e', chr(195).chr(172) => 'i', chr(195).chr(173) => 'i', chr(195).chr(174) => 'i', chr(195).chr(175) => 'i', chr(195).chr(177) => 'n', chr(195).chr(178) => 'o', chr(195).chr(179) => 'o', chr(195).chr(180) => 'o', chr(195).chr(181) => 'o', chr(195).chr(182) => 'o', chr(195).chr(182) => 'o', chr(195).chr(185) => 'u', chr(195).chr(186) => 'u', chr(195).chr(187) => 'u', chr(195).chr(188) => 'u', chr(195).chr(189) => 'y', chr(195).chr(191) => 'y', chr(196).chr(128) => 'A', chr(196).chr(129) => 'a', chr(196).chr(130) => 'A', chr(196).chr(131) => 'a', chr(196).chr(132) => 'A', chr(196).chr(133) => 'a', chr(196).chr(134) => 'C', chr(196).chr(135) => 'c', chr(196).chr(136) => 'C', chr(196).chr(137) => 'c', chr(196).chr(138) => 'C', chr(196).chr(139) => 'c', chr(196).chr(140) => 'C', chr(196).chr(141) => 'c', chr(196).chr(142) => 'D', chr(196).chr(143) => 'd', chr(196).chr(144) => 'D', chr(196).chr(145) => 'd', chr(196).chr(146) => 'E', chr(196).chr(147) => 'e', chr(196).chr(148) => 'E', chr(196).chr(149) => 'e', chr(196).chr(150) => 'E', chr(196).chr(151) => 'e', chr(196).chr(152) => 'E', chr(196).chr(153) => 'e', chr(196).chr(154) => 'E', chr(196).chr(155) => 'e', chr(196).chr(156) => 'G', chr(196).chr(157) => 'g', chr(196).chr(158) => 'G', chr(196).chr(159) => 'g', chr(196).chr(160) => 'G', chr(196).chr(161) => 'g', chr(196).chr(162) => 'G', chr(196).chr(163) => 'g', chr(196).chr(164) => 'H', chr(196).chr(165) => 'h', chr(196).chr(166) => 'H', chr(196).chr(167) => 'h', chr(196).chr(168) => 'I', chr(196).chr(169) => 'i', chr(196).chr(170) => 'I', chr(196).chr(171) => 'i', chr(196).chr(172) => 'I', chr(196).chr(173) => 'i', chr(196).chr(174) => 'I', chr(196).chr(175) => 'i', chr(196).chr(176) => 'I', chr(196).chr(177) => 'i', chr(196).chr(178) => 'IJ',chr(196).chr(179) => 'ij', chr(196).chr(180) => 'J', chr(196).chr(181) => 'j', chr(196).chr(182) => 'K', chr(196).chr(183) => 'k', chr(196).chr(184) => 'k', chr(196).chr(185) => 'L', chr(196).chr(186) => 'l', chr(196).chr(187) => 'L', chr(196).chr(188) => 'l', chr(196).chr(189) => 'L', chr(196).chr(190) => 'l', chr(196).chr(191) => 'L', chr(197).chr(128) => 'l', chr(197).chr(129) => 'L', chr(197).chr(130) => 'l', chr(197).chr(131) => 'N', chr(197).chr(132) => 'n', chr(197).chr(133) => 'N', chr(197).chr(134) => 'n', chr(197).chr(135) => 'N', chr(197).chr(136) => 'n', chr(197).chr(137) => 'N', chr(197).chr(138) => 'n', chr(197).chr(139) => 'N', chr(197).chr(140) => 'O', chr(197).chr(141) => 'o', chr(197).chr(142) => 'O', chr(197).chr(143) => 'o', chr(197).chr(144) => 'O', chr(197).chr(145) => 'o', chr(197).chr(146) => 'OE',chr(197).chr(147) => 'oe', chr(197).chr(148) => 'R', chr(197).chr(149) => 'r', chr(197).chr(150) => 'R', chr(197).chr(151) => 'r', chr(197).chr(152) => 'R', chr(197).chr(153) => 'r', chr(197).chr(154) => 'S', chr(197).chr(155) => 's', chr(197).chr(156) => 'S', chr(197).chr(157) => 's', chr(197).chr(158) => 'S', chr(197).chr(159) => 's', chr(197).chr(160) => 'S', chr(197).chr(161) => 's', chr(197).chr(162) => 'T', chr(197).chr(163) => 't', chr(197).chr(164) => 'T', chr(197).chr(165) => 't', chr(197).chr(166) => 'T', chr(197).chr(167) => 't', chr(197).chr(168) => 'U', chr(197).chr(169) => 'u', chr(197).chr(170) => 'U', chr(197).chr(171) => 'u', chr(197).chr(172) => 'U', chr(197).chr(173) => 'u', chr(197).chr(174) => 'U', chr(197).chr(175) => 'u', chr(197).chr(176) => 'U', chr(197).chr(177) => 'u', chr(197).chr(178) => 'U', chr(197).chr(179) => 'u', chr(197).chr(180) => 'W', chr(197).chr(181) => 'w', chr(197).chr(182) => 'Y', chr(197).chr(183) => 'y', chr(197).chr(184) => 'Y', chr(197).chr(185) => 'Z', chr(197).chr(186) => 'z', chr(197).chr(187) => 'Z', chr(197).chr(188) => 'z', chr(197).chr(189) => 'Z', chr(197).chr(190) => 'z', chr(197).chr(191) => 's', chr(226).chr(130).chr(172) => 'E', chr(194).chr(163) => '', 'Ä' => 'Ae', 'ä' => 'ae', 'Ü' => 'Ue', 'ü' => 'ue', 'Ö' => 'Oe', 'ö' => 'oe', 'ß' => 'ss', 'Å'=>'Aa','Æ'=>'Ae','Ø'=>'O','æ'=>'a','ø'=>'o','å'=>'aa' ); $string = strtr($string, $chars); } else { $chars['in'] = chr(128).chr(131).chr(138).chr(142).chr(154).chr(158) .chr(159).chr(162).chr(165).chr(181).chr(192).chr(193).chr(194) .chr(195).chr(196).chr(197).chr(199).chr(200).chr(201).chr(202) .chr(203).chr(204).chr(205).chr(206).chr(207).chr(209).chr(210) .chr(211).chr(212).chr(213).chr(214).chr(216).chr(217).chr(218) .chr(219).chr(220).chr(221).chr(224).chr(225).chr(226).chr(227) .chr(228).chr(229).chr(231).chr(232).chr(233).chr(234).chr(235) .chr(236).chr(237).chr(238).chr(239).chr(241).chr(242).chr(243) .chr(244).chr(245).chr(246).chr(248).chr(249).chr(250).chr(251) .chr(252).chr(253).chr(255); $chars['out'] = "EfSZszYcYuAAAAAACEEEEIIIINOOOOOOUUUUYaaaaaaceeeeiiiinoooooouuuuyy"; $string = strtr($string, $chars['in'], $chars['out']); $doubleChars['in'] = array(chr(140), chr(156), chr(198), chr(208), chr(222), chr(223), chr(230), chr(240), chr(254)); $doubleChars['out'] = array('OE', 'oe', 'AE', 'DH', 'TH', 'ss', 'ae', 'dh', 'th'); $string = str_replace($doubleChars['in'], $doubleChars['out'], $string); } return $string; } public static function urlize($text) { $text = self::unaccent($text); if (function_exists('mb_strtolower')) { $text = mb_strtolower($text); } else { $text = strtolower($text); } $text = preg_replace('/\W/', ' ', $text); $text = strtolower(preg_replace('/[^A-Z^a-z^0-9^\/]+/', '-', preg_replace('/([a-z\d])([A-Z])/', '\1_\2', preg_replace('/([A-Z]+)([A-Z][a-z])/', '\1_\2', preg_replace('/::/', '/', $text))))); return trim($text, '-'); } }class Doctrine_Manager extends Doctrine_Configurable implements Countable, IteratorAggregate { protected $_connections = array(); protected $_bound = array(); protected $_index = 0; protected $_currIndex = 0; protected $_queryRegistry; protected $_validators = array(); protected $_hydrators = array( Doctrine_Core::HYDRATE_ARRAY => 'Doctrine_Hydrator_ArrayDriver', Doctrine_Core::HYDRATE_RECORD => 'Doctrine_Hydrator_RecordDriver', Doctrine_Core::HYDRATE_NONE => 'Doctrine_Hydrator_NoneDriver', Doctrine_Core::HYDRATE_SCALAR => 'Doctrine_Hydrator_ScalarDriver', Doctrine_Core::HYDRATE_SINGLE_SCALAR => 'Doctrine_Hydrator_SingleScalarDriver', Doctrine_Core::HYDRATE_ON_DEMAND => 'Doctrine_Hydrator_RecordDriver', Doctrine_Core::HYDRATE_ARRAY_HIERARCHY => 'Doctrine_Hydrator_ArrayHierarchyDriver', Doctrine_Core::HYDRATE_RECORD_HIERARCHY => 'Doctrine_Hydrator_RecordHierarchyDriver', ); protected $_connectionDrivers = array( 'db2' => 'Doctrine_Connection_Db2', 'mysql' => 'Doctrine_Connection_Mysql', 'mysqli' => 'Doctrine_Connection_Mysql', 'sqlite' => 'Doctrine_Connection_Sqlite', 'pgsql' => 'Doctrine_Connection_Pgsql', 'oci' => 'Doctrine_Connection_Oracle', 'oci8' => 'Doctrine_Connection_Oracle', 'oracle' => 'Doctrine_Connection_Oracle', 'icingaOracle' => 'Doctrine_Connection_IcingaOracle', 'mssql' => 'Doctrine_Connection_Mssql', 'dblib' => 'Doctrine_Connection_Mssql', 'odbc' => 'Doctrine_Connection_Mssql', 'mock' => 'Doctrine_Connection_Mock' ); protected $_extensions = array(); protected $_loadedValidatorsFromDisk = false; protected static $_instance; private $_initialized = false; private function __construct() { $null = new Doctrine_Null; Doctrine_Locator_Injectable::initNullObject($null); Doctrine_Record_Iterator::initNullObject($null); } public function setDefaultAttributes() { if ( ! $this->_initialized) { $this->_initialized = true; $attributes = array( Doctrine_Core::ATTR_CACHE => null, Doctrine_Core::ATTR_RESULT_CACHE => null, Doctrine_Core::ATTR_QUERY_CACHE => null, Doctrine_Core::ATTR_LOAD_REFERENCES => true, Doctrine_Core::ATTR_LISTENER => new Doctrine_EventListener(), Doctrine_Core::ATTR_RECORD_LISTENER => new Doctrine_Record_Listener(), Doctrine_Core::ATTR_THROW_EXCEPTIONS => true, Doctrine_Core::ATTR_VALIDATE => Doctrine_Core::VALIDATE_NONE, Doctrine_Core::ATTR_QUERY_LIMIT => Doctrine_Core::LIMIT_RECORDS, Doctrine_Core::ATTR_IDXNAME_FORMAT => "%s_idx", Doctrine_Core::ATTR_SEQNAME_FORMAT => "%s_seq", Doctrine_Core::ATTR_TBLNAME_FORMAT => "%s", Doctrine_Core::ATTR_FKNAME_FORMAT => "%s", Doctrine_Core::ATTR_QUOTE_IDENTIFIER => false, Doctrine_Core::ATTR_SEQCOL_NAME => 'id', Doctrine_Core::ATTR_PORTABILITY => Doctrine_Core::PORTABILITY_NONE, Doctrine_Core::ATTR_EXPORT => Doctrine_Core::EXPORT_ALL, Doctrine_Core::ATTR_DECIMAL_PLACES => 2, Doctrine_Core::ATTR_DEFAULT_PARAM_NAMESPACE => 'doctrine', Doctrine_Core::ATTR_AUTOLOAD_TABLE_CLASSES => false, Doctrine_Core::ATTR_USE_DQL_CALLBACKS => false, Doctrine_Core::ATTR_AUTO_ACCESSOR_OVERRIDE => false, Doctrine_Core::ATTR_AUTO_FREE_QUERY_OBJECTS => false, Doctrine_Core::ATTR_DEFAULT_IDENTIFIER_OPTIONS => array(), Doctrine_Core::ATTR_DEFAULT_COLUMN_OPTIONS => array(), Doctrine_Core::ATTR_HYDRATE_OVERWRITE => true, Doctrine_Core::ATTR_QUERY_CLASS => 'Doctrine_Query', Doctrine_Core::ATTR_COLLECTION_CLASS => 'Doctrine_Collection', Doctrine_Core::ATTR_TABLE_CLASS => 'Doctrine_Table', Doctrine_Core::ATTR_CASCADE_SAVES => true, Doctrine_Core::ATTR_TABLE_CLASS_FORMAT => '%sTable' ); foreach ($attributes as $attribute => $value) { $old = $this->getAttribute($attribute); if ($old === null) { $this->setAttribute($attribute,$value); } } return true; } return false; } public static function getInstance() { if ( ! isset(self::$_instance)) { self::$_instance = new self(); } return self::$_instance; } public static function resetInstance() { if (self::$_instance) { self::$_instance->reset(); self::$_instance = null; } } public function reset() { foreach ($this->_connections as $conn) { $conn->close(); } $this->_connections = array(); $this->_queryRegistry = null; $this->_extensions = array(); $this->_bound = array(); $this->_validators = array(); $this->_loadedValidatorsFromDisk = false; $this->_index = 0; $this->_currIndex = 0; $this->_initialized = false; } public function getQueryRegistry() { if ( ! isset($this->_queryRegistry)) { $this->_queryRegistry = new Doctrine_Query_Registry(); } return $this->_queryRegistry; } public function setQueryRegistry(Doctrine_Query_Registry $registry) { $this->_queryRegistry = $registry; return $this; } public static function connection($adapter = null, $name = null) { if ($adapter == null) { return Doctrine_Manager::getInstance()->getCurrentConnection(); } else { return Doctrine_Manager::getInstance()->openConnection($adapter, $name); } } public function openConnection($adapter, $name = null, $setCurrent = true) { if (is_object($adapter)) { if ( ! ($adapter instanceof PDO) && ! in_array('Doctrine_Adapter_Interface', class_implements($adapter))) { throw new Doctrine_Manager_Exception("First argument should be an instance of PDO or implement Doctrine_Adapter_Interface"); } $driverName = $adapter->getAttribute(Doctrine_Core::ATTR_DRIVER_NAME); } else if (is_array($adapter)) { if ( ! isset($adapter[0])) { throw new Doctrine_Manager_Exception('Empty data source name given.'); } $e = explode(':', $adapter[0]); if ($e[0] == 'uri') { $e[0] = 'odbc'; } $parts['dsn'] = $adapter[0]; $parts['scheme'] = $e[0]; $parts['user'] = (isset($adapter[1])) ? $adapter[1] : null; $parts['pass'] = (isset($adapter[2])) ? $adapter[2] : null; $driverName = $e[0]; $adapter = $parts; } else { $parts = $this->parseDsn($adapter); $driverName = $parts['scheme']; $adapter = $parts; } if (is_array($adapter)) { foreach ($adapter as $key => $value) { $adapter[$key] = $value ? urldecode($value):null; } } $this->setDefaultAttributes(); if ($name !== null) { $name = (string) $name; if (isset($this->_connections[$name])) { if ($setCurrent) { $this->_currIndex = $name; } return $this->_connections[$name]; } } else { $name = $this->_index; $this->_index++; } if ( ! isset($this->_connectionDrivers[$driverName])) { throw new Doctrine_Manager_Exception('Unknown driver ' . $driverName); } $className = $this->_connectionDrivers[$driverName]; $conn = new $className($this, $adapter); $conn->setName($name); $this->_connections[$name] = $conn; if ($setCurrent) { $this->_currIndex = $name; } return $this->_connections[$name]; } public function parsePdoDsn($dsn) { $parts = array(); $names = array('dsn', 'scheme', 'host', 'port', 'user', 'pass', 'path', 'query', 'fragment', 'unix_socket'); foreach ($names as $name) { if ( ! isset($parts[$name])) { $parts[$name] = null; } } $e = explode(':', $dsn); $parts['scheme'] = $e[0]; $parts['dsn'] = $dsn; $e = explode(';', $e[1]); foreach ($e as $string) { if ($string) { $e2 = explode('=', $string); if (isset($e2[0]) && isset($e2[1])) { if (count($e2) > 2) { $key = $e2[0]; unset($e2[0]); $value = implode('=', $e2); } else { list($key, $value) = $e2; } $parts[$key] = $value; } } } return $parts; } protected function _buildDsnPartsArray($dsn) { $dsn = str_replace("////", "/", $dsn); $dsn = str_replace("\\", "/", $dsn); $dsn = preg_replace("/\/\/\/(.*):\//", "//$1:/", $dsn); $parts = @parse_url($dsn); $names = array('dsn', 'scheme', 'host', 'port', 'user', 'pass', 'path', 'query', 'fragment'); foreach ($names as $name) { if ( ! isset($parts[$name])) { $parts[$name] = null; } } if (count($parts) == 0 || ! isset($parts['scheme'])) { throw new Doctrine_Manager_Exception('Could not parse dsn'); } return $parts; } public function parseDsn($dsn) { $parts = $this->_buildDsnPartsArray($dsn); switch ($parts['scheme']) { case 'sqlite': case 'sqlite2': case 'sqlite3': if (isset($parts['host']) && $parts['host'] == ':memory') { $parts['database'] = ':memory:'; $parts['dsn'] = 'sqlite::memory:'; } else { if (isset($parts['host'])) { $parts['path'] = $parts['host'] . ":" . $parts["path"]; $parts['host'] = null; } $parts['database'] = $parts['path']; $parts['dsn'] = $parts['scheme'] . ':' . $parts['path']; } break; case 'mssql': case 'dblib': if ( ! isset($parts['path']) || $parts['path'] == '/') { throw new Doctrine_Manager_Exception('No database available in data source name'); } if (isset($parts['path'])) { $parts['database'] = substr($parts['path'], 1); } if ( ! isset($parts['host'])) { throw new Doctrine_Manager_Exception('No hostname set in data source name'); } $parts['dsn'] = $parts['scheme'] . ':host=' . $parts['host'] . (isset($parts['port']) ? ':' . $parts['port']:null) . ';dbname=' . $parts['database']; break; case 'mysql': case 'oci8': case 'oci': case 'pgsql': case 'odbc': case 'mock': case 'oracle': case 'icingaOracle': if ( ! isset($parts['path']) || $parts['path'] == '/') { throw new Doctrine_Manager_Exception('No database available in data source name'); } if (isset($parts['path'])) { $parts['database'] = substr($parts['path'], 1); } if ( ! isset($parts['host'])) { throw new Doctrine_Manager_Exception('No hostname set in data source name'); } $parts['dsn'] = $parts['scheme'] . ':host=' . $parts['host'] . (isset($parts['port']) ? ';port=' . $parts['port']:null) . ';dbname=' . $parts['database']; break; default: $parts['dsn'] = $dsn; } return $parts; } public function getConnection($name) { if ( ! isset($this->_connections[$name])) { throw new Doctrine_Manager_Exception('Unknown connection: ' . $name); } return $this->_connections[$name]; } public function getConnectionName(Doctrine_Connection $conn) { return array_search($conn, $this->_connections, true); } public function bindComponent($componentName, $connectionName) { $this->_bound[$componentName] = $connectionName; } public function getConnectionForComponent($componentName) { Doctrine_Core::modelsAutoload($componentName); if (isset($this->_bound[$componentName])) { return $this->getConnection($this->_bound[$componentName]); } return $this->getCurrentConnection(); } public function hasConnectionForComponent($componentName = null) { return isset($this->_bound[$componentName]); } public function closeConnection(Doctrine_Connection $connection) { $connection->close(); $key = array_search($connection, $this->_connections, true); if ($key !== false) { unset($this->_connections[$key]); if ($key === $this->_currIndex) { $key = key($this->_connections); $this->_currIndex = ($key !== null) ? $key : 0; } } unset($connection); } public function getConnections() { return $this->_connections; } public function setCurrentConnection($key) { $key = (string) $key; if ( ! isset($this->_connections[$key])) { throw new Doctrine_Manager_Exception("Connection key '$key' does not exist."); } $this->_currIndex = $key; } public function contains($key) { return isset($this->_connections[$key]); } public function count() { return count($this->_connections); } public function getIterator() { return new ArrayIterator($this->_connections); } public function getCurrentConnection() { $i = $this->_currIndex; if ( ! isset($this->_connections[$i])) { throw new Doctrine_Connection_Exception('There is no open connection'); } return $this->_connections[$i]; } public function createDatabases($specifiedConnections = array()) { if ( ! is_array($specifiedConnections)) { $specifiedConnections = (array) $specifiedConnections; } foreach ($this as $name => $connection) { if ( ! empty($specifiedConnections) && ! in_array($name, $specifiedConnections)) { continue; } $connection->createDatabase(); } } public function dropDatabases($specifiedConnections = array()) { if ( ! is_array($specifiedConnections)) { $specifiedConnections = (array) $specifiedConnections; } foreach ($this as $name => $connection) { if ( ! empty($specifiedConnections) && ! in_array($name, $specifiedConnections)) { continue; } $connection->dropDatabase(); } } public function __toString() { $r[] = "<pre>"; $r[] = "Doctrine_Manager"; $r[] = "Connections : ".count($this->_connections); $r[] = "</pre>"; return implode("\n",$r); } public function getValidators() { if ( ! $this->_loadedValidatorsFromDisk) { $this->_loadedValidatorsFromDisk = true; $validators = array(); $dir = Doctrine_Core::getPath() . DIRECTORY_SEPARATOR . 'Doctrine' . DIRECTORY_SEPARATOR . 'Validator'; $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir), RecursiveIteratorIterator::LEAVES_ONLY); foreach ($files as $file) { $e = explode('.', $file->getFileName()); if (end($e) == 'php') { $name = strtolower($e[0]); $validators[] = $name; } } $this->registerValidators($validators); } return $this->_validators; } public function registerValidators($validators) { $validators = (array) $validators; foreach ($validators as $validator) { if ( ! in_array($validator, $this->_validators)) { $this->_validators[] = $validator; } } } public function registerHydrator($name, $class) { $this->_hydrators[$name] = $class; } public function getHydrators() { return $this->_hydrators; } public function registerConnectionDriver($name, $class) { $this->_connectionDrivers[$name] = $class; } public function getConnectionDrivers() { return $this->_connectionsDrivers; } public function registerExtension($name, $path = null) { if (is_null($path)) { $path = Doctrine_Core::getExtensionsPath() . '/' . $name . '/lib'; } $this->_extensions[$name] = $path; } public function getExtensions() { return $this->_extensions; } } class Doctrine_Record_Iterator extends ArrayIterator { private $record; private static $null; public function __construct(Doctrine_Record $record) { $this->record = $record; parent::__construct($record->getData()); } public static function initNullObject(Doctrine_Null $null) { self::$null = $null; } public function current() { $value = parent::current(); if ($value === self::$null) { return null; } else { return $value; } } } class Doctrine_Record_Listener_Chain extends Doctrine_Access implements Doctrine_Record_Listener_Interface { protected $_listeners = array(); protected $_options = array('disabled' => false); public function setOption($name, $value = null) { if (is_array($name)) { $this->_options = Doctrine_Lib::arrayDeepMerge($this->_options, $name); } else { $this->_options[$name] = $value; } } public function getOption($name) { if (isset($this->_options[$name])) { return $this->_options[$name]; } return null; } public function getOptions() { return $this->_options; } public function add($listener, $name = null) { if ( ! ($listener instanceof Doctrine_Record_Listener_Interface) && ! ($listener instanceof Doctrine_Overloadable)) { throw new Doctrine_EventListener_Exception("Couldn't add eventlistener. Record listeners should implement either Doctrine_Record_Listener_Interface or Doctrine_Overloadable"); } if ($name === null) { $this->_listeners[] = $listener; } else { $this->_listeners[$name] = $listener; } } public function get($key) { if ( ! isset($this->_listeners[$key])) { return null; } return $this->_listeners[$key]; } public function set($key, $listener) { $this->_listeners[$key] = $listener; } public function preSerialize(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preSerialize', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preSerialize', $disabled))) { $listener->preSerialize($event); } } } } public function postSerialize(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postSerialize', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postSerialize', $disabled))) { $listener->postSerialize($event); } } } } public function preUnserialize(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preUnserialize', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preUnserialize', $disabled))) { $listener->preUnserialize($event); } } } } public function postUnserialize(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postUnserialize', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postUnserialize', $disabled))) { $listener->postUnserialize($event); } } } } public function preDqlSelect(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preDqlSelect', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preDqlSelect', $disabled))) { $listener->preDqlSelect($event); } } } } public function preSave(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preSave', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preSave', $disabled))) { $listener->preSave($event); } } } } public function postSave(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postSave', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postSave', $disabled))) { $listener->postSave($event); } } } } public function preDqlDelete(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preDqlDelete', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preDqlDelete', $disabled))) { $listener->preDqlDelete($event); } } } } public function preDelete(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preDelete', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preDelete', $disabled))) { $listener->preDelete($event); } } } } public function postDelete(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postDelete', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postDelete', $disabled))) { $listener->postDelete($event); } } } } public function preDqlUpdate(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preDqlUpdate', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preDqlUpdate', $disabled))) { $listener->preDqlUpdate($event); } } } } public function preUpdate(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preUpdate', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preUpdate', $disabled))) { $listener->preUpdate($event); } } } } public function postUpdate(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postUpdate', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postUpdate', $disabled))) { $listener->postUpdate($event); } } } } public function preInsert(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preInsert', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preInsert', $disabled))) { $listener->preInsert($event); } } } } public function postInsert(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postInsert', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postInsert', $disabled))) { $listener->postInsert($event); } } } } public function preHydrate(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preHydrate', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preHydrate', $disabled))) { $listener->preHydrate($event); } } } } public function postHydrate(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postHydrate', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postHydrate', $disabled))) { $listener->postHydrate($event); } } } } public function preValidate(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preValidate', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('preValidate', $disabled))) { $listener->preValidate($event); } } } } public function postValidate(Doctrine_Event $event) { $disabled = $this->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postValidate', $disabled))) { foreach ($this->_listeners as $listener) { $disabled = $listener->getOption('disabled'); if ($disabled !== true && ! (is_array($disabled) && in_array('postValidate', $disabled))) { $listener->postValidate($event); } } } } }abstract class Doctrine_Record_Filter { protected $_table; public function setTable(Doctrine_Table $table) { $this->_table = $table; } public function getTable() { return $this->_table; } public function init() { } abstract public function filterSet(Doctrine_Record $record, $name, $value); abstract public function filterGet(Doctrine_Record $record, $name); }class Doctrine_Record_Filter_Standard extends Doctrine_Record_Filter { public function filterSet(Doctrine_Record $record, $name, $value) { throw new Doctrine_Record_UnknownPropertyException(sprintf('Unknown record property / related component "%s" on "%s"', $name, get_class($record))); } public function filterGet(Doctrine_Record $record, $name) { throw new Doctrine_Record_UnknownPropertyException(sprintf('Unknown record property / related component "%s" on "%s"', $name, get_class($record))); } }class Doctrine_Record_Filter_Compound extends Doctrine_Record_Filter { protected $_aliases = array(); public function __construct(array $aliases) { $this->_aliases = $aliases; } public function init() { foreach ($this->_aliases as $alias) { $this->_table->getRelation($alias); } } public function filterSet(Doctrine_Record $record, $name, $value) { foreach ($this->_aliases as $alias) { if ( ! $record->exists()) { if (isset($record[$alias][$name])) { $record[$alias][$name] = $value; return $record; } } else { if (isset($record[$alias][$name])) { $record[$alias][$name] = $value; } return $record; } } throw new Doctrine_Record_UnknownPropertyException(sprintf('Unknown record property / related component "%s" on "%s"', $name, get_class($record))); } public function filterGet(Doctrine_Record $record, $name) { foreach ($this->_aliases as $alias) { if ( ! $record->exists()) { if (isset($record[$alias][$name])) { return $record[$alias][$name]; } } else { if (isset($record[$alias][$name])) { return $record[$alias][$name]; } } } throw new Doctrine_Record_UnknownPropertyException(sprintf('Unknown record property / related component "%s" on "%s"', $name, get_class($record))); } }class Doctrine_Record_Exception extends Doctrine_Exception { }class Doctrine_Record_UnknownPropertyException extends Doctrine_Record_Exception { }class Doctrine_Record_State_Exception extends Doctrine_Record_Exception { }class Doctrine_I18n_Exception extends Doctrine_Exception { }class Doctrine_Expression_Driver extends Doctrine_Connection_Module { public function getIdentifier($column) { return $column; } public function getIdentifiers($columns) { return $columns; } public function regexp() { throw new Doctrine_Expression_Exception('Regular expression operator is not supported by this database driver.'); } public function avg($column) { $column = $this->getIdentifier($column); return 'AVG(' . $column . ')'; } public function count($column) { $column = $this->getIdentifier($column); return 'COUNT(' . $column . ')'; } public function max($column) { $column = $this->getIdentifier($column); return 'MAX(' . $column . ')'; } public function min($column) { $column = $this->getIdentifier($column); return 'MIN(' . $column . ')'; } public function sum($column) { $column = $this->getIdentifier($column); return 'SUM(' . $column . ')'; } public function md5($column) { $column = $this->getIdentifier($column); return 'MD5(' . $column . ')'; } public function length($column) { $column = $this->getIdentifier($column); return 'LENGTH(' . $column . ')'; } public function round($column, $decimals = 0) { $column = $this->getIdentifier($column); return 'ROUND(' . $column . ', ' . $decimals . ')'; } public function mod($expression1, $expression2) { $expression1 = $this->getIdentifier($expression1); $expression2 = $this->getIdentifier($expression2); return 'MOD(' . $expression1 . ', ' . $expression2 . ')'; } public function trim($str) { return 'TRIM(' . $str . ')'; } public function rtrim($str) { return 'RTRIM(' . $str . ')'; } public function ltrim($str) { return 'LTRIM(' . $str . ')'; } public function upper($str) { return 'UPPER(' . $str . ')'; } public function lower($str) { return 'LOWER(' . $str . ')'; } public function locate($str, $substr) { return 'LOCATE(' . $str . ', ' . $substr . ')'; } public function now() { return 'NOW()'; } public function soundex($value) { throw new Doctrine_Expression_Exception('SQL soundex function not supported by this driver.'); } public function substring($value, $from, $len = null) { $value = $this->getIdentifier($value); if ($len === null) return 'SUBSTRING(' . $value . ' FROM ' . $from . ')'; else { $len = $this->getIdentifier($len); return 'SUBSTRING(' . $value . ' FROM ' . $from . ' FOR ' . $len . ')'; } } public function concat() { $args = func_get_args(); return 'CONCAT(' . join(', ', (array) $args) . ')'; } public function not($expression) { $expression = $this->getIdentifier($expression); return 'NOT(' . $expression . ')'; } private function basicMath($type, array $args) { $elements = $this->getIdentifiers($args); if (count($elements) < 1) { return ''; } if (count($elements) == 1) { return $elements[0]; } else { return '(' . implode(' ' . $type . ' ', $elements) . ')'; } } public function add(array $args) { return $this->basicMath('+', $args); } public function sub(array $args) { return $this->basicMath('-', $args ); } public function mul(array $args) { return $this->basicMath('*', $args); } public function div(array $args) { return $this->basicMath('/', $args); } public function eq($value1, $value2) { $value1 = $this->getIdentifier($value1); $value2 = $this->getIdentifier($value2); return $value1 . ' = ' . $value2; } public function neq($value1, $value2) { $value1 = $this->getIdentifier($value1); $value2 = $this->getIdentifier($value2); return $value1 . ' <> ' . $value2; } public function gt($value1, $value2) { $value1 = $this->getIdentifier($value1); $value2 = $this->getIdentifier($value2); return $value1 . ' > ' . $value2; } public function gte($value1, $value2) { $value1 = $this->getIdentifier($value1); $value2 = $this->getIdentifier($value2); return $value1 . ' >= ' . $value2; } public function lt($value1, $value2) { $value1 = $this->getIdentifier($value1); $value2 = $this->getIdentifier($value2); return $value1 . ' < ' . $value2; } public function lte($value1, $value2) { $value1 = $this->getIdentifier($value1); $value2 = $this->getIdentifier($value2); return $value1 . ' <= ' . $value2; } public function in($column, $values) { if ( ! is_array($values)) { $values = array($values); } $values = $this->getIdentifiers($values); $column = $this->getIdentifier($column); if (count($values) == 0) { throw new Doctrine_Expression_Exception('Values array for IN operator should not be empty.'); } return $column . ' IN (' . implode(', ', $values) . ')'; } public function isNull($expression) { $expression = $this->getIdentifier($expression); return $expression . ' IS NULL'; } public function isNotNull($expression) { $expression = $this->getIdentifier($expression); return $expression . ' IS NOT NULL'; } public function between($expression, $value1, $value2) { $expression = $this->getIdentifier($expression); $value1 = $this->getIdentifier($value1); $value2 = $this->getIdentifier($value2); return $expression . ' BETWEEN ' .$value1 . ' AND ' . $value2; } public function guid() { throw new Doctrine_Expression_Exception('method not implemented'); } public function acos($value) { return 'ACOS(' . $value . ')'; } public function sin($value) { return 'SIN(' . $value . ')'; } public function pi() { return 'PI()'; } public function cos($value) { return 'COS(' . $value . ')'; } public function coalesce() { $args = func_get_args(); return 'COALESCE(' . join(', ', (array) $args) . ')'; } public function __call($m, $a) { if ($this->conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_EXPR) { throw new Doctrine_Expression_Exception('Unknown expression: ' . $m); } return $m . '(' . implode(', ', $a) . ')'; } }class Doctrine_Expression_Sqlite extends Doctrine_Expression_Driver { public static function md5Impl($data) { return md5($data); } public static function modImpl($dividend, $divisor) { return $dividend % $divisor; } public static function concatImpl() { $args = func_get_args(); return join('', $args); } public static function locateImpl($substr, $str) { return strpos($str, $substr); } public static function sha1Impl($str) { return sha1($str); } public static function ltrimImpl($str) { return ltrim($str); } public static function rtrimImpl($str) { return rtrim($str); } public static function trimImpl($str) { return trim($str); } public static function nowImpl() { return date('Y-m-d h:i:s'); } public function regexp() { return 'RLIKE'; } public function soundex($value) { return 'SOUNDEX(' . $value . ')'; } public function now($type = 'timestamp') { switch ($type) { case 'time': return 'time(\'now\')'; case 'date': return 'date(\'now\')'; case 'timestamp': default: return 'datetime(\'now\')'; } } public function random() { return '((RANDOM() + 2147483648) / 4294967296)'; } public function substring($value, $position, $length = null) { if ($length !== null) { return 'SUBSTR(' . $value . ', ' . $position . ', ' . $length . ')'; } return 'SUBSTR(' . $value . ', ' . $position . ', LENGTH(' . $value . '))'; } }class Doctrine_Expression_Mysql extends Doctrine_Expression_Driver { public function regexp() { return 'RLIKE'; } public function random() { return 'RAND()'; } public function matchPattern($pattern, $operator = null, $field = null) { $match = ''; if ( ! is_null($operator)) { $field = is_null($field) ? '' : $field.' '; $operator = strtoupper($operator); switch ($operator) { case 'ILIKE': $match = $field.'LIKE '; break; case 'LIKE': $match = $field.'LIKE BINARY '; break; default: throw new Doctrine_Expression_Mysql_Exception('not a supported operator type:'. $operator); } } $match.= "'"; foreach ($pattern as $key => $value) { if ($key % 2) { $match .= $value; } else { $match .= $this->conn->escapePattern($this->conn->escape($value)); } } $match.= "'"; $match.= $this->patternEscapeString(); return $match; } public function guid() { return 'UUID()'; } public function year($column) { $column = $this->getIdentifier($column); return 'YEAR(' . $column . ')'; } public function month($column) { $column = $this->getIdentifier($column); return 'MONTH(' . $column . ')'; } public function day($column) { $column = $this->getIdentifier($column); return 'DAY(' . $column . ')'; } public function soundex($column) { return 'SOUNDEX(' . $column . ')'; } }class Doctrine_Expression_Mssql extends Doctrine_Expression_Driver { public function now($type = 'timestamp') { switch ($type) { case 'time': case 'date': case 'timestamp': default: return 'GETDATE()'; } } public function substring($value, $position, $length = null) { if ( ! is_null($length)) { return 'SUBSTRING(' . $value . ', ' . $position . ', ' . $length . ')'; } return 'SUBSTRING(' . $value . ', ' . $position . ', LEN(' . $value . ') - ' . $position . ' + 1)'; } public function concat() { $args = func_get_args(); return '(' . implode(' + ', $args) . ')'; } public function guid() { return 'NEWID()'; } public function length($column) { return 'LEN (' . $column . ')'; } }class Doctrine_Expression_Oracle extends Doctrine_Expression_Driver { public function concat() { $args = func_get_args(); return join(' || ' , $args); } public function substring($value, $position, $length = null) { if ($length !== null) return "SUBSTR($value, $position, $length)"; return "SUBSTR($value, $position)"; } public function now($type = 'timestamp') { switch ($type) { case 'date': case 'time': case 'timestamp': default: return 'TO_CHAR(CURRENT_TIMESTAMP, \'YYYY-MM-DD HH24:MI:SS\')'; } } public function random() { return 'dbms_random.value'; } public function guid() { return 'SYS_GUID()'; } }class Doctrine_Expression_Pgsql extends Doctrine_Expression_Driver { public function md5($column) { $column = $this->getIdentifier($column); return 'MD5(' . $column . ')'; } public function substring($value, $from, $len = null) { $value = $this->getIdentifier($value); if ($len === null) { $len = $this->getIdentifier($len); return 'SUBSTR(' . $value . ', ' . $from . ')'; } else { return 'SUBSTR(' . $value . ', ' . $from . ', ' . $len . ')'; } } public function age($timestamp1, $timestamp2 = null) { if ( $timestamp2 == null ) { return 'AGE(' . $timestamp1 . ')'; } return 'AGE(' . $timestamp1 . ', ' . $timestamp2 . ')'; } public function date_part($text, $time) { return 'DATE_PART(' . $text . ', ' . $time . ')'; } public function to_char($time, $text) { return 'TO_CHAR(' . $time . ', ' . $text . ')'; } public function concat() { $args = func_get_args(); return join(' || ' , $args); } public function now() { return 'LOCALTIMESTAMP(0)'; } public function regexp() { return 'SIMILAR TO'; } public function random() { return 'RANDOM()'; } public function matchPattern($pattern, $operator = null, $field = null) { $match = ''; if ( ! is_null($operator)) { $field = is_null($field) ? '' : $field.' '; $operator = strtoupper($operator); switch ($operator) { case 'ILIKE': $match = $field.'ILIKE '; break; case 'LIKE': $match = $field.'LIKE '; break; default: throw new Doctrine_Expression_Pgsql_Exception('not a supported operator type:'. $operator); } } $match.= "'"; foreach ($pattern as $key => $value) { if ($key % 2) { $match.= $value; } else { $match.= $this->conn->escapePattern($this->conn->escape($value)); } } $match.= "'"; $match.= $this->patternEscapeString(); return $match; } public function translate($string, $from, $to) { $translate = 'TRANSLATE(' . $string . ', ' . $from . ', ' . $to . ')'; return $translate; } public function locate($substr, $str) { return $this->position($substr, $str); } public function position($substr, $str) { $substr = $this->getIdentifier($substr); $str = $this->getIdentifier($str); return sprintf('POSITION(%s IN %s)', $substr, $str); } }class Doctrine_Expression_Mock extends Doctrine_Expression_Driver { }class Doctrine_Expression_Exception extends Doctrine_Exception { }class Doctrine_Validator_Driver { public $args; public $invoker; public $field; public function __get($arg) { if (isset($this->args[$arg])) { return $this->args[$arg]; } return null; } public function __isset($arg) { return isset($this->args[$arg]); } public function __set($arg, $value) { $this->args[$arg] = $value; return $this; } public function getArg($arg) { if ( ! isset($this->args[$arg])) { throw new Doctrine_Validator_Exception('Unknown option ' . $arg); } return $this->args[$arg]; } public function setArg($arg, $value) { $this->args[$arg] = $value; return $this; } public function getArgs() { return $this->args; } public function __toString() { $className = get_class($this); if (strpos($className, 'Doctrine_Validator_') === 0) { return strtolower(substr($className, 19)); } else { return $className; } } }class Doctrine_Validator_Nospace extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } return ($value === null || ! preg_match('/\s/', $value)); } } class Doctrine_Validator_Creditcard extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } $cardType = ""; $card_regexes = array( "/^4\d{12}(\d\d\d){0,1}$/" => 'visa', "/^5[12345]\d{14}$/" => 'mastercard', "/^3[47]\d{13}$/" => 'amex', "/^6011\d{12}$/" => 'discover', "/^30[012345]\d{11}$/" => 'diners', "/^3[68]\d{12}$/" => 'diners', ); foreach ($card_regexes as $regex => $type) { if (preg_match($regex, $value)) { $cardType = $type; break; } } if ( ! $cardType) { return false; } $revcode = strrev($value); $checksum = 0; for ($i = 0; $i < strlen($revcode); $i++) { $currentNum = intval($revcode[$i]); if ($i & 1) { $currentNum *= 2; } $checksum += $currentNum % 10; if ($currentNum > 9) { $checksum += 1; } } if ($checksum % 10 == 0) { return true; } else { return false; } } }class Doctrine_Validator_Notnull extends Doctrine_Validator_Driver { public function validate($value) { return ($value !== null); } }class Doctrine_Validator_Future extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } $e = explode('-', $value); if (count($e) !== 3) { return false; } if (is_array($this->args) && isset($this->args['timezone'])) { switch (strtolower($this->args['timezone'])) { case 'gmt': $now = gmdate("U") - date("Z"); break; default: $now = getdate(); break; } } else { $now = getdate(); } if ($now['year'] > $e[0]) { return false; } else if ($now['year'] == $e[0]) { if ($now['mon'] > $e[1]) { return false; } else if ($now['mon'] == $e[1]) { return $now['mday'] < $e[2]; } else { return true; } } else { return true; } } }class Doctrine_Validator_Unsigned extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value) || $value == '') { return true; } if (preg_match('/[^0-9\-\.]/', $value)) { return false; } if ((double) $value >= 0) { return true; } return false; } }class Doctrine_Validator_Country extends Doctrine_Validator_Driver { private static $countries = array( 'ad' => 'Andorra', 'ae' => 'United Arab Emirates', 'af' => 'Afghanistan', 'ag' => 'Antigua and Barbuda', 'ai' => 'Anguilla', 'al' => 'Albania', 'am' => 'Armenia', 'an' => 'Netherlands Antilles', 'ao' => 'Angola', 'aq' => 'Antarctica', 'ar' => 'Argentina', 'as' => 'American Samoa', 'at' => 'Austria', 'au' => 'Australia', 'aw' => 'Aruba', 'az' => 'Azerbaijan', 'ba' => 'Bosnia Hercegovina', 'bb' => 'Barbados', 'bd' => 'Bangladesh', 'be' => 'Belgium', 'bf' => 'Burkina Faso', 'bg' => 'Bulgaria', 'bh' => 'Bahrain', 'bi' => 'Burundi', 'bj' => 'Benin', 'bm' => 'Bermuda', 'bn' => 'Brunei Darussalam', 'bo' => 'Bolivia', 'br' => 'Brazil', 'bs' => 'Bahamas', 'bt' => 'Bhutan', 'bv' => 'Bouvet Island', 'bw' => 'Botswana', 'by' => 'Belarus (Byelorussia)', 'bz' => 'Belize', 'ca' => 'Canada', 'cc' => 'Cocos Islands', 'cd' => 'Congo, The Democratic Republic of the', 'cf' => 'Central African Republic', 'cg' => 'Congo', 'ch' => 'Switzerland', 'ci' => 'Ivory Coast', 'ck' => 'Cook Islands', 'cl' => 'Chile', 'cm' => 'Cameroon', 'cn' => 'China', 'co' => 'Colombia', 'cr' => 'Costa Rica', 'cs' => 'Czechoslovakia', 'cu' => 'Cuba', 'cv' => 'Cape Verde', 'cx' => 'Christmas Island', 'cy' => 'Cyprus', 'cz' => 'Czech Republic', 'de' => 'Germany', 'dj' => 'Djibouti', 'dk' => 'Denmark', 'dm' => 'Dominica', 'do' => 'Dominican Republic', 'dz' => 'Algeria', 'ec' => 'Ecuador', 'ee' => 'Estonia', 'eg' => 'Egypt', 'eh' => 'Western Sahara', 'er' => 'Eritrea', 'es' => 'Spain', 'et' => 'Ethiopia', 'fi' => 'Finland', 'fj' => 'Fiji', 'fk' => 'Falkland Islands', 'fm' => 'Micronesia', 'fo' => 'Faroe Islands', 'fr' => 'France', 'fx' => 'France, Metropolitan FX', 'ga' => 'Gabon', 'gb' => 'United Kingdom (Great Britain)', 'gd' => 'Grenada', 'ge' => 'Georgia', 'gf' => 'French Guiana', 'gh' => 'Ghana', 'gi' => 'Gibraltar', 'gl' => 'Greenland', 'gm' => 'Gambia', 'gn' => 'Guinea', 'gp' => 'Guadeloupe', 'gq' => 'Equatorial Guinea', 'gr' => 'Greece', 'gs' => 'South Georgia and the South Sandwich Islands', 'gt' => 'Guatemala', 'gu' => 'Guam', 'gw' => 'Guinea-bissau', 'gy' => 'Guyana', 'hk' => 'Hong Kong', 'hm' => 'Heard and McDonald Islands', 'hn' => 'Honduras', 'hr' => 'Croatia', 'ht' => 'Haiti', 'hu' => 'Hungary', 'id' => 'Indonesia', 'ie' => 'Ireland', 'il' => 'Israel', 'in' => 'India', 'io' => 'British Indian Ocean Territory', 'iq' => 'Iraq', 'ir' => 'Iran', 'is' => 'Iceland', 'it' => 'Italy', 'jm' => 'Jamaica', 'jo' => 'Jordan', 'jp' => 'Japan', 'ke' => 'Kenya', 'kg' => 'Kyrgyzstan', 'kh' => 'Cambodia', 'ki' => 'Kiribati', 'km' => 'Comoros', 'kn' => 'Saint Kitts and Nevis', 'kp' => 'North Korea', 'kr' => 'South Korea', 'kw' => 'Kuwait', 'ky' => 'Cayman Islands', 'kz' => 'Kazakhstan', 'la' => 'Laos', 'lb' => 'Lebanon', 'lc' => 'Saint Lucia', 'li' => 'Lichtenstein', 'lk' => 'Sri Lanka', 'lr' => 'Liberia', 'ls' => 'Lesotho', 'lt' => 'Lithuania', 'lu' => 'Luxembourg', 'lv' => 'Latvia', 'ly' => 'Libya', 'ma' => 'Morocco', 'mc' => 'Monaco', 'md' => 'Moldova Republic', 'mg' => 'Madagascar', 'mh' => 'Marshall Islands', 'mk' => 'Macedonia, The Former Yugoslav Republic of', 'ml' => 'Mali', 'mm' => 'Myanmar', 'mn' => 'Mongolia', 'mo' => 'Macau', 'mp' => 'Northern Mariana Islands', 'mq' => 'Martinique', 'mr' => 'Mauritania', 'ms' => 'Montserrat', 'mt' => 'Malta', 'mu' => 'Mauritius', 'mv' => 'Maldives', 'mw' => 'Malawi', 'mx' => 'Mexico', 'my' => 'Malaysia', 'mz' => 'Mozambique', 'na' => 'Namibia', 'nc' => 'New Caledonia', 'ne' => 'Niger', 'nf' => 'Norfolk Island', 'ng' => 'Nigeria', 'ni' => 'Nicaragua', 'nl' => 'Netherlands', 'no' => 'Norway', 'np' => 'Nepal', 'nr' => 'Nauru', 'nt' => 'Neutral Zone', 'nu' => 'Niue', 'nz' => 'New Zealand', 'om' => 'Oman', 'pa' => 'Panama', 'pe' => 'Peru', 'pf' => 'French Polynesia', 'pg' => 'Papua New Guinea', 'ph' => 'Philippines', 'pk' => 'Pakistan', 'pl' => 'Poland', 'pm' => 'St. Pierre and Miquelon', 'pn' => 'Pitcairn', 'pr' => 'Puerto Rico', 'pt' => 'Portugal', 'pw' => 'Palau', 'py' => 'Paraguay', 'qa' => 'Qatar', 're' => 'Reunion', 'ro' => 'Romania', 'ru' => 'Russia', 'rw' => 'Rwanda', 'sa' => 'Saudi Arabia', 'sb' => 'Solomon Islands', 'sc' => 'Seychelles', 'sd' => 'Sudan', 'se' => 'Sweden', 'sg' => 'Singapore', 'sh' => 'St. Helena', 'si' => 'Slovenia', 'sj' => 'Svalbard and Jan Mayen Islands', 'sk' => 'Slovakia (Slovak Republic)', 'sl' => 'Sierra Leone', 'sm' => 'San Marino', 'sn' => 'Senegal', 'so' => 'Somalia', 'sr' => 'Suriname', 'st' => 'Sao Tome and Principe', 'sv' => 'El Salvador', 'sy' => 'Syria', 'sz' => 'Swaziland', 'tc' => 'Turks and Caicos Islands', 'td' => 'Chad', 'tf' => 'French Southern Territories', 'tg' => 'Togo', 'th' => 'Thailand', 'tj' => 'Tajikistan', 'tk' => 'Tokelau', 'tm' => 'Turkmenistan', 'tn' => 'Tunisia', 'to' => 'Tonga', 'tp' => 'East Timor', 'tr' => 'Turkey', 'tt' => 'Trinidad, Tobago', 'tv' => 'Tuvalu', 'tw' => 'Taiwan', 'tz' => 'Tanzania', 'ua' => 'Ukraine', 'ug' => 'Uganda', 'uk' => 'United Kingdom', 'um' => 'United States Minor Islands', 'us' => 'United States of America', 'uy' => 'Uruguay', 'uz' => 'Uzbekistan', 'va' => 'Vatican City', 'vc' => 'Saint Vincent, Grenadines', 've' => 'Venezuela', 'vg' => 'Virgin Islands (British)', 'vi' => 'Virgin Islands (USA)', 'vn' => 'Viet Nam', 'vu' => 'Vanuatu', 'wf' => 'Wallis and Futuna Islands', 'ws' => 'Samoa', 'ye' => 'Yemen', 'yt' => 'Mayotte', 'yu' => 'Yugoslavia', 'za' => 'South Africa', 'zm' => 'Zambia', 'zr' => 'Zaire', 'zw' => 'Zimbabwe'); public static function getCountries() { return self::$countries; } public function validate($value) { if (is_null($value)) { return true; } $value = strtolower($value); return isset(self::$countries[$value]); } }class Doctrine_Validator_Ip extends Doctrine_Validator_Driver { public function validate($value) { return is_null($value) ? true : (bool) filter_var($value, FILTER_VALIDATE_IP); } }class Doctrine_Validator_Minlength extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } if (isset($this->args) && strlen($value) < $this->args) { return false; } return true; } }class Doctrine_Validator_Date extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } $e = explode('-', $value); if (count($e) !== 3) { return false; } $e2 = explode(' ', $e[2]); $e[2] = $e2[0]; return checkdate($e[1], $e[2], $e[0]); } }class Doctrine_Validator_Regexp extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } if ( ! isset($this->args)) { return true; } if (is_array($this->args)) { foreach ($this->args as $regexp) { if ( ! preg_match($regexp, $value)) { return false; } } return true; } else { if (preg_match($this->args, $value)) { return true; } } return false; } }class Doctrine_Validator_Range extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } if (isset($this->args[0]) && $value < $this->args[0]) { return false; } if (isset($this->args[1]) && $value > $this->args[1]) { return false; } return true; } }class Doctrine_Validator_Timestamp extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } $e = explode('T', trim($value)); $date = isset($e[0]) ? $e[0]:null; $time = isset($e[1]) ? $e[1]:null; $dateValidator = Doctrine_Validator::getValidator('date'); $timeValidator = Doctrine_Validator::getValidator('time'); if ( ! $dateValidator->validate($date)) { return false; } if ( ! $timeValidator->validate($time)) { return false; } return true; } }class Doctrine_Validator_Readonly extends Doctrine_Validator_Driver { public function validate($value) { $modified = $this->invoker->getModified(); return array_key_exists($this->field, $modified) ? false : true; } } class Doctrine_Validator_Notblank extends Doctrine_Validator_Driver { public function validate($value) { return (trim($value) !== '' && $value !== null); } }class Doctrine_Validator_Unique extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } $table = $this->invoker->getTable(); $conn = $table->getConnection(); $pks = $table->getIdentifierColumnNames(); if (is_array($pks)) { for ($i = 0, $l = count($pks); $i < $l; $i++) { $pks[$i] = $conn->quoteIdentifier($pks[$i]); } $pks = implode(', ', $pks); } $sql = 'SELECT ' . $pks . ' FROM ' . $conn->quoteIdentifier($table->getTableName()) . ' WHERE '; if (is_array($this->field)) { foreach ($this->field as $k => $v) { $this->field[$k] = $conn->quoteIdentifier($table->getColumnName($v)); } $sql .= implode(' = ? AND ', $this->field) . ' = ?'; $values = $value; } else { $sql .= $conn->quoteIdentifier($table->getColumnName($this->field)) . ' = ?'; $values = array(); $values[] = $value; } $state = $this->invoker->state(); if ( ! ($state == Doctrine_Record::STATE_TDIRTY || $state == Doctrine_Record::STATE_TCLEAN)) { foreach ((array) $table->getIdentifierColumnNames() as $pk) { $sql .= ' AND ' . $conn->quoteIdentifier($pk) . ' != ?'; $pkFieldName = $table->getFieldName($pk); $values[] = $this->invoker->$pkFieldName; } } if (isset($this->args) && is_array($this->args) && isset($this->args['where'])) { $sql .= ' AND ' . $this->args['where']; } $stmt = $table->getConnection()->getDbh()->prepare($sql); $stmt->execute($values); return ( ! is_array($stmt->fetch())); } }class Doctrine_Validator_ErrorStack extends Doctrine_Access implements Countable, IteratorAggregate { protected $_errors = array(); protected $_validators = array(); protected $_className; public function __construct($className) { $this->_className = $className; } public function add($invalidFieldName, $errorCode = 'general') { if (is_object($errorCode)) { if ( ! ($errorCode instanceof Doctrine_Validator_Driver)) { throw new Doctrine_Exception('Validators must be an instance of Doctrine_Validator_Driver'); } $validator = $errorCode; $this->_validators[$invalidFieldName][] = $validator; $errorCode = (string) $validator; } $this->_errors[$invalidFieldName][] = $errorCode; } public function remove($fieldName) { if (isset($this->_errors[$fieldName])) { unset($this->_errors[$fieldName]); if (isset($this->_validators[$fieldName])) { unset($this->_validators[$fieldName]); } } } public function get($fieldName) { return isset($this->_errors[$fieldName]) ? $this->_errors[$fieldName] : null; } public function set($fieldName, $errorCode) { $this->add($fieldName, $errorCode); } public function contains($fieldName) { return array_key_exists($fieldName, $this->_errors); } public function clear() { $this->_errors = array(); $this->_validators = array(); } public function getIterator() { return new ArrayIterator($this->_errors); } public function toArray() { return $this->_errors; } public function count() { return count($this->_errors); } public function getClassname() { return $this->_className; } public function getValidators() { return $this->_validators; } }class Doctrine_Validator_Past extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } $e = explode('-', $value); if (count($e) !== 3) { return false; } if (is_array($this->args) && isset($this->args['timezone'])) { switch (strtolower($this->args['timezone'])) { case 'gmt': $now = gmdate("U") - date("Z"); break; default: $now = getdate(); break; } } else { $now = getdate(); } if ($now['year'] < $e[0]) { return false; } else if ($now['year'] == $e[0]) { if ($now['mon'] < $e[1]) { return false; } else if ($now['mon'] == $e[1]) { return $now['mday'] > $e[2]; } else { return true; } } else { return true; } } }class Doctrine_Validator_Email extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } if (isset($this->args) && (! isset($this->args['check_mx']) || $this->args['check_mx'] == true)) { $parts = explode('@', $value); if (isset($parts[1]) && $parts[1] && ! $this->_checkMX($parts[1])) { return false; } } $e = explode('.', $value); $tld = end($e); if (preg_match("/[^a-zA-Z]/", $tld)) { return false; } $qtext = '[^\\x0d\\x22\\x5c\\x80-\\xff]'; $dtext = '[^\\x0d\\x5b-\\x5d\\x80-\\xff]'; $atom = '[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+'; $quotedPair = '\\x5c[\\x00-\\x7f]'; $domainLiteral = "\\x5b($dtext|$quotedPair)*\\x5d"; $quotedString = "\\x22($qtext|$quotedPair)*\\x22"; $domainRef = $atom; $subDomain = "($domainRef|$domainLiteral)"; $word = "($atom|$quotedString)"; $domain = "$subDomain(\\x2e$subDomain)+"; $localPart = "$word(\\x2e$word)*"; $addrSpec = "$localPart\\x40$domain"; return (bool) preg_match("!^$addrSpec$!D", $value); } private function _checkMX($host) { if (strtolower(substr(PHP_OS, 0, 3)) == 'win' && version_compare(PHP_VERSION, '5.3.0', '<')) { $output = array(); @exec('nslookup -type=MX '.escapeshellcmd($host) . ' 2>&1', $output); if (empty($output)) { throw new Doctrine_Exception('Unable to execute DNS lookup. Are you sure PHP can call exec()?'); } foreach ($output as $line) { if (preg_match('/^'.$host.'/', $line)) { return true; } } return false; } else if (function_exists('checkdnsrr')) { return checkdnsrr($host, 'MX'); } throw new Doctrine_Exception('Could not retrieve DNS record information. Remove check_mx = true to prevent this warning'); } }class Doctrine_Validator_Usstate extends Doctrine_Validator_Driver { private static $states = array( 'AK' => true, 'AL' => true, 'AR' => true, 'AZ' => true, 'CA' => true, 'CO' => true, 'CT' => true, 'DC' => true, 'DE' => true, 'FL' => true, 'GA' => true, 'HI' => true, 'IA' => true, 'ID' => true, 'IL' => true, 'IN' => true, 'KS' => true, 'KY' => true, 'LA' => true, 'MA' => true, 'MD' => true, 'ME' => true, 'MI' => true, 'MN' => true, 'MO' => true, 'MS' => true, 'MT' => true, 'NC' => true, 'ND' => true, 'NE' => true, 'NH' => true, 'NJ' => true, 'NM' => true, 'NV' => true, 'NY' => true, 'OH' => true, 'OK' => true, 'OR' => true, 'PA' => true, 'PR' => true, 'RI' => true, 'SC' => true, 'SD' => true, 'TN' => true, 'TX' => true, 'UT' => true, 'VA' => true, 'VI' => true, 'VT' => true, 'WA' => true, 'WI' => true, 'WV' => true, 'WY' => true ); public function getStates() { return self::$states; } public function validate($value) { if (is_null($value)) { return true; } return isset(self::$states[$value]); } }class Doctrine_Validator_Exception extends Doctrine_Exception implements Countable, IteratorAggregate { private $invalid = array(); public function __construct(array $invalid) { $this->invalid = $invalid; parent::__construct($this->generateMessage()); } public function getInvalidRecords() { return $this->invalid; } public function getIterator() { return new ArrayIterator($this->invalid); } public function count() { return count($this->invalid); } private function generateMessage() { $message = ''; foreach ($this->invalid as $record) { $message .= $record->getErrorStackAsString(); } return $message; } public function inspect($function) { foreach ($this->invalid as $record) { call_user_func($function, $record->getErrorStack()); } } }class Doctrine_Validator_Time extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } if ( ! preg_match('/^\s*(\d{2}):(\d{2})(:(\d{2}))?(\.(\d{1,6}))?([+-]\d{1,2}(:(\d{2}))?)?\s*$/', $value, $matches)) { return false; } $hh = (isset($matches[1])) ? intval($matches[1]) : 0; $mm = (isset($matches[2])) ? intval($matches[2]) : 0; $ss = (isset($matches[4])) ? intval($matches[4]) : 0; $ms = (isset($matches[6])) ? intval($matches[6]) : 0; $tz_hh = (isset($matches[7])) ? intval($matches[7]) : 0; $tz_mm = (isset($matches[9])) ? intval($matches[9]) : 0; return ($hh >= 0 && $hh <= 23) && ($mm >= 0 && $mm <= 59) && ($ss >= 0 && $ss <= 59) && ($tz_hh >= -13 && $tz_hh <= 14) && ($tz_mm >= 0 && $tz_mm <= 59) ; } } class Doctrine_Validator_HtmlColor extends Doctrine_Validator_Driver { public function validate($value) { if (is_null($value)) { return true; } if ( ! preg_match("/^#{0,1}[0-9a-fA-F]{6}$/", $value)) { return false; } return true; } }class Doctrine_Locator implements Countable, IteratorAggregate { protected $_resources = array(); protected $_classPrefix = 'Doctrine_'; protected static $_instances = array(); public function __construct(array $defaults = null) { if (null !== $defaults) { foreach ($defaults as $name => $resource) { if ($resource instanceof Doctrine_Locator_Injectable) { $resource->setLocator($this); } $this->_resources[$name] = $resource; } } self::$_instances[] = $this; } public static function instance() { if (empty(self::$_instances)) { $obj = new Doctrine_Locator(); } return current(self::$_instances); } public function setClassPrefix($prefix) { $this->_classPrefix = $prefix; } public function getClassPrefix() { return $this->_classPrefix; } public function contains($name) { return isset($this->_resources[$name]); } public function bind($name, $value) { $this->_resources[$name] = $value; return $this; } public function locate($name) { if (isset($this->_resources[$name])) { return $this->_resources[$name]; } else { $className = $name; if ( ! class_exists($className)) { $name = explode('.', $name); $name = array_map('strtolower', $name); $name = array_map('ucfirst', $name); $name = implode('_', $name); $className = $this->_classPrefix . $name; if ( ! class_exists($className)) { throw new Doctrine_Locator_Exception("Couldn't locate resource " . $className); } } $this->_resources[$name] = new $className(); if ($this->_resources[$name] instanceof Doctrine_Locator_Injectable) { $this->_resources[$name]->setLocator($this); } return $this->_resources[$name]; } throw new Doctrine_Locator_Exception("Couldn't locate resource " . $name); } public function count() { return count($this->_resources); } public function getIterator() { return new ArrayIterator($this->_resources); } } final class Doctrine_Null { public function exists() { return false; } public function __toString() { return ''; } }class Doctrine_Connection_Common extends Doctrine_Connection { public function modifyLimitQuery($query, $limit = false,$offset = false,$isManip=false) { $limit = (int) $limit; $offset = (int) $offset; if ($limit && $offset) { $query .= ' LIMIT ' . $limit . ' OFFSET ' . $offset; } elseif ($limit && ! $offset) { $query .= ' LIMIT ' . $limit; } elseif ( ! $limit && $offset) { $query .= ' LIMIT 999999999999 OFFSET ' . $offset; } return $query; } }class Doctrine_Connection_Sqlite extends Doctrine_Connection_Common { protected $driverName = 'Sqlite'; public function __construct(Doctrine_Manager $manager, $adapter) { $this->supported = array('sequences' => 'emulated', 'indexes' => true, 'affected_rows' => true, 'summary_functions' => true, 'order_by_text' => true, 'current_id' => 'emulated', 'limit_queries' => true, 'LOBs' => true, 'replace' => true, 'transactions' => true, 'savepoints' => false, 'sub_selects' => true, 'auto_increment' => true, 'primary_key' => true, 'result_introspection' => false, 'prepared_statements' => 'emulated', 'identifier_quoting' => true, 'pattern_escaping' => false, ); parent::__construct($manager, $adapter); if ($this->isConnected) { $this->dbh->sqliteCreateFunction('mod', array('Doctrine_Expression_Sqlite', 'modImpl'), 2); $this->dbh->sqliteCreateFunction('concat', array('Doctrine_Expression_Sqlite', 'concatImpl')); $this->dbh->sqliteCreateFunction('md5', 'md5', 1); $this->dbh->sqliteCreateFunction('now', array('Doctrine_Expression_Sqlite', 'nowImpl'), 0); } } public function connect() { if ($this->isConnected) { return false; } parent::connect(); $this->dbh->sqliteCreateFunction('mod', array('Doctrine_Expression_Sqlite', 'modImpl'), 2); $this->dbh->sqliteCreateFunction('concat', array('Doctrine_Expression_Sqlite', 'concatImpl')); $this->dbh->sqliteCreateFunction('md5', 'md5', 1); $this->dbh->sqliteCreateFunction('now', array('Doctrine_Expression_Sqlite', 'nowImpl'), 0); } public function createDatabase() { if ( ! $dsn = $this->getOption('dsn')) { throw new Doctrine_Connection_Exception('You must create your Doctrine_Connection by using a valid Doctrine style dsn in order to use the create/drop database functionality'); } $info = $this->getManager()->parseDsn($dsn); $this->export->createDatabase($info['database']); } public function dropDatabase() { if ( ! $dsn = $this->getOption('dsn')) { throw new Doctrine_Connection_Exception('You must create your Doctrine_Connection by using a valid Doctrine style dsn in order to use the create/drop database functionality'); } $info = $this->getManager()->parseDsn($dsn); $this->export->dropDatabase($info['database']); } }class Doctrine_Connection_Exception extends Doctrine_Exception { static protected $errorMessages = array( Doctrine_Core::ERR => 'unknown error', Doctrine_Core::ERR_ALREADY_EXISTS => 'already exists', Doctrine_Core::ERR_CANNOT_CREATE => 'can not create', Doctrine_Core::ERR_CANNOT_ALTER => 'can not alter', Doctrine_Core::ERR_CANNOT_REPLACE => 'can not replace', Doctrine_Core::ERR_CANNOT_DELETE => 'can not delete', Doctrine_Core::ERR_CANNOT_DROP => 'can not drop', Doctrine_Core::ERR_CONSTRAINT => 'constraint violation', Doctrine_Core::ERR_CONSTRAINT_NOT_NULL=> 'null value violates not-null constraint', Doctrine_Core::ERR_DIVZERO => 'division by zero', Doctrine_Core::ERR_INVALID => 'invalid', Doctrine_Core::ERR_INVALID_DATE => 'invalid date or time', Doctrine_Core::ERR_INVALID_NUMBER => 'invalid number', Doctrine_Core::ERR_MISMATCH => 'mismatch', Doctrine_Core::ERR_NODBSELECTED => 'no database selected', Doctrine_Core::ERR_NOSUCHFIELD => 'no such field', Doctrine_Core::ERR_NOSUCHTABLE => 'no such table', Doctrine_Core::ERR_NOT_CAPABLE => 'Doctrine backend not capable', Doctrine_Core::ERR_NOT_FOUND => 'not found', Doctrine_Core::ERR_NOT_LOCKED => 'not locked', Doctrine_Core::ERR_SYNTAX => 'syntax error', Doctrine_Core::ERR_UNSUPPORTED => 'not supported', Doctrine_Core::ERR_VALUE_COUNT_ON_ROW => 'value count on row', Doctrine_Core::ERR_INVALID_DSN => 'invalid DSN', Doctrine_Core::ERR_CONNECT_FAILED => 'connect failed', Doctrine_Core::ERR_NEED_MORE_DATA => 'insufficient data supplied', Doctrine_Core::ERR_EXTENSION_NOT_FOUND=> 'extension not found', Doctrine_Core::ERR_NOSUCHDB => 'no such database', Doctrine_Core::ERR_ACCESS_VIOLATION => 'insufficient permissions', Doctrine_Core::ERR_LOADMODULE => 'error while including on demand module', Doctrine_Core::ERR_TRUNCATED => 'truncated', Doctrine_Core::ERR_DEADLOCK => 'deadlock detected', ); protected $portableCode; public function getPortableCode() { return $this->portableCode; } public function getPortableMessage() { return self::errorMessage($this->portableCode); } public function errorMessage($value = null) { return isset(self::$errorMessages[$value]) ? self::$errorMessages[$value] : self::$errorMessages[Doctrine_Core::ERR]; } public function processErrorInfo(array $errorInfo) { } }class Doctrine_Connection_Mssql_Exception extends Doctrine_Connection_Exception { protected static $errorCodeMap = array( 110 => Doctrine_Core::ERR_VALUE_COUNT_ON_ROW, 155 => Doctrine_Core::ERR_NOSUCHFIELD, 170 => Doctrine_Core::ERR_SYNTAX, 207 => Doctrine_Core::ERR_NOSUCHFIELD, 208 => Doctrine_Core::ERR_NOSUCHTABLE, 245 => Doctrine_Core::ERR_INVALID_NUMBER, 515 => Doctrine_Core::ERR_CONSTRAINT_NOT_NULL, 547 => Doctrine_Core::ERR_CONSTRAINT, 1913 => Doctrine_Core::ERR_ALREADY_EXISTS, 2627 => Doctrine_Core::ERR_CONSTRAINT, 2714 => Doctrine_Core::ERR_ALREADY_EXISTS, 3701 => Doctrine_Core::ERR_NOSUCHTABLE, 8134 => Doctrine_Core::ERR_DIVZERO, ); public function processErrorInfo(array $errorInfo) { $code = $errorInfo[1]; if (isset(self::$errorCodeMap[$code])) { $this->portableCode = self::$errorCodeMap[$code]; return true; } return false; } }class Doctrine_Connection_IcingaOracle extends Doctrine_Connection_Common { protected $driverName = 'Oracle'; public function __construct(Doctrine_Manager $manager, $adapter) { $this->supported = array( 'sequences' => true, 'indexes' => true, 'summary_functions' => true, 'order_by_text' => true, 'current_id' => true, 'affected_rows' => true, 'transactions' => true, 'savepoints' => true, 'limit_queries' => true, 'LOBs' => true, 'replace' => 'emulated', 'sub_selects' => true, 'auto_increment' => false, 'primary_key' => true, 'result_introspection' => true, 'prepared_statements' => true, 'identifier_quoting' => true, 'pattern_escaping' => true, ); $this->properties['sql_file_delimiter'] = "\n/\n"; $this->properties['number_max_precision'] = 38; $this->properties['max_identifier_length'] = 30; parent::__construct($manager, $adapter); $this->setParam('varchar2_max_length', 4000); $this->setParam('char_unit', null); } public function setDateFormat($format = 'YYYY-MM-DD HH24:MI:SS') { $this->exec('ALTER SESSION SET NLS_DATE_FORMAT = "' . $format . '"'); $this->exec('ALTER SESSION SET NLS_TIMESTAMP_FORMAT = "' . $format . '"'); } public function modifyLimitQuery($query, $limit = false, $offset = false, $isManip = false) { return $this->_createLimitSubquery($query, $limit, $offset); } private function _createLimitSubquery($query, $limit, $offset, $column = null) { $limit = (int) $limit; $offset = (int) $offset; if (preg_match('/^\s*SELECT/i', $query)) { if ( ! preg_match('/\sFROM\s/i', $query)) { $query .= " FROM dual"; } if ($limit > 0) { $max = $offset + $limit; $column = $column === null ? '*' : $this->quoteIdentifier($column); if ($offset > 0) { $min = $offset + 1; $query = 'SELECT '.$this->quoteIdentifier('b').'.'.$column.' FROM ( '. 'SELECT '.$this->quoteIdentifier('a').'.*, ROWNUM AS doctrine_rownum FROM ( ' . $query . ' ) ' . $this->quoteIdentifier('a') . ' '. ' ) ' . $this->quoteIdentifier('b') . ' '. 'WHERE doctrine_rownum BETWEEN ' . $min . ' AND ' . $max; } else { $query = 'SELECT a.'.$column.' FROM ( ' . $query .' ) a WHERE ROWNUM <= ' . $max; } } } return $query; } public function modifyLimitSubquery(Doctrine_Table $rootTable, $query, $limit = false, $offset = false, $isManip = false) { $columnNames = $rootTable->getIdentifierColumnNames(); if (count($columnNames) > 1) { throw new Doctrine_Connection_Exception("Composite keys in LIMIT queries are " . "currently not supported."); } $column = $columnNames[0]; return $this->_createLimitSubquery($query, $limit, $offset, $column); } public function getTmpConnection($info) { return clone $this; } public function quote($input, $type = null) { if ($type === 'boolean') { if ($input === null) { return null; } else { return $input ? 1 : 0; } } else { return parent::quote($input, $type); } } } class Doctrine_Connection_Mysql extends Doctrine_Connection_Common { protected $driverName = 'Mysql'; public function __construct(Doctrine_Manager $manager, $adapter) { $this->setAttribute(Doctrine_Core::ATTR_DEFAULT_TABLE_TYPE, 'INNODB'); $this->supported = array( 'sequences' => 'emulated', 'indexes' => true, 'affected_rows' => true, 'transactions' => true, 'savepoints' => false, 'summary_functions' => true, 'order_by_text' => true, 'current_id' => 'emulated', 'limit_queries' => true, 'LOBs' => true, 'replace' => true, 'sub_selects' => true, 'auto_increment' => true, 'primary_key' => true, 'result_introspection' => true, 'prepared_statements' => 'emulated', 'identifier_quoting' => true, 'pattern_escaping' => true ); $this->properties['string_quoting'] = array('start' => "'", 'end' => "'", 'escape' => '\\', 'escape_pattern' => '\\'); $this->properties['identifier_quoting'] = array('start' => '`', 'end' => '`', 'escape' => '`'); $this->properties['sql_comments'] = array( array('start' => '-- ', 'end' => "\n", 'escape' => false), array('start' => '#', 'end' => "\n", 'escape' => false), array('start' => '/*', 'end' => '*/', 'escape' => false), ); $this->properties['varchar_max_length'] = 255; parent::__construct($manager, $adapter); } public function connect() { $connected = parent::connect(); $this->setAttribute(PDO::ATTR_EMULATE_PREPARES, true); return $connected; } public function getDatabaseName() { return $this->fetchOne('SELECT DATABASE()'); } public function setCharset($charset) { $query = 'SET NAMES ' . $this->quote($charset); $this->exec($query); parent::setCharset($charset); } public function replace(Doctrine_Table $table, array $fields, array $keys) { if (empty($keys)) { throw new Doctrine_Connection_Exception('Not specified which fields are keys'); } $columns = array(); $values = array(); $params = array(); foreach ($fields as $fieldName => $value) { $columns[] = $table->getColumnName($fieldName); $values[] = '?'; $params[] = $value; } $query = 'REPLACE INTO ' . $this->quoteIdentifier($table->getTableName()) . ' (' . implode(',', $columns) . ') VALUES (' . implode(',', $values) . ')'; return $this->exec($query, $params); } }class Doctrine_Connection_Mysql_Exception extends Doctrine_Connection_Exception { protected static $errorCodeMap = array( 1004 => Doctrine_Core::ERR_CANNOT_CREATE, 1005 => Doctrine_Core::ERR_CANNOT_CREATE, 1006 => Doctrine_Core::ERR_CANNOT_CREATE, 1007 => Doctrine_Core::ERR_ALREADY_EXISTS, 1008 => Doctrine_Core::ERR_CANNOT_DROP, 1022 => Doctrine_Core::ERR_ALREADY_EXISTS, 1044 => Doctrine_Core::ERR_ACCESS_VIOLATION, 1046 => Doctrine_Core::ERR_NODBSELECTED, 1048 => Doctrine_Core::ERR_CONSTRAINT, 1049 => Doctrine_Core::ERR_NOSUCHDB, 1050 => Doctrine_Core::ERR_ALREADY_EXISTS, 1051 => Doctrine_Core::ERR_NOSUCHTABLE, 1054 => Doctrine_Core::ERR_NOSUCHFIELD, 1061 => Doctrine_Core::ERR_ALREADY_EXISTS, 1062 => Doctrine_Core::ERR_ALREADY_EXISTS, 1064 => Doctrine_Core::ERR_SYNTAX, 1091 => Doctrine_Core::ERR_NOT_FOUND, 1100 => Doctrine_Core::ERR_NOT_LOCKED, 1136 => Doctrine_Core::ERR_VALUE_COUNT_ON_ROW, 1142 => Doctrine_Core::ERR_ACCESS_VIOLATION, 1146 => Doctrine_Core::ERR_NOSUCHTABLE, 1216 => Doctrine_Core::ERR_CONSTRAINT, 1217 => Doctrine_Core::ERR_CONSTRAINT, 1451 => Doctrine_Core::ERR_CONSTRAINT, ); public function processErrorInfo(array $errorInfo) { $code = $errorInfo[1]; if (isset(self::$errorCodeMap[$code])) { $this->portableCode = self::$errorCodeMap[$code]; return true; } return false; } }class Doctrine_Connection_Db2 extends Doctrine_Connection_Common { public function modifyLimitQuery($query, $limit = false, $offset = false, $isManip = false) { if ($limit <= 0) return $query; if ($offset == 0) { return $query . ' FETCH FIRST '. $limit .' ROWS ONLY'; } else { $sqlPieces = explode('from', $query); $select = $sqlPieces[0]; $table = $sqlPieces[1]; $col = explode('select', $select); $sql = 'WITH OFFSET AS(' . $select . ', ROW_NUMBER() ' . 'OVER(ORDER BY ' . $col[1] . ') AS doctrine_rownum FROM ' . $table . ')' . $select . 'FROM OFFSET WHERE doctrine_rownum BETWEEN ' . $offset . 'AND ' . ($offset + $limit - 1); return $sql; } } }class Doctrine_Connection_Profiler_Exception extends Doctrine_Exception { }class Doctrine_Connection_Mssql extends Doctrine_Connection_Common { protected $driverName = 'Mssql'; public function __construct(Doctrine_Manager $manager, $adapter) { $this->supported = array( 'sequences' => 'emulated', 'indexes' => true, 'affected_rows' => true, 'transactions' => true, 'summary_functions' => true, 'order_by_text' => true, 'current_id' => 'emulated', 'limit_queries' => 'emulated', 'LOBs' => true, 'replace' => 'emulated', 'sub_selects' => true, 'auto_increment' => true, 'primary_key' => true, 'result_introspection' => true, 'prepared_statements' => 'emulated', ); $this->properties['varchar_max_length'] = 8000; parent::__construct($manager, $adapter); } public function quoteIdentifier($identifier, $checkOption = false) { if ($checkOption && ! $this->getAttribute(Doctrine_Core::ATTR_QUOTE_IDENTIFIER)) { return $identifier; } if (strpos($identifier, '.') !== false) { $parts = explode('.', $identifier); $quotedParts = array(); foreach ($parts as $p) { $quotedParts[] = $this->quoteIdentifier($p); } return implode('.', $quotedParts); } return '[' . str_replace(']', ']]', $identifier) . ']'; } public function modifyLimitQuery($query, $limit = false, $offset = false, $isManip = false, $isSubQuery = false) { if ($limit > 0) { $count = intval($limit); $offset = intval($offset); if ($offset < 0) { throw new Doctrine_Connection_Exception("LIMIT argument offset=$offset is not valid"); } $orderby = stristr($query, 'ORDER BY'); if ($orderby !== false) { $order = str_ireplace('ORDER BY', '', $orderby); $orders = explode(',', $order); for ($i = 0; $i < count($orders); $i++) { $sorts[$i] = (stripos($orders[$i], ' desc') !== false) ? 'DESC' : 'ASC'; $orders[$i] = trim(preg_replace('/\s+(ASC|DESC)$/i', '', $orders[$i])); $helper_string = stristr($query, $orders[$i]); $from_clause_pos = strpos($helper_string, ' FROM '); $fields_string = substr($helper_string, 0, $from_clause_pos + 1); $field_array = explode(',', $fields_string); $field_array = array_shift($field_array); $aux2 = spliti(' as ', $field_array); $aux2 = explode('.', end($aux2)); $aliases[$i] = trim(end($aux2)); } } $selectRegExp = 'SELECT\s+'; $selectReplace = 'SELECT '; if (preg_match('/^SELECT(\s+)DISTINCT/i', $query)) { $selectRegExp .= 'DISTINCT\s+'; $selectReplace .= 'DISTINCT '; } $fields_string = substr($query, strlen($selectReplace), strpos($query, ' FROM ') - strlen($selectReplace)); $field_array = explode(',', $fields_string); $field_array = array_shift($field_array); $aux2 = spliti(' as ', $field_array); $aux2 = explode('.', end($aux2)); $key_field = trim(end($aux2)); $query = preg_replace('/^'.$selectRegExp.'/i', $selectReplace . 'TOP ' . ($count + $offset) . ' ', $query); if ($isSubQuery === true) { $query = 'SELECT TOP ' . $count . ' ' . $this->quoteIdentifier('inner_tbl') . '.' . $key_field . ' FROM (' . $query . ') AS ' . $this->quoteIdentifier('inner_tbl'); } else { $query = 'SELECT * FROM (SELECT TOP ' . $count . ' * FROM (' . $query . ') AS ' . $this->quoteIdentifier('inner_tbl'); } if ($orderby !== false) { $query .= ' ORDER BY '; for ($i = 0, $l = count($orders); $i < $l; $i++) { if ($i > 0) { $query .= ', '; } $query .= $this->quoteIdentifier('inner_tbl') . '.' . $aliases[$i] . ' '; $query .= (stripos($sorts[$i], 'asc') !== false) ? 'DESC' : 'ASC'; } } if ($isSubQuery !== true) { $query .= ') AS ' . $this->quoteIdentifier('outer_tbl'); if ($orderby !== false) { $query .= ' ORDER BY '; for ($i = 0, $l = count($orders); $i < $l; $i++) { if ($i > 0) { $query .= ', '; } $query .= $this->quoteIdentifier('outer_tbl') . '.' . $aliases[$i] . ' ' . $sorts[$i]; } } } } return $query; } public function modifyLimitSubquery(Doctrine_Table $rootTable, $query, $limit = false, $offset = false, $isManip = false) { return $this->modifyLimitQuery($query, $limit, $offset, $isManip, true); } public function getServerVersion($native = false) { if ($this->serverInfo) { $serverInfo = $this->serverInfo; } else { $query = 'SELECT @@VERSION'; $serverInfo = $this->fetchOne($query); } $this->serverInfo = $serverInfo; if ( ! $native) { if (preg_match('/([0-9]+)\.([0-9]+)\.([0-9]+)/', $serverInfo, $tmp)) { $serverInfo = array( 'major' => $tmp[1], 'minor' => $tmp[2], 'patch' => $tmp[3], 'extra' => null, 'native' => $serverInfo, ); } else { $serverInfo = array( 'major' => null, 'minor' => null, 'patch' => null, 'extra' => null, 'native' => $serverInfo, ); } } return $serverInfo; } public function checkSequence($seqName) { $query = 'SELECT * FROM ' . $seqName; try { $this->exec($query); } catch(Doctrine_Connection_Exception $e) { if ($e->getPortableCode() == Doctrine_Core::ERR_NOSUCHTABLE) { return false; } throw $e; } return true; } public function execute($query, array $params = array()) { if(! empty($params)) { $query = $this->replaceBoundParamsWithInlineValuesInQuery($query, $params); } return parent::execute($query, array()); } public function exec($query, array $params = array()) { if(! empty($params)) { $query = $this->replaceBoundParamsWithInlineValuesInQuery($query, $params); } return parent::exec($query, array()); } protected function replaceBoundParamsWithInlineValuesInQuery($query, array $params) { foreach($params as $key => $value) { if(is_null($value)) { $value = 'NULL'; } else { $value = $this->quote($value); } $re = '/([=,\(][^\\\']*)(\?)/iU'; $query = preg_replace($re, "\\1 {$value}", $query, 1); } return $query; } public function insert(Doctrine_Table $table, array $fields) { $identifiers = $table->getIdentifierColumnNames(); $settingNullIdentifier = false; $fields = array_change_key_case($fields); foreach($identifiers as $identifier) { $lcIdentifier = strtolower($identifier); if(array_key_exists($lcIdentifier, $fields)) { if(is_null($fields[$lcIdentifier])) { $settingNullIdentifier = true; unset($fields[$lcIdentifier]); } } } if ($settingNullIdentifier) { $count = $this->exec('INSERT INTO ' . $this->quoteIdentifier($table->getTableName()) . ' DEFAULT VALUES'); if(! $count) { return $count; } $id = $this->lastInsertId($table->getTableName()); return $this->update($table, $fields, array($id)); } return parent::insert($table, $fields); } }class Doctrine_Connection_Oracle_Exception extends Doctrine_Connection_Exception { protected static $errorCodeMap = array( 1 => Doctrine_Core::ERR_CONSTRAINT, 900 => Doctrine_Core::ERR_SYNTAX, 904 => Doctrine_Core::ERR_NOSUCHFIELD, 913 => Doctrine_Core::ERR_VALUE_COUNT_ON_ROW, 921 => Doctrine_Core::ERR_SYNTAX, 923 => Doctrine_Core::ERR_SYNTAX, 942 => Doctrine_Core::ERR_NOSUCHTABLE, 955 => Doctrine_Core::ERR_ALREADY_EXISTS, 1400 => Doctrine_Core::ERR_CONSTRAINT_NOT_NULL, 1401 => Doctrine_Core::ERR_INVALID, 1407 => Doctrine_Core::ERR_CONSTRAINT_NOT_NULL, 1418 => Doctrine_Core::ERR_NOT_FOUND, 1476 => Doctrine_Core::ERR_DIVZERO, 1722 => Doctrine_Core::ERR_INVALID_NUMBER, 2289 => Doctrine_Core::ERR_NOSUCHTABLE, 2291 => Doctrine_Core::ERR_CONSTRAINT, 2292 => Doctrine_Core::ERR_CONSTRAINT, 2449 => Doctrine_Core::ERR_CONSTRAINT, ); public function processErrorInfo(array $errorInfo) { $code = $errorInfo[1]; if (isset(self::$errorCodeMap[$code])) { $this->portableCode = self::$errorCodeMap[$code]; return true; } return false; } }class Doctrine_Connection_Statement implements Doctrine_Adapter_Statement_Interface { protected $_conn; protected $_stmt; public function __construct(Doctrine_Connection $conn, $stmt) { $this->_conn = $conn; $this->_stmt = $stmt; if ($stmt === false) { throw new Doctrine_Exception('Unknown statement object given.'); } } public function getConnection() { return $this->_conn; } public function getStatement() { return $this->_stmt; } public function getQuery() { return $this->_stmt->queryString; } public function bindColumn($column, $param, $type = null) { if ($type === null) { return $this->_stmt->bindColumn($column, $param); } else { return $this->_stmt->bindColumn($column, $param, $type); } } public function bindValue($param, $value, $type = null) { if ($type === null) { return $this->_stmt->bindValue($param, $value); } else { return $this->_stmt->bindValue($param, $value, $type); } } public function bindParam($column, &$variable, $type = null, $length = null, $driverOptions = array()) { if ($type === null) { return $this->_stmt->bindParam($column, $variable); } else { return $this->_stmt->bindParam($column, $variable, $type, $length, $driverOptions); } } public function closeCursor() { return $this->_stmt->closeCursor(); } public function columnCount() { return $this->_stmt->columnCount(); } public function errorCode() { return $this->_stmt->errorCode(); } public function errorInfo() { return $this->_stmt->errorInfo(); } public function execute($params = null) { try { $event = new Doctrine_Event($this, Doctrine_Event::STMT_EXECUTE, $this->getQuery(), $params); $this->_conn->getListener()->preStmtExecute($event); $result = true; if ( ! $event->skipOperation) { if ($this->_conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_EMPTY_TO_NULL) { foreach ($params as $key => $value) { if ($value === '') { $params[$key] = null; } } } if ($params) { $pos = 0; foreach ($params as $key => $value) { $pos++; $param = is_numeric($key) ? $pos : $key; if (is_resource($value)) { $this->_stmt->bindParam($param, $params[$key], Doctrine_Core::PARAM_LOB); } else { $this->_stmt->bindParam($param, $params[$key]); } } } $result = $this->_stmt->execute(); $this->_conn->incrementQueryCount(); } $this->_conn->getListener()->postStmtExecute($event); return $result; } catch (PDOException $e) { } catch (Doctrine_Adapter_Exception $e) { } $this->_conn->rethrowException($e, $this); return false; } public function fetch($fetchMode = Doctrine_Core::FETCH_BOTH, $cursorOrientation = Doctrine_Core::FETCH_ORI_NEXT, $cursorOffset = null) { $event = new Doctrine_Event($this, Doctrine_Event::STMT_FETCH, $this->getQuery()); $event->fetchMode = $fetchMode; $event->cursorOrientation = $cursorOrientation; $event->cursorOffset = $cursorOffset; $data = $this->_conn->getListener()->preFetch($event); if ( ! $event->skipOperation) { $data = $this->_stmt->fetch($fetchMode, $cursorOrientation, $cursorOffset); } $this->_conn->getListener()->postFetch($event); return $data; } public function fetchAll($fetchMode = Doctrine_Core::FETCH_BOTH, $columnIndex = null) { $event = new Doctrine_Event($this, Doctrine_Event::STMT_FETCHALL, $this->getQuery()); $event->fetchMode = $fetchMode; $event->columnIndex = $columnIndex; $this->_conn->getListener()->preFetchAll($event); if ( ! $event->skipOperation) { if ($columnIndex !== null) { $data = $this->_stmt->fetchAll($fetchMode, $columnIndex); } else { $data = $this->_stmt->fetchAll($fetchMode); } $event->data = $data; } $this->_conn->getListener()->postFetchAll($event); return $data; } public function fetchColumn($columnIndex = 0) { return $this->_stmt->fetchColumn($columnIndex); } public function fetchObject($className = 'stdClass', $args = array()) { return $this->_stmt->fetchObject($className, $args); } public function getAttribute($attribute) { return $this->_stmt->getAttribute($attribute); } public function getColumnMeta($column) { return $this->_stmt->getColumnMeta($column); } public function nextRowset() { return $this->_stmt->nextRowset(); } public function rowCount() { return $this->_stmt->rowCount(); } public function setAttribute($attribute, $value) { return $this->_stmt->setAttribute($attribute, $value); } public function setFetchMode($mode, $arg1 = null, $arg2 = null) { return $this->_stmt->setFetchMode($mode, $arg1, $arg2); } } class Doctrine_Connection_UnitOfWork extends Doctrine_Connection_Module { public function saveGraph(Doctrine_Record $record, $replace = false) { $record->assignInheritanceValues(); $conn = $this->getConnection(); $conn->connect(); $state = $record->state(); if ($state === Doctrine_Record::STATE_LOCKED || $state === Doctrine_Record::STATE_TLOCKED) { return false; } $record->state($record->exists() ? Doctrine_Record::STATE_LOCKED : Doctrine_Record::STATE_TLOCKED); try { $conn->beginInternalTransaction(); $record->state($state); $event = $record->invokeSaveHooks('pre', 'save'); $state = $record->state(); $isValid = true; if ( ! $event->skipOperation) { $this->saveRelatedLocalKeys($record); switch ($state) { case Doctrine_Record::STATE_TDIRTY: case Doctrine_Record::STATE_TCLEAN: if ($replace) { $isValid = $this->replace($record); } else { $isValid = $this->insert($record); } break; case Doctrine_Record::STATE_DIRTY: case Doctrine_Record::STATE_PROXY: if ($replace) { $isValid = $this->replace($record); } else { $isValid = $this->update($record); } break; case Doctrine_Record::STATE_CLEAN: break; } $aliasesUnlinkInDb = array(); if ($isValid) { foreach ($record->getPendingDeletes() as $pendingDelete) { $pendingDelete->delete(); } foreach ($record->getPendingUnlinks() as $alias => $ids) { if ($ids === false) { $record->unlinkInDb($alias, array()); $aliasesUnlinkInDb[] = $alias; } else if ($ids) { $record->unlinkInDb($alias, array_keys($ids)); $aliasesUnlinkInDb[] = $alias; } } $record->resetPendingUnlinks(); $record->invokeSaveHooks('post', 'save', $event); } else { $conn->transaction->addInvalid($record); } $state = $record->state(); $record->state($record->exists() ? Doctrine_Record::STATE_LOCKED : Doctrine_Record::STATE_TLOCKED); if ($isValid) { $saveLater = $this->saveRelatedForeignKeys($record); foreach ($saveLater as $fk) { $alias = $fk->getAlias(); if ($record->hasReference($alias)) { $obj = $record->$alias; if ($obj && ! ($obj instanceof Doctrine_Null)) { $processDiff = !in_array($alias, $aliasesUnlinkInDb); $obj->save($conn, $processDiff); } } } $this->saveAssociations($record); } } $record->state($state); $conn->commit(); } catch (Exception $e) { $conn->rollback(); throw $e; } $record->clearInvokedSaveHooks(); return true; } public function delete(Doctrine_Record $record) { $deletions = array(); $this->_collectDeletions($record, $deletions); return $this->_executeDeletions($deletions); } private function _collectDeletions(Doctrine_Record $record, array &$deletions) { if ( ! $record->exists()) { return; } $deletions[$record->getOid()] = $record; $this->_cascadeDelete($record, $deletions); } private function _executeDeletions(array $deletions) { $classNames = array(); foreach ($deletions as $record) { $classNames[] = $record->getTable()->getComponentName(); } $classNames = array_unique($classNames); $executionOrder = $this->buildFlushTree($classNames); try { $this->conn->beginInternalTransaction(); for ($i = count($executionOrder) - 1; $i >= 0; $i--) { $className = $executionOrder[$i]; $table = $this->conn->getTable($className); $identifierMaps = array(); $deletedRecords = array(); foreach ($deletions as $oid => $record) { if ($record->getTable()->getComponentName() == $className) { $veto = $this->_preDelete($record); if ( ! $veto) { $identifierMaps[] = $record->identifier(); $deletedRecords[] = $record; unset($deletions[$oid]); } } } if (count($deletedRecords) < 1) { continue; } $params = array(); $columnNames = array(); foreach ($identifierMaps as $idMap) { while (list($fieldName, $value) = each($idMap)) { $params[] = $value; $columnNames[] = $table->getColumnName($fieldName); } } $columnNames = array_unique($columnNames); $tableName = $table->getTableName(); $sql = "DELETE FROM " . $this->conn->quoteIdentifier($tableName) . " WHERE "; if ($table->isIdentifierComposite()) { $sql .= $this->_buildSqlCompositeKeyCondition($columnNames, count($identifierMaps)); $this->conn->exec($sql, $params); } else { $sql .= $this->_buildSqlSingleKeyCondition($columnNames, count($params)); $this->conn->exec($sql, $params); } foreach ($deletedRecords as $record) { $this->_deleteCTIParents($table, $record); $record->state(Doctrine_Record::STATE_TCLEAN); $record->getTable()->removeRecord($record); $this->_postDelete($record); } } foreach ($deletions as $skippedRecord) { $this->_postDelete($skippedRecord); } $this->conn->commit(); return true; } catch (Exception $e) { $this->conn->rollback(); throw $e; } } private function _buildSqlSingleKeyCondition($columnNames, $numRecords) { $idColumn = $this->conn->quoteIdentifier($columnNames[0]); return implode(' OR ', array_fill(0, $numRecords, "$idColumn = ?")); } private function _buildSqlCompositeKeyCondition($columnNames, $numRecords) { $singleCondition = ""; foreach ($columnNames as $columnName) { $columnName = $this->conn->quoteIdentifier($columnName); if ($singleCondition === "") { $singleCondition .= "($columnName = ?"; } else { $singleCondition .= " AND $columnName = ?"; } } $singleCondition .= ")"; $fullCondition = implode(' OR ', array_fill(0, $numRecords, $singleCondition)); return $fullCondition; } protected function _cascadeDelete(Doctrine_Record $record, array &$deletions) { foreach ($record->getTable()->getRelations() as $relation) { if ($relation->isCascadeDelete()) { $fieldName = $relation->getAlias(); if ( ! ($relation->getType() == Doctrine_Relation::ONE && isset($record->$fieldName))) { $record->refreshRelated($relation->getAlias()); } $relatedObjects = $record->get($relation->getAlias()); if ($relatedObjects instanceof Doctrine_Record && $relatedObjects->exists() && ! isset($deletions[$relatedObjects->getOid()])) { $this->_collectDeletions($relatedObjects, $deletions); } else if ($relatedObjects instanceof Doctrine_Collection && count($relatedObjects) > 0) { foreach ($relatedObjects as $object) { if ( ! isset($deletions[$object->getOid()])) { $this->_collectDeletions($object, $deletions); } } } } } } public function saveRelatedForeignKeys(Doctrine_Record $record) { $saveLater = array(); foreach ($record->getReferences() as $k => $v) { $rel = $record->getTable()->getRelation($k); if ($rel instanceof Doctrine_Relation_ForeignKey) { $saveLater[$k] = $rel; } } return $saveLater; } public function saveRelatedLocalKeys(Doctrine_Record $record) { $state = $record->state(); $record->state($record->exists() ? Doctrine_Record::STATE_LOCKED : Doctrine_Record::STATE_TLOCKED); foreach ($record->getReferences() as $k => $v) { $rel = $record->getTable()->getRelation($k); $local = $rel->getLocal(); $foreign = $rel->getForeign(); if ($rel instanceof Doctrine_Relation_LocalKey) { $obj = $record->get($rel->getAlias()); if ($obj instanceof Doctrine_Record && $obj->isModified()) { $obj->save($this->conn); $id = array_values($obj->identifier()); if ( ! empty($id)) { foreach ((array) $rel->getLocal() as $k => $columnName) { $field = $record->getTable()->getFieldName($columnName); if (isset($id[$k]) && $id[$k] && $record->getTable()->hasField($field)) { $record->set($field, $id[$k]); } } } } } } $record->state($state); } public function saveAssociations(Doctrine_Record $record) { foreach ($record->getReferences() as $k => $v) { $rel = $record->getTable()->getRelation($k); if ($rel instanceof Doctrine_Relation_Association) { if ($this->conn->getAttribute(Doctrine_Core::ATTR_CASCADE_SAVES) || $v->isModified()) { $v->save($this->conn, false); } $assocTable = $rel->getAssociationTable(); foreach ($v->getDeleteDiff() as $r) { $query = 'DELETE FROM ' . $assocTable->getTableName() . ' WHERE ' . $rel->getForeignRefColumnName() . ' = ?' . ' AND ' . $rel->getLocalRefColumnName() . ' = ?'; $this->conn->execute($query, array($r->getIncremented(), $record->getIncremented())); } foreach ($v->getInsertDiff() as $r) { $assocRecord = $assocTable->create(); $assocRecord->set($assocTable->getFieldName($rel->getForeign()), $r); $assocRecord->set($assocTable->getFieldName($rel->getLocal()), $record); $this->saveGraph($assocRecord); } $v->takeSnapshot(); } } } private function _preDelete(Doctrine_Record $record) { $event = new Doctrine_Event($record, Doctrine_Event::RECORD_DELETE); $record->preDelete($event); $record->getTable()->getRecordListener()->preDelete($event); return $event->skipOperation; } private function _postDelete(Doctrine_Record $record) { $event = new Doctrine_Event($record, Doctrine_Event::RECORD_DELETE); $record->postDelete($event); $record->getTable()->getRecordListener()->postDelete($event); } public function saveAll() { $tree = $this->buildFlushTree($this->conn->getTables()); foreach ($tree as $name) { $table = $this->conn->getTable($name); foreach ($table->getRepository() as $record) { $this->saveGraph($record); } } } public function update(Doctrine_Record $record) { $event = $record->invokeSaveHooks('pre', 'update');; if ($record->isValid(false, false)) { $table = $record->getTable(); if ( ! $event->skipOperation) { $identifier = $record->identifier(); if ($table->getOption('joinedParents')) { $this->_updateCTIRecord($table, $record); } else { $array = $record->getPrepared(); $this->conn->update($table, $array, $identifier); } $record->assignIdentifier(true); } $record->invokeSaveHooks('post', 'update', $event); return true; } return false; } public function insert(Doctrine_Record $record) { $event = $record->invokeSaveHooks('pre', 'insert'); if ($record->isValid(false, false)) { $table = $record->getTable(); if ( ! $event->skipOperation) { if ($table->getOption('joinedParents')) { $this->_insertCTIRecord($table, $record); } else { $this->processSingleInsert($record); } } $table->addRecord($record); $record->invokeSaveHooks('post', 'insert', $event); return true; } return false; } public function replace(Doctrine_Record $record) { if ($record->exists()) { return $this->update($record); } else { if ($record->isValid()) { $this->_assignSequence($record); $saveEvent = $record->invokeSaveHooks('pre', 'save'); $insertEvent = $record->invokeSaveHooks('pre', 'insert'); $table = $record->getTable(); $identifier = (array) $table->getIdentifier(); $data = $record->getPrepared(); foreach ($data as $key => $value) { if ($value instanceof Doctrine_Expression) { $data[$key] = $value->getSql(); } } $result = $this->conn->replace($table, $data, $identifier); $record->invokeSaveHooks('post', 'insert', $insertEvent); $record->invokeSaveHooks('post', 'save', $saveEvent); $this->_assignIdentifier($record); return true; } else { return false; } } } public function processSingleInsert(Doctrine_Record $record) { $fields = $record->getPrepared(); $table = $record->getTable(); if (empty($fields)) { foreach ($table->getFieldNames() as $field) { $fields[$field] = null; } } $this->_assignSequence($record, $fields); $this->conn->insert($table, $fields); $this->_assignIdentifier($record); } public function buildFlushTree(array $tables) { $classesToOrder = array(); foreach ($tables as $table) { if ( ! ($table instanceof Doctrine_Table)) { $table = $this->conn->getTable($table, false); } $classesToOrder[] = $table->getComponentName(); } $classesToOrder = array_unique($classesToOrder); if (count($classesToOrder) < 2) { return $classesToOrder; } $flushList = array(); foreach ($classesToOrder as $class) { $table = $this->conn->getTable($class, false); $currentClass = $table->getComponentName(); $index = array_search($currentClass, $flushList); if ($index === false) { $flushList[] = $currentClass; $index = max(array_keys($flushList)); } $rels = $table->getRelations(); foreach ($rels as $key => $rel) { if ($rel instanceof Doctrine_Relation_ForeignKey) { unset($rels[$key]); array_unshift($rels, $rel); } } foreach ($rels as $rel) { $relatedClassName = $rel->getTable()->getComponentName(); if ( ! in_array($relatedClassName, $classesToOrder)) { continue; } $relatedCompIndex = array_search($relatedClassName, $flushList); $type = $rel->getType(); if ($relatedClassName === $currentClass) { continue; } if ($rel instanceof Doctrine_Relation_ForeignKey) { if ($relatedCompIndex !== false) { if ($relatedCompIndex >= $index) { continue; } unset($flushList[$index]); array_splice($flushList, $relatedCompIndex, 0, $currentClass); $index = $relatedCompIndex; } else { $flushList[] = $relatedClassName; } } else if ($rel instanceof Doctrine_Relation_LocalKey) { if ($relatedCompIndex !== false) { if ($relatedCompIndex <= $index) { continue; } unset($flushList[$relatedCompIndex]); array_splice($flushList, $index, 0, $relatedClassName); } else { array_unshift($flushList, $relatedClassName); $index++; } } else if ($rel instanceof Doctrine_Relation_Association) { $assocTable = $rel->getAssociationFactory(); $assocClassName = $assocTable->getComponentName(); if ($relatedCompIndex !== false) { unset($flushList[$relatedCompIndex]); } array_splice($flushList, $index, 0, $relatedClassName); $index++; $index3 = array_search($assocClassName, $flushList); if ($index3 !== false) { if ($index3 >= $index) { continue; } unset($flushList[$index3]); array_splice($flushList, $index - 1, 0, $assocClassName); $index = $relatedCompIndex; } else { $flushList[] = $assocClassName; } } } } return array_values($flushList); } private function _deleteCTIParents(Doctrine_Table $table, $record) { if ($table->getOption('joinedParents')) { foreach (array_reverse($table->getOption('joinedParents')) as $parent) { $parentTable = $table->getConnection()->getTable($parent); $this->conn->delete($parentTable, $record->identifier()); } } } private function _insertCTIRecord(Doctrine_Table $table, Doctrine_Record $record) { $dataSet = $this->_formatDataSet($record); $component = $table->getComponentName(); $classes = $table->getOption('joinedParents'); $classes[] = $component; foreach ($classes as $k => $parent) { if ($k === 0) { $rootRecord = new $parent(); $rootRecord->merge($dataSet[$parent]); $this->processSingleInsert($rootRecord); $record->assignIdentifier($rootRecord->identifier()); } else { foreach ((array) $rootRecord->identifier() as $id => $value) { $dataSet[$parent][$id] = $value; } $this->conn->insert($this->conn->getTable($parent), $dataSet[$parent]); } } } private function _updateCTIRecord(Doctrine_Table $table, Doctrine_Record $record) { $identifier = $record->identifier(); $dataSet = $this->_formatDataSet($record); $component = $table->getComponentName(); $classes = $table->getOption('joinedParents'); $classes[] = $component; foreach ($record as $field => $value) { if ($value instanceof Doctrine_Record) { if ( ! $value->exists()) { $value->save(); } $record->set($field, $value->getIncremented()); } } foreach ($classes as $class) { $parentTable = $this->conn->getTable($class); if ( ! array_key_exists($class, $dataSet)) { continue; } $this->conn->update($this->conn->getTable($class), $dataSet[$class], $identifier); } } private function _formatDataSet(Doctrine_Record $record) { $table = $record->getTable(); $dataSet = array(); $component = $table->getComponentName(); $array = $record->getPrepared(); foreach ($table->getColumns() as $columnName => $definition) { if ( ! isset($dataSet[$component])) { $dataSet[$component] = array(); } if ( isset($definition['owner']) && ! isset($dataSet[$definition['owner']])) { $dataSet[$definition['owner']] = array(); } $fieldName = $table->getFieldName($columnName); if (isset($definition['primary']) && $definition['primary']) { continue; } if ( ! array_key_exists($fieldName, $array)) { continue; } if (isset($definition['owner'])) { $dataSet[$definition['owner']][$fieldName] = $array[$fieldName]; } else { $dataSet[$component][$fieldName] = $array[$fieldName]; } } return $dataSet; } protected function _assignSequence(Doctrine_Record $record, &$fields = null) { $table = $record->getTable(); $seq = $table->sequenceName; if ( ! empty($seq)) { $id = $this->conn->sequence->nextId($seq); $seqName = $table->getIdentifier(); if ($fields) { $fields[$seqName] = $id; } $record->assignIdentifier($id); return $id; } } protected function _assignIdentifier(Doctrine_Record $record) { $table = $record->getTable(); $identifier = $table->getIdentifier(); $seq = $table->sequenceName; if (empty($seq) && !is_array($identifier) && $table->getIdentifierType() != Doctrine_Core::IDENTIFIER_NATURAL) { $id = false; if ($record->$identifier == null) { if (($driver = strtolower($this->conn->getDriverName())) == 'pgsql') { $seq = $table->getTableName() . '_' . $table->getColumnName($identifier); } elseif ($driver == 'oracle' || $driver == 'mssql') { $seq = $table->getTableName(); } $id = $this->conn->sequence->lastInsertId($seq); } else { $id = $record->$identifier; } if ( ! $id) { throw new Doctrine_Connection_Exception("Couldn't get last insert identifier."); } $record->assignIdentifier($id); } else { $record->assignIdentifier(true); } } }class Doctrine_Connection_Pgsql_Exception extends Doctrine_Connection_Exception { protected static $errorRegexps = array( '/parser: parse error at or near/i' => Doctrine_Core::ERR_SYNTAX, '/syntax error at/' => Doctrine_Core::ERR_SYNTAX, '/column reference .* is ambiguous/i' => Doctrine_Core::ERR_SYNTAX, '/column .* (of relation .*)?does not exist/i' => Doctrine_Core::ERR_NOSUCHFIELD, '/attribute .* not found|relation .* does not have attribute/i' => Doctrine_Core::ERR_NOSUCHFIELD, '/column .* specified in USING clause does not exist in (left|right) table/i' => Doctrine_Core::ERR_NOSUCHFIELD, '/(relation|sequence|table).*does not exist|class .* not found/i' => Doctrine_Core::ERR_NOSUCHTABLE, '/index .* does not exist/' => Doctrine_Core::ERR_NOT_FOUND, '/relation .* already exists/i' => Doctrine_Core::ERR_ALREADY_EXISTS, '/(divide|division) by zero$/i' => Doctrine_Core::ERR_DIVZERO, '/pg_atoi: error in .*: can\'t parse /i' => Doctrine_Core::ERR_INVALID_NUMBER, '/invalid input syntax for( type)? (integer|numeric)/i' => Doctrine_Core::ERR_INVALID_NUMBER, '/value .* is out of range for type \w*int/i' => Doctrine_Core::ERR_INVALID_NUMBER, '/integer out of range/i' => Doctrine_Core::ERR_INVALID_NUMBER, '/value too long for type character/i' => Doctrine_Core::ERR_INVALID, '/permission denied/' => Doctrine_Core::ERR_ACCESS_VIOLATION, '/violates [\w ]+ constraint/' => Doctrine_Core::ERR_CONSTRAINT, '/referential integrity violation/' => Doctrine_Core::ERR_CONSTRAINT, '/violates not-null constraint/' => Doctrine_Core::ERR_CONSTRAINT_NOT_NULL, '/more expressions than target columns/i' => Doctrine_Core::ERR_VALUE_COUNT_ON_ROW, ); public function processErrorInfo(array $errorInfo) { foreach (self::$errorRegexps as $regexp => $code) { if (preg_match($regexp, $errorInfo[2])) { $this->portableCode = $code; return true; } } return false; } }class Doctrine_Connection_Sqlite_Exception extends Doctrine_Connection_Exception { protected static $errorRegexps = array( '/^no such table:/' => Doctrine_Core::ERR_NOSUCHTABLE, '/^no such index:/' => Doctrine_Core::ERR_NOT_FOUND, '/^(table|index) .* already exists$/' => Doctrine_Core::ERR_ALREADY_EXISTS, '/PRIMARY KEY must be unique/i' => Doctrine_Core::ERR_CONSTRAINT, '/is not unique/' => Doctrine_Core::ERR_CONSTRAINT, '/columns .* are not unique/i' => Doctrine_Core::ERR_CONSTRAINT, '/uniqueness constraint failed/' => Doctrine_Core::ERR_CONSTRAINT, '/may not be NULL/' => Doctrine_Core::ERR_CONSTRAINT_NOT_NULL, '/^no such column:/' => Doctrine_Core::ERR_NOSUCHFIELD, '/column not present in both tables/i' => Doctrine_Core::ERR_NOSUCHFIELD, '/^near ".*": syntax error$/' => Doctrine_Core::ERR_SYNTAX, '/[0-9]+ values for [0-9]+ columns/i' => Doctrine_Core::ERR_VALUE_COUNT_ON_ROW, ); public function processErrorInfo(array $errorInfo) { foreach (self::$errorRegexps as $regexp => $code) { if (preg_match($regexp, $errorInfo[2])) { $this->portableCode = $code; return true; } } return false; } }class Doctrine_Connection_Profiler implements Doctrine_Overloadable, IteratorAggregate, Countable { private $listeners = array('query', 'prepare', 'commit', 'rollback', 'connect', 'begintransaction', 'exec', 'execute'); private $events = array(); private $eventSequences = array(); public function __construct() { } public function setFilterQueryType() { } public function __call($m, $a) { if ( ! ($a[0] instanceof Doctrine_Event)) { throw new Doctrine_Connection_Profiler_Exception("Couldn't listen event. Event should be an instance of Doctrine_Event."); } if (substr($m, 0, 3) === 'pre') { $a[0]->start(); $eventSequence = $a[0]->getSequence(); if ( ! isset($this->eventSequences[$eventSequence])) { $this->events[] = $a[0]; $this->eventSequences[$eventSequence] = true; } } else { $a[0]->end(); } } public function get($key) { if (isset($this->events[$key])) { return $this->events[$key]; } return null; } public function getAll() { return $this->events; } public function getIterator() { return new ArrayIterator($this->events); } public function count() { return count($this->events); } public function pop() { $event = array_pop($this->events); if ($event !== null) { unset($this->eventSequences[$event->getSequence()]); } return $event; } public function lastEvent() { if (empty($this->events)) { return false; } end($this->events); return current($this->events); } }class Doctrine_Connection_Oracle extends Doctrine_Connection_Common { protected $driverName = 'Oracle'; public function __construct(Doctrine_Manager $manager, $adapter) { $this->supported = array( 'sequences' => true, 'indexes' => true, 'summary_functions' => true, 'order_by_text' => true, 'current_id' => true, 'affected_rows' => true, 'transactions' => true, 'savepoints' => true, 'limit_queries' => true, 'LOBs' => true, 'replace' => 'emulated', 'sub_selects' => true, 'auto_increment' => false, 'primary_key' => true, 'result_introspection' => true, 'prepared_statements' => true, 'identifier_quoting' => true, 'pattern_escaping' => true, ); $this->properties['sql_file_delimiter'] = "\n/\n"; $this->properties['number_max_precision'] = 38; $this->properties['max_identifier_length'] = 30; parent::__construct($manager, $adapter); $this->setParam('varchar2_max_length', 4000); $this->setParam('char_unit', null); } public function setDateFormat($format = 'YYYY-MM-DD HH24:MI:SS') { $this->exec('ALTER SESSION SET NLS_DATE_FORMAT = "' . $format . '"'); $this->exec('ALTER SESSION SET NLS_TIMESTAMP_FORMAT = "' . $format . '"'); } public function modifyLimitQuery($query, $limit = false, $offset = false, $isManip = false) { return $this->_createLimitSubquery($query, $limit, $offset); } private function _createLimitSubquery($query, $limit, $offset, $column = null) { $limit = (int) $limit; $offset = (int) $offset; if (preg_match('/^\s*SELECT/i', $query)) { if ( ! preg_match('/\sFROM\s/i', $query)) { $query .= " FROM dual"; } if ($limit > 0) { $max = $offset + $limit; $column = $column === null ? '*' : $this->quoteIdentifier($column); if ($offset > 0) { $min = $offset + 1; $query = 'SELECT '.$this->quoteIdentifier('b').'.'.$column.' FROM ( '. 'SELECT '.$this->quoteIdentifier('a').'.*, ROWNUM AS doctrine_rownum FROM ( ' . $query . ' ) ' . $this->quoteIdentifier('a') . ' '. ' ) ' . $this->quoteIdentifier('b') . ' '. 'WHERE doctrine_rownum BETWEEN ' . $min . ' AND ' . $max; } else { $query = 'SELECT a.'.$column.' FROM ( ' . $query .' ) a WHERE ROWNUM <= ' . $max; } } } return $query; } public function modifyLimitSubquery(Doctrine_Table $rootTable, $query, $limit = false, $offset = false, $isManip = false) { $columnNames = $rootTable->getIdentifierColumnNames(); if (count($columnNames) > 1) { throw new Doctrine_Connection_Exception("Composite keys in LIMIT queries are " . "currently not supported."); } $column = $columnNames[0]; return $this->_createLimitSubquery($query, $limit, $offset, $column); } public function getTmpConnection($info) { return clone $this; } public function quote($input, $type = null) { if ($type === 'boolean') { if ($input === null) { return null; } else { return $input ? 1 : 0; } } else { return parent::quote($input, $type); } } } class Doctrine_Connection_Pgsql extends Doctrine_Connection_Common { protected $driverName = 'Pgsql'; public function __construct(Doctrine_Manager $manager, $adapter) { $this->supported = array( 'sequences' => true, 'indexes' => true, 'affected_rows' => true, 'summary_functions' => true, 'order_by_text' => true, 'transactions' => true, 'savepoints' => true, 'current_id' => true, 'limit_queries' => true, 'LOBs' => true, 'replace' => 'emulated', 'sub_selects' => true, 'auto_increment' => 'emulated', 'primary_key' => true, 'result_introspection' => true, 'prepared_statements' => true, 'identifier_quoting' => true, 'pattern_escaping' => true, ); $this->properties['string_quoting'] = array('start' => "'", 'end' => "'", 'escape' => "'", 'escape_pattern' => '\\'); $this->properties['identifier_quoting'] = array('start' => '"', 'end' => '"', 'escape' => '"'); parent::__construct($manager, $adapter); } public function setCharset($charset) { $query = 'SET NAMES '.$this->quote($charset); $this->exec($query); parent::setCharset($charset); } public function convertBooleans($item) { if (is_array($item)) { foreach ($item as $key => $value) { if (is_bool($value)) { $item[$key] = ($value) ? 'true' : 'false'; } } } else { if (is_bool($item) || is_numeric($item)) { $item = ($item) ? 'true' : 'false'; } } return $item; } public function modifyLimitQuery($query, $limit = false, $offset = false, $isManip = false) { if ($limit > 0) { $query = rtrim($query); if (substr($query, -1) == ';') { $query = substr($query, 0, -1); } if ($isManip) { $manip = preg_replace('/^(DELETE FROM|UPDATE).*$/', '\\1', $query); $from = $match[2]; $where = $match[3]; $query = $manip . ' ' . $from . ' WHERE ctid=(SELECT ctid FROM ' . $from . ' ' . $where . ' LIMIT ' . $limit . ')'; } else { if ( ! empty($limit)) { $query .= ' LIMIT ' . $limit; } if ( ! empty($offset)) { $query .= ' OFFSET ' . $offset; } } } return $query; } public function getServerVersion($native = false) { $query = 'SHOW SERVER_VERSION'; $serverInfo = $this->fetchOne($query); if ( ! $native) { $tmp = explode('.', $serverInfo, 3); if (empty($tmp[2]) && isset($tmp[1]) && preg_match('/(\d+)(.*)/', $tmp[1], $tmp2) ) { $serverInfo = array( 'major' => $tmp[0], 'minor' => $tmp2[1], 'patch' => null, 'extra' => $tmp2[2], 'native' => $serverInfo, ); } else { $serverInfo = array( 'major' => isset($tmp[0]) ? $tmp[0] : null, 'minor' => isset($tmp[1]) ? $tmp[1] : null, 'patch' => isset($tmp[2]) ? $tmp[2] : null, 'extra' => null, 'native' => $serverInfo, ); } } return $serverInfo; } public function insert(Doctrine_Table $table, array $fields) { $tableName = $table->getTableName(); $cols = array(); $a = array(); foreach ($fields as $fieldName => $value) { if ($table->isIdentifier($fieldName) && $table->isIdentifierAutoincrement() && $value == null) { unset($fields[$fieldName]); continue; } $cols[] = $this->quoteIdentifier($table->getColumnName($fieldName)); if ($value instanceof Doctrine_Expression) { $a[] = $value->getSql(); unset($fields[$fieldName]); } else { $a[] = '?'; } } if (count($fields) == 0) { return $this->exec('INSERT INTO ' . $this->quoteIdentifier($tableName) . ' ' . ' VALUES (DEFAULT)'); } $query = 'INSERT INTO ' . $this->quoteIdentifier($tableName) . ' (' . implode(', ', $cols) . ')' . ' VALUES (' . implode(', ', $a) . ')'; return $this->exec($query, array_values($fields)); } } class Doctrine_Connection_Mock extends Doctrine_Connection_Common { protected $driverName = 'Mock'; public function __construct(Doctrine_Manager $manager, $adapter) { } }abstract class Doctrine_Hook_Parser { protected $condition; protected $params = array(); public function getCondition() { return $this->condition; } public function getParams() { return $this->params; } abstract public function parse($alias, $field, $value); }abstract class Doctrine_Hook_Parser_Complex extends Doctrine_Hook_Parser { protected $_tokenizer; public function __construct() { $this->_tokenizer = new Doctrine_Query_Tokenizer(); } public function parse($alias, $field, $value) { $this->condition = $this->parseClause($alias, $field, $value); } public function parseClause($alias, $field, $value) { $parts = $this->_tokenizer->quoteExplode($value, ' AND '); if (count($parts) > 1) { $ret = array(); foreach ($parts as $part) { $ret[] = $this->parseSingle($alias, $field, $part); } $r = implode(' AND ', $ret); } else { $parts = $this->_tokenizer->quoteExplode($value, ' OR '); if (count($parts) > 1) { $ret = array(); foreach ($parts as $part) { $ret[] = $this->parseClause($alias, $field, $part); } $r = implode(' OR ', $ret); } else { $ret = $this->parseSingle($alias, $field, $parts[0]); return $ret; } } return '(' . $r . ')'; } abstract public function parseSingle($alias, $field, $value); }class Doctrine_Hook_Integer extends Doctrine_Hook_Parser_Complex { public function parseSingle($alias, $field, $value) { $e = explode(' ', $value); foreach ($e as $v) { $v = trim($v); $e2 = explode('-', $v); $name = $alias. '.' . $field; if (count($e2) == 1) { $a[] = $name . ' = ?'; $this->params[] = $v; } else { $a[] = '(' . $name . ' > ? AND ' . $name . ' < ?)'; $this->params += array($e2[0], $e2[1]); } } return implode(' OR ', $a); } }class Doctrine_Hook_WordLike extends Doctrine_Hook_Parser_Complex { public function parseSingle($alias, $field, $value) { if (strpos($value, "'") !== false) { $value = $this->_tokenizer->bracketTrim($value, "'", "'"); $a[] = $alias . '.' . $field . ' LIKE ?'; $this->params[] = '%' . $value . '%'; } else { $e2 = explode(' ',$value); foreach ($e2 as $v) { $v = trim($v); $a[] = $alias . '.' . $field . ' LIKE ?'; $this->params[] = '%' . $v . '%'; } } return implode(' OR ', $a); } } class Doctrine_Hook_Equal extends Doctrine_Hook_Parser { public function parse($alias, $field, $value) { $this->params = (array) $value; $this->condition = $alias . '.' . $field . ' = ?'; } }class Doctrine_Task_DropDb extends Doctrine_Task { public $description = 'Drop database for all existing connections', $requiredArguments = array(), $optionalArguments = array('force' => 'Whether or not to force the drop database task'); public function execute() { if ( ! $this->getArgument('force')) { $answer = $this->ask('Are you sure you wish to drop your databases? (y/n)'); if ($answer != 'y') { $this->notify('Successfully cancelled'); return; } } $manager = Doctrine_Manager::getInstance(); foreach ($manager as $name => $connection) { try { $connection->dropDatabase(); $this->notify("Successfully dropped database for connection named '" . $name . "'"); } catch (Exception $e) { $this->notify($e->getMessage()); } } } }class Doctrine_Task_GenerateModelsYaml extends Doctrine_Task { public $description = 'Generates your Doctrine_Record definitions from a Yaml schema file', $requiredArguments = array('yaml_schema_path' => 'Specify the complete directory path to your yaml schema files.', 'models_path' => 'Specify complete path to your Doctrine_Record definitions.'), $optionalArguments = array('generate_models_options' => 'Array of options for generating models'); public function execute() { Doctrine_Core::generateModelsFromYaml($this->getArgument('yaml_schema_path'), $this->getArgument('models_path'), $this->getArgument('generate_models_options', array())); $this->notify('Generated models successfully from YAML schema'); } } class Doctrine_Task_CreateTables extends Doctrine_Task { public $description = 'Create tables for all existing database connections. If table exists nothing happens.', $requiredArguments = array('models_path' => 'Specify path to your models directory.'), $optionalArguments = array(); public function execute() { Doctrine_Core::createTablesFromModels($this->getArgument('models_path')); $this->notify('Created tables successfully'); } }class Doctrine_Task_BuildAllReload extends Doctrine_Task { public $description = 'Calls rebuild-db and load-data', $requiredArguments = array(), $optionalArguments = array(); public function __construct($dispatcher = null) { parent::__construct($dispatcher); $this->rebuildDb = new Doctrine_Task_RebuildDb($this->dispatcher); $this->loadData = new Doctrine_Task_LoadData($this->dispatcher); $this->requiredArguments = array_merge($this->requiredArguments, $this->rebuildDb->requiredArguments, $this->loadData->requiredArguments); $this->optionalArguments = array_merge($this->optionalArguments, $this->rebuildDb->optionalArguments, $this->loadData->optionalArguments); } public function execute() { $this->rebuildDb->setArguments($this->getArguments()); $this->rebuildDb->execute(); $this->loadData->setArguments($this->getArguments()); $this->loadData->execute(); } }class Doctrine_Task_BuildAll extends Doctrine_Task { public $description = 'Calls generate-models-from-yaml, create-db, and create-tables', $requiredArguments = array(), $optionalArguments = array(); protected $models, $tables; public function __construct($dispatcher = null) { parent::__construct($dispatcher); $this->models = new Doctrine_Task_GenerateModelsYaml($this->dispatcher); $this->createDb = new Doctrine_Task_CreateDb($this->dispatcher); $this->tables = new Doctrine_Task_CreateTables($this->dispatcher); $this->requiredArguments = array_merge($this->requiredArguments, $this->models->requiredArguments, $this->createDb->requiredArguments, $this->tables->requiredArguments); $this->optionalArguments = array_merge($this->optionalArguments, $this->models->optionalArguments, $this->createDb->optionalArguments, $this->tables->optionalArguments); } public function execute() { $this->models->setArguments($this->getArguments()); $this->models->execute(); $this->createDb->setArguments($this->getArguments()); $this->createDb->execute(); $this->tables->setArguments($this->getArguments()); $this->tables->execute(); } }class Doctrine_Task_GenerateMigrationsDiff extends Doctrine_Task { public $description = 'Generate migration classes from a generated difference between your models and yaml schema files', $requiredArguments = array('migrations_path' => 'Specify the path to your migration classes folder.', 'yaml_schema_path' => 'Specify the path to your yaml schema files folder.'), $optionalArguments = array('models_path' => 'Specify the path to your doctrine models folder.'); public function execute() { $migrationsPath = $this->getArgument('migrations_path'); $modelsPath = $this->getArgument('models_path'); $yamlSchemaPath = $this->getArgument('yaml_schema_path'); $migration = new Doctrine_Migration($migrationsPath); $diff = new Doctrine_Migration_Diff($modelsPath, $yamlSchemaPath, $migration); $changes = $diff->generateMigrationClasses(); $numChanges = count($changes, true) - count($changes); if ( ! $numChanges) { throw new Doctrine_Task_Exception('Could not generate migration classes from difference'); } else { $this->notify('Generated migration classes successfully from difference'); } } }class Doctrine_Task_GenerateSql extends Doctrine_Task { public $description = 'Generate sql for all existing database connections.', $requiredArguments = array('models_path' => 'Specify complete path to your Doctrine_Record definitions.', 'sql_path' => 'Path to write the generated sql.'), $optionalArguments = array(); public function execute() { if (is_dir($this->getArgument('sql_path'))) { $path = $this->getArgument('sql_path') . DIRECTORY_SEPARATOR . 'schema.sql'; } else if (is_file($this->getArgument('sql_path'))) { $path = $this->getArgument('sql_path'); } else { throw new Doctrine_Task_Exception('Invalid sql path.'); } $sql = Doctrine_Core::generateSqlFromModels($this->getArgument('models_path')); file_put_contents($path, $sql); $this->notify('Generated SQL successfully for models'); } }class Doctrine_Task_Migrate extends Doctrine_Task { public $description = 'Migrate database to latest version or the specified version', $requiredArguments = array('migrations_path' => 'Specify path to your migrations directory.'), $optionalArguments = array('version' => 'Version to migrate to. If you do not specify, the db will be migrated from the current version to the latest.'); public function execute() { $version = Doctrine_Core::migrate($this->getArgument('migrations_path'), $this->getArgument('version')); $this->notify('migrated successfully to version #' . $version); } }class Doctrine_Task_LoadData extends Doctrine_Task { public $description = 'Load data from a yaml data fixture file.', $requiredArguments = array('data_fixtures_path' => 'Specify the complete path to load the yaml data fixtures files from.', 'models_path' => 'Specify path to your Doctrine_Record definitions.'), $optionalArguments = array('append' => 'Whether or not to append the data'); public function execute() { Doctrine_Core::loadModels($this->getArgument('models_path')); Doctrine_Core::loadData($this->getArgument('data_fixtures_path'), $this->getArgument('append', false)); $this->notify('Data was successfully loaded'); } }class Doctrine_Task_Compile extends Doctrine_Task { public $description = 'Compile doctrine classes in to one single php file', $requiredArguments = array(), $optionalArguments = array('drivers' => 'Specify list of drivers you wish to compile. Ex: mysql|mssql|sqlite', 'compiled_path' => 'The path where you want to write the compiled doctrine libs.'); public function execute() { $compiledPath = Doctrine_Core::compile($this->getArgument('compiled_path'), $this->getArgument('drivers', array())); $this->notify('Compiled Doctrine successfully to: ' . $compiledPath); } }class Doctrine_Task_DumpData extends Doctrine_Task { public $description = 'Dump data to a yaml data fixture file.', $requiredArguments = array('data_fixtures_path' => 'Specify path to write the yaml data fixtures file to.', 'models_path' => 'Specify path to your Doctrine_Record definitions.'), $optionalArguments = array(); public function execute() { $models = Doctrine_Core::loadModels($this->getArgument('models_path')); if (empty($models)) { throw new Doctrine_Task_Exception('No models were loaded'); } $path = $this->getArgument('data_fixtures_path'); if (is_array($path) && count($path) > 0) { $path = $path[0]; } if ( ! empty($path)) { Doctrine_Core::dumpData($path); $this->notify(sprintf('Dumped data successfully to: %s', $path)); } else { throw new Doctrine_Task_Exception('Unable to find data fixtures path.'); } } }class Doctrine_Task_Dql extends Doctrine_Task { public $description = 'Execute dql query and display the results', $requiredArguments = array('models_path' => 'Specify path to your Doctrine_Record definitions.', 'dql_query' => 'Specify the complete dql query to execute.'), $optionalArguments = array('params' => 'Comma separated list of the params to replace the ? tokens in the dql'); public function execute() { Doctrine_Core::loadModels($this->getArgument('models_path')); $dql = $this->getArgument('dql_query'); $query = Doctrine_Query::create(); $params = $this->getArgument('params'); $params = $params ? explode(',', $params):array(); $this->notify('executing: "' . $dql . '" (' . implode(', ', $params) . ')'); $results = $query->query($dql, $params, Doctrine_Core::HYDRATE_ARRAY); $this->_printResults($results); } protected function _printResults($array) { $yaml = Doctrine_Parser::dump($array, 'yml'); $lines = explode("\n", $yaml); unset($lines[0]); foreach ($lines as $yamlLine) { $line = trim($yamlLine); if ($line) { $this->notify($yamlLine); } } } }class Doctrine_Task_BuildAllLoad extends Doctrine_Task { public $description = 'Calls build-all, and load-data', $requiredArguments = array(), $optionalArguments = array(); public function __construct($dispatcher = null) { parent::__construct($dispatcher); $this->buildAll = new Doctrine_Task_BuildAll($this->dispatcher); $this->loadData = new Doctrine_Task_LoadData($this->dispatcher); $this->requiredArguments = array_merge($this->requiredArguments, $this->buildAll->requiredArguments, $this->loadData->requiredArguments); $this->optionalArguments = array_merge($this->optionalArguments, $this->buildAll->optionalArguments, $this->loadData->optionalArguments); } public function execute() { $this->buildAll->setArguments($this->getArguments()); $this->buildAll->execute(); $this->loadData->setArguments($this->getArguments()); $this->loadData->execute(); } }class Doctrine_Task_GenerateMigration extends Doctrine_Task { public $description = 'Generate new migration class definition', $requiredArguments = array('class_name' => 'Name of the migration class to generate', 'migrations_path' => 'Specify the complete path to your migration classes folder.'), $optionalArguments = array(); public function execute() { Doctrine_Core::generateMigrationClass($this->getArgument('class_name'), $this->getArgument('migrations_path')); $this->notify(sprintf('Generated migration class: %s successfully to %s', $this->getArgument('class_name'), $this->getArgument('migrations_path'))); } }class Doctrine_Task_GenerateYamlModels extends Doctrine_Task { public $description = 'Generates a Yaml schema file from existing Doctrine_Record definitions', $requiredArguments = array('yaml_schema_path' => 'Specify the complete directory path to your yaml schema files.'), $optionalArguments = array('models_path' => 'Specify complete path to your Doctrine_Record definitions.'); public function execute() { Doctrine_Core::generateYamlFromModels($this->getArgument('yaml_schema_path'), $this->getArgument('models_path')); $this->notify('Generated YAML schema successfully from models'); } }class Doctrine_Task_GenerateModelsDb extends Doctrine_Task { public $description = 'Generates your Doctrine_Record definitions from your existing database connections.', $requiredArguments = array('models_path' => 'Specify path to your Doctrine_Record definitions.'), $optionalArguments = array('connection' => 'Optionally specify a single connection to generate the models for.'); public function execute() { $configs = $this->dispatcher->getConfig(); $options = isset($configs['generate_models_options']) ? $configs['generate_models_options'] : array(); Doctrine_Core::generateModelsFromDb($this->getArgument('models_path'), (array) $this->getArgument('connection'), $options); $this->notify('Generated models successfully from databases'); } } class Doctrine_Task_CreateDb extends Doctrine_Task { public $description = 'Create all databases for your connections. If the database already exists, nothing happens.', $optionalArguments = array(); public function execute() { $manager = Doctrine_Manager::getInstance(); foreach ($manager as $name => $connection) { try { $connection->createDatabase(); $this->notify("Successfully created database for connection named '" . $name . "'"); } catch (Exception $e) { $this->notify($e->getMessage()); } } } }class Doctrine_Task_RebuildDb extends Doctrine_Task { public $description = 'Drops and re-creates databases', $requiredArguments = array(), $optionalArguments = array(); public function __construct($dispatcher = null) { parent::__construct($dispatcher); $this->dropDb = new Doctrine_Task_DropDb($this->dispatcher); $this->createDb = new Doctrine_Task_CreateDb($this->dispatcher); $this->createTables = new Doctrine_Task_CreateTables($this->dispatcher); $this->requiredArguments = array_merge($this->requiredArguments, $this->dropDb->requiredArguments, $this->createDb->requiredArguments, $this->createTables->requiredArguments); $this->optionalArguments = array_merge($this->optionalArguments, $this->dropDb->optionalArguments, $this->createDb->optionalArguments, $this->createTables->optionalArguments); } public function execute() { $this->dropDb->setArguments($this->getArguments()); $this->dropDb->execute(); $this->createDb->setArguments($this->getArguments()); $this->createDb->execute(); $this->createTables->setArguments($this->getArguments()); $this->createTables->execute(); } }class Doctrine_Task_GenerateYamlDb extends Doctrine_Task { public $description = 'Generates a Yaml schema file from an existing database', $requiredArguments = array('yaml_schema_path' => 'Specify the path to your yaml schema files.'), $optionalArguments = array(); public function execute() { Doctrine_Core::generateYamlFromDb($this->getArgument('yaml_schema_path')); $this->notify('Generate YAML schema successfully from database'); } }class Doctrine_Task_GenerateMigrationsDb extends Doctrine_Task { public $description = 'Generate migration classes for an existing database', $requiredArguments = array('migrations_path' => 'Specify the complete path to your migration classes folder.'), $optionalArguments = array(); public function execute() { try { $migrationsPath = $this->getArgument('migrations_path'); $yamlSchemaPath = $this->getArgument('yaml_schema_path'); $migration = new Doctrine_Migration($migrationsPath); $result1 = false; if ( ! count($migration->getMigrationClasses())) { $result1 = Doctrine_Core::generateMigrationsFromDb($migrationsPath); } $connections = array(); foreach (Doctrine_Manager::getInstance() as $connection) { $connections[] = $connection->getName(); } $changes = Doctrine_Core::generateMigrationsFromDiff($migrationsPath, $connections, $yamlSchemaPath); $numChanges = count($changes, true) - count($changes); $result = ($result1 || $numChanges) ? true:false; } catch (Exception $e) { $result = false; } if ( ! $result) { throw new Doctrine_Task_Exception('Could not generate migration classes from database'); } else { $this->notify('Generated migration classes successfully from database'); } } }class Doctrine_Task_Exception extends Doctrine_Exception { }class Doctrine_Task_GenerateMigrationsModels extends Doctrine_Task { public $description = 'Generate migration classes for an existing set of models', $requiredArguments = array('migrations_path' => 'Specify the path to your migration classes folder.', 'models_path' => 'Specify the path to your doctrine models folder.'), $optionalArguments = array(); public function execute() { Doctrine_Core::generateMigrationsFromModels($this->getArgument('migrations_path'), $this->getArgument('models_path')); $this->notify('Generated migration classes successfully from models'); } }abstract class Doctrine_Template extends Doctrine_Record_Abstract { protected $_invoker; protected $_plugin; protected $_options = array(); public function __construct(array $options = array()) { $this->_options = Doctrine_Lib::arrayDeepMerge($this->_options, $options); } public function setTable(Doctrine_Table $table) { $this->_table = $table; } public function getTable() { return $this->_table; } public function setInvoker(Doctrine_Record_Abstract $invoker) { $this->_invoker = $invoker; } public function getInvoker() { return $this->_invoker; } public function addChild(Doctrine_Template $template) { $this->_plugin->addChild($template); return $this; } public function getPlugin() { return $this->_plugin; } public function hasPlugin() { return isset($this->_plugin) ? true : false; } public function getOptions() { return $this->_options; } public function getOption($name, $default = null) { if (isset($this->_options[$name])) { return $this->_options[$name]; } return $default; } public function get($name) { throw new Doctrine_Exception("Templates doesn't support accessors."); } public function set($name, $value) { throw new Doctrine_Exception("Templates doesn't support accessors."); } public function setUp() { } public function setTableDefinition() { } }class Doctrine_Template_SoftDelete extends Doctrine_Template { protected $_options = array( 'name' => 'deleted_at', 'type' => 'timestamp', 'length' => null, 'options' => array( 'notnull' => false ), 'hardDelete' => false ); protected $_listener; public function setTableDefinition() { if ($this->_options['type'] == 'boolean') { $this->_options['length'] = 1; $this->_options['options'] = array('default' => false, 'notnull' => true); } $this->hasColumn($this->_options['name'], $this->_options['type'], $this->_options['length'], $this->_options['options']); $this->_listener = new Doctrine_Template_Listener_SoftDelete($this->_options); $this->addListener($this->_listener); } public function hardDelete($conn = null) { if ($conn === null) { $conn = $this->_table->getConnection(); } $this->_listener->hardDelete(true); $result = $this->_invoker->delete(); $this->_listener->hardDelete(false); return $result; } }class Doctrine_Template_Listener_SoftDelete extends Doctrine_Record_Listener { protected $_options = array(); public function __construct(array $options) { $this->_options = $options; } public function hardDelete($bool) { $this->_options['hardDelete'] = $bool; } public function preDelete(Doctrine_Event $event) { $name = $this->_options['name']; $invoker = $event->getInvoker(); if ($this->_options['type'] == 'timestamp') { $invoker->$name = date('Y-m-d H:i:s', time()); } else if ($this->_options['type'] == 'boolean') { $invoker->$name = true; } if ( ! $this->_options['hardDelete']) { $event->skipOperation(); } } public function postDelete(Doctrine_Event $event) { if ( ! $this->_options['hardDelete']) { $event->getInvoker()->save(); } } public function preDqlDelete(Doctrine_Event $event) { $params = $event->getParams(); $field = $params['alias'] . '.' . $this->_options['name']; $query = $event->getQuery(); if ( ! $query->contains($field)) { $query->from('')->update($params['component']['table']->getOption('name') . ' ' . $params['alias']); if ($this->_options['type'] == 'timestamp') { $query->set($field, '?', date('Y-m-d H:i:s', time())); $query->addWhere($field . ' IS NULL'); } else if ($this->_options['type'] == 'boolean') { $query->set($field, $query->getConnection()->convertBooleans(true)); $query->addWhere( $field . ' = ' . $query->getConnection()->convertBooleans(false) ); } } } public function preDqlSelect(Doctrine_Event $event) { $params = $event->getParams(); $field = $params['alias'] . '.' . $this->_options['name']; $query = $event->getQuery(); if (( ! $query->isSubquery() || ($query->isSubquery() && $query->contains(' ' . $params['alias'] . ' '))) && ! $query->contains($field)) { if ($this->_options['type'] == 'timestamp') { $query->addPendingJoinCondition($params['alias'], $field . ' IS NULL'); } else if ($this->_options['type'] == 'boolean') { $query->addPendingJoinCondition( $params['alias'], $field . ' = ' . $query->getConnection()->convertBooleans(false) ); } } } }class Doctrine_Template_Listener_Sluggable extends Doctrine_Record_Listener { protected $_options = array(); public function __construct(array $options) { $this->_options = $options; } public function preInsert(Doctrine_Event $event) { $record = $event->getInvoker(); $name = $record->getTable()->getFieldName($this->_options['name']); if ( ! $record->$name) { $record->$name = $this->buildSlugFromFields($record); } } public function preUpdate(Doctrine_Event $event) { if (false !== $this->_options['unique']) { $record = $event->getInvoker(); $name = $record->getTable()->getFieldName($this->_options['name']); if ( ! $record->$name || ( false !== $this->_options['canUpdate'] && ! array_key_exists($name, $record->getModified()) )) { $record->$name = $this->buildSlugFromFields($record); } else if ( ! empty($record->$name) && false !== $this->_options['canUpdate'] && array_key_exists($name, $record->getModified() )) { $record->$name = $this->buildSlugFromSlugField($record); } } } protected function buildSlugFromFields($record) { if (empty($this->_options['fields'])) { if (is_callable($this->_options['provider'])) { $value = call_user_func($this->_options['provider'], $record); } else if (method_exists($record, 'getUniqueSlug')) { $value = $record->getUniqueSlug($record); } else { $value = (string) $record; } } else { $value = ''; foreach ($this->_options['fields'] as $field) { $value .= $record->$field . ' '; } $value = substr($value, 0, -1); } if ($this->_options['unique'] === true) { return $this->getUniqueSlug($record, $value); } return call_user_func_array($this->_options['builder'], array($value, $record)); } protected function buildSlugFromSlugField($record) { $name = $record->getTable()->getFieldName($this->_options['name']); $value = $record->$name; if ($this->_options['unique'] === true) { return $this->getUniqueSlug($record, $value); } return call_user_func_array($this->_options['builder'], array($value, $record)); } public function getUniqueSlug($record, $slugFromFields) { if ($record->getTable()->getOption('inheritanceMap')) { $parentTable = $record->getTable()->getOption('parents'); $i = 0; $reflectionClass = new ReflectionClass($parentTable[$i]); while ($reflectionClass->isAbstract()) { $i++; $reflectionClass = new ReflectionClass($parentTable[$i]); } $table = Doctrine_Core::getTable($parentTable[$i]); } else { $table = $record->getTable(); } $name = $table->getFieldName($this->_options['name']); $proposal = call_user_func_array($this->_options['builder'], array($slugFromFields, $record)); $slug = $proposal; $whereString = 'r.' . $name . ' LIKE ?'; $whereParams = array($proposal.'%'); if ($record->exists()) { $identifier = $record->identifier(); $whereString .= ' AND r.' . implode(' != ? AND r.', $table->getIdentifierColumnNames()) . ' != ?'; $whereParams = array_merge($whereParams, array_values($identifier)); } foreach ($this->_options['uniqueBy'] as $uniqueBy) { if (is_null($record->$uniqueBy)) { $whereString .= ' AND r.'.$uniqueBy.' IS NULL'; } else { $whereString .= ' AND r.'.$uniqueBy.' = ?'; $value = $record->$uniqueBy; if ($value instanceof Doctrine_Record) { $value = current((array) $value->identifier()); } $whereParams[] = $value; } } $originalIndexBy = $table->getBoundQueryPart('indexBy'); $table->bindQueryPart('indexBy', null); $query = $table->createQuery('r') ->select('r.' . $name) ->where($whereString , $whereParams) ->setHydrationMode(Doctrine_Core::HYDRATE_ARRAY); if ($table->hasTemplate('Doctrine_Template_SoftDelete')) { $softDelete = $table->getTemplate('Doctrine_Template_SoftDelete'); if ($softDelete->getOption('type') == 'boolean') { $conn = $query->getConnection(); $query->addWhere( '(r.' . $softDelete->getOption('name') . ' = ' . $conn->convertBooleans(true) . ' OR r.' . $softDelete->getOption('name') . ' = ' . $conn->convertBooleans(false) . ')' ); } else { $query->addWhere('(r.' . $softDelete->getOption('name') . ' IS NOT NULL OR r.' . $softDelete->getOption('name') . ' IS NULL)'); } } $similarSlugResult = $query->execute(); $query->free(); $table->bindQueryPart('indexBy', $originalIndexBy); $similarSlugs = array(); foreach ($similarSlugResult as $key => $value) { $similarSlugs[$key] = strtolower($value[$name]); } $i = 1; while (in_array(strtolower($slug), $similarSlugs)) { $slug = call_user_func_array($this->_options['builder'], array($proposal.'-'.$i, $record)); $i++; } $length = $table->getFieldLength($this->_options['name']); if (strlen($slug) > $length) { $slug = substr($slug, 0, $length - (strlen($i) + 1)); $slug = $this->getUniqueSlug($record, $slug); } return $slug; } }class Doctrine_Template_Listener_Timestampable extends Doctrine_Record_Listener { protected $_options = array(); public function __construct(array $options) { $this->_options = $options; } public function preInsert(Doctrine_Event $event) { if ( ! $this->_options['created']['disabled']) { $createdName = $event->getInvoker()->getTable()->getFieldName($this->_options['created']['name']); $modified = $event->getInvoker()->getModified(); if ( ! isset($modified[$createdName])) { $event->getInvoker()->$createdName = $this->getTimestamp('created', $event->getInvoker()->getTable()->getConnection()); } } if ( ! $this->_options['updated']['disabled'] && $this->_options['updated']['onInsert']) { $updatedName = $event->getInvoker()->getTable()->getFieldName($this->_options['updated']['name']); $modified = $event->getInvoker()->getModified(); if ( ! isset($modified[$updatedName])) { $event->getInvoker()->$updatedName = $this->getTimestamp('updated', $event->getInvoker()->getTable()->getConnection()); } } } public function preUpdate(Doctrine_Event $event) { if ( ! $this->_options['updated']['disabled']) { $updatedName = $event->getInvoker()->getTable()->getFieldName($this->_options['updated']['name']); $modified = $event->getInvoker()->getModified(); if ( ! isset($modified[$updatedName])) { $event->getInvoker()->$updatedName = $this->getTimestamp('updated', $event->getInvoker()->getTable()->getConnection()); } } } public function preDqlUpdate(Doctrine_Event $event) { if ( ! $this->_options['updated']['disabled']) { $params = $event->getParams(); $updatedName = $event->getInvoker()->getTable()->getFieldName($this->_options['updated']['name']); $field = $params['alias'] . '.' . $updatedName; $query = $event->getQuery(); if ( ! $query->contains($field)) { $query->set($field, '?', $this->getTimestamp('updated', $event->getInvoker()->getTable()->getConnection())); } } } public function getTimestamp($type, $conn = null) { $options = $this->_options[$type]; if ($options['expression'] !== false && is_string($options['expression'])) { return new Doctrine_Expression($options['expression'], $conn); } else { if ($options['type'] == 'date') { return date($options['format'], time()); } else if ($options['type'] == 'timestamp') { return date($options['format'], time()); } else { return time(); } } } }class Doctrine_Template_Geographical extends Doctrine_Template { protected $_options = array('latitude' => array('name' => 'latitude', 'type' => 'double', 'size' => null, 'options' => array()), 'longitude' => array('name' => 'longitude', 'type' => 'double', 'size' => null, 'options' => array())); public function setTableDefinition() { $this->hasColumn($this->_options['latitude']['name'], $this->_options['latitude']['type'], $this->_options['latitude']['size'], $this->_options['latitude']['options']); $this->hasColumn($this->_options['longitude']['name'], $this->_options['longitude']['type'], $this->_options['longitude']['size'], $this->_options['longitude']['options']); } public function getDistanceQuery() { $invoker = $this->getInvoker(); $query = $invoker->getTable()->createQuery(); $rootAlias = $query->getRootAlias(); $latName = $this->_options['latitude']['name']; $longName = $this->_options['longitude']['name']; $query->addSelect($rootAlias . '.*'); $sql = "((ACOS(SIN(%s * PI() / 180) * SIN(" . $rootAlias . "." . $latName . " * PI() / 180) + COS(%s * PI() / 180) * COS(" . $rootAlias . "." . $latName . " * PI() / 180) * COS((%s - " . $rootAlias . "." . $longName . ") * PI() / 180)) * 180 / PI()) * 60 * %s) as %s"; $milesSql = sprintf($sql, $invoker->get($latName), $invoker->get($latName), $invoker->get($longName), '1.1515', 'miles'); $query->addSelect($milesSql); $kilometersSql = sprintf($sql, $invoker->get($latName), $invoker->get($latName), $invoker->get($longName), '1.1515 * 1.609344', 'kilometers'); $query->addSelect($kilometersSql); return $query; } public function getDistance(Doctrine_Record $record, $kilometers = false) { $query = $this->getDistanceQuery($kilometers); $conditions = array(); $values = array(); foreach ((array) $record->getTable()->getIdentifier() as $id) { $conditions[] = $query->getRootAlias() . '.' . $id . ' = ?'; $values[] = $record->get($id); } $where = implode(' AND ', $conditions); $query->addWhere($where, $values); $query->limit(1); $result = $query->execute()->getFirst(); if (isset($result['kilometers']) && $result['miles']) { return $kilometers ? $result->get('kilometers'):$result->get('miles'); } else { return 0; } } }class Doctrine_Template_I18n extends Doctrine_Template { public function __construct(array $options = array()) { parent::__construct($options); $this->_plugin = new Doctrine_I18n($this->_options); } public function setUp() { $this->_plugin->initialize($this->_table); } public function getI18n() { return $this->_plugin; } }class Doctrine_Template_Sluggable extends Doctrine_Template { protected $_options = array( 'name' => 'slug', 'alias' => null, 'type' => 'string', 'length' => 255, 'unique' => true, 'options' => array(), 'fields' => array(), 'uniqueBy' => array(), 'uniqueIndex' => true, 'canUpdate' => false, 'builder' => array('Doctrine_Inflector', 'urlize'), 'provider' => null, 'indexName' => null ); public function setTableDefinition() { $name = $this->_options['name']; if ($this->_options['alias']) { $name .= ' as ' . $this->_options['alias']; } if ($this->_options['indexName'] === null) { $this->_options['indexName'] = $this->getTable()->getTableName().'_sluggable'; } $this->hasColumn($name, $this->_options['type'], $this->_options['length'], $this->_options['options']); if ($this->_options['unique'] == true && $this->_options['uniqueIndex'] == true) { $indexFields = array($this->_options['name']); $indexFields = array_merge($indexFields, $this->_options['uniqueBy']); $this->index($this->_options['indexName'], array('fields' => $indexFields, 'type' => 'unique')); } $this->addListener(new Doctrine_Template_Listener_Sluggable($this->_options)); } }class Doctrine_Template_Timestampable extends Doctrine_Template { protected $_options = array('created' => array('name' => 'created_at', 'alias' => null, 'type' => 'timestamp', 'format' => 'Y-m-d H:i:s', 'disabled' => false, 'expression' => false, 'options' => array('notnull' => true)), 'updated' => array('name' => 'updated_at', 'alias' => null, 'type' => 'timestamp', 'format' => 'Y-m-d H:i:s', 'disabled' => false, 'expression' => false, 'onInsert' => true, 'options' => array('notnull' => true))); public function setTableDefinition() { if ( ! $this->_options['created']['disabled']) { $name = $this->_options['created']['name']; if ($this->_options['created']['alias']) { $name .= ' as ' . $this->_options['created']['alias']; } $this->hasColumn($name, $this->_options['created']['type'], null, $this->_options['created']['options']); } if ( ! $this->_options['updated']['disabled']) { $name = $this->_options['updated']['name']; if ($this->_options['updated']['alias']) { $name .= ' as ' . $this->_options['updated']['alias']; } $this->hasColumn($name, $this->_options['updated']['type'], null, $this->_options['updated']['options']); } $this->addListener(new Doctrine_Template_Listener_Timestampable($this->_options)); } }class Doctrine_Template_Searchable extends Doctrine_Template { public function __construct(array $options = array()) { parent::__construct($options); $this->_plugin = new Doctrine_Search($this->_options); } public function setUp() { $this->_plugin->initialize($this->_table); $this->addListener(new Doctrine_Search_Listener($this->_plugin)); } public function batchUpdateIndex($limit = null, $offset = null, $encoding = null) { $this->_plugin->batchUpdateIndex($limit, $offset, $encoding); } public function batchUpdateIndexTableProxy($limit = null, $offset = null, $encoding = null) { $this->batchUpdateIndex($limit, $offset, $encoding); } public function searchTableProxy($string, $query = null) { return $this->_plugin->search($string, $query); } } class Doctrine_Template_NestedSet extends Doctrine_Template { public function setUp() { $this->_table->setOption('treeOptions', $this->_options); $this->_table->setOption('treeImpl', 'NestedSet'); } public function setTableDefinition() { $this->_table->getTree()->setTableDefinition(); } }class Doctrine_Template_Versionable extends Doctrine_Template { protected $_options = array('version' => array('name' => 'version', 'alias' => null, 'type' => 'integer', 'length' => 8, 'options' => array()), 'generateRelations' => true, 'tableName' => false, 'generateFiles' => false, 'auditLog' => true, 'deleteVersions' => true, 'listener' => 'Doctrine_AuditLog_Listener'); public function __construct(array $options = array()) { parent::__construct($options); $this->_plugin = new Doctrine_AuditLog($this->_options); } public function setUp() { if ($this->_plugin->getOption('auditLog')) { $this->_plugin->initialize($this->_table); } $version = $this->_options['version']; $name = $version['name'] . (isset($version['alias']) ? ' as ' . $version['alias'] : ''); $this->hasColumn($name, $version['type'], $version['length'], $version['options']); $listener = $this->_options['listener']; $this->addListener(new $listener($this->_plugin)); } public function getAuditLog() { return $this->_plugin; } public function revert($version) { $auditLog = $this->_plugin; if ( ! $auditLog->getOption('auditLog')) { throw new Doctrine_Record_Exception('Audit log is turned off, no version history is recorded.'); } $data = $auditLog->getVersion($this->getInvoker(), $version); if ( ! isset($data[0])) { throw new Doctrine_Record_Exception('Version ' . $version . ' does not exist!'); } $this->getInvoker()->merge($data[0]); return $this->getInvoker(); } }class Doctrine_EventListener implements Doctrine_EventListener_Interface { public function preClose(Doctrine_Event $event) { } public function postClose(Doctrine_Event $event) { } public function onCollectionDelete(Doctrine_Collection $collection) { } public function onPreCollectionDelete(Doctrine_Collection $collection) { } public function onOpen(Doctrine_Connection $connection) { } public function preTransactionCommit(Doctrine_Event $event) { } public function postTransactionCommit(Doctrine_Event $event) { } public function preTransactionRollback(Doctrine_Event $event) { } public function postTransactionRollback(Doctrine_Event $event) { } public function preTransactionBegin(Doctrine_Event $event) { } public function postTransactionBegin(Doctrine_Event $event) { } public function preSavepointCommit(Doctrine_Event $event) { } public function postSavepointCommit(Doctrine_Event $event) { } public function preSavepointRollback(Doctrine_Event $event) { } public function postSavepointRollback(Doctrine_Event $event) { } public function preSavepointCreate(Doctrine_Event $event) { } public function postSavepointCreate(Doctrine_Event $event) { } public function postConnect(Doctrine_Event $event) { } public function preConnect(Doctrine_Event $event) { } public function preQuery(Doctrine_Event $event) { } public function postQuery(Doctrine_Event $event) { } public function prePrepare(Doctrine_Event $event) { } public function postPrepare(Doctrine_Event $event) { } public function preExec(Doctrine_Event $event) { } public function postExec(Doctrine_Event $event) { } public function preError(Doctrine_Event $event) { } public function postError(Doctrine_Event $event) { } public function preFetch(Doctrine_Event $event) { } public function postFetch(Doctrine_Event $event) { } public function preFetchAll(Doctrine_Event $event) { } public function postFetchAll(Doctrine_Event $event) { } public function preStmtExecute(Doctrine_Event $event) { } public function postStmtExecute(Doctrine_Event $event) { } } class Doctrine_Query extends Doctrine_Query_Abstract implements Countable { protected static $_keywords = array('ALL', 'AND', 'ANY', 'AS', 'ASC', 'AVG', 'BETWEEN', 'BIT_LENGTH', 'BY', 'CHARACTER_LENGTH', 'CHAR_LENGTH', 'CURRENT_DATE', 'CURRENT_TIME', 'CURRENT_TIMESTAMP', 'DELETE', 'DESC', 'DISTINCT', 'EMPTY', 'EXISTS', 'FALSE', 'FETCH', 'FROM', 'GROUP', 'HAVING', 'IN', 'INDEXBY', 'INNER', 'IS', 'JOIN', 'LEFT', 'LIKE', 'LOWER', 'MEMBER', 'MOD', 'NEW', 'NOT', 'NULL', 'OBJECT', 'OF', 'OR', 'ORDER', 'OUTER', 'POSITION', 'SELECT', 'SOME', 'TRIM', 'TRUE', 'UNKNOWN', 'UPDATE', 'WHERE'); protected $_subqueryAliases = array(); protected $_aggregateAliasMap = array(); protected $_pendingAggregates = array(); protected $_needsSubquery = false; protected $_isSubquery; protected $_neededTables = array(); protected $_pendingSubqueries = array(); protected $_pendingFields = array(); protected $_parsers = array(); protected $_pendingJoinConditions = array(); protected $_expressionMap = array(); protected $_sql; public static function create($conn = null, $class = null) { if ( ! $class) { $class = Doctrine_Manager::getInstance() ->getAttribute(Doctrine_Core::ATTR_QUERY_CLASS); } return new $class($conn); } protected function clear() { $this->_preQueried = false; $this->_pendingJoinConditions = array(); $this->_state = self::STATE_DIRTY; } public function reset() { $this->_subqueryAliases = array(); $this->_aggregateAliasMap = array(); $this->_pendingAggregates = array(); $this->_pendingSubqueries = array(); $this->_pendingFields = array(); $this->_neededTables = array(); $this->_expressionMap = array(); $this->_subqueryAliases = array(); $this->_needsSubquery = false; $this->_isLimitSubqueryUsed = false; } public function createSubquery() { $class = get_class($this); $obj = new $class(); $obj->copySubqueryInfo($this); $obj->isSubquery(true); return $obj; } public function addPendingJoinCondition($componentAlias, $joinCondition) { if ( ! isset($this->_pendingJoinConditions[$componentAlias])) { $this->_pendingJoinConditions[$componentAlias] = array(); } $this->_pendingJoinConditions[$componentAlias][] = $joinCondition; } public function fetchArray($params = array()) { return $this->execute($params, Doctrine_Core::HYDRATE_ARRAY); } public function fetchOne($params = array(), $hydrationMode = null) { $collection = $this->execute($params, $hydrationMode); if (is_scalar($collection)) { return $collection; } if (count($collection) === 0) { return false; } if ($collection instanceof Doctrine_Collection) { return $collection->getFirst(); } else if (is_array($collection)) { return array_shift($collection); } return false; } public function isSubquery($bool = null) { if ($bool === null) { return $this->_isSubquery; } $this->_isSubquery = (bool) $bool; return $this; } public function getSqlAggregateAlias($dqlAlias) { if (isset($this->_aggregateAliasMap[$dqlAlias])) { $this->_expressionMap[$dqlAlias][1] = true; return $this->_aggregateAliasMap[$dqlAlias]; } else if ( ! empty($this->_pendingAggregates)) { $this->processPendingAggregates(); return $this->getSqlAggregateAlias($dqlAlias); } else if( ! ($this->_conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_EXPR)){ return $dqlAlias; } else { throw new Doctrine_Query_Exception('Unknown aggregate alias: ' . $dqlAlias); } } public function hasSqlAggregateAlias($dqlAlias) { try { $this->getSqlAggregateAlias($dqlAlias); return true; } catch (Exception $e) { return false; } } public function adjustProcessedParam($index) { $params = $this->getInternalParams(); $first = array_slice($params, 0, $index); $last = array_slice($params, $index, count($params) - $index); array_splice($last, 0, 1, $last[0]); $this->_execParams = array_merge($first, $last); } public function getDqlPart($queryPart) { if ( ! isset($this->_dqlParts[$queryPart])) { throw new Doctrine_Query_Exception('Unknown query part ' . $queryPart); } return $this->_dqlParts[$queryPart]; } public function contains($dql) { return stripos($this->getDql(), $dql) === false ? false : true; } public function processPendingFields($componentAlias) { $tableAlias = $this->getSqlTableAlias($componentAlias); $table = $this->_queryComponents[$componentAlias]['table']; if ( ! isset($this->_pendingFields[$componentAlias])) { if ($this->_hydrator->getHydrationMode() != Doctrine_Core::HYDRATE_NONE) { if ( ! $this->_isSubquery && $componentAlias == $this->getRootAlias()) { throw new Doctrine_Query_Exception("The root class of the query (alias $componentAlias) " . " must have at least one field selected."); } } return; } if ( ! $this->isSubquery() && isset($this->_queryComponents[$componentAlias]['parent'])) { $parentAlias = $this->_queryComponents[$componentAlias]['parent']; if (is_string($parentAlias) && ! isset($this->_pendingFields[$parentAlias]) && $this->_hydrator->getHydrationMode() != Doctrine_Core::HYDRATE_NONE && $this->_hydrator->getHydrationMode() != Doctrine_Core::HYDRATE_SCALAR && $this->_hydrator->getHydrationMode() != Doctrine_Core::HYDRATE_SINGLE_SCALAR) { throw new Doctrine_Query_Exception("The left side of the join between " . "the aliases '$parentAlias' and '$componentAlias' must have at least" . " the primary key field(s) selected."); } } $fields = $this->_pendingFields[$componentAlias]; if (in_array('*', $fields)) { $fields = $table->getFieldNames(); } else { $driverClassName = $this->_hydrator->getHydratorDriverClassName(); if ( ! $this->_isSubquery && is_subclass_of($driverClassName, 'Doctrine_Hydrator_Graph')) { $fields = array_unique(array_merge((array) $table->getIdentifier(), $fields)); } } $sql = array(); foreach ($fields as $fieldName) { $columnName = $table->getColumnName($fieldName); if (($owner = $table->getColumnOwner($columnName)) !== null && $owner !== $table->getComponentName()) { $parent = $this->_conn->getTable($owner); $columnName = $parent->getColumnName($fieldName); $parentAlias = $this->getSqlTableAlias($componentAlias . '.' . $parent->getComponentName()); $sql[] = $this->_conn->quoteIdentifier($parentAlias) . '.' . $this->_conn->quoteIdentifier($columnName) . ' AS ' . $this->_conn->quoteIdentifier($tableAlias . '__' . $columnName); } else { $columnName = $table->getColumnName($fieldName); $sql[] = $this->_conn->quoteIdentifier($tableAlias) . '.' . $this->_conn->quoteIdentifier($columnName) . ' AS ' . $this->_conn->quoteIdentifier($tableAlias . '__' . $columnName); } } $this->_neededTables[] = $tableAlias; return implode(', ', $sql); } public function parseSelectField($field) { $terms = explode('.', $field); if (isset($terms[1])) { $componentAlias = $terms[0]; $field = $terms[1]; } else { reset($this->_queryComponents); $componentAlias = key($this->_queryComponents); $fields = $terms[0]; } $tableAlias = $this->getSqlTableAlias($componentAlias); $table = $this->_queryComponents[$componentAlias]['table']; if ($field === '*') { $sql = array(); foreach ($table->getColumnNames() as $field) { $sql[] = $this->parseSelectField($componentAlias . '.' . $field); } return implode(', ', $sql); } else { $name = $table->getColumnName($field); $this->_neededTables[] = $tableAlias; return $this->_conn->quoteIdentifier($tableAlias . '.' . $name) . ' AS ' . $this->_conn->quoteIdentifier($tableAlias . '__' . $name); } } public function getExpressionOwner($expr) { if (strtoupper(substr(trim($expr, '( '), 0, 6)) !== 'SELECT') { preg_match_all("/[a-z_][a-z0-9_]*\.[a-z_][a-z0-9_]*[\.[a-z0-9]+]*/i", $expr, $matches); $match = current($matches); if (isset($match[0])) { $terms = explode('.', $match[0]); return $terms[0]; } } return $this->getRootAlias(); } public function parseSelect($dql) { $refs = $this->_tokenizer->sqlExplode($dql, ','); $pos = strpos(trim($refs[0]), ' '); $first = substr($refs[0], 0, $pos); if ($first === 'DISTINCT') { $this->_sqlParts['distinct'] = true; $refs[0] = substr($refs[0], ++$pos); } $parsedComponents = array(); foreach ($refs as $reference) { $reference = trim($reference); if (empty($reference)) { continue; } $terms = $this->_tokenizer->sqlExplode($reference, ' '); $pos = strpos($terms[0], '('); if (count($terms) > 1 || $pos !== false) { $expression = array_shift($terms); $alias = array_pop($terms); if ( ! $alias) { $alias = substr($expression, 0, $pos); } if ($pos !== false && substr($expression, 0, 1) !== "'" && substr($expression, 0, $pos) == '') { $_queryComponents = $this->_queryComponents; reset($_queryComponents); $componentAlias = key($_queryComponents); } else { $componentAlias = $this->getExpressionOwner($expression); } $expression = $this->parseClause($expression); $tableAlias = $this->getSqlTableAlias($componentAlias); $index = count($this->_aggregateAliasMap); $sqlAlias = $this->_conn->quoteIdentifier($tableAlias . '__' . $index); $this->_sqlParts['select'][] = $expression . ' AS ' . $sqlAlias; $this->_aggregateAliasMap[$alias] = $sqlAlias; $this->_expressionMap[$alias][0] = $expression; $this->_queryComponents[$componentAlias]['agg'][$index] = $alias; $this->_neededTables[] = $tableAlias; } else { $e = explode('.', $terms[0]); if (isset($e[1])) { $componentAlias = $e[0]; $field = $e[1]; } else { reset($this->_queryComponents); $componentAlias = key($this->_queryComponents); $field = $e[0]; } $this->_pendingFields[$componentAlias][] = $field; } } } public function parseClause($clause) { $clause = $this->_conn->dataDict->parseBoolean(trim($clause)); if (is_numeric($clause)) { return $clause; } $terms = $this->_tokenizer->clauseExplode($clause, array(' ', '+', '-', '*', '/', '<', '>', '=', '>=', '<=', '&', '|')); $str = ''; foreach ($terms as $term) { $pos = strpos($term[0], '('); if ($pos !== false && substr($term[0], 0, 1) !== "'") { $name = substr($term[0], 0, $pos); $term[0] = $this->parseFunctionExpression($term[0]); } else { if (substr($term[0], 0, 1) !== "'" && substr($term[0], -1) !== "'") { if (strpos($term[0], '.') !== false) { if ( ! is_numeric($term[0])) { $e = explode('.', $term[0]); $field = array_pop($e); if ($this->getType() === Doctrine_Query::SELECT) { $componentAlias = implode('.', $e); if (empty($componentAlias)) { $componentAlias = $this->getRootAlias(); } $this->load($componentAlias); if ( ! isset($this->_queryComponents[$componentAlias])) { throw new Doctrine_Query_Exception('Unknown component alias ' . $componentAlias); } $table = $this->_queryComponents[$componentAlias]['table']; $def = $table->getDefinitionOf($field); $field = $table->getColumnName($field); if ( ! $def) { throw new Doctrine_Query_Exception('Unknown column ' . $field); } if (isset($def['owner'])) { $componentAlias = $componentAlias . '.' . $def['owner']; } $tableAlias = $this->getSqlTableAlias($componentAlias); $term[0] = $this->_conn->quoteIdentifier($tableAlias) . '.' . $this->_conn->quoteIdentifier($field); } else { $field = $this->getRoot()->getColumnName($field); $term[0] = $this->_conn->quoteIdentifier($field); } } } else { if ( ! empty($term[0]) && ! in_array(strtoupper($term[0]), self::$_keywords) && ! is_numeric($term[0]) && $term[0] !== '?' && substr($term[0], 0, 1) !== ':') { $componentAlias = $this->getRootAlias(); $found = false; if ($componentAlias !== false && $componentAlias !== null) { $table = $this->_queryComponents[$componentAlias]['table']; if ($table->hasField($term[0])) { $found = true; $def = $table->getDefinitionOf($term[0]); $term[0] = $table->getColumnName($term[0]); if (isset($def['owner'])) { $componentAlias = $componentAlias . '.' . $def['owner']; } $tableAlias = $this->getSqlTableAlias($componentAlias); if ($this->getType() === Doctrine_Query::SELECT) { $term[0] = $this->_conn->quoteIdentifier($tableAlias) . '.' . $this->_conn->quoteIdentifier($term[0]); } else { $term[0] = $this->_conn->quoteIdentifier($term[0]); } } else { $found = false; } } if ( ! $found) { $term[0] = $this->getSqlAggregateAlias($term[0]); } } } } } $str .= $term[0] . $term[1]; } return $str; } public function parseIdentifierReference($expr) { } public function parseFunctionExpression($expr) { $pos = strpos($expr, '('); $name = substr($expr, 0, $pos); if ($name === '') { return $this->parseSubquery($expr); } $argStr = substr($expr, ($pos + 1), -1); $args = array(); foreach ($this->_tokenizer->sqlExplode($argStr, ',') as $arg) { $args[] = $this->parseClause($arg); } try { $expr = call_user_func_array(array($this->_conn->expression, $name), $args); } catch (Doctrine_Expression_Exception $e) { throw new Doctrine_Query_Exception('Unknown function ' . $name . '.'); } return $expr; } public function parseSubquery($subquery) { $trimmed = trim($this->_tokenizer->bracketTrim($subquery)); if (substr($trimmed, 0, 4) == 'FROM' || substr($trimmed, 0, 6) == 'SELECT') { $q = $this->createSubquery()->parseDqlQuery($trimmed); $trimmed = $q->getSqlQuery(); $q->free(); } else if (substr($trimmed, 0, 4) == 'SQL:') { $trimmed = substr($trimmed, 4); } else { $e = $this->_tokenizer->sqlExplode($trimmed, ','); $value = array(); $index = false; foreach ($e as $part) { $value[] = $this->parseClause($part); } $trimmed = implode(', ', $value); } return '(' . $trimmed . ')'; } public function processPendingSubqueries() { foreach ($this->_pendingSubqueries as $value) { list($dql, $alias) = $value; $subquery = $this->createSubquery(); $sql = $subquery->parseDqlQuery($dql, false)->getQuery(); $subquery->free(); reset($this->_queryComponents); $componentAlias = key($this->_queryComponents); $tableAlias = $this->getSqlTableAlias($componentAlias); $sqlAlias = $tableAlias . '__' . count($this->_aggregateAliasMap); $this->_sqlParts['select'][] = '(' . $sql . ') AS ' . $this->_conn->quoteIdentifier($sqlAlias); $this->_aggregateAliasMap[$alias] = $sqlAlias; $this->_queryComponents[$componentAlias]['agg'][] = $alias; } $this->_pendingSubqueries = array(); } public function processPendingAggregates() { foreach ($this->_pendingAggregates as $aggregate) { list ($expression, $components, $alias) = $aggregate; $tableAliases = array(); if ( ! empty ($components)) { foreach ($components as $component) { if (is_numeric($component)) { continue; } $e = explode('.', $component); $field = array_pop($e); $componentAlias = implode('.', $e); if ( ! isset($this->_queryComponents[$componentAlias])) { throw new Doctrine_Query_Exception('Unknown component alias ' . $componentAlias); } $table = $this->_queryComponents[$componentAlias]['table']; $field = $table->getColumnName($field); if ( ! $table->hasColumn($field)) { throw new Doctrine_Query_Exception('Unknown column ' . $field); } $sqlTableAlias = $this->getSqlTableAlias($componentAlias); $tableAliases[$sqlTableAlias] = true; $identifier = $this->_conn->quoteIdentifier($sqlTableAlias . '.' . $field); $expression = str_replace($component, $identifier, $expression); } } if (count($tableAliases) !== 1) { $componentAlias = reset($this->_tableAliasMap); $tableAlias = key($this->_tableAliasMap); } $index = count($this->_aggregateAliasMap); $sqlAlias = $this->_conn->quoteIdentifier($tableAlias . '__' . $index); $this->_sqlParts['select'][] = $expression . ' AS ' . $sqlAlias; $this->_aggregateAliasMap[$alias] = $sqlAlias; $this->_expressionMap[$alias][0] = $expression; $this->_queryComponents[$componentAlias]['agg'][$index] = $alias; $this->_neededTables[] = $tableAlias; } $this->_pendingAggregates = array(); } protected function _buildSqlQueryBase() { switch ($this->_type) { case self::DELETE: $q = 'DELETE FROM '; break; case self::UPDATE: $q = 'UPDATE '; break; case self::SELECT: $distinct = ($this->_sqlParts['distinct']) ? 'DISTINCT ' : ''; $q = 'SELECT ' . $distinct . implode(', ', $this->_sqlParts['select']) . ' FROM '; break; } return $q; } protected function _buildSqlFromPart($ignorePending = false) { $q = ''; foreach ($this->_sqlParts['from'] as $k => $part) { $e = explode(' ', $part); if ($k === 0) { if ( ! $ignorePending && $this->_type == self::SELECT) { $alias = count($e) > 1 ? $this->getComponentAlias($e[1]) : null; $where = $this->_processPendingJoinConditions($alias); if ( ! empty($where)) { if (count($this->_sqlParts['where']) > 0) { $this->_sqlParts['where'][] = 'AND'; } if (substr($where, 0, 1) === '(' && substr($where, -1) === ')') { $this->_sqlParts['where'][] = $where; } else { $this->_sqlParts['where'][] = '(' . $where . ')'; } } } $q .= $part; continue; } if ( ! preg_match('/\bJOIN\b/i', $part) && ! isset($this->_pendingJoinConditions[$k])) { $q .= ', ' . $part; } else { if (substr($part, 0, 9) === 'LEFT JOIN') { $aliases = array_merge($this->_subqueryAliases, array_keys($this->_neededTables)); if ( ! in_array($e[3], $aliases) && ! in_array($e[2], $aliases) && ! empty($this->_pendingFields)) { continue; } } if ( ! $ignorePending && isset($this->_pendingJoinConditions[$k])) { if (strpos($part, ' ON ') !== false) { $part .= ' AND '; } else { $part .= ' ON '; } $part .= $this->_processPendingJoinConditions($k); } $componentAlias = $this->getComponentAlias($e[3]); $string = $this->getInheritanceCondition($componentAlias); if ($string) { $part = $part . ' AND ' . $string; } $q .= ' ' . $part; } $this->_sqlParts['from'][$k] = $part; } return $q; } protected function _processPendingJoinConditions($alias) { $parts = array(); if ($alias !== null && isset($this->_pendingJoinConditions[$alias])) { $parser = new Doctrine_Query_JoinCondition($this, $this->_tokenizer); foreach ($this->_pendingJoinConditions[$alias] as $joinCondition) { $parts[] = $parser->parse($joinCondition); } } return (count($parts) > 0 ? '(' . implode(') AND (', $parts) . ')' : ''); } public function getSqlQuery($params = array(), $limitSubquery = true) { $this->_params['exec'] = $params; $this->_execParams = $this->getFlattenedParams(); if ($this->_state !== self::STATE_DIRTY) { $this->fixArrayParameterValues($this->getInternalParams()); return $this->_sql; } return $this->buildSqlQuery($limitSubquery); } public function buildSqlQuery($limitSubquery = true) { if ( ! $this->isSubquery()) { $this->_queryComponents = array(); $this->_pendingAggregates = array(); $this->_aggregateAliasMap = array(); } $this->reset(); $this->_preQuery(); foreach ($this->_dqlParts as $queryPartName => $queryParts) { if ($queryPartName == 'from') { $queryComponentsBefore = $this->getQueryComponents(); } if ($queryPartName != 'forUpdate') { $this->_processDqlQueryPart($queryPartName, $queryParts); } if ($queryPartName == 'from') { $queryComponentsAfter = $this->getQueryComponents(); $diffQueryComponents = array_diff_key($queryComponentsAfter, $queryComponentsBefore); $this->_rootAlias = key($diffQueryComponents); } } $this->_state = self::STATE_CLEAN; if (empty($this->_sqlParts['from'])) { return false; } $needsSubQuery = false; $subquery = ''; $map = $this->getRootDeclaration(); $table = $map['table']; $rootAlias = $this->getRootAlias(); if ( ! empty($this->_sqlParts['limit']) && $this->_needsSubquery && $table->getAttribute(Doctrine_Core::ATTR_QUERY_LIMIT) == Doctrine_Core::LIMIT_RECORDS) { if(!$this->_sqlParts['distinct']) { $this->_isLimitSubqueryUsed = true; $needsSubQuery = true; } else { foreach( array_keys($this->_pendingFields) as $alias){ if($alias == $this->getRootAlias()){ continue; } if(isset($this->_queryComponents[$alias]['relation']) && $this->_queryComponents[$alias]['relation']->getType() == Doctrine_Relation::ONE){ continue; } $this->_isLimitSubqueryUsed = true; $needsSubQuery = true; } } } $sql = array(); if ( ! empty($this->_pendingFields)) { foreach ($this->_queryComponents as $alias => $map) { $fieldSql = $this->processPendingFields($alias); if ( ! empty($fieldSql)) { $sql[] = $fieldSql; } } } if ( ! empty($sql)) { array_unshift($this->_sqlParts['select'], implode(', ', $sql)); } $this->_pendingFields = array(); $q = $this->_buildSqlQueryBase(); $q .= $this->_buildSqlFromPart(); if ( ! empty($this->_sqlParts['set'])) { $q .= ' SET ' . implode(', ', $this->_sqlParts['set']); } $string = $this->getInheritanceCondition($this->getRootAlias()); if ( ! empty($string)) { if (count($this->_sqlParts['where']) > 0) { $this->_sqlParts['where'][] = 'AND'; } if (substr($string, 0, 1) === '(' && substr($string, -1) === ')') { $this->_sqlParts['where'][] = $string; } else { $this->_sqlParts['where'][] = '(' . $string . ')'; } } $modifyLimit = true; $limitSubquerySql = ''; if ( ( ! empty($this->_sqlParts['limit']) || ! empty($this->_sqlParts['offset'])) && $needsSubQuery && $limitSubquery) { $subquery = $this->getLimitSubquery(); $idColumnName = $table->getColumnName($table->getIdentifier()); switch (strtolower($this->_conn->getDriverName())) { case 'mysql': $this->useQueryCache(false); $list = $this->_conn->execute($subquery, $this->_execParams)->fetchAll(Doctrine_Core::FETCH_COLUMN); $subquery = implode(', ', array_map(array($this->_conn, 'quote'), $list)); break; case 'pgsql': $subqueryAlias = $this->_conn->quoteIdentifier('doctrine_subquery_alias'); $subquery = 'SELECT ' . $subqueryAlias . '.' . $this->_conn->quoteIdentifier($idColumnName) . ' FROM (' . $subquery . ') AS ' . $subqueryAlias; break; } $field = $this->getSqlTableAlias($rootAlias) . '.' . $idColumnName; $limitSubquerySql = $this->_conn->quoteIdentifier($field) . (( ! empty($subquery)) ? ' IN (' . $subquery . ')' : ' IS NULL') . ((count($this->_sqlParts['where']) > 0) ? ' AND ' : ''); $modifyLimit = false; } $emptyWhere = empty($this->_sqlParts['where']); if ( ! ($emptyWhere && $limitSubquerySql == '')) { $where = implode(' ', $this->_sqlParts['where']); $where = ($where == '' || (substr($where, 0, 1) === '(' && substr($where, -1) === ')')) ? $where : '(' . $where . ')'; $q .= ' WHERE ' . $limitSubquerySql . $where; } foreach ($this->_sqlParts['orderby'] as $k => $orderBy) { $e = explode(', ', $orderBy); unset($this->_sqlParts['orderby'][$k]); foreach ($e as $v) { $this->_sqlParts['orderby'][] = $v; } } if ($this->_type === self::SELECT) { foreach ($this->_queryComponents as $alias => $map) { $sqlAlias = $this->getSqlTableAlias($alias); if (isset($map['relation'])) { $orderBy = $map['relation']->getOrderByStatement($sqlAlias, true); if ($orderBy == $map['relation']['orderBy']) { if (isset($map['ref'])) { $orderBy = $map['relation']['refTable']->processOrderBy($sqlAlias, $map['relation']['orderBy'], true); } else { $orderBy = null; } } } else { $orderBy = $map['table']->getOrderByStatement($sqlAlias, true); } if ($orderBy) { $e = explode(',', $orderBy); $e = array_map('trim', $e); foreach ($e as $v) { if ( ! in_array($v, $this->_sqlParts['orderby'])) { $this->_sqlParts['orderby'][] = $v; } } } } } $q .= ( ! empty($this->_sqlParts['groupby'])) ? ' GROUP BY ' . implode(', ', $this->_sqlParts['groupby']) : ''; $q .= ( ! empty($this->_sqlParts['having'])) ? ' HAVING ' . implode(' AND ', $this->_sqlParts['having']): ''; $q .= ( ! empty($this->_sqlParts['orderby'])) ? ' ORDER BY ' . implode(', ', $this->_sqlParts['orderby']) : ''; if ($modifyLimit) { $q = $this->_conn->modifyLimitQuery($q, $this->_sqlParts['limit'], $this->_sqlParts['offset']); } $q .= $this->_sqlParts['forUpdate'] === true ? ' FOR UPDATE ' : ''; $this->_sql = $q; $this->clear(); return $q; } public function getLimitSubquery() { $map = reset($this->_queryComponents); $table = $map['table']; $componentAlias = key($this->_queryComponents); $alias = $this->getSqlTableAlias($componentAlias); $primaryKey = $alias . '.' . $table->getColumnName($table->getIdentifier()); $driverName = $this->_conn->getAttribute(Doctrine_Core::ATTR_DRIVER_NAME); if (($driverName == 'oracle' || $driverName == 'oci') && $this->_isOrderedByJoinedColumn()) { $subquery = 'SELECT '; } else { $subquery = 'SELECT DISTINCT '; } $subquery .= $this->_conn->quoteIdentifier($primaryKey); if ($driverName == 'pgsql' || $driverName == 'oracle' || $driverName == 'icingaOracle' || $driverName == 'oci' || $driverName == 'mssql' || $driverName == 'odbc') { foreach ($this->_sqlParts['orderby'] as $part) { $e = $this->_tokenizer->bracketExplode($part, ' '); foreach ($e as $f) { if ($f == 0 || $f % 2 == 0) { $partOriginal = str_replace(',', '', trim($f)); $callback = create_function('$e', 'return trim($e, \'[]`"\');'); $part = trim(implode('.', array_map($callback, explode('.', $partOriginal)))); if (strpos($part, '.') === false) { continue; } if (strpos($part, '(') !== false) { continue; } if ($part !== $primaryKey) { $subquery .= ', ' . $partOriginal; } } } } } $orderby = $this->_sqlParts['orderby']; $having = $this->_sqlParts['having']; if ($driverName == 'mysql' || $driverName == 'pgsql') { foreach ($this->_expressionMap as $dqlAlias => $expr) { if (isset($expr[1])) { $subquery .= ', ' . $expr[0] . ' AS ' . $this->_aggregateAliasMap[$dqlAlias]; } } } else { foreach ($this->_expressionMap as $dqlAlias => $expr) { if (isset($expr[1])) { foreach ($having as $k => $v) { $having[$k] = str_replace($this->_aggregateAliasMap[$dqlAlias], $expr[0], $v); } foreach ($orderby as $k => $v) { $e = explode(' ', $v); if ($e[0] == $this->_aggregateAliasMap[$dqlAlias]) { $orderby[$k] = $expr[0]; } } } } } preg_match_all('/`[a-z0-9_]+`\.`[a-z0-9_]+`/i', implode(' ', $having), $matches, PREG_PATTERN_ORDER); if (count($matches[0]) > 0) { $subquery .= ', ' . implode(', ', array_unique($matches[0])); } $subquery .= ' FROM'; foreach ($this->_sqlParts['from'] as $part) { if (substr($part, 0, 9) === 'LEFT JOIN') { $e = explode(' ', $part); if (empty($this->_sqlParts['orderby']) && empty($this->_sqlParts['where']) && empty($this->_sqlParts['having']) && empty($this->_sqlParts['groupby'])) { continue; } } $subquery .= ' ' . $part; } $subquery .= ( ! empty($this->_sqlParts['where']))? ' WHERE ' . implode(' ', $this->_sqlParts['where']) : ''; $subquery .= ( ! empty($this->_sqlParts['groupby']))? ' GROUP BY ' . implode(', ', $this->_sqlParts['groupby']) : ''; $subquery .= ( ! empty($having))? ' HAVING ' . implode(' AND ', $having) : ''; $subquery .= ( ! empty($orderby))? ' ORDER BY ' . implode(', ', $orderby) : ''; if (($driverName == 'oracle' || $driverName == 'oci') && $this->_isOrderedByJoinedColumn()) { $quotedIdentifierColumnName = $this->_conn->quoteIdentifier($table->getColumnName($table->getIdentifier())); $subquery = 'SELECT doctrine_subquery_alias.' . $quotedIdentifierColumnName . ' FROM (' . $subquery . ') doctrine_subquery_alias' . ' GROUP BY doctrine_subquery_alias.' . $quotedIdentifierColumnName . ' ORDER BY MIN(ROWNUM)'; } $subquery = $this->_conn->modifyLimitSubquery($table, $subquery, $this->_sqlParts['limit'], $this->_sqlParts['offset']); $parts = $this->_tokenizer->quoteExplode($subquery, ' ', "'", "'"); foreach ($parts as $k => $part) { if (strpos($part, ' ') !== false) { continue; } $part = str_replace(array('"', "'", '`'), "", $part); if ($this->hasSqlTableAlias($part)) { $parts[$k] = $this->_conn->quoteIdentifier($this->generateNewSqlTableAlias($part)); continue; } if (strpos($part, '.') === false) { continue; } preg_match_all("/[a-zA-Z0-9_]+\.[a-z0-9_]+/i", $part, $m); foreach ($m[0] as $match) { $e = explode('.', $match); $e2 = array(); foreach ($e as $k2 => $v2) { $e2[$k2] = $this->_conn->quoteIdentifier($v2); } $match = implode('.', $e2); $e[0] = $this->generateNewSqlTableAlias($e[0]); foreach ($e as $k2 => $v2) { $e[$k2] = $this->_conn->quoteIdentifier($v2); } $replace = implode('.' , $e); $parts[$k] = str_replace($match, $replace, $parts[$k]); } } if ($driverName == 'mysql' || $driverName == 'pgsql') { foreach ($parts as $k => $part) { if (strpos($part, "'") !== false) { continue; } if (strpos($part, '__') == false) { continue; } preg_match_all("/[a-zA-Z0-9_]+\_\_[a-z0-9_]+/i", $part, $m); foreach ($m[0] as $match) { $e = explode('__', $match); $e[0] = $this->generateNewSqlTableAlias($e[0]); $parts[$k] = str_replace($match, implode('__', $e), $parts[$k]); } } } $subquery = implode(' ', $parts); return $subquery; } private function _isOrderedByJoinedColumn() { if ( ! $this->_queryComponents) { throw new Doctrine_Query_Exception("The query is in an invalid state for this " . "operation. It must have been fully parsed first."); } $componentAlias = key($this->_queryComponents); $mainTableAlias = $this->getSqlTableAlias($componentAlias); foreach ($this->_sqlParts['orderby'] as $part) { $part = trim($part); $e = $this->_tokenizer->bracketExplode($part, ' '); $part = trim($e[0]); if (strpos($part, '.') === false) { continue; } list($tableAlias, $columnName) = explode('.', $part); if ($tableAlias != $mainTableAlias) { return true; } } return false; } public function parseDqlQuery($query, $clear = true) { if ($clear) { $this->clear(); } $query = trim($query); $query = str_replace("\r", "\n", str_replace("\r\n", "\n", $query)); $query = str_replace("\n", ' ', $query); $parts = $this->_tokenizer->tokenizeQuery($query); foreach ($parts as $partName => $subParts) { $subParts = trim($subParts); $partName = strtolower($partName); switch ($partName) { case 'create': $this->_type = self::CREATE; break; case 'insert': $this->_type = self::INSERT; break; case 'delete': $this->_type = self::DELETE; break; case 'select': $this->_type = self::SELECT; $this->_addDqlQueryPart($partName, $subParts); break; case 'update': $this->_type = self::UPDATE; $partName = 'from'; case 'from': $this->_addDqlQueryPart($partName, $subParts); break; case 'set': $this->_addDqlQueryPart($partName, $subParts, true); break; case 'group': case 'order': $partName .= 'by'; case 'where': case 'having': case 'limit': case 'offset': $this->_addDqlQueryPart($partName, $subParts); break; } } return $this; } public function load($path, $loadFields = true) { if (isset($this->_queryComponents[$path])) { return $this->_queryComponents[$path]; } $e = $this->_tokenizer->quoteExplode($path, ' INDEXBY '); $mapWith = null; if (count($e) > 1) { $mapWith = trim($e[1]); $path = $e[0]; } $e = explode(' ON ', str_ireplace(' on ', ' ON ', $path)); $joinCondition = ''; if (count($e) > 1) { $joinCondition = substr($path, strlen($e[0]) + 4, strlen($e[1])); $path = substr($path, 0, strlen($e[0])); $overrideJoin = true; } else { $e = explode(' WITH ', str_ireplace(' with ', ' WITH ', $path)); if (count($e) > 1) { $joinCondition = substr($path, strlen($e[0]) + 6, strlen($e[1])); $path = substr($path, 0, strlen($e[0])); } $overrideJoin = false; } $tmp = explode(' ', $path); $componentAlias = $originalAlias = (count($tmp) > 1) ? end($tmp) : null; $e = preg_split("/[.:]/", $tmp[0], -1); $fullPath = $tmp[0]; $prevPath = ''; $fullLength = strlen($fullPath); if (isset($this->_queryComponents[$e[0]])) { $table = $this->_queryComponents[$e[0]]['table']; $componentAlias = $e[0]; $prevPath = $parent = array_shift($e); } foreach ($e as $key => $name) { $length = strlen($prevPath); $prevPath = ($prevPath) ? $prevPath . '.' . $name : $name; $delimeter = substr($fullPath, $length, 1); if (strlen($prevPath) === $fullLength && isset($originalAlias)) { $componentAlias = $originalAlias; } else { $componentAlias = $prevPath; } if (isset($this->_queryComponents[$componentAlias])) { throw new Doctrine_Query_Exception("Duplicate alias '$componentAlias' in query."); } if ( ! isset($table)) { $table = $this->loadRoot($name, $componentAlias); } else { $join = ($delimeter == ':') ? 'INNER JOIN ' : 'LEFT JOIN '; $relation = $table->getRelation($name); $localTable = $table; $table = $relation->getTable(); $this->_queryComponents[$componentAlias] = array('table' => $table, 'parent' => $parent, 'relation' => $relation, 'map' => null); if ( ! $relation->isOneToOne()) { $this->_needsSubquery = true; } $localAlias = $this->getSqlTableAlias($parent, $localTable->getTableName()); $foreignAlias = $this->getSqlTableAlias($componentAlias, $relation->getTable()->getTableName()); $foreignSql = $this->_conn->quoteIdentifier($relation->getTable()->getTableName()) . ' ' . $this->_conn->quoteIdentifier($foreignAlias); $map = $relation->getTable()->inheritanceMap; if ( ! $loadFields || ! empty($map) || $joinCondition) { $this->_subqueryAliases[] = $foreignAlias; } if ($relation instanceof Doctrine_Relation_Association) { $asf = $relation->getAssociationTable(); $assocTableName = $asf->getTableName(); if ( ! $loadFields || ! empty($map) || $joinCondition) { $this->_subqueryAliases[] = $assocTableName; } $assocPath = $prevPath . '.' . $asf->getComponentName() . ' ' . $componentAlias; $this->_queryComponents[$assocPath] = array( 'parent' => $prevPath, 'relation' => $relation, 'table' => $asf, 'ref' => true); $assocAlias = $this->getSqlTableAlias($assocPath, $asf->getTableName()); $queryPart = $join . $this->_conn->quoteIdentifier($assocTableName) . ' ' . $this->_conn->quoteIdentifier($assocAlias); $ref = $relation->__getIdField(); $queryPart .= ' ON (' . $this->_conn->quoteIdentifier($localAlias . '.' . $localTable->getColumnName($ref ? $ref : $localTable->getIdentifier())) . ' = ' . $this->_conn->quoteIdentifier($assocAlias . '.' . $relation->getLocalRefColumnName()); if ($relation->isEqual()) { $queryPart .= ' OR ' . $this->_conn->quoteIdentifier($localAlias . '.' . $table->getColumnName($table->getIdentifier())) . ' = ' . $this->_conn->quoteIdentifier($assocAlias . '.' . $relation->getForeignRefColumnName()); } $queryPart .= ')'; $this->_sqlParts['from'][] = $queryPart; $queryPart = $join . $foreignSql; if ( ! $overrideJoin) { $queryPart .= $this->buildAssociativeRelationSql($relation, $assocAlias, $foreignAlias, $localAlias); } } else { $queryPart = $this->buildSimpleRelationSql($relation, $foreignAlias, $localAlias, $overrideJoin, $join); } $queryPart .= $this->buildInheritanceJoinSql($table->getComponentName(), $componentAlias); $this->_sqlParts['from'][$componentAlias] = $queryPart; if ( ! empty($joinCondition)) { $this->addPendingJoinCondition($componentAlias, $joinCondition); } } if ($loadFields) { $restoreState = false; if ($loadFields && empty($this->_dqlParts['select'])) { $this->_pendingFields[$componentAlias] = array('*'); } } $parent = $prevPath; } $table = $this->_queryComponents[$componentAlias]['table']; return $this->buildIndexBy($componentAlias, $mapWith); } protected function buildSimpleRelationSql(Doctrine_Relation $relation, $foreignAlias, $localAlias, $overrideJoin, $join) { $queryPart = $join . $this->_conn->quoteIdentifier($relation->getTable()->getTableName()) . ' ' . $this->_conn->quoteIdentifier($foreignAlias); if ( ! $overrideJoin) { $queryPart .= ' ON ' . $this->_conn->quoteIdentifier($localAlias . '.' . $relation->getLocalColumnName()) . ' = ' . $this->_conn->quoteIdentifier($foreignAlias . '.' . $relation->getForeignColumnName()); } return $queryPart; } protected function buildIndexBy($componentAlias, $mapWith = null) { $table = $this->_queryComponents[$componentAlias]['table']; $indexBy = null; $column = false; if (isset($mapWith)) { $terms = explode('.', $mapWith); if (count($terms) == 1) { $indexBy = $terms[0]; } else if (count($terms) == 2) { $column = true; $indexBy = $terms[1]; } } else if ($table->getBoundQueryPart('indexBy') !== null) { $indexBy = $table->getBoundQueryPart('indexBy'); } if ($indexBy !== null) { if ( $column && ! $table->hasColumn($table->getColumnName($indexBy))) { throw new Doctrine_Query_Exception("Couldn't use key mapping. Column " . $indexBy . " does not exist."); } $this->_queryComponents[$componentAlias]['map'] = $indexBy; } return $this->_queryComponents[$componentAlias]; } protected function buildAssociativeRelationSql(Doctrine_Relation $relation, $assocAlias, $foreignAlias, $localAlias) { $table = $relation->getTable(); $localIdentifier = null; $queryPart = ' ON '; if ($relation->isEqual()) { $queryPart .= '('; } $foreignField = $relation->__getForeignId(); if(!$foreignField) $localIdentifier = $table->getColumnName($table->getIdentifier()); else $localIdentifier = $foreignField; $queryPart .= $this->_conn->quoteIdentifier($foreignAlias . '.' . $localIdentifier) . ' = ' . $this->_conn->quoteIdentifier($assocAlias . '.' . $relation->getForeignRefColumnName()); if ($relation->isEqual()) { $queryPart .= ' OR ' . $this->_conn->quoteIdentifier($foreignAlias . '.' . $localIdentifier) . ' = ' . $this->_conn->quoteIdentifier($assocAlias . '.' . $relation->getLocalRefColumnName()) . ') AND ' . $this->_conn->quoteIdentifier($foreignAlias . '.' . $localIdentifier) . ' != ' . $this->_conn->quoteIdentifier($localAlias . '.' . $localIdentifier); } return $queryPart; } public function loadRoot($name, $componentAlias) { $manager = Doctrine_Manager::getInstance(); if ( ! $this->_passedConn && $manager->hasConnectionForComponent($name)) { $this->_conn = $manager->getConnectionForComponent($name); } $table = $this->_conn->getTable($name); $tableName = $table->getTableName(); $tableAlias = $this->getSqlTableAlias($componentAlias, $tableName); $queryPart = $this->_conn->quoteIdentifier($tableName); if ($this->_type === self::SELECT) { $queryPart .= ' ' . $this->_conn->quoteIdentifier($tableAlias); } $this->_tableAliasMap[$tableAlias] = $componentAlias; $queryPart .= $this->buildInheritanceJoinSql($name, $componentAlias); $this->_sqlParts['from'][] = $queryPart; $this->_queryComponents[$componentAlias] = array('table' => $table, 'map' => null); return $table; } public function buildInheritanceJoinSql($name, $componentAlias) { $manager = Doctrine_Manager::getInstance(); if ( ! $this->_passedConn && $manager->hasConnectionForComponent($name)) { $this->_conn = $manager->getConnectionForComponent($name); } $table = $this->_conn->getTable($name); $tableName = $table->getTableName(); $tableAlias = $this->getSqlTableAlias($componentAlias, $tableName); $queryPart = ''; foreach ($table->getOption('joinedParents') as $parent) { $parentTable = $this->_conn->getTable($parent); $parentAlias = $componentAlias . '.' . $parent; $parentTableAlias = $this->getSqlTableAlias($parentAlias, $parentTable->getTableName()); $queryPart .= ' LEFT JOIN ' . $this->_conn->quoteIdentifier($parentTable->getTableName()) . ' ' . $this->_conn->quoteIdentifier($parentTableAlias) . ' ON '; foreach ((array) $table->getIdentifier() as $identifier) { $column = $table->getColumnName($identifier); $queryPart .= $this->_conn->quoteIdentifier($tableAlias) . '.' . $this->_conn->quoteIdentifier($column) . ' = ' . $this->_conn->quoteIdentifier($parentTableAlias) . '.' . $this->_conn->quoteIdentifier($column); } } return $queryPart; } public function getCountSqlQuery() { $this->getSqlQuery(array(), false); $where = $this->_sqlParts['where']; $having = $this->_sqlParts['having']; $groupby = $this->_sqlParts['groupby']; $rootAlias = $this->getRootAlias(); $tableAlias = $this->getSqlTableAlias($rootAlias); $q = 'SELECT COUNT(*) AS ' . $this->_conn->quoteIdentifier('num_results') . ' FROM '; $from = $this->_buildSqlFromPart(true); $where = ( ! empty($where)) ? ' WHERE ' . implode(' ', $where) : ''; $groupby = ( ! empty($groupby)) ? ' GROUP BY ' . implode(', ', $groupby) : ''; $having = ( ! empty($having)) ? ' HAVING ' . implode(' AND ', $having) : ''; if (count($this->_queryComponents) == 1 && empty($having)) { $q .= $from . $where . $groupby . $having; } else { $ta = $this->_conn->quoteIdentifier($tableAlias); $map = $this->getRootDeclaration(); $idColumnNames = $map['table']->getIdentifierColumnNames(); $pkFields = $ta . '.' . implode(', ' . $ta . '.', $this->_conn->quoteMultipleIdentifier($idColumnNames)); $selectFields = $pkFields; if ( ! empty($having)) { foreach ($this->_sqlParts['select'] as $field) { if (strpos($field, '(') !== false) { $selectFields .= ', ' . $field; } } preg_match_all('/`[a-z0-9_]+`\.`[a-z0-9_]+`/i', $having, $matches, PREG_PATTERN_ORDER); if (count($matches[0]) > 0) { $selectFields .= ', ' . implode(', ', array_unique($matches[0])); } } if (empty($groupby)) { $groupby = ' GROUP BY ' . $pkFields; } $q .= '(SELECT ' . $selectFields . ' FROM ' . $from . $where . $groupby . $having . ') ' . $this->_conn->quoteIdentifier('dctrn_count_query'); } return $q; } public function count($params = array()) { $q = $this->getCountSqlQuery(); $params = $this->getCountQueryParams($params); $params = $this->_conn->convertBooleans($params); if ($this->_resultCache) { $conn = $this->getConnection(); $cacheDriver = $this->getResultCacheDriver(); $hash = $this->getResultCacheHash($params).'_count'; $cached = ($this->_expireResultCache) ? false : $cacheDriver->fetch($hash); if ($cached === false) { $results = $this->getConnection()->fetchAll($q, $params); $cacheDriver->save($hash, serialize($results), $this->getResultCacheLifeSpan()); } else { $results = unserialize($cached); } } else { $results = $this->getConnection()->fetchAll($q, $params); } if (count($results) > 1) { $count = count($results); } else { if (isset($results[0])) { $results[0] = array_change_key_case($results[0], CASE_LOWER); $count = $results[0]['num_results']; } else { $count = 0; } } return (int) $count; } public function query($query, $params = array(), $hydrationMode = null) { $this->parseDqlQuery($query); return $this->execute($params, $hydrationMode); } public function copy(Doctrine_Query $query = null) { if ( ! $query) { $query = $this; } $new = clone $query; return $new; } public function __clone() { $this->_parsers = array(); $this->_hydrator = clone $this->_hydrator; if ($this->isSubquery()) { $this->_killReference('_params'); $this->_killReference('_tableAliasMap'); $this->_killReference('_queryComponents'); } } protected function _killReference($key) { $tmp = $this->$key; unset($this->$key); $this->$key = $tmp; } public function free() { $this->reset(); $this->_parsers = array(); $this->_dqlParts = array(); } } abstract class Doctrine_Parser { abstract public function loadData($array); abstract public function dumpData($array, $path = null, $charset = null); static public function getParser($type) { $class = 'Doctrine_Parser_'.ucfirst($type); return new $class; } static public function load($path, $type = 'xml') { $parser = self::getParser($type); return (array) $parser->loadData($path); } static public function dump($array, $type = 'xml', $path = null, $charset = null) { $parser = self::getParser($type); return $parser->dumpData($array, $path, $charset); } public function doLoad($path) { ob_start(); if ( ! file_exists($path)) { $contents = $path; $path = sys_get_temp_dir() . DIRECTORY_SEPARATOR . 'dparser_' . microtime(); file_put_contents($path, $contents); } include($path); $contents = ob_get_clean(); return $contents; } public function doDump($data, $path = null) { if ($path !== null) { return file_put_contents($path, $data); } else { return $data; } } } class Doctrine_Parser_Yml extends Doctrine_Parser { public function dumpData($array, $path = null, $charset = null) { try { $data = sfYaml::dump($array, 6); return $this->doDump($data, $path); } catch(InvalidArgumentException $e) { $rethrowed_exception = new Doctrine_Parser_Exception($e->getMessage(), $e->getCode()); throw $rethrowed_exception; } } public function loadData($path) { try { $contents = $this->doLoad($path); $array = sfYaml::load($contents); return $array; } catch(InvalidArgumentException $e) { $rethrowed_exception = new Doctrine_Parser_Exception($e->getMessage(), $e->getCode()); throw $rethrowed_exception; } } } class Doctrine_Parser_Json extends Doctrine_Parser { public function dumpData($array, $path = null, $charset = null) { $data = json_encode($array); return $this->doDump($data, $path); } public function loadData($path) { $contents = $this->doLoad($path); $json = json_decode($contents); return $json; } } class Doctrine_Parser_Xml extends Doctrine_Parser { public function dumpData($array, $path = null, $charset = null) { $data = self::arrayToXml($array, 'data', null, $charset); return $this->doDump($data, $path); } public static function arrayToXml($array, $rootNodeName = 'data', $xml = null, $charset = null) { if ($xml === null) { $xml = new SimpleXmlElement("<?xml version=\"1.0\" encoding=\"utf-8\"?><$rootNodeName/>"); } foreach($array as $key => $value) { $key = preg_replace('/[^a-z]/i', '', $key); if (is_array($value) && ! empty($value)) { $node = $xml->addChild($key); foreach ($value as $k => $v) { if (is_numeric($v)) { unset($value[$k]); $node->addAttribute($k, $v); } } self::arrayToXml($value, $rootNodeName, $node, $charset); } else if (is_int($key)) { $xml->addChild($value, 'true'); } else { $charset = $charset ? $charset : 'utf-8'; if (strcasecmp($charset, 'utf-8') !== 0 && strcasecmp($charset, 'utf8') !== 0) { $value = iconv($charset, 'UTF-8', $value); } $value = htmlspecialchars($value, ENT_COMPAT, 'UTF-8'); $xml->addChild($key, $value); } } return $xml->asXML(); } public function loadData($path) { $contents = $this->doLoad($path); $simpleXml = simplexml_load_string($contents); return $this->prepareData($simpleXml); } public function prepareData($simpleXml) { if ($simpleXml instanceof SimpleXMLElement) { $children = $simpleXml->children(); $return = null; } foreach ($children as $element => $value) { if ($value instanceof SimpleXMLElement) { $values = (array) $value->children(); if (count($values) > 0) { $return[$element] = $this->prepareData($value); } else { if ( ! isset($return[$element])) { $return[$element] = (string) $value; } else { if ( ! is_array($return[$element])) { $return[$element] = array($return[$element], (string) $value); } else { $return[$element][] = (string) $value; } } } } } if (is_array($return)) { return $return; } else { return array(); } } } class Doctrine_Parser_Serialize extends Doctrine_Parser { public function dumpData($array, $path = null, $charset = null) { $data = serialize($array); return $this->doDump($data, $path); } public function loadData($path) { $contents = $this->doLoad($path); return unserialize($contents); } }class Doctrine_Parser_Exception extends Doctrine_Exception { }class Doctrine_RawSql_Exception extends Doctrine_Exception { }class Doctrine_EventListener_Chain extends Doctrine_Access implements Doctrine_EventListener_Interface { protected $_listeners = array(); public function add($listener, $name = null) { if ( ! ($listener instanceof Doctrine_EventListener_Interface) && ! ($listener instanceof Doctrine_Overloadable)) { throw new Doctrine_EventListener_Exception("Couldn't add eventlistener. EventListeners should implement either Doctrine_EventListener_Interface or Doctrine_Overloadable"); } if ($name === null) { $this->_listeners[] = $listener; } else { $this->_listeners[$name] = $listener; } } public function get($key) { if ( ! isset($this->_listeners[$key])) { return null; } return $this->_listeners[$key]; } public function set($key, $listener) { $this->_listeners[$key] = $listener; } public function onLoad(Doctrine_Record $record) { foreach ($this->_listeners as $listener) { $listener->onLoad($record); } } public function onPreLoad(Doctrine_Record $record) { foreach ($this->_listeners as $listener) { $listener->onPreLoad($record); } } public function onSleep(Doctrine_Record $record) { foreach ($this->_listeners as $listener) { $listener->onSleep($record); } } public function onWakeUp(Doctrine_Record $record) { foreach ($this->_listeners as $listener) { $listener->onWakeUp($record); } } public function postClose(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postClose($event); } } public function preClose(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preClose($event); } } public function onOpen(Doctrine_Connection $connection) { foreach ($this->_listeners as $listener) { $listener->onOpen($connection); } } public function postTransactionCommit(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postTransactionCommit($event); } } public function preTransactionCommit(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preTransactionCommit($event); } } public function postTransactionRollback(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postTransactionRollback($event); } } public function preTransactionRollback(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preTransactionRollback($event); } } public function postTransactionBegin(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postTransactionBegin($event); } } public function preTransactionBegin(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preTransactionBegin($event); } } public function postSavepointCommit(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postSavepointCommit($event); } } public function preSavepointCommit(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preSavepointCommit($event); } } public function postSavepointRollback(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postSavepointRollback($event); } } public function preSavepointRollback(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preSavepointRollback($event); } } public function postSavepointCreate(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postSavepointCreate($event); } } public function preSavepointCreate(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preSavepointCreate($event); } } public function onCollectionDelete(Doctrine_Collection $collection) { foreach ($this->_listeners as $listener) { $listener->onCollectionDelete($collection); } } public function onPreCollectionDelete(Doctrine_Collection $collection) { foreach ($this->_listeners as $listener) { $listener->onPreCollectionDelete($collection); } } public function postConnect(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postConnect($event); } } public function preConnect(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preConnect($event); } } public function preQuery(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preQuery($event); } } public function postQuery(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postQuery($event); } } public function prePrepare(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->prePrepare($event); } } public function postPrepare(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postPrepare($event); } } public function preExec(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preExec($event); } } public function postExec(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postExec($event); } } public function preError(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preError($event); } } public function postError(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postError($event); } } public function preFetch(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preFetch($event); } } public function postFetch(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postFetch($event); } } public function preFetchAll(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preFetchAll($event); } } public function postFetchAll(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postFetchAll($event); } } public function preStmtExecute(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->preStmtExecute($event); } } public function postStmtExecute(Doctrine_Event $event) { foreach ($this->_listeners as $listener) { $listener->postStmtExecute($event); } } }class Doctrine_EventListener_Exception extends Doctrine_Exception { }class Doctrine_Locking_Manager_Pessimistic { private $conn; private $_lockTable = 'doctrine_lock_tracking'; public function __construct(Doctrine_Connection $conn) { $this->conn = $conn; if ($this->conn->getAttribute(Doctrine_Core::ATTR_EXPORT) & Doctrine_Core::EXPORT_TABLES) { $columns = array(); $columns['object_type'] = array('type' => 'string', 'length' => 50, 'notnull' => true, 'primary' => true); $columns['object_key'] = array('type' => 'string', 'length' => 250, 'notnull' => true, 'primary' => true); $columns['user_ident'] = array('type' => 'string', 'length' => 50, 'notnull' => true); $columns['timestamp_obtained'] = array('type' => 'integer', 'length' => 10, 'notnull' => true); $options = array('primary' => array('object_type', 'object_key')); try { $this->conn->export->createTable($this->_lockTable, $columns, $options); } catch(Exception $e) { } } } public function getLock(Doctrine_Record $record, $userIdent) { $objectType = $record->getTable()->getComponentName(); $key = $record->getTable()->getIdentifier(); $gotLock = false; $time = time(); if (is_array($key)) { $key = implode('|', $key); } try { $dbh = $this->conn->getDbh(); $this->conn->beginTransaction(); $stmt = $dbh->prepare('INSERT INTO ' . $this->_lockTable . ' (object_type, object_key, user_ident, timestamp_obtained)' . ' VALUES (:object_type, :object_key, :user_ident, :ts_obtained)'); $stmt->bindParam(':object_type', $objectType); $stmt->bindParam(':object_key', $key); $stmt->bindParam(':user_ident', $userIdent); $stmt->bindParam(':ts_obtained', $time); try { $stmt->execute(); $gotLock = true; } catch(Exception $pkviolation) { } if ( ! $gotLock) { $lockingUserIdent = $this->_getLockingUserIdent($objectType, $key); if ($lockingUserIdent !== null && $lockingUserIdent == $userIdent) { $gotLock = true; $stmt = $dbh->prepare('UPDATE ' . $this->_lockTable . ' SET timestamp_obtained = :ts' . ' WHERE object_type = :object_type AND' . ' object_key  = :object_key  AND' . ' user_ident  = :user_ident'); $stmt->bindParam(':ts', $time); $stmt->bindParam(':object_type', $objectType); $stmt->bindParam(':object_key', $key); $stmt->bindParam(':user_ident', $lockingUserIdent); $stmt->execute(); } } $this->conn->commit(); } catch (Exception $pdoe) { $this->conn->rollback(); throw new Doctrine_Locking_Exception($pdoe->getMessage()); } return $gotLock; } public function releaseLock(Doctrine_Record $record, $userIdent) { $objectType = $record->getTable()->getComponentName(); $key = $record->getTable()->getIdentifier(); if (is_array($key)) { $key = implode('|', $key); } try { $dbh = $this->conn->getDbh(); $stmt = $dbh->prepare("DELETE FROM $this->_lockTable WHERE
                                        object_type = :object_type AND
                                        object_key  = :object_key  AND
                                        user_ident  = :user_ident"); $stmt->bindParam(':object_type', $objectType); $stmt->bindParam(':object_key', $key); $stmt->bindParam(':user_ident', $userIdent); $stmt->execute(); $count = $stmt->rowCount(); return ($count > 0); } catch (PDOException $pdoe) { throw new Doctrine_Locking_Exception($pdoe->getMessage()); } } private function _getLockingUserIdent($objectType, $key) { if (is_array($key)) { $key = implode('|', $key); } try { $dbh = $this->conn->getDbh(); $stmt = $dbh->prepare('SELECT user_ident FROM ' . $this->_lockTable . ' WHERE object_type = :object_type AND object_key = :object_key'); $stmt->bindParam(':object_type', $objectType); $stmt->bindParam(':object_key', $key); $success = $stmt->execute(); if ( ! $success) { throw new Doctrine_Locking_Exception("Failed to determine locking user"); } $userIdent = $stmt->fetchColumn(); } catch (PDOException $pdoe) { throw new Doctrine_Locking_Exception($pdoe->getMessage()); } return $userIdent; } public function getLockOwner($lockedRecord) { $objectType = $lockedRecord->getTable()->getComponentName(); $key = $lockedRecord->getTable()->getIdentifier(); return $this->_getLockingUserIdent($objectType, $key); } public function releaseAgedLocks($age = 900, $objectType = null, $userIdent = null) { $age = time() - $age; try { $dbh = $this->conn->getDbh(); $stmt = $dbh->prepare('DELETE FROM ' . $this->_lockTable . ' WHERE timestamp_obtained < :age'); $stmt->bindParam(':age', $age); $query = 'DELETE FROM ' . $this->_lockTable . ' WHERE timestamp_obtained < :age'; if ($objectType) { $query .= ' AND object_type = :object_type'; } if ($userIdent) { $query .= ' AND user_ident = :user_ident'; } $stmt = $dbh->prepare($query); $stmt->bindParam(':age', $age); if ($objectType) { $stmt->bindParam(':object_type', $objectType); } if ($userIdent) { $stmt->bindParam(':user_ident', $userIdent); } $stmt->execute(); $count = $stmt->rowCount(); return $count; } catch (PDOException $pdoe) { throw new Doctrine_Locking_Exception($pdoe->getMessage()); } } } class Doctrine_Locking_Exception extends Doctrine_Exception {}class Doctrine_File_Index extends Doctrine_Record { public function setTableDefinition() { $this->hasColumn('keyword', 'string', 255, array('notnull' => true, 'primary' => true)); $this->hasColumn('field', 'string', 50, array('notnull' => true, 'primary' => true)); $this->hasColumn('position', 'string', 255, array('notnull' => true, 'primary' => true)); $this->hasColumn('file_id', 'integer', 8, array('notnull' => true, 'primary' => true)); } public function setUp() { $this->hasOne('Doctrine_File', array('local' => 'file_id', 'foreign' => 'id', 'onDelete' => 'CASCADE', 'onUpdate' => 'CASCADE')); } }class Doctrine_Column extends Doctrine_Access implements IteratorAggregate, Countable { protected $_definition = array( 'type' => null, 'length' => 0, ); public function __construct(array $definition = array()) { $this->_definition = $definition; } public function getDefinition() { return $this->_definition; } public function contains($name) { return isset($this->_definition[$name]); } public function get($name) { if ( ! isset($this->_definition[$name])) { return null; } return $this->_definition[$name]; } public function set($name, $value) { $this->_definition[$name] = $value; } public function getEnumValues() { if (isset($this->_definition['values'])) { return $this->_definition['values']; } else { return array(); } } public function enumValue($index) { if ($index instanceof Doctrine_Null) { return false; } return isset($this->_definition['values'][$index]) ? $this->_definition['values'][$index] : false; } public function enumIndex($field, $value) { $values = $this->getEnumValues($field); return array_search($value, $values); } public function count() { return count($this->_definition); } public function getIterator() { return new ArrayIterator($this->_definition); } } class Doctrine_Table extends Doctrine_Configurable implements Countable { protected $_data = array(); protected $_identifier = array(); protected $_identifierType; protected $_conn; protected $_identityMap = array(); protected $_repository; protected $_columns = array(); protected $_uniques = array(); protected $_fieldNames = array(); protected $_columnNames = array(); protected $columnCount; protected $hasDefaultValues; protected $_options = array('name' => null, 'tableName' => null, 'sequenceName' => null, 'inheritanceMap' => array(), 'enumMap' => array(), 'type' => null, 'charset' => null, 'collate' => null, 'treeImpl' => null, 'treeOptions' => array(), 'indexes' => array(), 'parents' => array(), 'joinedParents' => array(), 'queryParts' => array(), 'versioning' => null, 'subclasses' => array(), 'orderBy' => null ); protected $_tree; protected $_parser; protected $_templates = array(); protected $_filters = array(); protected $_generators = array(); protected $_generator; protected $_invokedMethods = array(); protected $record; public function __construct($name, Doctrine_Connection $conn, $initDefinition = false) { $this->_conn = $conn; $this->_options['name'] = $name; $this->setParent($this->_conn); $this->_conn->addTable($this); $this->_parser = new Doctrine_Relation_Parser($this); if ($charset = $this->getAttribute(Doctrine_Core::ATTR_DEFAULT_TABLE_CHARSET)) { $this->_options['charset'] = $charset; } if ($collate = $this->getAttribute(Doctrine_Core::ATTR_DEFAULT_TABLE_COLLATE)) { $this->_options['collate'] = $collate; } if ($initDefinition) { $this->record = $this->initDefinition(); $this->initIdentifier(); $this->record->setUp(); if ($this->isTree()) { $this->getTree()->setUp(); } } else { if ( ! isset($this->_options['tableName'])) { $this->setTableName(Doctrine_Inflector::tableize($this->_options['name'])); } } $this->_filters[] = new Doctrine_Record_Filter_Standard(); $this->_repository = new Doctrine_Table_Repository($this); $this->construct(); } public function construct() { } public function initDefinition() { $name = $this->_options['name']; if ( ! class_exists($name) || empty($name)) { throw new Doctrine_Exception("Couldn't find class " . $name); } $record = new $name($this); $names = array(); $class = $name; do { if ($class === 'Doctrine_Record') { break; } $name = $class; $names[] = $name; } while ($class = get_parent_class($class)); if ($class === false) { throw new Doctrine_Table_Exception('Class "' . $name . '" must be a child class of Doctrine_Record'); } $names = array_reverse($names); array_pop($names); $this->_options['parents'] = $names; if (method_exists($record, 'setTableDefinition')) { $record->setTableDefinition(); $method = new ReflectionMethod($this->_options['name'], 'setTableDefinition'); $class = $method->getDeclaringClass(); } else { $class = new ReflectionClass($class); } $this->_options['joinedParents'] = array(); foreach (array_reverse($this->_options['parents']) as $parent) { if ($parent === $class->getName()) { continue; } $ref = new ReflectionClass($parent); if ($ref->isAbstract() || ! $class->isSubClassOf($parent)) { continue; } $parentTable = $this->_conn->getTable($parent); $found = false; $parentColumns = $parentTable->getColumns(); foreach ($parentColumns as $columnName => $definition) { if ( ! isset($definition['primary']) || $definition['primary'] === false) { if (isset($this->_columns[$columnName])) { $found = true; break; } else { if ( ! isset($parentColumns[$columnName]['owner'])) { $parentColumns[$columnName]['owner'] = $parentTable->getComponentName(); } $this->_options['joinedParents'][] = $parentColumns[$columnName]['owner']; } } else { unset($parentColumns[$columnName]); } } if ($found) { continue; } foreach ($parentColumns as $columnName => $definition) { $fullName = $columnName . ' as ' . $parentTable->getFieldName($columnName); $this->setColumn($fullName, $definition['type'], $definition['length'], $definition, true); } break; } $this->_options['joinedParents'] = array_values(array_unique($this->_options['joinedParents'])); $this->_options['declaringClass'] = $class; if ($this->isTree()) { $this->getTree()->setTableDefinition(); } $this->columnCount = count($this->_columns); if ( ! isset($this->_options['tableName'])) { $this->setTableName(Doctrine_Inflector::tableize($class->getName())); } return $record; } public function initIdentifier() { switch (count($this->_identifier)) { case 0: if ( ! empty($this->_options['joinedParents'])) { $root = current($this->_options['joinedParents']); $table = $this->_conn->getTable($root); $this->_identifier = $table->getIdentifier(); $this->_identifierType = ($table->getIdentifierType() !== Doctrine_Core::IDENTIFIER_AUTOINC) ? $table->getIdentifierType() : Doctrine_Core::IDENTIFIER_NATURAL; foreach ((array) $this->_identifier as $id) { $definition = $table->getDefinitionOf($id); unset($definition['autoincrement']); unset($definition['sequence']); $fullName = $id . ' as ' . $table->getFieldName($id); $this->setColumn($fullName, $definition['type'], $definition['length'], $definition, true); } } else { $identifierOptions = $this->getAttribute(Doctrine_Core::ATTR_DEFAULT_IDENTIFIER_OPTIONS); $name = (isset($identifierOptions['name']) && $identifierOptions['name']) ? $identifierOptions['name']:'id'; $name = sprintf($name, $this->getTableName()); $definition = array('type' => (isset($identifierOptions['type']) && $identifierOptions['type']) ? $identifierOptions['type']:'integer', 'length' => (isset($identifierOptions['length']) && $identifierOptions['length']) ? $identifierOptions['length']:8, 'autoincrement' => isset($identifierOptions['autoincrement']) ? $identifierOptions['autoincrement']:true, 'primary' => isset($identifierOptions['primary']) ? $identifierOptions['primary']:true); unset($identifierOptions['name'], $identifierOptions['type'], $identifierOptions['length']); foreach ($identifierOptions as $key => $value) { if ( ! isset($definition[$key]) || ! $definition[$key]) { $definition[$key] = $value; } } $this->setColumn($name, $definition['type'], $definition['length'], $definition, true); $this->_identifier = $name; $this->_identifierType = Doctrine_Core::IDENTIFIER_AUTOINC; } $this->columnCount++; break; case 1: foreach ($this->_identifier as $pk) { $e = $this->getDefinitionOf($pk); $found = false; foreach ($e as $option => $value) { if ($found) { break; } $e2 = explode(':', $option); switch (strtolower($e2[0])) { case 'autoincrement': case 'autoinc': if ($value !== false) { $this->_identifierType = Doctrine_Core::IDENTIFIER_AUTOINC; $found = true; } break; case 'seq': case 'sequence': $this->_identifierType = Doctrine_Core::IDENTIFIER_SEQUENCE; $found = true; if (is_string($value)) { $this->_options['sequenceName'] = $value; } else { if (($sequence = $this->getAttribute(Doctrine_Core::ATTR_DEFAULT_SEQUENCE)) !== null) { $this->_options['sequenceName'] = $sequence; } else { $this->_options['sequenceName'] = $this->_conn->formatter->getSequenceName($this->_options['tableName']); } } break; } } if ( ! isset($this->_identifierType)) { $this->_identifierType = Doctrine_Core::IDENTIFIER_NATURAL; } } $this->_identifier = $pk; break; default: $this->_identifierType = Doctrine_Core::IDENTIFIER_COMPOSITE; } } public function getColumnOwner($columnName) { if (isset($this->_columns[$columnName]['owner'])) { return $this->_columns[$columnName]['owner']; } else { return $this->getComponentName(); } } public function getRecordInstance() { if ( ! $this->record) { $this->record = new $this->_options['name']; } return $this->record; } public function isInheritedColumn($columnName) { return (isset($this->_columns[$columnName]['owner'])); } public function isIdentifier($fieldName) { return ($fieldName === $this->getIdentifier() || in_array($fieldName, (array) $this->getIdentifier())); } public function isIdentifierAutoincrement() { return $this->getIdentifierType() === Doctrine_Core::IDENTIFIER_AUTOINC; } public function isIdentifierComposite() { return $this->getIdentifierType() === Doctrine_Core::IDENTIFIER_COMPOSITE; } public function getMethodOwner($method) { return (isset($this->_invokedMethods[$method])) ? $this->_invokedMethods[$method] : false; } public function setMethodOwner($method, $class) { $this->_invokedMethods[$method] = $class; } public function export() { $this->_conn->export->exportTable($this); } public function getExportableFormat($parseForeignKeys = true) { $columns = array(); $primary = array(); foreach ($this->getColumns() as $name => $definition) { if (isset($definition['owner'])) { continue; } switch ($definition['type']) { case 'boolean': if (isset($definition['default'])) { $definition['default'] = $this->getConnection()->convertBooleans($definition['default']); } break; } $columns[$name] = $definition; if (isset($definition['primary']) && $definition['primary']) { $primary[] = $name; } } $options['foreignKeys'] = isset($this->_options['foreignKeys']) ? $this->_options['foreignKeys'] : array(); if ($parseForeignKeys && $this->getAttribute(Doctrine_Core::ATTR_EXPORT) & Doctrine_Core::EXPORT_CONSTRAINTS) { $constraints = array(); $emptyIntegrity = array('onUpdate' => null, 'onDelete' => null); foreach ($this->getRelations() as $name => $relation) { $fk = $relation->toArray(); $fk['foreignTable'] = $relation->getTable()->getTableName(); if ($relation->getTable()->getAttribute(Doctrine_Core::ATTR_EXPORT) === Doctrine_Core::EXPORT_NONE) { continue; } if ($relation->getTable() === $this && in_array($relation->getLocal(), $primary)) { if ($relation->hasConstraint()) { throw new Doctrine_Table_Exception("Badly constructed integrity constraints. Cannot define constraint of different fields in the same table."); } continue; } $integrity = array('onUpdate' => $fk['onUpdate'], 'onDelete' => $fk['onDelete']); $fkName = $relation->getForeignKeyName(); if ($relation instanceof Doctrine_Relation_LocalKey) { $def = array('name' => $fkName, 'local' => $relation->getLocalColumnName(), 'foreign' => $relation->getForeignColumnName(), 'foreignTable' => $relation->getTable()->getTableName()); if ($integrity !== $emptyIntegrity) { $def = array_merge($def, $integrity); } if (($key = $this->_checkForeignKeyExists($def, $options['foreignKeys'])) === false) { $options['foreignKeys'][$fkName] = $def; } else { unset($def['name']); $options['foreignKeys'][$key] = array_merge($options['foreignKeys'][$key], $def); } } } } $options['primary'] = $primary; return array('tableName' => $this->getOption('tableName'), 'columns' => $columns, 'options' => array_merge($this->getOptions(), $options)); } protected function _checkForeignKeyExists($def, $foreignKeys) { foreach ($foreignKeys as $key => $foreignKey) { if ($def['local'] == $foreignKey['local'] && $def['foreign'] == $foreignKey['foreign'] && $def['foreignTable'] == $foreignKey['foreignTable']) { return $key; } } return false; } public function getRelationParser() { return $this->_parser; } public function __get($option) { if (isset($this->_options[$option])) { return $this->_options[$option]; } return null; } public function __isset($option) { return isset($this->_options[$option]); } public function getOptions() { return $this->_options; } public function setOptions($options) { foreach ($options as $key => $value) { $this->setOption($key, $value); } } public function addForeignKey(array $definition) { $this->_options['foreignKeys'][] = $definition; } public function addCheckConstraint($definition, $name) { if (is_string($name)) { $this->_options['checks'][$name] = $definition; } else { $this->_options['checks'][] = $definition; } return $this; } public function addIndex($index, array $definition) { if (isset($definition['fields'])) { foreach ((array) $definition['fields'] as $key => $field) { if (is_numeric($key)) { $definition['fields'][$key] = $this->getColumnName($field); } else { $columnName = $this->getColumnName($key); unset($definition['fields'][$key]); $definition['fields'][$columnName] = $field; } } } $this->_options['indexes'][$index] = $definition; } public function getIndex($index) { if (isset($this->_options['indexes'][$index])) { return $this->_options['indexes'][$index]; } return false; } public function unique($fields, $options = array(), $createdUniqueIndex = true) { if ($createdUniqueIndex) { $name = implode('_', $fields) . '_unqidx'; $definition = array('type' => 'unique', 'fields' => $fields); $this->addIndex($name, $definition); } $this->_uniques[] = array($fields, $options); } public function bind($args, $type) { $options = ( ! isset($args[1])) ? array() : $args[1]; $options['type'] = $type; $this->_parser->bind($args[0], $options); } public function hasOne() { $this->bind(func_get_args(), Doctrine_Relation::ONE); } public function hasMany() { $this->bind(func_get_args(), Doctrine_Relation::MANY); } public function hasRelation($alias) { return $this->_parser->hasRelation($alias); } public function getRelation($alias, $recursive = true) { return $this->_parser->getRelation($alias, $recursive); } public function getRelations() { return $this->_parser->getRelations(); } public function createQuery($alias = '') { if ( ! empty($alias)) { $alias = ' ' . trim($alias); } $class = $this->getAttribute(Doctrine_Core::ATTR_QUERY_CLASS); return Doctrine_Query::create($this->_conn, $class) ->from($this->getComponentName() . $alias); } public function getRepository() { return $this->_repository; } public function setOption($name, $value) { switch ($name) { case 'name': case 'tableName': break; case 'enumMap': case 'inheritanceMap': case 'index': case 'treeOptions': if ( ! is_array($value)) { throw new Doctrine_Table_Exception($name . ' should be an array.'); } break; } $this->_options[$name] = $value; } public function getOption($name) { if (isset($this->_options[$name])) { return $this->_options[$name]; } return null; } public function getOrderByStatement($alias = null, $columnNames = false) { if (isset($this->_options['orderBy'])) { return $this->processOrderBy($alias, $this->_options['orderBy']); } } public function processOrderBy($alias, $orderBy, $columnNames = false) { if ( ! $alias) { $alias = $this->getComponentName(); } if ( ! is_array($orderBy)) { $e1 = explode(',', $orderBy); } else { $e1 = $orderBy; } $e1 = array_map('trim', $e1); foreach ($e1 as $k => $v) { $e2 = explode(' ', $v); if ($columnNames) { $e2[0] = $this->getColumnName($e2[0]); } if ($this->hasField($this->getFieldName($e2[0]))) { $e1[$k] = $alias . '.' . $e2[0]; } else { $e1[$k] = $e2[0]; } if (isset($e2[1])) { $e1[$k] .= ' ' . $e2[1]; } } return implode(', ', $e1); } public function getColumnName($fieldName) { $fieldName = is_array($fieldName) ? $fieldName[0]:$fieldName; if (isset($this->_columnNames[$fieldName])) { return $this->_columnNames[$fieldName]; } return strtolower($fieldName); } public function getColumnDefinition($columnName) { if ( ! isset($this->_columns[$columnName])) { return false; } return $this->_columns[$columnName]; } public function getFieldName($columnName) { if (isset($this->_fieldNames[$columnName])) { return $this->_fieldNames[$columnName]; } return $columnName; } public function setColumnOptions($columnName, array $options) { if (is_array($columnName)) { foreach ($columnName as $name) { $this->setColumnOptions($name, $options); } } else { foreach ($options as $option => $value) { $this->setColumnOption($columnName, $option, $value); } } } public function setColumnOption($columnName, $option, $value) { if ($option == 'primary') { if (isset($this->_identifier)) { $this->_identifier = (array) $this->_identifier; } if ($value && ! in_array($columnName, $this->_identifier)) { $this->_identifier[] = $columnName; } else if (!$value && in_array($columnName, $this->_identifier)) { $key = array_search($columnName, $this->_identifier); unset($this->_identifier[$key]); } } $columnName = $this->getColumnName($columnName); $this->_columns[$columnName][$option] = $value; } public function setColumns(array $definitions) { foreach ($definitions as $name => $options) { $this->setColumn($name, $options['type'], $options['length'], $options); } } public function setColumn($name, $type = null, $length = null, $options = array(), $prepend = false) { if(strtolower($name) == strtolower(substr($this->getTableName(),0,-1)."_id")) if (is_string($options)) { $options = explode('|', $options); } foreach ($options as $k => $option) { if (is_numeric($k)) { if ( ! empty($option)) { $options[$option] = true; } unset($options[$k]); } } if (stripos($name, ' as ')) { if (strpos($name, ' as ')) { $parts = explode(' as ', $name); } else { $parts = explode(' AS ', $name); } if (count($parts) > 1) { $fieldName = $parts[1]; } else { $fieldName = $parts[0]; } $name = strtolower($parts[0]); } else { $fieldName = $name; $name = strtolower($name); } $name = trim($name); $fieldName = trim($fieldName); if ($prepend) { $this->_columnNames = array_merge(array($fieldName => $name), $this->_columnNames); $this->_fieldNames = array_merge(array($name => $fieldName), $this->_fieldNames); } else { $this->_columnNames[$fieldName] = $name; $this->_fieldNames[$name] = $fieldName; } $defaultOptions = $this->getAttribute(Doctrine_Core::ATTR_DEFAULT_COLUMN_OPTIONS); if (isset($defaultOptions['length']) && $defaultOptions['length'] && $length == null) { $length = $defaultOptions['length']; } if ($length == null) { switch ($type) { case 'integer': $length = 8; break; case 'decimal': $length = 18; break; case 'string': case 'clob': case 'float': case 'integer': case 'array': case 'object': case 'blob': case 'gzip': $length = null; break; case 'boolean': $length = 1; case 'date': $length = 10; case 'time': $length = 14; case 'timestamp': $length = 25; } } $options['type'] = $type; $options['length'] = $length; foreach ($defaultOptions as $key => $value) { if ( ! array_key_exists($key, $options) || is_null($options[$key])) { $options[$key] = $value; } } if ($prepend) { $this->_columns = array_merge(array($name => $options), $this->_columns); } else { $this->_columns[$name] = $options; } if (isset($options['primary']) && $options['primary']) { if (isset($this->_identifier)) { $this->_identifier = (array) $this->_identifier; } if ( ! in_array($fieldName, $this->_identifier)) { $this->_identifier[] = $fieldName; } } if (isset($options['default'])) { $this->hasDefaultValues = true; } } public function hasDefaultValues() { return $this->hasDefaultValues; } public function getDefaultValueOf($fieldName) { $columnName = $this->getColumnName($fieldName); if ( ! isset($this->_columns[$columnName])) { throw new Doctrine_Table_Exception("Couldn't get default value. Column ".$columnName." doesn't exist."); } if (isset($this->_columns[$columnName]['default'])) { return $this->_columns[$columnName]['default']; } else { return null; } } public function getIdentifier() { return $this->_identifier; } public function getIdentifierType() { return $this->_identifierType; } public function hasColumn($columnName) { return isset($this->_columns[strtolower($columnName)]); } public function hasField($fieldName) { return isset($this->_columnNames[$fieldName]); } public function setConnection(Doctrine_Connection $conn) { $this->_conn = $conn; $this->setParent($this->_conn); return $this; } public function getConnection() { return $this->_conn; } public function create(array $array = array()) { $record = new $this->_options['name']($this, true); $record->fromArray($array); return $record; } public function addNamedQuery($queryKey, $query) { $registry = Doctrine_Manager::getInstance()->getQueryRegistry(); $registry->add($this->getComponentName() . '/' . $queryKey, $query); } public function createNamedQuery($queryKey) { $queryRegistry = Doctrine_Manager::getInstance()->getQueryRegistry(); if (strpos($queryKey, '/') !== false) { $e = explode('/', $queryKey); return $queryRegistry->get($e[1], $e[0]); } return $queryRegistry->get($queryKey, $this->getComponentName()); } public function find() { $num_args = func_num_args(); $name = func_get_arg(0); if (is_null($name)) { return false; } $ns = $this->getComponentName(); $m = $name; if ( ! is_array($name) && strpos($name, '/') !== false) { list($ns, $m) = explode('/', $name); } if ( ! is_array($name) && Doctrine_Manager::getInstance()->getQueryRegistry()->has($m, $ns) ) { $q = $this->createNamedQuery($name); $params = ($num_args >= 2) ? func_get_arg(1) : array(); $hydrationMode = ($num_args == 3) ? func_get_arg(2) : null; $res = $q->execute($params, $hydrationMode); } else { $q = $this->createQuery('dctrn_find') ->where('dctrn_find.' . implode(' = ? AND dctrn_find.', (array) $this->getIdentifier()) . ' = ?') ->limit(1); $params = is_array($name) ? array_values($name) : array($name); $hydrationMode = ($num_args == 2) ? func_get_arg(1) : null; $res = $q->fetchOne($params, $hydrationMode); } $q->free(); return $res; } public function findAll($hydrationMode = null) { return $this->createQuery('dctrn_find') ->execute(array(), $hydrationMode); } public function findBySql($dql, $params = array(), $hydrationMode = null) { return $this->createQuery('dctrn_find') ->where($dql)->execute($params, $hydrationMode); } public function findByDql($dql, $params = array(), $hydrationMode = null) { $parser = $this->createQuery(); $query = 'FROM ' . $this->getComponentName() . ' dctrn_find WHERE ' . $dql; return $parser->query($query, $params, $hydrationMode); } public function findBy($fieldName, $value, $hydrationMode = null) { return $this->createQuery('dctrn_find') ->where($this->buildFindByWhere($fieldName), (array) $value) ->execute(array(), $hydrationMode); } public function findOneBy($fieldName, $value, $hydrationMode = null) { return $this->createQuery('dctrn_find') ->where($this->buildFindByWhere($fieldName), (array) $value) ->limit(1) ->fetchOne(array(), $hydrationMode); } public function execute($queryKey, $params = array(), $hydrationMode = Doctrine_Core::HYDRATE_RECORD) { return $this->createNamedQuery($queryKey)->execute($params, $hydrationMode); } public function executeOne($queryKey, $params = array(), $hydrationMode = Doctrine_Core::HYDRATE_RECORD) { return $this->createNamedQuery($queryKey)->fetchOne($params, $hydrationMode); } public function clear() { $this->_identityMap = array(); } public function addRecord(Doctrine_Record $record) { $id = implode(' ', $record->identifier()); if (isset($this->_identityMap[$id])) { return false; } $this->_identityMap[$id] = $record; return true; } public function removeRecord(Doctrine_Record $record) { $id = implode(' ', $record->identifier()); if (isset($this->_identityMap[$id])) { unset($this->_identityMap[$id]); return true; } return false; } public function getRecord() { if ( ! empty($this->_data)) { $identifierFieldNames = $this->getIdentifier(); if ( ! is_array($identifierFieldNames)) { $identifierFieldNames = array($identifierFieldNames); } $found = false; foreach ($identifierFieldNames as $fieldName) { if ( ! isset($this->_data[$fieldName])) { $found = true; break; } $id[] = $this->_data[$fieldName]; } if ($found) { $recordName = $this->getComponentName(); $record = new $recordName($this, true); $this->_data = array(); return $record; } $id = implode(' ', $id); if (isset($this->_identityMap[$id])) { $record = $this->_identityMap[$id]; if ($record->getTable()->getAttribute(Doctrine_Core::ATTR_HYDRATE_OVERWRITE)) { $record->hydrate($this->_data); if ($record->state() == Doctrine_Record::STATE_PROXY) { if (!$record->isInProxyState()) { $record->state(Doctrine_Record::STATE_CLEAN); } } } else { $record->hydrate($this->_data, false); } } else { $recordName = $this->getComponentName(); $record = new $recordName($this); $this->_identityMap[$id] = $record; } $this->_data = array(); } else { $recordName = $this->getComponentName(); $record = new $recordName($this, true); } return $record; } public function getClassnameToReturn() { if ( ! isset($this->_options['subclasses'])) { return $this->_options['name']; } foreach ($this->_options['subclasses'] as $subclass) { $table = $this->_conn->getTable($subclass); $inheritanceMap = $table->getOption('inheritanceMap'); $nomatch = false; foreach ($inheritanceMap as $key => $value) { if ( ! isset($this->_data[$key]) || $this->_data[$key] != $value) { $nomatch = true; break; } } if ( ! $nomatch) { return $table->getComponentName(); } } return $this->_options['name']; } final public function getProxy($id = null) { if ($id !== null) { $identifierColumnNames = $this->getIdentifierColumnNames(); $query = 'SELECT ' . implode(', ', (array) $identifierColumnNames) . ' FROM ' . $this->getTableName() . ' WHERE ' . implode(' = ? && ', (array) $identifierColumnNames) . ' = ?'; $query = $this->applyInheritance($query); $params = array_merge(array($id), array_values($this->_options['inheritanceMap'])); $this->_data = $this->_conn->execute($query, $params)->fetch(PDO::FETCH_ASSOC); if ($this->_data === false) return false; } return $this->getRecord(); } final public function applyInheritance($where) { if ( ! empty($this->_options['inheritanceMap'])) { $a = array(); foreach ($this->_options['inheritanceMap'] as $field => $value) { $a[] = $this->getColumnName($field) . ' = ?'; } $i = implode(' AND ', $a); $where .= ' AND ' . $i; } return $where; } public function count() { return $this->createQuery()->count(); } public function getQueryObject() { $graph = $this->createQuery(); $graph->load($this->getComponentName()); return $graph; } public function getEnumValues($fieldName) { $columnName = $this->getColumnName($fieldName); if (isset($this->_columns[$columnName]['values'])) { return $this->_columns[$columnName]['values']; } else { return array(); } } public function enumValue($fieldName, $index) { if ($index instanceof Doctrine_Null) { return false; } if ($this->_conn->getAttribute(Doctrine_Core::ATTR_USE_NATIVE_ENUM)) { return $index; } $columnName = $this->getColumnName($fieldName); return isset($this->_columns[$columnName]['values'][$index]) ? $this->_columns[$columnName]['values'][$index] : false; } public function enumIndex($fieldName, $value) { $values = $this->getEnumValues($fieldName); if ($this->_conn->getAttribute(Doctrine_Core::ATTR_USE_NATIVE_ENUM)) { return $value; } return array_search($value, $values); } public function validateField($fieldName, $value, Doctrine_Record $record = null) { if ($record instanceof Doctrine_Record) { $errorStack = $record->getErrorStack(); } else { $record = $this->create(); $errorStack = new Doctrine_Validator_ErrorStack($this->getOption('name')); } if ($value === self::$_null) { $value = null; } else if ($value instanceof Doctrine_Record && $value->exists()) { $value = $value->getIncremented(); } else if ($value instanceof Doctrine_Record && ! $value->exists()) { foreach($this->getRelations() as $relation) { if ($fieldName == $relation->getLocalFieldName() && (get_class($value) == $relation->getClass() || is_subclass_of($value, $relation->getClass()))) { return $errorStack; } } } $dataType = $this->getTypeOf($fieldName); if ($this->getAttribute(Doctrine_Core::ATTR_VALIDATE) & Doctrine_Core::VALIDATE_TYPES) { if ( ! Doctrine_Validator::isValidType($value, $dataType)) { $errorStack->add($fieldName, 'type'); } if ($dataType == 'enum') { $enumIndex = $this->enumIndex($fieldName, $value); if ($enumIndex === false && $value !== null) { $errorStack->add($fieldName, 'enum'); } } if ($dataType == 'set') { $values = $this->_columns[$fieldName]['values']; if (is_string($value)) { $value = explode(',', $value); $value = array_map('trim', $value); $record->set($fieldName, $value); } foreach ($value as $k => $v) { if ( ! in_array($v, $values)) { $errorStack->add($fieldName, 'set'); } } } } if ($this->getAttribute(Doctrine_Core::ATTR_VALIDATE) & Doctrine_Core::VALIDATE_LENGTHS) { if ( ! Doctrine_Validator::validateLength($value, $dataType, $this->getFieldLength($fieldName))) { $errorStack->add($fieldName, 'length'); } } foreach ($this->getFieldValidators($fieldName) as $validatorName => $args) { if ( ! is_string($validatorName)) { $validatorName = $args; $args = array(); } $validator = Doctrine_Validator::getValidator($validatorName); $validator->invoker = $record; $validator->field = $fieldName; $validator->args = $args; if ( ! $validator->validate($value)) { $errorStack->add($fieldName, $validator); } } return $errorStack; } public function validateUniques(Doctrine_Record $record) { $errorStack = $record->getErrorStack(); $validator = Doctrine_Validator::getValidator('unique'); $validator->invoker = $record; foreach ($this->_uniques as $unique) { list($fields, $options) = $unique; $validator->args = $options; $validator->field = $fields; $values = array(); foreach ($fields as $field) { $values[] = $record->$field; } if ( ! $validator->validate($values)) { foreach ($fields as $field) { $errorStack->add($field, $validator); } } } } public function getColumnCount() { return $this->columnCount; } public function getColumns() { return $this->_columns; } public function removeColumn($fieldName) { if ( ! $this->hasField($fieldName)) { return false; } $columnName = $this->getColumnName($fieldName); unset($this->_columnNames[$fieldName], $this->_fieldNames[$columnName], $this->_columns[$columnName]); $this->columnCount = count($this->_columns); return true; } public function getColumnNames(array $fieldNames = null) { if ($fieldNames === null) { return array_keys($this->_columns); } else { $columnNames = array(); foreach ($fieldNames as $fieldName) { $columnNames[] = $this->getColumnName($fieldName); } return $columnNames; } } public function getIdentifierColumnNames() { return $this->getColumnNames((array) $this->getIdentifier()); } public function getUniques() { return $this->_uniques; } public function getFieldNames() { return array_values($this->_fieldNames); } public function getDefinitionOf($fieldName) { $columnName = $this->getColumnName($fieldName); return $this->getColumnDefinition($columnName); } public function getTypeOf($fieldName) { return $this->getTypeOfColumn($this->getColumnName($fieldName)); } public function getTypeOfColumn($columnName) { return isset($this->_columns[$columnName]) ? $this->_columns[$columnName]['type'] : false; } public function setData(array $data) { $this->_data = $data; } public function getData() { return $this->_data; } public function prepareValue($fieldName, $value, $typeHint = null) { if ($value === self::$_null) { return self::$_null; } else if ($value === null) { return null; } else { $type = is_null($typeHint) ? $this->getTypeOf($fieldName) : $typeHint; switch ($type) { case 'enum': case 'integer': case 'string'; break; case 'set': return explode(',', $value); break; case 'boolean': return (boolean) $value; break; case 'array': case 'object': if (is_string($value)) { $value = empty($value) ? null:unserialize($value); if ($value === false) { throw new Doctrine_Table_Exception('Unserialization of ' . $fieldName . ' failed.'); } return $value; } break; case 'gzip': $value = gzuncompress($value); if ($value === false) { throw new Doctrine_Table_Exception('Uncompressing of ' . $fieldName . ' failed.'); } return $value; break; } } return $value; } public function getTree() { if (isset($this->_options['treeImpl'])) { if ( ! $this->_tree) { $options = isset($this->_options['treeOptions']) ? $this->_options['treeOptions'] : array(); $this->_tree = Doctrine_Tree::factory($this, $this->_options['treeImpl'], $options ); } return $this->_tree; } return false; } public function getComponentName() { return $this->_options['name']; } public function getTableName() { return $this->_options['tableName']; } public function setTableName($tableName) { $this->setOption('tableName', $this->_conn->formatter->getTableName($tableName)); } public function isTree() { return ( ! is_null($this->_options['treeImpl'])) ? true : false; } public function getTemplates() { return $this->_templates; } public function getTemplate($template) { if (isset($this->_templates['Doctrine_Template_' . $template])) { return $this->_templates['Doctrine_Template_' . $template]; } else if (isset($this->_templates[$template])) { return $this->_templates[$template]; } throw new Doctrine_Table_Exception('Template ' . $template . ' not loaded'); } public function hasTemplate($template) { return isset($this->_templates[$template]) || isset($this->_templates['Doctrine_Template_' . $template]); } public function addTemplate($template, Doctrine_Template $impl) { $this->_templates[$template] = $impl; return $this; } public function getGenerators() { return $this->_generators; } public function getGenerator($generator) { if ( ! isset($this->_generators[$generator])) { throw new Doctrine_Table_Exception('Generator ' . $generator . ' not loaded'); } return $this->_generators[$generator]; } public function hasGenerator($generator) { return isset($this->_generators[$generator]); } public function addGenerator(Doctrine_Record_Generator $generator, $name = null) { if ($name === null) { $this->_generators[] = $generator; } else { $this->_generators[$name] = $generator; } return $this; } public function setGenerator(Doctrine_Record_Generator $generator) { $this->_generator = $generator; } public function isGenerator() { return isset($this->_generator) ? true : false; } public function getParentGenerator() { return $this->_generator; } public function bindQueryParts(array $queryParts) { $this->_options['queryParts'] = $queryParts; return $this; } public function bindQueryPart($queryPart, $value) { $this->_options['queryParts'][$queryPart] = $value; return $this; } public function getFieldValidators($fieldName) { $validators = array(); $columnName = $this->getColumnName($fieldName); foreach ($this->_columns[$columnName] as $name => $args) { if (empty($name) || $name == 'primary' || $name == 'protected' || $name == 'autoincrement' || $name == 'default' || $name == 'values' || $name == 'sequence' || $name == 'zerofill' || $name == 'owner' || $name == 'scale' || $name == 'type' || $name == 'length' || $name == 'fixed' || $name == 'comment' || $name == 'extra') { continue; } if ($name == 'notnull' && isset($this->_columns[$columnName]['autoincrement']) && $this->_columns[$columnName]['autoincrement'] === true) { continue; } if ($args === false) { continue; } $validators[$name] = $args; } return $validators; } public function getFieldLength($fieldName) { return $this->_columns[$this->getColumnName($fieldName)]['length']; } public function getBoundQueryPart($queryPart) { if ( ! isset($this->_options['queryParts'][$queryPart])) { return null; } return $this->_options['queryParts'][$queryPart]; } public function unshiftFilter(Doctrine_Record_Filter $filter) { $filter->setTable($this); $filter->init(); array_unshift($this->_filters, $filter); return $this; } public function getFilters() { return $this->_filters; } public function __toString() { return Doctrine_Lib::getTableAsString($this); } private function isGreaterThan($a, $b) { if (strlen($a) == strlen($b)) return 0; return (strlen($a) > strlen($b)) ? 1 : -1; } public function buildFindByWhere($fieldName) { $fields = array_merge($this->getFieldNames(), $this->getColumnNames()); $fields = array_merge($fields, array_map(array('Doctrine_Inflector', 'classify'), $fields)); $fields = array_merge($fields, array_map('ucfirst', $fields)); usort($fields, array($this, 'isGreaterThan')); $fields = array_reverse(array_unique($fields)); preg_match_all('/(' . implode('|', $fields) . ')(Or|And)?/', $fieldName, $matches); $fieldsFound = $matches[1]; $operatorFound = array_map('strtoupper', $matches[2]); if (strlen(implode('', $fieldsFound) . implode('', $operatorFound)) !== strlen($fieldName)) { $expression = preg_replace('/(' . implode('|', $fields) . ')(Or|And)?/', '($1)$2', $fieldName); throw new Doctrine_Table_Exception('Invalid expression found: ' . $expression); } $where = $lastOperator = ''; $bracketOpen = false; foreach ($fieldsFound as $index => $field) { $field = $this->_resolveFindByFieldName($field); if (!$field) { throw new Doctrine_Table_Exception('Invalid field name to find by: ' . $field); } if ($operatorFound[$index] == 'OR' && !$bracketOpen) { $where .= '('; $bracketOpen = true; } $where .= 'dctrn_find.' . $field . ' = ?'; if ($operatorFound[$index] != 'OR' && $lastOperator == 'OR') { $where .= ')'; $bracketOpen = false; } $where .= ' ' . strtoupper($operatorFound[$index]) . ' '; $lastOperator = $operatorFound[$index]; } return trim($where); } protected function _resolveFindByFieldName($name) { $fieldName = Doctrine_Inflector::tableize($name); if ($this->hasColumn($name) || $this->hasField($name)) { return $this->getFieldName($this->getColumnName($name)); } else if ($this->hasColumn($fieldName) || $this->hasField($fieldName)) { return $this->getFieldName($this->getColumnName($fieldName)); } else { return false; } } public function __call($method, $arguments) { $lcMethod = strtolower($method); if (substr($lcMethod, 0, 6) == 'findby') { $by = substr($method, 6, strlen($method)); $method = 'findBy'; } else if (substr($lcMethod, 0, 9) == 'findoneby') { $by = substr($method, 9, strlen($method)); $method = 'findOneBy'; } if (isset($by)) { if ( ! isset($arguments[0])) { throw new Doctrine_Table_Exception('You must specify the value to ' . $method); } $fieldName = $this->_resolveFindByFieldName($by); $count = count(explode('Or', $by)) + (count(explode('And', $by)) - 1); if (count($arguments) > $count) { $hydrationMode = end($arguments); unset($arguments[count($arguments) - 1]); } else { $hydrationMode = null; } if ($this->hasField($fieldName)) { return $this->$method($fieldName, $arguments[0], $hydrationMode); } else if ($this->hasRelation($by)) { $relation = $this->getRelation($by); if ($relation['type'] === Doctrine_Relation::MANY) { throw new Doctrine_Table_Exception('Cannot findBy many relationship.'); } return $this->$method($relation['local'], $arguments[0], $hydrationMode); } else { return $this->$method($by, $arguments, $hydrationMode); } } try { return call_user_func_array(array($this->getRecordInstance(), $method . 'TableProxy'), $arguments); } catch (Doctrine_Record_UnknownPropertyException $e) {} throw new Doctrine_Table_Exception(sprintf('Unknown method %s::%s', get_class($this), $method)); } } class Doctrine_IntegrityMapper { public function processDeleteIntegrity(Doctrine_Record $record) { $coll = $this->buildIntegrityRelationQuery($record); $this->invokeIntegrityActions($record); } public function invokeIntegrityActions(Doctrine_Record $record) { $deleteActions = Doctrine_Manager::getInstance() ->getDeleteActions($record->getTable()->getComponentName()); foreach ($record->getTable()->getRelations() as $relation) { $componentName = $relation->getTable()->getComponentName(); foreach($record->get($relation->getAlias()) as $coll) { if ( ! ($coll instanceof Doctrine_Collection)) { $coll = array($coll); } foreach ($coll as $record) { $this->invokeIntegrityActions($record); if (isset($deleteActions[$componentName])) { if ($deleteActions[$componentName] === 'SET NULL') { $record->set($relation->getForeign(), null); } elseif ($deleteActions[$componentName] === 'CASCADE') { $this->conn->transaction->addDelete($record); } } } } } } public function buildIntegrityRelationQuery(Doctrine_Record $record) { $q = $record->getTable()->createQuery(); $aliases = array(); $indexes = array(); $root = $record->getTable()->getComponentName(); $rootAlias = strtolower(substr($root, 0, 1)); $aliases[$rootAlias] = $root; foreach ((array) $record->getTable()->getIdentifier() as $id) { $field = $rootAlias . '.' . $id; $cond[] = $field . ' = ?'; $fields[] = $field; $params = $record->get($id); } $fields = implode(', ', $fields); $components[] = $root; $this->buildIntegrityRelations($record->getTable(), $aliases, $fields, $indexes, $components); $q->select($fields)->from($root. ' ' . $rootAlias); foreach ($aliases as $alias => $name) { $q->leftJoin($rootAlias . '.' . $name . ' ' . $alias); } $q->where(implode(' AND ', $cond)); return $q->execute(array($params)); } public function buildIntegrityRelations(Doctrine_Table $table, &$aliases, &$fields, &$indexes, &$components) { $deleteActions = Doctrine_Manager::getInstance() ->getDeleteActions($table->getComponentName()); foreach ($table->getRelations() as $relation) { $componentName = $relation->getTable()->getComponentName(); if (in_array($componentName, $components)) { continue; } $components[] = $componentName; $alias = strtolower(substr($relation->getAlias(), 0, 1)); if ( ! isset($indexes[$alias])) { $indexes[$alias] = 1; } if (isset($deleteActions[$componentName])) { if (isset($aliases[$alias])) { $alias = $alias . ++$indexes[$alias]; } $aliases[$alias] = $relation->getAlias(); if ($deleteActions[$componentName] === 'SET NULL') { if ($relation instanceof Doctrine_Relation_ForeignKey) { foreach ((array) $relation->getForeign() as $foreign) { $fields .= ', ' . $alias . '.' . $foreign; } } elseif ($relation instanceof Doctrine_Relation_LocalKey) { foreach ((array) $relation->getLocal() as $foreign) { $fields .= ', ' . $alias . '.' . $foreign; } } } foreach ((array) $relation->getTable()->getIdentifier() as $id) { $fields .= ', ' . $alias . '.' . $id; } if ($deleteActions[$componentName] === 'CASCADE') { $this->buildIntegrityRelations($relation->getTable(), $aliases, $fields, $indexes, $components); } } } } } class Doctrine_Event { const CONN_QUERY = 1; const CONN_EXEC = 2; const CONN_PREPARE = 3; const CONN_CONNECT = 4; const CONN_CLOSE = 5; const CONN_ERROR = 6; const STMT_EXECUTE = 10; const STMT_FETCH = 11; const STMT_FETCHALL = 12; const TX_BEGIN = 31; const TX_COMMIT = 32; const TX_ROLLBACK = 33; const SAVEPOINT_CREATE = 34; const SAVEPOINT_ROLLBACK = 35; const SAVEPOINT_COMMIT = 36; const HYDRATE = 40; const RECORD_DELETE = 21; const RECORD_SAVE = 22; const RECORD_UPDATE = 23; const RECORD_INSERT = 24; const RECORD_SERIALIZE = 25; const RECORD_UNSERIALIZE = 26; const RECORD_DQL_DELETE = 27; const RECORD_DQL_SELECT = 28; const RECORD_DQL_UPDATE = 29; const RECORD_VALIDATE = 30; static protected $_nextSequence = 0; protected $_sequence; protected $_invoker; protected $_query; protected $_params; protected $_code; protected $_startedMicrotime; protected $_endedMicrotime; protected $_options = array(); public function __construct($invoker, $code, $query = null, $params = array()) { $this->_sequence = self::$_nextSequence++; $this->_invoker = $invoker; $this->_code = $code; $this->_query = $query; $this->_params = $params; } public function getQuery() { return $this->_query; } public function getName() { switch ($this->_code) { case self::CONN_QUERY: return 'query'; case self::CONN_EXEC: return 'exec'; case self::CONN_PREPARE: return 'prepare'; case self::CONN_CONNECT: return 'connect'; case self::CONN_CLOSE: return 'close'; case self::CONN_ERROR: return 'error'; case self::STMT_EXECUTE: return 'execute'; case self::STMT_FETCH: return 'fetch'; case self::STMT_FETCHALL: return 'fetch all'; case self::TX_BEGIN: return 'begin'; case self::TX_COMMIT: return 'commit'; case self::TX_ROLLBACK: return 'rollback'; case self::SAVEPOINT_CREATE: return 'create savepoint'; case self::SAVEPOINT_ROLLBACK: return 'rollback savepoint'; case self::SAVEPOINT_COMMIT: return 'commit savepoint'; case self::RECORD_DELETE: return 'delete record'; case self::RECORD_SAVE: return 'save record'; case self::RECORD_UPDATE: return 'update record'; case self::RECORD_INSERT: return 'insert record'; case self::RECORD_SERIALIZE: return 'serialize record'; case self::RECORD_UNSERIALIZE: return 'unserialize record'; case self::RECORD_DQL_SELECT: return 'select records'; case self::RECORD_DQL_DELETE: return 'delete records'; case self::RECORD_DQL_UPDATE: return 'update records'; case self::RECORD_VALIDATE: return 'validate record'; } } public function getCode() { return $this->_code; } public function __get($option) { if ( ! isset($this->_options[$option])) { return null; } return $this->_options[$option]; } public function skipOperation() { $this->_options['skipOperation'] = true; return $this; } public function __set($option, $value) { $this->_options[$option] = $value; return $this; } public function set($option, &$value) { $this->_options[$option] =& $value; return $this; } public function start() { $this->_startedMicrotime = microtime(true); } public function hasEnded() { return ($this->_endedMicrotime != null); } public function end() { $this->_endedMicrotime = microtime(true); return $this; } public function getSequence() { return $this->_sequence; } public function getInvoker() { return $this->_invoker; } public function setInvoker($invoker) { $this->_invoker = $invoker; } public function getParams() { return $this->_params; } public function getElapsedSecs() { if (is_null($this->_endedMicrotime)) { return false; } return ($this->_endedMicrotime - $this->_startedMicrotime); } } abstract class Doctrine_Collection_Iterator implements Iterator { protected $collection; protected $keys; protected $key; protected $index; protected $count; public function __construct($collection) { $this->collection = $collection; $this->keys = $this->collection->getKeys(); $this->count = $this->collection->count(); } public function rewind() { $this->index = 0; $i = $this->index; if (isset($this->keys[$i])) { $this->key = $this->keys[$i]; } } public function key() { return $this->key; } public function current() { return $this->collection->get($this->key); } public function next() { $this->index++; $i = $this->index; if (isset($this->keys[$i])) { $this->key = $this->keys[$i]; } } }class Doctrine_Collection_Offset extends Doctrine_Collection { private $limit; public function __construct(Doctrine_Table $table) { parent::__construct($table); $this->limit = $table->getAttribute(Doctrine_Core::ATTR_COLL_LIMIT); } public function getLimit() { return $this->limit; } public function getIterator() { return new Doctrine_Collection_Iterator_Expandable($this); } } class Doctrine_Collection_OnDemand implements Iterator { protected $_stmt; protected $_current; protected $_tableAliasMap; protected $_hydrator; protected $index; public function __construct($stmt, $hydrator, $tableAliasMap) { $this->_stmt = $stmt; $this->_hydrator = $hydrator; $this->_tableAliasMap = $tableAliasMap; $this->_current = null; $this->index = 0; $this->_hydrateCurrent(); } private function _hydrateCurrent() { $record = $this->_hydrator->hydrateResultSet($this->_stmt); if ($record instanceof Doctrine_Collection) { $this->_current = $record->getFirst(); } else if (is_array($record) && count($record) == 0) { $this->_current = null; } else if (is_array($record) && isset($record[0])) { $this->_current = $record[0]; } else { $this->_current = $record; } } public function rewind() { $this->index = 0; $this->_stmt->closeCursor(); $this->_stmt->execute(); $this->_hydrator->onDemandReset(); $this->_hydrateCurrent(); } public function key() { return $this->index; } public function current() { return $this->_current; } public function next() { $this->_current = null; $this->index++; $this->_hydrateCurrent(); } public function valid() { if ( ! is_null($this->_current) && $this->_current !== false) { return true; } return false; } }class Doctrine_Collection_Iterator_Offset extends Doctrine_Collection_Iterator { public function valid() { } }class Doctrine_Collection_Iterator_Normal extends Doctrine_Collection_Iterator { public function valid() { return ($this->index < $this->count); } }class Doctrine_Collection_Iterator_Expandable extends Doctrine_Collection_Iterator { public function valid() { if ($this->index < $this->count) { return true; } elseif ($this->index == $this->count) { $coll = $this->collection->expand($this->index); if ($coll instanceof Doctrine_Collection) { $count = count($coll); if ($count > 0) { $this->keys = array_merge($this->keys, $coll->getKeys()); $this->count += $count; return true; } } return false; } } }class Doctrine_Collection_Exception extends Doctrine_Exception { }class Doctrine_Table_Repository implements Countable, IteratorAggregate { private $table; private $registry = array(); public function __construct(Doctrine_Table $table) { $this->table = $table; } public function getTable() { return $this->table; } public function add(Doctrine_Record $record) { $oid = $record->getOID(); if (isset($this->registry[$oid])) { return false; } $this->registry[$oid] = $record; return true; } public function get($oid) { if ( ! isset($this->registry[$oid])) { throw new Doctrine_Table_Repository_Exception("Unknown object identifier"); } return $this->registry[$oid]; } public function count() { return count($this->registry); } public function evict($oid) { if ( ! isset($this->registry[$oid])) { return false; } unset($this->registry[$oid]); return true; } public function evictAll() { $evicted = 0; foreach ($this->registry as $oid=>$record) { if ($this->evict($oid)) { $evicted++; } } return $evicted; } public function getIterator() { return new ArrayIterator($this->registry); } public function contains($oid) { return isset($this->registry[$oid]); } public function loadAll() { $this->table->findAll(); } } class Doctrine_Table_Repository_Exception extends Doctrine_Exception { }class Doctrine_Table_Exception extends Doctrine_Exception { public function __construct($message = "Couldn't initialize table. One instance of this
                            table already exists. Always use Doctrine_Session::getTable(\$name)
                            to get on instance of a Doctrine_Table.") { parent::__construct($message); } }class Doctrine_Compiler_Exception extends Doctrine_Exception { }class Doctrine_Relation_Association extends Doctrine_Relation { private $tmp_rec; public function getAssociationFactory() { return $this->definition['refTable']; } public function getAssociationTable() { return $this->definition['refTable']; } public function getRelationDql($count, $context = 'record') { $table = $this->definition['refTable']; $component = $this->definition['refTable']->getComponentName(); switch ($context) { case "record": $sub = substr(str_repeat("?, ", $count),0,-2); $dql = 'FROM ' . $this->getTable()->getComponentName(); $dql .= '.' . $component; $dql .= ' WHERE ' . $this->getTable()->getComponentName() . '.' . $component . '.' . $this->getLocalRefColumnName() . ' IN (' . $sub . ')'; $dql .= $this->getOrderBy($this->getTable()->getComponentName(), false); break; case "collection": $sub = substr(str_repeat("?, ", $count),0,-2); $dql = 'FROM ' . $component . '.' . $this->getTable()->getComponentName(); $dql .= ' WHERE ' . $component . '.' . $this->getLocalRefColumnName() . ' IN (' . $sub . ')'; $dql .= $this->getOrderBy($component, false); break; } return $dql; } final public function getLocalRefColumnName() { return $this->definition['refTable']->getColumnName($this->definition['local']); } final public function getLocalRefFieldName() { return $this->definition['refTable']->getFieldName($this->definition['local']); } final public function getForeignRefColumnName() { return $this->definition['refTable']->getColumnName($this->definition['foreign']); } final public function getForeignRefFieldName() { return $this->definition['refTable']->getFieldName($this->definition['foreign']); } public function fetchRelatedFor(Doctrine_Record $record) { $id = -1; try { $recId = $record->get($this->getLocalRefFieldName()); if($recId) $id = $recId; else $id = $record->getIncremented(); } catch(Exception $e) { $id = $record->getIncremented(); } $this->tmp_rec = $record; if (empty($id) || ! $this->definition['table']->getAttribute(Doctrine_Core::ATTR_LOAD_REFERENCES)) { $coll = Doctrine_Collection::create($this->getTable()); } else { $coll = $this->getTable()->getConnection()->query($this->getRelationDql(1), array($id)); } $coll->setReference($record, $this); return $coll; } } class Doctrine_Relation_Nest extends Doctrine_Relation_Association { public function fetchRelatedFor(Doctrine_Record $record) { $id = $record->getIncremented(); if (empty($id) || ! $this->definition['table']->getAttribute(Doctrine_Core::ATTR_LOAD_REFERENCES)) { return Doctrine_Collection::create($this->getTable()); } else { $q = new Doctrine_RawSql($this->getTable()->getConnection()); $formatter = $q->getConnection()->formatter; $assocTable = $this->getAssociationFactory()->getTableName(); $tableName = $record->getTable()->getTableName(); $identifierColumnNames = $record->getTable()->getIdentifierColumnNames(); $identifier = $formatter->quoteIdentifier(array_pop($identifierColumnNames)); $sub = 'SELECT ' . $formatter->quoteIdentifier($this->getForeignRefColumnName()) . ' FROM ' . $formatter->quoteIdentifier($assocTable) . ' WHERE ' . $formatter->quoteIdentifier($this->getLocalRefColumnName()) . ' = ?'; $condition[] = $formatter->quoteIdentifier($tableName) . '.' . $identifier . ' IN (' . $sub . ')'; $joinCondition[] = $formatter->quoteIdentifier($tableName) . '.' . $identifier . ' = ' . $formatter->quoteIdentifier($assocTable) . '.' . $formatter->quoteIdentifier($this->getForeignRefColumnName()); if ($this->definition['equal']) { $sub2 = 'SELECT ' . $formatter->quoteIdentifier($this->getLocalRefColumnName()) . ' FROM ' . $formatter->quoteIdentifier($assocTable) . ' WHERE ' . $formatter->quoteIdentifier($this->getForeignRefColumnName()) . ' = ?'; $condition[] = $formatter->quoteIdentifier($tableName) . '.' . $identifier . ' IN (' . $sub2 . ')'; $joinCondition[] = $formatter->quoteIdentifier($tableName) . '.' . $identifier . ' = ' . $formatter->quoteIdentifier($assocTable) . '.' . $formatter->quoteIdentifier($this->getLocalRefColumnName()); } $q->select('{'.$tableName.'.*}, {'.$assocTable.'.*}') ->from($formatter->quoteIdentifier($tableName) . ' INNER JOIN ' . $formatter->quoteIdentifier($assocTable) . ' ON ' . implode(' OR ', $joinCondition)) ->where(implode(' OR ', $condition)); if ($orderBy = $this->getOrderByStatement($tableName, true)) { $q->addOrderBy($orderBy); } else { $q->addOrderBy($formatter->quoteIdentifier($tableName) . '.' . $identifier . ' ASC'); } $q->addComponent($tableName, $this->getClass()); $path = $this->getClass(). '.' . $this->getAssociationFactory()->getComponentName(); if ($this->definition['refClassRelationAlias']) { $path = $this->getClass(). '.' . $this->definition['refClassRelationAlias']; } $q->addComponent($assocTable, $path); $params = ($this->definition['equal']) ? array($id, $id) : array($id); $res = $q->execute($params); return $res; } } } class Doctrine_Relation_Exception extends Doctrine_Exception { }class Doctrine_Relation_Parser_Exception extends Doctrine_Relation_Exception { }class Doctrine_Relation_Parser { protected $_table; protected $_relations = array(); protected $_pending = array(); public function __construct(Doctrine_Table $table) { $this->_table = $table; } public function getTable() { return $this->_table; } public function getPendingRelation($name) { if ( ! isset($this->_pending[$name])) { throw new Doctrine_Relation_Exception('Unknown pending relation ' . $name); } return $this->_pending[$name]; } public function getPendingRelations() { return $this->_pending; } public function unsetPendingRelations($name) { unset($this->_pending[$name]); } public function hasRelation($name) { if ( ! isset($this->_pending[$name]) && ! isset($this->_relations[$name])) { return false; } return true; } public function bind($name, $options = array()) { $e = explode(' as ', $name); $e = array_map('trim', $e); $name = $e[0]; $alias = isset($e[1]) ? $e[1] : $name; if ( ! isset($options['type'])) { throw new Doctrine_Relation_Exception('Relation type not set.'); } if ($this->hasRelation($alias)) { unset($this->_relations[$alias]); unset($this->_pending[$alias]); } $this->_pending[$alias] = array_merge($options, array('class' => $name, 'alias' => $alias)); return $this->_pending[$alias]; } public function getRelation($alias, $recursive = true) { if (isset($this->_relations[$alias])) { return $this->_relations[$alias]; } if (isset($this->_pending[$alias])) { $def = $this->_pending[$alias]; $identifierColumnNames = $this->_table->getIdentifierColumnNames(); $idColumnName = array_pop($identifierColumnNames); if(isset($def['idField'])) $idColumnName = $def['idField']; if (isset($def['refClass'])) { $def = $this->completeAssocDefinition($def); $localClasses = array_merge($this->_table->getOption('parents'), array($this->_table->getComponentName())); $backRefRelationName = isset($def['refClassRelationAlias']) ? $def['refClassRelationAlias'] : $def['refClass']; if ( ! isset($this->_pending[$backRefRelationName]) && ! isset($this->_relations[$backRefRelationName])) { $parser = $def['refTable']->getRelationParser(); if ( ! $parser->hasRelation($this->_table->getComponentName())) { $parser->bind($this->_table->getComponentName(), array('type' => Doctrine_Relation::ONE, 'local' => $def['local'], 'foreign' => $idColumnName, 'localKey' => true, )); } if ( ! $this->hasRelation($backRefRelationName)) { if (in_array($def['class'], $localClasses)) { $this->bind($def['refClass'] . " as " . $backRefRelationName, array( 'type' => Doctrine_Relation::MANY, 'foreign' => $def['foreign'], 'local' => $idColumnName)); } else { $this->bind($def['refClass'] . " as " . $backRefRelationName, array( 'type' => Doctrine_Relation::MANY, 'foreign' => $def['local'], 'local' => $idColumnName)); } } } if (in_array($def['class'], $localClasses)) { $rel = new Doctrine_Relation_Nest($def); } else { $rel = new Doctrine_Relation_Association($def); } } else { $def = $this->completeDefinition($def); if (isset($def['localKey']) && $def['localKey']) { $rel = new Doctrine_Relation_LocalKey($def); $foreign = (array) $def['foreign']; foreach ($foreign as $fk) { if ( ! $rel['table']->isIdentifier($rel['table']->getFieldName($fk))) { $rel['table']->addIndex($fk, array('fields' => array($fk))); } } } else { $rel = new Doctrine_Relation_ForeignKey($def); } } if (isset($rel)) { unset($this->_pending[$alias]); $this->_relations[$alias] = $rel; return $rel; } } if ($recursive) { $this->getRelations(); return $this->getRelation($alias, false); } else { throw new Doctrine_Table_Exception('Unknown relation alias ' . $alias); } } public function getRelations() { foreach ($this->_pending as $k => $v) { $this->getRelation($k); } return $this->_relations; } public function getImpl($template) { $conn = $this->_table->getConnection(); if (class_exists($template) && in_array('Doctrine_Template', class_parents($template))) { $impl = $this->_table->getImpl($template); if ($impl === null) { throw new Doctrine_Relation_Parser_Exception("Couldn't find concrete implementation for template " . $template); } } else { $impl = $template; } return $conn->getTable($impl); } public function completeAssocDefinition($def) { $conn = $this->_table->getConnection(); $def['table'] = $this->getImpl($def['class']); $def['localTable'] = $this->_table; $def['class'] = $def['table']->getComponentName(); $def['refTable'] = $this->getImpl($def['refClass']); $id = $def['refTable']->getIdentifierColumnNames(); if (count($id) > 1) { if ( ! isset($def['foreign'])) { $def['foreign'] = ($def['local'] === $id[0]) ? $id[1] : $id[0]; } if ( ! isset($def['local'])) { $def['local'] = ($def['foreign'] === $id[0]) ? $id[1] : $id[0]; } } else { if ( ! isset($def['foreign'])) { $columns = $this->getIdentifiers($def['table']); $def['foreign'] = $columns; } if ( ! isset($def['local'])) { $columns = $this->getIdentifiers($this->_table); $def['local'] = $columns; } } return $def; } public function getIdentifiers(Doctrine_Table $table) { $componentNameToLower = strtolower($table->getComponentName()); if (is_array($table->getIdentifier())) { $columns = array(); foreach ((array) $table->getIdentifierColumnNames() as $identColName) { $columns[] = $componentNameToLower . '_' . $identColName; } } else { $columns = $componentNameToLower . '_' . $table->getColumnName( $table->getIdentifier()); } return $columns; } public function guessColumns(array $classes, Doctrine_Table $foreignTable) { $conn = $this->_table->getConnection(); foreach ($classes as $class) { try { $table = $conn->getTable($class); } catch (Doctrine_Table_Exception $e) { continue; } $columns = $this->getIdentifiers($table); $found = true; foreach ((array) $columns as $column) { if ( ! $foreignTable->hasColumn($column)) { $found = false; break; } } if ($found) { break; } } if ( ! $found) { throw new Doctrine_Relation_Exception("Couldn't find columns."); } return $columns; } public function completeDefinition($def) { $conn = $this->_table->getConnection(); $def['table'] = $this->getImpl($def['class']); $def['localTable'] = $this->_table; $def['class'] = $def['table']->getComponentName(); $foreignClasses = array_merge($def['table']->getOption('parents'), array($def['class'])); $localClasses = array_merge($this->_table->getOption('parents'), array($this->_table->getComponentName())); $localIdentifierColumnNames = $this->_table->getIdentifierColumnNames(); $localIdentifierCount = count($localIdentifierColumnNames); $localIdColumnName = array_pop($localIdentifierColumnNames); $foreignIdentifierColumnNames = $def['table']->getIdentifierColumnNames(); $foreignIdColumnName = array_pop($foreignIdentifierColumnNames); if (isset($def['local'])) { $def['local'] = $def['localTable']->getColumnName($def['local']); if ( ! isset($def['foreign'])) { if ($def['local'] === $localIdColumnName) { $def['foreign'] = $this->guessColumns($localClasses, $def['table']); } else { $def['foreign'] = $foreignIdColumnName; $def['localKey'] = true; } } else { $def['foreign'] = $def['table']->getColumnName($def['foreign']); if ($localIdentifierCount == 1) { if ($def['local'] == $localIdColumnName && isset($def['owningSide']) && $def['owningSide'] === true) { $def['localKey'] = true; } else if (($def['local'] !== $localIdColumnName && $def['type'] == Doctrine_Relation::ONE)) { $def['localKey'] = true; } } else if ($localIdentifierCount > 1 && ! isset($def['localKey'])) { $def['localKey'] = true; } } } else { if (isset($def['foreign'])) { $def['foreign'] = $def['table']->getColumnName($def['foreign']); if ($def['foreign'] === $foreignIdColumnName) { $def['localKey'] = true; try { $def['local'] = $this->guessColumns($foreignClasses, $this->_table); } catch (Doctrine_Relation_Exception $e) { $def['local'] = $localIdColumnName; } } else { $def['local'] = $localIdColumnName; } } else { $conn = $this->_table->getConnection(); foreach ($localClasses as $class) { $table = $conn->getTable($class); $identifierColumnNames = $table->getIdentifierColumnNames(); $idColumnName = array_pop($identifierColumnNames); $column = strtolower($table->getComponentName()) . '_' . $idColumnName; foreach ($foreignClasses as $class2) { $table2 = $conn->getTable($class2); if ($table2->hasColumn($column)) { $def['foreign'] = $column; $def['local'] = $idColumnName; return $def; } } } foreach ($foreignClasses as $class) { $table = $conn->getTable($class); $identifierColumnNames = $table->getIdentifierColumnNames(); $idColumnName = array_pop($identifierColumnNames); $column = strtolower($table->getComponentName()) . '_' . $idColumnName; foreach ($localClasses as $class2) { $table2 = $conn->getTable($class2); if ($table2->hasColumn($column)) { $def['foreign'] = $idColumnName; $def['local'] = $column; $def['localKey'] = true; return $def; } } } $columns = array(); foreach ((array) $this->_table->getIdentifierColumnNames() as $id) { $column = strtolower($table->getComponentName()) . '_' . $id; $col = $this->_table->getColumnDefinition($id); $type = $col['type']; $length = $col['length']; unset($col['type']); unset($col['length']); unset($col['autoincrement']); unset($col['sequence']); unset($col['primary']); $def['table']->setColumn($column, $type, $length, $col); $columns[] = $column; } if (count($columns) > 1) { $def['foreign'] = $columns; } else { $def['foreign'] = $columns[0]; } $def['local'] = $localIdColumnName; } } return $def; } } class Doctrine_Relation_ForeignKey extends Doctrine_Relation { private $tmp_rec; public function fetchRelatedFor(Doctrine_Record $record) { $this->tmp_rec = $record; $id = array(); $localTable = $record->getTable(); foreach ((array) $this->definition['local'] as $local) { $value = $record->get($localTable->getFieldName($local)); if (isset($value)) { $id[] = $value; } } if ($this->isOneToOne()) { if ( ! $record->exists() || empty($id) || ! $this->definition['table']->getAttribute(Doctrine_Core::ATTR_LOAD_REFERENCES)) { $related = $this->getTable()->create(); } else { $dql = 'FROM ' . $this->getTable()->getComponentName() . ' WHERE ' . $this->getCondition(); $dql .= $this->getOrderBy(null, false); $coll = $this->getTable()->getConnection()->query($dql, $id); $related = $coll[0]; } $related->set($related->getTable()->getFieldName($this->definition['foreign']), $record, false); } else { if ( ! $record->exists() || empty($id) || ! $this->definition['table']->getAttribute(Doctrine_Core::ATTR_LOAD_REFERENCES)) { $related = Doctrine_Collection::create($this->getTable()); } else { $query = $this->getRelationDql(1); $related = $this->getTable()->getConnection()->query($query, $id); } $related->setReference($record, $this); } return $related; } public function getRelationDql($count) { $component = $this->getTable()->getComponentName(); $dql = 'FROM ' . $component . ' WHERE ' . $component . '.' . $this->definition['foreign'] . ' IN (' . substr(str_repeat('?, ', $count), 0, -2) . ')'; $dql .= $this->getOrderBy($component); return $dql; } public function getCondition($alias = null) { if ( ! $alias) { $alias = $this->getTable()->getComponentName(); } $conditions = array(); foreach ((array) $this->definition['foreign'] as $foreign) { $conditions[] = $alias . '.' . $foreign . ' = ?'; } return implode(' AND ', $conditions); } } class Doctrine_Relation_Association_Self extends Doctrine_Relation_Association { public function getRelationDql($count, $context = 'record') { switch ($context) { case 'record': $identifierColumnNames = $this->definition['table']->getIdentifierColumnNames(); $identifier = array_pop($identifierColumnNames); $sub = 'SELECT '.$this->definition['foreign'] . ' FROM '.$this->definition['refTable']->getTableName() . ' WHERE '.$this->definition['local'] . ' = ?'; $sub2 = 'SELECT '.$this->definition['local'] . ' FROM '.$this->definition['refTable']->getTableName() . ' WHERE '.$this->definition['foreign'] . ' = ?'; $dql = 'FROM ' . $this->definition['table']->getComponentName() . '.' . $this->definition['refTable']->getComponentName() . ' WHERE ' . $this->definition['table']->getComponentName() . '.' . $identifier . ' IN (' . $sub . ')' . ' || ' . $this->definition['table']->getComponentName() . '.' . $identifier . ' IN (' . $sub2 . ')'; $dql .= $this->getOrderBy($this->definition['table']->getComponentName(), false); break; case 'collection': $sub = substr(str_repeat('?, ', $count),0,-2); $dql = 'FROM '.$this->definition['refTable']->getComponentName() . '.' . $this->definition['table']->getComponentName() . ' WHERE '.$this->definition['refTable']->getComponentName() . '.' . $this->definition['local'] . ' IN (' . $sub . ')'; $dql .= $this->getOrderBy($this->definition['refTable']->getComponentName(), false); }; return $dql; } public function fetchRelatedFor(Doctrine_Record $record) { $id = $record->getIncremented(); $q = new Doctrine_RawSql(); $assocTable = $this->getAssociationFactory()->getTableName(); $tableName = $record->getTable()->getTableName(); $identifierColumnNames = $record->getTable()->getIdentifierColumnNames(); $identifier = array_pop($identifierColumnNames); $sub = 'SELECT '.$this->getForeign(). ' FROM '.$assocTable. ' WHERE '.$this->getLocal(). ' = ?'; $sub2 = 'SELECT '.$this->getLocal(). ' FROM '.$assocTable. ' WHERE '.$this->getForeign(). ' = ?'; $q->select('{'.$tableName.'.*}, {'.$assocTable.'.*}') ->from($tableName . ' INNER JOIN '.$assocTable.' ON '. $tableName . '.' . $identifier . ' = ' . $assocTable . '.' . $this->getLocal() . ' OR ' . $tableName . '.' . $identifier . ' = ' . $assocTable . '.' . $this->getForeign() ) ->where($tableName.'.'.$identifier.' IN ('.$sub.') OR '. $tableName.'.'.$identifier.' IN ('.$sub2.')' ); $q->addComponent($tableName, $record->getTable()->getComponentName()); $q->addComponent($assocTable, $record->getTable()->getComponentName(). '.' . $this->getAssociationFactory()->getComponentName()); $q->orderBy($this->getOrderByStatement($tableName, true)); return $q->execute(array($id, $id)); } }class Doctrine_Relation_LocalKey extends Doctrine_Relation { public function fetchRelatedFor(Doctrine_Record $record) { $localFieldName = $record->getTable()->getFieldName($this->definition['local']); $id = $record->get($localFieldName); if (is_null($id) || ! $this->definition['table']->getAttribute(Doctrine_Core::ATTR_LOAD_REFERENCES)) { $related = $this->getTable()->create(); if ( ! is_null($id)) { $related->assignIdentifier($id); $related->state(Doctrine_Record::STATE_PROXY); } } else { $dql = 'FROM ' . $this->getTable()->getComponentName() . ' WHERE ' . $this->getCondition() . $this->getOrderBy(null, false); $related = $this->getTable() ->getConnection() ->query($dql, array($id)) ->getFirst(); if ( ! $related || empty($related)) { $related = $this->getTable()->create(); } } $record->set($localFieldName, $id, false); return $related; } public function getCondition($alias = null) { if ( ! $alias) { $alias = $this->getTable()->getComponentName(); } return $alias . '.' . $this->definition['foreign'] . ' = ?'; } } class Doctrine_Search_Analyzer implements Doctrine_Search_Analyzer_Interface { protected $_options = array(); public function __construct($options = array()) { $this->_options = $options; } public function analyze($text, $encoding = null) { return $text; } }class Doctrine_Search_Analyzer_Standard extends Doctrine_Search_Analyzer implements Doctrine_Search_Analyzer_Interface { protected static $_stopwords = array( 'a', 'about', 'after', 'all', 'almost', 'along', 'also', 'although', 'amp', 'an', 'and', 'another', 'any', 'are', 'area', 'arent', 'around', 'as', 'at', 'available', 'back', 'be', 'because', 'been', 'before', 'being', 'best', 'better', 'big', 'bit', 'both', 'but', 'by', 'c', 'came', 'can', 'capable', 'control', 'could', 'course', 'd', 'dan', 'day', 'decided', 'did', 'didn', 'different', 'div', 'do', 'doesn', 'don', 'down', 'drive', 'e', 'each', 'easily', 'easy', 'edition', 'either', 'end', 'enough', 'even', 'every', 'example', 'few', 'find', 'first', 'for', 'found', 'from', 'get', 'go', 'going', 'good', 'got', 'gt', 'had', 'hard', 'has', 'have', 'he', 'her', 'here', 'how', 'i', 'if', 'in', 'into', 'is', 'isn', 'it', 'just', 'know', 'last', 'left', 'li', 'like', 'little', 'll', 'long', 'look', 'lot', 'lt', 'm', 'made', 'make', 'many', 'mb', 'me', 'menu', 'might', 'mm', 'more', 'most', 'much', 'my', 'name', 'nbsp', 'need', 'new', 'no', 'not', 'now', 'number', 'of', 'off', 'old', 'on', 'one', 'only', 'or', 'original', 'other', 'our', 'out', 'over', 'part', 'place', 'point', 'pretty', 'probably', 'problem', 'put', 'quite', 'quot', 'r', 're', 'really', 'results', 'right', 's', 'same', 'saw', 'see', 'set', 'several', 'she', 'sherree', 'should', 'since', 'size', 'small', 'so', 'some', 'something', 'special', 'still', 'stuff', 'such', 'sure', 'system', 't', 'take', 'than', 'that', 'the', 'their', 'them', 'then', 'there', 'these', 'they', 'thing', 'things', 'think', 'this', 'those', 'though', 'through', 'time', 'to', 'today', 'together', 'too', 'took', 'two', 'up', 'us', 'use', 'used', 'using', 've', 'very', 'want', 'was', 'way', 'we', 'well', 'went', 'were', 'what', 'when', 'where', 'which', 'while', 'white', 'who', 'will', 'with', 'would', 'yet', 'you', 'your', 'yours' ); public function analyze($text, $encoding = null) { $text = preg_replace('/[\'`"]/', '', $text); $text = Doctrine_Inflector::unaccent($text); $text = preg_replace('/[^A-Za-z0-9]/', ' ', $text); $text = str_replace('  ', ' ', $text); $terms = explode(' ', $text); $ret = array(); if ( ! empty($terms)) { foreach ($terms as $i => $term) { if (empty($term)) { continue; } $lower = strtolower(trim($term)); if (in_array($lower, self::$_stopwords)) { continue; } $ret[$i] = $lower; } } return $ret; } } class Doctrine_Search_Exception extends Doctrine_Exception { }class Doctrine_Search_Analyzer_Exception extends Doctrine_Search_Exception { }class Doctrine_Search_Analyzer_Utf8 extends Doctrine_Search_Analyzer_Standard { public function analyze($text, $encoding = null) { if (is_null($encoding)) { $encoding = isset($this->_options['encoding']) ? $this->_options['encoding']:'utf-8'; } if (strcasecmp($encoding, 'utf-8') != 0 && strcasecmp($encoding, 'utf8') != 0) { $text = iconv($encoding, 'UTF-8', $text); } $text = preg_replace('/[^\p{L}\p{N}]+/u', ' ', $text); $text = str_replace('  ', ' ', $text); $terms = explode(' ', $text); $ret = array(); if ( ! empty($terms)) { foreach ($terms as $i => $term) { if (empty($term)) { continue; } $lower = mb_strtolower(trim($term), 'UTF-8'); if (in_array($lower, self::$_stopwords)) { continue; } $ret[$i] = $lower; } } return $ret; } }class Doctrine_Search_Indexer { public function indexDirectory($dir) { if ( ! file_exists($dir)) { throw new Doctrine_Search_Indexer_Exception('Unknown directory ' . $dir); } $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir), RecursiveIteratorIterator::LEAVES_ONLY); $files = array(); foreach ($it as $file) { $name = $file->getPathName(); if (strpos($name, '.svn') === false) { $files[] = $name; } } $q = Doctrine_Core::getTable('Doctrine_File') ->createQuery('f') ->delete() ->where('f.url LIKE ?', array($dir . '%')) ->execute(); $q = Doctrine_Core::getTable('Doctrine_File_Index') ->createQuery('i') ->where('i.file_id = ?') ->execute(); $coll = Doctrine_Collection::create('Doctrine_File'); foreach ($files as $file) { $coll[]->url = $file; } $coll->save(); } }class Doctrine_Search extends Doctrine_Record_Generator { const INDEX_FILES = 0; const INDEX_TABLES = 1; protected $_options = array('generateFiles' => false, 'analyzer' => 'Doctrine_Search_Analyzer_Standard', 'analyzer_options' => array(), 'type' => self::INDEX_TABLES, 'className' => '%CLASS%Index', 'generatePath' => false, 'table' => null, 'batchUpdates' => false, 'pluginTable' => false, 'fields' => array(), 'connection' => null, 'children' => array(), 'cascadeDelete' => true, 'appLevelDelete' => false); public function __construct(array $options) { $this->_options = Doctrine_Lib::arrayDeepMerge($this->_options, $options); if ( ! isset($this->_options['analyzer'])) { $this->_options['analyzer'] = 'Doctrine_Search_Analyzer_Standard'; } if ( ! isset($this->_options['analyzer_options'])) { $this->_options['analyzer_options'] = array(); } $this->_options['analyzer'] = new $this->_options['analyzer']($this->_options['analyzer_options']); } public function buildTable() { $result = parent::buildTable(); if ( ! isset($this->_options['connection'])) { $manager = Doctrine_Manager::getInstance(); $this->_options['connection'] = $manager->getConnectionForComponent($this->_options['table']->getComponentName()); $manager->bindComponent($this->_options['className'], $this->_options['connection']->getName()); } return $result; } public function search($string, $query = null) { $q = new Doctrine_Search_Query($this->_table); if ($query instanceof Doctrine_Query) { $q->query($string, false); $newQuery = $query->copy(); $query->getSqlQuery(); $key = (array) $this->getOption('table')->getIdentifier(); $newQuery->addWhere($query->getRootAlias() . '.'.current($key).' IN (SQL:' . $q->getSqlQuery() . ')', $q->getParams()); return $newQuery; } else { if ( ! isset($this->_options['connection'])) { $this->_options['connection'] = $this->_table->getConnection(); } $q->query($string); return $this->_options['connection']->fetchAll($q->getSqlQuery(), $q->getParams()); } } public function analyze($text, $encoding = null) { return $this->_options['analyzer']->analyze($text, $encoding); } public function updateIndex(array $data, $encoding = null) { $this->initialize($this->_options['table']); $fields = $this->getOption('fields'); $class = $this->getOption('className'); $name = $this->getOption('table')->getComponentName(); $conn = $this->getOption('table')->getConnection(); $identifier = $this->_options['table']->getIdentifier(); $q = Doctrine_Core::getTable($class) ->createQuery() ->delete(); foreach ((array) $identifier as $id) { $q->addWhere($id . ' = ?', array($data[$id])); } $q->execute(); if ($this->_options['batchUpdates'] === true) { $index = new $class(); foreach ((array) $this->_options['table']->getIdentifier() as $id) { $index->$id = $data[$id]; } $index->save(); } else { foreach ($fields as $field) { $value = isset($data[$field]) ? $data[$field] : null; $terms = $this->analyze($value, $encoding); foreach ($terms as $pos => $term) { $index = new $class(); $index->keyword = $term; $index->position = $pos; $index->field = $field; foreach ((array) $this->_options['table']->getIdentifier() as $id) { $index->$id = $data[$id]; } $index->save(); $index->free(true); } } } } public function readTableData($limit = null, $offset = null) { $this->initialize($this->_options['table']); $conn = $this->_options['table']->getConnection(); $tableName = $this->_options['table']->getTableName(); $id = current($this->_options['table']->getIdentifierColumnNames()); $tableId = current($this->_table->getIdentifierColumnNames()); $query = 'SELECT * FROM ' . $conn->quoteIdentifier($tableName) . ' WHERE ' . $conn->quoteIdentifier($id) . ' IN (SELECT ' . $conn->quoteIdentifier($tableId) . ' FROM ' . $conn->quoteIdentifier($this->_table->getTableName()) . ' WHERE keyword = \'\') OR ' . $conn->quoteIdentifier($id) . ' NOT IN (SELECT ' . $conn->quoteIdentifier($tableId) . ' FROM ' . $conn->quoteIdentifier($this->_table->getTableName()) . ')'; $query = $conn->modifyLimitQuery($query, $limit, $offset); return $conn->fetchAll($query); } public function batchUpdateIndex($limit = null, $offset = null, $encoding = null) { $table = $this->_options['table']; $this->initialize($table); $id = $table->getIdentifierColumnNames(); $class = $this->_options['className']; $fields = $this->_options['fields']; $conn = $this->_options['table']->getConnection(); for ($i = 0; $i < count($fields); $i++) { $fields[$i] = $table->getColumnName($fields[$i], $fields[$i]); } $rows = $this->readTableData($limit, $offset); $ids = array(); foreach ($rows as $row) { foreach ($id as $idcol) { $ids[] = $row[$idcol]; } } if (count($ids) > 0) { $sql = 'DELETE FROM ' . $conn->quoteIdentifier($this->_table->getTableName()); if (count($id) == 1) { $placeholders = str_repeat('?, ', count($ids)); $placeholders = substr($placeholders, 0, strlen($placeholders) - 2); $sql .= ' WHERE ' . $conn->quoteIdentifier($table->getIdentifier()) . ' IN (' . substr($placeholders, 0) . ')'; } else { $placeholders = ''; foreach ($table->getIdentifier() as $id) { $placeholders .= $conn->quoteIdentifier($id) . ' = ? AND '; } $placeholders = '(' . substr($placeholders, 0, strlen($placeholders) - 5) . ') OR '; $placeholders = str_repeat($placeholders, count($rows)); $placeholders = substr($placeholders, 0, strlen($placeholders) - 4); $sql .= ' WHERE ' . $placeholders; } $conn->exec($sql, $ids); } foreach ($rows as $row) { $conn->beginTransaction(); try { foreach ($fields as $field) { $data = $row[$field]; $terms = $this->analyze($data, $encoding); foreach ($terms as $pos => $term) { $index = new $class(); $index->keyword = $term; $index->position = $pos; $index->field = $field; foreach ((array) $table->getIdentifier() as $identifier) { $index->$identifier = $row[$table->getColumnName($identifier, $identifier)]; } $index->save(); $index->free(true); } } $conn->commit(); } catch (Doctrine_Exception $e) { $conn->rollback(); throw $e; } } } public function setTableDefinition() { if ( ! isset($this->_options['table'])) { throw new Doctrine_Record_Exception("Unknown option 'table'."); } $componentName = $this->_options['table']->getComponentName(); $className = $this->getOption('className'); $autoLoad = (bool) ($this->_options['generateFiles']); if (class_exists($className, $autoLoad)) { return false; } $previousIdentifier = array(); foreach ($this->_table->getIdentifier() as $name) { $previousIdentifier[$name] = $this->_table->getColumnDefinition($name); $this->_table->removeColumn($name); } $columns = array('keyword' => array('type' => 'string', 'length' => 200, 'primary' => true, ), 'field' => array('type' => 'string', 'length' => 50, 'primary' => true), 'position' => array('type' => 'integer', 'length' => 8, 'primary' => true, )); $this->hasColumns($columns); $this->hasColumns($previousIdentifier); } } class Doctrine_Search_File extends Doctrine_Search { public function __construct(array $options = array()) { parent::__construct($options); if ( ! isset($this->_options['resource'])) { $conn = Doctrine_Manager::connection(); $tableClass = $conn->getAttribute(Doctrine_Core::ATTR_TABLE_CLASS); $table = new $tableClass('File', $conn); $table->setColumn('url', 'string', 255, array('primary' => true)); } if (empty($this->_options['fields'])) { $this->_options['fields'] = array('url', 'content'); } $this->initialize($table); } public function buildRelation() { } public function indexDirectory($dir) { $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir), RecursiveIteratorIterator::LEAVES_ONLY); foreach ($it as $file) { if (strpos($file, DIRECTORY_SEPARATOR . '.svn') !== false) { continue; } $this->updateIndex(array('url' => $file->getPathName(), 'content' => file_get_contents($file))); } } } class Doctrine_Search_Indexer_Dir { public function add($dir) { if ( ! file_exists($dir)) { throw new Doctrine_Search_Indexer_Exception('Unknown directory ' . $dir); } $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir), RecursiveIteratorIterator::LEAVES_ONLY); foreach ($it as $file) { $this->indexFile($file); } } }class Doctrine_Search_Indexer_Exception extends Doctrine_Search_Exception { }class Doctrine_Search_Query { protected $_table = array(); protected $_sql = ''; protected $_params = array(); protected $_words = array(); protected $_tokenizer; protected $_condition; public function __construct($table) { if (is_string($table)) { $table = Doctrine_Core::getTable($table); } else { if ( ! $table instanceof Doctrine_Table) { throw new Doctrine_Search_Exception('Invalid argument type. Expected instance of Doctrine_Table.'); } } $this->_tokenizer = new Doctrine_Query_Tokenizer(); $this->_table = $table; $foreignId = current(array_diff($this->_table->getColumnNames(), array('keyword', 'field', 'position'))); $this->_condition = $foreignId . ' %s (SELECT ' . $foreignId . ' FROM ' . $this->_table->getTableName() . ' WHERE '; } public function query($text, $includeRelevance = true) { $text = trim($text); $foreignId = current(array_diff($this->_table->getColumnNames(), array('keyword', 'field', 'position'))); $weighted = false; if (strpos($text, '^') === false) { if ($includeRelevance) { $select = 'SELECT COUNT(keyword) AS relevance, ' . $foreignId; } else { $select = 'SELECT ' . $foreignId; } } else { if ($includeRelevance) { $select = 'SELECT SUM(sub_relevance) AS relevance, ' . $foreignId; } else { $select = 'SELECT ' . $foreignId; } } $from = 'FROM ' . $this->_table->getTableName(); $where = 'WHERE '; $where .= $this->parseClause($text); $groupby = 'GROUP BY ' . $foreignId; if ($includeRelevance) { $orderBy = 'ORDER BY relevance DESC'; } else { $orderBy = null; } $this->_sql = $select . ' ' . $from . ' ' . $where . ' ' . $groupby; if (isset($orderBy) && $orderBy !== null) { $this->_sql .= ' ' . $orderBy; } } public function parseClause($originalClause, $recursive = false) { $clause = $this->_tokenizer->bracketTrim($originalClause); $brackets = false; if ($clause !== $originalClause) { $brackets = true; } $foreignId = current(array_diff($this->_table->getColumnNames(), array('keyword', 'field', 'position'))); $terms = $this->_tokenizer->sqlExplode($clause, ' OR ', '(', ')'); $ret = array(); if (count($terms) > 1) { $leavesOnly = true; foreach ($terms as $k => $term) { if ($this->isExpression($term)) { $ret[$k] = $this->parseClause($term, true); $leavesOnly = false; } else { $ret[$k] = $this->parseTerm($term); } } $return = implode(' OR ', $ret); if ($leavesOnly && $recursive) { $return = sprintf($this->_condition, 'IN') . $return . ')'; $brackets = false; } } else { $terms = $this->_tokenizer->sqlExplode($clause, ' ', '(', ')'); if (count($terms) === 1 && ! $recursive) { $return = $this->parseTerm($clause); } else { foreach ($terms as $k => $term) { $term = trim($term); if ($term === 'AND') { continue; } if (substr($term, 0, 1) === '-') { $operator = 'NOT IN'; $term = substr($term, 1); } else { $operator = 'IN'; } if ($this->isExpression($term)) { $ret[$k] = $this->parseClause($term, true); } else { $ret[$k] = sprintf($this->_condition, $operator) . $this->parseTerm($term) . ')'; } } $return = implode(' AND ', $ret); } } if ($brackets) { return '(' . $return . ')'; } else { return $return; } } public function isExpression($term) { if (strpos($term, '(') !== false) { return true; } else { $terms = $this->_tokenizer->quoteExplode($term); return (count($terms) > 1); } } public function parseTerm($term) { $negation = false; if (strpos($term, "'") === false) { $where = $this->parseWord($term); } else { $term = trim($term, "' "); $terms = $this->_tokenizer->quoteExplode($term); $where = $this->parseWord($terms[0]); foreach ($terms as $k => $word) { if ($k === 0) { continue; } $where .= ' AND (position + ' . $k . ') IN (SELECT position FROM ' . $this->_table->getTableName() . ' WHERE ' . $this->parseWord($word) . ')'; } } return $where; } public function parseWord($word) { $this->_words[] = str_replace('*', '', $word); if (strpos($word, '?') !== false || strpos($word, '*') !== false) { $word = str_replace('*', '%', $word); $where = 'keyword LIKE ?'; $params = array($word); } else { $where = 'keyword = ?'; } $this->_params[] = $word; return $where; } public function getWords() { return $this->_words; } public function getParams() { return $this->_params; } public function getSqlQuery() { return $this->_sql; } }class Doctrine_Search_Parser { public function parse($file) { $contents = file_get_contents($file); return array('url' => $file, 'contents' => $contents); } }class Doctrine_Search_Listener extends Doctrine_Record_Listener { protected $_search; public function __construct(Doctrine_Search $search) { $this->_search = $search; } public function preUpdate(Doctrine_Event $event) { } public function postUpdate(Doctrine_Event $event) { $record = $event->getInvoker(); $this->_search->updateIndex($record->toArray()); } public function postInsert(Doctrine_Event $event) { $record = $event->getInvoker(); $this->_search->updateIndex($record->toArray()); } }class Doctrine_Search_Record extends Doctrine_Template { public function setTableDefinition() { $this->hasColumn('keyword', 'string', 250, array('notnull' => true)); $this->hasColumn('field', 'string', 50, array('notnull' => true)); $this->hasColumn('position', 'integer', 8); } public function setUp() { $this->hasOne('[Component]', array('onDelete' => 'CASCADE')); } }class Doctrine_Export extends Doctrine_Connection_Module { protected $valid_default_values = array( 'text' => '', 'boolean' => true, 'integer' => 0, 'decimal' => 0.0, 'float' => 0.0, 'timestamp' => '1970-01-01 00:00:00', 'time' => '00:00:00', 'date' => '1970-01-01', 'clob' => '', 'blob' => '', 'string' => '' ); public function dropDatabase($database) { foreach ((array) $this->dropDatabaseSql($database) as $query) { $this->conn->execute($query); } } public function dropDatabaseSql($database) { throw new Doctrine_Export_Exception('Drop database not supported by this driver.'); } public function dropTableSql($table) { return 'DROP TABLE ' . $this->conn->quoteIdentifier($table); } public function dropTable($table) { $this->conn->execute($this->dropTableSql($table)); } public function dropIndex($table, $name) { return $this->conn->exec($this->dropIndexSql($table, $name)); } public function dropIndexSql($table, $name) { $name = $this->conn->quoteIdentifier($this->conn->formatter->getIndexName($name)); return 'DROP INDEX ' . $name; } public function dropConstraint($table, $name, $primary = false) { $table = $this->conn->quoteIdentifier($table); $name = $this->conn->quoteIdentifier($name); return $this->conn->exec('ALTER TABLE ' . $table . ' DROP CONSTRAINT ' . $name); } public function dropForeignKey($table, $name) { return $this->dropConstraint($table, $this->conn->formatter->getForeignKeyName($name)); } public function dropSequence($sequenceName) { $this->conn->exec($this->dropSequenceSql($sequenceName)); } public function dropSequenceSql($sequenceName) { throw new Doctrine_Export_Exception('Drop sequence not supported by this driver.'); } public function createDatabase($database) { $this->conn->execute($this->createDatabaseSql($database)); } public function createDatabaseSql($database) { throw new Doctrine_Export_Exception('Create database not supported by this driver.'); } public function createTableSql($name, array $fields, array $options = array()) { if ( ! $name) { throw new Doctrine_Export_Exception('no valid table name specified'); } if (empty($fields)) { throw new Doctrine_Export_Exception('no fields specified for table ' . $name); } $queryFields = $this->getFieldDeclarationList($fields); if (isset($options['primary']) && ! empty($options['primary'])) { $primaryKeys = array_map(array($this->conn, 'quoteIdentifier'), array_values($options['primary'])); $queryFields .= ', PRIMARY KEY(' . implode(', ', $primaryKeys) . ')'; } if (isset($options['indexes']) && ! empty($options['indexes'])) { foreach($options['indexes'] as $index => $definition) { $indexDeclaration = $this->getIndexDeclaration($index, $definition); if ( ! is_null($indexDeclaration)) { $queryFields .= ', '.$indexDeclaration; } } } $query = 'CREATE TABLE ' . $this->conn->quoteIdentifier($name, true) . ' (' . $queryFields; $check = $this->getCheckDeclaration($fields); if ( ! empty($check)) { $query .= ', ' . $check; } $query .= ')'; $sql[] = $query; if (isset($options['foreignKeys'])) { foreach ((array) $options['foreignKeys'] as $k => $definition) { if (is_array($definition)) { $sql[] = $this->createForeignKeySql($name, $definition); } } } return $sql; } public function createTable($name, array $fields, array $options = array()) { $count = 0; foreach ($fields as $fieldName => $field) { if (isset($field['primary']) && $field['primary']) { if ($count == 0) { $options['primary'] = array(); } $count++; $options['primary'][] = $fieldName; } } $sql = (array) $this->createTableSql($name, $fields, $options); foreach ($sql as $query) { $this->conn->execute($query); } } public function createSequence($seqName, $start = 1, array $options = array()) { return $this->conn->execute($this->createSequenceSql($seqName, $start = 1, $options)); } public function createSequenceSql($seqName, $start = 1, array $options = array()) { throw new Doctrine_Export_Exception('Create sequence not supported by this driver.'); } public function createConstraint($table, $name, $definition) { $sql = $this->createConstraintSql($table, $name, $definition); return $this->conn->exec($sql); } public function createConstraintSql($table, $name, $definition) { $table = $this->conn->quoteIdentifier($table); $name = $this->conn->quoteIdentifier($this->conn->formatter->getIndexName($name)); $query = 'ALTER TABLE ' . $table . ' ADD CONSTRAINT ' . $name; if (isset($definition['primary']) && $definition['primary']) { $query .= ' PRIMARY KEY'; } elseif (isset($definition['unique']) && $definition['unique']) { $query .= ' UNIQUE'; } $fields = array(); foreach (array_keys($definition['fields']) as $field) { $fields[] = $this->conn->quoteIdentifier($field, true); } $query .= ' ('. implode(', ', $fields) . ')'; return $query; } public function createIndex($table, $name, array $definition) { return $this->conn->execute($this->createIndexSql($table, $name, $definition)); } public function createIndexSql($table, $name, array $definition) { $table = $this->conn->quoteIdentifier($table); $name = $this->conn->quoteIdentifier($name); $type = ''; if (isset($definition['type'])) { switch (strtolower($definition['type'])) { case 'unique': $type = strtoupper($definition['type']) . ' '; break; default: throw new Doctrine_Export_Exception( 'Unknown type ' . $definition['type'] . ' for index ' . $name . ' in table ' . $table ); } } $query = 'CREATE ' . $type . 'INDEX ' . $name . ' ON ' . $table; $fields = array(); foreach ($definition['fields'] as $field) { $fields[] = $this->conn->quoteIdentifier($field); } $query .= ' (' . implode(', ', $fields) . ')'; return $query; } public function createForeignKeySql($table, array $definition) { $table = $this->conn->quoteIdentifier($table); $query = 'ALTER TABLE ' . $table . ' ADD ' . $this->getForeignKeyDeclaration($definition); return $query; } public function createForeignKey($table, array $definition) { $sql = $this->createForeignKeySql($table, $definition); return $this->conn->execute($sql); } public function alterTable($name, array $changes, $check = false) { $sql = $this->alterTableSql($name, $changes, $check); if (is_string($sql) && $sql) { $this->conn->execute($sql); } } public function alterTableSql($name, array $changes, $check = false) { throw new Doctrine_Export_Exception('Alter table not supported by this driver.'); } public function getFieldDeclarationList(array $fields) { foreach ($fields as $fieldName => $field) { $query = $this->getDeclaration($fieldName, $field); $queryFields[] = $query; } return implode(', ', $queryFields); } public function getDeclaration($name, array $field) { $default = $this->getDefaultFieldDeclaration($field); $charset = (isset($field['charset']) && $field['charset']) ? ' ' . $this->getCharsetFieldDeclaration($field['charset']) : ''; $collation = (isset($field['collation']) && $field['collation']) ? ' ' . $this->getCollationFieldDeclaration($field['collation']) : ''; $notnull = $this->getNotNullFieldDeclaration($field); $unique = (isset($field['unique']) && $field['unique']) ? ' ' . $this->getUniqueFieldDeclaration() : ''; $check = (isset($field['check']) && $field['check']) ? ' ' . $field['check'] : ''; $method = 'get' . $field['type'] . 'Declaration'; try { if (method_exists($this->conn->dataDict, $method)) { return $this->conn->dataDict->$method($name, $field); } else { $dec = $this->conn->dataDict->getNativeDeclaration($field); } return $this->conn->quoteIdentifier($name, true) . ' ' . $dec . $charset . $default . $notnull . $unique . $check . $collation; } catch (Exception $e) { throw new Doctrine_Exception('Around field ' . $name . ': ' . $e->getMessage()); } } public function getDefaultFieldDeclaration($field) { $default = ''; if (array_key_exists('default', $field)) { if ($field['default'] === '') { $field['default'] = empty($field['notnull']) ? null : $this->valid_default_values[$field['type']]; if ($field['default'] === '' && ($this->conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_EMPTY_TO_NULL)) { $field['default'] = null; } } if ($field['type'] === 'boolean') { $field['default'] = $this->conn->convertBooleans($field['default']); } $default = ' DEFAULT ' . (is_null($field['default']) ? 'NULL' : $this->conn->quote($field['default'], $field['type'])); } return $default; } public function getNotNullFieldDeclaration(array $definition) { return (isset($definition['notnull']) && $definition['notnull']) ? ' NOT NULL' : ''; } public function getCheckDeclaration(array $definition) { $constraints = array(); foreach ($definition as $field => $def) { if (is_string($def)) { $constraints[] = 'CHECK (' . $def . ')'; } else { if (isset($def['min'])) { $constraints[] = 'CHECK (' . $field . ' >= ' . $def['min'] . ')'; } if (isset($def['max'])) { $constraints[] = 'CHECK (' . $field . ' <= ' . $def['max'] . ')'; } } } return implode(', ', $constraints); } public function getIndexDeclaration($name, array $definition) { $name = $this->conn->quoteIdentifier($name); $type = ''; if (isset($definition['type'])) { if (strtolower($definition['type']) == 'unique') { $type = strtoupper($definition['type']) . ' '; } else { throw new Doctrine_Export_Exception( 'Unknown type ' . $definition['type'] . ' for index ' . $name ); } } if ( ! isset($definition['fields']) || ! is_array($definition['fields'])) { throw new Doctrine_Export_Exception('No columns given for index ' . $name); } $query = $type . 'INDEX ' . $name; $query .= ' (' . $this->getIndexFieldDeclarationList($definition['fields']) . ')'; return $query; } public function getIndexFieldDeclarationList(array $fields) { $ret = array(); foreach ($fields as $field => $definition) { if (is_array($definition)) { $ret[] = $this->conn->quoteIdentifier($field); } else { $ret[] = $this->conn->quoteIdentifier($definition); } } return implode(', ', $ret); } public function getTemporaryTableQuery() { return 'TEMPORARY'; } public function getForeignKeyDeclaration(array $definition) { $sql = $this->getForeignKeyBaseDeclaration($definition); $sql .= $this->getAdvancedForeignKeyOptions($definition); return $sql; } public function getAdvancedForeignKeyOptions(array $definition) { $query = ''; if ( ! empty($definition['onUpdate'])) { $query .= ' ON UPDATE ' . $this->getForeignKeyReferentialAction($definition['onUpdate']); } if ( ! empty($definition['onDelete'])) { $query .= ' ON DELETE ' . $this->getForeignKeyReferentialAction($definition['onDelete']); } return $query; } public function getForeignKeyReferentialAction($action) { $upper = strtoupper($action); switch ($upper) { case 'CASCADE': case 'SET NULL': case 'NO ACTION': case 'RESTRICT': case 'SET DEFAULT': return $upper; break; default: throw new Doctrine_Export_Exception('Unknown foreign key referential action \'' . $upper . '\' given.'); } } public function getForeignKeyBaseDeclaration(array $definition) { $sql = ''; if (isset($definition['name'])) { $sql .= 'CONSTRAINT ' . $this->conn->quoteIdentifier($this->conn->formatter->getForeignKeyName($definition['name'])) . ' '; } $sql .= 'FOREIGN KEY ('; if ( ! isset($definition['local'])) { throw new Doctrine_Export_Exception('Local reference field missing from definition.'); } if ( ! isset($definition['foreign'])) { throw new Doctrine_Export_Exception('Foreign reference field missing from definition.'); } if ( ! isset($definition['foreignTable'])) { throw new Doctrine_Export_Exception('Foreign reference table missing from definition.'); } if ( ! is_array($definition['local'])) { $definition['local'] = array($definition['local']); } if ( ! is_array($definition['foreign'])) { $definition['foreign'] = array($definition['foreign']); } $sql .= implode(', ', array_map(array($this->conn, 'quoteIdentifier'), $definition['local'])) . ') REFERENCES ' . $this->conn->quoteIdentifier($definition['foreignTable']) . '(' . implode(', ', array_map(array($this->conn, 'quoteIdentifier'), $definition['foreign'])) . ')'; return $sql; } public function getUniqueFieldDeclaration() { return 'UNIQUE'; } public function getCharsetFieldDeclaration($charset) { return ''; } public function getCollationFieldDeclaration($collation) { return ''; } public function exportSchema($directory = null) { if ($directory !== null) { $models = Doctrine_Core::filterInvalidModels(Doctrine_Core::loadModels($directory)); } else { $models = Doctrine_Core::getLoadedModels(); } $this->exportClasses($models); } public function exportSortedClassesSql($classes, $groupByConnection = true) { $connections = array(); foreach ($classes as $class) { $connection = Doctrine_Manager::getInstance()->getConnectionForComponent($class); $connectionName = $connection->getName(); if ( ! isset($connections[$connectionName])) { $connections[$connectionName] = array( 'create_tables' => array(), 'create_sequences' => array(), 'create_indexes' => array(), 'alters' => array(), 'create_triggers' => array(), ); } $sql = $connection->export->exportClassesSql(array($class)); foreach ($sql as $key => $query) { if (substr($query, 0, strlen('CREATE TABLE')) == 'CREATE TABLE') { $connections[$connectionName]['create_tables'][] = $query; unset($sql[$key]); continue; } if (substr($query, 0, strlen('CREATE SEQUENCE')) == 'CREATE SEQUENCE') { $connections[$connectionName]['create_sequences'][] = $query; unset($sql[$key]); continue; } if (preg_grep("/CREATE ([^ ]* )?INDEX/", array($query))) { $connections[$connectionName]['create_indexes'][] = $query; unset($sql[$key]); continue; } if (substr($query, 0, strlen('ALTER TABLE')) == 'ALTER TABLE' || substr($query, 0, strlen('DECLARE')) == 'DECLARE') { $connections[$connectionName]['alters'][] = $query; unset($sql[$key]); continue; } if (substr($query, 0, strlen('CREATE TRIGGER')) == 'CREATE TRIGGER') { $connections[$connectionName]['create_triggers'][] = $query; unset($sql[$key]); continue; } if (substr($query, 0, strlen('COMMENT ON')) == 'COMMENT ON') { $connections[$connectionName]['comments'][] = $query; unset($sql[$key]); continue; } } } $build = array(); foreach ($connections as $connectionName => $sql) { $build[$connectionName] = array_unique(array_merge($sql['create_tables'], $sql['create_sequences'], $sql['create_indexes'], $sql['alters'], $sql['create_triggers'])); } if ( ! $groupByConnection) { $new = array(); foreach($build as $connectionname => $sql) { $new = array_unique(array_merge($new, $sql)); } $build = $new; } return $build; } public function exportClasses(array $classes) { $queries = $this->exportSortedClassesSql($classes); foreach ($queries as $connectionName => $sql) { $connection = Doctrine_Manager::getInstance()->getConnection($connectionName); $connection->beginTransaction(); foreach ($sql as $query) { try { $connection->exec($query); } catch (Doctrine_Connection_Exception $e) { if ($e->getPortableCode() !== Doctrine_Core::ERR_ALREADY_EXISTS) { $connection->rollback(); throw new Doctrine_Export_Exception($e->getMessage() . '. Failing Query: ' . $query); } } } $connection->commit(); } } public function exportClassesSql(array $classes) { $models = Doctrine_Core::filterInvalidModels($classes); $sql = array(); foreach ($models as $name) { $record = new $name(); $table = $record->getTable(); $parents = $table->getOption('joinedParents'); foreach ($parents as $parent) { $data = $table->getConnection()->getTable($parent)->getExportableFormat(); $query = $this->conn->export->createTableSql($data['tableName'], $data['columns'], $data['options']); $sql = array_merge($sql, (array) $query); } if ($table->getAttribute(Doctrine_Core::ATTR_EXPORT) === Doctrine_Core::EXPORT_NONE) { continue; } $data = $table->getExportableFormat(); $query = $this->conn->export->createTableSql($data['tableName'], $data['columns'], $data['options']); if (is_array($query)) { $sql = array_merge($sql, $query); } else { $sql[] = $query; } if ($table->getAttribute(Doctrine_Core::ATTR_EXPORT) & Doctrine_Core::EXPORT_PLUGINS) { $sql = array_merge($sql, $this->exportGeneratorsSql($table)); } $table->getRepository()->evict($record->getOid()); unset($record); } $sql = array_unique($sql); rsort($sql); return $sql; } public function getAllGenerators(Doctrine_Table $table) { $generators = array(); foreach ($table->getGenerators() as $name => $generator) { if ($generator === null) { continue; } $generators[] = $generator; $generatorTable = $generator->getTable(); if ($generatorTable instanceof Doctrine_Table) { $generators = array_merge($generators, $this->getAllGenerators($generatorTable)); } } return $generators; } public function exportGeneratorsSql(Doctrine_Table $table) { $sql = array(); foreach ($this->getAllGenerators($table) as $name => $generator) { $table = $generator->getTable(); if ($table instanceof Doctrine_Table) { $data = $table->getExportableFormat(); $query = $this->conn->export->createTableSql($data['tableName'], $data['columns'], $data['options']); $sql = array_merge($sql, (array) $query); } } return $sql; } public function exportSql($directory = null) { if ($directory !== null) { $models = Doctrine_Core::filterInvalidModels(Doctrine_Core::loadModels($directory)); } else { $models = Doctrine_Core::getLoadedModels(); } return $this->exportSortedClassesSql($models, false); } public function exportTable(Doctrine_Table $table) { try { $data = $table->getExportableFormat(); $this->conn->export->createTable($data['tableName'], $data['columns'], $data['options']); } catch(Doctrine_Connection_Exception $e) { if ($e->getPortableCode() !== Doctrine_Core::ERR_ALREADY_EXISTS) { throw $e; } } } } class Doctrine_Export_Sqlite extends Doctrine_Export { public function dropDatabase($databaseFile) { if ( ! @file_exists($databaseFile)) { throw new Doctrine_Export_Exception('database does not exist'); } $result = @unlink($databaseFile); if ( ! $result) { throw new Doctrine_Export_Exception('could not remove the database file'); } } public function createDatabase($databaseFile) { return new PDO('sqlite:' . $databaseFile); } public function createIndexSql($table, $name, array $definition) { $name = $this->conn->formatter->getIndexName($name); $name = $this->conn->quoteIdentifier($name); $type = ''; if (isset($definition['type'])) { switch (strtolower($definition['type'])) { case 'unique': $type = strtoupper($definition['type']) . ' '; break; default: throw new Doctrine_Export_Exception( 'Unknown type ' . $definition['type'] . ' for index ' . $name . ' in table ' . $table ); } } $query = 'CREATE ' . $type . 'INDEX ' . $name . ' ON ' . $table; $query .= ' (' . $this->getIndexFieldDeclarationList($definition['fields']) . ')'; return $query; } public function getIndexFieldDeclarationList(array $fields) { $declFields = array(); foreach ($fields as $fieldName => $field) { $fieldString = $this->conn->quoteIdentifier($fieldName); if (is_array($field)) { if (isset($field['sorting'])) { $sort = strtoupper($field['sorting']); switch ($sort) { case 'ASC': case 'DESC': $fieldString .= ' ' . $sort; break; default: throw new Doctrine_Export_Exception('Unknown index sorting option given.'); } } } else { $fieldString = $this->conn->quoteIdentifier($field); } $declFields[] = $fieldString; } return implode(', ', $declFields); } public function createTableSql($name, array $fields, array $options = array()) { if ( ! $name) { throw new Doctrine_Export_Exception('no valid table name specified'); } if (empty($fields)) { throw new Doctrine_Export_Exception('no fields specified for table '.$name); } $queryFields = $this->getFieldDeclarationList($fields); $autoinc = false; foreach($fields as $field) { if (isset($field['autoincrement']) && $field['autoincrement'] || (isset($field['autoinc']) && $field['autoinc'])) { $autoinc = true; break; } } if ( ! $autoinc && isset($options['primary']) && ! empty($options['primary'])) { $keyColumns = array_values($options['primary']); $keyColumns = array_map(array($this->conn, 'quoteIdentifier'), $keyColumns); $queryFields.= ', PRIMARY KEY('.implode(', ', $keyColumns).')'; } $name = $this->conn->quoteIdentifier($name, true); $sql = 'CREATE TABLE ' . $name . ' (' . $queryFields; if ($check = $this->getCheckDeclaration($fields)) { $sql .= ', ' . $check; } if (isset($options['checks']) && $check = $this->getCheckDeclaration($options['checks'])) { $sql .= ', ' . $check; } $sql .= ')'; $query[] = $sql; if (isset($options['indexes']) && ! empty($options['indexes'])) { foreach ($options['indexes'] as $index => $definition) { $query[] = $this->createIndexSql($name, $index, $definition); } } return $query; } public function getAdvancedForeignKeyOptions(array $definition) { $query = ''; if (isset($definition['match'])) { $query .= ' MATCH ' . $definition['match']; } if (isset($definition['onUpdate'])) { $query .= ' ON UPDATE ' . $definition['onUpdate']; } if (isset($definition['onDelete'])) { $query .= ' ON DELETE ' . $definition['onDelete']; } if (isset($definition['deferrable'])) { $query .= ' DEFERRABLE'; } else { $query .= ' NOT DEFERRABLE'; } if (isset($definition['feferred'])) { $query .= ' INITIALLY DEFERRED'; } else { $query .= ' INITIALLY IMMEDIATE'; } return $query; } public function createSequence($seqName, $start = 1, array $options = array()) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); $seqcolName = $this->conn->quoteIdentifier($this->conn->getAttribute(Doctrine_Core::ATTR_SEQCOL_NAME), true); $query = 'CREATE TABLE ' . $sequenceName . ' (' . $seqcolName . ' INTEGER PRIMARY KEY DEFAULT 0 NOT NULL)'; $this->conn->exec($query); if ($start == 1) { return true; } try { $this->conn->exec('INSERT INTO ' . $sequenceName . ' (' . $seqcolName . ') VALUES (' . ($start-1) . ')'); return true; } catch(Doctrine_Connection_Exception $e) { try { $result = $db->exec('DROP TABLE ' . $sequenceName); } catch(Doctrine_Connection_Exception $e) { throw new Doctrine_Export_Exception('could not drop inconsistent sequence table'); } } throw new Doctrine_Export_Exception('could not create sequence table'); } public function dropSequenceSql($sequenceName) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($sequenceName), true); return 'DROP TABLE ' . $sequenceName; } public function alterTableSql($name, array $changes, $check = false) { if ( ! $name) { throw new Doctrine_Export_Exception('no valid table name specified'); } foreach ($changes as $changeName => $change) { switch ($changeName) { case 'add': case 'change': case 'rename': case 'name': break; default: throw new Doctrine_Export_Exception('change type "' . $changeName . '" not yet supported'); } } if ($check) { return true; } $query = ''; if ( ! empty($changes['name'])) { $change_name = $this->conn->quoteIdentifier($changes['name']); $query .= 'RENAME TO ' . $change_name; } if ( ! empty($changes['add']) && is_array($changes['add'])) { foreach ($changes['add'] as $fieldName => $field) { if ($query) { $query.= ', '; } $query.= 'ADD ' . $this->getDeclaration($fieldName, $field); } } $rename = array(); if ( ! empty($changes['rename']) && is_array($changes['rename'])) { foreach ($changes['rename'] as $fieldName => $field) { $rename[$field['name']] = $fieldName; } } if ( ! empty($changes['change']) && is_array($changes['change'])) { foreach ($changes['change'] as $fieldName => $field) { if ($query) { $query.= ', '; } if (isset($rename[$fieldName])) { $oldFieldName = $rename[$fieldName]; unset($rename[$fieldName]); } else { $oldFieldName = $fieldName; } $oldFieldName = $this->conn->quoteIdentifier($oldFieldName, true); $query .= 'CHANGE ' . $oldFieldName . ' ' . $this->getDeclaration($fieldName, $field['definition']); } } if ( ! empty($rename) && is_array($rename)) { foreach ($rename as $renameName => $renamedField) { if ($query) { $query.= ', '; } $field = $changes['rename'][$renamedField]; $renamedField = $this->conn->quoteIdentifier($renamedField, true); $query .= 'CHANGE ' . $renamedField . ' ' . $this->getDeclaration($field['name'], $field['definition']); } } if ( ! $query) { return false; } $name = $this->conn->quoteIdentifier($name, true); return 'ALTER TABLE ' . $name . ' ' . $query; } public function createForeignKey($table, array $definition) { return false; } }class Doctrine_Export_Mysql extends Doctrine_Export { public function dropConstraint($table, $name, $primary = false) { $table = $this->conn->quoteIdentifier($table); if ( ! $primary) { $name = 'CONSTRAINT ' . $this->conn->quoteIdentifier($name); } else { $name = 'PRIMARY KEY'; } return $this->conn->exec('ALTER TABLE ' . $table . ' DROP ' . $name); } public function createDatabaseSql($name) { return 'CREATE DATABASE ' . $this->conn->quoteIdentifier($name, true); } public function dropDatabaseSql($name) { return array( 'SET FOREIGN_KEY_CHECKS = 0', 'DROP DATABASE ' . $this->conn->quoteIdentifier($name), 'SET FOREIGN_KEY_CHECKS = 1' ); } public function createTableSql($name, array $fields, array $options = array()) { if ( ! $name) throw new Doctrine_Export_Exception('no valid table name specified'); if (empty($fields)) { throw new Doctrine_Export_Exception('no fields specified for table "'.$name.'"'); } $queryFields = $this->getFieldDeclarationList($fields); if (isset($options['foreignKeys'])) { foreach ($options['foreignKeys'] as $fk) { $local = $fk['local']; $found = false; if (isset($options['indexes'])) { foreach ($options['indexes'] as $definition) { if (is_string($definition['fields'])) { $found = $found || ($local == $definition['fields']); } else if (in_array($local, $definition['fields']) && count($definition['fields']) === 1) { $found = true; } } } if (isset($options['primary']) && !empty($options['primary']) && in_array($local, $options['primary'])) { $found = true; } if ( ! $found) { if (is_array($local)) { foreach($local as $localidx) { $options['indexes'][$localidx] = array('fields' => array($localidx => array())); } } else { $options['indexes'][$local] = array('fields' => array($local => array())); } } } } if (isset($options['indexes']) && ! empty($options['indexes'])) { $dupes = array(); foreach ($options['indexes'] as $key => $index) { if (in_array(strtolower($key), $dupes)) { unset($options['indexes'][$key]); } else { $dupes[] = strtolower($key); } } unset($dupes); foreach($options['indexes'] as $index => $definition) { $queryFields .= ', ' . $this->getIndexDeclaration($index, $definition); } } if (isset($options['primary']) && ! empty($options['primary'])) { $keyColumns = array_values($options['primary']); $keyColumns = array_map(array($this->conn, 'quoteIdentifier'), $keyColumns); $queryFields .= ', PRIMARY KEY(' . implode(', ', $keyColumns) . ')'; } $query = 'CREATE TABLE ' . $this->conn->quoteIdentifier($name, true) . ' (' . $queryFields . ')'; $optionStrings = array(); if (isset($options['comment'])) { $optionStrings['comment'] = 'COMMENT = ' . $this->conn->quote($options['comment'], 'text'); } if (isset($options['charset'])) { $optionStrings['charset'] = 'DEFAULT CHARACTER SET ' . $options['charset']; } if (isset($options['collate'])) { $optionStrings['collate'] = 'COLLATE ' . $options['collate']; } $type = false; if (isset($options['type'])) { $type = $options['type']; } else { $type = $this->conn->getAttribute(Doctrine_Core::ATTR_DEFAULT_TABLE_TYPE); } if ($type) { $optionStrings[] = 'ENGINE = ' . $type; } if ( ! empty($optionStrings)) { $query.= ' '.implode(' ', $optionStrings); } $sql[] = $query; if (isset($options['foreignKeys'])) { foreach ((array) $options['foreignKeys'] as $k => $definition) { if (is_array($definition)) { $sql[] = $this->createForeignKeySql($name, $definition); } } } return $sql; } public function getDeclaration($name, array $field) { $default = $this->getDefaultFieldDeclaration($field); $charset = (isset($field['charset']) && $field['charset']) ? ' ' . $this->getCharsetFieldDeclaration($field['charset']) : ''; $collation = (isset($field['collation']) && $field['collation']) ? ' ' . $this->getCollationFieldDeclaration($field['collation']) : ''; $notnull = (isset($field['notnull']) && $field['notnull']) ? ' NOT NULL' : ''; $unique = (isset($field['unique']) && $field['unique']) ? ' ' . $this->getUniqueFieldDeclaration() : ''; $check = (isset($field['check']) && $field['check']) ? ' ' . $field['check'] : ''; $comment = (isset($field['comment']) && $field['comment']) ? " COMMENT " . $this->conn->quote($field['comment'], 'text') : ''; $method = 'get' . $field['type'] . 'Declaration'; try { if (method_exists($this->conn->dataDict, $method)) { return $this->conn->dataDict->$method($name, $field); } else { $dec = $this->conn->dataDict->getNativeDeclaration($field); } return $this->conn->quoteIdentifier($name, true) . ' ' . $dec . $charset . $default . $notnull . $comment . $unique . $check . $collation; } catch (Exception $e) { throw new Doctrine_Exception('Around field ' . $name . ': ' . $e->getMessage() . "\n\n" . $e->getTraceAsString() . "\n\n"); } } public function alterTableSql($name, array $changes, $check = false) { if ( ! $name) { throw new Doctrine_Export_Exception('no valid table name specified'); } foreach ($changes as $changeName => $change) { switch ($changeName) { case 'add': case 'remove': case 'change': case 'rename': case 'name': break; default: throw new Doctrine_Export_Exception('change type "' . $changeName . '" not yet supported'); } } if ($check) { return true; } $query = ''; if ( ! empty($changes['name'])) { $change_name = $this->conn->quoteIdentifier($changes['name']); $query .= 'RENAME TO ' . $change_name; } if ( ! empty($changes['add']) && is_array($changes['add'])) { foreach ($changes['add'] as $fieldName => $field) { if ($query) { $query.= ', '; } $query.= 'ADD ' . $this->getDeclaration($fieldName, $field); } } if ( ! empty($changes['remove']) && is_array($changes['remove'])) { foreach ($changes['remove'] as $fieldName => $field) { if ($query) { $query .= ', '; } $fieldName = $this->conn->quoteIdentifier($fieldName); $query .= 'DROP ' . $fieldName; } } $rename = array(); if ( ! empty($changes['rename']) && is_array($changes['rename'])) { foreach ($changes['rename'] as $fieldName => $field) { $rename[$field['name']] = $fieldName; } } if ( ! empty($changes['change']) && is_array($changes['change'])) { foreach ($changes['change'] as $fieldName => $field) { if ($query) { $query.= ', '; } if (isset($rename[$fieldName])) { $oldFieldName = $rename[$fieldName]; unset($rename[$fieldName]); } else { $oldFieldName = $fieldName; } $oldFieldName = $this->conn->quoteIdentifier($oldFieldName, true); $query .= 'CHANGE ' . $oldFieldName . ' ' . $this->getDeclaration($fieldName, $field['definition']); } } if ( ! empty($rename) && is_array($rename)) { foreach ($rename as $renameName => $renamedField) { if ($query) { $query.= ', '; } $field = $changes['rename'][$renamedField]; $renamedField = $this->conn->quoteIdentifier($renamedField, true); $query .= 'CHANGE ' . $renamedField . ' ' . $this->getDeclaration($field['name'], $field['definition']); } } if ( ! $query) { return false; } $name = $this->conn->quoteIdentifier($name, true); return 'ALTER TABLE ' . $name . ' ' . $query; } public function createSequence($sequenceName, $start = 1, array $options = array()) { $sequenceName = $this->conn->quoteIdentifier($sequenceName, true); $seqcolName = $this->conn->quoteIdentifier($this->conn->getAttribute(Doctrine_Core::ATTR_SEQCOL_NAME), true); $optionsStrings = array(); if (isset($options['comment']) && ! empty($options['comment'])) { $optionsStrings['comment'] = 'COMMENT = ' . $this->conn->quote($options['comment'], 'string'); } if (isset($options['charset']) && ! empty($options['charset'])) { $optionsStrings['charset'] = 'DEFAULT CHARACTER SET ' . $options['charset']; if (isset($options['collate'])) { $optionsStrings['charset'] .= ' COLLATE ' . $options['collate']; } } $type = false; if (isset($options['type'])) { $type = $options['type']; } else { $type = $this->conn->getAttribute(Doctrine_Core::ATTR_DEFAULT_TABLE_TYPE); } if ($type) { $optionsStrings[] = 'ENGINE = ' . $type; } try { $query = 'CREATE TABLE ' . $sequenceName . ' (' . $seqcolName . ' BIGINT NOT NULL AUTO_INCREMENT, PRIMARY KEY (' . $seqcolName . ')) ' . implode($optionsStrings, ' '); $res = $this->conn->exec($query); } catch(Doctrine_Connection_Exception $e) { throw new Doctrine_Export_Exception('could not create sequence table'); } if ($start == 1 && $res == 1) return true; $query = 'INSERT INTO ' . $sequenceName . ' (' . $seqcolName . ') VALUES (' . ($start - 1) . ')'; $res = $this->conn->exec($query); if ($res == 1) return true; try { $result = $this->conn->exec('DROP TABLE ' . $sequenceName); } catch(Doctrine_Connection_Exception $e) { throw new Doctrine_Export_Exception('could not drop inconsistent sequence table'); } } public function createIndexSql($table, $name, array $definition) { $table = $table; $table = $this->conn->quoteIdentifier($table, true); $name = $this->conn->formatter->getIndexName($name); $name = $this->conn->quoteIdentifier($name); $type = ''; if (isset($definition['type'])) { switch (strtolower($definition['type'])) { case 'fulltext': case 'unique': $type = strtoupper($definition['type']) . ' '; break; default: throw new Doctrine_Export_Exception( 'Unknown type ' . $definition['type'] . ' for index ' . $name . ' in table ' . $table ); } } $query = 'CREATE ' . $type . 'INDEX ' . $name . ' ON ' . $table; $query .= ' (' . $this->getIndexFieldDeclarationList($definition['fields']) . ')'; return $query; } public function getDefaultFieldDeclaration($field) { $default = ''; if (isset($field['default']) && ( ! isset($field['length']) || $field['length'] <= 255)) { if ($field['default'] === '') { $field['default'] = empty($field['notnull']) ? null : $this->valid_default_values[$field['type']]; if ($field['default'] === '' && ($this->conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_EMPTY_TO_NULL) ) { $field['default'] = ' '; } } if ($field['type'] == 'enum' && $this->conn->getAttribute(Doctrine_Core::ATTR_USE_NATIVE_ENUM)) { $fieldType = 'varchar'; } else { $fieldType = $field['type']; } $default = ' DEFAULT ' . (is_null($field['default']) ? 'NULL' : $this->conn->quote($field['default'], $fieldType)); } return $default; } public function getIndexDeclaration($name, array $definition) { $name = $this->conn->formatter->getIndexName($name); $type = ''; if (isset($definition['type'])) { switch (strtolower($definition['type'])) { case 'fulltext': case 'unique': $type = strtoupper($definition['type']) . ' '; break; default: throw new Doctrine_Export_Exception( 'Unknown type ' . $definition['type'] . ' for index ' . $name ); } } if ( ! isset($definition['fields'])) { throw new Doctrine_Export_Exception('No columns given for index ' . $name); } if ( ! is_array($definition['fields'])) { $definition['fields'] = array($definition['fields']); } $query = $type . 'INDEX ' . $this->conn->quoteIdentifier($name); $query .= ' (' . $this->getIndexFieldDeclarationList($definition['fields']) . ')'; return $query; } public function getIndexFieldDeclarationList(array $fields) { $declFields = array(); foreach ($fields as $fieldName => $field) { $fieldString = $this->conn->quoteIdentifier($fieldName); if (is_array($field)) { if (isset($field['length'])) { $fieldString .= '(' . $field['length'] . ')'; } if (isset($field['sorting'])) { $sort = strtoupper($field['sorting']); switch ($sort) { case 'ASC': case 'DESC': $fieldString .= ' ' . $sort; break; default: throw new Doctrine_Export_Exception('Unknown index sorting option given.'); } } } else { $fieldString = $this->conn->quoteIdentifier($field); } $declFields[] = $fieldString; } return implode(', ', $declFields); } public function getCharsetFieldDeclaration($charset) { return $this->conn->dataDict->getCharsetFieldDeclaration($charset); } public function getCollationFieldDeclaration($collation) { return $this->conn->dataDict->getCollationFieldDeclaration($collation); } public function getAdvancedForeignKeyOptions(array $definition) { $query = ''; if ( ! empty($definition['match'])) { $query .= ' MATCH ' . $definition['match']; } if ( ! empty($definition['onUpdate'])) { $query .= ' ON UPDATE ' . $this->getForeignKeyReferentialAction($definition['onUpdate']); } if ( ! empty($definition['onDelete'])) { $query .= ' ON DELETE ' . $this->getForeignKeyReferentialAction($definition['onDelete']); } return $query; } public function dropIndexSql($table, $name) { $table = $this->conn->quoteIdentifier($table, true); $name = $this->conn->quoteIdentifier($this->conn->formatter->getIndexName($name), true); return 'DROP INDEX ' . $name . ' ON ' . $table; } public function dropTableSql($table) { $table = $this->conn->quoteIdentifier($table, true); return 'DROP TABLE ' . $table; } public function dropForeignKey($table, $name) { $table = $this->conn->quoteIdentifier($table); $name = $this->conn->quoteIdentifier($this->conn->formatter->getForeignKeyName($name)); return $this->conn->exec('ALTER TABLE ' . $table . ' DROP FOREIGN KEY ' . $name); } } class Doctrine_Export_Mssql extends Doctrine_Export { public function createDatabase($name) { $name = $this->conn->quoteIdentifier($name, true); $query = "CREATE DATABASE $name"; $options = $this->conn->getOptions(); if (isset($options['database_device']) && $options['database_device']) { $query.= ' ON '.$this->conn->options['database_device']; $query.= $this->conn->options['database_size'] ? '=' . $this->conn->options['database_size'] : ''; } return $this->conn->standaloneQuery($query, array(), true); } public function dropDatabase($name) { $name = $this->conn->quoteIdentifier($name, true); return $this->conn->standaloneQuery('DROP DATABASE ' . $name, array(), true); } public function getTemporaryTableQuery() { return ''; } public function dropIndexSql($table, $name) { $name = $this->conn->quoteIdentifier($this->conn->formatter->getIndexName($name)); $table = $this->conn->quoteIdentifier($table); return 'DROP INDEX ' . $name . ' ON ' . $table; } public function alterTable($name, array $changes, $check = false) { if ( !$name ) { throw new Doctrine_Export_Exception('no valid table name specified'); } foreach ($changes as $changeName => $change) { switch ($changeName) { case 'add': case 'remove': case 'name': case 'rename': case 'change': break; default: throw new Doctrine_Export_Exception('alterTable: change type "' . $changeName . '" not yet supported'); } } if ($check) { return true; } $query = ''; $postQueries = ''; if ( ! empty($changes['name'])) { $changeName = $this->conn->quoteIdentifier($changes['name'], true); $postQueries .= sprintf( "EXECUTE sp_RENAME '%s', '%s';", $this->conn->quoteIdentifier($name), $changeName ); } if ( ! empty($changes['add']) && is_array($changes['add'])) { foreach ($changes['add'] as $fieldName => $field) { if ($query) { $query .= ', '; } $query .= 'ADD ' . $this->getDeclaration($fieldName, $field); } } if ( ! empty($changes['remove']) && is_array($changes['remove'])) { if ($query) { $query .= ', '; } $query .= 'DROP COLUMN '; $dropped = array(); foreach ($changes['remove'] as $fieldName => $field) { $fieldName = $this->conn->quoteIdentifier($fieldName, true); $dropped[] = $fieldName; } $query .= implode(', ', $dropped) . ' '; } $rename = array(); if ( ! empty($changes['rename']) && is_array($changes['rename'])) { foreach ($changes['rename'] as $fieldName => $field) { $rename[$field['name']] = $fieldName; } } if ( ! empty($changes['change']) && is_array($changes['change'])) { if ($query) { $query.= ', '; } $query .= "ALTER COLUMN "; $altered = array(); foreach ($changes['change'] as $fieldName => $field) { if (isset($rename[$fieldName])) { $oldFieldName = $rename[$fieldName]; unset($rename[$fieldName]); } else { $oldFieldName = $fieldName; } $oldFieldName = $this->conn->quoteIdentifier($oldFieldName, true); $declaration = $this->getDeclaration($fieldName, $field['definition']); if (preg_match('/(CONSTRAINT\s+([^\s]*)\s+DEFAULT\s+([^\s]*)\s*)|(DEFAULT\s+([^\s]*)\s*)/', $declaration, $matches)) { $altered[] = str_replace($matches[0], '', $declaration); if (count($matches) === 6) { $defaultName = 'DF__' . $name . '__' . $fieldName . '__' . mt_rand(); $defaultValue = $matches[5]; } else { $defaultName = $matches[2]; $defaultValue = $matches[3]; } $postQueries .= sprintf( ' ALTER TABLE %s ADD CONSTRAINT %s DEFAULT (%s) FOR %s', $name, $defaultName, $defaultValue, $fieldName ); } else { $altered[] = $declaration; } } $query .= implode(sprintf( "; ALTER TABLE %s ALTER COLUMN ", $this->conn->quoteIdentifier($name, true) ), $altered) . ' '; } if ( ! empty($rename) && is_array($rename)) { foreach ($rename as $renameName => $renamedField) { $field = $changes['rename'][$renamedField]; $renamedField = $this->conn->quoteIdentifier($renamedField); $postQueries .= sprintf( "EXECUTE sp_RENAME '%s.%s', '%s', 'COLUMN';", $this->conn->quoteIdentifier($name), $renamedField, $this->conn->quoteIdentifier($field['name'], true) ); } } if ( ! $query && ! $postQueries) { return false; } $name = $this->conn->quoteIdentifier($name, true); $finalQuery = ''; if ($query) { $finalQuery .= 'ALTER TABLE ' . $name . ' ' . trim($query) . ';'; } if ($postQueries) { $finalQuery .= $postQueries; } return $this->conn->exec($finalQuery); } public function createSequence($seqName, $start = 1, array $options = array()) { $sequenceName = $this->conn->quoteIdentifier($this->conn->getSequenceName($seqName), true); $seqcolName = $this->conn->quoteIdentifier($this->conn->options['seqcol_name'], true); $query = 'CREATE TABLE ' . $sequenceName . ' (' . $seqcolName . ' INT PRIMARY KEY CLUSTERED IDENTITY(' . $start . ', 1) NOT NULL)'; $res = $this->conn->exec($query); if ($start == 1) { return true; } try { $query = 'SET IDENTITY_INSERT ' . $sequenceName . ' ON ' . 'INSERT INTO ' . $sequenceName . ' (' . $seqcolName . ') VALUES ( ' . $start . ')'; $res = $this->conn->exec($query); } catch (Exception $e) { $result = $this->conn->exec('DROP TABLE ' . $sequenceName); } return true; } public function dropSequenceSql($seqName) { $sequenceName = $this->conn->quoteIdentifier($this->conn->getSequenceName($seqName), true); return 'DROP TABLE ' . $sequenceName; } public function createTableSql($name, array $fields, array $options = array()) { if ( ! $name) { throw new Doctrine_Export_Exception('no valid table name specified'); } if (empty($fields)) { throw new Doctrine_Export_Exception('no fields specified for table ' . $name); } if ( ! isset($options['primary'])) { foreach ($fields as $fieldName => $fieldData) { if (isset($fieldData['primary']) && $fieldData['primary']) { $options['primary'][$fieldName] = $fieldName; } } } if (isset($options['primary'])) { foreach ($options['primary'] as $fieldName) { if (isset($fields[$fieldName])) { $fields[$fieldName]['notnull'] = true; } } } $queryFields = $this->getFieldDeclarationList($fields); if (isset($options['primary']) && ! empty($options['primary'])) { $primaryKeys = array_map(array($this->conn, 'quoteIdentifier'), array_values($options['primary'])); $queryFields .= ', PRIMARY KEY(' . implode(', ', $primaryKeys) . ')'; } $query = 'CREATE TABLE ' . $this->conn->quoteIdentifier($name, true) . ' (' . $queryFields; $check = $this->getCheckDeclaration($fields); if ( ! empty($check)) { $query .= ', ' . $check; } $query .= ')'; $sql[] = $query; if (isset($options['indexes']) && ! empty($options['indexes'])) { foreach($options['indexes'] as $index => $definition) { if (is_array($definition)) { $sql[] = $this->createIndexSql($name,$index, $definition); } } } if (isset($options['foreignKeys'])) { foreach ((array) $options['foreignKeys'] as $k => $definition) { if (is_array($definition)) { $sql[] = $this->createForeignKeySql($name, $definition); } } } return $sql; } public function getNotNullFieldDeclaration(array $definition) { return ( (isset($definition['notnull']) && $definition['notnull']) || (isset($definition['primary']) && $definition['primary']) ) ? ' NOT NULL' : ' NULL'; } public function getDefaultFieldDeclaration($field) { $default = ''; if (array_key_exists('default', $field)) { if ($field['default'] === '') { $field['default'] = empty($field['notnull']) ? null : $this->valid_default_values[$field['type']]; if ($field['default'] === '' && ($this->conn->getAttribute(Doctrine_Core::ATTR_PORTABILITY) & Doctrine_Core::PORTABILITY_EMPTY_TO_NULL)) { $field['default'] = null; } } if ($field['type'] === 'boolean') { $field['default'] = $this->conn->convertBooleans($field['default']); } if (array_key_exists('defaultConstraintName', $field)) { $default .= ' CONSTRAINT ' . $field['defaultConstraintName']; } $default .= ' DEFAULT ' . (is_null($field['default']) ? 'NULL' : $this->conn->quote($field['default'], $field['type'])); } return $default; } }class Doctrine_Export_Reporter implements IteratorAggregate { protected $messages = array(); public function add($code, $message) { $this->messages[] = array($code, $message); } public function pop() { return array_pop($this->messages); } public function getIterator() { return new ArrayIterator($this->messages); } }class Doctrine_Export_Oracle extends Doctrine_Export { public function createDatabase($name) { if ($this->conn->getAttribute(Doctrine_Core::ATTR_EMULATE_DATABASE)) { $username = $name; $password = $this->conn->dsn['password'] ? $this->conn->dsn['password'] : $name; $tablespace = $this->conn->options['default_tablespace'] ? ' DEFAULT TABLESPACE '.$this->conn->options['default_tablespace'] : ''; $query = 'CREATE USER ' . $username . ' IDENTIFIED BY ' . $password . $tablespace; $result = $this->conn->exec($query); try { $query = 'GRANT CREATE SESSION, CREATE TABLE, UNLIMITED TABLESPACE, CREATE SEQUENCE, CREATE TRIGGER TO ' . $username; $result = $this->conn->exec($query); } catch (Exception $e) { $this->dropDatabase($username); } } return true; } public function dropDatabase($name) { $sql = <<<SQL
BEGIN
  -- user_tables contains also materialized views
  FOR I IN (SELECT table_name FROM user_tables WHERE table_name NOT IN (SELECT mview_name FROM user_mviews))
  LOOP 
    EXECUTE IMMEDIATE 'DROP TABLE "'||I.table_name||'" CASCADE CONSTRAINTS';
  END LOOP;
  
  FOR I IN (SELECT SEQUENCE_NAME FROM USER_SEQUENCES)
  LOOP
    EXECUTE IMMEDIATE 'DROP SEQUENCE "'||I.SEQUENCE_NAME||'"';
  END LOOP;
END;

SQL;
$this->conn->exec($sql); if ($this->conn->getAttribute(Doctrine_Core::ATTR_EMULATE_DATABASE)) { $username = $name; $this->conn->exec('DROP USER ' . $username . ' CASCADE'); } } public function _makeAutoincrement($name, $table, $start = 1) { $sql = array(); if ( ! $this->conn->getAttribute(Doctrine_Core::ATTR_QUOTE_IDENTIFIER)) { $table = strtoupper($table); } $indexName = $table . '_AI_PK'; $definition = array( 'primary' => true, 'fields' => array($name => true), ); $sql[] = 'DECLARE
  constraints_Count NUMBER;
BEGIN
  SELECT COUNT(CONSTRAINT_NAME) INTO constraints_Count FROM USER_CONSTRAINTS WHERE TABLE_NAME = \''.$table.'\' AND CONSTRAINT_TYPE = \'P\';
  IF constraints_Count = 0 THEN
    EXECUTE IMMEDIATE \''.$this->createConstraintSql($table, $indexName, $definition).'\';
  END IF;
END;'; if (is_null($start)) { $query = 'SELECT MAX(' . $this->conn->quoteIdentifier($name, true) . ') FROM ' . $this->conn->quoteIdentifier($table, true); $start = $this->conn->fetchOne($query); ++$start; } $sql[] = $this->createSequenceSql($table, $start); $sequenceName = $this->conn->formatter->getSequenceName($table); $triggerName = $this->conn->quoteIdentifier($table . '_AI_PK', true); $table = $this->conn->quoteIdentifier($table, true); $name = $this->conn->quoteIdentifier($name, true); $sql[] = 'CREATE TRIGGER ' . $triggerName . '
   BEFORE INSERT
   ON ' . $table . '
   FOR EACH ROW
DECLARE
   last_Sequence NUMBER;
   last_InsertID NUMBER;
BEGIN
   IF (:NEW.' . $name . ' IS NULL OR :NEW.'.$name.' = 0) THEN
      SELECT ' . $this->conn->quoteIdentifier($sequenceName) . '.NEXTVAL INTO :NEW.' . $name . ' FROM DUAL;
   ELSE
      SELECT NVL(Last_Number, 0) INTO last_Sequence
        FROM User_Sequences
       WHERE UPPER(Sequence_Name) = UPPER(\'' . $sequenceName . '\');
      SELECT :NEW.' . $name . ' INTO last_InsertID FROM DUAL;
      WHILE (last_InsertID > last_Sequence) LOOP
         SELECT ' . $this->conn->quoteIdentifier($sequenceName) . '.NEXTVAL INTO last_Sequence FROM DUAL;
      END LOOP;
   END IF;
END;'; return $sql; } public function dropAutoincrement($table) { $table = strtoupper($table); $triggerName = $table . '_AI_PK'; $trigger_name_quoted = $this->conn->quote($triggerName); $query = 'SELECT trigger_name FROM user_triggers'; $query.= ' WHERE trigger_name='.$trigger_name_quoted.' OR trigger_name='.strtoupper($trigger_name_quoted); $trigger = $this->conn->fetchOne($query); if ($trigger) { $trigger_name = $this->conn->quoteIdentifier($table . '_AI_PK', true); $trigger_sql = 'DROP TRIGGER ' . $trigger_name; $this->conn->exec($trigger_sql); $this->dropSequence($table); $indexName = $table . '_AI_PK'; $this->dropConstraint($table, $indexName); } } public function getTemporaryTableQuery() { return 'GLOBAL TEMPORARY'; } public function getAdvancedForeignKeyOptions(array $definition) { $query = ''; if (isset($definition['onDelete']) && strtoupper(trim($definition['onDelete'])) != 'NO ACTION') { $query .= ' ON DELETE ' . $definition['onDelete']; } if (isset($definition['deferrable'])) { $query .= ' DEFERRABLE'; } else { $query .= ' NOT DEFERRABLE'; } if (isset($definition['feferred'])) { $query .= ' INITIALLY DEFERRED'; } else { $query .= ' INITIALLY IMMEDIATE'; } return $query; } public function createTable($name, array $fields, array $options = array()) { $this->conn->beginTransaction(); foreach ($this->createTableSql($name, $fields, $options) as $sql) { $this->conn->exec($sql); } $this->conn->commit(); } public function createTableSql($name, array $fields, array $options = array()) { $sql = parent::createTableSql($name, $fields, $options); if (isset($options['comment']) && ! empty($options['comment'])) { $sql[] = $this->_createTableCommentSql($name, $options['comment']); } foreach ($fields as $fieldName => $field) { if (isset($field['sequence'])) { $sql[] = $this->createSequenceSql($field['sequence'], 1); } if (isset($field['autoincrement']) && $field['autoincrement'] || (isset($field['autoinc']) && $fields['autoinc'])) { $sql = array_merge($sql, $this->_makeAutoincrement($fieldName, $name)); } if (isset($field['comment']) && ! empty($field['comment'])){ $sql[] = $this->_createColumnCommentSql($name,$fieldName,$field['comment']); } } if (isset($options['indexes']) && ! empty($options['indexes'])) { foreach ($options['indexes'] as $indexName => $definition) { if ( ! isset($definition['type']) || (isset($definition['type']) && strtolower($definition['type']) != 'unique')) { $sql[] = $this->createIndexSql($name, $indexName, $definition); } } } return $sql; } public function _createTableCommentSql($table,$comment) { return 'COMMENT ON TABLE '. $this->conn->quoteIdentifier($table, true). ' IS '.$this->conn->quote($comment, 'text').''; } public function _createColumnCommentSql($table,$column, $comment) { return 'COMMENT ON COLUMN '. $this->conn->quoteIdentifier($table, true). '.'. $this->conn->quoteIdentifier($column, true). ' IS '.$this->conn->quote($comment, 'text').''; } public function dropTable($name) { $result = $this->dropAutoincrement($name); $result = parent::dropTable($name); return $result; } public function alterTable($name, array $changes, $check = false) { foreach ($changes as $changeName => $change) { switch ($changeName) { case 'add': case 'remove': case 'change': case 'name': case 'rename': break; default: throw new Doctrine_Export_Exception('change type "' . $changeName . '" not yet supported'); } } if ($check) { return false; } $name = $this->conn->quoteIdentifier($name, true); if ( ! empty($changes['add']) && is_array($changes['add'])) { $fields = array(); foreach ($changes['add'] as $fieldName => $field) { $fields[] = $this->getDeclaration($fieldName, $field); } $result = $this->conn->exec('ALTER TABLE ' . $name . ' ADD (' . implode(', ', $fields) . ')'); } if ( ! empty($changes['change']) && is_array($changes['change'])) { $fields = array(); foreach ($changes['change'] as $fieldName => $field) { $fields[] = $fieldName. ' ' . $this->getDeclaration('', $field['definition']); } $result = $this->conn->exec('ALTER TABLE ' . $name . ' MODIFY (' . implode(', ', $fields) . ')'); } if ( ! empty($changes['rename']) && is_array($changes['rename'])) { foreach ($changes['rename'] as $fieldName => $field) { $query = 'ALTER TABLE ' . $name . ' RENAME COLUMN ' . $this->conn->quoteIdentifier($fieldName, true) . ' TO ' . $this->conn->quoteIdentifier($field['name']); $result = $this->conn->exec($query); } } if ( ! empty($changes['remove']) && is_array($changes['remove'])) { $fields = array(); foreach ($changes['remove'] as $fieldName => $field) { $fields[] = $this->conn->quoteIdentifier($fieldName, true); } $result = $this->conn->exec('ALTER TABLE ' . $name . ' DROP COLUMN ' . implode(', ', $fields)); } if ( ! empty($changes['name'])) { $changeName = $this->conn->quoteIdentifier($changes['name'], true); $result = $this->conn->exec('ALTER TABLE ' . $name . ' RENAME TO ' . $changeName); } } public function createSequenceSql($seqName, $start = 1, array $options = array()) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); $query = 'CREATE SEQUENCE ' . $sequenceName . ' START WITH ' . $start . ' INCREMENT BY 1 NOCACHE'; $query .= ($start < 1 ? ' MINVALUE ' . $start : ''); return $query; } public function dropSequenceSql($seqName) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($seqName), true); return 'DROP SEQUENCE ' . $sequenceName; } public function getIndexDeclaration($name, array $definition) { $name = $this->conn->quoteIdentifier($name); $type = ''; if ( isset($definition['type'])) { if (strtolower($definition['type']) == 'unique') { $type = strtoupper($definition['type']); } else { throw new Doctrine_Export_Exception( 'Unknown type '.$definition['type'] .' for index '.$name ); } } else { return null; } if ( !isset($definition['fields']) || !is_array($definition['fields'])) { throw new Doctrine_Export_Exception('No columns given for index '.$name); } $query = 'CONSTRAINT '.$name.' '.$type.' ('.$this->getIndexFieldDeclarationList($definition['fields']).')'; return $query; } } class Doctrine_Export_Pgsql extends Doctrine_Export { public $tmpConnectionDatabase = 'postgres'; public function createDatabaseSql($name) { $query = 'CREATE DATABASE ' . $this->conn->quoteIdentifier($name); return $query; } public function dropDatabaseSql($name) { $query = 'DROP DATABASE ' . $this->conn->quoteIdentifier($name); return $query; } public function getAdvancedForeignKeyOptions(array $definition) { $query = ''; if (isset($definition['match'])) { $query .= ' MATCH ' . $definition['match']; } if (isset($definition['onUpdate'])) { $query .= ' ON UPDATE ' . $definition['onUpdate']; } if (isset($definition['onDelete'])) { $query .= ' ON DELETE ' . $definition['onDelete']; } if (isset($definition['deferrable'])) { $query .= ' DEFERRABLE'; } else { $query .= ' NOT DEFERRABLE'; } if (isset($definition['deferred'])) { $query .= ' INITIALLY DEFERRED'; } else { $query .= ' INITIALLY IMMEDIATE'; } return $query; } public function alterTableSql($name, array $changes, $check = false) { foreach ($changes as $changeName => $change) { switch ($changeName) { case 'add': case 'remove': case 'change': case 'name': case 'rename': break; default: throw new Doctrine_Export_Exception('change type "' . $changeName . '\" not yet supported'); } } if ($check) { return true; } $sql = array(); if (isset($changes['add']) && is_array($changes['add'])) { foreach ($changes['add'] as $fieldName => $field) { $query = 'ADD ' . $this->getDeclaration($fieldName, $field); $sql[] = 'ALTER TABLE ' . $this->conn->quoteIdentifier($name, true) . ' ' . $query; } } if (isset($changes['remove']) && is_array($changes['remove'])) { foreach ($changes['remove'] as $fieldName => $field) { $fieldName = $this->conn->quoteIdentifier($fieldName, true); $query = 'DROP ' . $fieldName; $sql[] = 'ALTER TABLE ' . $this->conn->quoteIdentifier($name, true) . ' ' . $query; } } if (isset($changes['change']) && is_array($changes['change'])) { foreach ($changes['change'] as $fieldName => $field) { $fieldName = $this->conn->quoteIdentifier($fieldName, true); if (isset($field['definition']['type'])) { $serverInfo = $this->conn->getServerVersion(); if (is_array($serverInfo) && $serverInfo['major'] < 8) { throw new Doctrine_Export_Exception('changing column type for "'.$field['type'].'\" requires PostgreSQL 8.0 or above'); } $query = 'ALTER ' . $fieldName . ' TYPE ' . $this->conn->dataDict->getNativeDeclaration($field['definition']); $sql[] = 'ALTER TABLE ' . $this->conn->quoteIdentifier($name, true) . ' ' . $query; } if (array_key_exists('default', $field['definition'])) { $query = 'ALTER ' . $fieldName . ' SET DEFAULT ' . $this->conn->quote($field['definition']['default'], $field['definition']['type']); $sql[] = 'ALTER TABLE ' . $this->conn->quoteIdentifier($name, true) . ' ' . $query; } if ( ! empty($field['definition']['notnull'])) { $query = 'ALTER ' . $fieldName . ' ' . ($field['definition']['notnull'] ? 'SET' : 'DROP') . ' NOT NULL'; $sql[] = 'ALTER TABLE ' . $this->conn->quoteIdentifier($name, true) . ' ' . $query; } } } if (isset($changes['rename']) && is_array($changes['rename'])) { foreach ($changes['rename'] as $fieldName => $field) { $fieldName = $this->conn->quoteIdentifier($fieldName, true); $sql[] = 'ALTER TABLE ' . $this->conn->quoteIdentifier($name, true) . ' RENAME COLUMN ' . $fieldName . ' TO ' . $this->conn->quoteIdentifier($field['name'], true); } } $name = $this->conn->quoteIdentifier($name, true); if (isset($changes['name'])) { $changeName = $this->conn->quoteIdentifier($changes['name'], true); $sql[] = 'ALTER TABLE ' . $this->conn->quoteIdentifier($name, true) . ' RENAME TO ' . $changeName; } return $sql; } public function alterTable($name, array $changes, $check = false) { $sql = $this->alterTableSql($name, $changes, $check); foreach ($sql as $query) { $this->conn->exec($query); } return true; } public function createSequenceSql($sequenceName, $start = 1, array $options = array()) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($sequenceName), true); return 'CREATE SEQUENCE ' . $sequenceName . ' INCREMENT 1' . ($start < 1 ? ' MINVALUE ' . $start : '') . ' START ' . $start; } public function dropSequenceSql($sequenceName) { $sequenceName = $this->conn->quoteIdentifier($this->conn->formatter->getSequenceName($sequenceName), true); return 'DROP SEQUENCE ' . $sequenceName; } public function createTableSql($name, array $fields, array $options = array()) { if ( ! $name) { throw new Doctrine_Export_Exception('no valid table name specified'); } if (empty($fields)) { throw new Doctrine_Export_Exception('no fields specified for table ' . $name); } $queryFields = $this->getFieldDeclarationList($fields); if (isset($options['primary']) && ! empty($options['primary'])) { $keyColumns = array_values($options['primary']); $keyColumns = array_map(array($this->conn, 'quoteIdentifier'), $keyColumns); $queryFields .= ', PRIMARY KEY(' . implode(', ', $keyColumns) . ')'; } $query = 'CREATE TABLE ' . $this->conn->quoteIdentifier($name, true) . ' (' . $queryFields; if ($check = $this->getCheckDeclaration($fields)) { $query .= ', ' . $check; } if (isset($options['checks']) && $check = $this->getCheckDeclaration($options['checks'])) { $query .= ', ' . $check; } $query .= ')'; $sql[] = $query; if (isset($options['indexes']) && ! empty($options['indexes'])) { foreach($options['indexes'] as $index => $definition) { $sql[] = $this->createIndexSql($name, $index, $definition); } } if (isset($options['foreignKeys'])) { foreach ((array) $options['foreignKeys'] as $k => $definition) { if (is_array($definition)) { $sql[] = $this->createForeignKeySql($name, $definition); } } } if (isset($options['sequenceName'])) { $sql[] = $this->createSequenceSql($options['sequenceName']); } return $sql; } public function createIndexSql($table, $name, array $definition) { $query = parent::createIndexSql($table, $name, $definition); if (isset($definition['where'])) { return $query . ' WHERE ' . $definition['where']; } return $query; } }class Doctrine_Export_Schema { public function buildSchema($directory = null, $models = array(), $modelLoading = null) { if ($directory !== null) { $loadedModels = Doctrine_Core::filterInvalidModels(Doctrine_Core::loadModels($directory, $modelLoading)); } else { $loadedModels = Doctrine_Core::getLoadedModels(); } $array = array(); $parent = new ReflectionClass('Doctrine_Record'); $sql = array(); $fks = array(); foreach ($loadedModels as $className) { if ( ! empty($models) && !in_array($className, $models)) { continue; } $recordTable = Doctrine_Core::getTable($className); $data = $recordTable->getExportableFormat(); $table = array(); $table['connection'] = $recordTable->getConnection()->getName(); $remove = array('ptype', 'ntype', 'alltypes'); foreach ($data['columns'] AS $name => $column) { if (isset($column['length']) && $column['length'] && isset($column['scale']) && $column['scale']) { $data['columns'][$name]['type'] = $column['type'] . '(' . $column['length'] . ', ' . $column['scale'] . ')'; unset($data['columns'][$name]['length'], $data['columns'][$name]['scale']); } else { $data['columns'][$name]['type'] = $column['type'] . '(' . $column['length'] . ')'; unset($data['columns'][$name]['length']); } foreach ($remove as $value) { if (isset($data['columns'][$name][$value])) { unset($data['columns'][$name][$value]); } } if (count($data['columns'][$name]) === 1 && isset($data['columns'][$name]['type'])) { $type = $data['columns'][$name]['type']; unset($data['columns'][$name]); $data['columns'][$name] = $type; } } $table['tableName'] = $data['tableName']; $table['columns'] = $data['columns']; $relations = $recordTable->getRelations(); foreach ($relations as $key => $relation) { $relationData = $relation->toArray(); $relationKey = $relationData['alias']; if (isset($relationData['refTable']) && $relationData['refTable']) { $table['relations'][$relationKey]['refClass'] = $relationData['refTable']->getComponentName(); } if (isset($relationData['class']) && $relationData['class'] && $relation['class'] != $relationKey) { $table['relations'][$relationKey]['class'] = $relationData['class']; } $table['relations'][$relationKey]['local'] = $relationData['local']; $table['relations'][$relationKey]['foreign'] = $relationData['foreign']; if ($relationData['type'] === Doctrine_Relation::ONE) { $table['relations'][$relationKey]['type'] = 'one'; } else if ($relationData['type'] === Doctrine_Relation::MANY) { $table['relations'][$relationKey]['type'] = 'many'; } else { $table['relations'][$relationKey]['type'] = 'one'; } } $array[$className] = $table; } return $array; } public function exportSchema($schema, $format = 'yml', $directory = null, $models = array(), $modelLoading = null) { $array = $this->buildSchema($directory, $models, $modelLoading); if (is_dir($schema)) { $schema = $schema . DIRECTORY_SEPARATOR . 'schema.' . $format; } return Doctrine_Parser::dump($array, $format, $schema); } }class Doctrine_Export_Exception extends Doctrine_Exception { }class Doctrine_Cli { const TASK_BASE_CLASS = 'Doctrine_Task'; protected $_scriptName = null; private $_config; private $_formatter; private $_registeredTask = array(); private $_taskInstance; public function __construct(array $config = array(), Doctrine_Cli_Formatter $formatter = null) { $this->setConfig($config); $this->setFormatter($formatter ? $formatter : new Doctrine_Cli_AnsiColorFormatter()); $this->includeAndRegisterTaskClasses(); } public function setConfig(array $config) { $this->_config = $config; } public function getConfig() { return $this->_config; } public function setFormatter(Doctrine_Cli_Formatter $formatter) { $this->_formatter = $formatter; } public function getFormatter() { return $this->_formatter; } public function getConfigValue($name) { if (! isset($this->_config[$name])) { if (func_num_args() > 1) { return func_get_arg(1); } throw new OutOfBoundsException("The element \"{$name}\" does not exist in the config"); } return $this->_config[$name]; } public function hasConfigValue($name, $value = null, $strict = false) { if (isset($this->_config[$name])) { if (func_num_args() < 2) { return true; } if ($strict) { return $this->_config[$name] === $value; } return $this->_config[$name] == $value; } return false; } public function setRegisteredTasks(array $registeredTask) { $this->_registeredTask = $registeredTask; } public function getRegisteredTasks() { return $this->_registeredTask; } public function taskClassIsRegistered($className) { return isset($this->_registeredTask[$className]); } public function taskNameIsRegistered($taskName, &$className = null) { foreach ($this->getRegisteredTasks() as $currClassName => $task) { if ($task->getTaskName() == $taskName) { $className = $currClassName; return true; } } return false; } public function setTaskInstance(Doctrine_Task $task) { $this->_taskInstance = $task; } public function getTaskInstance() { return $this->_taskInstance; } protected function includeAndRegisterTaskClasses() { $this->includeAndRegisterDoctrineTaskClasses(); if ($this->getConfigValue('autoregister_custom_tasks', true)) { $this->registerIncludedTaskClasses(); } } protected function includeAndRegisterDoctrineTaskClasses($directories = null) { if (is_null($directories)) { $directories = Doctrine_Core::getPath() . DIRECTORY_SEPARATOR . 'Doctrine' . DIRECTORY_SEPARATOR . 'Task'; } foreach ((array) $directories as $directory) { foreach ($this->includeDoctrineTaskClasses($directory) as $className) { $this->registerTaskClass($className); } } } protected function includeDoctrineTaskClasses($directory) { if (! is_dir($directory)) { throw new InvalidArgumentException("The directory \"{$directory}\" does not exist"); } $taskClassesIncluded = array(); $iterator = new RecursiveIteratorIterator( new RecursiveDirectoryIterator($directory), RecursiveIteratorIterator::LEAVES_ONLY ); foreach ($iterator as $file) { $baseName = $file->getFileName(); $matched = (bool) preg_match('/^([A-Z].*?)\.php$/', $baseName, $matches); if ( ! ($matched && (strpos($baseName, '.inc') === false))) { continue; } $expectedClassName = self::TASK_BASE_CLASS . '_' . $matches[1]; if ( ! class_exists($expectedClassName)) { require_once($file->getPathName()); } if (class_exists($expectedClassName, false) && $this->classIsTask($expectedClassName)) { $taskClassesIncluded[] = $expectedClassName; } } return $taskClassesIncluded; } public function registerTaskClass($className) { if ($this->taskClassIsRegistered($className)) { return; } if ( ! class_exists($className)) { throw new InvalidArgumentException("The task class \"{$className}\" does not exist"); } if ( ! $this->classIsTask($className)) { throw new DomainException("The class \"{$className}\" is not a Doctrine Task"); } $this->_registeredTask[$className] = $this->createTaskInstance($className, $this); } protected function classIsTask($className) { $reflectionClass = new ReflectionClass($className); return (bool) $reflectionClass->isSubClassOf(self::TASK_BASE_CLASS); } protected function createTaskInstance($className, Doctrine_Cli $cli) { return new $className($cli); } public function registerIncludedTaskClasses() { foreach (get_declared_classes() as $className) { if ($this->classIsTask($className)) { $this->registerTaskClass($className); } } } public function notify($notification = null, $style = 'HEADER') { $formatter = $this->getFormatter(); echo( $formatter->format($this->getTaskInstance()->getTaskName(), 'INFO') . ' - ' . $formatter->format($notification, $style) . "\n" ); } protected function formatExceptionMessage(Exception $exception) { $message = $exception->getMessage(); if (Doctrine_Core::debug()) { $message .= "\n" . $exception->getTraceAsString(); } return $this->getFormatter()->format($message, 'ERROR') . "\n"; } protected function notifyException(Exception $exception) { echo $this->formatExceptionMessage($exception); } public function run(array $args) { try { $this->_run($args); } catch (Exception $exception) { if ($this->getConfigValue('rethrow_exceptions', false)) { throw new $exception($this->formatExceptionMessage($exception)); } $this->notifyException($exception); if ($exception instanceof Doctrine_Cli_Exception) { $this->printTasks(); } } } protected function _run(array $args) { $this->_scriptName = $args[0]; $requestedTaskName = isset($args[1]) ? $args[1] : null; if ( ! $requestedTaskName || $requestedTaskName == 'help') { $this->printTasks(null, $requestedTaskName == 'help' ? true : false); return; } if ($requestedTaskName && isset($args[2]) && $args[2] === 'help') { $this->printTasks($requestedTaskName, true); return; } if (! $this->taskNameIsRegistered($requestedTaskName, $taskClassName)) { throw new Doctrine_Cli_Exception("The task \"{$requestedTaskName}\" has not been registered"); } $taskInstance = $this->createTaskInstance($taskClassName, $this); $this->setTaskInstance($taskInstance); $this->executeTask($taskInstance, $this->prepareArgs(array_slice($args, 2))); } protected function executeTask(Doctrine_Task $task, array $preparedArguments) { $task->setArguments($preparedArguments); if (! $task->validate()) { throw new Doctrine_Cli_Exception('Required arguments missing'); } $task->execute(); } protected function prepareArgs(array $args) { $taskInstance = $this->getTaskInstance(); $args = array_values($args); $prepared = array(); $requiredArguments = $taskInstance->getRequiredArguments(); foreach ($requiredArguments as $key => $arg) { $prepared[$arg] = null; } $optionalArguments = $taskInstance->getOptionalArguments(); foreach ($optionalArguments as $key => $arg) { $prepared[$arg] = null; } foreach ($this->getConfig() as $key => $value) { if (array_key_exists($key, $prepared)) { $prepared[$key] = $value; } } $copy = $args; foreach ($prepared as $key => $value) { if ( ! $value && !empty($copy)) { $prepared[$key] = $copy[0]; unset($copy[0]); $copy = array_values($copy); } } return $prepared; } public function printTasks($taskName = null, $full = false) { $formatter = $this->getFormatter(); $config = $this->getConfig(); $taskIndex = $formatter->format('Doctrine Command Line Interface', 'HEADER') . "\n\n"; foreach ($this->getRegisteredTasks() as $task) { if ($taskName && (strtolower($taskName) != strtolower($task->getTaskName()))) { continue; } $taskIndex .= $formatter->format($this->_scriptName . ' ' . $task->getTaskName(), 'INFO'); if ($full) { $taskIndex .= ' - ' . $task->getDescription() . "\n"; $args = ''; $args .= $this->assembleArgumentList($task->getRequiredArgumentsDescriptions(), $config, $formatter); $args .= $this->assembleArgumentList($task->getOptionalArgumentsDescriptions(), $config, $formatter); if ($args) { $taskIndex .= "\n" . $formatter->format('Arguments:', 'HEADER') . "\n" . $args; } } $taskIndex .= "\n"; } echo $taskIndex; } protected function assembleArgumentList(array $argumentsDescriptions, array $config, Doctrine_Cli_Formatter $formatter) { $argumentList = ''; foreach ($argumentsDescriptions as $name => $description) { $argumentList .= $formatter->format($name, 'ERROR') . ' - '; if (isset($config[$name])) { $argumentList .= $formatter->format($config[$name], 'COMMENT'); } else { $argumentList .= $description; } $argumentList .= "\n"; } return $argumentList; } private function createOldStyleTaskList(array $registeredTask) { $taskNames = array(); foreach ($registeredTask as $className => $task) { $taskName = $task->getTaskName(); $taskNames[$taskName] = $taskName; } return $taskNames; } public function loadTasks($directory = null) { $this->includeAndRegisterDoctrineTaskClasses($directory); return $this->createOldStyleTaskList($this->getRegisteredTasks()); } protected function _getTaskClassFromArgs(array $args) { return self::TASK_BASE_CLASS . '_' . Doctrine_Inflector::classify(str_replace('-', '_', $args[1])); } public function getLoadedTasks() { return $this->createOldStyleTaskList($this->getRegisteredTasks()); } }abstract class Doctrine_Cache_Driver implements Doctrine_Cache_Interface { protected $_options = array(); public function __construct($options = array()) { $this->_options = $options; } public function setOption($option, $value) { if (isset($this->_options[$option])) { $this->_options[$option] = $value; return true; } return false; } public function getOption($option) { if ( ! isset($this->_options[$option])) { return null; } return $this->_options[$option]; } public function fetch($id, $testCacheValidity = true) { $key = $this->_getKey($id); return $this->_doFetch($key, $testCacheValidity); } public function contains($id) { $key = $this->_getKey($id); return $this->_doContains($key); } public function save($id, $data, $lifeTime = false) { $key = $this->_getKey($id); return $this->_doSave($key, $data, $lifeTime); } public function delete($id) { $key = $this->_getKey($id); if (strpos($key, '*') !== false) { return $this->deleteByRegex('/' . str_replace('*', '.*', $key) . '/'); } return $this->_doDelete($key); } public function deleteByRegex($regex) { $count = 0; $keys = $this->_getCacheKeys(); if (is_array($keys)) { foreach ($keys as $key) { if (preg_match($regex, $key)) { $count++; $this->delete($key); } } } return $count; } public function deleteByPrefix($prefix) { $count = 0; $keys = $this->_getCacheKeys(); if (is_array($keys)) { foreach ($keys as $key) { if (strpos($key, $prefix) === 0) { $count++; $this->delete($key); } } } return $count; } public function deleteBySuffix($suffix) { $count = 0; $keys = $this->_getCacheKeys(); if (is_array($keys)) { foreach ($keys as $key) { if (substr($key, -1 * strlen($suffix)) == $suffix) { $count++; $this->delete($key); } } } return $count; } public function deleteAll() { $count = 0; if (is_array($keys = $this->_getCacheKeys())) { foreach ($keys as $key) { $count++; $this->delete($key); } } return $count; } protected function _getKey($id) { $prefix = isset($this->_options['prefix']) ? $this->_options['prefix'] : ''; if ( ! $prefix || strpos($id, $prefix) === 0) { return $id; } else { return $prefix . $id; } } abstract protected function _getCacheKeys(); abstract protected function _doFetch($id, $testCacheValidity = true); abstract protected function _doContains($id); abstract protected function _doSave($id, $data, $lifeTime = false); abstract protected function _doDelete($id); }class Doctrine_Cache_Db extends Doctrine_Cache_Driver { public function __construct($options = array()) { if ( ! isset($options['connection']) || ! ($options['connection'] instanceof Doctrine_Connection)) { throw new Doctrine_Cache_Exception('Connection option not set.'); } if ( ! isset($options['tableName']) || ! is_string($options['tableName'])) { throw new Doctrine_Cache_Exception('Table name option not set.'); } $this->_options = $options; } public function getConnection() { return $this->_options['connection']; } protected function _doFetch($id, $testCacheValidity = true) { $sql = 'SELECT data, expire FROM ' . $this->_options['tableName'] . ' WHERE id = ?'; if ($testCacheValidity) { $sql .= " AND (expire is null OR expire > '" . date('Y-m-d H:i:s') . "')"; } $result = $this->getConnection()->execute($sql, array($id))->fetchAll(Doctrine_Core::FETCH_NUM); if ( ! isset($result[0])) { return false; } return unserialize($this->_hex2bin($result[0][0])); } protected function _doContains($id) { $sql = 'SELECT id, expire FROM ' . $this->_options['tableName'] . ' WHERE id = ?'; $result = $this->getConnection()->fetchOne($sql, array($id)); if (isset($result[0] )) { return time(); } return false; } protected function _doSave($id, $data, $lifeTime = false, $saveKey = true) { if ($this->contains($id)) { $sql = 'UPDATE ' . $this->_options['tableName'] . ' SET data = ?, expire=? ' . ' WHERE id = ?'; if ($lifeTime) { $expire = date('Y-m-d H:i:s', time() + $lifeTime); } else { $expire = NULL; } $params = array(bin2hex(serialize($data)), $expire, $id); } else { $sql = 'INSERT INTO ' . $this->_options['tableName'] . ' (id, data, expire) VALUES (?, ?, ?)'; if ($lifeTime) { $expire = date('Y-m-d H:i:s', time() + $lifeTime); } else { $expire = NULL; } $params = array($id, bin2hex(serialize($data)), $expire); } return $this->getConnection()->exec($sql, $params); } protected function _doDelete($id) { $sql = 'DELETE FROM ' . $this->_options['tableName'] . ' WHERE id = ?'; return $this->getConnection()->exec($sql, array($id)); } public function createTable() { $name = $this->_options['tableName']; $fields = array( 'id' => array( 'type' => 'string', 'length' => 255 ), 'data' => array( 'type' => 'blob' ), 'expire' => array( 'type' => 'timestamp' ) ); $options = array( 'primary' => array('id') ); $this->getConnection()->export->createTable($name, $fields, $options); } protected function _hex2bin($hex) { if ( ! is_string($hex)) { return null; } if ( ! ctype_xdigit($hex)) { return $hex; } return pack("H*", $hex); } protected function _getCacheKeys() { $sql = 'SELECT id FROM ' . $this->_options['tableName']; $keys = array(); $results = $this->getConnection()->execute($sql)->fetchAll(Doctrine_Core::FETCH_NUM); for ($i = 0, $count = count($results); $i < $count; $i++) { $keys[] = $results[$i][0]; } return $keys; } }class Doctrine_Cache_Xcache extends Doctrine_Cache_Driver { public function __construct($options = array()) { if ( ! extension_loaded('xcache') ) { throw new Doctrine_Cache_Exception('In order to use Xcache driver, the xcache extension must be loaded.'); } parent::__construct($options); } protected function _doFetch($id, $testCacheValidity = true) { return $this->_doContains($id) ? xcache_get($id) : false; } protected function _doContains($id) { return xcache_isset($id); } protected function _doSave($id, $data, $lifeTime = false) { return xcache_set($id, $data, $lifeTime); } protected function _doDelete($id) { return xcache_unset($id); } protected function _getCacheKeys() { $this->checkAuth(); $keys = array(); for ($i = 0, $count = xcache_count(XC_TYPE_VAR); $i < $count; $i++) { $entries = xcache_list(XC_TYPE_VAR, $i); if (is_array($entries['cache_list'])) { foreach ($entries['cache_list'] as $entry) { $keys[] = $entry['name']; } } } return $keys; } protected function checkAuth() { if (ini_get('xcache.admin.enable_auth')) { throw new Doctrine_Cache_Exception('To use all features of Doctrine_Cache_Xcache, you must set "xcache.admin.enable_auth" to "Off" in your php.ini.'); } } }class Doctrine_Cache_Memcache extends Doctrine_Cache_Driver { protected $_memcache = null; public function __construct($options = array()) { if ( ! extension_loaded('memcache')) { throw new Doctrine_Cache_Exception('In order to use Memcache driver, the memcache extension must be loaded.'); } parent::__construct($options); if (isset($options['servers'])) { $value= $options['servers']; if (isset($value['host'])) { $value = array(0 => $value); } $this->setOption('servers', $value); } $this->_memcache = new Memcache; foreach ($this->_options['servers'] as $server) { if ( ! array_key_exists('persistent', $server)) { $server['persistent'] = true; } if ( ! array_key_exists('port', $server)) { $server['port'] = 11211; } $this->_memcache->addServer($server['host'], $server['port'], $server['persistent']); } } protected function _doFetch($id, $testCacheValidity = true) { return $this->_memcache->get($id); } protected function _doContains($id) { return (bool) $this->_memcache->get($id); } protected function _doSave($id, $data, $lifeTime = false) { if ($this->_options['compression']) { $flag = MEMCACHE_COMPRESSED; } else { $flag = 0; } return $this->_memcache->set($id, $data, $flag, $lifeTime); } protected function _doDelete($id) { return $this->_memcache->delete($id); } protected function _getCacheKeys() { $keys = array(); $allSlabs = $this->_memcache->getExtendedStats('slabs'); foreach ($allSlabs as $server => $slabs) { foreach (array_keys($slabs) as $slabId) { $dump = $this->_memcache->getExtendedStats('cachedump', (int) $slabId); foreach ($dump as $entries) { if ($entries) { $keys = array_merge($keys, array_keys($entries)); } } } } return $keys; } }class Doctrine_Cache_Array extends Doctrine_Cache_Driver { protected $data = array(); protected function _doFetch($id, $testCacheValidity = true) { if (isset($this->data[$id])) { return $this->data[$id]; } return false; } protected function _doContains($id) { return isset($this->data[$id]); } protected function _doSave($id, $data, $lifeTime = false) { $this->data[$id] = $data; return true; } protected function _doDelete($id) { $exists = isset($this->data[$id]); unset($this->data[$id]); return $exists; } protected function _getCacheKeys() { return array_keys($this->data); } }class Doctrine_Cache_Apc extends Doctrine_Cache_Driver { public function __construct($options = array()) { if ( ! extension_loaded('apc')) { throw new Doctrine_Cache_Exception('The apc extension must be loaded for using this backend !'); } parent::__construct($options); } protected function _doFetch($id, $testCacheValidity = true) { return apc_fetch($id); } protected function _doContains($id) { $found = false; apc_fetch($id, $found); return $found; } protected function _doSave($id, $data, $lifeTime = false) { return apc_store($id, $data, $lifeTime); } protected function _doDelete($id) { return apc_delete($id); } protected function _getCacheKeys() { $ci = apc_cache_info('user'); $keys = array(); foreach ($ci['cache_list'] as $entry) { $keys[] = $entry['info']; } return $keys; } }class Doctrine_Cache_Exception extends Doctrine_Exception { }class Doctrine_Manager_Exception extends Doctrine_Exception { }class Doctrine_Util extends Doctrine_Connection_Module { }class Doctrine_Formatter extends Doctrine_Connection_Module { public function escapePattern($text) { if ( ! $this->string_quoting['escape_pattern']) { return $text; } $tmp = $this->conn->string_quoting; $text = str_replace($tmp['escape_pattern'], $tmp['escape_pattern'] . $tmp['escape_pattern'], $text); foreach ($this->wildcards as $wildcard) { $text = str_replace($wildcard, $tmp['escape_pattern'] . $wildcard, $text); } return $text; } public function convertBooleans($item) { if (is_array($item)) { foreach ($item as $k => $value) { if (is_bool($value)) { $item[$k] = (int) $value; } } } else { if (is_bool($item)) { $item = (int) $item; } } return $item; } public function quoteIdentifier($str, $checkOption = true) { if ($checkOption && ! $this->conn->getAttribute(Doctrine_Core::ATTR_QUOTE_IDENTIFIER)) { return $str; } $tmp = $this->conn->identifier_quoting; $str = str_replace($tmp['end'], $tmp['escape'] . $tmp['end'], $str); return $tmp['start'] . $str . $tmp['end']; } public function quoteMultipleIdentifier($arr, $checkOption = true) { foreach ($arr as $k => $v) { $arr[$k] = $this->quoteIdentifier($v, $checkOption); } return $arr; } public function quote($input, $type = null) { if ($type == null) { $type = gettype($input); } switch ($type) { case 'integer': case 'double': case 'float': case 'bool': case 'decimal': case 'int': return $input; case 'array': case 'object': $input = serialize($input); case 'date': case 'time': case 'timestamp': case 'string': case 'char': case 'varchar': case 'text': case 'gzip': case 'blob': case 'clob': case 'enum': case 'set': case 'boolean': return "'" . str_replace("'","''",$input) . "'"; } } public function fixSequenceName($sqn) { $seqPattern = '/^'.preg_replace('/%s/', '([a-z0-9_]+)', $this->conn->getAttribute(Doctrine_Core::ATTR_SEQNAME_FORMAT)).'$/i'; $seqName = preg_replace($seqPattern, '\\1', $sqn); if ($seqName && ! strcasecmp($sqn, $this->getSequenceName($seqName))) { return $seqName; } return $sqn; } public function fixIndexName($idx) { $indexPattern = '/^'.preg_replace('/%s/', '([a-z0-9_]+)', $this->conn->getAttribute(Doctrine_Core::ATTR_IDXNAME_FORMAT)).'$/i'; $indexName = preg_replace($indexPattern, '\\1', $idx); if ($indexName && ! strcasecmp($idx, $this->getIndexName($indexName))) { return $indexName; } return $idx; } public function getSequenceName($sqn) { return sprintf($this->conn->getAttribute(Doctrine_Core::ATTR_SEQNAME_FORMAT), preg_replace('/[^a-z0-9_\$.]/i', '_', $sqn)); } public function getIndexName($idx) { return sprintf($this->conn->getAttribute(Doctrine_Core::ATTR_IDXNAME_FORMAT), preg_replace('/[^a-z0-9_\$]/i', '_', $idx)); } public function getForeignKeyName($fkey) { return sprintf($this->conn->getAttribute(Doctrine_Core::ATTR_FKNAME_FORMAT), preg_replace('/[^a-z0-9_\$]/i', '_', $fkey)); } public function getTableName($table) { $format = $this->conn->getAttribute(Doctrine_Core::ATTR_TBLNAME_FORMAT); return sprintf($format, str_replace(sprintf($format, null), null, $table)); } } class Doctrine_Pager { protected $_query; protected $_countQuery; protected $_countQueryParams; protected $_numResults; protected $_maxPerPage; protected $_page; protected $_lastPage; protected $_executed; public function __construct($query, $page, $maxPerPage = 0) { $this->_setExecuted(false); $this->_setQuery($query); $this->_setPage($page); $this->setMaxPerPage($maxPerPage); } protected function _initialize($params = array()) { $countQuery = $this->getCountQuery(); $count = $countQuery->count($this->getCountQueryParams($params)); $this->_setNumResults($count); $this->_setExecuted(true); $this->_adjustOffset(); } protected function _adjustOffset() { $this->_setLastPage( max(1, ceil($this->getNumResults() / $this->getMaxPerPage())) ); $offset = ($this->getPage() - 1) * $this->getMaxPerPage(); $p = $this->getQuery(); $p->offset($offset); $p->limit($this->getMaxPerPage()); } public function getExecuted() { return $this->_executed; } protected function _setExecuted($executed) { $this->_executed = $executed; } public function getRange($rangeStyle, $options = array()) { $class = 'Doctrine_Pager_Range_' . ucfirst($rangeStyle); return new $class($options, $this); } public function getNumResults() { if ($this->getExecuted()) { return $this->_numResults; } throw new Doctrine_Pager_Exception( 'Cannot retrieve the number of results of a not yet executed Pager query' ); } protected function _setNumResults($nb) { $this->_numResults = $nb; } public function getFirstPage() { return 1; } public function getLastPage() { if ($this->getExecuted()) { return $this->_lastPage; } throw new Doctrine_Pager_Exception( 'Cannot retrieve the last page number of a not yet executed Pager query' ); } protected function _setLastPage($page) { $this->_lastPage = $page; if ($this->getPage() > $page) { $this->_setPage($page); } } public function getPage() { return $this->_page; } public function getNextPage() { if ($this->getExecuted()) { return min($this->getPage() + 1, $this->getLastPage()); } throw new Doctrine_Pager_Exception( 'Cannot retrieve the last page number of a not yet executed Pager query' ); } public function getPreviousPage() { if ($this->getExecuted()) { return max($this->getPage() - 1, $this->getFirstPage()); } throw new Doctrine_Pager_Exception( 'Cannot retrieve the previous page number of a not yet executed Pager query' ); } public function getFirstIndice() { return ($this->getPage() - 1) * $this->getMaxPerPage() + 1; } public function getLastIndice() { return min($this->getNumResults(), ($this->getPage() * $this->getMaxPerPage())); } public function haveToPaginate() { if ($this->getExecuted()) { return $this->getNumResults() > $this->getMaxPerPage(); } throw new Doctrine_Pager_Exception( 'Cannot know if it is necessary to paginate a not yet executed Pager query' ); } public function setPage($page) { $this->_setPage($page); $this->_setExecuted(false); } protected function _setPage($page) { $page = intval($page); $this->_page = ($page <= 0) ? 1 : $page; } public function getMaxPerPage() { return $this->_maxPerPage; } public function setMaxPerPage($max) { if ($max > 0) { $this->_maxPerPage = $max; } else if ($max == 0) { $this->_maxPerPage = 25; } else { $this->_maxPerPage = abs($max); } $this->_setExecuted(false); } public function getResultsInPage() { $page = $this->getPage(); if ($page != $this->getLastPage()) { return $this->getMaxPerPage(); } $offset = ($this->getPage() - 1) * $this->getMaxPerPage(); return abs($this->getNumResults() - $offset); } public function getQuery() { return $this->_query; } protected function _setQuery($query) { if (is_string($query)) { $query = Doctrine_Query::create() ->parseDqlQuery($query); } $this->_query = $query; } public function getCountQuery() { return ($this->_countQuery !== null) ? $this->_countQuery : $this->_query; } public function setCountQuery($query, $params = null) { if (is_string($query)) { $query = Doctrine_Query::create() ->parseDqlQuery($query); } $this->_countQuery = $query; $this->setCountQueryParams($params); $this->_setExecuted(false); } public function getCountQueryParams($defaultParams = array()) { return ($this->_countQueryParams !== null) ? $this->_countQueryParams : $defaultParams; } public function setCountQueryParams($params = array(), $append = false) { if ($append && is_array($this->_countQueryParams)) { $this->_countQueryParams = array_merge($this->_countQueryParams, $params); } else { if ($params !== null && !is_array($params)) { $params = array($params); } $this->_countQueryParams = $params; } $this->_setExecuted(false); } public function execute($params = array(), $hydrationMode = null) { if ( !$this->getExecuted()) { $this->_initialize($params); } return $this->getQuery()->execute($params, $hydrationMode); } }class Doctrine_Validator extends Doctrine_Locator_Injectable { private static $validators = array(); public static function getValidator($name) { if ( ! isset(self::$validators[$name])) { $class = 'Doctrine_Validator_' . ucwords(strtolower($name)); if (class_exists($class)) { self::$validators[$name] = new $class; } else if (class_exists($name)) { self::$validators[$name] = new $name; } else { throw new Doctrine_Exception("Validator named '$name' not available."); } } return self::$validators[$name]; } public function validateRecord(Doctrine_Record $record) { $table = $record->getTable(); $fields = $record->exists() ? $record->getModified():$record->getData(); foreach ($fields as $fieldName => $value) { $table->validateField($fieldName, $value, $record); } $table->validateUniques($record); } public static function validateLength($value, $type, $maximumLength) { if ($maximumLength === null ) { return true; } if ($type == 'timestamp' || $type == 'integer' || $type == 'enum') { return true; } else if ($type == 'array' || $type == 'object') { $length = strlen(serialize($value)); } else if ($type == 'decimal' || $type == 'float') { $value = abs($value); $localeInfo = localeconv(); $decimalPoint = $localeInfo['mon_decimal_point'] ? $localeInfo['mon_decimal_point'] : $localeInfo['decimal_point']; $e = explode($decimalPoint, $value); $length = strlen($e[0]); if (isset($e[1])) { $length = $length + strlen($e[1]); } } else if ($type == 'blob') { $length = strlen($value); } else { $length = self::getStringLength($value); } if ($length > $maximumLength) { return false; } return true; } public static function getStringLength($string) { if (function_exists('mb_strlen')) { return mb_strlen($string, 'utf8'); } else { return strlen(utf8_decode($string)); } } public function hasErrors() { return (count($this->stack) > 0); } public static function isValidType($var, $type) { if ($var instanceof Doctrine_Expression) { return true; } else if ($var === null) { return true; } else if (is_object($var)) { return $type == 'object'; } switch ($type) { case 'float': case 'double': case 'decimal': return (string) $var == strval(floatval($var)); case 'integer': return (string) $var == strval(round(floatval($var))); case 'string': return is_string($var) || is_numeric($var); case 'blob': return is_string($var) || is_resource($var); case 'clob': case 'gzip': return is_string($var); case 'array': return is_array($var); case 'object': return is_object($var); case 'boolean': return is_bool($var) || (is_numeric($var) && ($var == 0 || $var == 1)); case 'timestamp': $validator = self::getValidator('timestamp'); return $validator->validate($var); case 'time': $validator = self::getValidator('time'); return $validator->validate($var); case 'date': $validator = self::getValidator('date'); return $validator->validate($var); case 'enum': return is_string($var) || is_int($var); case 'set': return is_array($var) || is_string($var); default: return true; } } }abstract class Doctrine_Pager_Range { protected $_options; private $pager; final public function __construct($options = array(), $pager = null) { $this->_setOptions($options); if ($pager !== null) { $this->setPager($pager); } } public function getPager() { return $this->pager; } public function setPager($pager) { $this->pager = $pager; $this->_initialize(); } public function getOptions() { return $this->_options; } public function getOption($option) { if (isset($this->_options[$option])) { return $this->_options[$option]; } throw new Doctrine_Pager_Exception( 'Cannot access unexistent option \'' . $option . '\' in Doctrine_Pager_Range class' ); } protected function _setOptions($options) { $this->_options = $options; } public function isInRange($page) { return (array_search($page, $this->rangeAroundPage()) !== false); } abstract protected function _initialize(); abstract public function rangeAroundPage(); }class Doctrine_Pager_Range_Sliding extends Doctrine_Pager_Range { private $_chunkLength; protected function _initialize() { if (isset($this->_options['chunk'])) { $this->_setChunkLength($this->_options['chunk']); } else { throw new Doctrine_Pager_Exception('Missing parameter \'chunk\' that must be defined in options.'); } } public function getChunkLength() { return $this->_chunkLength; } protected function _setChunkLength($chunkLength) { $chunkLength = (int) $chunkLength; if ( !$chunkLength) { $chunkLength = 1; } else { $this->_chunkLength = $chunkLength; } } public function rangeAroundPage() { $pager = $this->getPager(); if ($pager->getExecuted()) { $page = $pager->getPage(); $pages = $pager->getLastPage(); $chunk = $this->getChunkLength(); if ($chunk > $pages) { $chunk = $pages; } $chunkStart = $page - (floor($chunk / 2)); $chunkEnd = $page + (ceil($chunk / 2)-1); if ($chunkStart < 1) { $adjust = 1 - $chunkStart; $chunkStart = 1; $chunkEnd = $chunkEnd + $adjust; } if ($chunkEnd > $pages) { $adjust = $chunkEnd - $pages; $chunkStart = $chunkStart - $adjust; $chunkEnd = $pages; } return range($chunkStart, $chunkEnd); } throw new Doctrine_Pager_Exception( 'Cannot retrieve the range around the page of a not yet executed Pager query' ); } }class Doctrine_Pager_Range_Jumping extends Doctrine_Pager_Range { private $_chunkLength; protected function _initialize() { if (isset($this->_options['chunk'])) { $this->_setChunkLength($this->_options['chunk']); } else { throw new Doctrine_Pager_Exception('Missing parameter \'chunk\' that must be define in options.'); } } public function getChunkLength() { return $this->_chunkLength; } protected function _setChunkLength($chunkLength) { $this->_chunkLength = $chunkLength; } public function rangeAroundPage() { $pager = $this->getPager(); if ($pager->getExecuted()) { $page = $pager->getPage(); $startPage = $page - ($page - 1) % $this->getChunkLength(); $endPage = ($startPage + $this->getChunkLength()) - 1; if ($endPage > $pager->getLastPage()) { $endPage = $pager->getLastPage(); } return range($startPage, $endPage); } throw new Doctrine_Pager_Exception( 'Cannot retrieve the range around the page of a not yet executed Pager query' ); } }class Doctrine_Pager_Layout { private $_pager; private $_pagerRange; private $_template; private $_selectedTemplate; private $_separatorTemplate; private $_urlMask; private $_maskReplacements = array(); public function __construct($pager, $pagerRange, $urlMask) { $this->_setPager($pager); $this->_setPagerRange($pagerRange); $this->_setUrlMask($urlMask); $this->setTemplate('[<a href="{%url}">{%page}</a>]'); $this->setSelectedTemplate(''); $this->setSeparatorTemplate(''); } public function getPager() { return $this->_pager; } protected function _setPager($pager) { $this->_pager = $pager; } public function execute($params = array(), $hydrationMode = null) { return $this->getPager()->execute($params, $hydrationMode); } public function getPagerRange() { return $this->_pagerRange; } protected function _setPagerRange($pagerRange) { $this->_pagerRange = $pagerRange; $this->getPagerRange()->setPager($this->getPager()); } public function getUrlMask() { return $this->_urlMask; } protected function _setUrlMask($urlMask) { $this->_urlMask = $urlMask; } public function getTemplate() { return $this->_template; } public function setTemplate($template) { $this->_template = $template; } public function getSelectedTemplate() { return $this->_selectedTemplate; } public function setSelectedTemplate($selectedTemplate) { $this->_selectedTemplate = $selectedTemplate; } public function getSeparatorTemplate() { return $this->_separatorTemplate; } public function setSeparatorTemplate($separatorTemplate) { $this->_separatorTemplate = $separatorTemplate; } public function addMaskReplacement($oldMask, $newMask, $asValue = false) { if (($oldMask = trim($oldMask)) != 'page_number') { $this->_maskReplacements[$oldMask] = array( 'newMask' => $newMask, 'asValue' => ($asValue === false) ? false : true ); } } public function removeMaskReplacement($oldMask) { if (isset($this->_maskReplacements[$oldMask])) { $this->_maskReplacements[$oldMask] = null; unset($this->_maskReplacements[$oldMask]); } } public function cleanMaskReplacements() { $this->_maskReplacements = null; $this->_maskReplacements = array(); } public function display($options = array(), $return = false) { $range = $this->getPagerRange()->rangeAroundPage(); $str = ''; for ($i = 0, $l = count($range); $i < $l; $i++) { $options['page_number'] = $range[$i]; $str .= $this->processPage($options); if ($i < $l - 1) { $str .= $this->getSeparatorTemplate(); } } if ($return) { return $str; } echo $str; } public function processPage($options = array()) { if ( !isset($options['page_number'])) { throw new Doctrine_Pager_Exception( 'Cannot process template of the given page. ' . 'Missing at least one of needed parameters: \'page\' or \'page_number\'' ); return ''; } if ( !isset($this->_maskReplacements['page']) && !isset($options['page'])) { $options['page'] = $options['page_number']; } return $this->_parseTemplate($options); } public function __toString() { return $this->display(array(), true); } protected function _parseTemplate($options = array()) { $str = $this->_parseUrlTemplate($options); $replacements = $this->_parseReplacementsTemplate($options); return strtr($str, $replacements); } protected function _parseUrlTemplate($options = array()) { $str = ''; if ($options['page_number'] == $this->getPager()->getPage()) { $str = $this->_parseMaskReplacements($this->getSelectedTemplate()); } if ($str == '') { $str = $this->_parseMaskReplacements($this->getTemplate()); } return $str; } protected function _parseReplacementsTemplate($options = array()) { $options['url'] = $this->_parseUrl($options); $replacements = array(); foreach ($options as $k => $v) { $replacements['{%'.$k.'}'] = $v; } return $replacements; } protected function _parseUrl($options = array()) { $str = $this->_parseMaskReplacements($this->getUrlMask()); $replacements = array(); foreach ($options as $k => $v) { $replacements['{%'.$k.'}'] = $v; } return strtr($str, $replacements); } protected function _parseMaskReplacements($str) { $replacements = array(); foreach ($this->_maskReplacements as $k => $v) { $replacements['{%'.$k.'}'] = ($v['asValue'] === true) ? $v['newMask'] : '{%'.$v['newMask'].'}'; } return strtr($str, $replacements); } }class Doctrine_Pager_Exception extends Doctrine_Exception { }abstract class Doctrine_Query_Part { protected $query; protected $_tokenizer; public function __construct($query, Doctrine_Query_Tokenizer $tokenizer = null) { $this->query = $query; if ( ! $tokenizer) { $tokenizer = new Doctrine_Query_Tokenizer(); } $this->_tokenizer = $tokenizer; } public function getQuery() { return $this->query; } } abstract class Doctrine_Query_Condition extends Doctrine_Query_Part { public function parse($str) { $tmp = trim($str); $parts = $this->_tokenizer->bracketExplode($str, array(' OR '), '(', ')'); if (count($parts) > 1) { $ret = array(); foreach ($parts as $part) { $part = $this->_tokenizer->bracketTrim($part, '(', ')'); $ret[] = $this->parse($part); } $r = implode(' OR ', $ret); } else { $parts = $this->_tokenizer->bracketExplode($str, array(' AND '), '(', ')'); $tmp = array(); for ($i = 0, $l = count($parts); $i < $l; $i++) { $test = $this->_tokenizer->sqlExplode($parts[$i]); if (count($test) == 3 && strtoupper($test[1]) == 'BETWEEN') { $tmp[] = $parts[$i] . ' AND ' . $parts[++$i]; } else if (count($test) == 4 && strtoupper($test[1]) == 'NOT' && strtoupper($test[2]) == 'BETWEEN') { $tmp[] = $parts[$i] . ' AND ' . $parts[++$i]; } else { $tmp[] = $parts[$i]; } } $parts = $tmp; unset($tmp); if (count($parts) > 1) { $ret = array(); foreach ($parts as $part) { $part = $this->_tokenizer->bracketTrim($part, '(', ')'); $ret[] = $this->parse($part); } $r = implode(' AND ', $ret); } else { if (substr($parts[0],0,1) == '(' && substr($parts[0], -1) == ')') { return $this->parse(substr($parts[0], 1, -1)); } else { if (strtoupper(substr($parts[0], 0, 4)) === 'NOT ') { $r = 'NOT ('.$this->parse(substr($parts[0], 4)).')'; } else { return $this->load($parts[0]); } } } } return '(' . $r . ')'; } public function parseLiteralValue($value) { if (strpos($value, '\'') === false) { $value = $this->query->getConnection() ->dataDict->parseBoolean($value); $a = explode('.', $value); if (count($a) > 1) { if ( ! is_numeric($a[0])) { $field = array_pop($a); $reference = implode('.', $a); $value = $this->query->getConnection()->quoteIdentifier( $this->query->getSqlTableAlias($reference). '.' . $field ); } } } else { } return $value; } } class Doctrine_Query_Offset extends Doctrine_Query_Part { public function parse($offset) { return (int) $offset; } }class Doctrine_Query_JoinCondition extends Doctrine_Query_Condition { public function load($condition) { $condition = trim($condition); $e = $this->_tokenizer->sqlExplode($condition); foreach ($e as $k => $v) { if ( ! $v) { unset($e[$k]); } } $e = array_values($e); if (($l = count($e)) > 2) { $leftExpr = $this->query->parseClause($e[0]); $operator = $e[1]; if ($l == 4) { $operator .= ' ' . $e[2]; $e[2] = $e[3]; unset($e[3]); } else if ($l >= 5) { $e[2] .= ' ' . $e[3] . ' ' . $e[4]; unset($e[3], $e[4]); } if (substr(trim($e[2]), 0, 1) != '(') { $expr = new Doctrine_Expression($e[2], $this->query->getConnection()); $e[2] = $expr->getSql(); } $rightMatches = array(); $hasRightAggExpression = $this->_processPossibleAggExpression($e[2], $rightMatches); $value = $e[2]; if (substr($value, 0, 1) == '(') { $trimmed = $this->_tokenizer->bracketTrim($value); $trimmed_upper = strtoupper($trimmed); if (substr($trimmed_upper, 0, 4) == 'FROM' || substr($trimmed_upper, 0, 6) == 'SELECT') { $q = $this->query->createSubquery() ->parseDqlQuery($trimmed, false); $value = '(' . $q->getSqlQuery() . ')'; $q->free(); } elseif (substr($trimmed_upper, 0, 4) == 'SQL:') { $value = substr($trimmed, 4); } else { $e = $this->_tokenizer->sqlExplode($trimmed, ','); $value = array(); foreach ($e as $part) { $value[] = $this->parseLiteralValue($part); } $value = '(' . implode(', ', $value) . ')'; } } elseif ( ! $hasRightAggExpression) { $e = $this->_tokenizer->bracketExplode($value, array(' AND ', ' \&\& '), '(', ')'); $value = array(); foreach ($e as $part) { $value[] = $this->parseLiteralValue($part); } $value = implode(' AND ', $value); } if ($hasRightAggExpression) { $rightExpr = $rightMatches[1] . '(' . $value . ')' . $rightMatches[3]; $rightExpr = $this->query->parseClause($rightExpr); } else { $rightExpr = $value; } $condition = $leftExpr . ' ' . $operator . ' ' . $rightExpr; return $condition; } $parser = new Doctrine_Query_Where($this->query, $this->_tokenizer); return $parser->parse($condition); } protected function _processPossibleAggExpression(& $expr, & $matches = array()) { $hasAggExpr = preg_match('/(.*[^\s\(\=])\(([^\)]*)\)(.*)/', $expr, $matches); if ($hasAggExpr) { $expr = $matches[2]; if (substr(trim($matches[3]), 0, 1) == ',') { $xplod = $this->_tokenizer->sqlExplode(trim($matches[3], ' )'), ','); $matches[3] = array(); foreach ($xplod as $part) { if ($part != '') { $matches[3][] = $this->parseLiteralValue($part); } } $matches[3] = '), ' . implode(', ', $matches[3]); } } return $hasAggExpr; } } class Doctrine_Query_Limit extends Doctrine_Query_Part { public function parse($limit) { return (int) $limit; } }class Doctrine_Query_Where extends Doctrine_Query_Condition { public function load($where) { $possibleOp = strtolower($where); if ($possibleOp == 'and' || $possibleOp == 'or') { return $where; } $where = $this->_tokenizer->bracketTrim(trim($where)); $conn = $this->query->getConnection(); $terms = $this->_tokenizer->sqlExplode($where); if (count($terms) > 1) { if (substr($where, 0, 6) == 'EXISTS') { return $this->parseExists($where, true); } elseif (preg_match('/^NOT\s+EXISTS\b/i', $where) !== 0) { return $this->parseExists($where, false); } } if (count($terms) < 3) { $terms = $this->_tokenizer->sqlExplode($where, array('=', '<', '<>', '>', '!=')); } if (count($terms) > 1) { $leftExpr = array_shift($terms); $rightExpr = array_pop($terms); $operator = trim(substr($where, strlen($leftExpr), -strlen($rightExpr))); if (strpos($leftExpr, "'") === false && strpos($leftExpr, '(') === false) { $a = explode('.', $leftExpr); array_pop($a); $reference = implode('.', $a); if (empty($reference)) { $map = $this->query->getRootDeclaration(); $alias = $this->query->getSqlTableAlias($this->query->getRootAlias()); } else { $map = $this->query->load($reference, false); $alias = $this->query->getSqlTableAlias($reference); } } $sql = $this->_buildSql($leftExpr, $operator, $rightExpr); return $sql; } else { return $where; } } protected function _buildSql($leftExpr, $operator, $rightExpr) { $leftExprOriginal = $leftExpr; $leftExpr = $this->query->parseClause($leftExpr); if ('BETWEEN' == strtoupper(substr($operator, 0, 7))) { $midExpr = trim(substr($operator, 7, -3)); $operator = 'BETWEEN ' . $this->query->parseClause($midExpr) . ' AND'; } if ('NOT BETWEEN' == strtoupper(substr($operator, 0, 11))) { $midExpr = trim(substr($operator, 11, -3)); $operator = 'NOT BETWEEN ' . $this->query->parseClause($midExpr) . ' AND'; } $op = strtolower($operator); $isInX = ($op == 'in' || $op == 'not in'); if (substr($rightExpr, 0 , 1) == ':' && $isInX) { throw new Doctrine_Query_Exception( 'Cannot use ' . $operator . ' with a named parameter in "' . $leftExprOriginal . ' ' . $operator . ' ' . $rightExpr . '"' ); } $rightExpr = ($rightExpr == '?' && $isInX) ? $this->_buildWhereInArraySqlPart($rightExpr) : $this->query->parseClause($rightExpr); return $leftExpr . ' ' . $operator . ' ' . $rightExpr; } protected function _buildWhereInArraySqlPart($rightExpr) { $params = $this->query->getInternalParams(); $value = array(); for ($i = 0, $l = count($params); $i < $l; $i++) { if (is_array($params[$i])) { $value = array_fill(0, count($params[$i]), $rightExpr); $this->query->adjustProcessedParam($i); break; } } return '(' . (count($value) > 0 ? implode(', ', $value) : $rightExpr) . ')'; } public function parseExists($where, $negation) { $operator = ($negation) ? 'EXISTS' : 'NOT EXISTS'; $pos = strpos($where, '('); if ($pos == false) { throw new Doctrine_Query_Exception('Unknown expression, expected a subquery with () -marks'); } $sub = $this->_tokenizer->bracketTrim(substr($where, $pos)); $q = $this->query->createSubquery()->parseDqlQuery($sub, false); $sql = $q->getSqlQuery(); $q->free(); return $operator . ' (' . $sql . ')'; } } class Doctrine_Query_Exception extends Doctrine_Exception { }class Doctrine_Query_Registry_Exception extends Doctrine_Query_Exception { }class Doctrine_Query_Check { protected $table; protected $sql; protected $_tokenizer; public function __construct($table) { if ( ! ($table instanceof Doctrine_Table)) { $table = Doctrine_Manager::getInstance() ->getCurrentConnection() ->getTable($table); } $this->table = $table; $this->_tokenizer = new Doctrine_Query_Tokenizer(); } public function getTable() { return $this->table; } public function parse($dql) { $this->sql = $this->parseClause($dql); } public function parseClause($dql) { $parts = $this->_tokenizer->sqlExplode($dql, ' AND '); if (count($parts) > 1) { $ret = array(); foreach ($parts as $part) { $ret[] = $this->parseSingle($part); } $r = implode(' AND ', $ret); } else { $parts = $this->_tokenizer->quoteExplode($dql, ' OR '); if (count($parts) > 1) { $ret = array(); foreach ($parts as $part) { $ret[] = $this->parseClause($part); } $r = implode(' OR ', $ret); } else { $ret = $this->parseSingle($dql); return $ret; } } return '(' . $r . ')'; } public function parseSingle($part) { $e = explode(' ', $part); $e[0] = $this->parseFunction($e[0]); switch ($e[1]) { case '>': case '<': case '=': case '!=': case '<>': break; default: throw new Doctrine_Query_Exception('Unknown operator ' . $e[1]); } return implode(' ', $e); } public function parseFunction($dql) { if (($pos = strpos($dql, '(')) !== false) { $func = substr($dql, 0, $pos); $value = substr($dql, ($pos + 1), -1); $expr = $this->table->getConnection()->expression; if ( ! method_exists($expr, $func)) { throw new Doctrine_Query_Exception('Unknown function ' . $func); } $func = $expr->$func($value); } return $func; } public function getSql() { return $this->sql; } }class Doctrine_Query_From extends Doctrine_Query_Part { public function parse($str, $return = false) { $str = trim($str); $parts = $this->_tokenizer->bracketExplode($str, 'JOIN '); $from = $return ? array() : null; $operator = false; switch (trim($parts[0])) { case 'INNER': $operator = ':'; case 'LEFT': array_shift($parts); break; } $last = ''; foreach ($parts as $k => $part) { $part = trim($part); if (empty($part)) { continue; } $e = explode(' ', $part); if (end($e) == 'INNER' || end($e) == 'LEFT') { $last = array_pop($e); } $part = implode(' ', $e); foreach ($this->_tokenizer->bracketExplode($part, ',') as $reference) { $reference = trim($reference); $e = explode(' ', $reference); $e2 = explode('.', $e[0]); if ($operator) { $e[0] = array_shift($e2) . $operator . implode('.', $e2); } if ($return) { $from[] = $e; } else { $table = $this->query->load(implode(' ', $e)); } } $operator = ($last == 'INNER') ? ':' : '.'; } return $from; } } class Doctrine_Query_Groupby extends Doctrine_Query_Part { public function parse($clause, $append = false) { $terms = $this->_tokenizer->clauseExplode($clause, array(' ', '+', '-', '*', '/', '<', '>', '=', '>=', '<=')); $str = ''; foreach ($terms as $term) { $pos = strpos($term[0], '('); $hasComma = false; if ($pos !== false) { $name = substr($term[0], 0, $pos); $term[0] = $this->query->parseFunctionExpression($term[0]); } else { if (substr($term[0], 0, 1) !== "'" && substr($term[0], -1) !== "'") { if (strpos($term[0], '.') !== false) { if ( ! is_numeric($term[0])) { $e = explode('.', $term[0]); $field = array_pop($e); if (($pos = strpos($field, ',')) !== false) { $field = substr($field, 0, $pos); $hasComma = true; } $conn = $this->query->getConnection(); if ($this->query->getType() === Doctrine_Query::SELECT) { $componentAlias = implode('.', $e); if (empty($componentAlias)) { $componentAlias = $this->query->getRootAlias(); } $this->query->load($componentAlias); $queryComponent = $this->query->getQueryComponent($componentAlias); $table = $queryComponent['table']; $def = $table->getDefinitionOf($field); $field = $table->getColumnName($field); if ( ! $def) { throw new Doctrine_Query_Exception('Unknown column ' . $field); } if (isset($def['owner'])) { $componentAlias = $componentAlias . '.' . $def['owner']; } $tableAlias = $this->query->getSqlTableAlias($componentAlias); $term[0] = $conn->quoteIdentifier($tableAlias) . '.' . $conn->quoteIdentifier($field); } else { $field = $this->query->getRoot()->getColumnName($field); $term[0] = $conn->quoteIdentifier($field); } } } else { if ( ! empty($term[0]) && ! is_numeric($term[0]) && $term[0] !== '?' && substr($term[0], 0, 1) !== ':') { $componentAlias = $this->query->getRootAlias(); $found = false; if (($pos = strpos($term[0], ',')) !== false) { $term[0] = substr($term[0], 0, $pos); $hasComma = true; } if ($componentAlias !== false && $componentAlias !== null) { $queryComponent = $this->query->getQueryComponent($componentAlias); $table = $queryComponent['table']; if ($table->hasField($term[0])) { $found = true; $def = $table->getDefinitionOf($term[0]); $term[0] = $table->getColumnName($term[0]); if (isset($def['owner'])) { $componentAlias = $componentAlias . '.' . $def['owner']; } $tableAlias = $this->query->getSqlTableAlias($componentAlias); $conn = $this->query->getConnection(); if ($this->query->getType() === Doctrine_Query::SELECT) { $term[0] = $conn->quoteIdentifier($tableAlias) . '.' . $conn->quoteIdentifier($term[0]); } else { $term[0] = $conn->quoteIdentifier($term[0]); } } else { $found = false; } } if ( ! $found) { $term[0] = $this->query->getSqlAggregateAlias($term[0]); } } } } } $str .= $term[0] . ($hasComma ? ',' : '') . $term[1]; } return $str; } } class Doctrine_Query_Tokenizer_Exception extends Doctrine_Exception { }class Doctrine_Query_Filter implements Doctrine_Query_Filter_Interface { public function preQuery(Doctrine_Query $query) { } public function postQuery(Doctrine_Query $query) { } }class Doctrine_Query_Registry { protected $_queries = array(); public function add($key, $query) { if ($query instanceof Doctrine_Query) { $query = clone $query; } if (strpos($key, '/') === false) { $this->_queries[$key] = $query; } else { $e = explode('/', $key); $this->_queries[$e[0]][$e[1]] = $query; } } public function get($key, $namespace = null) { if (isset($namespace)) { if ( ! isset($this->_queries[$namespace][$key])) { throw new Doctrine_Query_Registry_Exception('A query with the name ' . $namespace . '/' . $key . ' does not exist.'); } $query = $this->_queries[$namespace][$key]; } else { if ( ! isset($this->_queries[$key])) { throw new Doctrine_Query_Registry_Exception('A query with the name ' . $key . ' does not exist.'); } $query = $this->_queries[$key]; } if ( ! ($query instanceof Doctrine_Query)) { $query = Doctrine_Query::create() ->parseDqlQuery($query); } return clone $query; } public function has($key, $namespace = null) { return isset($namespace) ? isset($this->_queries[$namespace][$key]) : isset($this->_queries[$key]); } }class Doctrine_Query_Filter_Chain { protected $_filters = array(); public function add(Doctrine_Query_Filter $filter) { $this->_filters[] = $filter; } public function get($key) { if ( ! isset($this->_filters[$key])) { throw new Doctrine_Query_Exception('Unknown filter ' . $key); } return $this->_filters[$key]; } public function set($key, Doctrine_Query_Filter $listener) { $this->_filters[$key] = $listener; } public function preQuery(Doctrine_Query $query) { foreach ($this->_filters as $filter) { $filter->preQuery($query); } } public function postQuery(Doctrine_Query $query) { foreach ($this->_filters as $filter) { $filter->postQuery($query); } } }class Doctrine_Query_Tokenizer { public function tokenizeQuery($query) { $tokens = $this->sqlExplode($query, ' '); $parts = array(); foreach ($tokens as $index => $token) { $token = trim($token); switch (strtolower($token)) { case 'delete': case 'update': case 'select': case 'set': case 'from': case 'where': case 'limit': case 'offset': case 'having': $p = $token; $parts[$token] = ''; break; case 'order': case 'group': $i = ($index + 1); if (isset($tokens[$i]) && strtolower($tokens[$i]) === 'by') { $p = $token; $parts[$token] = ''; } else { $parts[$p] .= "$token "; } break; case 'by': continue; default: if ( ! isset($p)) { throw new Doctrine_Query_Tokenizer_Exception( "Couldn't tokenize query. Encountered invalid token: '$token'." ); } $parts[$p] .= "$token "; } } return $parts; } public function bracketTrim($str, $e1 = '(', $e2 = ')') { if (substr($str, 0, 1) === $e1 && substr($str, -1) === $e2) { return substr($str, 1, -1); } else { return $str; } } public function bracketExplode($str, $d = ' ', $e1 = '(', $e2 = ')') { if (is_string($d)) { $d = array($d); } $regexp = $this->getSplitRegExpFromArray($d) . 'i'; $terms = $this->clauseExplodeRegExp($str, $regexp, $e1, $e2); $res = array(); foreach ($terms as $value) { $res[] = trim($value[0]); } return $res; } public function quoteExplode($str, $d = ' ') { if (is_string($d)) { $d = array($d); } $regexp = $this->getSplitRegExpFromArray($d) . 'i'; $terms = $this->clauseExplodeCountBrackets($str, $regexp); $res = array(); foreach ($terms as $val) { $res[] = trim($val[0]); } return $res; } public function sqlExplode($str, $d = ' ', $e1 = '(', $e2 = ')') { if (is_string($d)) { $d = array($d); } $terms = $this->clauseExplode($str, $d, $e1, $e2); $res = array(); foreach ($terms as $value) { $res[] = trim($value[0]); } return $res; } public function clauseExplode($str, array $d, $e1 = '(', $e2 = ')') { $regexp = $this->getSplitRegExpFromArray($d); return $this->clauseExplodeRegExp($str, $regexp, $e1, $e2); } private function getSplitRegExpFromArray(array $d) { foreach ($d as $key => $string) { $escapedString = preg_quote($string); if (preg_match('#^\w+$#', $string)) { $escapedString = "\W$escapedString\W"; } $d[$key] = $escapedString; } if (in_array(' ', $d)) { $d[] = '\s'; } return '#(' . implode('|', $d) . ')#'; } private function clauseExplodeRegExp($str, $regexp, $e1 = '(', $e2 = ')') { $terms = $this->clauseExplodeCountBrackets($str, $regexp, $e1, $e2); $terms = $this->mergeBracketTerms($terms); foreach ($terms as & $val) { unset($val[2]); } return $terms; } private function clauseExplodeCountBrackets($str, $regexp, $e1 = '(', $e2 = ')') { $quoteTerms = $this->quotedStringExplode($str); $terms = array(); $i = 0; foreach ($quoteTerms as $key => $val) { if ($key & 1) { if ($terms[$i - 1][1] == '') { $terms[$i - 1][0] .= $val; } else { $terms[$i++] = array($val, '', 0); } } else { $subterms = $this->clauseExplodeNonQuoted($val, $regexp); foreach ($subterms as &$sub) { $c1 = substr_count($sub[0], $e1); $c2 = substr_count($sub[0], $e2); $sub[2] = $c1 - $c2; } if ($i > 0 && $terms[$i - 1][1] == '') { $first = array_shift($subterms); $idx = $i - 1; $terms[$idx][0] .= $first[0]; $terms[$idx][1] = $first[1]; $terms[$idx][2] += $first[2]; } $terms = array_merge($terms, $subterms); $i += sizeof($subterms); } } return $terms; } private function clauseExplodeNonQuoted($str, $regexp) { $str = preg_split($regexp, $str, -1, PREG_SPLIT_DELIM_CAPTURE); $term = array(); $i = 0; foreach ($str as $key => $val) { if ( ! ($key & 1)) { $term[$i] = array($val, ''); } else { $term[$i++][1] = $val; } } return $term; } private function mergeBracketTerms(array $terms) { $res = array(); $i = 0; foreach ($terms as $val) { if ( ! isset($res[$i])) { $res[$i] = array($val[0], $val[1], $val[2]); } else { $res[$i][0] .= $res[$i][1] . $val[0]; $res[$i][1] = $val[1]; $res[$i][2] += $val[2]; } if ($res[$i][2] == 0) { $i++; } } return $res; } public function quotedStringExplode($str) { $split = array_map('preg_quote', array("\\'","''","'", "\\\"", "\"\"", "\"")); $split = '#(' . implode('|', $split) . ')#'; $str = preg_split($split, $str, -1, PREG_SPLIT_DELIM_CAPTURE); $parts = array(); $mode = false; $i = 0; foreach ($str as $key => $val) { if ($key & 1) { if ( ! $mode) { if ($val == "'" || $val == "\"") { $mode = $val; $i++; } } else if ($mode == $val) { if ( ! isset($parts[$i])) { $parts[$i] = $val; } else { $parts[$i] .= $val; } $mode = false; $i++; continue; } } if ( ! isset($parts[$i])) { $parts[$i] = $val; } else { $parts[$i] .= $val; } } return $parts; } } class Doctrine_Query_Select extends Doctrine_Query_Part { public function parse($dql) { $this->query->parseSelect($dql); } } class Doctrine_Query_Parser { }class Doctrine_Query_Having extends Doctrine_Query_Condition { private function parseAggregateFunction($func) { $pos = strpos($func, '('); if ($pos === 0 && substr($func, 1, 6) == 'SELECT') { $sub = $this->_tokenizer->bracketTrim($func); $q = $this->query->createSubquery()->parseDqlQuery($sub, false); $sql = $q->getSqlQuery(); $q->free(); return '(' . $sql . ')'; } if ($pos !== false) { $funcs = array(); $name = substr($func, 0, $pos); $func = substr($func, ($pos + 1), -1); $params = $this->_tokenizer->bracketExplode($func, ',', '(', ')'); foreach ($params as $k => $param) { $params[$k] = $this->parseAggregateFunction($param); } $funcs = $name . '(' . implode(', ', $params) . ')'; return $funcs; } else { return $this->_parseAliases($func); } } final private function _parseAliases($value) { if ( ! is_numeric($value)) { $a = explode('.', $value); if (count($a) > 1) { $field = array_pop($a); $ref = implode('.', $a); $map = $this->query->load($ref, false); $field = $map['table']->getColumnName($field); $value = $this->query->getConnection()->quoteIdentifier($this->query->getSqlTableAlias($ref) . '.' . $field); } else { $field = end($a); if ($this->query->hasSqlAggregateAlias($field)) { $value = $this->query->getSqlAggregateAlias($field); } } } return $value; } final public function load($having) { $tokens = $this->_tokenizer->bracketExplode($having, ' ', '(', ')'); $part = $this->parseAggregateFunction(array_shift($tokens)); $operator = array_shift($tokens); $value = implode(' ', $tokens); $value = $this->parseAggregateFunction($value); $part .= ' ' . $operator . ' ' . $value; return $part; } } class Doctrine_Query_Orderby extends Doctrine_Query_Part { public function parse($clause, $append = false) { $terms = $this->_tokenizer->clauseExplode($clause, array(' ', ',', '+', '-', '*', '/', '<', '>', '=', '>=', '<=')); $str = ''; foreach ($terms as $term) { $pos = strpos($term[0], '('); $hasComma = false; if ($pos !== false) { $name = substr($term[0], 0, $pos); $term[0] = $this->query->parseFunctionExpression($term[0]); } else { if (substr($term[0], 0, 1) !== "'" && substr($term[0], -1) !== "'") { if (strpos($term[0], '.') !== false) { if ( ! is_numeric($term[0])) { $e = explode('.', $term[0]); $field = array_pop($e); if (($pos = strpos($field, ',')) !== false) { $field = substr($field, 0, $pos); $hasComma = true; } $conn = $this->query->getConnection(); if ($this->query->getType() === Doctrine_Query::SELECT) { $componentAlias = implode('.', $e); if (empty($componentAlias)) { $componentAlias = $this->query->getRootAlias(); } $this->query->load($componentAlias); $queryComponent = $this->query->getQueryComponent($componentAlias); $table = $queryComponent['table']; $def = $table->getDefinitionOf($field); $field = $table->getColumnName($field); if ( ! $def) { throw new Doctrine_Query_Exception('Unknown column ' . $field); } if (isset($def['owner'])) { $componentAlias = $componentAlias . '.' . $def['owner']; } $tableAlias = $this->query->getSqlTableAlias($componentAlias); $term[0] = $conn->quoteIdentifier($tableAlias) . '.' . $conn->quoteIdentifier($field); } else { $field = $this->query->getRoot()->getColumnName($field); $term[0] = $conn->quoteIdentifier($field); } } } else { if ( ! empty($term[0]) && ! is_numeric($term[0]) && $term[0] !== '?' && substr($term[0], 0, 1) !== ':') { $componentAlias = $this->query->getRootAlias(); $found = false; if (($pos = strpos($term[0], ',')) !== false) { $term[0] = substr($term[0], 0, $pos); $hasComma = true; } if ($componentAlias !== false && $componentAlias !== null) { $queryComponent = $this->query->getQueryComponent($componentAlias); $table = $queryComponent['table']; if ($table->hasField($term[0])) { $found = true; $def = $table->getDefinitionOf($term[0]); $term[0] = $table->getColumnName($term[0]); if (isset($def['owner'])) { $componentAlias = $componentAlias . '.' . $def['owner']; } $tableAlias = $this->query->getSqlTableAlias($componentAlias); $conn = $this->query->getConnection(); if ($this->query->getType() === Doctrine_Query::SELECT) { $term[0] = $conn->quoteIdentifier($tableAlias) . '.' . $conn->quoteIdentifier($term[0]); } else { $term[0] = $conn->quoteIdentifier($term[0]); } } else { $found = false; } } if ( ! $found) { $tmp = strtoupper(trim($term[0], ', ')); if ($tmp !== 'DESC' && $tmp !== 'ASC') { $term[0] = $this->query->getSqlAggregateAlias($term[0]); } } } } } } $str .= $term[0] . ($hasComma ? ',' : '') . $term[1]; } return $str; } } class Doctrine_Query_Set extends Doctrine_Query_Part { public function parse($dql) { $terms = $this->_tokenizer->sqlExplode($dql, ' '); $termsTranslation = array(); foreach ($terms as $term) { $termOriginal = $term; $matches = array(); $hasAggExpression = $this->_processPossibleAggExpression($term, $matches); $lftExpr = (($hasAggExpression) ? $matches[1] . '(' : ''); $rgtExpr = (($hasAggExpression) ? $matches[3] . ')' : ''); preg_match_all("/^([a-zA-Z0-9_]+[\.[a-zA-Z0-9_]+]*)(\sAS\s[a-zA-Z0-9_]+)?/i", $term, $m, PREG_SET_ORDER); if (isset($m[0])) { $processed = array(); foreach ($m as $piece) { $part = $piece[1]; $e = explode('.', trim($part)); $fieldName = array_pop($e); $reference = (count($e) > 0) ? implode('.', $e) : $this->query->getRootAlias(); $aliasMap = $this->query->getQueryComponent($reference); if ($aliasMap['table']->hasField($fieldName)) { $columnName = $aliasMap['table']->getColumnName($fieldName); $columnName = $aliasMap['table']->getConnection()->quoteIdentifier($columnName); $part = $columnName; } $processed[] = $part . (isset($piece[2]) ? $piece[2] : ''); } $termsTranslation[$termOriginal] = $lftExpr . implode(' ', $processed) . $rgtExpr; } } return strtr($dql, $termsTranslation); } protected function _processPossibleAggExpression(& $expr, & $matches = array()) { $hasAggExpr = preg_match('/(.*[^\s\(\=])\(([^\)]*)\)(.*)/', $expr, $matches); if ($hasAggExpr) { $expr = $matches[2]; if (substr(trim($matches[3]), 0, 1) == ',') { $xplod = $this->_tokenizer->sqlExplode(trim($matches[3], ' )'), ','); $matches[3] = array(); foreach ($xplod as $part) { if ($part != '') { $matches[3][] = $this->parseLiteralValue($part); } } $matches[3] = '), ' . implode(', ', $matches[3]); } } return $hasAggExpr; } }class Doctrine_Query_Forupdate extends Doctrine_Query_Part { public function parse($forUpdate) { return (bool) $forUpdate; } }class Doctrine_Migration { protected $_migrationTableName = 'migration_version', $_migrationTableCreated = false, $_connection, $_migrationClassesDirectory = array(), $_migrationClasses = array(), $_reflectionClass, $_errors = array(), $_process; protected static $_migrationClassesForDirectories = array(); public function __construct($directory = null, $connection = null) { $this->_reflectionClass = new ReflectionClass('Doctrine_Migration_Base'); if (is_null($connection)) { $this->_connection = Doctrine_Manager::connection(); } else { if (is_string($connection)) { $this->_connection = Doctrine_Manager::getInstance() ->getConnection($connection); } else { $this->_connection = $connection; } } $this->_process = new Doctrine_Migration_Process($this); if ($directory != null) { $this->_migrationClassesDirectory = $directory; $this->loadMigrationClassesFromDirectory(); } } public function getConnection() { return $this->_connection; } public function setConnection(Doctrine_Connection $conn) { $this->_connection = $conn; } public function getMigrationClassesDirectory() { return $this->_migrationClassesDirectory; } public function getTableName() { return $this->_migrationTableName; } public function setTableName($tableName) { $this->_migrationTableName = $this->_connection ->formatter->getTableName($tableName); } public function loadMigrationClassesFromDirectory($directory = null) { $directory = $directory ? $directory:$this->_migrationClassesDirectory; $classesToLoad = array(); $classes = get_declared_classes(); foreach ((array) $directory as $dir) { $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir), RecursiveIteratorIterator::LEAVES_ONLY); if (isset(self::$_migrationClassesForDirectories[$dir])) { foreach (self::$_migrationClassesForDirectories[$dir] as $num => $className) { $this->_migrationClasses[$num] = $className; } } foreach ($it as $file) { $info = pathinfo($file->getFileName()); if (isset($info['extension']) && $info['extension'] == 'php') { require_once($file->getPathName()); $array = array_diff(get_declared_classes(), $classes); $className = end($array); if ($className) { $e = explode('_', $file->getFileName()); $timestamp = $e[0]; $classesToLoad[$timestamp] = array('className' => $className, 'path' => $file->getPathName()); } } } } ksort($classesToLoad, SORT_NUMERIC); foreach ($classesToLoad as $class) { $this->loadMigrationClass($class['className'], $class['path']); } } public function loadMigrationClass($name, $path = null) { $class = new ReflectionClass($name); while ($class->isSubclassOf($this->_reflectionClass)) { $class = $class->getParentClass(); if ($class === false) { break; } } if ($class === false) { return false; } if (empty($this->_migrationClasses)) { $classMigrationNum = 1; } else { $nums = array_keys($this->_migrationClasses); $num = end($nums); $classMigrationNum = $num + 1; } $this->_migrationClasses[$classMigrationNum] = $name; if ($path) { $dir = dirname($path); self::$_migrationClassesForDirectories[$dir][$classMigrationNum] = $name; } } public function getMigrationClasses() { return $this->_migrationClasses; } public function setCurrentVersion($number) { if ($this->hasMigrated()) { $this->_connection->exec("UPDATE " . $this->_migrationTableName . " SET version = $number"); } else { $this->_connection->exec("INSERT INTO " . $this->_migrationTableName . " (version) VALUES ($number)"); } } public function getCurrentVersion() { $this->_createMigrationTable(); $result = $this->_connection->fetchColumn("SELECT version FROM " . $this->_migrationTableName); return isset($result[0]) ? $result[0]:0; } public function hasMigrated() { $this->_createMigrationTable(); $result = $this->_connection->fetchColumn("SELECT version FROM " . $this->_migrationTableName); return isset($result[0]) ? true:false; } public function getLatestVersion() { $versions = array_keys($this->_migrationClasses); rsort($versions); return isset($versions[0]) ? $versions[0]:0; } public function getNextVersion() { return $this->getLatestVersion() + 1; } public function getNextMigrationClassVersion() { if (empty($this->_migrationClasses)) { return 1; } else { $nums = array_keys($this->_migrationClasses); $num = end($nums) + 1; return $num; } } public function migrate($to = null, $dryRun = false) { $this->clearErrors(); $this->_createMigrationTable(); $this->_connection->beginTransaction(); try { if ($to === null) { $to = $this->getLatestVersion(); } $this->_doMigrate($to); } catch (Exception $e) { $this->addError($e); } if ($this->hasErrors()) { $this->_connection->rollback(); if ($dryRun) { return false; } else { $this->_throwErrorsException(); } } else { if ($dryRun) { $this->_connection->rollback(); if ($this->hasErrors()) { return false; } else { return $to; } } else { $this->_connection->commit(); $this->setCurrentVersion($to); return $to; } } return false; } public function migrateDryRun($to = null) { return $this->migrate($to, true); } public function getNumErrors() { return count($this->_errors); } public function getErrors() { return $this->_errors; } public function clearErrors() { $this->_errors = array(); } public function addError(Exception $e) { $this->_errors[] = $e; } public function hasErrors() { return $this->getNumErrors() > 0 ? true:false; } public function getMigrationClass($num) { if (isset($this->_migrationClasses[$num])) { $className = $this->_migrationClasses[$num]; return new $className(); } throw new Doctrine_Migration_Exception('Could not find migration class for migration step: '.$num); } protected function _throwErrorsException() { $messages = array(); $num = 0; foreach ($this->getErrors() as $error) { $num++; $messages[] = ' Error #' . $num . ' - ' .$error->getMessage() . "\n" . $error->getTraceAsString() . "\n"; } $title = $this->getNumErrors() . ' error(s) encountered during migration'; $message = $title . "\n"; $message .= str_repeat('=', strlen($title)) . "\n"; $message .= implode("\n", $messages); throw new Doctrine_Migration_Exception($message); } protected function _doMigrate($to) { $from = $this->getCurrentVersion(); if ($from == $to) { throw new Doctrine_Migration_Exception('Already at version # ' . $to); } $direction = $from > $to ? 'down':'up'; if ($direction === 'up') { for ($i = $from + 1; $i <= $to; $i++) { $this->_doMigrateStep($direction, $i); } } else { for ($i = $from; $i > $to; $i--) { $this->_doMigrateStep($direction, $i); } } return $to; } protected function _doMigrateStep($direction, $num) { try { $migration = $this->getMigrationClass($num); $method = 'pre' . $direction; $migration->$method(); if (method_exists($migration, $direction)) { $migration->$direction(); } else if (method_exists($migration, 'migrate')) { $migration->migrate($direction); } if ($migration->getNumChanges() > 0) { $changes = $migration->getChanges(); if ($direction == 'down' && method_exists($migration, 'migrate')) { $changes = array_reverse($changes); } foreach ($changes as $value) { list($type, $change) = $value; $funcName = 'process' . Doctrine_Inflector::classify($type); if (method_exists($this->_process, $funcName)) { try { $this->_process->$funcName($change); } catch (Exception $e) { $this->addError($e); } } else { throw new Doctrine_Migration_Exception(sprintf('Invalid migration change type: %s', $type)); } } } $method = 'post' . $direction; $migration->$method(); } catch (Exception $e) { $this->addError($e); } } protected function _createMigrationTable() { if ($this->_migrationTableCreated) { return true; } $this->_migrationTableCreated = true; try { $this->_connection->export->createTable($this->_migrationTableName, array('version' => array('type' => 'integer', 'size' => 11))); return true; } catch(Exception $e) { return false; } } }class Doctrine_Lib { public static function getRecordStateAsString($state) { switch ($state) { case Doctrine_Record::STATE_PROXY: return "proxy"; break; case Doctrine_Record::STATE_CLEAN: return "persistent clean"; break; case Doctrine_Record::STATE_DIRTY: return "persistent dirty"; break; case Doctrine_Record::STATE_TDIRTY: return "transient dirty"; break; case Doctrine_Record::STATE_TCLEAN: return "transient clean"; break; } } public static function getRecordAsString(Doctrine_Record $record) { $r[] = '<pre>'; $r[] = 'Component  : ' . $record->getTable()->getComponentName(); $r[] = 'ID         : ' . Doctrine_Core::dump($record->identifier()); $r[] = 'References : ' . count($record->getReferences()); $r[] = 'State      : ' . Doctrine_Lib::getRecordStateAsString($record->state()); $r[] = 'OID        : ' . $record->getOID(); $r[] = 'data       : ' . Doctrine_Core::dump($record->getData(), false); $r[] = '</pre>'; return implode("\n",$r)."<br />"; } public static function getConnectionStateAsString($state) { switch ($state) { case Doctrine_Transaction::STATE_SLEEP: return "open"; break; case Doctrine_Transaction::STATE_BUSY: return "busy"; break; case Doctrine_Transaction::STATE_ACTIVE: return "active"; break; } } public static function getConnectionAsString(Doctrine_Connection $connection) { $r[] = '<pre>'; $r[] = 'Doctrine_Connection object'; $r[] = 'State               : ' . Doctrine_Lib::getConnectionStateAsString($connection->transaction->getState()); $r[] = 'Open Transactions   : ' . $connection->transaction->getTransactionLevel(); $r[] = 'Table in memory     : ' . $connection->count(); $r[] = 'Driver name         : ' . $connection->getAttribute(Doctrine_Core::ATTR_DRIVER_NAME); $r[] = "</pre>"; return implode("\n",$r)."<br>"; } public static function getTableAsString(Doctrine_Table $table) { $r[] = "<pre>"; $r[] = "Component   : ".$table->getComponentName(); $r[] = "Table       : ".$table->getTableName(); $r[] = "</pre>"; return implode("\n",$r)."<br>"; } public static function formatSql($sql) { $e = explode("\n",$sql); $color = "367FAC"; $l = $sql; $l = str_replace("SELECT ", "<font color='$color'><b>SELECT </b></font><br \>  ",$l); $l = str_replace("FROM ", "<font color='$color'><b>FROM </b></font><br \>",$l); $l = str_replace(" LEFT JOIN ", "<br \><font color='$color'><b> LEFT JOIN </b></font>",$l); $l = str_replace(" INNER JOIN ", "<br \><font color='$color'><b> INNER JOIN </b></font>",$l); $l = str_replace(" WHERE ", "<br \><font color='$color'><b> WHERE </b></font>",$l); $l = str_replace(" GROUP BY ", "<br \><font color='$color'><b> GROUP BY </b></font>",$l); $l = str_replace(" HAVING ", "<br \><font color='$color'><b> HAVING </b></font>",$l); $l = str_replace(" AS ", "<font color='$color'><b> AS </b></font><br \>  ",$l); $l = str_replace(" ON ", "<font color='$color'><b> ON </b></font>",$l); $l = str_replace(" ORDER BY ", "<font color='$color'><b> ORDER BY </b></font><br \>",$l); $l = str_replace(" LIMIT ", "<font color='$color'><b> LIMIT </b></font><br \>",$l); $l = str_replace(" OFFSET ", "<font color='$color'><b> OFFSET </b></font><br \>",$l); $l = str_replace("  ", "<dd>",$l); return $l; } public static function getCollectionAsString(Doctrine_Collection $collection) { $r[] = "<pre>"; $r[] = get_class($collection); $r[] = 'data : ' . Doctrine_Core::dump($collection->getData(), false); $r[] = "</pre>"; return implode("\n",$r); } public static function arrayDeepMerge() { switch (func_num_args()) { case 0: return false; case 1: return func_get_arg(0); case 2: $args = func_get_args(); $args[2] = array(); if (is_array($args[0]) && is_array($args[1])) { foreach (array_unique(array_merge(array_keys($args[0]),array_keys($args[1]))) as $key) { $isKey0 = array_key_exists($key, $args[0]); $isKey1 = array_key_exists($key, $args[1]); if ($isKey0 && $isKey1 && is_array($args[0][$key]) && is_array($args[1][$key])) { $args[2][$key] = self::arrayDeepMerge($args[0][$key], $args[1][$key]); } else if ($isKey0 && $isKey1) { $args[2][$key] = $args[1][$key]; } else if ( ! $isKey1) { $args[2][$key] = $args[0][$key]; } else if ( ! $isKey0) { $args[2][$key] = $args[1][$key]; } } return $args[2]; } else { return $args[1]; } default: $args = func_get_args(); $args[1] = self::arrayDeepMerge($args[0], $args[1]); array_shift($args); return call_user_func_array(array('Doctrine_Lib', 'arrayDeepMerge'), $args); break; } } public static function makeDirectories($path, $mode = 0777) { if ( ! $path) { return false; } if (is_dir($path) || is_file($path)) { return true; } return mkdir(trim($path), $mode, true); } public static function removeDirectories($folderPath) { if (is_dir($folderPath)) { foreach (scandir($folderPath) as $value) { if ($value != '.' && $value != '..') { $value = $folderPath . "/" . $value; if (is_dir($value)) { self::removeDirectories($value); } else if (is_file($value)) { unlink($value); } } } return rmdir($folderPath); } else { return false; } } public static function copyDirectory($source, $dest) { if (is_file($source)) { return copy($source, $dest); } if ( ! is_dir($dest)) { mkdir($dest); } $dir = dir($source); while (false !== $entry = $dir->read()) { if ($entry == '.' || $entry == '..') { continue; } if ($dest !== "$source/$entry") { self::copyDirectory("$source/$entry", "$dest/$entry"); } } $dir->close(); return true; } public static function isValidClassName($className) { if (preg_match('~(^[a-z])|(_[a-z])|([\W])|(_{2})~', $className)) { return false; } return true; } } interface Doctrine_Node_Interface { public function hasPrevSibling(); public function hasNextSibling(); public function hasChildren(); public function hasParent(); public function getPrevSibling(); public function getNextSibling(); public function getSiblings($includeNode = false); public function getFirstChild(); public function getLastChild(); public function getChildren(); public function getDescendants(); public function getParent(); public function getAncestors(); public function getPath($seperator = ' > ', $includeNode = false); public function getLevel(); public function getNumberChildren(); public function getNumberDescendants(); public function insertAsParentOf(Doctrine_Record $dest); public function insertAsPrevSiblingOf(Doctrine_Record $dest); public function insertAsNextSiblingOf(Doctrine_Record $dest); public function insertAsFirstChildOf(Doctrine_Record $dest); public function insertAsLastChildOf(Doctrine_Record $dest); public function moveAsPrevSiblingOf(Doctrine_Record $dest); public function moveAsNextSiblingOf(Doctrine_Record $dest); public function moveAsFirstChildOf(Doctrine_Record $dest); public function moveAsLastChildOf(Doctrine_Record $dest); public function addChild(Doctrine_Record $record); public function isLeaf(); public function isRoot(); public function isEqualTo(Doctrine_Record $subj); public function isDescendantOf(Doctrine_Record $subj); public function isDescendantOfOrEqualTo(Doctrine_Record $subj); public function isValidNode(); public function delete(); } interface Doctrine_Tree_Interface { public function createRoot(Doctrine_Record $record = null); public function fetchRoot($root_id = 1); public function fetchTree($options = array(), $hydrationMode = null); public function fetchBranch($pk, $options = array(), $hydrationMode = null); }interface Doctrine_Record_Listener_Interface { public function setOption($name, $value = null); public function getOptions(); public function getOption($name); public function preSerialize(Doctrine_Event $event); public function postSerialize(Doctrine_Event $event); public function preUnserialize(Doctrine_Event $event); public function postUnserialize(Doctrine_Event $event); public function preSave(Doctrine_Event $event); public function postSave(Doctrine_Event $event); public function preDelete(Doctrine_Event $event); public function postDelete(Doctrine_Event $event); public function preUpdate(Doctrine_Event $event); public function postUpdate(Doctrine_Event $event); public function preInsert(Doctrine_Event $event); public function postInsert(Doctrine_Event $event); public function preHydrate(Doctrine_Event $event); public function postHydrate(Doctrine_Event $event); }interface Doctrine_Adapter_Interface { public function prepare($prepareString); public function query($queryString); public function quote($input); public function exec($statement); public function lastInsertId(); public function beginTransaction(); public function commit(); public function rollBack(); public function errorCode(); public function errorInfo(); public function setAttribute($attribute, $value); public function getAttribute($attribute); }interface Doctrine_Adapter_Statement_Interface { public function bindColumn($column, $param, $type = null); public function bindValue($param, $value, $type = null); public function bindParam($column, &$variable, $type = null, $length = null, $driverOptions = array()); public function closeCursor(); public function columnCount(); public function errorCode(); public function errorInfo(); public function execute($params = null); public function fetch($fetchStyle = Doctrine_Core::FETCH_BOTH, $cursorOrientation = Doctrine_Core::FETCH_ORI_NEXT, $cursorOffset = null); public function fetchAll($fetchStyle = Doctrine_Core::FETCH_BOTH); public function fetchColumn($columnIndex = 0); public function fetchObject($className = 'stdClass', $args = array()); public function getAttribute($attribute); public function getColumnMeta($column); public function nextRowset(); public function rowCount(); public function setAttribute($attribute, $value); public function setFetchMode($mode, $arg1 = null, $arg2 = null); }interface Doctrine_Overloadable { public function __call($m, $a); } interface Doctrine_EventListener_Interface { public function preTransactionCommit(Doctrine_Event $event); public function postTransactionCommit(Doctrine_Event $event); public function preTransactionRollback(Doctrine_Event $event); public function postTransactionRollback(Doctrine_Event $event); public function preTransactionBegin(Doctrine_Event $event); public function postTransactionBegin(Doctrine_Event $event); public function postConnect(Doctrine_Event $event); public function preConnect(Doctrine_Event $event); public function preQuery(Doctrine_Event $event); public function postQuery(Doctrine_Event $event); public function prePrepare(Doctrine_Event $event); public function postPrepare(Doctrine_Event $event); public function preExec(Doctrine_Event $event); public function postExec(Doctrine_Event $event); public function preError(Doctrine_Event $event); public function postError(Doctrine_Event $event); public function preFetch(Doctrine_Event $event); public function postFetch(Doctrine_Event $event); public function preFetchAll(Doctrine_Event $event); public function postFetchAll(Doctrine_Event $event); public function preStmtExecute(Doctrine_Event $event); public function postStmtExecute(Doctrine_Event $event); } interface Doctrine_Search_Analyzer_Interface { public function analyze($text); }interface Doctrine_Cache_Interface { public function fetch($id, $testCacheValidity = true); public function contains($id); public function save($id, $data, $lifeTime = false); public function delete($id); }interface Doctrine_Query_Filter_Interface { public function preQuery(Doctrine_Query $query); public function postQuery(Doctrine_Query $query); }