/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "igenericprop.h"


#include <vtkProp.h>


#define IGENERICPROP_RENDER(_fun_) \
	if(mEnabled) \
	{ \
		ret = 0; \
		for(j=0; j<mProps.Size(); j++) if(mProps[j]->GetVisibility() != 0) \
		{ \
			ret += mProps[j]->_fun_(vp); \
		} \
		if(mSelf) ret += this->Prop::_fun_(vp); \
	} \
	else ret = 0



template<class Prop>
iGenericProp<Prop>::iGenericProp(bool self) : mSelf(self)
{
	mDirty = mEnabled = true;
}


template<class Prop>
void iGenericProp<Prop>::MakeUpTodate(vtkViewport *vp)
{
	if(mDirty)
	{
		this->UpdateGeometry(vp);
		mDirty = false;
	}
}


template<class Prop>
void iGenericProp<Prop>::Reset()
{
}


template<class Prop>
void iGenericProp<Prop>::UpdateOverlay(vtkViewport *)
{
}


template<class Prop>
int iGenericProp<Prop>::RenderOverlay(vtkViewport *vp)
{
	int j, ret;

	this->MakeUpTodate(vp);
	
	if(mEnabled) this->UpdateOverlay(vp);

	IGENERICPROP_RENDER(RenderOverlay);

	this->Reset();
	mDirty = mEnabled = true;
	mLastRenderMTime.Modified();

	return ret;
}


template<class Prop>
int iGenericProp<Prop>::RenderOpaqueGeometry(vtkViewport *vp)
{
	int j, ret;

	this->MakeUpTodate(vp);
	
	IGENERICPROP_RENDER(RenderOpaqueGeometry);
	return ret;
}


#ifdef IVTK_PRE52


template<class Prop>
int iGenericProp<Prop>::RenderTranslucentGeometry(vtkViewport *vp)
{
	int j, ret;

	this->MakeUpTodate(vp);

	IGENERICPROP_RENDER(RenderTranslucentGeometry);
	return ret;
}


#else


template<class Prop>
int iGenericProp<Prop>::HasTranslucentPolygonalGeometry()
{
	int j;

	if(mEnabled)
	{
		for(j=0; j<mProps.Size(); j++) if(mProps[j]->GetVisibility() != 0)
		{
			if(mProps[j]->HasTranslucentPolygonalGeometry() != 0) return 1;
		}
		if(mSelf && this->Prop::HasTranslucentPolygonalGeometry()!=0) return 1;
	}

	return 0;
}


template<class Prop>
int iGenericProp<Prop>::RenderTranslucentPolygonalGeometry(vtkViewport *vp)
{
	int j, ret;

	this->MakeUpTodate(vp);

	IGENERICPROP_RENDER(RenderTranslucentPolygonalGeometry);
	return ret;
}


template<class Prop>
int iGenericProp<Prop>::RenderVolumetricGeometry(vtkViewport *vp)
{
	int j, ret;

	this->MakeUpTodate(vp);

	IGENERICPROP_RENDER(RenderVolumetricGeometry);
	return ret;
}


#endif

template<class Prop>
void iGenericProp<Prop>::ReleaseGraphicsResources(vtkWindow *win)
{
	int j;

	for(j=0; j<mProps.Size(); j++)
	{
		mProps[j]->ReleaseGraphicsResources(win);
	}
	if(mSelf) this->Prop::ReleaseGraphicsResources(win);
}


template<class Prop>
void iGenericProp<Prop>::PrependComponent(vtkProp *p)
{
	if(p!=0 && p!=this)
	{
		p->SetVisibility(1);
		mProps.Add(p);
		//
		//  Reorder
		//
		int i;
		for(i=mProps.MaxIndex(); i>0; i--)
		{
			mProps[i] = mProps[i-1];
		}
		mProps[0] = p;
	}
}


template<class Prop>
void iGenericProp<Prop>::AppendComponent(vtkProp *p)
{
	if(p!=0 && p!=this)
	{
		p->SetVisibility(1);
		mProps.Add(p);
	}
}


template<class Prop>
void iGenericProp<Prop>::RemoveComponent(vtkProp *p)
{
	mProps.Remove(p);
}


template<class Prop>
void iGenericProp<Prop>::RemoveAllComponents()
{
	mProps.Clear();
}


template<class Prop>
void iGenericProp<Prop>::ToggleComponent(vtkProp *p)
{
	int j;

	for(j=0; j<mProps.Size(); j++)
	{
		mProps[j]->SetVisibility(0);
	}
	j = mProps.Find(p);
	if(j > -1) p->SetVisibility(1);
}


template<class Prop>
void iGenericProp<Prop>::ShowComponents(int n, vtkProp **p)
{
	int i, j;
	for(j=0; j<mProps.Size(); j++)
	{
		mProps[j]->SetVisibility(0);
	}

	for(i=0; i<n; i++)
	{
		j = mProps.Find(p[i]);
		if(j > -1) p[i]->SetVisibility(1);
	}
}


template<class Prop>
void iGenericProp<Prop>::Disable()
{
	mEnabled = false;
}

