/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import jonelo.jacksum.JacksumAPI;
import jonelo.jacksum.algorithm.AbstractChecksum;
import jonelo.jacksum.cli.JacksumHelp;
import jonelo.jacksum.ui.CheckFile;
import jonelo.jacksum.ui.MetaInfo;
import jonelo.jacksum.ui.MetaInfoVersionException;
import jonelo.jacksum.ui.Summary;
import jonelo.jacksum.ui.Verbose;
import jonelo.jacksum.util.Service;
import jonelo.sugar.util.EncodingException;
import jonelo.sugar.util.ExitException;
import jonelo.sugar.util.GeneralProgram;
import jonelo.sugar.util.GeneralString;

public class Jacksum {
    public static final String DEFAULT = "default";
    public static final String TIMESTAMPFORMAT_DEFAULT = "yyyyMMddHHmmss";
    private AbstractChecksum checksum;
    private String checksumArg;
    private String expected;
    private String format;
    private String outputFile;
    private String errorFile;
    private char fileseparatorChar;
    private char groupingChar;
    private boolean _f;
    private boolean _x;
    private boolean _X;
    private boolean _r;
    private boolean _t;
    private boolean _m;
    private boolean _p;
    private boolean _o;
    private boolean _I;
    private boolean _O;
    private boolean _u;
    private boolean _U;
    private boolean _l;
    private boolean _d;
    private boolean _S;
    private boolean _e;
    private boolean _F;
    private boolean _alternate;
    private boolean _P;
    private boolean _g;
    private boolean _G;
    private boolean _V;
    private boolean _w;
    private MetaInfo metaInfo;
    private Verbose verbose;
    private Summary summary;
    private String workingDir;
    private int workingdirlen;
    private boolean windows;

    public static void main(String[] stringArray) {
        try {
            new Jacksum(stringArray);
        }
        catch (ExitException exitException) {
            if (exitException.getMessage() != null) {
                System.err.println(exitException.getMessage());
            }
            System.exit(exitException.getExitCode());
        }
    }

    private void recursDir(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            if (!this._d || this._d && !Service.isSymbolicLink(file)) {
                String[] stringArray = file.list();
                if (stringArray == null) {
                    System.err.println("Jacksum: Can't access file system folder \"" + file + "\"");
                    this.summary.addErrorDir();
                } else {
                    int n;
                    Object object;
                    this.summary.addDir();
                    if (!(this._e || this._p || this._S)) {
                        object = file.toString();
                        if (this._w && ((String)object).length() > this.workingdirlen) {
                            object = ((String)object).substring(this.workingdirlen);
                        } else if (this._w && ((String)object).length() < this.workingdirlen) {
                            object = "";
                        }
                        if (this._P) {
                            System.out.println("\n" + ((String)object).replace(File.separatorChar, this.fileseparatorChar) + ":");
                        } else {
                            System.out.println("\n" + (String)object + ":");
                        }
                    }
                    object = new ArrayList();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
                    String string2 = file.toString();
                    boolean bl = true;
                    if (string2.length() > 0 && !string2.endsWith(File.separator)) {
                        if (this.windows && string2.endsWith(":")) {
                            bl = false;
                        }
                        if (bl) {
                            string2 = string2 + File.separator;
                        }
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        File file2 = new File(string2 + stringArray[n]);
                        if (file2.isDirectory()) {
                            ((ArrayList)object).add(stringArray[n]);
                            continue;
                        }
                        arrayList.add(stringArray[n]);
                    }
                    if (!(!this.verbose.getDetails() || this._e || this._m || this._p || this._S)) {
                        StringBuffer stringBuffer = new StringBuffer(32);
                        stringBuffer.append(arrayList.size());
                        stringBuffer.append(" file");
                        if (arrayList.size() != 1) {
                            stringBuffer.append('s');
                        }
                        if (!this._f) {
                            stringBuffer.append(", ");
                            stringBuffer.append(((ArrayList)object).size());
                            stringBuffer.append(" director");
                            if (((ArrayList)object).size() != 1) {
                                stringBuffer.append("ies");
                            } else {
                                stringBuffer.append("y");
                            }
                        }
                        System.err.println(stringBuffer.toString());
                    }
                    for (n = 0; n < arrayList.size(); ++n) {
                        this.recursDir(string2 + arrayList.get(n));
                    }
                    if (!this._f) {
                        for (n = 0; n < ((ArrayList)object).size(); ++n) {
                            System.err.println("Jacksum: " + ((ArrayList)object).get(n) + ": Is a directory");
                        }
                    }
                    for (n = 0; n < ((ArrayList)object).size(); ++n) {
                        this.recursDir(string2 + ((ArrayList)object).get(n));
                    }
                }
            }
        } else {
            this.processItem(string);
        }
    }

    private void oneDir(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray == null) {
                System.err.println("Jacksum: Can't access file system folder \"" + file + "\"");
                this.summary.addErrorDir();
            } else {
                this.summary.addDir();
                Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = string + (string.endsWith(File.separator) ? "" : File.separator) + stringArray[i];
                    File file2 = new File(string2);
                    if (file2.isDirectory()) {
                        if (this._f) continue;
                        System.err.println("Jacksum: " + stringArray[i] + ": Is a directory");
                        continue;
                    }
                    this.processItem(string2);
                }
            }
        } else {
            this.processItem(string);
        }
    }

    private void processItem(String string) {
        File file = new File(string);
        if (file.isFile()) {
            if (this._o || this._O) {
                try {
                    if (new File(this.outputFile).getCanonicalPath().equals(file.getCanonicalPath())) {
                        return;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Jacksum: Error: " + exception);
                }
            }
            if (this._u || this._U) {
                try {
                    if (new File(this.errorFile).getCanonicalPath().equals(file.getCanonicalPath())) {
                        return;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Jacksum: Error: " + exception);
                }
            }
            try {
                if (this._S) {
                    String string2;
                    long l = this.checksum.readFile(string, false);
                    if (this.checksum.isTimestampWanted()) {
                        this.checksum.update(this.checksum.getTimestampFormatted().getBytes("ISO-8859-1"));
                    }
                    String string3 = string2 = this._w ? string.substring(this.workingdirlen) : string;
                    if (File.separatorChar != '/') {
                        string2 = string2.replace(File.separatorChar, '/');
                    }
                    this.checksum.update(string2.getBytes("ISO-8859-1"));
                    this.summary.addBytes(l);
                } else {
                    if (this._e) {
                        this.checksum.readFile(string, true);
                        this.expectationContinue(this.checksum, this.expected);
                    } else {
                        String string4 = this.getChecksumOutput(string);
                        if (string4 != null) {
                            if (this._P && File.separatorChar != this.fileseparatorChar) {
                                string4 = string4.replace(File.separatorChar, this.fileseparatorChar);
                            }
                            System.out.println(string4);
                        }
                    }
                    this.summary.addBytes(this.checksum.getLength());
                }
                this.summary.addFile();
            }
            catch (Exception exception) {
                this.summary.addErrorFile();
                String string5 = null;
                string5 = this.verbose.getDetails() ? string + " [" + exception.getMessage() + "]" : string;
                System.err.println("Jacksum: Error: " + string5);
            }
        } else if (!this._f) {
            this.summary.addErrorFile();
            System.err.println("Jacksum: " + string + ": Is not a regular file");
        }
    }

    private String getChecksumOutput(String string) throws IOException {
        this.checksum.readFile(string, true);
        File file = new File(string);
        if (this._r && !this._p) {
            this.checksum.setFilename(file.getName());
        } else {
            if (this._w) {
                string = string.substring(this.workingdirlen);
            }
            this.checksum.setFilename(string);
        }
        return this._F ? this.checksum.format(this.format) : this.checksum.toString();
    }

    private void expectation(AbstractChecksum abstractChecksum, String string) throws ExitException {
        String string2 = abstractChecksum.getFormattedValue();
        if (abstractChecksum.getEncoding().equalsIgnoreCase("base64") ? string2.equals(string) : string2.equalsIgnoreCase(string)) {
            System.out.println("[OK]");
            throw new ExitException(null, 0);
        }
        System.out.println("[MISMATCH]");
        throw new ExitException(null, 1);
    }

    private void expectationContinue(AbstractChecksum abstractChecksum, String string) {
        String string2 = abstractChecksum.getFormattedValue();
        if (abstractChecksum.getEncoding().equalsIgnoreCase("base64") ? string2.equals(string) : string2.equalsIgnoreCase(string)) {
            System.out.println(this._F ? abstractChecksum.format(this.format) : abstractChecksum.toString());
        }
    }

    private static String decodeQuoteAndSeparator(String string, String string2) {
        String string3 = string;
        if (string2 != null) {
            string3 = GeneralString.replaceAllStrings(string3, "#SEPARATOR", string2);
        }
        string3 = GeneralString.replaceAllStrings(string3, "#QUOTE", "\"");
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Jacksum(String[] stringArray) throws ExitException {
        block160: {
            Object object;
            String string;
            Object object2;
            Object object3;
            Object object4;
            this.checksum = null;
            this.checksumArg = null;
            this.expected = null;
            this.format = null;
            this.outputFile = null;
            this.errorFile = null;
            this.fileseparatorChar = (char)47;
            this.groupingChar = (char)32;
            this._f = false;
            this._x = false;
            this._X = false;
            this._r = false;
            this._t = false;
            this._m = false;
            this._p = false;
            this._o = false;
            this._I = false;
            this._O = false;
            this._u = false;
            this._U = false;
            this._l = false;
            this._d = false;
            this._S = false;
            this._e = false;
            this._F = false;
            this._alternate = false;
            this._P = false;
            this._g = false;
            this._G = false;
            this._V = false;
            this._w = false;
            this.metaInfo = null;
            this.verbose = null;
            this.summary = null;
            this.workingDir = null;
            this.workingdirlen = 0;
            this.windows = false;
            GeneralProgram.requiresMinimumJavaVersion("1.3.1");
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            int n = 0;
            this.metaInfo = new MetaInfo();
            this.verbose = new Verbose();
            this.summary = new Summary();
            if (stringArray.length == 0) {
                JacksumHelp.printHelpShort();
            } else if (stringArray.length > 0) {
                while (n < stringArray.length && stringArray[n].startsWith("-")) {
                    Object object5;
                    if ((string2 = stringArray[n++]).equals("-a")) {
                        if (n >= stringArray.length) throw new ExitException("Option -a requires an algorithm. Use -h for help. Exit.", 2);
                        this.checksumArg = string2 = stringArray[n++].toLowerCase();
                        continue;
                    }
                    if (string2.equals("-s")) {
                        if (n >= stringArray.length) throw new ExitException("Option -s requires a separator string. Use -h for help. Exit.", 2);
                        bl2 = true;
                        string2 = stringArray[n++];
                        this.metaInfo.setSeparator(GeneralString.translateEscapeSequences(string2));
                        continue;
                    }
                    if (string2.equals("-f")) {
                        this._f = true;
                        continue;
                    }
                    if (string2.equals("-")) {
                        bl = true;
                        continue;
                    }
                    if (string2.equals("-r")) {
                        this._r = true;
                        continue;
                    }
                    if (string2.equals("-x")) {
                        this._x = true;
                        continue;
                    }
                    if (string2.equals("-X")) {
                        this._X = true;
                        continue;
                    }
                    if (string2.equals("-m")) {
                        this._m = true;
                        continue;
                    }
                    if (string2.equals("-p")) {
                        this._p = true;
                        continue;
                    }
                    if (string2.equals("-l")) {
                        this._l = true;
                        continue;
                    }
                    if (string2.equals("-d")) {
                        this._d = true;
                        continue;
                    }
                    if (string2.equals("-E")) {
                        if (n >= stringArray.length) throw new ExitException("Option -b requires an argument", 2);
                        bl6 = true;
                        string7 = string2 = stringArray[n++];
                        continue;
                    }
                    if (string2.equals("-A")) {
                        this._alternate = true;
                        continue;
                    }
                    if (string2.equals("-S")) {
                        this._S = true;
                        continue;
                    }
                    if (string2.equals("-q")) {
                        if (n >= stringArray.length) throw new ExitException("Option -q requires a hex sequence argument", 2);
                        bl4 = true;
                        string4 = string2 = stringArray[n++];
                        continue;
                    }
                    if (string2.equals("-g")) {
                        if (n >= stringArray.length) throw new ExitException("Option -g requires an integer argument", 2);
                        this._g = true;
                        string6 = string2 = stringArray[n++];
                        continue;
                    }
                    if (string2.equals("-G")) {
                        if (n >= stringArray.length) throw new ExitException("Option -G requires an argument", 2);
                        this._G = true;
                        if ((string2 = stringArray[n++]).length() != 1) {
                            throw new ExitException("Option -G requires exactly one character", 2);
                        }
                        this.groupingChar = string2.charAt(0);
                        continue;
                    }
                    if (string2.equals("-P")) {
                        if (n >= stringArray.length) throw new ExitException("Option -P requires an argument", 2);
                        this._P = true;
                        if ((string2 = stringArray[n++]).length() != 1) {
                            throw new ExitException("Option -P requires exactly one character", 2);
                        }
                        if (string2.charAt(0) != '/' && string2.charAt(0) != '\\') throw new ExitException("Option -P requires / or \\", 2);
                        this.fileseparatorChar = string2.charAt(0);
                        continue;
                    }
                    if (string2.equals("-F")) {
                        if (n >= stringArray.length) throw new ExitException("Option -F requires an argument", 2);
                        this._F = true;
                        this.format = string2 = stringArray[n++];
                        continue;
                    }
                    if (string2.equals("-w")) {
                        if (n >= stringArray.length) throw new ExitException("Option -w requires a directory parameter", 2);
                        this._w = true;
                        this.workingDir = stringArray[n];
                        if (n + 1 >= stringArray.length) continue;
                        throw new ExitException("Option -w <directory> has to be the last parameter", 2);
                    }
                    if (string2.equals("-c")) {
                        if (n >= stringArray.length) throw new ExitException("Option -c requires a filename parameter", 2);
                        bl5 = true;
                        string5 = string2 = stringArray[n++];
                        continue;
                    }
                    if (string2.equals("-e")) {
                        if (n >= stringArray.length) throw new ExitException("Option -e requires an argument", 2);
                        this._e = true;
                        this._f = true;
                        this.expected = string2 = stringArray[n++];
                        continue;
                    }
                    if (string2.equals("-h")) {
                        object4 = "en";
                        object5 = null;
                        if (n < stringArray.length) {
                            if (((String)(object4 = stringArray[n++].toLowerCase())).equals("en") || ((String)object4).equals("de")) {
                                if (n < stringArray.length) {
                                    object5 = stringArray[n++].toLowerCase();
                                }
                            } else {
                                object5 = object4;
                                object4 = "en";
                            }
                        }
                        JacksumHelp.help((String)object4, object5);
                        continue;
                    }
                    if (string2.equals("-t")) {
                        this._t = true;
                        if (n >= stringArray.length) throw new ExitException("Option -t requires a format string. Use -h for help. Exit.", 2);
                        if (!(string3 = stringArray[n++]).equals(DEFAULT)) continue;
                        string3 = TIMESTAMPFORMAT_DEFAULT;
                        continue;
                    }
                    if (string2.equals("-v")) {
                        JacksumHelp.printVersion();
                        throw new ExitException(null, 0);
                    }
                    if (string2.equals("-V")) {
                        this._V = true;
                        if (n >= stringArray.length || ((String)(object4 = stringArray[n++])).equals(DEFAULT)) continue;
                        object5 = new StringTokenizer((String)object4, ",");
                        while (((StringTokenizer)object5).hasMoreTokens()) {
                            object3 = ((StringTokenizer)object5).nextToken();
                            if (((String)object3).equals("warnings")) {
                                this.verbose.setWarnings(true);
                                continue;
                            }
                            if (((String)object3).equals("nowarnings")) {
                                this.verbose.setWarnings(false);
                                continue;
                            }
                            if (((String)object3).equals("details")) {
                                this.verbose.setDetails(true);
                                continue;
                            }
                            if (((String)object3).equals("nodetails")) {
                                this.verbose.setDetails(false);
                                continue;
                            }
                            if (((String)object3).equals("summary")) {
                                this.verbose.setSummary(true);
                                continue;
                            }
                            if (!((String)object3).equals("nosummary")) throw new ExitException("Option -V requires valid parameters. Use -h for help. Exit.", 2);
                            this.verbose.setSummary(false);
                        }
                        continue;
                    }
                    if (string2.equals("-o")) {
                        this._o = true;
                        if (n >= stringArray.length) throw new ExitException("Option -o requires a parameter. Use -h for help. Exit.", 2);
                        this.outputFile = stringArray[n++];
                        continue;
                    }
                    if (string2.equals("-O")) {
                        this._O = true;
                        if (n >= stringArray.length) throw new ExitException("Option -O requires a parameter. Use -h for help. Exit.", 2);
                        this.outputFile = stringArray[n++];
                        continue;
                    }
                    if (string2.equals("-u")) {
                        this._u = true;
                        if (n >= stringArray.length) throw new ExitException("Option -u requires a parameter. Use -h for help. Exit.", 2);
                        this.errorFile = stringArray[n++];
                        continue;
                    }
                    if (string2.equals("-U")) {
                        this._U = true;
                        if (n >= stringArray.length) throw new ExitException("Option -U requires a parameter. Use -h for help. Exit.", 2);
                        this.errorFile = stringArray[n++];
                        continue;
                    }
                    if (!string2.equals("-I")) throw new ExitException("Unknown argument. Use -h for help. Exit.", 2);
                    this._I = true;
                    if (n >= stringArray.length) throw new ExitException("Option -I requires a parameter. Use -h for help. Exit.", 2);
                    this.metaInfo.setCommentchars(stringArray[n++]);
                }
            }
            if (this._V && stringArray.length == 1) {
                JacksumHelp.printVersion();
                throw new ExitException(null, 0);
            }
            this.windows = System.getProperty("os.name").toLowerCase(Locale.US).startsWith("windows");
            object4 = null;
            boolean bl7 = false;
            if ((this._o || this._O) && (this._u || this._U) && this.outputFile.equals(this.errorFile)) {
                if (this._m) {
                    throw new ExitException("Jacksum: Error: stdout and stderr may not equal if -m is wanted.", 2);
                }
                try {
                    object4 = new PrintStream(new FileOutputStream(this.outputFile));
                    bl7 = true;
                }
                catch (Exception exception) {
                    throw new ExitException(exception.getMessage(), 4);
                }
            }
            if (this._o || this._O) {
                try {
                    object3 = new File(this.outputFile);
                    if (!this._O && ((File)object3).exists()) {
                        throw new ExitException("Jacksum: Error: the file " + object3 + " already exists. Specify the file by -O to overwrite it.", 4);
                    }
                    if (bl7) {
                        System.setOut(object4);
                    } else {
                        object2 = new PrintStream(new FileOutputStream(this.outputFile));
                        System.setOut((PrintStream)object2);
                    }
                }
                catch (Exception exception) {
                    throw new ExitException(exception.getMessage(), 4);
                }
            }
            if (this._u || this._U) {
                try {
                    object3 = new File(this.errorFile);
                    if (!this._U && ((File)object3).exists()) {
                        throw new ExitException("Jacksum: Error: the file " + object3 + " already exists. Specify the file by -U to overwrite it.", 4);
                    }
                    if (bl7) {
                        System.setErr((PrintStream)object4);
                    } else {
                        object2 = new PrintStream(new FileOutputStream(this.errorFile));
                        System.setErr((PrintStream)object2);
                    }
                }
                catch (Exception exception) {
                    throw new ExitException(exception.getMessage(), 4);
                }
            }
            if (this.checksumArg == null) {
                this.checksumArg = "sha1";
            }
            if (this._e && this.checksumArg.equals("none")) {
                throw new ExitException("-a none and -e cannot go together.", 2);
            }
            if (!this._alternate && !GeneralProgram.isJ2SEcompatible()) {
                this._alternate = true;
            }
            try {
                this.checksum = JacksumAPI.getChecksumInstance(this.checksumArg, this._alternate);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ExitException(noSuchAlgorithmException.getMessage() + "\nUse -a <code> to specify a valid one.\nFor help and a list of all supported algorithms use -h.\nExit.", 2);
            }
            this.summary.setEnabled(this.verbose.getSummary());
            if (bl2) {
                this.checksum.setSeparator(this.metaInfo.getSeparator());
            }
            if (this._g) {
                try {
                    int n2 = Integer.parseInt(string6);
                    if (n2 > 0) {
                        this.checksum.setEncoding("hex");
                        this.checksum.setGroup(n2);
                        if (this._G) {
                            this.checksum.setGroupChar(this.groupingChar);
                        }
                    } else if (this.verbose.getWarnings()) {
                        System.err.println("Jacksum: Warning: Ignoring -g, because parameter is not greater than 0.");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ExitException(string6 + " is not a decimal number.", 2);
                }
            }
            if (this._x) {
                this.checksum.setEncoding("hex");
            }
            if (this._X) {
                this.checksum.setEncoding("hexup");
            }
            if (bl6) {
                try {
                    if (string7.length() == 0) {
                        throw new EncodingException("Encoding not supported");
                    }
                    this.checksum.setEncoding(string7);
                }
                catch (EncodingException encodingException) {
                    throw new ExitException("Jacksum: " + encodingException.getMessage(), 2);
                }
            }
            if (this._t && !bl4) {
                try {
                    string3 = Jacksum.decodeQuoteAndSeparator(string3, this.metaInfo.getSeparator());
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
                    simpleDateFormat.format((Object)new Date());
                    this.checksum.setTimestampFormat(string3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ExitException("Option -t is wrong (" + illegalArgumentException.getMessage() + ")", 2);
                }
            }
            if (this._m && this._S) {
                throw new ExitException("Jacksum: -S and -m can't go together, it is not supported.", 2);
            }
            if (this._m && this._G && this.groupingChar == ';') {
                throw new ExitException("Jacksum: Option -G doesn't allow a semicolon when -m has been specified", 2);
            }
            if (this._m || bl5) {
                if (this._F && this.verbose.getWarnings()) {
                    System.err.println("Jacksum: Warning: Ignoring -F, because -m or -c has been specified.");
                }
                this.metaInfo.setVersion("1.7.0");
                this.metaInfo.setRecursive(this._r);
                this.metaInfo.setEncoding(this.checksum.getEncoding());
                this.metaInfo.setPathInfo(this._p);
                this.metaInfo.setTimestampFormat(this._t ? this.checksum.getTimestampFormat() : null);
                this.metaInfo.setFilesep(this._P ? this.fileseparatorChar : File.separatorChar);
                this.metaInfo.setGrouping(this._g ? this.checksum.getGroup() : 0);
                if (this._g && this._G) {
                    this.metaInfo.setGroupChar(this.checksum.getGroupChar());
                }
                this.metaInfo.setAlgorithm(this.checksum.getName());
                this.metaInfo.setAlternate(this._alternate);
            }
            if (this._m) {
                if (this._t && string3.indexOf(";") > -1) {
                    throw new ExitException("Option -t contains a semicolon. This is not supported with -m.", 2);
                }
                if (this._I) {
                    if (this.metaInfo.getCommentchars().length() == 0) {
                        throw new ExitException("Option -I has been set to an empty string. This is not supported with -m.", 2);
                    }
                    if (this.metaInfo.getCommentchars().indexOf(";") > -1) {
                        throw new ExitException("Option -I contains a semicolon. This is not supported with -m.", 2);
                    }
                }
                if (bl2) {
                    if (this.metaInfo.getSeparator().indexOf(";") > -1) {
                        throw new ExitException("Option -s contains a semicolon. This is not supported with -m.", 2);
                    }
                    this.checksum.setSeparator(this.metaInfo.getSeparator());
                }
                this._F = false;
                System.out.println(this.metaInfo);
                System.out.println(this.metaInfo.getComment());
            }
            String string8 = null;
            object2 = null;
            if (bl4) {
                if (this._t) {
                    if (this.verbose.getWarnings()) {
                        System.err.println("Jacksum: Warning: Option -t will be ignored, because option -q is used.");
                    }
                    this._t = false;
                    this.checksum.setTimestampFormat(null);
                }
                byte[] byArray = null;
                this.checksum.setFilename("");
                String string9 = string4.toLowerCase();
                if (string9.startsWith("txt:")) {
                    string4 = string4.substring(4);
                    byArray = string4.getBytes();
                } else if (string9.startsWith("dec:")) {
                    if ((string4 = string4.substring(4)).length() == 0) {
                        byArray = string4.getBytes();
                    } else {
                        int n3 = GeneralString.countChar(string4, ',');
                        byArray = new byte[n3 + 1];
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                        int n4 = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            int n5 = 0;
                            String string10 = null;
                            try {
                                string10 = stringTokenizer.nextToken();
                                n5 = Integer.parseInt(string10);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new ExitException(string10 + " is not a decimal number.", 2);
                            }
                            if (n5 < 0 || n5 > 255) {
                                throw new ExitException("The number " + n5 + " is out of range.", 2);
                            }
                            byArray[n4++] = (byte)n5;
                        }
                    }
                } else {
                    if (string9.startsWith("hex:")) {
                        string4 = string4.substring(4);
                    }
                    if (string4.length() % 2 == 1) {
                        throw new ExitException("An even number of nibbles was expected.\nExit.", 2);
                    }
                    try {
                        byArray = new byte[string4.length() / 2];
                        int n6 = 0;
                        int n7 = 0;
                        while (n7 < string4.length()) {
                            String string11 = string4.substring(n7, n7 += 2);
                            byArray[n6++] = (byte)Integer.parseInt(string11, 16);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExitException("Not a hex number. " + numberFormatException.getMessage(), 2);
                    }
                }
                this.checksum.update(byArray);
                if (this._e) {
                    this.expectation(this.checksum, this.expected);
                    throw new ExitException(null, 0);
                } else {
                    System.out.println(this._F ? this.checksum.format(this.format) : this.checksum.toString());
                }
                throw new ExitException(null, 0);
            }
            if (bl5) {
                this._F = false;
                File file = new File(string5);
                if (!file.exists()) {
                    throw new ExitException("Jacksum: " + string5 + ": No such file or directory. Exit.", 4);
                }
                int n8 = 0;
                if (file.isDirectory()) {
                    throw new ExitException("Parameter is a directory, but a filename was expected. Exit.", 2);
                }
                CheckFile checkFile = null;
                try {
                    checkFile = new CheckFile(string5);
                    if (this._w) {
                        checkFile.setWorkingDir(this.workingDir);
                    }
                    checkFile.setMetaInfo(this.metaInfo);
                    checkFile.setVerbose(this.verbose);
                    checkFile.setSummary(this.summary);
                    checkFile.setList(this._l);
                    checkFile.perform();
                }
                catch (MetaInfoVersionException metaInfoVersionException) {
                    throw new ExitException(metaInfoVersionException.getMessage(), 3);
                }
                catch (ExitException exitException) {
                    throw new ExitException(exitException.getMessage(), exitException.getExitCode());
                }
                catch (Exception exception) {
                    n8 = 3;
                    System.err.println(exception);
                }
                if (n8 == 0 && checkFile.getRemoved() + checkFile.getModified() > 0L) {
                    n8 = 1;
                }
                this.summary.print();
                throw new ExitException(null, n8);
            }
            if (stringArray.length - n == 1) {
                string = stringArray[n];
                object = new File(string);
                if (!((File)object).exists()) {
                    throw new ExitException("Jacksum: " + string + ": No such file or directory. Exit.", 4);
                }
                if (((File)object).isDirectory()) {
                    bl3 = true;
                } else {
                    if (!((File)object).isFile()) throw new ExitException("Jacksum: \"" + string + "\" is not a normal file", 4);
                    if (this._e) {
                        try {
                            this.checksum.readFile(string);
                            this.expectation(this.checksum, this.expected);
                        }
                        catch (IOException iOException) {
                            throw new ExitException(iOException.getMessage(), 4);
                        }
                    }
                }
            }
            if (this._r || bl3) {
                string = null;
                if (stringArray.length - n == 1) {
                    string = stringArray[n];
                } else {
                    if (stringArray.length != n) throw new ExitException("Too many parameters. One directory was expeced. Exit.", 2);
                    string = ".";
                }
                object = new File(string);
                if (!((File)object).exists()) {
                    throw new ExitException("Jacksum: " + string + ": No such file or directory. Exit.", 4);
                }
                if (!((File)object).isDirectory()) throw new ExitException("Parameter is a file, but a directory was expected. Exit.", 2);
                if (this._m) {
                    System.out.println(this.metaInfo.getCommentchars() + " param dir=" + string);
                }
                if (this._w) {
                    this.workingdirlen = this.getWorkingdirLength(((File)object).toString());
                }
                if (this._r) {
                    this.recursDir(((File)object).toString());
                } else {
                    this.oneDir(((File)object).toString());
                }
                if (this._S) {
                    this.printS();
                }
            } else if (bl || n == stringArray.length) {
                if (this._t) {
                    if (this.verbose.getWarnings()) {
                        System.err.println("Jacksum: Warning: Option -t will be ignored, because standard input is used.");
                    }
                    this._t = false;
                    this.checksum.setTimestampFormat(null);
                }
                this.checksum.setFilename("");
                string = null;
                object = new BufferedReader(new InputStreamReader(System.in));
                try {
                    do {
                        if ((string = ((BufferedReader)object).readLine()) == null) continue;
                        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
                        stringBuffer.insert(0, string);
                        stringBuffer.insert(string.length(), '\n');
                        this.checksum.update(stringBuffer.toString().getBytes());
                    } while (string != null);
                    this.summary.addBytes(this.checksum.getLength());
                    if (this._e) {
                        this.expectation(this.checksum, this.expected);
                        break block160;
                    }
                    System.out.println(this.checksum.toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                for (int i = n; i < stringArray.length; ++i) {
                    object2 = stringArray[i];
                    try {
                        object = new File((String)object2);
                        string8 = null;
                        if (!((File)object).exists()) {
                            string8 = "Jacksum: " + (String)object2 + ": No such file or directory";
                        } else if (((File)object).isDirectory()) {
                            if (!this._f) {
                                string8 = "Jacksum: " + (String)object2 + ": Is a directory";
                            }
                        } else {
                            this.processItem((String)object2);
                        }
                        if (string8 == null) continue;
                        System.err.println(string8);
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                }
                if (this._S) {
                    this.printS();
                }
            }
        }
        this.summary.print();
    }

    private int getWorkingdirLength(String string) {
        if (string == null) {
            return 0;
        }
        boolean bl = true;
        if (!string.endsWith(File.separator)) {
            if (this.windows && string.endsWith(":")) {
                bl = false;
            }
            if (bl) {
                string = string + File.separator;
            }
        }
        return string.length();
    }

    private void printS() throws ExitException {
        this.checksum.setFilename("");
        this.checksum.setTimestampFormat("");
        this.checksum.setSeparator("");
        if (this._e) {
            this.expectation(this.checksum, this.expected);
        } else {
            System.out.println(this._F ? this.checksum.format(this.format) : this.checksum.format("#CHECKSUM"));
        }
    }
}

