/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public class GenericOptionsParser {
    private static final Log LOG = LogFactory.getLog(GenericOptionsParser.class);
    private Configuration conf;
    private CommandLine commandLine;

    public GenericOptionsParser(Options opts, String[] args) throws IOException {
        this(new Configuration(), new Options(), args);
    }

    public GenericOptionsParser(String[] args) throws IOException {
        this(new Configuration(), new Options(), args);
    }

    public GenericOptionsParser(Configuration conf, String[] args) throws IOException {
        this(conf, new Options(), args);
    }

    public GenericOptionsParser(Configuration conf, Options options, String[] args) throws IOException {
        this.parseGeneralOptions(options, conf, args);
        this.conf = conf;
    }

    public String[] getRemainingArgs() {
        return this.commandLine == null ? new String[]{} : this.commandLine.getArgs();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    private static Options buildGeneralOptions(Options opts) {
        OptionBuilder.withArgName((String)"local|namenode:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a namenode");
        Option fs = OptionBuilder.create((String)"fs");
        OptionBuilder.withArgName((String)"local|jobtracker:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a job tracker");
        Option jt = OptionBuilder.create((String)"jt");
        OptionBuilder.withArgName((String)"configuration file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify an application configuration file");
        Option oconf = OptionBuilder.create((String)"conf");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use value for given property");
        Option property = OptionBuilder.create((char)'D');
        OptionBuilder.withArgName((String)"paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma separated jar files to include in the classpath.");
        Option libjars = OptionBuilder.create((String)"libjars");
        OptionBuilder.withArgName((String)"paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma separated files to be copied to the map reduce cluster");
        Option files = OptionBuilder.create((String)"files");
        OptionBuilder.withArgName((String)"paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma separated archives to be unarchived on the compute machines.");
        Option archives = OptionBuilder.create((String)"archives");
        OptionBuilder.withArgName((String)"tokensFile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"name of the file with the tokens");
        Option tokensFile = OptionBuilder.create((String)"tokenCacheFile");
        opts.addOption(fs);
        opts.addOption(jt);
        opts.addOption(oconf);
        opts.addOption(property);
        opts.addOption(libjars);
        opts.addOption(files);
        opts.addOption(archives);
        opts.addOption(tokensFile);
        return opts;
    }

    private void processGeneralOptions(Configuration conf, CommandLine line) throws IOException {
        if (line.hasOption("fs")) {
            FileSystem.setDefaultUri(conf, line.getOptionValue("fs"));
        }
        if (line.hasOption("jt")) {
            conf.set("mapred.job.tracker", line.getOptionValue("jt"));
        }
        if (line.hasOption("conf")) {
            String[] values;
            for (String value : values = line.getOptionValues("conf")) {
                conf.addResource(new Path(value));
            }
        }
        if (line.hasOption("libjars")) {
            conf.set("tmpjars", this.validateFiles(line.getOptionValue("libjars"), conf));
            URL[] libjars = GenericOptionsParser.getLibJars(conf);
            if (libjars != null && libjars.length > 0) {
                conf.setClassLoader(new URLClassLoader(libjars, conf.getClassLoader()));
                Thread.currentThread().setContextClassLoader(new URLClassLoader(libjars, Thread.currentThread().getContextClassLoader()));
            }
        }
        if (line.hasOption("files")) {
            conf.set("tmpfiles", this.validateFiles(line.getOptionValue("files"), conf));
        }
        if (line.hasOption("archives")) {
            conf.set("tmparchives", this.validateFiles(line.getOptionValue("archives"), conf));
        }
        if (line.hasOption('D')) {
            String[] property = line.getOptionValues('D');
            for (String prop : property) {
                String[] keyval = prop.split("=", 2);
                if (keyval.length != 2) continue;
                conf.set(keyval[0], keyval[1]);
            }
        }
        conf.setBoolean("mapred.used.genericoptionsparser", true);
        if (line.hasOption("tokenCacheFile")) {
            String fileName = line.getOptionValue("tokenCacheFile");
            try {
                LocalFileSystem localFs = FileSystem.getLocal(conf);
                Path p = new Path(fileName);
                if (!((FileSystem)localFs).exists(p)) {
                    throw new FileNotFoundException("File " + fileName + " does not exist.");
                }
                LOG.debug((Object)("setting conf tokensFile: " + fileName));
                conf.set("mapreduce.job.credentials.json", ((FileSystem)localFs).makeQualified(p).toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static URL[] getLibJars(Configuration conf) throws IOException {
        String jars = conf.get("tmpjars");
        if (jars == null) {
            return null;
        }
        String[] files = jars.split(",");
        ArrayList<URL> cp = new ArrayList<URL>();
        for (String file : files) {
            Path tmp = new Path(file);
            if (!tmp.getFileSystem(conf).equals(FileSystem.getLocal(conf))) continue;
            cp.add(FileSystem.getLocal(conf).pathToFile(tmp).toURI().toURL());
        }
        return cp.toArray(new URL[0]);
    }

    private String validateFiles(String files, Configuration conf) throws IOException {
        if (files == null) {
            return null;
        }
        String[] fileArr = files.split(",");
        String[] finalArr = new String[fileArr.length];
        for (int i = 0; i < fileArr.length; ++i) {
            String finalPath;
            URI pathURI;
            String tmp = fileArr[i];
            try {
                pathURI = new URI(tmp);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            Path path = new Path(pathURI);
            LocalFileSystem localFs = FileSystem.getLocal(conf);
            if (pathURI.getScheme() == null) {
                if (!((FileSystem)localFs).exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified(localFs).toString();
            } else {
                FileSystem fs = path.getFileSystem(conf);
                if (!fs.exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified(fs).toString();
            }
            finalArr[i] = finalPath;
        }
        return StringUtils.arrayToString(finalArr);
    }

    private String[] parseGeneralOptions(Options opts, Configuration conf, String[] args) throws IOException {
        opts = GenericOptionsParser.buildGeneralOptions(opts);
        GnuParser parser = new GnuParser();
        try {
            this.commandLine = parser.parse(opts, args, true);
            this.processGeneralOptions(conf, this.commandLine);
            return this.commandLine.getArgs();
        }
        catch (ParseException e) {
            LOG.warn((Object)("options parsing failed: " + e.getMessage()));
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("general options are: ", opts);
            return args;
        }
    }

    public static void printGenericCommandUsage(PrintStream out) {
        out.println("Generic options supported are");
        out.println("-conf <configuration file>     specify an application configuration file");
        out.println("-D <property=value>            use value for given property");
        out.println("-fs <local|namenode:port>      specify a namenode");
        out.println("-jt <local|jobtracker:port>    specify a job tracker");
        out.println("-files <comma separated list of files>    specify comma separated files to be copied to the map reduce cluster");
        out.println("-libjars <comma separated list of jars>    specify comma separated jar files to include in the classpath.");
        out.println("-archives <comma separated list of archives>    specify comma separated archives to be unarchived on the compute machines.\n");
        out.println("The general command line syntax is");
        out.println("bin/hadoop command [genericOptions] [commandOptions]\n");
    }
}

