#ifndef _SOCKETS_H
#define _SOCKETS_H
#include "Heap.h"
#include "VM.h"
#include "stdfuns.h"
#include "KayaAPI.h"
#include <sys/types.h>
#include <sys/socket.h>

extern "C" {
  KArray do_socketpair();
  void do_closesocket(void* sptr);

  void do_socketsend(void* vmptr, void* sptr, wchar_t* msg);
  void do_socketsendchars(void* vmptr, void* sptr, void* data, int len);
  void do_socketsendbyte(void* vmptr, void* sptr, kint byte);

  wchar_t* do_socketrecv(void* vmptr, void* sptr, KayaValue len);
  void* do_socketrecvchars(void* vmptr, void* sptr, KayaValue len);
  kint do_socketrecvbyte(void* vmptr, void* sptr);

  bool do_socketpending(void* vm, void* conn, int timeout);
}

#endif
