#ifndef _STDFUNS_H
#define _STDFUNS_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

// Standard functions for linking into the standard library

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include "Heap.h"
#include "KayaAPI.h"
#include "unpickler.h"
#include <map>
#include "sizes.h"

typedef map<wchar_t*,wchar_t*> ArgMap;

extern KayaArray args;

wchar_t* inttostr(kint s, kint base);
kint strtoint(wchar_t* str, kint base);

VMState* getsubstr(void* vmptr, wchar_t* x,kint i,kint len);
void str_offset(Value* str, kint inc);
void str_chop(Value* str, kint inc);
VMState* getstrend(void* vmptr, wchar_t* x,kint i);
wchar_t* readstr();

wchar_t getIndex(wchar_t* str,kint i);
void setIndex(wchar_t* str, wchar_t c,kint i);

VMState* do_urlencode(void* vm, wchar_t* strinwide, kint len);
VMState* do_urldecode(void* vm, wchar_t* strinwide, kint len);

void* do_tmpFile();

VMState* getLine(void* vmptr, void* file);
void getLineTo(void* file, KayaValue strv);
wchar_t do_fgetc(void* fptr);
void do_fputc(kint ch, void* fptr);
VMState* getString(void* vmptr, void* file);
void putString(void* f, wchar_t* c, kint len);
void putLine(void* f, wchar_t* c, kint len);
void do_fseek(void* f, kint p);
kint do_ftell(void* f);
bool do_feof(void* f);
kint do_fflush(void* f);
void do_fclose(void* f);

void putStr(wchar_t* c, kint len);
// Check if a string has any UTF8 characters in it (return non-zero if so)
kint topSet(const char* str);
kint checkUTF8(wchar_t* str);

void* getstdin();
void* getstdout();
void* getstderr();
void setStdErr(FILE* f);

bool validFile(void* f);

void printArray(KayaArray foo);
KayaArray reverseArray(KayaArray foo);
void shortenArray(KayaArray foo);
KayaValue shiftArray(KayaArray foo);
void unshiftArray(KayaValue val, KayaArray foo);
KayaArray createArray(void* vmptr, kint size);
void resizeArray(KayaArray foo, kint size);
kint arraySize(KayaArray foo);

// these really are char* and int
void storeArgs(int argc,char* argv[]);
KayaArray getArgs();

kint gettime();
kint getclock();
kint dogettimeofday();
#ifdef GTOD_INTERNAL
kint gettimeofday (struct timeval *tp, void *tz);
#endif
KayaValue dogmtime(kint secs);
KayaValue dolocaltime(kint secs);
kint domktime(KayaValue time);

kint runProgram(wchar_t* prog, KayaArray args);
kint dofork();
kint dowait();
kint dowaitpid(kint pid);
void reap();

kint dogetpid();

kint do_wcsstr(wchar_t* needle, wchar_t* haystack);
bool do_wcschr(wchar_t c, wchar_t* s);
kint do_wcscspn(wchar_t c, wchar_t* s);
kint offset_wcscspn(wchar_t c, wchar_t* s, kint i);

wchar_t* b64enc(wchar_t* block, kint len);
wchar_t* b64dec(wchar_t* block, KayaValue len);
char* b64enc(char* block, kint len);
char* b64dec(char* block, KayaValue len);

wchar_t* mkString(KayaValue x);

void quicksort(void* vm, KayaArray xs, KayaValue sortfn);

#define FUNTABLE_OP(op,x,y) \
switch (x->getFunTable()) { \
  case KVT_INT: \
    r = inttable_##op(x,y); \
    break; \
  case KVT_STRING: \
    r = stringtable_##op(x,y); \
    break; \
  case KVT_FUNC: \
    r = fntable_##op(x,y); \
    break; \
  case KVT_ARRAY: \
    r = arraytable_##op(x,y); \
    break; \
  case KVT_CUNION: \
    r = cuniontable_##op(x,y); \
    break; \
  case KVT_EXCEPTION: \
    r = exceptiontable_##op(x,y); \
    break; \
  case KVT_REAL: \
    r = realtable_##op(x,y); \
    break; \
  case KVT_NULL: \
    r = inttable_##op(x,y); \
    break; \
  case KVT_UNION: \
  default: \
    r = uniontable_##op(x,y); \
    break; \
  } 
/* KVT_NULL can't happen
KVT_UNION has to be last and default because anything > KVT_UNION is also a union
 */

// #define funtable_compare(x,y) x->getFunTable()->cmp(x,y)
#define funtable_eq(v,x,y) (x==y || funtable_equal(v,x,y))
#define funtable_eq_aux(x,y,done) (x==y || funtable_equal_aux(x,y,done))

kint funtable_compare(void* vmptr, KayaValue x, KayaValue y);
bool funtable_equal(void* vmptr, KayaValue x, KayaValue y);
bool funtable_equal_aux(KayaValue x, KayaValue y, map<Value*,Value*>& done);
kint funtable_memusage(KayaValue x);
kint funtable_hash(KayaValue x);
kint funtable_hash_aux(KayaValue x, vector<KayaValue>& done);
VMState* funtable_marshal(void* vmptr,KayaValue x,kint id);
void funtable_marshal_aux(void* vmptr,String* mdata,vector<KayaValue>& done,KayaValue x, kint i);
Value* funtable_reflect(void* vmptr,KayaValue x);
Value* funtable_reflect_aux(void* vmptr,
			    map<KayaValue, KayaValue>& done,KayaValue x);
KayaValue funtable_copy(void* vmptr, KayaValue x);
KayaValue funtable_copy_aux(VMState* vm, KayaValue x, map<Value*, Value*>& done);

KayaValue reifyUnion(kint tag, kint arity);
void reifyUnionArgs(KayaValue v, KayaArray flds);
KayaValue reifyClosure(kint tag, kint arity);
void reifyClosureArgs(KayaValue v, KayaArray flds);

bool is_initialised(KayaValue x);
KayaValue unsafe_id(KayaValue x);

wchar_t* getAddr(KayaValue x);

wchar_t* except_msg(KayaValue x);
kint except_code(KayaValue x);
void except_dumpbt(KayaValue x);

kint doGetFnID(KayaValue fn);
//void callFnID(void* vmptr, kint id, KayaValue arg);

kint memusage();

kint isNull(void* p);
kint isIdentical(KayaValue x, KayaValue y);
kint maxMemUsage(void* vmptr);

// Added by Chris Morris, 18/6/05
kint do_access(wchar_t* pathname, KayaValue mode);
// Added by Chris Morris, 5/9/05
kint do_unlink(const wchar_t* fn);
wchar_t* dogetcwd();
kint do_mkdir(const wchar_t* fn, kint um);

kint do_setrlimit(KayaValue lim, kint soft, kint hard);

// Directory functions, 28/8/05

void* do_opendir(wchar_t* name);
kint do_closedir(void* dir);
void* do_readdir(void* dir);

VMState* dir_getname(void* vmptr, void* ent);

KayaValue do_stat(void* vm, wchar_t* name);

void* do_fopen(const wchar_t* path, const wchar_t* mode);
void* do_freopen(const wchar_t* path, const wchar_t* mode, void* stream);
void do_rename(const wchar_t* oldfile, const wchar_t* newfile);
void do_chdir(const wchar_t* newdir);
wchar_t* do_getenv(const wchar_t* env);

kint binary_length(const wchar_t* str, kint len);

#ifndef WIN32
kint do_system(const wchar_t* prog);
void* do_popen(const wchar_t* prog, kint read);
kint do_pclose(void* stream);
#endif

// Return next biggest power of 2.
kint nextPower(kint x);

kint strAlloc(Value* str);
Value* createString(void* vmptr, kint len);

void do_GC_enable_incremental();
void do_GC_finalizer(Value* obj, Value* finalizer);

void do_sleep(kint len);
void do_usleep(kint len);

kint strHash(wchar_t* m, kint len);

kint rtchecks();

#endif
