#  This program source code file is part of KICAD, a free EDA CAD application.
#
# Copyright (C) 2011 SoftPLC Corporation, Dick Hollenbeck <dick@softplc.com>
# Copyright (C) 2011 Kicad Developers, see change_log.txt for contributors#.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, you may find one here:
#  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#  or you may search the http://www.gnu.org website for the version 2 license,
#  or you may write to the Free Software Foundation, Inc.,
#  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#
#############################################################################
#
# This script converts a *.png file into a *.cpp file.
# The *.cpp file will contain a BITMAP_DEF structure, which is simply a byte
# array and a length of bytes which were found in the *.png file.
#
#
# Invocation Parameters are:  inputFile, outCppFile
#
#     inputFile  - Required, full path and file name of the input PNG file
#
#     outCppFile - Required, full path and file name of where to save the
#                  generated cpp file.


file( READ ${inputFile} file_contents HEX )

get_filename_component( png_name "${inputFile}" NAME_WE )

# split into pairs of ASCII, where each pair gives a single byte's value
string( REGEX MATCHALL "[0-9a-fA-F][0-9a-fA-F]" byte_list ${file_contents} )

set( output_begin "
/* Do not modify this file, it was automatically generated by the
 * PNG2cpp CMake script, using a *.png file as input.
 */

#include <bitmaps.h>

static const unsigned char png[] = {"
)

set( output_end "};

const BITMAP_OPAQUE ${png_name}_xpm[1] = {{ png, sizeof( png ), \"${png_name}_xpm\" }};

//EOF
" )

set( byte_count 0 )
set( byte_array "" )

foreach( byte ${byte_list} )

    math( EXPR modulus "${byte_count} % 16" )
    if( modulus EQUAL 0 )
        set( byte_array "${byte_array}\n" )
    endif()

    set( byte_array "${byte_array} 0x${byte}," )
    math( EXPR byte_count "${byte_count} + 1" )
endforeach()

set( byte_array "${byte_array}\n" )

file( WRITE  ${outCppFile} "${output_begin}" )
file( APPEND ${outCppFile} "${byte_array}" )
file( APPEND ${outCppFile} "${output_end}" )

