/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef FORM_ENTRY_H
#define FORM_ENTRY_H

#include <QtCore/QMap>
#include <QtCore/QStringList>

#include "qldap.h"

namespace Form
{

class Entry
{
  public:
    typedef QList<Entry> List;

    Entry();
    ~Entry();

    void setId( const QString &id );
    QString id() const;

    QStringList keys() const;

    QString value( const QString &key ) const;
    QStringList values( const QString &key ) const;

    void setValue( const QString &key, const QString &value );
    void addValue( const QString &key, const QString &value );

    void clearValue( const QString &key );

    void dump() const;

    static Entry fromLdapEntry( const QLdapEntry &ldapEntry );

  private:
    QMap<QString, QStringList> mValues;
    QString mId;
};

}

#endif
