/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QtGui/QLabel>
#include <QtGui/QLineEdit>

#include "passwordfield.h"

using namespace Form;

PasswordField::PasswordField( const QString &name, QWidget *parent )
  : Field( name, parent )
{
  mPassword = new QLineEdit( this );
  mPassword->setEchoMode( QLineEdit::Password );

  QLabel *label = new QLabel( tr( "   Verify: " ), this );

  mPasswordVerify = new QLineEdit( this );
  mPasswordVerify->setEchoMode( QLineEdit::Password );

  fieldLayout()->addWidget( mPassword, 0, 0 );
  fieldLayout()->addWidget( label, 0, 1, Qt::AlignRight );
  fieldLayout()->addWidget( mPasswordVerify, 0, 2 );
}

void PasswordField::loadEntry( const Entry& )
{
}

void PasswordField::saveEntry( Entry &entry ) const
{
  if ( !mPassword->text().isEmpty() )
    entry.setValue( name(), mPassword->text() );
}

bool PasswordField::isValid( QString &msg, PagePolicy::State state ) const
{
  if ( state == PagePolicy::Add ) {
    if ( mPassword->text().isEmpty() ) {
      msg = tr( "Password is empty" );
      return false;
    }
  }

  if ( state == PagePolicy::Add || state == PagePolicy::Modify ) {
    if ( mPassword->text() != mPasswordVerify->text() ) {
      msg = tr( "Passwords dont match" );
      return false;
    }
  }

  return true;
}

void PasswordField::setEditable( bool editable )
{
  mPassword->setReadOnly( !editable );
  mPasswordVerify->setReadOnly( !editable );
}

