/* Declarations of the pexecute functions for libiberty.
   Copyright 2001, 2002, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef PEXECUTE_H
#define PEXECUTE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "ansidecl.h"

#include <stdio.h>

/* Definitions used by the pexecute routine.  */

#define PEXECUTE_FIRST   1
#define PEXECUTE_LAST    2
#define PEXECUTE_ONE     (PEXECUTE_FIRST + PEXECUTE_LAST)
#define PEXECUTE_SEARCH  4
#define PEXECUTE_VERBOSE 8

/* Execute a program.  */

extern int pexecute PARAMS ((const char *, char * const *, const char *,
			    const char *, char **, char **, int));

/* Wait for pexecute to finish.  */

extern int pwait PARAMS ((int, int *, int));

/* Execute a program and read its standard output.  */

extern FILE *pex_read PARAMS ((const char *, char * const *, const char *,
			       const char *, char **, char **, int, int *));

/* Wait for pex_read to finish.  */

extern int pex_read_close PARAMS ((int, FILE *, int *, int));

#ifdef __cplusplus
}
#endif

#endif /* ! defined (PEXECUTE_H) */
