/* pref_dialog.vala
 *
 * Copyright (C) 2009-2010  troorl
 * Copyright (C) 2010 Kushal Das <kushal@fedoraproject.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	troorl <troorl@gmail.com>
 */

using Gtk;
using Auth;

public class PrefDialog : Dialog {
	
	private Notebook tabs;
	
	private Entry login;
	private Entry password;
	private CheckButton savePass;
	
	public AccountWidget accountWidget;
	
	public signal void delete_cache();
	
	public PrefDialog(Window parent, Accounts accounts) {
		this.modal = true;
		set_title(_("Preferences"));
		this.has_separator = false;
		
		tabs = new Notebook();
		
		//account page
		var ac_box = new VBox(false, 0);
		
		//accounts
		accountWidget = new AccountWidget(this, accounts);
		
		var table_auth = new HigTable(_("Authorization"));
		table_auth.add_widget_wide(accountWidget);
		
		ac_box.pack_start(table_auth, false, true, 10);
		
		tabs.append_page(ac_box, new Label(_("Account")));
		
		var hor_box = new HBox(false, 0);
		hor_box.pack_start(tabs, true, true, 10);
		
		this.vbox.pack_start(hor_box, true, true, 10);
		this.vbox.set_spacing(0);
		
		//action buttons
		add_button(STOCK_CLOSE, ResponseType.CLOSE);
		
		this.response.connect(response_acts);
		
		set_transient_for(parent);
		show_all();
		
	}
	
	
	private void response_acts(int resp_id) {
		switch(resp_id) {
			case ResponseType.CLOSE:
				close();
				break;
		}
	}	
}
