#ifndef GRAPH_H
#define GRAPH_H

#include <QtGui>

class MainWindow;
class RenderArea;
class QDomElement;

class Graph : public QWidget
{
    Q_OBJECT

public:
    explicit Graph(QWidget* parent=0);
    ~Graph();
    MainWindow* mainWindow; // for convenience
    QMdiSubWindow* window;
    QLineEdit* y1LineEdit;
    QLineEdit* y2LineEdit;
    QLineEdit* y3LineEdit;
    RenderArea* renderArea;
    void plot();
    void zoomIn();
    void zoomOut();
    void zoomReset();
    bool openFile(QString fileName);
    bool saveFile();
    bool saveAsFile();
    void close();
    void repopulateParameterEdits();

    enum ScaleStyle
    {
        Decimal,
        Radians
    };
    ScaleStyle scaleStyle;

protected:
    void closeEvent(QCloseEvent *event);

private:
    QVBoxLayout* vBox;
    QGridLayout* gridLayout;
    QLineEdit* xMinLineEdit;
    QLineEdit* xMaxLineEdit;
    QLineEdit* yMinLineEdit;
    QLineEdit* yMaxLineEdit;
    QString xMinOrig;
    QString xMaxOrig;
    QString yMinOrig;
    QString yMaxOrig;

    bool eventFilter(QObject *object, QEvent *event);
    bool maybeSave();
};

#endif // GRAPH_H
