// linker define fe_frombytes

/*
   This file is basically ref10/fe_frombytes.h.
*/

#include "fe.h"
#include "crypto_uint64.h"

static crypto_uint64 load_3(const unsigned char *in)
{
  crypto_uint64 result;
  result = (crypto_uint64) in[0];
  result |= ((crypto_uint64) in[1]) << 8;
  result |= ((crypto_uint64) in[2]) << 16;
  return result;
}

static crypto_uint64 load_4(const unsigned char *in)
{
  crypto_uint64 result;
  result = (crypto_uint64) in[0];
  result |= ((crypto_uint64) in[1]) << 8;
  result |= ((crypto_uint64) in[2]) << 16;
  result |= ((crypto_uint64) in[3]) << 24;
  return result;
}

void fe_frombytes(fe h,const unsigned char *s)
{
  crypto_uint64 h0 = load_4(s);
  crypto_uint64 h1 = load_3(s + 4) << 6;
  crypto_uint64 h2 = load_3(s + 7) << 5;
  crypto_uint64 h3 = load_3(s + 10) << 3;
  crypto_uint64 h4 = load_3(s + 13) << 2;
  crypto_uint64 h5 = load_4(s + 16);
  crypto_uint64 h6 = load_3(s + 20) << 7;
  crypto_uint64 h7 = load_3(s + 23) << 5;
  crypto_uint64 h8 = load_3(s + 26) << 4;
  crypto_uint64 h9 = (load_3(s + 29) & 8388607) << 2;
  crypto_uint64 carry0;
  crypto_uint64 carry1;
  crypto_uint64 carry2;
  crypto_uint64 carry3;
  crypto_uint64 carry4;
  crypto_uint64 carry5;
  crypto_uint64 carry6;
  crypto_uint64 carry7;
  crypto_uint64 carry8;
  crypto_uint64 carry9;

  carry9 = h9 >> 25; h0 += carry9 * 19; h9 &= 0x1FFFFFF;
  carry1 = h1 >> 25; h2 += carry1; h1 &= 0x1FFFFFF;
  carry3 = h3 >> 25; h4 += carry3; h3 &= 0x1FFFFFF;
  carry5 = h5 >> 25; h6 += carry5; h5 &= 0x1FFFFFF;
  carry7 = h7 >> 25; h8 += carry7; h7 &= 0x1FFFFFF;

  carry0 = h0 >> 26; h1 += carry0; h0 &= 0x3FFFFFF;
  carry2 = h2 >> 26; h3 += carry2; h2 &= 0x3FFFFFF;
  carry4 = h4 >> 26; h5 += carry4; h4 &= 0x3FFFFFF;
  carry6 = h6 >> 26; h7 += carry6; h6 &= 0x3FFFFFF;
  carry8 = h8 >> 26; h9 += carry8; h8 &= 0x3FFFFFF;

  h[0] = h0;
  h[1] = h1;
  h[2] = h2;
  h[3] = h3;
  h[4] = h4;
  h[5] = h5;
  h[6] = h6;
  h[7] = h7;
  h[8] = h8;
  h[9] = h9;
}
