/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;

final class TypeConverter {
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new ImmutableMap.Builder().put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Character.TYPE, Character.class).put(Double.TYPE, Double.class).put(Float.TYPE, Float.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Short.TYPE, Short.class).put(Void.TYPE, Void.class).build();

    private TypeConverter() {
    }

    public static Object fromString(String value, Type type) {
        if (type == String.class) {
            return value;
        }
        Class c = TypeConverter.wrap((Class)type);
        try {
            Method m = c.getMethod("valueOf", String.class);
            m.setAccessible(true);
            return m.invoke(null, value);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Cannot convert " + value + " of type " + type, e);
        }
    }

    private static <T> Class<T> wrap(Class<T> c) {
        return c.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(c) : c;
    }
}

