package Locales::DB::Language::brx;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::brx::VERSION = '0.09';

$Locales::DB::Language::brx::cldr_version = '2.0';

%Locales::DB::Language::brx::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#\,\#\#0\%",
        'territory' => "क्षेत्र\:भारत\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\"",
        'alternate_quotation_start' => "\"",
        'quotation_end'             => "\'",
        'quotation_start'           => "\'"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => 'नहीं',
        'yesstr' => 'हाँ'
    },
);

%Locales::DB::Language::brx::code_to_name = (
    'aa'     => 'Afar',
    'ab'     => 'अब्खाज़ियन्',
    'ace'    => 'अचेहनी',
    'ach'    => 'अकोली',
    'ada'    => 'अडांगमे',
    'ady'    => 'अडीगे',
    'ae'     => 'अवस्तन्',
    'af'     => 'अफ्रीकी',
    'afa'    => "अफ्रो\-एशियाई\ भाषाएँ",
    'afh'    => 'अफ्रीहीली',
    'agq'    => 'Aghem',
    'ain'    => 'ऐनू',
    'ak'     => 'अकन',
    'akk'    => 'अकाडिनी',
    'ale'    => 'अलुट',
    'alg'    => 'अलगौनकीन',
    'alt'    => "Southern\ Altai",
    'am'     => 'अम्हारिक्',
    'an'     => 'आर्गोनी',
    'ang'    => "पुरानी\ अंग्रेज़ी",
    'anp'    => 'अंगीका',
    'apa'    => "अपाची\ भाषा",
    'ar'     => 'अरबी',
    'arc'    => 'अरामाईक',
    'arn'    => 'Araucanian',
    'arp'    => 'अरापाहो',
    'art'    => "कृत्रिम\ भाषा",
    'arw'    => 'अरावाक',
    'as'     => 'असामी',
    'asa'    => 'Asu',
    'ast'    => 'Asturian',
    'ath'    => "अथापास्कन्\ भाषा",
    'aus'    => "औस्ट्रेलियाई\ भाषा",
    'av'     => 'अवारिक्',
    'awa'    => 'अवधी',
    'ay'     => 'आयमारा',
    'az'     => 'अज़रबैजानी',
    'ba'     => 'बशख़िर्',
    'bad'    => 'बंदा',
    'bai'    => 'बामीलेके',
    'bal'    => 'बलूची',
    'ban'    => 'बालिनी',
    'bas'    => 'बास्क़्',
    'bat'    => "बल्टीक\ भाषा",
    'be'     => 'बैलोरूसियन्',
    'bej'    => 'बेजा',
    'bem'    => 'बेंबा',
    'ber'    => 'बरबर्',
    'bez'    => 'Bena',
    'bg'     => 'बल्गैरियन्',
    'bh'     => 'बिहारी',
    'bho'    => 'भोजपुरी',
    'bi'     => 'बिस्लामा',
    'bik'    => 'बिकोल्',
    'bin'    => 'बिनी',
    'bla'    => 'सीकसीका',
    'bm'     => 'बांबारा',
    'bn'     => 'बंगला',
    'bnt'    => 'बाँटु',
    'bo'     => 'तिब्बती',
    'br'     => 'ब्रटों',
    'bra'    => 'ब्रज',
    'brx'    => 'बड़ो',
    'bs'     => 'बोस्नियाई',
    'btk'    => 'बातक',
    'bua'    => 'बुरियात',
    'bug'    => 'बुगीनी',
    'byn'    => 'ब्लीन',
    'ca'     => 'कातालान्',
    'cad'    => 'काद्दौ',
    'cai'    => "मध्य\ अमरिकी\ भाषा",
    'car'    => 'कारीब्',
    'cau'    => "काकौशी\ भाषा",
    'cay'    => 'Cayuga',
    'cch'    => 'आत्सम',
    'ce'     => 'चेचेन्',
    'ceb'    => 'चेबुआनो',
    'cel'    => "केल्ट\ भाषा",
    'cgg'    => 'Chiga',
    'ch'     => 'चामोरो',
    'chb'    => 'चीबचा',
    'chg'    => 'चगताई',
    'chk'    => 'चुकेसे',
    'chm'    => 'मारी',
    'chn'    => "चीनूक्\ जार्गन्",
    'cho'    => 'चौक्टो',
    'chp'    => 'चिपेवियान्',
    'chr'    => 'चीरोकी',
    'chy'    => 'शायान्',
    'cmc'    => 'चामीक्',
    'co'     => 'कोर्सीकन्',
    'cop'    => 'कॉप्टीक्',
    'cpe'    => "क्रेओल्\ \(अंग्रेजी\ आधारीत\)",
    'cpf'    => "क्रेओल्\ \(फ़्रानसीसी\ आधारीत\)",
    'cpp'    => "क्रेओल्\ \(पुर्तुगी\ आधारीत\)",
    'cr'     => 'क्री',
    'crh'    => "तुर्की\ क्रिमिया",
    'crp'    => "क्रेओल्\ या\ पीड्जीन",
    'cs'     => 'चेक्',
    'csb'    => 'काशुबियान्',
    'cu'     => "चर्च\ स्लाविक्",
    'cus'    => "कुशीतीक्\ भाषा",
    'cv'     => 'चुवाश्',
    'cy'     => 'वैल्श्',
    'da'     => 'डैनीश्',
    'dak'    => 'डकौटा',
    'dar'    => 'दर्गवा',
    'dav'    => 'Taita',
    'day'    => 'डयाक्',
    'de'     => 'ज़र्मन',
    'de_at'  => "जर्मन\ \(ऑस्ट्रिया\)",
    'de_ch'  => "उच्च\ स्तरिय\ स्वीस\ जर्मन",
    'del'    => 'दलावार्',
    'den'    => 'स्लेव्',
    'dgr'    => 'डोगरीब्',
    'din'    => 'डींगका',
    'dje'    => 'Zarma',
    'doi'    => 'डोगरी',
    'dra'    => "द्रविड्\ भाषा",
    'dsb'    => 'सोर्बियन्',
    'dua'    => 'डुआला',
    'dum'    => "मध्य\ डच",
    'dv'     => 'दीवेही',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'द्युआला',
    'dz'     => 'भुटानी',
    'ebu'    => 'Embu',
    'ee'     => 'एवे',
    'efi'    => 'एफीक्',
    'egy'    => "प्राचीन\ मिस्री",
    'eka'    => 'एकाजुक',
    'el'     => 'ग्रीक',
    'elx'    => 'एलामी',
    'en'     => 'अंग्रेज़ी',
    'en_au'  => "अंग्रेज़ी\ \(ऑस्ट्रेलिया\ का\)",
    'en_ca'  => "अंग्रेज़ी\ \(कनाडाई\)",
    'en_gb'  => "अंग्रेजी\ \(ब्रिटिश\)",
    'en_us'  => "अंग्रेज़ी\ \(अमरिकी\)",
    'enm'    => "मध्य\ अंग्रेज़ी",
    'eo'     => 'एस्पेरान्तो',
    'es'     => 'स्पैनिश',
    'es_419' => "लैटिन\ अमरिकी\ स्पैनिश",
    'es_es'  => "ईवेरियाई\ स्पैनिश",
    'et'     => 'ऐस्टोनियन्',
    'eu'     => 'बास्क्',
    'ewo'    => 'एवौंडो',
    'fa'     => 'फार्सी',
    'fan'    => 'फाँग्',
    'fat'    => 'फाँटी',
    'ff'     => 'फुलाह्',
    'fi'     => 'फिनिश्',
    'fil'    => 'फिलिपिनो',
    'fiu'    => "फीनो\-ऊग्री\ भाषा",
    'fj'     => 'फ़ीजी',
    'fo'     => 'फिरोज़ी',
    'fon'    => 'फोन',
    'fr'     => 'फ्रांसीसी',
    'fr_ca'  => "फ्रांसीसी\ \(कनाडाई\)",
    'fr_ch'  => "फ्रांसीसी\ \(स्वीस\)",
    'frm'    => "मध्य\ फ्रांसीसी",
    'fro'    => "पुरानी\ फ्रांसीसी",
    'frr'    => "उत्तरी\ फ्रीज़ियन्",
    'frs'    => "पूर्वी\ फ्रीज़ियन्",
    'fur'    => 'फ्रीउलीअन्',
    'fy'     => "पश्चीमी\ फ्रीज़ियन्",
    'ga'     => 'आईरिश',
    'gaa'    => 'गा',
    'gay'    => 'गायो',
    'gba'    => 'ग्बाया',
    'gd'     => "स्कॉट्स्\ गैलिक्",
    'gem'    => "जर्मनी\ भाषा",
    'gez'    => 'गीज़्',
    'gil'    => 'गीलबर्टी',
    'gl'     => 'गैलिशियन्',
    'gmh'    => "मध्य\ उच्चस्तरी\ जर्मन",
    'gn'     => 'गुआरानी',
    'goh'    => "पुरानी\ उच्चस्तरी\ जर्मन",
    'gon'    => 'गाँडी',
    'gor'    => 'गोरंटालो',
    'got'    => 'गॉथिक',
    'grb'    => 'ग्रेबो',
    'grc'    => "प्राचीन\ यूनानी",
    'gsw'    => "स्वीस\ जर्मन",
    'gu'     => 'गुजराती',
    'guz'    => 'Gusii',
    'gv'     => 'मैंक्स',
    'gwi'    => 'ग्वीचलीन',
    'ha'     => 'हउसा',
    'hai'    => 'हईडा',
    'haw'    => 'हवाईअन',
    'he'     => 'हिब्रु',
    'hi'     => 'हिंदी',
    'hil'    => 'हीलीगैनोन',
    'him'    => 'हिमांचली',
    'hit'    => 'हीत्ती',
    'hmn'    => 'ह्मौंग',
    'ho'     => "हीरी\ मोटु",
    'hr'     => 'क्रोएशन्',
    'hsb'    => "ऊपरी\ सौर्बियन",
    'ht'     => 'हाईशीयन्',
    'hu'     => 'हंगैरीयन्',
    'hup'    => 'हूपा',
    'hy'     => 'अरमेनियन्',
    'hz'     => 'हेरेरो',
    'ia'     => 'ईन्टरलिंग्वा',
    'iba'    => 'ईबान्',
    'id'     => 'इन्डोनेशियन्',
    'ie'     => 'ईन्टरलिंग्वे',
    'ig'     => 'ईग्बो',
    'ii'     => "सीचुआन्\ यी",
    'ijo'    => 'ईजो',
    'ik'     => 'इनुपियाक़्',
    'ilo'    => 'ईलोको',
    'inc'    => "भारतीय\ भाषाएँ",
    'ine'    => "ईंडो\ यूरोपी\ भाषाएँ",
    'inh'    => 'ईंगुष',
    'io'     => 'ईडो',
    'ira'    => "ईरानी\ भाषाएँ",
    'iro'    => 'ईरोक़्वाईअन',
    'is'     => 'आईस्लैंडिक्',
    'it'     => 'ईटालियन्',
    'iu'     => 'इनूक्टीटूत्',
    'ja'     => 'जापानी',
    'jbo'    => 'लोजबान',
    'jmc'    => 'Machame',
    'jpr'    => "यहुदी\ फ़ारसी",
    'jrb'    => "यहुदी\ अरबी",
    'jv'     => 'जावानीस',
    'ka'     => 'जॉर्जियन्',
    'kaa'    => "कारा\ कलपक",
    'kab'    => 'काबील्',
    'kac'    => 'कचीन्',
    'kaj'    => 'जु',
    'kam'    => 'कंबा',
    'kar'    => 'करेन्',
    'kaw'    => 'कावी',
    'kbd'    => "कबार्डी\ भाषा",
    'kcg'    => 'त्याप्',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'कोरो',
    'kg'     => 'कॉंगो',
    'kha'    => 'ख़ासी',
    'khi'    => "खोईसान्\ भाषा",
    'kho'    => 'ख़ोतानी',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'किकुयु',
    'kj'     => 'कुआनयामा',
    'kk'     => 'क़ज़ाख़्',
    'kl'     => 'कलालीसुत',
    'kln'    => 'Kalenjin',
    'km'     => 'ख्मेर',
    'kmb'    => 'कींबुंडु',
    'kn'     => 'कन्नड्',
    'ko'     => 'कोरीयन्',
    'kok'    => 'कोंकणी',
    'kos'    => 'कोस्राईयन्',
    'kpe'    => 'क्पेले',
    'kr'     => 'कनुरी',
    'krc'    => "कराचय्\ बलकार्",
    'krl'    => 'करेलियन्',
    'kro'    => 'क्रु',
    'kru'    => 'कुरुख़्',
    'ks'     => 'कश्मिरी',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'कुर्दी',
    'kum'    => 'कुमीक्',
    'kut'    => 'कुतेनाई',
    'kv'     => 'कोमी',
    'kw'     => 'कौर्नवॉली',
    'ky'     => 'किरग़ीज़्',
    'la'     => 'लैटीन्',
    'lad'    => 'लाड़ीनो',
    'lag'    => 'Langi',
    'lah'    => 'लाह्डां',
    'lam'    => 'लांबा',
    'lb'     => 'लुक्समबुर्गी',
    'lez'    => 'लेज़गीयान',
    'lg'     => 'गांडा',
    'li'     => 'लींबुर्गी',
    'ln'     => 'लिंगाला',
    'lo'     => 'लाओसीयन्',
    'lol'    => 'मोंगो',
    'loz'    => 'लोज़ी',
    'lt'     => 'लिथुआनियन्',
    'lu'     => "लुबा\ कटांगा",
    'lua'    => "लुबा\ लुलुआ",
    'lui'    => 'लुईसेनो',
    'lun'    => 'लुंडा',
    'luo'    => 'लुओ',
    'lus'    => 'लुशाई',
    'luy'    => 'Luyia',
    'lv'     => "लाटवियन्\ \(लैट्टीश\)",
    'mad'    => 'मादुरी',
    'mag'    => 'मघी',
    'mai'    => 'मैथीली',
    'mak'    => 'मक्सर',
    'man'    => 'मांडींगो',
    'map'    => 'औस्ट्रोनेसी',
    'mas'    => 'मसाई',
    'mdf'    => 'मोक्षा',
    'mdr'    => 'मंदार',
    'men'    => 'मेंदे',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'मालागासी',
    'mga'    => "मध्य\ आईरीश\ भाषा",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'मार्शली',
    'mi'     => 'माओरी',
    'mic'    => 'मीकमाक',
    'min'    => 'मिनंगकाबाउ',
    'mis'    => "Miscellaneous\ Language",
    'mk'     => 'मैसेडोनियन्',
    'mkh'    => "मोन\ ख्मेर",
    'ml'     => 'मलयालम',
    'mn'     => 'मोंगोलियन',
    'mnc'    => 'मांचु',
    'mni'    => 'मणीपुरी',
    'mno'    => 'मानोबो',
    'mo'     => 'मोल्डेवियन्',
    'moh'    => 'मोहोक',
    'mos'    => 'मोस्सी',
    'mr'     => 'मराठी',
    'ms'     => 'मलाय',
    'mt'     => 'मालटीज़्',
    'mua'    => 'Mundang',
    'mul'    => "Multiple\ Languages",
    'mun'    => 'मुंडा',
    'mus'    => 'क्रीक',
    'mwl'    => 'मीरांडी',
    'mwr'    => 'मारवाड़ी',
    'my'     => 'बर्मी',
    'myn'    => "माया\ भाषा",
    'myv'    => 'ऐर्ज़िया',
    'na'     => 'नाऊरू',
    'nah'    => 'नाहुआतल्',
    'nai'    => "उत्तर\ अमरिकी\ भाषाएँ",
    'nap'    => 'नेआपोलिटन',
    'naq'    => 'Nama',
    'nb'     => "नोर्वेगी\ बोकमाल",
    'nd'     => "उत्तर\ न्दबेले",
    'nds'    => "नीजी\ स्तरिय\ जर्मन",
    'ne'     => 'नेपाली',
    'new'    => 'नेवारी',
    'ng'     => 'न्डोंगा',
    'nia'    => 'नियास',
    'nic'    => "निगेर\ कोर्डोफियान\ भाषा",
    'niu'    => 'नियुइआन',
    'nl'     => 'डच्',
    'nl_be'  => 'फ्लेमी',
    'nmg'    => 'Kwasio',
    'nn'     => "नॉर्वेजियन्\ नीनॉर्स्क्",
    'no'     => 'नॉर्वेजीयन्',
    'nog'    => 'नोगाई',
    'non'    => "पुरानी\ नॉर्स्",
    'nqo'    => 'न्गको',
    'nr'     => "दक्षिणी\ न्दबेले",
    'nso'    => "Northern\ Sotho",
    'nub'    => 'नुबियन',
    'nus'    => 'Nuer',
    'nv'     => 'नावाहो',
    'nwc'    => "पुरानी\ नेवारी",
    'ny'     => 'न्यानजा',
    'nym'    => 'न्यामवेज़ी',
    'nyn'    => 'न्यानकोले',
    'nyo'    => 'न्यौरो',
    'nzi'    => 'न्ज़ीमा',
    'oc'     => 'ओक्सीतान',
    'oj'     => 'ओहीबवा',
    'om'     => "ओरोमो\ \(अफ़ान\)",
    'or'     => 'उड़िया',
    'os'     => 'ओस्सेटी',
    'osa'    => 'ओसेज',
    'ota'    => "तुर्की\ ओटोमान",
    'oto'    => 'ओटोमानी',
    'pa'     => 'पंजाबी',
    'paa'    => 'पापुअन',
    'pag'    => 'पांगासीनन',
    'pal'    => 'पहलवी',
    'pam'    => 'पंपंगा',
    'pap'    => 'पापीआमेन्तो',
    'pau'    => 'पालाऊ',
    'peo'    => "पुरानी\ फ़ारसी",
    'phi'    => 'फ़ीलीपीनी',
    'phn'    => 'फीनीसी',
    'pi'     => 'पाली',
    'pl'     => 'पोलिश',
    'pon'    => 'पोहनपी',
    'pra'    => 'प्राकृत',
    'pro'    => "पुरानी\ प्रोवाँसाल",
    'ps'     => 'पख़्तु',
    'pt'     => 'पुर्तगाली',
    'pt_br'  => "Brazilian\ Portuguese",
    'pt_pt'  => "Iberian\ Portuguese",
    'qu'     => 'क्वेचुआ',
    'raj'    => 'राजस्थानी',
    'rap'    => 'रापानुई',
    'rar'    => 'रारोटोंगा',
    'rm'     => "रेह्टो\-रोमान्स",
    'rn'     => 'किरून्दी',
    'ro'     => 'रूमानीयन्',
    'roa'    => 'रोमान्स्',
    'rof'    => 'Rombo',
    'rom'    => 'रुमानी',
    'ru'     => 'रुसी',
    'rup'    => 'आरोमानी',
    'rw'     => 'किन्यारुआण्डा',
    'rwk'    => 'Rwa',
    'sa'     => 'संस्कृत्',
    'sad'    => 'संडावे',
    'sah'    => 'यकुट्',
    'sai'    => "दक्षिणी\ अमरिकी\ भाषाएँ",
    'sal'    => 'सलीशान',
    'sam'    => "समारीती\ आरामाईक़",
    'saq'    => 'Samburu',
    'sas'    => 'सासक',
    'sat'    => 'संताली',
    'sbp'    => 'Sangu',
    'sc'     => 'सार्दीनी',
    'scn'    => 'सीसीलीअन',
    'sco'    => 'स्कॉट',
    'sd'     => 'सिंधी',
    'se'     => "उत्तरी\ सामी",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'सेलकुप',
    'sem'    => "सैमीटीक\ भाषाएँ",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'सांग्रो',
    'sga'    => "पुरानी\ आईरीश",
    'sgn'    => "चीह्न\ भाषा",
    'sh'     => "सर्बो\-क्रोएशन्",
    'shi'    => 'Tachelhit',
    'shn'    => 'शान',
    'si'     => 'सींहाला',
    'sid'    => 'सीदामो',
    'sio'    => 'सीऊआन',
    'sit'    => "सीनो\ तिब्बती\ भाषाएँ",
    'sk'     => 'स्लोवाक्',
    'sl'     => 'स्लोवेनियन्',
    'sla'    => 'स्लाव्',
    'sm'     => 'सामोअन',
    'sma'    => "पश्चीमी\ सामी",
    'smi'    => 'सामी',
    'smj'    => "लुले\ सामी",
    'smn'    => "ईनारी\ सामी",
    'sms'    => "स्कोल्ट्\ सामी",
    'sn'     => 'शोना',
    'snk'    => 'सोनिंगके',
    'so'     => 'सोमाली',
    'sog'    => 'सोगडीयन',
    'son'    => 'सोंघाई',
    'sq'     => 'आल्बेनियन्',
    'sr'     => 'सर्बियन्',
    'srn'    => "स्रनान्\ टॉंगो",
    'srr'    => 'सेरेर',
    'ss'     => 'स्वाटि',
    'ssa'    => "नील\ सहारा\ भाषा",
    'ssy'    => 'Saho',
    'st'     => "Southern\ Sotho",
    'su'     => 'सुन्दानी',
    'suk'    => 'सुकुमा',
    'sus'    => 'सुसु',
    'sux'    => 'सुमेरिअन',
    'sv'     => 'स्वीडिश',
    'sw'     => 'स्वाहिली',
    'swb'    => 'Comorian',
    'swc'    => "Congo\ Swahili",
    'syc'    => "पारंपरीक\ सिरिआक",
    'syr'    => 'सिरिआक',
    'ta'     => 'तमिळ',
    'tai'    => 'ताई',
    'te'     => 'तेलुगु',
    'tem'    => 'तीमने',
    'teo'    => 'Teso',
    'ter'    => 'तेरेनो',
    'tet'    => 'तेतुम',
    'tg'     => 'ताजिक्',
    'th'     => 'थाई',
    'ti'     => 'तिग्रीन्या',
    'tig'    => 'टीग्रे',
    'tiv'    => 'टीव्',
    'tk'     => 'तुर्कमेन',
    'tkl'    => 'टोकेलौ',
    'tl'     => 'तागालोग',
    'tlh'    => 'क्लींगदन',
    'tli'    => 'ट्लिंगीत',
    'tmh'    => 'तमाशेक',
    'tn'     => 'त्स्वाना',
    'to'     => 'टॉंगा',
    'tog'    => "न्यासा\ टॉंगा",
    'tpi'    => "तोक\ पिसीन",
    'tr'     => 'तुर्की',
    'trv'    => 'Taroko',
    'ts'     => 'सोंगा',
    'tsi'    => 'त्सीमशीआन्',
    'tt'     => 'टाटर्',
    'tum'    => 'टुँबुका',
    'tup'    => 'तुपी',
    'tut'    => "Altaic\ Language",
    'tvl'    => 'टुवालु',
    'tw'     => 'ट्वी',
    'twq'    => 'Tasawaq',
    'ty'     => 'टाहिटि',
    'tyv'    => 'टुवी',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'उड़मुर्त',
    'ug'     => 'उईग़ुर',
    'uga'    => 'उगारिती',
    'uk'     => 'यूक्रेनियन्',
    'umb'    => 'उंबुंडु',
    'und'    => "अज्ञात\ या\ अवैध\ भाषा",
    'ur'     => 'ऊर्दु',
    'uz'     => 'उज़बेक्',
    'vai'    => 'वाई',
    've'     => 'वेंडा',
    'vi'     => 'वियेतनामी',
    'vo'     => 'वोलापोक',
    'vot'    => 'वोटीक',
    'vun'    => 'Vunjo',
    'wa'     => 'वालुन',
    'wae'    => 'Walser',
    'wak'    => 'वाकाशान',
    'wal'    => 'वालामो',
    'war'    => 'वारय',
    'was'    => 'वाशो',
    'wen'    => 'सोर्बीयन',
    'wo'     => 'वोलोफ',
    'xal'    => 'कालमीक',
    'xh'     => 'ख़ोसा',
    'xog'    => 'Soga',
    'yao'    => 'याओ',
    'yap'    => 'यापीज़',
    'yav'    => 'Yangben',
    'yi'     => 'यीद्दीश',
    'yo'     => 'योरूबा',
    'ypk'    => "युपीक\ भाषा",
    'yue'    => 'Cantonese',
    'za'     => 'ज़ुआंग',
    'zap'    => 'ज़ापोतेक',
    'zbl'    => "ब्लीस\ चिन्ह",
    'zen'    => 'ज़ेनागा',
    'zh'     => 'चीनी',
    'znd'    => 'ज़ांडे',
    'zu'     => 'ज़ुलू',
    'zun'    => 'ज़ुनी',
    'zxx'    => 'रिक्त',
    'zza'    => 'ज़ाज़ा',
);

%Locales::DB::Language::brx::name_to_code = (
    'afar'                                                                  => 'aa',
    'aghem'                                                                 => 'agq',
    'altaiclanguage'                                                        => 'tut',
    'araucanian'                                                            => 'arn',
    'asturian'                                                              => 'ast',
    'asu'                                                                   => 'asa',
    'bafia'                                                                 => 'ksf',
    'bena'                                                                  => 'bez',
    'brazilianportuguese'                                                   => 'pt_br',
    'cantonese'                                                             => 'yue',
    'cayuga'                                                                => 'cay',
    'centralmoroccotamazight'                                               => 'tzm',
    'chiga'                                                                 => 'cgg',
    'colognian'                                                             => 'ksh',
    'comorian'                                                              => 'swb',
    'congoswahili'                                                          => 'swc',
    'embu'                                                                  => 'ebu',
    'gusii'                                                                 => 'guz',
    'iberianportuguese'                                                     => 'pt_pt',
    'jolafonyi'                                                             => 'dyo',
    'kabuverdianu'                                                          => 'kea',
    'kalenjin'                                                              => 'kln',
    'koyraborosenni'                                                        => 'ses',
    'koyrachiini'                                                           => 'khq',
    'kwasio'                                                                => 'nmg',
    'langi'                                                                 => 'lag',
    'luyia'                                                                 => 'luy',
    'machame'                                                               => 'jmc',
    'makhuwameetto'                                                         => 'mgh',
    'makonde'                                                               => 'kde',
    'meru'                                                                  => 'mer',
    'miscellaneouslanguage'                                                 => 'mis',
    'morisyen'                                                              => 'mfe',
    'multiplelanguages'                                                     => 'mul',
    'mundang'                                                               => 'mua',
    'nama'                                                                  => 'naq',
    'northernsotho'                                                         => 'nso',
    'nuer'                                                                  => 'nus',
    'rombo'                                                                 => 'rof',
    'rwa'                                                                   => 'rwk',
    'saho'                                                                  => 'ssy',
    'samburu'                                                               => 'saq',
    'sangu'                                                                 => 'sbp',
    'sena'                                                                  => 'seh',
    'seneca'                                                                => 'see',
    'shambala'                                                              => 'ksb',
    'soga'                                                                  => 'xog',
    'southernaltai'                                                         => 'alt',
    'southernsotho'                                                         => 'st',
    'tachelhit'                                                             => 'shi',
    'taita'                                                                 => 'dav',
    'taroko'                                                                => 'trv',
    'tasawaq'                                                               => 'twq',
    'teso'                                                                  => 'teo',
    'vunjo'                                                                 => 'vun',
    'walser'                                                                => 'wae',
    'yangben'                                                               => 'yav',
    'zarma'                                                                 => 'dje',
    'अंगीका'                                                    => 'anp',
    'अंग्रेज़ी'                                           => 'en',
    'अंग्रेज़ीअमरिकी'                         => 'en_us',
    'अंग्रेज़ीऑस्ट्रेलियाका'    => 'en_au',
    'अंग्रेज़ीकनाडाई'                         => 'en_ca',
    'अंग्रेजीब्रिटिश'                         => 'en_gb',
    'अकन'                                                             => 'ak',
    'अकाडिनी'                                                 => 'akk',
    'अकोली'                                                       => 'ach',
    'अचेहनी'                                                    => 'ace',
    'अज़रबैजानी'                                        => 'az',
    'अज्ञातयाअवैधभाषा'                      => 'und',
    'अडांगमे'                                                 => 'ada',
    'अडीगे'                                                       => 'ady',
    'अथापास्कन्भाषा'                            => 'ath',
    'अपाचीभाषा'                                           => 'apa',
    'अफ्रीकी'                                                 => 'af',
    'अफ्रीहीली'                                           => 'afh',
    'अफ्रोएशियाईभाषाएँ'                   => 'afa',
    'अब्खाज़ियन्'                                     => 'ab',
    'अम्हारिक्'                                           => 'am',
    'अरबी'                                                          => 'ar',
    'अरमेनियन्'                                           => 'hy',
    'अरापाहो'                                                 => 'arp',
    'अरामाईक'                                                 => 'arc',
    'अरावाक'                                                    => 'arw',
    'अलगौनकीन'                                              => 'alg',
    'अलुट'                                                          => 'ale',
    'अवधी'                                                          => 'awa',
    'अवस्तन्'                                                 => 'ae',
    'अवारिक्'                                                 => 'av',
    'असामी'                                                       => 'as',
    'आईरिश'                                                       => 'ga',
    'आईस्लैंडिक्'                                     => 'is',
    'आत्सम'                                                       => 'cch',
    'आयमारा'                                                    => 'ay',
    'आरोमानी'                                                 => 'rup',
    'आर्गोनी'                                                 => 'an',
    'आल्बेनियन्'                                        => 'sq',
    'इनुपियाक़्'                                        => 'ik',
    'इनूक्टीटूत्'                                     => 'iu',
    'इन्डोनेशियन्'                                  => 'id',
    'ईंगुष'                                                       => 'inh',
    'ईंडोयूरोपीभाषाएँ'                      => 'ine',
    'ईग्बो'                                                       => 'ig',
    'ईजो'                                                             => 'ijo',
    'ईटालियन्'                                              => 'it',
    'ईडो'                                                             => 'io',
    'ईनारीसामी'                                           => 'smn',
    'ईन्टरलिंग्वा'                                  => 'ia',
    'ईन्टरलिंग्वे'                                  => 'ie',
    'ईबान्'                                                       => 'iba',
    'ईरानीभाषाएँ'                                     => 'ira',
    'ईरोक़्वाईअन'                                     => 'iro',
    'ईलोको'                                                       => 'ilo',
    'ईवेरियाईस्पैनिश'                         => 'es_es',
    'उंबुंडु'                                                 => 'umb',
    'उईग़ुर'                                                    => 'ug',
    'उगारिती'                                                 => 'uga',
    'उच्चस्तरियस्वीसजर्मन'          => 'de_ch',
    'उज़बेक्'                                                 => 'uz',
    'उड़मुर्त'                                              => 'udm',
    'उड़िया'                                                    => 'or',
    'उत्तरअमरिकीभाषाएँ'                   => 'nai',
    'उत्तरन्दबेले'                                  => 'nd',
    'उत्तरीफ्रीज़ियन्'                      => 'frr',
    'उत्तरीसामी'                                        => 'se',
    'ऊपरीसौर्बियन'                                  => 'hsb',
    'ऊर्दु'                                                       => 'ur',
    'एकाजुक'                                                    => 'eka',
    'एफीक्'                                                       => 'efi',
    'एलामी'                                                       => 'elx',
    'एवे'                                                             => 'ee',
    'एवौंडो'                                                    => 'ewo',
    'एस्पेरान्तो'                                     => 'eo',
    'ऐनू'                                                             => 'ain',
    'ऐर्ज़िया'                                              => 'myv',
    'ऐस्टोनियन्'                                        => 'et',
    'ओक्सीतान'                                              => 'oc',
    'ओटोमानी'                                                 => 'oto',
    'ओरोमोअफ़ान'                                        => 'om',
    'ओसेज'                                                          => 'osa',
    'ओस्सेटी'                                                 => 'os',
    'ओहीबवा'                                                    => 'oj',
    'औस्ट्रेलियाईभाषा'                      => 'aus',
    'औस्ट्रोनेसी'                                     => 'map',
    'कंबा'                                                          => 'kam',
    'कचीन्'                                                       => 'kac',
    'कनुरी'                                                       => 'kr',
    'कन्नड्'                                                    => 'kn',
    'कबार्डीभाषा'                                     => 'kbd',
    'कराचय्बलकार्'                                  => 'krc',
    'करेन्'                                                       => 'kar',
    'करेलियन्'                                              => 'krl',
    'कलालीसुत'                                              => 'kl',
    'कश्मिरी'                                                 => 'ks',
    'क़ज़ाख़्'                                              => 'kk',
    'काकौशीभाषा'                                        => 'cau',
    'कातालान्'                                              => 'ca',
    'काद्दौ'                                                    => 'cad',
    'काबील्'                                                    => 'kab',
    'काराकलपक'                                              => 'kaa',
    'कारीब्'                                                    => 'car',
    'कालमीक'                                                    => 'xal',
    'कावी'                                                          => 'kaw',
    'काशुबियान्'                                        => 'csb',
    'किकुयु'                                                    => 'ki',
    'किन्यारुआण्डा'                               => 'rw',
    'किरग़ीज़्'                                           => 'ky',
    'किरून्दी'                                              => 'rn',
    'कींबुंडु'                                              => 'kmb',
    'कुआनयामा'                                              => 'kj',
    'कुतेनाई'                                                 => 'kut',
    'कुमीक्'                                                    => 'kum',
    'कुरुख़्'                                                 => 'kru',
    'कुर्दी'                                                    => 'ku',
    'कुशीतीक्भाषा'                                  => 'cus',
    'कृत्रिमभाषा'                                     => 'art',
    'केल्टभाषा'                                           => 'cel',
    'कॉंगो'                                                       => 'kg',
    'कॉप्टीक्'                                              => 'cop',
    'कोंकणी'                                                    => 'kok',
    'कोमी'                                                          => 'kv',
    'कोरीयन्'                                                 => 'ko',
    'कोरो'                                                          => 'kfo',
    'कोर्सीकन्'                                           => 'co',
    'कोस्राईयन्'                                        => 'kos',
    'कौर्नवॉली'                                           => 'kw',
    'क्पेले'                                                    => 'kpe',
    'क्री'                                                          => 'cr',
    'क्रीक'                                                       => 'mus',
    'क्रु'                                                          => 'kro',
    'क्रेओल्अंग्रेजीआधारीत'       => 'cpe',
    'क्रेओल्पुर्तुगीआधारीत'       => 'cpp',
    'क्रेओल्फ़्रानसीसीआधारीत' => 'cpf',
    'क्रेओल्यापीड्जीन'                      => 'crp',
    'क्रोएशन्'                                              => 'hr',
    'क्लींगदन'                                              => 'tlh',
    'क्वेचुआ'                                                 => 'qu',
    'ख़ासी'                                                       => 'kha',
    'ख़ोतानी'                                                 => 'kho',
    'ख़ोसा'                                                       => 'xh',
    'खोईसान्भाषा'                                     => 'khi',
    'ख्मेर'                                                       => 'km',
    'गा'                                                                => 'gaa',
    'गाँडी'                                                       => 'gon',
    'गांडा'                                                       => 'lg',
    'गायो'                                                          => 'gay',
    'गीज़्'                                                       => 'gez',
    'गीलबर्टी'                                              => 'gil',
    'गुआरानी'                                                 => 'gn',
    'गुजराती'                                                 => 'gu',
    'गैलिशियन्'                                           => 'gl',
    'गॉथिक'                                                       => 'got',
    'गोरंटालो'                                              => 'gor',
    'ग्बाया'                                                    => 'gba',
    'ग्रीक'                                                       => 'el',
    'ग्रेबो'                                                    => 'grb',
    'ग्वीचलीन'                                              => 'gwi',
    'चगताई'                                                       => 'chg',
    'चर्चस्लाविक्'                                  => 'cu',
    'चामीक्'                                                    => 'cmc',
    'चामोरो'                                                    => 'ch',
    'चिपेवियान्'                                        => 'chp',
    'चीनी'                                                          => 'zh',
    'चीनूक्जार्गन्'                               => 'chn',
    'चीबचा'                                                       => 'chb',
    'चीरोकी'                                                    => 'chr',
    'चीह्नभाषा'                                           => 'sgn',
    'चुकेसे'                                                    => 'chk',
    'चुवाश्'                                                    => 'cv',
    'चेक्'                                                          => 'cs',
    'चेचेन्'                                                    => 'ce',
    'चेबुआनो'                                                 => 'ceb',
    'चौक्टो'                                                    => 'cho',
    'जर्मनऑस्ट्रिया'                            => 'de_at',
    'जर्मनीभाषा'                                        => 'gem',
    'ज़र्मन'                                                    => 'de',
    'ज़ांडे'                                                    => 'znd',
    'ज़ाज़ा'                                                    => 'zza',
    'ज़ापोतेक'                                              => 'zap',
    'ज़ुआंग'                                                    => 'za',
    'ज़ुनी'                                                       => 'zun',
    'ज़ुलू'                                                       => 'zu',
    'ज़ेनागा'                                                 => 'zen',
    'जापानी'                                                    => 'ja',
    'जावानीस'                                                 => 'jv',
    'जु'                                                                => 'kaj',
    'जॉर्जियन्'                                           => 'ka',
    'टाटर्'                                                       => 'tt',
    'टाहिटि'                                                    => 'ty',
    'टीग्रे'                                                    => 'tig',
    'टीव्'                                                          => 'tiv',
    'टुँबुका'                                                 => 'tum',
    'टुवालु'                                                    => 'tvl',
    'टुवी'                                                          => 'tyv',
    'टॉंगा'                                                       => 'to',
    'टोकेलौ'                                                    => 'tkl',
    'ट्लिंगीत'                                              => 'tli',
    'ट्वी'                                                          => 'tw',
    'डकौटा'                                                       => 'dak',
    'डच्'                                                             => 'nl',
    'डयाक्'                                                       => 'day',
    'डींगका'                                                    => 'din',
    'डुआला'                                                       => 'dua',
    'डैनीश्'                                                    => 'da',
    'डोगरी'                                                       => 'doi',
    'डोगरीब्'                                                 => 'dgr',
    'तमाशेक'                                                    => 'tmh',
    'तमिळ'                                                          => 'ta',
    'ताई'                                                             => 'tai',
    'तागालोग'                                                 => 'tl',
    'ताजिक्'                                                    => 'tg',
    'तिग्रीन्या'                                        => 'ti',
    'तिब्बती'                                                 => 'bo',
    'तीमने'                                                       => 'tem',
    'तुपी'                                                          => 'tup',
    'तुर्कमेन'                                              => 'tk',
    'तुर्की'                                                    => 'tr',
    'तुर्कीओटोमान'                                  => 'ota',
    'तुर्कीक्रिमिया'                            => 'crh',
    'तेतुम'                                                       => 'tet',
    'तेरेनो'                                                    => 'ter',
    'तेलुगु'                                                    => 'te',
    'तोकपिसीन'                                              => 'tpi',
    'त्याप्'                                                    => 'kcg',
    'त्सीमशीआन्'                                        => 'tsi',
    'त्स्वाना'                                              => 'tn',
    'थाई'                                                             => 'th',
    'दक्षिणीअमरिकीभाषाएँ'             => 'sai',
    'दक्षिणीन्दबेले'                            => 'nr',
    'दर्गवा'                                                    => 'dar',
    'दलावार्'                                                 => 'del',
    'दीवेही'                                                    => 'dv',
    'द्युआला'                                                 => 'dyu',
    'द्रविड्भाषा'                                     => 'dra',
    'नाऊरू'                                                       => 'na',
    'नावाहो'                                                    => 'nv',
    'नाहुआतल्'                                              => 'nah',
    'निगेरकोर्डोफियानभाषा'          => 'nic',
    'नियास'                                                       => 'nia',
    'नियुइआन'                                                 => 'niu',
    'नीजीस्तरियजर्मन'                         => 'nds',
    'नीलसहाराभाषा'                                  => 'ssa',
    'नुबियन'                                                    => 'nub',
    'नेआपोलिटन'                                           => 'nap',
    'नेपाली'                                                    => 'ne',
    'नेवारी'                                                    => 'new',
    'नॉर्वेजियन्नीनॉर्स्क्'       => 'nn',
    'नॉर्वेजीयन्'                                     => 'no',
    'नोगाई'                                                       => 'nog',
    'नोर्वेगीबोकमाल'                            => 'nb',
    'न्गको'                                                       => 'nqo',
    'न्ज़ीमा'                                                 => 'nzi',
    'न्डोंगा'                                                 => 'ng',
    'न्यानकोले'                                           => 'nyn',
    'न्यानजा'                                                 => 'ny',
    'न्यामवेज़ी'                                        => 'nym',
    'न्यासाटॉंगा'                                     => 'tog',
    'न्यौरो'                                                    => 'nyo',
    'पंजाबी'                                                    => 'pa',
    'पंपंगा'                                                    => 'pam',
    'पख़्तु'                                                    => 'ps',
    'पश्चीमीफ्रीज़ियन्'                   => 'fy',
    'पश्चीमीसामी'                                     => 'sma',
    'पहलवी'                                                       => 'pal',
    'पांगासीनन'                                           => 'pag',
    'पापीआमेन्तो'                                     => 'pap',
    'पापुअन'                                                    => 'paa',
    'पारंपरीकसिरिआक'                            => 'syc',
    'पालाऊ'                                                       => 'pau',
    'पाली'                                                          => 'pi',
    'पुरानीअंग्रेज़ी'                         => 'ang',
    'पुरानीआईरीश'                                     => 'sga',
    'पुरानीउच्चस्तरीजर्मन'          => 'goh',
    'पुरानीनेवारी'                                  => 'nwc',
    'पुरानीनॉर्स्'                                  => 'non',
    'पुरानीप्रोवाँसाल'                      => 'pro',
    'पुरानीफ़ारसी'                                  => 'peo',
    'पुरानीफ्रांसीसी'                         => 'fro',
    'पुर्तगाली'                                           => 'pt',
    'पूर्वीफ्रीज़ियन्'                      => 'frs',
    'पोलिश'                                                       => 'pl',
    'पोहनपी'                                                    => 'pon',
    'प्राकृत'                                                 => 'pra',
    'प्राचीनमिस्री'                               => 'egy',
    'प्राचीनयूनानी'                               => 'grc',
    'फ़ीजी'                                                       => 'fj',
    'फ़ीलीपीनी'                                           => 'phi',
    'फाँग्'                                                       => 'fan',
    'फाँटी'                                                       => 'fat',
    'फार्सी'                                                    => 'fa',
    'फिनिश्'                                                    => 'fi',
    'फिरोज़ी'                                                 => 'fo',
    'फिलिपिनो'                                              => 'fil',
    'फीनीसी'                                                    => 'phn',
    'फीनोऊग्रीभाषा'                               => 'fiu',
    'फुलाह्'                                                    => 'ff',
    'फोन'                                                             => 'fon',
    'फ्रांसीसी'                                           => 'fr',
    'फ्रांसीसीकनाडाई'                         => 'fr_ca',
    'फ्रांसीसीस्वीस'                            => 'fr_ch',
    'फ्रीउलीअन्'                                        => 'fur',
    'फ्लेमी'                                                    => 'nl_be',
    'बंगला'                                                       => 'bn',
    'बंदा'                                                          => 'bad',
    'बड़ो'                                                          => 'brx',
    'बरबर्'                                                       => 'ber',
    'बर्मी'                                                       => 'my',
    'बलूची'                                                       => 'bal',
    'बल्गैरियन्'                                        => 'bg',
    'बल्टीकभाषा'                                        => 'bat',
    'बशख़िर्'                                                 => 'ba',
    'बाँटु'                                                       => 'bnt',
    'बांबारा'                                                 => 'bm',
    'बातक'                                                          => 'btk',
    'बामीलेके'                                              => 'bai',
    'बालिनी'                                                    => 'ban',
    'बास्क़्'                                                 => 'bas',
    'बास्क्'                                                    => 'eu',
    'बिकोल्'                                                    => 'bik',
    'बिनी'                                                          => 'bin',
    'बिस्लामा'                                              => 'bi',
    'बिहारी'                                                    => 'bh',
    'बुगीनी'                                                    => 'bug',
    'बुरियात'                                                 => 'bua',
    'बेंबा'                                                       => 'bem',
    'बेजा'                                                          => 'bej',
    'बैलोरूसियन्'                                     => 'be',
    'बोस्नियाई'                                           => 'bs',
    'ब्रज'                                                          => 'bra',
    'ब्रटों'                                                    => 'br',
    'ब्लीन'                                                       => 'byn',
    'ब्लीसचिन्ह'                                        => 'zbl',
    'भारतीयभाषाएँ'                                  => 'inc',
    'भुटानी'                                                    => 'dz',
    'भोजपुरी'                                                 => 'bho',
    'मंदार'                                                       => 'mdr',
    'मक्सर'                                                       => 'mak',
    'मघी'                                                             => 'mag',
    'मणीपुरी'                                                 => 'mni',
    'मध्यअंग्रेज़ी'                               => 'enm',
    'मध्यअमरिकीभाषा'                            => 'cai',
    'मध्यआईरीशभाषा'                               => 'mga',
    'मध्यउच्चस्तरीजर्मन'                => 'gmh',
    'मध्यडच'                                                    => 'dum',
    'मध्यफ्रांसीसी'                               => 'frm',
    'मराठी'                                                       => 'mr',
    'मलयालम'                                                    => 'ml',
    'मलाय'                                                          => 'ms',
    'मसाई'                                                          => 'mas',
    'मांचु'                                                       => 'mnc',
    'मांडींगो'                                              => 'man',
    'माओरी'                                                       => 'mi',
    'मादुरी'                                                    => 'mad',
    'मानोबो'                                                    => 'mno',
    'मायाभाषा'                                              => 'myn',
    'मारवाड़ी'                                              => 'mwr',
    'मारी'                                                          => 'chm',
    'मार्शली'                                                 => 'mh',
    'मालटीज़्'                                              => 'mt',
    'मालागासी'                                              => 'mg',
    'मिनंगकाबाउ'                                        => 'min',
    'मीकमाक'                                                    => 'mic',
    'मीरांडी'                                                 => 'mwl',
    'मुंडा'                                                       => 'mun',
    'मेंदे'                                                       => 'men',
    'मैंक्स'                                                    => 'gv',
    'मैथीली'                                                    => 'mai',
    'मैसेडोनियन्'                                     => 'mk',
    'मोंगो'                                                       => 'lol',
    'मोंगोलियन'                                           => 'mn',
    'मोक्षा'                                                    => 'mdf',
    'मोनख्मेर'                                              => 'mkh',
    'मोल्डेवियन्'                                     => 'mo',
    'मोस्सी'                                                    => 'mos',
    'मोहोक'                                                       => 'moh',
    'यकुट्'                                                       => 'sah',
    'यहुदीअरबी'                                           => 'jrb',
    'यहुदीफ़ारसी'                                     => 'jpr',
    'याओ'                                                             => 'yao',
    'यापीज़'                                                    => 'yap',
    'यीद्दीश'                                                 => 'yi',
    'युपीकभाषा'                                           => 'ypk',
    'यूक्रेनियन्'                                     => 'uk',
    'योरूबा'                                                    => 'yo',
    'राजस्थानी'                                           => 'raj',
    'रापानुई'                                                 => 'rap',
    'रारोटोंगा'                                           => 'rar',
    'रिक्त'                                                       => 'zxx',
    'रुमानी'                                                    => 'rom',
    'रुसी'                                                          => 'ru',
    'रूमानीयन्'                                           => 'ro',
    'रेह्टोरोमान्स'                               => 'rm',
    'रोमान्स्'                                              => 'roa',
    'लांबा'                                                       => 'lam',
    'लाओसीयन्'                                              => 'lo',
    'लाटवियन्लैट्टीश'                         => 'lv',
    'लाड़ीनो'                                                 => 'lad',
    'लाह्डां'                                                 => 'lah',
    'लिंगाला'                                                 => 'ln',
    'लिथुआनियन्'                                        => 'lt',
    'लींबुर्गी'                                           => 'li',
    'लुंडा'                                                       => 'lun',
    'लुईसेनो'                                                 => 'lui',
    'लुओ'                                                             => 'luo',
    'लुक्समबुर्गी'                                  => 'lb',
    'लुबाकटांगा'                                        => 'lu',
    'लुबालुलुआ'                                           => 'lua',
    'लुलेसामी'                                              => 'smj',
    'लुशाई'                                                       => 'lus',
    'लेज़गीयान'                                           => 'lez',
    'लैटिनअमरिकीस्पैनिश'                => 'es_419',
    'लैटीन्'                                                    => 'la',
    'लोजबान'                                                    => 'jbo',
    'लोज़ी'                                                       => 'loz',
    'वाई'                                                             => 'vai',
    'वाकाशान'                                                 => 'wak',
    'वारय'                                                          => 'war',
    'वालामो'                                                    => 'wal',
    'वालुन'                                                       => 'wa',
    'वाशो'                                                          => 'was',
    'वियेतनामी'                                           => 'vi',
    'वेंडा'                                                       => 've',
    'वैल्श्'                                                    => 'cy',
    'वोटीक'                                                       => 'vot',
    'वोलापोक'                                                 => 'vo',
    'वोलोफ'                                                       => 'wo',
    'शान'                                                             => 'shn',
    'शायान्'                                                    => 'chy',
    'शोना'                                                          => 'sn',
    'संडावे'                                                    => 'sad',
    'संताली'                                                    => 'sat',
    'संस्कृत्'                                              => 'sa',
    'समारीतीआरामाईक़'                         => 'sam',
    'सर्बियन्'                                              => 'sr',
    'सर्बोक्रोएशन्'                               => 'sh',
    'सलीशान'                                                    => 'sal',
    'सांग्रो'                                                 => 'sg',
    'सामी'                                                          => 'smi',
    'सामोअन'                                                    => 'sm',
    'सार्दीनी'                                              => 'sc',
    'सासक'                                                          => 'sas',
    'सिंधी'                                                       => 'sd',
    'सिरिआक'                                                    => 'syr',
    'सींहाला'                                                 => 'si',
    'सीऊआन'                                                       => 'sio',
    'सीकसीका'                                                 => 'bla',
    'सीचुआन्यी'                                           => 'ii',
    'सीदामो'                                                    => 'sid',
    'सीनोतिब्बतीभाषाएँ'                   => 'sit',
    'सीसीलीअन'                                              => 'scn',
    'सुकुमा'                                                    => 'suk',
    'सुन्दानी'                                              => 'su',
    'सुमेरिअन'                                              => 'sux',
    'सुसु'                                                          => 'sus',
    'सेरेर'                                                       => 'srr',
    'सेलकुप'                                                    => 'sel',
    'सैमीटीकभाषाएँ'                               => 'sem',
    'सोंगा'                                                       => 'ts',
    'सोंघाई'                                                    => 'son',
    'सोगडीयन'                                                 => 'sog',
    'सोनिंगके'                                              => 'snk',
    'सोमाली'                                                    => 'so',
    'सोर्बियन्'                                           => 'dsb',
    'सोर्बीयन'                                              => 'wen',
    'स्कॉट'                                                       => 'sco',
    'स्कॉट्स्गैलिक्'                            => 'gd',
    'स्कोल्ट्सामी'                                  => 'sms',
    'स्पैनिश'                                                 => 'es',
    'स्रनान्टॉंगो'                                  => 'srn',
    'स्लाव्'                                                    => 'sla',
    'स्लेव्'                                                    => 'den',
    'स्लोवाक्'                                              => 'sk',
    'स्लोवेनियन्'                                     => 'sl',
    'स्वाटि'                                                    => 'ss',
    'स्वाहिली'                                              => 'sw',
    'स्वीडिश'                                                 => 'sv',
    'स्वीसजर्मन'                                        => 'gsw',
    'हंगैरीयन्'                                           => 'hu',
    'हईडा'                                                          => 'hai',
    'हउसा'                                                          => 'ha',
    'हवाईअन'                                                    => 'haw',
    'हाईशीयन्'                                              => 'ht',
    'हिंदी'                                                       => 'hi',
    'हिब्रु'                                                    => 'he',
    'हिमांचली'                                              => 'him',
    'हीत्ती'                                                    => 'hit',
    'हीरीमोटु'                                              => 'ho',
    'हीलीगैनोन'                                           => 'hil',
    'हूपा'                                                          => 'hup',
    'हेरेरो'                                                    => 'hz',
    'ह्मौंग'                                                    => 'hmn',
);

1;
