/* progress16.h
 */
#ifndef PROGRESS_PROGRESS16_H
#define PROGRESS_PROGRESS16_H

#include <cassert>
namespace osl
{
  namespace progress
  {
    /**
     * 0-15 の進行度を表現
     */
    class Progress16
    {
      int progress16;
    public:
      explicit Progress16(int value=0) : progress16(value)
      {
	assert(isValid());
      }
      int value() const { return progress16; }
      bool isValid() const { 
	return (progress16 >= 0) && (progress16 < 16);
      }
    };
    inline bool operator==(Progress16 l, Progress16 r)
    {
      return l.value() == r.value();
    }
    inline bool operator!=(Progress16 l, Progress16 r)
    {
      return ! (l == r);
    }
    inline bool operator<(Progress16 l, Progress16 r)
    {
      return l.value() < r.value();
    }
  } // namespace progress
  using progress::Progress16;
} // namespace osl

#endif /* PROGRESS_PROGRESS16_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
