#!/usr/bin/python
# Copyright (C) 2005-2010 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

"""Demo Test

This is a basic test to verify that mago-ng is working as expected and can
be run with various testing framework

To run it with:
$ mago-ng <path_to_this_file>

You can code ldtp directly in there or an external module
The only mandatory element is 'launcher' (and window_name for now)

set setupOnce to False to launch/close the app for each test

The purpose of this example is to demo the use of a configuration file
"""

from mago import TestCase, magoConfig
import os

class TestConfiguration(TestCase):
    """Test Class"""

    launcher = 'gedit'
    window_name = 'frm*gedit'

    def test_showconfig(self):
        """Load the main and test configurations and display it in gedit"""

        localconf = ".".join(os.path.basename(__file__).split('.')[:-1])
        str1 = "The main configuration file for mago is '~/.magorc' and its content is:\n\
            %s\n" % magoConfig.items('mago')
        str2 = "The configuration file for the test is '%s.ini' and its content is:\n\
            %s\n" % (localconf, self.testConfig.items('hello'))
        str3 = "* The values read from the test configuration file are:"
        str4 = self.testConfig.get('hello', 'hello')
        str5 = self.testConfig.get('hello', 'goodbye')
        str6 = "\n* This value is not in the configuration file:"
        str7 = self.testConfig.get('hello', 'aurevoir', vars={'aurevoir':'Au Revoir'})

        str = '\n'.join((str1, str2, str3, str4, str5, str6, str7))
        self.application.context.settextvalue('txt1', str)
