//
//  Starter_Banks.cpp
//  
//
//  Created by Pierre Peterlongo on 25/10/2012
//
#include <iostream>
#include "Starter_Bank.h"
extern int size_seeds;



Starter_Bank::Starter_Bank(Fragment_Bank *fragment_bank){
  for (int i=0;i<fragment_bank->all_fragments.size();i++){
    starter_bank.push_back(new Starter(fragment_bank->all_fragments[i]));
  }
}

Starter_Bank::~Starter_Bank(){
  starter_bank.clear();
}


Extension_Bank * Starter_Bank::generate_all_substarters(const int min_coverage, const int substitutions_allowed, const int error_correction_threshold, const int size_kmers){
  Extension_Bank * extension_bank = new Extension_Bank();
  
  for(int i=0; i<starter_bank.size();i++){
    	starter_bank[i]->generate_substarters(extension_bank, substitutions_allowed, min_coverage, error_correction_threshold, size_kmers);
//    fprintf(stderr, "found %d result(s) for starter %s with min coverage %d and %d substitutions allowed\n", res, starter_bank[i]->fragment->fragment_sequence, min_coverage, substitutions_allowed);
  }
  return extension_bank;
}


Extension_Bank * Starter_Bank::generate_all_substarter_nomapping(const int size_kmers){
    Extension_Bank * extension_bank = new Extension_Bank();
    
    for(int i=0; i<starter_bank.size();i++){
        starter_bank[i]->generate_substarter_no_mapping(extension_bank, size_kmers);
    }
    return extension_bank;
}


void  Starter_Bank::format_results(const int extension_type, Extension_Bank * extension_bank, string prefix_name){
  bool is_graph;
  if(extension_type==3 || extension_type==4) is_graph=true;
  else is_graph = false;
    
  if(is_graph){
   id_els first_id_els = {};

    //    GraphOutput graph = GraphOutput(prefix_name,2); // 2 = XML format
    GraphOutput graph = GraphOutput(prefix_name,3); // 3 = Json format
    for(int i=0; i<starter_bank.size();i++){
      starter_bank[i]->starter_output_graph(extension_bank,graph, first_id_els);
      graph.print_starter_head(i, (starter_bank[i]->fragment)->fragment_sequence);
    }
    graph.close();
  }
  else{
      string starter_head;
      bool erase = true;
      for(int i=0; i<starter_bank.size();i++){
          starter_bank[i]->starter_output_sequence(extension_bank, i, prefix_name+string(".fasta"), erase);
	  erase = false;
    }
  }
}



