# NAME
report &mdash; Results of a test

# LIBRARY
MeasurementKit (libmeasurement_kit, -lmeasurement_kit).

# SYNOPSIS
```C++
#include <measurement_kit/report.hpp>
```

# DESCRIPTION

In OONI, a test consists of one or more test cases. Each test case produces as
result an entry. All such entries make a report.

The `report` module contains the following submodules:

- [base_reporter](report/base_reporter.md): base class for all reporters
- [entry](report/entry.md): contains the results of a single test case
- [error](report/error.md): errors generated by this module
- [report](report/report.md): represents a report
- [file reporter](report/file_reporter.md): reporter for writing on disk

# HISTORY

The `report` module appeared in MeasurementKit 0.2.0.
