/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File IconFactory.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef IconFactory_H
#define IconFactory_H

#include <string>
using std::string;

class IconObject;
class IconClass;
class IconInfo;
class Folder;
class Request;

class IconFactory {
public:

// -- Exceptions
	// None

// -- Contructors

	IconFactory(const string& name);

// -- Destructor

	virtual ~IconFactory(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual IconObject* make(Folder* parent,const IconClass& kind,
						const string& name,IconInfo* info) = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static IconObject* create(IconObject*,const Request&,const IconClass* = 0);
	static IconObject* create(Folder*,const Request&);
	static IconObject* create(const string& name);
	static IconObject* create(const string& name,const IconClass&);
	static IconObject* create(Folder* parent,const string& name);
	static IconObject* create(Folder* parent,const string& name,const IconClass&);
	static IconObject* create(Folder* parent,const string& name,const IconClass&,IconInfo*);

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	IconFactory(const IconFactory&);
	IconFactory& operator=(const IconFactory&);

// -- Members
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const IconFactory& p)
	//	{ p.print(s); return s; }

};

template<class T>
class IconMaker : public IconFactory {
	IconObject* make(Folder* parent,const IconClass& kind,
			const string& name,IconInfo* info) 
		{
			return new T(parent,kind,name,info);
		}
public:
	IconMaker(const string& name) : IconFactory(name) {}
};


#endif
