/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef IconLine_H
#include "IconLine.h"
#endif

#ifndef IconSelection_H
#include "IconSelection.h"
#endif

#ifndef XMLabel_H
#include "XMLabel.h"
#endif

#ifndef XMText_H
#include "XMText.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef LineFactory_H
#include "LineFactory.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef Folder_H
#include "Folder.h"
#endif

#ifndef Dropping_H
#include "Dropping.h"
#endif

#include <Xm/ToggleB.h>

#include <mars.h>

IconLine::IconLine(RequestPanel& owner,const Parameter& param):
	XRequestPanelLine<UIIconLine_c>(owner,param),
	unique_(false)
{
}

IconLine::~IconLine()
{
}

void IconLine::init(Widget w)
{
	XRequestPanelLine<UIIconLine_c>::init(w);
	IconHolder::install(drag_);
	Request interface = param_.interfaceRequest();
	classes_ = interface.get("class");

	string lab;
	string sep;

   for(vector<string>::iterator j =  classes_.begin(); j != classes_.end(); ++j)
	{
		lab = lab + sep + IconClass::find(*j).defaultName();
		sep = ", ";
	}

	XMLabel label(class_);
	label.set(lab);
}


void IconLine::reset()
{

	clear();
	const Request& r = owner_.request();

	vector<IconObjectH> sub = currentObject_->subObjects(param_.name(),r);

	for(vector<IconObjectH>::iterator j = sub.begin(); j != sub.end(); ++j)
		add(*j);

	grey();
}

bool IconLine::accept(IconObject* o)
{	
	const IconClass& ic = o->iconClass();
	for ( vector<string>::iterator j =  classes_.begin(); j != classes_.end(); ++j)
		if ( ic.canBecome(IconClass::find(*j)) )   return true;
	return classes_.size() == 0;	
}

void IconLine::update()
{
	grey();
}

void IconLine::apply()
{
	owner_.changed(*this);
}

void IconLine::set(Request& r)
{
	currentObject_->subObjects(param_.name(),icons_,r);
}

void IconLine::editCB(Widget,XtPointer data)
{
	for(vector<IconObjectH>::iterator j = current_.begin(); j != current_.end(); ++j)
		(*j)->edit();
	current_.clear();
}

void IconLine::removeCB(Widget,XtPointer data)
{
	clearCurrent();
}

void IconLine::drop(Dropping& drop)
{
	IconObjectH o = drop.object(*this);

	if(drop.copy())
	{
		add(o->clone(currentObject_->embeddedFolder(
			param_.beautifiedName())));
	}
	else
		add(o);
}

Widget IconLine::menu()
{	
	return current_.size() ? menu1_ : menu2_;
}

void IconLine::newIconCB(Widget,XtPointer)
{
	IconObject* o = IconSelection::make(
		currentObject_->embeddedFolder(param_.beautifiedName()),
		menu_x_,
		menu_y_);
	if(o) add(o);
}

void IconLine::openHiddenCB(Widget,XtPointer)
{
	currentObject_->embeddedFolder(param_.beautifiedName())->open();
}

static LineMaker<IconLine> maker("icon");
