/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef PageView_H
#include "PageView.h"
#endif

#include <Paper.h>

#include "IconClass.h"

PageView::PageView(IconObject* o):
	object_(o),
	pixmap_(o?o->iconClass().pixmap():string())
{
}

PageView::~PageView()
{
}

IconObject* PageView::view()
{
	return object_;
}

void PageView::draw(Widget w,PaperGraphics* g)
{
	if(!name_)
	{
		if(object_ == 0)
			name_ = XMString("Undefined");
		else
			name_ = XMString(object_->name(),"italic");
		width_  = XmStringWidth(g->font,name_);
	}

	int x = g->rect->x + (g->rect->width - 32)/2;
	int y = g->rect->y + (g->rect->height - 32)/2;

	if(pixmap_ != XmUNSPECIFIED_PIXMAP)
	XCopyArea(XtDisplay(w),pixmap_,g->drawable,g->gc,0,0,32,32,x,y);

	x = g->rect->x + (g->rect->width  - width_ ) /2;
	y = y + 32 ;

	XmStringDraw(XtDisplay(w),g->drawable,
	    g->font,
	    name_,
	    g->gc,
	    x,
	    y,
	   	width_, 
	    XmALIGNMENT_CENTER, XmSTRING_DIRECTION_L_TO_R, NULL);

	char buf[10];
	sprintf(buf,"%d",g->r->number);
	XMString s(buf,"tiny");

	XmStringDraw(XtDisplay(w),g->drawable,
		g->font,
		s,
		g->gc,
		g->rect->x + 2,
		g->rect->y + 2,
		XmStringWidth(g->font,s), 
		XmALIGNMENT_CENTER, XmSTRING_DIRECTION_L_TO_R, NULL);
}

void PageView::edit()
{
	if(object_) object_->edit();
}

