/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <math.h>
#include <Xm/TextF.h>
#ifndef PaperDrawer_H
#include "PaperDrawer.h"
#endif

#ifndef EditorDrawerFactory_H
#include "EditorDrawerFactory.h"
#endif

#ifndef ViewEditor_H
#include "ViewEditor.h"
#endif

#ifndef XMText_H
#include "XMText.h"
#endif


PaperDrawer::PaperDrawer(ViewEditor& e):
	XEditorDrawer<UIPaperDrawer_c>(e),
	editor_(e)
{
}

PaperDrawer::~PaperDrawer()
{
}

void PaperDrawer::edit(IconObject*)
{
  // Get the initial width and height values from editor
  double w,h;
  editor_.getPaperSize(w,h);
  setSize(w,h);
}

void PaperDrawer::setSize(double w,double h)
{
	XMText(height_).set(h);
	XMText(width_).set(w);
	editor_.setPaperSize(w,h);
}


void PaperDrawer::setCB(Widget, XtPointer)
{
	double h = 0, w = 0;
	XMText(height_).get(h);
	XMText(width_).get(w);
    editor_.setPaperSize(fabs(w),fabs(h));
}

void PaperDrawer::a4CB(Widget, XtPointer)
{
  setSize(21,29.7);
}

void PaperDrawer::a3CB(Widget, XtPointer)
{
  setSize(29.7,42); 
}

void PaperDrawer::rotateCB(Widget,XtPointer)
{
  double h,v;
  editor_.getPaperSize(h,v);
  setSize(v,h);
}

static EditorDrawerMaker<PaperDrawer,ViewEditor> maker(10);

